/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Korean 38pt, capital 'A' height: 28px, width: 100%, range: 0xac70-0xd788, glyphs: 110
extern const uint8_t NotoSans_Medium_Korean_28[14631] = {
  162,28,112,172,136,215,37,246, // unifont_t
  // 0xac70  거
  112,172,29,36,32,35,2,252,0,0,0,0,0,0,85,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,47,255,255,255,192,0,191,64,47,255,255,255,192,0,191,64,47,255,255,255,192,0,191,64,0,0,0,63,192,0,191,64,0,0,0,63,192,0,191,64,0,0,0,63,192,0,191,64,0,0,0,127,128,0,191,64,0,0,0,127,64,0,191,64,0,0,0,191,0,0,191,64,0,0,0,255,0,0,191,64,0,0,1,254,0,0,191,64,0,0,3,253,63,255,255,64,0,0,7,252,63,255,255,64,0,0,15,244,63,255,255,64,0,0,47,240,0,0,191,64,0,0,127,208,0,0,191,64,0,0,255,128,0,0,191,64,0,3,255,0,0,0,191,64,0,31,252,0,0,0,191,64,0,127,240,0,0,0,191,64,3,255,208,0,0,0,191,64,47,255,0,0,0,0,191,64,255,248,0,0,0,0,191,64,191,208,0,0,0,0,191,64,62,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,
  // 0xace0  고
  224,172,31,28,224,35,2,0,3,255,255,255,255,255,254,0,3,255,255,255,255,255,254,0,3,255,255,255,255,255,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,253,0,0,0,0,0,0,2,253,0,0,0,0,84,0,2,253,0,0,0,2,253,0,2,252,0,0,0,2,253,0,3,252,0,0,0,2,253,0,3,252,0,0,0,2,253,0,3,252,0,0,0,2,253,0,3,252,0,0,0,2,253,0,7,248,0,0,0,2,253,0,11,244,0,0,0,2,253,0,6,244,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0xadf8  그
  248,173,31,27,216,35,2,1,3,255,255,255,255,255,252,0,3,255,255,255,255,255,252,0,3,255,255,255,255,255,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,244,0,0,0,0,0,0,11,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,
  // 0xae09  급
  9,174,31,34,16,35,2,252,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,11,244,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,0,0,0,3,252,0,0,254,0,0,0,3,252,0,0,254,0,0,0,3,252,0,0,254,0,0,0,3,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,254,0,0,0,3,252,0,0,254,0,0,0,3,252,0,0,254,0,0,0,3,252,0,0,254,0,0,0,3,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,
  // 0xae30  기
  48,174,28,36,252,35,2,252,0,0,0,0,0,0,85,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,15,255,255,255,240,0,191,15,255,255,255,240,0,191,15,255,255,255,240,0,191,0,0,0,15,240,0,191,0,0,0,15,240,0,191,0,0,0,15,224,0,191,0,0,0,31,208,0,191,0,0,0,47,208,0,191,0,0,0,63,192,0,191,0,0,0,127,128,0,191,0,0,0,191,64,0,191,0,0,0,255,0,0,191,0,0,3,254,0,0,191,0,0,7,252,0,0,191,0,0,15,248,0,0,191,0,0,63,240,0,0,191,0,0,255,192,0,0,191,0,3,255,64,0,0,191,0,15,254,0,0,0,191,0,127,248,0,0,0,191,2,255,224,0,0,0,191,47,255,64,0,0,0,191,191,252,0,0,0,0,191,63,224,0,0,0,0,191,30,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,
  // 0xae45  깅
  69,174,29,36,32,35,2,252,0,0,0,0,0,0,85,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,15,255,255,255,240,0,255,0,15,255,255,255,224,0,255,0,15,255,255,255,224,0,255,0,0,0,0,47,224,0,255,0,0,0,0,47,192,0,255,0,0,0,0,63,192,0,255,0,0,0,0,127,128,0,255,0,0,0,0,255,0,0,255,0,0,0,1,254,0,0,255,0,0,0,7,252,0,0,255,0,0,0,31,244,0,0,255,0,0,0,127,224,0,0,255,0,0,2,255,128,0,0,255,0,0,47,254,0,0,0,255,0,2,255,244,0,0,0,255,0,127,255,192,0,0,0,255,0,127,253,0,0,0,0,255,0,63,208,0,0,0,0,255,0,24,0,0,0,0,0,106,0,0,0,2,191,255,228,0,0,0,0,127,255,255,255,128,0,0,2,255,255,255,255,244,0,0,11,255,144,0,127,252,0,0,31,244,0,0,3,254,0,0,47,208,0,0,0,255,0,0,63,192,0,0,0,191,64,0,63,192,0,0,0,191,0,0,47,208,0,0,0,255,0,0,31,248,0,0,7,254,0,0,11,255,148,5,191,252,0,0,2,255,255,255,255,240,0,0,0,127,255,255,255,64,0,0,0,1,191,255,164,0,0,
  // 0xb044  끄
  68,176,31,27,216,35,2,1,11,255,255,224,255,255,254,0,11,255,255,224,255,255,254,0,11,255,255,224,255,255,254,0,0,0,31,224,0,1,254,0,0,0,31,224,0,1,254,0,0,0,31,224,0,1,254,0,0,0,31,208,0,1,254,0,0,0,31,208,0,1,254,0,0,0,47,208,0,1,253,0,0,0,47,192,0,1,253,0,0,0,63,192,0,2,253,0,0,0,63,192,0,2,253,0,0,0,63,192,0,2,252,0,0,0,127,128,0,3,252,0,0,0,127,64,0,3,252,0,0,0,191,64,0,3,252,0,0,0,255,0,0,3,248,0,0,0,255,0,0,7,248,0,0,1,254,0,0,11,244,0,0,1,253,0,0,11,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,
  // 0xb0b4  내
  180,176,28,36,252,35,3,252,0,0,0,0,0,0,21,0,0,0,0,42,0,191,0,0,0,0,127,64,191,0,0,0,0,127,64,191,21,0,0,0,127,64,191,191,64,0,0,127,64,191,191,64,0,0,127,64,191,191,64,0,0,127,64,191,191,64,0,0,127,64,191,191,64,0,0,127,64,191,191,64,0,0,127,64,191,191,64,0,0,127,64,191,191,64,0,0,127,64,191,191,64,0,0,127,64,191,191,64,0,0,127,64,191,191,64,0,0,127,255,255,191,64,0,0,127,255,255,191,64,0,0,127,255,255,191,64,0,0,127,64,191,191,64,0,0,127,64,191,191,64,0,0,127,64,191,191,64,0,0,127,64,191,191,64,0,16,127,64,191,191,150,175,248,127,64,191,191,255,255,248,127,64,191,191,255,255,252,127,64,191,191,255,233,64,127,64,191,0,0,0,0,127,64,191,0,0,0,0,127,64,191,0,0,0,0,127,64,191,0,0,0,0,127,64,191,0,0,0,0,127,64,191,0,0,0,0,127,64,191,0,0,0,0,127,64,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,
  // 0xb178  노
  120,177,31,29,232,35,2,0,1,169,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,255,255,255,255,255,254,0,1,255,255,255,255,255,254,0,1,255,255,255,255,255,254,0,0,0,0,47,224,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0xb204  누
  4,178,31,34,16,35,2,252,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,255,255,255,255,255,254,0,0,255,255,255,255,255,254,0,0,255,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,
  // 0xb274  뉴
  116,178,31,34,16,35,2,252,0,170,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,255,255,255,255,255,253,0,0,255,255,255,255,255,253,0,0,255,255,255,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,2,254,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,
  // 0xb2c8  니
  200,178,27,36,252,35,4,252,0,0,0,0,0,1,80,0,0,0,0,0,11,244,0,0,0,0,0,11,244,0,0,0,0,0,11,244,254,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,1,172,11,244,255,86,171,255,253,11,244,255,255,255,255,254,11,244,255,255,255,255,249,11,244,255,255,234,80,0,11,244,0,0,0,0,0,11,244,0,0,0,0,0,11,244,0,0,0,0,0,11,244,0,0,0,0,0,11,244,0,0,0,0,0,11,244,0,0,0,0,0,11,244,0,0,0,0,0,11,244,0,0,0,0,0,11,244,0,0,0,0,0,11,240,
  // 0xb2e4  다
  228,178,31,36,32,35,3,252,0,0,0,0,0,5,64,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,191,255,255,255,0,31,208,0,191,255,255,255,0,31,208,0,191,255,255,255,0,31,208,0,191,64,0,0,0,31,208,0,191,0,0,0,0,31,208,0,191,0,0,0,0,31,208,0,191,0,0,0,0,31,208,0,191,0,0,0,0,31,208,0,191,0,0,0,0,31,208,0,191,0,0,0,0,31,208,0,191,0,0,0,0,31,255,252,191,0,0,0,0,31,255,252,191,0,0,0,0,31,255,252,191,0,0,0,0,31,224,0,191,0,0,0,0,31,208,0,191,0,0,0,0,31,208,0,191,0,0,0,0,31,208,0,191,0,0,0,0,31,208,0,191,0,0,0,0,31,208,0,191,0,1,91,252,31,208,0,191,255,255,255,252,31,208,0,191,255,255,255,252,31,208,0,191,255,255,250,80,31,208,0,21,80,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,
  // 0xb2f9  당
  249,178,31,36,32,35,3,252,0,0,0,0,0,5,80,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,191,255,255,254,0,15,240,0,191,255,255,254,0,15,240,0,191,255,255,254,0,15,240,0,191,64,0,0,0,15,240,0,191,0,0,0,0,15,240,0,191,0,0,0,0,15,240,0,191,0,0,0,0,15,240,0,191,0,0,0,0,15,255,248,191,0,0,0,0,15,255,248,191,0,0,0,0,15,255,248,191,0,0,0,0,15,240,0,191,0,0,0,0,15,240,0,191,64,21,107,248,15,240,0,191,255,255,255,252,15,240,0,191,255,255,255,252,15,240,0,191,255,255,169,64,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,5,64,0,0,0,27,255,249,0,0,0,0,6,255,255,255,244,0,0,0,47,255,255,255,255,0,0,0,191,249,64,91,255,192,0,0,255,128,0,0,127,208,0,2,254,0,0,0,31,240,0,2,252,0,0,0,15,240,0,2,252,0,0,0,15,240,0,2,254,0,0,0,31,240,0,0,255,128,0,0,127,208,0,0,191,249,81,91,255,192,0,0,47,255,255,255,255,0,0,0,2,255,255,255,244,0,0,0,0,27,255,249,0,0,0,
  // 0xb3c4  도
  196,179,31,29,232,35,2,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,255,255,255,255,255,254,0,1,255,255,255,255,255,254,0,1,255,255,255,255,255,254,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0xb3cc  돌
  204,179,31,34,16,35,2,252,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,255,255,255,255,253,0,0,255,255,255,255,255,253,0,0,255,255,255,255,255,253,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,255,255,255,255,255,255,0,1,255,255,255,255,255,255,0,1,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,
  // 0xb3d9  동
  217,179,31,34,16,35,2,252,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,255,255,255,255,255,253,0,0,255,255,255,255,255,253,0,0,255,255,255,255,255,253,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,47,224,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,255,254,144,0,0,0,2,255,255,255,254,0,0,0,31,255,255,255,255,208,0,0,127,249,0,1,191,240,0,0,255,128,0,0,15,248,0,1,255,0,0,0,3,252,0,1,254,0,0,0,3,252,0,1,255,0,0,0,3,252,0,0,255,128,0,0,15,248,0,0,127,249,0,1,191,240,0,0,31,255,255,255,255,208,0,0,2,255,255,255,254,0,0,0,0,26,255,254,144,0,0,
  // 0xb418  되
  24,180,28,36,252,35,2,252,0,0,0,0,0,0,85,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,11,255,255,255,255,0,255,11,255,255,255,255,0,255,11,255,255,255,255,0,255,11,244,0,0,0,0,255,11,244,0,0,0,0,255,11,244,0,0,0,0,255,11,244,0,0,0,0,255,11,244,0,0,0,0,255,11,244,0,0,0,0,255,11,244,0,0,0,0,255,11,244,0,0,0,0,255,11,244,0,0,0,0,255,11,255,255,255,255,0,255,11,255,255,255,255,0,255,11,255,255,255,255,0,255,0,0,47,192,0,0,255,0,0,47,192,0,0,255,0,0,47,192,0,0,255,0,0,47,192,0,0,255,0,0,47,192,0,0,255,0,0,47,213,106,176,255,255,255,255,255,255,244,255,191,255,255,255,255,244,255,191,255,255,255,165,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,191,
  // 0xb41c  된
  28,180,30,36,32,35,2,252,0,0,0,0,0,0,85,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,3,255,255,255,253,0,191,0,3,255,255,255,253,0,191,0,3,255,255,255,253,0,191,0,3,252,0,0,0,0,191,0,3,252,0,0,0,0,191,0,3,252,0,0,0,0,191,0,3,252,0,0,0,0,191,0,3,252,0,0,0,0,191,0,3,252,0,0,0,0,191,0,3,255,255,255,254,0,191,0,3,255,255,255,254,0,191,0,3,255,255,255,254,0,191,0,0,0,47,208,0,0,191,0,0,0,47,208,0,0,191,0,0,0,47,208,0,0,191,0,0,0,47,208,0,0,191,0,0,1,127,234,191,240,191,0,255,255,255,255,255,240,191,0,191,255,255,255,255,240,191,0,191,255,255,169,80,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,10,144,0,0,0,191,0,0,31,208,0,0,0,191,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,255,255,255,255,255,208,0,31,255,255,255,255,255,208,0,31,255,255,255,255,255,208,0,0,0,0,0,0,0,0,
  // 0xb428  됨
  40,180,29,35,24,35,2,252,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,3,255,255,255,254,0,191,64,3,255,255,255,254,0,191,64,3,255,255,255,254,0,191,64,3,252,0,0,0,0,191,64,3,252,0,0,0,0,191,64,3,252,0,0,0,0,191,64,3,252,0,0,0,0,191,64,3,252,0,0,0,0,191,64,3,255,255,255,255,0,191,64,3,255,255,255,255,0,191,64,3,255,255,255,255,0,191,64,0,0,47,208,0,0,191,64,0,0,47,208,0,0,191,64,0,0,47,208,0,0,191,64,0,0,47,234,191,240,191,64,255,255,255,255,255,240,191,64,191,255,255,255,255,224,191,64,127,255,254,169,64,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,255,255,255,255,64,0,31,255,255,255,255,255,64,0,31,255,255,255,255,255,64,0,31,208,0,0,0,191,64,0,31,208,0,0,0,191,64,0,31,208,0,0,0,191,64,0,31,208,0,0,0,191,64,0,31,208,0,0,0,191,64,0,31,255,255,255,255,255,64,0,31,255,255,255,255,255,64,0,31,255,255,255,255,255,64,0,0,0,0,0,0,0,0,
  // 0xb4a4  뒤
  164,180,29,35,24,35,2,252,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,3,255,255,255,253,0,191,64,3,255,255,255,253,0,191,64,3,255,255,255,253,0,191,64,3,252,0,0,0,0,191,64,3,252,0,0,0,0,191,64,3,252,0,0,0,0,191,64,3,252,0,0,0,0,191,64,3,252,0,0,0,0,191,64,3,252,0,0,0,0,191,64,3,255,255,255,255,0,191,64,3,255,255,255,255,0,191,64,3,255,255,255,255,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,21,107,244,191,64,255,255,255,255,255,244,191,64,255,255,255,255,255,244,191,64,255,255,255,254,165,0,191,64,0,0,63,192,0,0,191,64,0,0,63,192,0,0,191,64,0,0,63,192,0,0,191,64,0,0,63,192,0,0,191,64,0,0,63,192,0,0,191,64,0,0,63,192,0,0,191,64,0,0,63,192,0,0,191,64,0,0,63,192,0,0,191,64,0,0,63,192,0,0,191,64,0,0,63,192,0,0,191,64,0,0,63,192,0,0,191,64,0,0,42,128,0,0,191,64,0,0,0,0,0,0,191,64,
  // 0xb4dc  드
  220,180,31,28,224,35,2,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,255,255,255,255,255,254,0,1,255,255,255,255,255,254,0,1,255,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0xb514  디
  20,181,26,36,252,35,4,252,0,0,0,0,0,5,80,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,255,255,255,255,64,15,240,255,255,255,255,64,15,240,255,255,255,255,64,15,240,255,0,0,0,0,15,240,255,0,0,0,0,15,240,255,0,0,0,0,15,240,255,0,0,0,0,15,240,255,0,0,0,0,15,240,255,0,0,0,0,15,240,255,0,0,0,0,15,240,255,0,0,0,0,15,240,255,0,0,0,0,15,240,255,0,0,0,0,15,240,255,0,0,0,0,15,240,255,0,0,0,0,15,240,255,0,0,0,0,15,240,255,0,0,0,0,15,240,255,0,0,0,0,15,240,255,0,0,0,0,15,240,255,0,0,90,252,15,240,255,255,255,255,252,15,240,255,255,255,255,253,15,240,255,255,255,254,148,15,240,85,84,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,11,240,
  // 0xb77c  라
  124,183,31,36,32,35,3,252,0,0,0,0,0,5,64,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,255,255,255,255,0,31,224,0,255,255,255,255,0,31,224,0,255,255,255,255,0,31,224,0,0,0,0,255,0,31,224,0,0,0,0,255,0,31,224,0,0,0,0,255,0,31,224,0,0,0,0,255,0,31,224,0,0,0,0,255,0,31,224,0,0,0,0,255,0,31,224,0,0,0,0,255,0,31,224,0,191,255,255,255,0,31,255,252,191,255,255,255,0,31,255,252,191,255,255,255,0,31,255,252,191,0,0,0,0,31,229,80,191,0,0,0,0,31,224,0,191,0,0,0,0,31,224,0,191,0,0,0,0,31,224,0,191,0,0,0,0,31,224,0,191,0,0,0,0,31,224,0,191,0,0,90,252,31,224,0,191,255,255,255,252,31,224,0,191,255,255,255,253,31,224,0,191,255,255,250,80,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,208,0,
  // 0xb7ec  러
  236,183,28,36,252,35,3,252,0,0,0,0,0,0,84,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,255,255,255,253,0,2,253,255,255,255,253,0,2,253,255,255,255,253,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,2,253,255,255,255,253,0,2,253,255,255,255,253,47,255,253,255,255,255,253,47,255,253,255,0,0,0,47,255,253,255,0,0,0,0,2,253,255,0,0,0,0,2,253,255,0,0,0,0,2,253,255,0,0,0,0,2,253,255,0,0,0,0,2,253,255,0,0,0,0,2,253,255,0,1,106,240,2,253,255,255,255,255,240,2,253,255,255,255,255,244,2,253,255,255,255,234,80,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,1,253,
  // 0xb808  레
  8,184,28,36,252,35,3,252,0,0,0,0,0,0,85,0,0,0,0,31,192,191,0,0,0,0,31,192,191,0,0,0,0,31,192,191,255,255,255,0,31,192,191,255,255,255,0,31,192,191,255,255,255,0,31,192,191,0,0,191,0,31,192,191,0,0,191,0,31,192,191,0,0,191,0,31,192,191,0,0,191,0,31,192,191,0,0,191,0,31,192,191,0,0,191,0,31,192,191,0,0,191,31,255,192,191,255,255,255,31,255,192,191,255,255,255,31,255,192,191,255,255,255,0,47,192,191,254,0,0,0,31,192,191,254,0,0,0,31,192,191,254,0,0,0,31,192,191,254,0,0,0,31,192,191,254,0,0,0,31,192,191,254,0,0,0,31,192,191,255,0,22,184,31,192,191,255,255,255,252,31,192,191,255,255,255,252,31,192,191,255,255,254,164,31,192,191,0,0,0,0,31,192,191,0,0,0,0,31,192,191,0,0,0,0,31,192,191,0,0,0,0,31,192,191,0,0,0,0,31,192,191,0,0,0,0,31,192,191,0,0,0,0,31,192,191,0,0,0,0,0,0,191,0,0,0,0,0,0,127,
  // 0xb825  력
  37,184,28,36,252,35,3,252,0,0,0,0,0,0,84,0,0,0,0,0,2,253,0,0,0,0,0,2,253,255,255,255,252,0,2,253,255,255,255,252,0,2,253,255,255,255,252,0,2,253,0,0,3,252,47,255,253,0,0,3,252,47,255,253,0,0,3,252,47,255,253,0,0,3,252,0,2,253,191,255,255,252,0,2,253,191,255,255,252,0,2,253,191,255,255,252,0,2,253,191,0,0,0,47,255,253,191,0,0,0,47,255,253,191,0,0,0,47,255,253,191,0,0,0,0,2,253,191,64,21,175,192,2,253,191,255,255,255,192,2,253,191,255,255,255,192,2,253,191,255,255,165,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,0,84,0,0,0,0,0,0,0,0,255,255,255,255,255,253,0,255,255,255,255,255,253,0,255,255,255,255,255,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,
  // 0xb85c  로
  92,184,31,29,232,35,2,0,1,255,255,255,255,255,253,0,1,255,255,255,255,255,253,0,1,255,255,255,255,255,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,1,255,255,255,255,255,253,0,1,255,255,255,255,255,253,0,1,255,255,255,255,255,253,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,255,255,255,255,255,255,0,1,255,255,255,255,255,255,0,1,255,255,255,255,255,255,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,224,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,
  // 0xb8cc  료
  204,184,31,29,232,35,2,0,1,255,255,255,255,255,253,0,1,255,255,255,255,255,253,0,1,255,255,255,255,255,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,1,255,255,255,255,255,253,0,1,255,255,255,255,255,253,0,1,255,255,255,255,255,253,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,255,255,255,255,255,255,0,1,255,255,255,255,255,255,0,1,255,255,255,255,255,255,0,0,0,255,64,3,252,0,0,0,0,191,0,3,252,0,0,0,0,191,0,3,252,0,0,0,0,191,0,3,252,0,0,0,0,191,0,3,252,0,0,0,0,191,0,3,252,0,0,0,0,255,64,3,252,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,
  // 0xb974  르
  116,185,31,29,232,35,2,0,1,255,255,255,255,255,253,0,1,255,255,255,255,255,253,0,1,255,255,255,255,255,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,1,255,255,255,255,255,253,0,1,255,255,255,255,255,253,0,1,255,255,255,255,255,253,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,255,255,255,255,255,255,0,1,255,255,255,255,255,255,0,1,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0xb9ac  리
  172,185,26,36,252,35,4,252,0,0,0,0,0,5,80,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,255,255,255,255,0,11,240,255,255,255,255,0,11,240,255,255,255,255,0,11,240,0,0,0,255,0,11,240,0,0,0,255,0,11,240,0,0,0,255,0,11,240,0,0,0,255,0,11,240,0,0,0,255,0,11,240,0,0,0,255,0,11,240,0,0,1,255,0,11,240,255,255,255,255,0,11,240,255,255,255,255,0,11,240,255,255,255,255,0,11,240,255,0,0,0,0,11,240,255,0,0,0,0,11,240,255,0,0,0,0,11,240,255,0,0,0,0,11,240,255,0,0,0,0,11,240,255,0,0,0,0,11,240,255,0,1,90,254,11,240,255,255,255,255,254,11,240,255,255,255,255,255,11,240,255,255,255,250,144,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,
  // 0xb9b0  린
  176,185,28,36,252,35,3,252,0,0,0,0,0,1,84,0,0,0,0,0,2,252,0,0,0,0,0,2,252,127,255,255,255,64,2,252,127,255,255,255,64,2,252,127,255,255,255,64,2,252,0,0,0,191,64,2,252,0,0,0,191,64,2,252,0,0,0,191,64,2,252,0,0,0,191,64,2,252,0,0,0,191,64,2,252,127,255,255,255,64,2,252,127,255,255,255,64,2,252,127,255,255,255,64,2,252,127,128,0,0,0,2,252,127,128,0,0,0,2,252,127,128,0,0,0,2,252,127,128,0,0,0,2,252,127,128,21,107,255,2,252,127,255,255,255,255,2,252,127,255,255,255,255,2,252,127,255,255,233,64,2,252,0,0,0,0,0,2,252,0,0,0,0,0,2,252,0,21,0,0,0,2,252,0,127,64,0,0,2,252,0,127,64,0,0,2,168,0,127,64,0,0,0,0,0,127,64,0,0,0,0,0,127,64,0,0,0,0,0,127,64,0,0,0,0,0,127,64,0,0,0,0,0,127,255,255,255,255,255,0,127,255,255,255,255,255,0,127,255,255,255,255,255,0,0,0,0,0,0,0,
  // 0xb9bd  립
  189,185,27,36,252,35,3,252,0,0,0,0,0,1,168,0,0,0,0,0,2,252,127,255,255,255,64,2,252,127,255,255,255,64,2,252,127,255,255,255,64,2,252,0,0,0,191,64,2,252,0,0,0,191,64,2,252,0,0,0,191,64,2,252,0,0,0,191,64,2,252,127,255,255,255,64,2,252,127,255,255,255,64,2,252,127,255,255,255,64,2,252,127,128,0,0,0,2,252,127,128,0,0,0,2,252,127,128,0,0,0,2,252,127,128,0,22,191,2,252,127,255,255,255,255,2,252,127,255,255,255,255,2,252,127,255,255,254,148,2,252,0,0,0,0,0,2,252,0,0,0,0,0,0,0,0,42,64,0,0,1,168,0,127,128,0,0,2,252,0,127,128,0,0,2,252,0,127,128,0,0,2,252,0,127,255,255,255,255,252,0,127,255,255,255,255,252,0,127,255,255,255,255,252,0,127,128,0,0,2,252,0,127,128,0,0,2,252,0,127,128,0,0,2,252,0,127,128,0,0,2,252,0,127,255,255,255,255,252,0,127,255,255,255,255,252,0,127,255,255,255,255,252,0,0,0,0,0,0,0,
  // 0xb9c1  링
  193,185,28,36,252,35,3,252,0,0,0,0,0,0,84,0,0,0,0,0,2,252,0,0,0,0,0,2,252,127,255,255,255,64,2,252,127,255,255,255,64,2,252,127,255,255,255,64,2,252,0,0,0,191,64,2,252,0,0,0,191,64,2,252,0,0,0,191,64,2,252,0,0,0,191,64,2,252,127,255,255,255,64,2,252,127,255,255,255,64,2,252,127,255,255,255,64,2,252,127,128,0,0,0,2,252,127,128,0,0,0,2,252,127,128,0,0,0,2,252,127,128,0,22,191,2,252,127,255,255,255,255,2,252,127,255,255,255,255,2,252,127,255,255,254,148,2,252,0,0,0,0,0,2,252,0,0,0,0,0,2,252,0,0,0,0,0,0,0,0,0,10,255,255,144,0,0,1,255,255,255,254,0,0,15,255,255,255,255,224,0,63,254,64,1,191,244,0,127,208,0,0,11,252,0,191,64,0,0,2,253,0,191,0,0,0,2,253,0,191,64,0,0,3,253,0,127,208,0,0,11,252,0,63,254,80,5,191,244,0,11,255,255,255,255,208,0,1,255,255,255,254,0,0,0,6,255,254,144,0,
  // 0xba48  멈
  72,186,28,36,252,35,3,252,0,0,0,0,0,0,84,0,0,0,0,0,2,253,0,0,0,0,0,2,253,191,255,255,255,64,2,253,191,255,255,255,64,2,253,191,255,255,255,64,2,253,191,64,0,191,64,2,253,191,0,0,127,64,2,253,191,0,0,127,64,2,253,191,0,0,127,255,255,253,191,0,0,127,255,255,253,191,0,0,127,255,255,253,191,0,0,127,64,2,253,191,0,0,127,64,2,253,191,0,0,127,64,2,253,191,64,0,191,64,2,253,191,255,255,255,64,2,253,191,255,255,255,64,2,253,191,255,255,255,64,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,253,0,63,255,255,255,255,253,0,63,255,255,255,255,253,0,63,128,0,0,1,253,0,63,128,0,0,1,253,0,63,128,0,0,1,253,0,63,128,0,0,1,253,0,63,128,0,0,1,253,0,63,128,0,0,1,253,0,63,255,255,255,255,253,0,63,255,255,255,255,253,0,63,255,255,255,255,253,0,0,0,0,0,0,0,
  // 0xba54  메
  84,186,28,35,245,35,3,252,0,0,0,0,10,128,127,0,0,0,0,31,208,127,0,0,0,0,31,208,127,0,0,0,0,31,208,127,255,255,255,208,31,208,127,255,255,255,208,31,208,127,255,255,255,208,31,208,127,254,0,31,208,31,208,127,254,0,31,208,31,208,127,254,0,31,208,31,208,127,254,0,31,208,31,208,127,254,0,31,208,31,208,127,254,0,31,208,31,208,127,254,0,31,255,255,208,127,254,0,31,255,255,208,127,254,0,31,255,255,208,127,254,0,31,208,31,208,127,254,0,31,208,31,208,127,254,0,31,208,31,208,127,254,0,31,208,31,208,127,254,0,31,208,31,208,127,254,0,31,208,31,208,127,254,0,31,208,31,208,127,255,255,255,208,31,208,127,255,255,255,208,31,208,127,255,255,255,208,31,208,127,0,0,0,0,31,208,127,0,0,0,0,31,208,127,0,0,0,0,31,208,127,0,0,0,0,31,208,127,0,0,0,0,31,208,127,0,0,0,0,31,208,127,0,0,0,0,31,208,127,0,0,0,0,5,64,127,0,0,0,0,0,0,127,
  // 0xba74  면
  116,186,28,36,252,35,3,252,0,0,0,0,0,0,84,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,191,255,255,255,64,2,253,191,255,255,255,64,2,253,191,255,255,255,64,2,253,191,0,0,127,255,255,253,191,0,0,127,255,255,253,191,0,0,127,255,255,253,191,0,0,127,64,2,253,191,0,0,127,64,2,253,191,0,0,127,64,2,253,191,0,0,127,64,2,253,191,0,0,127,255,255,253,191,0,0,127,255,255,253,191,0,0,127,255,255,253,191,255,255,255,64,2,253,191,255,255,255,64,2,253,191,255,255,255,64,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,63,192,0,0,2,253,0,63,192,0,0,2,253,0,63,192,0,0,0,84,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,255,255,255,255,255,0,63,255,255,255,255,255,0,63,255,255,255,255,255,0,0,0,0,0,0,0,
  // 0xbaa8  모
  168,186,31,28,224,35,2,0,2,255,255,255,255,255,253,0,2,255,255,255,255,255,253,0,2,255,255,255,255,255,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,255,255,255,255,255,253,0,2,255,255,255,255,255,253,0,2,255,255,255,255,255,253,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0xbabb  못
  187,186,31,34,16,35,2,252,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,254,0,0,0,3,252,0,0,254,0,0,0,3,252,0,0,254,0,0,0,3,252,0,0,254,0,0,0,3,252,0,0,254,0,0,0,3,252,0,0,254,0,0,0,3,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,63,224,0,0,0,0,0,0,63,240,0,0,0,0,0,0,255,248,0,0,0,0,0,2,255,253,0,0,0,0,0,11,252,255,128,0,0,0,0,127,240,127,244,0,0,0,27,255,208,31,255,64,0,7,255,254,0,3,255,254,64,7,255,244,0,0,127,255,64,3,254,64,0,0,7,255,0,1,64,0,0,0,0,4,0,
  // 0xbbf8  미
  248,187,26,36,252,35,4,252,0,0,0,0,0,5,80,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,255,255,255,255,0,15,240,255,255,255,255,0,15,240,255,255,255,255,0,15,240,254,0,0,255,0,15,240,254,0,0,255,0,15,240,254,0,0,255,0,15,240,254,0,0,255,0,15,240,254,0,0,255,0,15,240,254,0,0,255,0,15,240,254,0,0,255,0,15,240,254,0,0,255,0,15,240,254,0,0,255,0,15,240,254,0,0,255,0,15,240,254,0,0,255,0,15,240,254,0,0,255,0,15,240,254,0,0,255,0,15,240,254,0,0,255,0,15,240,254,0,0,255,0,15,240,254,0,0,255,0,15,240,254,0,0,255,0,15,240,255,255,255,255,0,15,240,255,255,255,255,0,15,240,255,255,255,255,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,11,240,
  // 0xbc00  밀
  0,188,28,35,245,35,3,252,0,0,0,0,0,2,252,0,0,0,0,0,2,252,127,255,255,255,192,2,252,127,255,255,255,192,2,252,127,255,255,255,192,2,252,127,128,0,63,192,2,252,127,128,0,63,192,2,252,127,128,0,63,192,2,252,127,128,0,63,192,2,252,127,128,0,63,192,2,252,127,128,0,63,192,2,252,127,128,0,63,192,2,252,127,128,0,63,192,2,252,127,255,255,255,192,2,252,127,255,255,255,192,2,252,127,255,255,255,192,2,252,0,0,0,0,0,2,252,0,0,0,0,0,1,84,0,0,0,0,0,0,0,0,127,255,255,255,255,252,0,127,255,255,255,255,252,0,127,255,255,255,255,252,0,0,0,0,0,2,252,0,0,0,0,0,2,252,0,0,0,0,0,2,252,0,63,255,255,255,255,252,0,63,255,255,255,255,252,0,63,255,255,255,255,252,0,63,128,0,0,0,0,0,63,128,0,0,0,0,0,63,128,0,0,0,0,0,63,255,255,255,255,255,0,63,255,255,255,255,255,0,63,255,255,255,255,255,0,0,0,0,0,0,0,
  // 0xbc14  바
  20,188,31,36,32,35,3,252,0,0,0,0,0,5,64,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,85,0,0,21,0,31,208,0,255,0,0,127,64,31,208,0,255,0,0,127,64,31,208,0,255,0,0,127,64,31,208,0,255,0,0,127,64,31,208,0,255,0,0,127,64,31,208,0,255,0,0,127,64,31,208,0,255,0,0,127,64,31,208,0,255,0,0,127,64,31,208,0,255,0,0,191,64,31,208,0,255,255,255,255,64,31,208,0,255,255,255,255,64,31,255,252,255,255,255,255,64,31,255,252,255,0,0,127,64,31,255,252,255,0,0,127,64,31,229,80,255,0,0,127,64,31,208,0,255,0,0,127,64,31,208,0,255,0,0,127,64,31,208,0,255,0,0,127,64,31,208,0,255,0,0,127,64,31,208,0,255,0,0,127,64,31,208,0,255,255,255,255,64,31,208,0,255,255,255,255,64,31,208,0,255,255,255,255,64,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,
  // 0xbc84  버
  132,188,28,36,252,35,3,252,0,0,0,0,0,1,84,0,0,0,0,0,2,253,0,0,0,0,0,2,253,170,0,0,106,0,2,253,255,0,0,191,64,2,253,255,0,0,191,64,2,253,255,0,0,191,64,2,253,255,0,0,191,64,2,253,255,0,0,191,64,2,253,255,0,0,191,64,2,253,255,0,0,191,64,2,253,255,0,0,191,64,2,253,255,255,255,255,64,2,253,255,255,255,255,255,255,253,255,255,255,255,255,255,253,255,0,0,191,255,255,253,255,0,0,191,64,2,253,255,0,0,191,64,2,253,255,0,0,191,64,2,253,255,0,0,191,64,2,253,255,0,0,191,64,2,253,255,0,0,191,64,2,253,255,0,0,191,64,2,253,255,0,0,191,64,2,253,255,255,255,255,64,2,253,255,255,255,255,64,2,253,255,255,255,255,64,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,1,253,
  // 0xbca0  베
  160,188,28,36,252,35,3,252,0,0,0,0,0,0,21,0,0,0,0,26,128,127,0,0,0,0,31,208,127,0,0,0,0,31,208,127,254,0,15,208,31,208,127,254,0,15,208,31,208,127,254,0,15,208,31,208,127,254,0,15,208,31,208,127,254,0,15,208,31,208,127,254,0,15,208,31,208,127,254,0,15,208,31,208,127,254,0,15,208,31,208,127,255,255,255,208,31,208,127,255,255,255,224,47,208,127,255,255,255,255,255,208,127,255,0,31,255,255,208,127,254,0,15,255,255,208,127,254,0,15,208,31,208,127,254,0,15,208,31,208,127,254,0,15,208,31,208,127,254,0,15,208,31,208,127,254,0,15,208,31,208,127,254,0,15,208,31,208,127,254,0,15,208,31,208,127,255,255,255,208,31,208,127,255,255,255,208,31,208,127,255,255,255,208,31,208,127,0,0,0,0,31,208,127,0,0,0,0,31,208,127,0,0,0,0,31,208,127,0,0,0,0,31,208,127,0,0,0,0,31,208,127,0,0,0,0,31,208,127,0,0,0,0,31,208,127,0,0,0,0,0,0,127,0,0,0,0,0,0,127,
  // 0xbca8  벨
  168,188,29,36,32,35,3,252,0,0,0,0,0,0,85,0,0,0,0,0,31,192,255,0,21,0,6,144,47,192,255,0,191,0,15,224,47,192,255,0,191,0,15,224,47,192,255,0,191,0,15,224,47,192,255,0,191,0,15,224,47,192,255,0,191,255,255,224,47,192,255,0,191,255,255,255,255,192,255,0,191,255,255,255,255,192,255,0,191,0,15,255,255,192,255,0,191,0,15,224,47,192,255,0,191,0,15,224,47,192,255,0,191,0,15,224,47,192,255,0,191,0,15,224,47,192,255,0,191,255,255,224,47,192,255,0,191,255,255,224,47,192,255,0,191,255,255,224,47,192,255,0,0,0,0,0,47,192,255,0,0,0,0,0,0,0,85,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,0,0,63,255,255,255,255,255,0,0,63,255,255,255,255,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,63,255,255,255,255,255,0,0,63,255,255,255,255,255,0,0,63,255,255,255,255,255,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,255,255,255,255,255,192,0,63,255,255,255,255,255,192,0,63,255,255,255,255,255,192,0,0,0,0,0,0,0,0,
  // 0xbcf8  본
  248,188,31,34,16,35,2,252,0,254,0,0,0,3,252,0,0,255,0,0,0,3,252,0,0,255,0,0,0,3,252,0,0,255,0,0,0,3,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,255,0,0,0,3,252,0,0,255,0,0,0,3,252,0,0,255,0,0,0,3,252,0,0,255,0,0,0,3,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,255,255,255,255,255,253,0,0,255,255,255,255,255,253,0,0,255,255,255,255,255,253,0,0,0,0,0,0,0,0,0,
  // 0xbe44  비
  68,190,26,36,252,35,4,252,0,0,0,0,0,5,80,0,0,0,0,0,15,240,0,0,0,0,0,15,240,84,0,0,21,0,15,240,254,0,0,191,0,15,240,254,0,0,191,0,15,240,254,0,0,191,0,15,240,254,0,0,191,0,15,240,254,0,0,191,0,15,240,254,0,0,191,0,15,240,254,0,0,191,0,15,240,254,0,0,191,0,15,240,254,0,0,191,0,15,240,255,255,255,255,0,15,240,255,255,255,255,0,15,240,255,255,255,255,0,15,240,254,0,0,191,0,15,240,254,0,0,191,0,15,240,254,0,0,191,0,15,240,254,0,0,191,0,15,240,254,0,0,191,0,15,240,254,0,0,191,0,15,240,254,0,0,191,0,15,240,254,0,0,191,0,15,240,255,255,255,255,0,15,240,255,255,255,255,0,15,240,255,255,255,255,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,11,240,
  // 0xc0ac  사
  172,192,33,36,68,35,1,252,0,0,0,0,0,0,84,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,21,64,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,127,192,0,1,253,0,0,0,0,127,208,0,1,253,0,0,0,0,191,224,0,1,254,0,0,0,0,255,240,0,1,255,255,192,0,1,255,244,0,1,255,255,192,0,2,255,248,0,1,255,255,192,0,3,250,252,0,1,253,0,0,0,15,240,255,0,1,253,0,0,0,47,240,255,128,1,253,0,0,0,127,208,63,208,1,253,0,0,0,255,128,47,244,1,253,0,0,3,255,0,15,253,1,253,0,0,31,253,0,3,255,193,253,0,0,127,244,0,0,255,129,253,0,0,47,208,0,0,63,1,253,0,0,15,0,0,0,8,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,
  // 0xc0bd  삽
  189,192,32,36,32,35,2,252,0,0,0,0,0,1,84,0,0,0,0,0,0,3,248,0,0,0,170,0,0,3,248,0,0,0,255,0,0,3,248,0,0,0,255,0,0,3,248,0,0,0,255,0,0,3,248,0,0,0,255,0,0,3,248,0,0,0,255,0,0,3,248,0,0,1,255,64,0,3,252,0,0,2,255,192,0,3,255,254,0,3,255,208,0,3,255,254,0,11,255,240,0,3,255,254,0,31,251,252,0,3,248,0,0,127,195,255,0,3,248,0,1,255,129,255,208,3,248,0,11,255,0,127,253,3,248,0,191,252,0,31,254,3,248,0,255,224,0,3,252,3,248,0,63,64,0,0,116,3,248,0,20,0,0,0,0,3,248,0,0,0,0,0,0,0,0,0,0,42,64,0,0,2,164,0,0,63,128,0,0,3,248,0,0,63,128,0,0,3,248,0,0,63,128,0,0,3,248,0,0,63,255,255,255,255,248,0,0,63,255,255,255,255,248,0,0,63,255,255,255,255,248,0,0,63,128,0,0,3,248,0,0,63,128,0,0,3,248,0,0,63,128,0,0,3,248,0,0,63,128,0,0,3,248,0,0,63,255,255,255,255,248,0,0,63,255,255,255,255,248,0,0,63,255,255,255,255,248,0,0,0,0,0,0,0,0,0,
  // 0xc0c8  새
  200,192,30,36,32,35,1,252,0,0,0,0,0,0,1,80,0,0,0,0,2,164,7,240,0,0,0,0,3,248,7,240,0,0,0,0,3,248,7,240,0,1,253,0,3,248,7,240,0,1,253,0,3,248,7,240,0,1,253,0,3,248,7,240,0,1,253,0,3,248,7,240,0,1,253,0,3,248,7,240,0,1,253,0,3,248,7,240,0,1,254,0,3,248,7,240,0,1,254,0,3,248,7,240,0,1,254,0,3,248,7,240,0,2,255,0,3,248,7,240,0,2,255,0,3,248,11,240,0,3,255,0,3,255,255,240,0,3,255,128,3,255,255,240,0,11,255,192,3,255,255,240,0,15,255,192,3,248,7,240,0,31,223,240,3,248,7,240,0,63,203,244,3,248,7,240,0,191,135,252,3,248,7,240,0,255,2,255,3,248,7,240,3,254,0,255,195,248,7,240,15,252,0,127,243,248,7,240,127,240,0,47,227,248,7,240,63,208,0,7,195,248,7,240,15,64,0,0,3,248,7,240,0,0,0,0,3,248,7,240,0,0,0,0,3,248,7,240,0,0,0,0,3,248,7,240,0,0,0,0,3,248,7,240,0,0,0,0,3,248,7,240,0,0,0,0,3,248,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,
  // 0xc124  설
  36,193,30,36,32,35,2,252,0,0,0,0,0,0,21,0,0,0,0,0,0,0,191,64,0,0,255,0,0,0,191,64,0,0,255,0,0,0,191,64,0,0,255,0,0,0,191,64,0,0,255,0,0,0,191,64,0,0,255,0,0,0,191,64,0,0,255,64,47,255,255,64,0,1,255,192,47,255,255,64,0,3,255,208,47,255,255,64,0,7,255,240,0,0,191,64,0,15,251,248,0,0,191,64,0,63,211,255,0,0,191,64,0,255,193,255,208,0,191,64,11,255,0,127,253,0,191,64,191,252,0,31,255,0,191,64,191,224,0,2,252,0,191,64,63,64,0,0,36,0,191,64,4,0,0,0,0,0,21,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,64,0,15,255,255,255,255,255,64,0,15,255,255,255,255,255,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,15,255,255,255,255,255,64,0,15,255,255,255,255,255,64,0,15,255,255,255,255,255,64,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,255,255,255,255,255,224,0,15,255,255,255,255,255,224,0,15,255,255,255,255,255,224,0,0,0,0,0,0,0,0,
  // 0xc18c  소
  140,193,31,30,240,35,2,0,0,0,0,5,64,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,63,208,0,0,0,0,0,0,63,224,0,0,0,0,0,0,63,224,0,0,0,0,0,0,127,240,0,0,0,0,0,0,255,244,0,0,0,0,0,1,255,252,0,0,0,0,0,3,254,255,0,0,0,0,0,15,248,255,128,0,0,0,0,63,240,63,224,0,0,0,1,255,192,31,252,0,0,0,31,255,0,7,255,128,0,1,255,252,0,1,255,249,0,63,255,224,0,0,63,255,208,31,255,0,0,0,7,255,192,15,228,0,0,0,0,111,128,0,0,0,47,192,0,1,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0xc18d  속
  141,193,31,35,24,35,2,252,0,0,0,31,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,63,224,0,0,0,0,0,0,63,240,0,0,0,0,0,0,127,240,0,0,0,0,0,0,255,252,0,0,0,0,0,3,255,254,0,0,0,0,0,15,248,255,128,0,0,0,0,191,240,63,244,0,0,0,11,255,192,31,255,64,0,6,255,254,0,3,255,250,64,15,255,244,0,0,127,255,192,11,254,64,47,208,7,255,64,3,144,0,47,208,0,27,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,255,255,255,255,255,252,0,2,255,255,255,255,255,252,0,2,255,255,255,255,255,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,2,252,0,
  // 0xc2a4  스
  164,194,31,29,232,35,2,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,63,224,0,0,0,0,0,0,63,224,0,0,0,0,0,0,127,240,0,0,0,0,0,0,191,244,0,0,0,0,0,0,255,252,0,0,0,0,0,3,255,253,0,0,0,0,0,11,248,255,64,0,0,0,0,47,240,127,208,0,0,0,0,191,208,63,244,0,0,0,7,255,128,15,254,0,0,0,111,253,0,3,255,224,0,27,255,244,0,0,191,254,64,47,255,128,0,0,31,255,208,15,253,0,0,0,2,255,192,11,128,0,0,0,0,27,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0xc2ac  슬
  172,194,31,35,24,35,2,252,0,0,0,47,208,0,0,0,0,0,0,47,224,0,0,0,0,0,0,63,240,0,0,0,0,0,0,127,240,0,0,0,0,0,0,255,252,0,0,0,0,0,3,254,255,0,0,0,0,0,31,248,191,208,0,0,0,1,255,224,63,253,0,0,1,191,255,64,11,255,233,0,31,255,252,0,0,255,255,192,15,255,128,0,0,27,255,128,7,228,0,0,0,0,111,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,255,170,170,170,170,168,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,255,255,255,255,255,255,0,1,255,255,255,255,255,255,0,1,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,
  // 0xc2dc  시
  220,194,28,35,245,35,2,252,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,127,128,0,0,255,0,0,127,128,0,0,255,0,0,127,128,0,0,255,0,0,127,128,0,0,255,0,0,127,128,0,0,255,0,0,127,128,0,0,255,0,0,127,128,0,0,255,0,0,127,128,0,0,255,0,0,191,192,0,0,255,0,0,255,192,0,0,255,0,0,255,208,0,0,255,0,1,255,224,0,0,255,0,2,255,240,0,0,255,0,3,255,248,0,0,255,0,11,243,252,0,0,255,0,15,241,255,0,0,255,0,63,208,255,128,0,255,0,191,192,127,208,0,255,2,255,0,47,244,0,255,11,254,0,15,254,0,255,127,252,0,3,255,192,255,255,240,0,0,255,192,255,127,192,0,0,47,0,255,45,0,0,0,5,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,85,
  // 0xc2dd  식
  221,194,28,36,252,35,2,252,0,0,0,0,0,0,85,0,0,0,0,0,0,191,0,0,106,64,0,0,191,0,0,191,64,0,0,191,0,0,191,64,0,0,191,0,0,191,64,0,0,191,0,0,191,64,0,0,191,0,0,191,128,0,0,191,0,0,255,192,0,0,191,0,0,255,192,0,0,191,0,2,255,208,0,0,191,0,3,255,240,0,0,191,0,11,255,248,0,0,191,0,31,243,254,0,0,191,0,127,209,255,128,0,191,1,255,128,191,240,0,191,15,255,0,47,254,0,191,191,252,0,11,255,64,191,127,240,0,1,255,0,191,63,128,0,0,44,0,191,8,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,0,63,255,255,255,255,255,0,63,255,255,255,255,255,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,
  // 0xc5b4  어
  180,197,29,36,32,35,2,252,0,0,0,0,0,0,85,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,7,254,0,0,0,191,64,0,127,255,224,0,0,191,64,1,255,255,248,0,0,191,64,3,255,175,253,0,0,191,64,11,248,1,255,0,0,191,64,15,240,0,191,128,0,191,64,47,208,0,63,192,0,191,64,63,192,0,47,192,0,191,64,63,128,0,31,208,0,191,64,127,128,0,15,224,0,191,64,127,64,0,15,240,0,191,64,127,64,0,15,255,255,255,64,127,0,0,15,255,255,255,64,127,64,0,15,255,255,255,64,127,64,0,15,240,0,191,64,127,64,0,15,224,0,191,64,63,128,0,31,208,0,191,64,63,192,0,47,192,0,191,64,47,208,0,63,192,0,191,64,15,240,0,127,128,0,191,64,15,248,1,255,0,0,191,64,3,255,175,253,0,0,191,64,1,255,255,248,0,0,191,64,0,127,255,224,0,0,191,64,0,7,254,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,127,64,
  // 0xc5c6  없
  198,197,32,36,32,35,2,252,0,0,0,0,0,0,21,0,0,0,0,0,0,0,191,64,0,27,254,64,0,0,191,64,0,255,255,248,0,0,191,64,7,255,255,254,0,0,191,64,15,254,86,255,128,0,191,64,47,240,0,127,192,0,191,64,63,192,0,31,224,0,191,64,127,128,0,15,240,0,191,64,191,64,0,11,255,255,255,64,191,0,0,11,255,255,255,64,191,64,0,11,255,255,255,64,127,128,0,15,240,0,191,64,63,208,0,47,208,0,191,64,31,249,1,255,192,0,191,64,11,255,255,255,0,0,191,64,1,255,255,252,0,0,191,64,0,47,255,144,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,0,170,0,15,240,0,0,253,0,191,0,15,240,0,0,253,0,191,0,15,240,0,0,253,0,191,0,15,240,0,0,255,255,255,0,31,240,0,0,255,255,255,0,47,244,0,0,255,255,255,0,63,248,0,0,253,0,191,0,127,252,0,0,253,0,191,1,255,255,0,0,253,0,191,3,252,191,192,0,253,0,191,47,248,63,244,0,255,255,255,255,240,15,254,0,255,255,255,127,128,3,252,0,255,255,255,46,0,0,184,0,0,0,0,0,0,0,0,
  // 0xc5d1  엑
  209,197,29,36,32,35,2,252,0,0,0,0,0,0,21,64,0,0,0,0,7,240,63,192,0,1,0,0,7,244,63,192,0,127,253,0,7,244,63,192,3,255,255,128,7,244,63,192,15,255,255,240,7,244,63,192,31,244,31,248,7,244,63,192,63,192,3,252,7,244,63,192,127,64,1,253,7,244,63,192,191,0,0,254,7,244,63,192,255,0,0,255,255,244,63,192,254,0,0,255,255,244,63,192,255,0,0,255,255,244,63,192,191,0,0,253,7,244,63,192,127,64,2,252,7,244,63,192,63,208,7,252,7,244,63,192,31,249,111,244,7,244,63,192,11,255,255,224,7,244,63,192,2,255,255,64,7,244,63,192,0,47,232,0,7,244,63,192,0,0,0,0,7,244,63,192,0,0,0,0,1,80,26,128,0,0,0,0,0,0,0,0,0,31,255,255,255,255,255,192,0,31,255,255,255,255,255,192,0,31,255,255,255,255,255,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,
  // 0xc5d4  엔
  212,197,30,36,32,35,2,252,0,0,0,0,0,0,21,64,0,0,0,0,7,244,63,192,0,0,0,0,7,244,63,192,0,47,248,0,7,244,63,192,2,255,255,64,7,244,63,192,11,255,255,208,7,244,63,192,31,249,127,240,7,244,63,192,63,208,11,252,7,244,63,192,127,128,2,252,7,244,63,192,191,0,1,253,7,244,63,192,191,0,0,254,7,244,63,192,255,0,0,255,255,244,63,192,254,0,0,255,255,244,63,192,191,0,0,255,255,244,63,192,191,0,0,253,7,244,63,192,63,128,3,252,7,244,63,192,47,244,31,248,7,244,63,192,15,255,255,240,7,244,63,192,3,255,255,192,7,244,63,192,0,191,253,0,7,244,63,192,0,1,0,0,7,244,63,192,0,0,0,0,7,244,63,192,0,0,0,0,7,244,63,192,0,10,160,0,7,244,63,192,0,11,240,0,7,244,63,192,0,11,240,0,7,240,63,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,255,255,255,255,255,240,0,11,255,255,255,255,255,240,0,11,255,255,255,255,255,240,0,0,0,0,0,0,0,0,
  // 0xc5f4  열
  244,197,30,36,32,35,2,252,0,0,0,0,0,0,21,0,0,0,0,0,0,0,191,64,0,47,255,144,0,0,191,64,1,255,255,248,0,0,191,64,11,255,255,255,0,0,191,64,31,253,1,255,255,255,255,64,63,224,0,63,255,255,255,64,63,192,0,15,255,255,255,64,127,64,0,15,240,0,191,64,191,0,0,11,240,0,191,64,191,0,0,11,240,0,191,64,127,64,0,15,240,0,191,64,63,192,0,31,255,255,255,64,63,224,0,63,255,255,255,64,15,254,86,255,255,255,255,64,7,255,255,255,0,0,191,64,0,255,255,244,0,0,191,64,0,27,254,64,0,0,191,64,0,0,0,0,0,0,21,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,64,0,15,255,255,255,255,255,64,0,15,255,255,255,255,255,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,15,255,255,255,255,255,64,0,15,255,255,255,255,255,64,0,15,255,255,255,255,255,64,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,255,255,255,255,255,208,0,15,255,255,255,255,255,208,0,15,255,255,255,255,255,208,0,0,0,0,0,0,0,0,
  // 0xc608  예
  8,198,29,36,32,35,2,252,0,0,0,0,0,0,5,64,0,0,0,0,2,164,31,192,0,0,0,0,7,244,31,192,0,10,144,0,7,244,31,192,0,191,252,0,7,244,31,192,3,255,255,0,7,244,31,192,11,255,255,192,7,244,31,192,15,244,63,208,7,244,31,192,47,208,15,240,7,244,31,192,63,192,11,255,255,244,31,192,63,64,3,255,255,244,31,192,127,0,3,255,255,244,31,192,191,0,3,252,7,244,31,192,191,0,2,252,7,244,31,192,191,0,2,252,7,244,31,192,191,0,2,252,7,244,31,192,191,0,2,252,7,244,31,192,191,0,2,252,7,244,31,192,191,0,2,252,7,244,31,192,127,0,3,252,7,244,31,192,127,64,3,255,255,244,31,192,63,128,7,255,255,244,31,192,63,192,11,255,255,244,31,192,31,224,31,224,7,244,31,192,15,254,255,192,7,244,31,192,3,255,255,64,7,244,31,192,1,255,254,0,7,244,31,192,0,47,224,0,7,244,31,192,0,0,0,0,7,244,31,192,0,0,0,0,7,244,31,192,0,0,0,0,7,244,31,192,0,0,0,0,7,244,31,192,0,0,0,0,7,244,31,192,0,0,0,0,7,244,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,26,128,
  // 0xc624  오
  36,198,31,29,232,35,2,0,0,0,6,255,254,64,0,0,0,1,255,255,255,248,0,0,0,11,255,255,255,255,128,0,0,63,254,64,6,255,224,0,0,191,208,0,0,47,248,0,1,255,0,0,0,7,252,0,2,253,0,0,0,2,254,0,3,252,0,0,0,0,255,0,3,248,0,0,0,0,255,0,3,248,0,0,0,0,255,0,3,252,0,0,0,0,255,0,2,253,0,0,0,2,254,0,1,255,0,0,0,7,252,0,0,191,208,0,0,47,248,0,0,63,254,64,6,255,224,0,0,11,255,255,255,255,128,0,0,1,255,255,255,253,0,0,0,0,11,255,254,64,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0xc628  온
  40,198,31,34,16,35,2,252,0,0,27,255,255,144,0,0,0,2,255,255,255,254,0,0,0,47,255,255,255,255,208,0,0,191,249,0,1,255,244,0,0,255,128,0,0,15,252,0,2,254,0,0,0,3,253,0,2,253,0,0,0,1,254,0,2,253,0,0,0,1,254,0,2,254,0,0,0,3,253,0,0,255,128,0,0,15,252,0,0,127,253,64,6,255,244,0,0,31,255,255,255,255,208,0,0,2,255,255,255,254,0,0,0,0,26,255,254,80,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,255,255,255,255,255,253,0,0,255,255,255,255,255,253,0,0,255,255,255,255,255,253,0,0,0,0,0,0,0,0,0,
  // 0xc644  완
  68,198,32,36,32,35,2,252,0,0,0,0,0,1,84,0,0,0,0,0,0,3,252,0,0,6,191,144,0,3,252,0,0,127,255,253,0,3,252,0,1,255,255,255,192,3,252,0,3,254,64,127,224,3,252,0,15,244,0,15,240,3,252,0,15,224,0,7,248,3,252,0,15,208,0,3,248,3,252,0,15,208,0,3,248,3,252,0,15,224,0,7,244,3,252,0,11,244,0,15,240,3,252,0,3,254,64,127,224,3,255,253,1,255,255,255,192,3,255,253,0,63,255,254,0,3,255,253,0,6,255,208,0,3,252,0,0,0,191,0,0,3,252,0,0,0,191,0,0,3,252,0,0,0,191,0,1,67,252,0,0,5,255,175,255,195,252,0,255,255,255,255,255,195,252,0,255,255,255,255,255,131,252,0,191,255,254,165,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,21,0,0,0,3,252,0,0,127,128,0,0,3,252,0,0,127,128,0,0,3,248,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,255,255,255,255,255,0,0,127,255,255,255,255,255,0,0,127,255,255,255,255,255,0,0,0,0,0,0,0,0,0,
  // 0xc6d0  원
  208,198,29,36,32,35,2,252,0,0,0,0,0,0,21,0,0,0,0,0,0,0,191,64,0,2,191,228,0,0,191,64,0,47,255,255,128,0,191,64,1,255,255,255,240,0,191,64,3,254,64,31,248,0,191,64,7,248,0,3,252,0,191,64,11,240,0,2,253,0,191,64,11,240,0,2,253,0,191,64,7,248,0,3,252,0,191,64,3,254,64,31,248,0,191,64,1,255,255,255,240,0,191,64,0,47,255,255,128,0,191,64,0,2,191,228,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,80,191,64,0,21,85,171,255,240,191,64,255,255,255,255,255,240,191,64,255,255,255,255,255,240,191,64,255,255,255,250,80,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,10,170,255,64,0,0,47,192,31,255,255,64,0,0,47,192,31,255,255,64,0,85,47,192,0,0,191,64,0,191,111,192,0,0,191,64,0,191,64,0,0,0,191,64,0,191,64,0,0,0,21,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,255,255,255,255,255,192,0,191,255,255,255,255,255,192,0,191,255,255,255,255,255,192,0,0,0,0,0,0,0,0,
  // 0xc704  위
  4,199,29,36,32,35,2,252,0,0,0,0,0,0,85,0,0,0,0,0,0,0,191,64,0,1,191,228,0,0,191,64,0,31,255,255,64,0,191,64,0,191,255,255,240,0,191,64,2,255,213,111,248,0,191,64,3,253,0,7,253,0,191,64,7,248,0,1,254,0,191,64,11,240,0,0,255,0,191,64,11,240,0,0,255,0,191,64,11,240,0,0,255,0,191,64,7,248,0,1,254,0,191,64,3,253,0,7,253,0,191,64,2,255,213,111,248,0,191,64,0,191,255,255,240,0,191,64,0,31,255,255,64,0,191,64,0,1,191,228,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,80,191,64,0,85,85,171,255,240,191,64,255,255,255,255,255,244,191,64,255,255,255,255,255,224,191,64,191,255,255,233,64,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,0,0,0,0,191,64,
  // 0xc73c  으
  60,199,31,29,232,35,2,0,0,0,10,255,254,64,0,0,0,0,255,255,255,248,0,0,0,11,255,255,255,255,64,0,0,47,254,80,22,255,224,0,0,191,224,0,0,47,244,0,0,255,64,0,0,7,252,0,2,253,0,0,0,2,253,0,3,252,0,0,0,0,255,0,3,248,0,0,0,0,255,0,3,248,0,0,0,0,255,0,3,248,0,0,0,0,255,0,3,252,0,0,0,0,255,0,2,253,0,0,0,2,253,0,0,255,64,0,0,7,252,0,0,191,224,0,0,47,244,0,0,47,254,64,22,255,224,0,0,11,255,255,255,255,64,0,0,0,255,255,255,248,0,0,0,0,11,255,254,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0xc74c  음
  76,199,31,35,24,35,2,252,0,0,26,255,254,144,0,0,0,2,255,255,255,254,0,0,0,31,255,255,255,255,208,0,0,191,253,64,6,255,244,0,0,255,128,0,0,15,252,0,2,254,0,0,0,3,253,0,2,253,0,0,0,1,254,0,2,253,0,0,0,1,254,0,2,254,0,0,0,3,253,0,0,255,128,0,0,15,252,0,0,191,253,64,6,255,244,0,0,31,255,255,255,255,208,0,0,2,255,255,255,254,0,0,0,0,26,255,254,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,253,0,0,0,2,252,0,1,253,0,0,0,2,252,0,1,253,0,0,0,2,252,0,1,253,0,0,0,2,252,0,1,253,0,0,0,2,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,
  // 0xc774  이
  116,199,27,36,252,35,3,252,0,0,0,0,0,1,84,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,11,253,0,0,3,252,0,191,255,208,0,3,252,2,255,255,244,0,3,252,11,255,175,253,0,3,252,15,244,2,255,0,3,252,47,224,0,191,64,3,252,63,192,0,63,192,3,252,127,128,0,63,192,3,252,191,64,0,31,208,3,252,191,0,0,31,224,3,252,255,0,0,15,224,3,252,255,0,0,15,224,3,252,255,0,0,15,224,3,252,255,0,0,15,224,3,252,255,0,0,15,224,3,252,191,0,0,31,224,3,252,191,64,0,31,208,3,252,127,128,0,63,192,3,252,63,192,0,63,192,3,252,47,224,0,191,64,3,252,15,244,2,255,0,3,252,11,255,175,253,0,3,252,2,255,255,244,0,3,252,0,191,255,208,0,3,252,0,11,253,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,2,252,
  // 0xc77c  일
  124,199,29,36,32,35,2,252,0,0,0,0,0,0,85,0,0,0,0,0,0,0,191,0,0,31,255,208,0,0,191,0,1,255,255,253,0,0,191,0,7,255,255,255,128,0,191,0,15,253,1,255,208,0,191,0,63,224,0,47,240,0,191,0,63,192,0,15,244,0,191,0,127,128,0,7,244,0,191,0,127,64,0,7,248,0,191,0,127,128,0,7,244,0,191,0,63,192,0,15,244,0,191,0,63,224,0,47,240,0,191,0,15,253,1,255,208,0,191,0,7,255,255,255,128,0,191,0,1,255,255,253,0,0,191,0,0,31,255,208,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,255,255,255,255,0,0,31,255,255,255,255,255,0,0,31,255,255,255,255,255,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,15,255,255,255,255,255,0,0,15,255,255,255,255,255,0,0,15,255,255,255,255,255,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,255,255,255,255,255,192,0,15,255,255,255,255,255,192,0,15,255,255,255,255,255,192,0,0,0,0,0,0,0,0,
  // 0xc77d  읽
  125,199,28,36,252,35,2,252,0,0,0,0,0,0,85,0,0,0,0,0,0,191,0,11,255,128,0,0,191,0,191,255,248,0,0,191,3,255,255,255,64,0,191,15,254,70,255,192,0,191,47,240,0,63,224,0,191,63,192,0,15,240,0,191,127,128,0,11,244,0,191,127,64,0,7,248,0,191,127,64,0,7,248,0,191,127,128,0,11,244,0,191,63,192,0,15,240,0,191,47,240,0,47,240,0,191,15,254,70,255,192,0,191,3,255,255,255,64,0,191,0,191,255,248,0,0,191,0,11,255,128,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,254,63,255,255,0,255,255,254,63,255,255,0,255,255,254,63,255,255,0,0,0,254,0,0,191,0,0,0,254,0,0,191,0,191,255,254,0,0,191,0,255,255,254,0,0,191,0,255,255,254,0,0,191,0,255,0,0,0,0,191,0,255,0,0,0,0,191,0,255,0,5,144,0,191,0,255,255,255,240,0,191,0,255,255,255,240,0,191,0,255,255,250,80,0,191,0,0,0,0,0,0,21,
  // 0xc785  입
  133,199,28,36,252,35,2,252,0,0,0,0,0,0,85,0,0,0,0,0,0,191,0,11,255,144,0,0,191,0,191,255,253,0,0,191,3,255,255,255,64,0,191,15,254,86,255,208,0,191,47,240,0,47,240,0,191,63,192,0,15,244,0,191,63,128,0,7,248,0,191,127,128,0,3,248,0,191,127,64,0,3,248,0,191,127,128,0,7,248,0,191,63,192,0,11,244,0,191,47,240,0,31,240,0,191,15,253,1,191,208,0,191,7,255,255,255,128,0,191,0,255,255,254,0,0,191,0,31,255,224,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,224,0,0,0,191,0,15,224,0,0,0,191,0,15,224,0,0,0,191,0,15,224,0,0,0,191,0,15,255,255,255,255,255,0,15,255,255,255,255,255,0,15,255,255,255,255,255,0,15,224,0,0,0,191,0,15,224,0,0,0,191,0,15,224,0,0,0,191,0,15,224,0,0,0,191,0,15,255,255,255,255,255,0,15,255,255,255,255,255,0,15,255,255,255,255,255,0,0,0,0,0,0,0,
  // 0xc790  자
  144,199,33,36,68,35,1,252,0,0,0,0,0,0,84,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,31,255,255,255,255,1,253,0,0,31,255,255,255,255,1,253,0,0,31,255,255,255,255,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,127,208,0,1,254,0,0,0,0,191,224,0,1,255,255,192,0,0,255,240,0,1,255,255,192,0,1,255,244,0,1,255,255,192,0,3,255,252,0,1,253,0,0,0,7,249,254,0,1,253,0,0,0,15,240,255,64,1,253,0,0,0,47,224,127,192,1,253,0,0,0,127,192,63,240,1,253,0,0,1,255,64,15,252,1,253,0,0,7,255,0,7,255,65,253,0,0,47,252,0,1,255,209,253,0,0,127,240,0,0,127,129,253,0,0,47,192,0,0,15,1,253,0,0,14,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,
  // 0xc791  작
  145,199,32,36,32,35,2,252,0,0,0,0,0,1,84,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,127,255,255,255,252,3,248,0,127,255,255,255,252,3,248,0,127,255,255,255,252,3,248,0,0,0,255,0,0,3,248,0,0,0,255,0,0,3,248,0,0,0,255,0,0,3,248,0,0,1,255,64,0,3,252,0,0,2,255,128,0,3,255,254,0,3,255,192,0,3,255,254,0,7,255,224,0,3,255,254,0,15,255,244,0,3,248,0,0,63,215,253,0,3,248,0,0,255,194,255,64,3,248,0,7,255,0,255,244,3,248,0,127,253,0,63,255,3,248,0,255,244,0,11,253,3,248,0,191,192,0,1,252,3,248,0,61,0,0,0,16,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,248,0,0,255,255,255,255,255,248,0,0,255,255,255,255,255,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,
  // 0xc798  잘
  152,199,32,35,24,35,2,252,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,127,255,255,255,252,3,248,0,127,255,255,255,252,3,248,0,127,255,255,255,252,3,248,0,0,0,255,0,0,3,248,0,0,0,255,0,0,3,248,0,0,1,255,64,0,3,255,254,0,3,255,192,0,3,255,254,0,7,255,208,0,3,255,254,0,15,255,244,0,3,252,0,0,63,215,253,0,3,248,0,0,255,194,255,128,3,248,0,11,255,0,191,249,3,248,0,191,252,0,47,255,3,248,0,255,240,0,7,253,3,248,0,191,128,0,0,104,3,248,0,36,0,0,0,0,2,164,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,248,0,0,127,255,255,255,255,248,0,0,127,255,255,255,255,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,127,255,255,255,255,248,0,0,127,255,255,255,255,248,0,0,127,255,255,255,255,248,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,255,255,255,255,255,0,0,127,255,255,255,255,255,0,0,127,255,255,255,255,255,0,0,0,0,0,0,0,0,0,
  // 0xc7a5  장
  165,199,32,36,32,35,2,252,0,0,0,0,0,1,84,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,127,255,255,255,252,3,248,0,127,255,255,255,252,3,248,0,127,255,255,255,252,3,248,0,0,0,255,0,0,3,248,0,0,0,255,0,0,3,248,0,0,0,255,0,0,3,248,0,0,1,255,64,0,3,255,254,0,2,255,128,0,3,255,254,0,3,255,192,0,3,255,254,0,7,255,240,0,3,252,0,0,15,251,248,0,3,248,0,0,63,211,254,0,3,248,0,0,255,194,255,128,3,248,0,3,255,64,191,248,3,248,0,47,253,0,63,255,3,248,0,255,248,0,11,253,3,248,0,191,208,0,1,252,3,248,0,63,64,0,0,16,3,248,0,20,0,0,0,0,3,248,0,0,0,0,0,0,0,0,0,0,0,10,255,255,144,0,0,0,1,255,255,255,254,0,0,0,15,255,255,255,255,208,0,0,63,253,0,1,191,240,0,0,127,208,0,0,15,248,0,0,191,64,0,0,3,252,0,0,191,0,0,0,3,252,0,0,191,64,0,0,3,252,0,0,127,208,0,0,15,248,0,0,47,254,64,5,191,240,0,0,11,255,255,255,255,192,0,0,1,255,255,255,254,0,0,0,0,6,255,254,144,0,0,
  // 0xc7ac  재
  172,199,30,36,32,35,2,252,0,0,0,0,0,0,5,64,0,0,0,0,6,160,31,208,0,0,0,0,15,240,31,208,0,0,0,0,15,240,31,208,0,0,0,0,15,240,31,208,191,255,255,255,15,240,31,208,191,255,255,255,15,240,31,208,191,255,255,255,15,240,31,208,0,7,244,0,15,240,31,208,0,7,244,0,15,240,31,208,0,7,244,0,15,240,31,208,0,11,248,0,15,240,31,208,0,11,248,0,15,240,31,208,0,11,248,0,15,240,31,208,0,15,252,0,15,240,31,208,0,15,252,0,15,255,255,208,0,31,253,0,15,255,255,208,0,47,254,0,15,255,255,208,0,63,255,0,15,240,31,208,0,63,191,128,15,240,31,208,0,255,47,192,15,240,31,208,1,254,31,240,15,240,31,208,3,253,15,248,15,240,31,208,11,248,3,254,15,240,31,208,47,240,1,255,207,240,31,208,255,208,0,191,207,240,31,208,255,128,0,31,15,240,31,208,126,0,0,1,15,240,31,208,20,0,0,0,15,240,31,208,0,0,0,0,15,240,31,208,0,0,0,0,15,240,31,208,0,0,0,0,15,240,31,208,0,0,0,0,15,240,31,208,0,0,0,0,15,240,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,
  // 0xc800  저
  0,200,29,36,32,35,2,252,0,0,0,0,0,0,21,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,63,255,255,255,254,0,191,64,63,255,255,255,254,0,191,64,63,255,255,255,254,0,191,64,0,0,255,64,0,0,191,64,0,0,191,0,0,0,191,64,0,0,191,0,0,0,191,64,0,0,191,64,0,0,191,64,0,0,255,64,0,0,191,64,0,0,255,64,0,0,191,64,0,0,255,128,31,255,255,64,0,1,255,192,31,255,255,64,0,2,255,192,31,255,255,64,0,3,255,224,0,0,191,64,0,7,255,240,0,0,191,64,0,11,247,244,0,0,191,64,0,31,227,252,0,0,191,64,0,63,193,255,0,0,191,64,0,191,128,255,128,0,191,64,1,255,0,127,208,0,191,64,7,254,0,47,248,0,191,64,31,252,0,15,255,0,191,64,255,240,0,3,255,128,191,64,255,192,0,0,255,0,191,64,63,0,0,0,29,0,191,64,40,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,127,64,
  // 0xc804  전
  4,200,29,36,32,35,2,252,0,0,0,0,0,0,85,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,63,255,255,255,253,0,191,64,63,255,255,255,253,0,191,64,63,255,255,255,253,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,255,64,0,0,191,64,0,0,255,128,0,0,191,64,0,0,255,192,15,255,255,64,0,1,255,192,15,255,255,64,0,3,255,224,15,255,255,64,0,7,255,240,0,0,191,64,0,15,247,252,0,0,191,64,0,63,210,255,0,0,191,64,0,255,192,255,208,0,191,64,7,255,0,63,252,0,191,64,127,253,0,31,255,0,191,64,255,244,0,3,254,0,191,64,63,192,0,0,124,0,191,64,45,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,11,240,0,0,0,191,64,0,15,240,0,0,0,191,64,0,15,240,0,0,0,21,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,255,255,255,255,255,192,0,15,255,255,255,255,255,192,0,15,255,255,255,255,255,192,0,0,0,0,0,0,0,0,
  // 0xc815  정
  21,200,29,36,32,35,2,252,0,0,0,0,0,0,21,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,63,255,255,255,253,0,191,64,63,255,255,255,253,0,191,64,63,255,255,255,253,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,255,64,0,0,191,64,0,0,255,128,0,0,191,64,0,1,255,192,11,255,255,64,0,2,255,224,11,255,255,64,0,3,255,240,11,255,255,64,0,11,251,248,0,0,191,64,0,47,243,254,0,0,191,64,0,127,209,255,128,0,191,64,1,255,128,191,244,0,191,64,31,255,0,47,255,0,191,64,191,252,0,11,255,0,191,64,127,240,0,1,252,0,191,64,63,128,0,0,24,0,191,64,24,0,0,0,0,0,191,64,0,0,0,0,0,0,0,0,0,0,1,191,255,228,0,0,0,0,127,255,255,255,128,0,0,2,255,255,255,255,248,0,0,11,255,144,0,111,253,0,0,15,244,0,0,2,255,0,0,47,224,0,0,0,191,64,0,47,208,0,0,0,127,64,0,47,224,0,0,0,191,64,0,15,244,0,0,2,255,0,0,11,255,144,0,111,253,0,0,2,255,255,255,255,248,0,0,0,127,255,255,255,128,0,0,0,1,191,255,164,0,0,
  // 0xc81c  제
  28,200,29,36,32,35,2,252,0,0,0,0,0,0,5,64,0,0,0,0,6,160,47,192,0,0,0,0,7,240,47,192,0,0,0,0,7,240,47,192,0,0,0,0,7,240,47,192,127,255,255,255,7,240,47,192,127,255,255,255,7,240,47,192,127,255,255,255,7,240,47,192,0,7,244,0,7,240,47,192,0,7,244,0,7,240,47,192,0,7,244,0,7,240,47,192,0,11,244,0,7,240,47,192,0,11,248,0,7,240,47,192,0,11,248,31,255,240,47,192,0,15,248,31,255,240,47,192,0,15,252,31,255,240,47,192,0,31,253,0,11,240,47,192,0,47,254,0,7,240,47,192,0,63,255,0,7,240,47,192,0,127,127,64,7,240,47,192,0,255,63,192,7,240,47,192,1,253,31,224,7,240,47,192,3,252,15,244,7,240,47,192,15,244,7,252,7,240,47,192,47,240,2,255,71,240,47,192,255,208,0,255,199,240,47,192,255,64,0,63,71,240,47,192,126,0,0,10,7,240,47,192,36,0,0,0,7,240,47,192,0,0,0,0,7,240,47,192,0,0,0,0,7,240,47,192,0,0,0,0,7,240,47,192,0,0,0,0,7,240,47,192,0,0,0,0,7,240,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,31,192,
  // 0xc8fd  죽
  253,200,31,34,16,35,2,252,3,255,255,255,255,255,255,0,3,255,255,255,255,255,255,0,3,255,255,255,255,255,255,0,0,0,0,127,244,0,0,0,0,0,0,191,248,0,0,0,0,0,1,255,252,0,0,0,0,0,7,254,255,0,0,0,0,0,47,248,191,224,0,0,0,2,255,224,63,253,0,0,1,191,255,64,11,255,249,0,31,255,252,0,1,255,255,192,15,255,144,0,0,31,255,128,7,228,0,0,0,0,111,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,2,255,255,255,255,255,252,0,2,255,255,255,255,255,252,0,2,255,255,255,255,255,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,2,252,0,
  // 0xc900  준
  0,201,31,34,16,35,2,252,3,255,255,255,255,255,255,0,3,255,255,255,255,255,255,0,3,255,255,255,255,255,255,0,0,0,0,127,244,0,0,0,0,0,0,191,244,0,0,0,0,0,0,255,252,0,0,0,0,0,2,255,254,0,0,0,0,0,11,252,255,64,0,0,0,0,47,240,127,224,0,0,0,2,255,224,47,253,0,0,0,111,255,64,11,255,228,0,15,255,253,0,1,255,255,192,15,255,208,0,0,47,255,128,7,253,0,0,0,2,255,64,1,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,1,254,0,15,224,0,0,0,1,254,0,15,224,0,0,0,1,254,0,15,224,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,255,255,255,255,255,254,0,1,255,255,255,255,255,254,0,1,255,255,255,255,255,254,0,0,0,0,0,0,0,0,0,
  // 0xc911  중
  17,201,31,34,16,35,2,252,3,255,255,255,255,255,255,0,3,255,255,255,255,255,255,0,3,255,255,255,255,255,255,0,0,0,0,127,244,0,0,0,0,0,0,255,248,0,0,0,0,0,1,255,253,0,0,0,0,0,7,254,255,64,0,0,0,0,47,248,191,224,0,0,0,6,255,224,63,254,0,0,6,255,255,64,11,255,250,64,31,255,252,0,1,255,255,192,15,255,128,0,0,27,255,128,7,164,0,0,0,0,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,27,255,254,144,0,0,0,7,255,255,255,254,0,0,0,47,255,255,255,255,208,0,0,127,249,0,1,191,240,0,0,255,128,0,0,15,252,0,1,255,0,0,0,3,252,0,1,254,0,0,0,3,252,0,1,255,0,0,0,3,252,0,0,255,128,0,0,15,252,0,0,127,249,0,1,191,240,0,0,47,255,255,255,255,208,0,0,2,255,255,255,254,0,0,0,0,26,255,254,144,0,0,
  // 0xc990  즐
  144,201,31,34,16,35,2,252,3,255,255,255,255,255,255,0,3,255,255,255,255,255,255,0,3,255,255,255,255,255,255,0,0,0,0,63,240,0,0,0,0,0,0,191,248,0,0,0,0,0,2,255,253,0,0,0,0,0,15,253,255,128,0,0,0,1,191,240,127,248,0,0,1,175,255,192,31,255,229,0,31,255,253,0,2,255,255,192,15,255,208,0,0,31,255,192,7,164,0,0,0,0,107,64,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,255,255,255,255,255,255,0,1,255,255,255,255,255,255,0,1,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,
  // 0xc9c0  지
  192,201,28,36,252,35,2,252,0,0,0,0,0,0,85,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,63,255,255,255,255,0,255,63,255,255,255,255,0,255,63,255,255,255,255,0,255,0,0,191,128,0,0,255,0,0,127,128,0,0,255,0,0,127,128,0,0,255,0,0,127,128,0,0,255,0,0,127,128,0,0,255,0,0,191,128,0,0,255,0,0,191,192,0,0,255,0,0,255,192,0,0,255,0,0,255,208,0,0,255,0,1,255,224,0,0,255,0,3,255,240,0,0,255,0,7,251,248,0,0,255,0,15,242,253,0,0,255,0,47,224,255,0,0,255,0,127,192,191,192,0,255,0,255,128,63,224,0,255,3,255,0,31,252,0,255,15,253,0,11,255,128,255,191,244,0,1,255,192,255,255,208,0,0,127,64,255,63,64,0,0,11,0,255,24,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,191,
  // 0xcc98  처
  152,204,29,36,32,35,2,252,0,0,0,0,0,0,21,0,0,0,106,0,0,0,191,64,0,0,191,0,0,0,191,64,0,0,191,0,0,0,191,64,0,0,191,0,0,0,191,64,0,0,191,0,0,0,191,64,0,0,255,64,0,0,191,64,63,255,255,255,253,0,191,64,63,255,255,255,253,0,191,64,63,255,255,255,253,0,191,64,0,0,191,0,0,0,191,64,0,0,191,0,0,0,191,64,0,0,191,0,0,0,191,64,0,0,255,64,0,0,191,64,0,0,255,64,0,0,191,64,0,0,255,128,31,255,255,64,0,1,255,192,31,255,255,64,0,2,255,208,31,255,255,64,0,3,255,224,0,0,191,64,0,11,251,240,0,0,191,64,0,15,227,252,0,0,191,64,0,63,210,254,0,0,191,64,0,191,192,255,128,0,191,64,1,255,0,127,208,0,191,64,7,254,0,47,248,0,191,64,47,248,0,11,255,64,191,64,255,240,0,2,255,0,191,64,127,128,0,0,125,0,191,64,45,0,0,0,4,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,127,64,
  // 0xcd08  초
  8,205,31,31,248,35,2,0,0,0,0,26,144,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,47,224,0,0,0,7,255,255,255,255,255,255,0,7,255,255,255,255,255,255,0,7,255,255,255,255,255,255,0,0,0,0,47,224,0,0,0,0,0,0,63,224,0,0,0,0,0,0,63,240,0,0,0,0,0,0,191,248,0,0,0,0,0,1,255,253,0,0,0,0,0,7,254,255,0,0,0,0,0,31,248,191,208,0,0,0,0,255,224,63,248,0,0,0,31,255,128,11,255,144,0,27,255,253,0,1,255,255,128,31,255,224,0,0,47,255,192,15,254,0,5,64,2,255,128,6,64,0,31,208,0,6,64,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0xcd95  축
  149,205,31,36,32,35,2,252,0,0,0,21,64,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,3,255,255,255,255,255,255,0,3,255,255,255,255,255,255,0,3,255,255,255,255,255,255,0,0,0,0,63,240,0,0,0,0,0,0,127,240,0,0,0,0,0,0,255,252,0,0,0,0,0,7,255,255,64,0,0,0,0,127,244,191,244,0,0,0,111,255,208,47,255,148,0,31,255,254,0,3,255,255,192,15,255,224,0,0,111,255,128,7,164,0,0,0,0,111,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,2,255,255,255,255,255,252,0,2,255,255,255,255,255,252,0,2,255,255,255,255,255,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,2,252,0,
  // 0xcd9c  출
  156,205,31,36,32,35,2,252,0,0,0,5,64,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,3,255,255,255,255,255,255,0,3,255,255,255,255,255,255,0,3,255,255,255,255,255,255,0,0,0,0,63,240,0,0,0,0,0,0,255,248,0,0,0,0,0,3,255,255,0,0,0,0,0,111,248,255,228,0,0,1,111,255,224,63,255,165,0,31,255,255,64,7,255,255,192,15,255,228,0,0,111,255,192,11,164,0,0,0,0,107,64,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,255,170,170,170,170,168,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,255,255,255,255,255,255,0,1,255,255,255,255,255,255,0,1,255,255,255,255,255,255,0,
  // 0xcda4  춤
  164,205,31,36,32,35,2,252,0,0,0,5,64,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,3,255,255,255,255,255,255,0,3,255,255,255,255,255,255,0,3,255,255,255,255,255,255,0,0,0,0,63,240,0,0,0,0,0,0,127,240,0,0,0,0,0,0,255,252,0,0,0,0,0,7,255,255,64,0,0,0,0,127,244,191,244,0,0,0,111,255,208,47,255,148,0,31,255,254,0,3,255,255,192,15,255,224,0,0,111,255,192,11,164,0,0,0,0,111,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,254,0,0,0,2,252,0,1,253,0,0,0,2,252,0,1,253,0,0,0,2,252,0,1,253,0,0,0,2,252,0,1,253,0,0,0,2,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,
  // 0xcde8  취
  232,205,29,36,32,35,2,252,0,0,21,64,0,0,106,0,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,15,255,255,255,255,64,191,64,15,255,255,255,255,64,191,64,15,255,255,255,255,64,191,64,0,0,63,208,0,0,191,64,0,0,63,208,0,0,191,64,0,0,127,240,0,0,191,64,0,0,255,248,0,0,191,64,0,2,255,253,0,0,191,64,0,11,253,255,128,0,191,64,0,127,244,127,249,0,191,64,11,255,208,31,255,192,191,64,31,255,64,7,255,64,191,64,15,248,0,0,127,0,191,64,6,64,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,85,171,240,191,64,255,255,255,255,255,244,191,64,255,255,255,255,255,244,191,64,191,255,255,254,148,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,47,192,0,0,191,64,0,0,42,128,0,0,191,64,0,0,0,0,0,0,191,64,
  // 0xce58  치
  88,206,28,36,252,35,2,252,0,0,0,0,0,0,85,0,0,42,128,0,0,191,0,0,63,192,0,0,191,0,0,63,192,0,0,191,0,0,63,192,0,0,191,0,0,63,192,0,0,191,0,0,63,192,0,0,191,47,255,255,255,255,64,191,47,255,255,255,255,64,191,47,255,255,255,255,64,191,0,0,63,192,0,0,191,0,0,63,192,0,0,191,0,0,63,192,0,0,191,0,0,63,192,0,0,191,0,0,127,192,0,0,191,0,0,127,208,0,0,191,0,0,191,224,0,0,191,0,0,255,240,0,0,191,0,1,255,244,0,0,191,0,3,251,252,0,0,191,0,7,245,254,0,0,191,0,31,240,255,128,0,191,0,63,208,127,208,0,191,0,255,128,47,244,0,191,3,255,0,15,254,0,191,31,253,0,3,255,208,191,127,244,0,0,255,192,191,47,208,0,0,31,0,191,14,0,0,0,1,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,
  // 0xce68  침
  104,206,28,35,245,35,2,252,0,0,63,128,0,0,191,0,0,63,128,0,0,191,0,0,63,128,0,0,191,0,0,127,192,0,0,191,47,255,255,255,255,0,191,47,255,255,255,255,0,191,47,255,255,255,255,0,191,0,0,63,192,0,0,191,0,0,127,192,0,0,191,0,0,191,192,0,0,191,0,0,255,224,0,0,191,0,1,255,240,0,0,191,0,3,255,252,0,0,191,0,15,246,255,0,0,191,0,63,240,255,208,0,191,1,255,192,63,253,0,191,47,255,0,15,255,192,191,127,252,0,2,255,64,191,47,224,0,0,47,0,191,14,0,0,0,0,0,191,0,0,0,0,0,0,85,0,0,0,0,0,0,0,0,15,255,255,255,255,255,0,15,255,255,255,255,255,0,15,255,255,255,255,255,0,15,224,0,0,0,191,0,15,224,0,0,0,191,0,15,224,0,0,0,191,0,15,224,0,0,0,191,0,15,224,0,0,0,191,0,15,224,0,0,0,191,0,15,255,255,255,255,255,0,15,255,255,255,255,255,0,15,255,255,255,255,255,0,0,0,0,0,0,0,
  // 0xce74  카
  116,206,32,36,32,35,2,252,0,0,0,0,0,1,80,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,15,255,255,255,224,7,244,0,15,255,255,255,224,7,244,0,15,255,255,255,224,7,244,0,0,0,0,31,224,7,244,0,0,0,0,31,208,7,244,0,0,0,0,47,208,7,244,0,0,0,0,63,192,7,244,0,0,0,0,63,192,7,244,0,0,0,0,63,192,7,244,0,1,90,175,255,128,7,244,0,191,255,255,255,64,7,249,84,127,255,255,255,0,7,255,254,127,254,166,254,0,7,255,254,16,0,3,252,0,7,255,254,0,0,11,248,0,7,244,0,0,0,31,240,0,7,244,0,0,0,63,224,0,7,244,0,0,0,255,192,0,7,244,0,0,3,255,0,0,7,244,0,0,31,253,0,0,7,244,0,0,127,244,0,0,7,244,0,3,255,208,0,0,7,244,0,47,255,0,0,0,7,244,0,191,248,0,0,0,7,244,0,63,208,0,0,0,7,244,0,30,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,
  // 0xcf1c  켜
  28,207,29,36,32,35,2,252,0,0,0,0,0,0,85,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,15,255,255,255,208,0,191,64,15,255,255,255,192,0,191,64,15,255,255,255,192,0,191,64,0,0,0,47,192,0,191,64,0,0,0,63,192,0,191,64,0,0,0,63,192,0,191,64,0,0,0,63,255,255,255,64,0,0,0,127,255,255,255,64,0,0,1,191,255,255,255,64,171,255,255,255,0,0,191,64,255,255,255,255,0,0,191,64,191,255,255,254,0,0,191,64,191,169,67,252,0,0,191,64,0,0,11,248,0,0,191,64,0,0,15,244,0,0,191,64,0,0,47,224,0,0,191,64,0,0,191,192,255,255,255,64,0,1,255,64,255,255,255,64,0,7,254,0,255,255,255,64,0,47,252,0,0,0,191,64,0,191,240,0,0,0,191,64,7,255,192,0,0,0,191,64,63,254,0,0,0,0,191,64,255,244,0,0,0,0,191,64,127,192,0,0,0,0,191,64,45,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,127,64,
  // 0xd0d1  탑
  209,208,31,35,24,35,3,252,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,191,255,255,255,0,15,224,0,191,255,255,255,0,15,224,0,191,255,255,255,0,15,224,0,191,0,0,0,0,15,224,0,191,0,0,0,0,15,224,0,191,0,0,0,0,15,240,0,191,255,255,254,0,15,255,248,191,255,255,254,0,15,255,248,191,255,255,254,0,15,255,248,191,64,0,0,0,15,224,0,191,0,0,0,0,15,224,0,191,0,0,0,0,15,224,0,191,64,0,90,244,15,224,0,191,255,255,255,244,15,224,0,191,255,255,255,248,15,224,0,191,255,255,250,80,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,0,0,0,85,0,0,0,5,80,0,0,254,0,0,0,15,224,0,0,254,0,0,0,15,224,0,0,254,0,0,0,15,224,0,0,255,255,255,255,255,224,0,0,255,255,255,255,255,224,0,0,255,255,255,255,255,224,0,0,254,0,0,0,15,224,0,0,254,0,0,0,15,224,0,0,254,0,0,0,15,224,0,0,254,0,0,0,15,224,0,0,255,255,255,255,255,224,0,0,255,255,255,255,255,224,0,0,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0xd130  터
  48,209,28,36,252,35,3,252,0,0,0,0,0,0,84,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,191,255,255,255,64,2,253,191,255,255,255,64,2,253,191,255,255,255,64,2,253,191,64,0,0,0,2,253,191,64,0,0,0,2,253,191,64,0,0,0,2,253,191,64,0,0,0,2,253,191,64,0,0,0,2,253,191,64,0,0,0,2,253,191,64,0,0,0,2,253,191,255,255,252,63,255,253,191,255,255,252,63,255,253,191,255,255,252,63,255,253,191,64,0,0,0,2,253,191,64,0,0,0,2,253,191,64,0,0,0,2,253,191,64,0,0,0,2,253,191,64,0,0,0,2,253,191,64,0,0,0,2,253,191,64,0,90,180,2,253,191,255,255,255,244,2,253,191,255,255,255,248,2,253,191,255,255,250,80,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,1,253,
  // 0xd14c  테
  76,209,28,36,252,35,3,252,0,0,0,0,0,0,21,0,0,0,0,26,128,191,0,0,0,0,47,192,191,0,0,0,0,47,192,191,0,0,0,0,47,192,191,255,255,255,192,47,192,191,255,255,255,192,47,192,191,255,255,255,192,47,192,191,255,0,0,0,47,192,191,255,0,0,0,47,192,191,255,0,0,0,47,192,191,255,0,0,0,47,192,191,255,0,0,0,47,192,191,255,0,0,0,47,192,191,255,255,253,63,255,192,191,255,255,253,63,255,192,191,255,255,253,63,255,192,191,255,0,0,0,47,192,191,255,0,0,0,47,192,191,255,0,0,0,47,192,191,255,0,0,0,47,192,191,255,0,0,0,47,192,191,255,0,0,0,47,192,191,255,0,0,0,47,192,191,255,1,90,244,47,192,191,255,255,255,244,47,192,191,255,255,255,248,47,192,191,255,255,250,80,47,192,191,0,0,0,0,47,192,191,0,0,0,0,47,192,191,0,0,0,0,47,192,191,0,0,0,0,47,192,191,0,0,0,0,47,192,191,0,0,0,0,47,192,191,0,0,0,0,5,64,191,0,0,0,0,0,0,127,
  // 0xd1a0  토
  160,209,31,29,232,35,2,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,255,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,255,255,255,255,244,0,0,255,255,255,255,255,244,0,0,255,255,255,255,255,244,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,255,255,255,255,254,0,0,255,255,255,255,255,254,0,0,255,255,255,255,255,254,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,224,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,
  // 0xd2b8  트
  184,210,31,28,224,35,2,0,0,255,255,255,255,255,253,0,0,255,255,255,255,255,253,0,0,255,255,255,255,255,253,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,255,255,255,255,255,248,0,0,255,255,255,255,255,248,0,0,255,255,255,255,255,248,0,0,255,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,255,255,255,255,255,254,0,0,255,255,255,255,255,254,0,0,255,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0xd39c  펜
  156,211,30,36,32,35,2,252,0,0,0,0,0,0,21,64,0,0,0,0,2,164,47,192,0,0,0,0,3,248,47,192,0,0,0,0,3,248,47,192,191,255,255,255,3,248,47,192,191,255,255,255,3,248,47,192,191,255,255,255,3,248,47,192,3,244,15,208,3,248,47,192,3,244,15,208,3,248,47,192,3,244,15,208,3,248,47,192,3,244,15,208,3,248,47,192,3,244,15,211,255,248,47,192,3,244,15,211,255,248,47,192,3,244,15,211,255,248,47,192,3,244,15,208,3,248,47,192,3,244,15,208,3,248,47,192,3,244,15,208,3,248,47,192,3,244,15,230,67,248,47,192,255,255,255,255,195,248,47,192,255,255,255,255,195,248,47,192,255,255,255,233,3,248,47,192,0,0,0,0,3,248,47,192,0,0,0,0,3,248,47,192,0,0,0,0,3,248,47,192,0,7,244,0,3,248,47,192,0,7,244,0,3,248,47,192,0,7,244,0,0,0,47,192,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,255,255,255,255,255,240,0,7,255,255,255,255,255,240,0,7,255,255,255,255,255,240,0,0,0,0,0,0,0,0,
  // 0xd504  프
  4,213,31,28,224,35,2,0,11,255,255,255,255,255,255,64,11,255,255,255,255,255,255,64,11,255,255,255,255,255,255,64,0,2,254,0,2,253,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,1,253,0,2,252,0,0,0,2,254,0,2,253,0,0,7,255,255,255,255,255,255,0,7,255,255,255,255,255,255,0,7,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0xd558  하
  88,213,33,36,68,35,1,252,0,0,0,0,0,0,84,0,0,0,0,63,192,0,1,254,0,0,0,0,63,192,0,1,254,0,0,0,0,63,192,0,1,254,0,0,0,0,63,192,0,1,254,0,0,0,0,63,192,0,1,254,0,0,127,255,255,255,255,193,254,0,0,127,255,255,255,255,193,254,0,0,127,255,255,255,255,193,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,2,255,248,0,1,254,0,0,0,31,255,255,64,1,254,0,0,0,191,255,255,208,1,254,85,0,1,255,144,127,240,1,255,255,192,3,253,0,11,248,1,255,255,192,3,252,0,3,252,1,255,255,192,7,244,0,2,253,1,254,0,0,11,240,0,1,253,1,254,0,0,11,240,0,1,253,1,254,0,0,7,244,0,2,253,1,254,0,0,3,252,0,3,252,1,254,0,0,3,253,0,11,248,1,254,0,0,1,255,144,127,240,1,254,0,0,0,191,255,255,208,1,254,0,0,0,47,255,255,64,1,254,0,0,0,2,255,248,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,253,0,0,
  // 0xd569  합
  105,213,32,36,32,35,2,252,0,0,170,0,0,1,84,0,0,0,255,0,0,3,248,0,0,0,255,0,0,3,248,0,0,0,255,0,0,3,248,0,255,255,255,255,255,3,248,0,255,255,255,255,255,3,248,0,255,255,255,255,255,3,248,0,0,0,0,0,0,3,248,0,0,6,190,144,0,3,248,0,0,127,255,253,0,3,252,0,2,255,255,255,192,3,255,254,7,254,0,191,224,3,255,254,15,244,0,15,240,3,255,254,15,224,0,11,244,3,248,0,15,224,0,7,244,3,248,0,15,224,0,11,244,3,248,0,15,244,0,15,240,3,248,0,7,254,0,127,224,3,248,0,2,255,255,255,192,3,248,0,0,127,255,254,0,3,248,0,0,6,191,144,0,3,248,0,0,0,0,0,0,1,84,0,0,21,0,0,0,0,16,0,0,63,128,0,0,3,248,0,0,63,128,0,0,3,248,0,0,63,128,0,0,3,248,0,0,63,255,255,255,255,248,0,0,63,255,255,255,255,248,0,0,63,255,255,255,255,248,0,0,63,128,0,0,3,248,0,0,63,128,0,0,3,248,0,0,63,128,0,0,3,248,0,0,63,255,255,255,255,248,0,0,63,255,255,255,255,248,0,0,63,255,255,255,255,248,0,0,0,0,0,0,0,0,0,
  // 0xd648  홈
  72,214,31,35,24,35,2,253,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,47,255,255,255,255,255,255,192,47,255,255,255,255,255,255,192,47,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,5,170,169,64,0,0,0,2,255,255,255,253,0,0,0,31,255,255,255,255,208,0,0,127,249,0,1,191,240,0,0,191,192,0,0,15,248,0,0,255,64,0,0,11,248,0,0,191,192,0,0,15,248,0,0,127,249,0,1,191,240,0,0,31,255,255,255,255,208,0,0,2,255,255,255,254,0,0,0,0,6,191,249,64,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,253,0,0,0,2,252,0,1,253,0,0,0,2,252,0,1,253,0,0,0,2,252,0,1,253,0,0,0,2,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,1,255,255,255,255,255,252,0,
  // 0xd654  화
  84,214,33,35,59,35,1,252,0,0,47,208,0,0,254,0,0,0,0,47,208,0,0,254,0,0,0,0,47,208,0,0,254,0,0,0,0,47,208,0,0,254,0,0,63,255,255,255,255,224,254,0,0,63,255,255,255,255,224,254,0,0,63,255,255,255,255,224,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,1,175,232,0,0,254,0,0,0,31,255,255,128,0,254,0,0,0,127,255,255,240,0,254,0,0,0,255,128,27,252,0,254,0,0,2,253,0,2,253,0,254,0,0,3,252,0,0,254,0,255,255,128,3,252,0,0,253,0,255,255,128,2,252,0,2,253,0,255,255,128,1,255,0,3,252,0,255,0,0,0,255,208,47,248,0,254,0,0,0,63,255,255,240,0,254,0,0,0,15,255,255,128,0,254,0,0,0,1,191,244,0,0,254,0,0,0,0,47,208,0,0,254,0,0,0,0,47,208,0,0,254,0,0,0,0,47,213,106,240,254,0,0,127,255,255,255,255,240,254,0,0,63,255,255,255,255,240,254,0,0,63,255,255,254,164,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,
  // 0xd788  히
  136,215,28,36,252,35,2,252,0,0,0,0,0,0,85,0,0,63,192,0,0,255,0,0,63,192,0,0,255,0,0,63,192,0,0,255,0,0,63,192,0,0,255,0,0,63,192,0,0,255,127,255,255,255,255,192,255,127,255,255,255,255,192,255,127,255,255,255,255,192,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,2,255,248,0,0,255,0,31,255,255,64,0,255,0,191,255,255,224,0,255,1,255,144,127,244,0,255,3,253,0,11,252,0,255,7,248,0,3,252,0,255,11,244,0,1,253,0,255,11,240,0,1,254,0,255,11,240,0,1,254,0,255,11,244,0,1,253,0,255,7,248,0,3,252,0,255,3,253,0,11,252,0,255,1,255,144,111,244,0,255,0,191,255,255,224,0,255,0,47,255,255,64,0,255,0,2,255,248,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,191,
};

#endif // HAS_GRAPHICAL_TFT
