/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Vietnamese 37pt, capital 'A' height: 27px, width: 100%, range: 0x0102-0x1ef9, glyphs: 107
extern const uint8_t NotoSans_Medium_Vietnamese_27[18122] = {
  162,27,2,1,249,30,35,247, // unifont_t
  // 0x0102  Ă
  2,1,24,34,204,24,0,0,0,10,0,0,160,0,0,15,128,2,240,0,0,11,249,111,224,0,0,3,255,255,192,0,0,0,255,254,0,0,0,0,6,144,0,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x0103  ă
  3,1,18,29,145,21,1,255,1,160,0,26,0,1,240,0,62,0,0,254,86,252,0,0,127,255,248,0,0,31,255,208,0,0,1,169,0,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x0110  Đ
  16,1,24,27,162,27,1,0,1,85,85,64,0,0,7,255,255,255,64,0,7,255,255,255,244,0,7,255,255,255,254,0,7,248,0,27,255,192,7,248,0,0,191,224,7,248,0,0,47,244,7,248,0,0,15,252,7,248,0,0,7,252,7,248,0,0,3,253,7,248,0,0,2,254,7,248,0,0,1,255,191,255,255,64,1,255,255,255,255,128,1,255,255,255,255,128,1,255,171,254,170,64,1,255,7,248,0,0,2,254,7,248,0,0,3,253,7,248,0,0,3,252,7,248,0,0,11,252,7,248,0,0,31,244,7,248,0,0,127,240,7,248,0,2,255,192,7,253,85,191,255,64,7,255,255,255,252,0,7,255,255,255,208,0,7,255,255,228,0,0,
  // 0x0111  đ
  17,1,21,29,174,23,2,255,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,3,255,255,255,128,0,7,255,255,255,128,0,3,255,255,255,128,0,0,0,15,240,0,0,0,0,15,240,0,0,47,232,15,240,0,2,255,255,79,240,0,11,255,255,239,240,0,31,254,91,255,240,0,63,224,0,191,240,0,127,192,0,63,240,0,191,128,0,31,240,0,255,64,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,64,0,15,240,0,191,128,0,47,240,0,63,208,0,63,240,0,63,244,1,255,240,0,15,255,255,255,240,0,3,255,255,203,240,0,0,191,254,7,240,0,0,1,64,0,0,0,
  // 0x0128  Ĩ
  40,1,14,34,136,13,0,0,1,64,1,64,47,248,3,208,127,255,155,192,254,191,255,128,240,11,255,0,144,0,100,0,0,0,0,0,21,85,85,0,47,255,254,0,47,255,254,0,2,255,224,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,191,128,0,11,255,249,0,47,255,254,0,47,255,254,0,
  // 0x0129  ĩ
  41,1,14,28,112,10,254,0,1,64,0,80,15,253,1,240,63,255,215,224,126,191,255,192,248,7,255,64,160,0,100,0,0,0,0,0,0,0,0,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,
  // 0x0168  Ũ
  104,1,21,35,210,27,3,255,0,1,64,0,80,0,0,31,248,3,224,0,0,127,255,155,208,0,0,254,191,255,192,0,0,240,11,255,0,0,0,160,0,100,0,0,0,0,0,0,0,0,85,0,0,0,21,64,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,128,0,0,63,192,127,192,0,0,127,128,63,208,0,0,255,64,47,240,0,2,255,0,15,254,64,31,253,0,7,255,255,255,244,0,0,255,255,255,208,0,0,31,255,254,0,0,0,0,21,64,0,0,
  // 0x0169  ũ
  105,1,17,29,145,23,3,255,0,20,0,5,0,1,255,128,62,0,7,255,249,188,0,15,235,255,252,0,15,0,191,240,0,10,0,6,64,0,0,0,0,0,0,0,0,0,0,0,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,192,255,128,0,255,192,191,208,7,255,192,63,255,255,239,192,31,255,255,79,192,2,255,248,15,192,0,21,0,0,0,
  // 0x01a0  Ơ
  160,1,28,29,203,29,2,255,0,0,0,0,0,0,255,0,0,107,234,64,0,255,0,11,255,255,248,1,254,0,127,255,255,255,66,253,1,255,254,175,255,215,252,3,255,128,0,127,255,240,15,252,0,0,15,255,128,31,244,0,0,3,254,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,1,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x01a1  ơ
  161,1,23,24,144,24,2,255,0,0,0,0,11,248,0,0,0,0,11,244,0,0,16,0,15,240,0,47,255,208,15,240,2,255,255,252,63,208,11,255,255,255,255,128,31,248,1,255,253,0,63,208,0,63,224,0,127,192,0,15,240,0,191,64,0,15,240,0,255,0,0,11,244,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,11,244,0,191,64,0,15,240,0,127,192,0,15,240,0,63,208,0,63,224,0,31,248,0,255,192,0,11,255,255,255,0,0,1,255,255,252,0,0,0,47,255,208,0,0,0,0,84,0,0,0,
  // 0x01af  Ư
  175,1,28,29,203,30,3,255,0,0,0,0,0,0,255,85,0,0,0,21,65,255,191,64,0,0,63,194,253,191,64,0,0,63,195,252,191,64,0,0,63,203,248,191,64,0,0,63,255,224,191,64,0,0,63,255,128,191,64,0,0,63,228,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,127,192,0,0,127,128,0,63,208,0,0,255,64,0,47,240,0,2,255,0,0,15,254,64,31,253,0,0,3,255,255,255,248,0,0,0,255,255,255,208,0,0,0,31,255,254,0,0,0,0,0,21,64,0,0,0,
  // 0x01b0  ư
  176,1,24,24,144,26,3,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,1,254,255,0,0,47,194,253,255,0,0,47,199,252,255,0,0,47,255,240,255,0,0,47,255,192,255,0,0,47,249,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,127,192,0,255,128,0,255,192,0,191,208,7,255,192,0,63,255,255,239,192,0,31,255,255,79,192,0,2,255,248,15,192,0,0,21,0,0,0,0,
  // 0x0303  ̃
  3,3,14,6,24,0,238,22,1,64,1,64,47,248,3,208,127,255,155,192,254,191,255,128,240,11,255,0,144,0,100,0,
  // 0x0309  ̉
  9,3,7,10,20,0,242,21,85,0,255,240,255,252,1,252,0,252,2,248,47,240,47,64,31,0,0,0,
  // 0x0323  ̣
  35,3,5,5,10,0,242,249,25,0,63,128,127,192,127,192,30,0,
  // 0x0340  ̀
  64,3,8,7,14,0,250,22,85,0,255,128,63,192,31,240,7,248,0,253,0,41,
  // 0x0341  ́
  65,3,8,7,14,0,254,22,0,85,2,255,3,253,15,244,47,208,127,0,104,0,
  // 0x1ea0  Ạ
  160,30,24,34,204,24,0,249,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,128,0,0,0,0,15,240,0,0,0,0,15,244,0,0,0,0,15,240,0,0,0,0,3,208,0,0,
  // 0x1ea1  ạ
  161,30,18,28,140,21,1,249,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,0,0,0,0,0,0,0,100,0,0,0,1,254,0,0,0,2,255,0,0,0,1,254,0,0,0,0,184,0,0,
  // 0x1ea2  Ả
  162,30,24,37,222,24,0,0,0,0,21,64,0,0,0,0,63,248,0,0,0,0,63,254,0,0,0,0,0,127,0,0,0,0,0,63,0,0,0,0,0,254,0,0,0,0,11,248,0,0,0,0,11,192,0,0,0,0,11,192,0,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x1ea3  ả
  163,30,18,32,160,21,1,255,0,1,84,0,0,0,11,255,64,0,0,11,255,192,0,0,0,15,224,0,0,0,11,208,0,0,0,31,192,0,0,0,255,64,0,0,0,248,0,0,0,0,244,0,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x1ea4  Ấ
  164,30,24,36,216,24,0,0,0,0,0,0,7,240,0,0,0,0,15,208,0,0,15,244,47,64,0,0,63,252,124,0,0,0,191,255,0,0,0,2,252,47,128,0,0,7,224,7,224,0,0,5,64,0,80,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x1ea5  ấ
  165,30,20,31,155,21,1,255,0,0,0,0,254,0,0,0,1,252,0,2,170,3,240,0,7,255,79,128,0,15,255,208,0,0,63,71,240,0,0,253,0,252,0,0,160,0,41,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x1ea6  Ầ
  166,30,24,36,216,24,0,0,15,224,0,0,0,0,3,240,0,0,0,0,1,252,15,244,0,0,0,61,63,252,0,0,0,0,191,255,0,0,0,2,248,47,128,0,0,7,224,7,224,0,0,5,64,0,80,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x1ea7  ầ
  167,30,19,31,155,21,0,255,191,0,0,0,0,47,128,0,0,0,11,208,106,128,0,2,241,255,224,0,0,3,255,244,0,0,15,225,252,0,0,63,64,63,0,0,40,0,10,64,0,0,0,0,0,0,0,5,0,0,0,27,255,249,0,0,255,255,255,128,0,255,255,255,208,0,121,0,63,240,0,0,0,15,240,0,0,0,11,240,0,0,0,11,244,0,0,0,11,244,0,6,255,255,244,0,191,255,255,244,3,255,234,95,244,11,253,0,11,244,15,240,0,11,244,15,240,0,15,244,31,224,0,15,244,15,240,0,47,244,15,248,0,191,244,11,255,175,251,244,3,255,255,211,244,0,191,255,2,244,0,1,80,0,0,
  // 0x1ea8  Ẩ
  168,30,24,39,234,24,0,0,0,0,0,0,80,0,0,0,0,0,255,64,0,0,0,0,91,192,0,0,0,0,3,192,0,0,0,0,31,192,0,0,31,240,61,0,0,0,63,252,60,0,0,0,255,254,0,0,0,2,248,63,128,0,0,11,208,11,208,0,0,5,0,1,80,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x1ea9  ẩ
  169,30,19,33,165,21,1,255,0,0,0,15,240,0,0,0,10,248,0,0,0,0,124,0,0,0,1,248,0,1,170,7,208,0,7,255,135,128,0,15,255,208,0,0,63,135,240,0,0,189,0,252,0,0,160,0,25,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x1eaa  Ẫ
  170,30,24,39,234,24,0,0,0,0,185,0,176,0,0,3,255,209,240,0,0,7,235,255,208,0,0,11,64,191,128,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,47,252,0,0,0,0,191,254,0,0,0,1,252,47,128,0,0,7,224,7,224,0,0,5,0,0,80,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x1eab  ẫ
  171,30,18,34,170,21,1,255,0,26,64,13,0,0,127,248,61,0,0,254,255,252,0,0,240,47,244,0,0,64,1,64,0,0,1,169,0,0,0,3,255,64,0,0,15,255,192,0,0,63,135,240,0,0,253,0,252,0,0,160,0,25,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x1eac  Ậ
  172,30,24,42,252,24,0,249,0,0,5,80,0,0,0,0,47,252,0,0,0,0,127,254,0,0,0,0,255,191,64,0,0,3,248,47,208,0,0,15,224,7,244,0,0,26,64,0,164,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,0,0,0,0,15,240,0,0,0,0,15,244,0,0,0,0,15,244,0,0,0,0,2,208,0,0,
  // 0x1ead  ậ
  173,30,18,36,180,21,1,249,0,0,85,0,0,0,3,255,64,0,0,15,255,192,0,0,47,239,240,0,0,191,67,252,0,1,252,0,190,0,2,160,0,26,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,0,0,0,0,0,0,0,100,0,0,0,2,253,0,0,0,3,254,0,0,0,3,253,0,0,0,0,184,0,0,
  // 0x1eae  Ắ
  174,30,24,38,228,24,0,0,0,0,0,21,0,0,0,0,0,127,0,0,0,0,0,252,0,0,0,0,2,240,0,0,0,7,67,129,224,0,0,7,192,2,224,0,0,3,244,27,208,0,0,2,255,255,128,0,0,0,191,254,0,0,0,0,5,80,0,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x1eaf  ắ
  175,30,18,32,160,21,1,255,0,0,15,224,0,0,0,47,128,0,0,0,62,0,0,0,160,184,40,0,0,244,0,124,0,0,189,1,252,0,0,63,255,244,0,0,31,255,208,0,0,1,169,0,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x1eb0  Ằ
  176,30,24,38,228,24,0,0,0,0,84,0,0,0,0,0,254,0,0,0,0,0,63,0,0,0,0,0,15,128,0,0,0,7,66,193,224,0,0,7,192,3,224,0,0,3,244,31,208,0,0,2,255,255,128,0,0,0,191,254,0,0,0,0,5,80,0,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x1eb1  ằ
  177,30,18,32,160,21,1,255,0,47,192,0,0,0,11,208,0,0,0,2,240,0,0,0,160,184,40,0,0,244,0,124,0,0,253,1,252,0,0,63,255,240,0,0,31,255,208,0,0,1,169,0,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x1eb2  Ẳ
  178,30,24,39,234,24,0,0,0,0,10,64,0,0,0,0,15,244,0,0,0,0,0,184,0,0,0,0,0,184,0,0,0,0,3,240,0,0,0,7,67,129,224,0,0,7,192,3,224,0,0,3,244,31,208,0,0,2,255,255,128,0,0,0,191,254,0,0,0,0,5,80,0,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x1eb3  ẳ
  179,30,18,34,170,21,1,255,0,1,80,0,0,0,2,254,0,0,0,0,31,0,0,0,0,15,0,0,0,0,190,0,0,0,160,180,40,0,0,244,0,60,0,0,189,1,252,0,0,63,255,244,0,0,15,255,208,0,0,1,169,0,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x1eb4  Ẵ
  180,30,24,39,234,24,0,0,0,0,169,0,176,0,0,3,255,209,240,0,0,7,235,255,208,0,0,11,64,191,128,0,0,0,0,0,0,0,0,5,0,0,80,0,0,11,192,2,224,0,0,7,228,27,208,0,0,2,255,255,128,0,0,0,191,254,0,0,0,0,5,80,0,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x1eb5  ẵ
  181,30,18,34,170,21,1,255,0,10,64,9,0,0,63,248,46,0,0,254,255,252,0,0,240,31,244,0,0,64,0,64,0,0,80,0,20,0,0,240,0,60,0,0,253,1,252,0,0,127,255,244,0,0,31,255,208,0,0,1,169,0,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x1eb6  Ặ
  182,30,24,41,246,24,0,249,0,10,64,0,160,0,0,11,192,1,240,0,0,7,249,111,240,0,0,3,255,255,192,0,0,0,191,255,0,0,0,0,6,144,0,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,0,0,0,0,15,240,0,0,0,0,15,244,0,0,0,0,15,244,0,0,0,0,2,208,0,0,
  // 0x1eb7  ặ
  183,30,18,35,175,21,1,249,0,160,0,26,0,0,244,0,62,0,0,254,150,253,0,0,127,255,248,0,0,31,255,224,0,0,1,105,0,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,0,0,0,0,0,0,0,160,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,1,244,0,0,
  // 0x1eb8  Ẹ
  184,30,16,34,136,21,3,249,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,0,0,0,0,0,0,0,0,0,2,128,0,0,15,240,0,0,15,244,0,0,15,240,0,0,7,208,0,
  // 0x1eb9  ẹ
  185,30,18,28,140,21,2,249,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,0,0,0,0,0,0,0,160,0,0,0,3,252,0,0,0,3,253,0,0,0,3,252,0,0,0,1,244,0,0,
  // 0x1eba  Ẻ
  186,30,16,37,148,21,3,0,0,21,64,0,0,63,252,0,0,63,255,0,0,0,63,0,0,0,63,0,0,0,191,0,0,11,252,0,0,7,208,0,0,7,192,0,0,0,0,0,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,
  // 0x1ebb  ẻ
  187,30,18,32,160,21,2,255,0,1,84,0,0,0,15,255,64,0,0,15,255,192,0,0,0,15,208,0,0,0,15,208,0,0,0,47,192,0,0,1,255,0,0,0,1,244,0,0,0,0,240,0,0,0,0,0,0,0,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,
  // 0x1ebc  Ẽ
  188,30,16,34,136,21,3,0,0,16,0,20,3,255,64,124,15,255,245,252,31,239,255,244,47,1,255,224,24,0,21,0,0,0,0,0,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,
  // 0x1ebd  ẽ
  189,30,18,29,145,21,2,255,0,20,0,5,0,1,255,128,62,0,7,255,249,188,0,15,235,255,252,0,15,0,191,240,0,10,0,6,64,0,0,0,0,0,0,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,
  // 0x1ebe  Ế
  190,30,18,36,180,21,3,0,0,0,0,11,240,0,0,0,15,208,0,31,244,63,64,0,63,252,124,0,0,255,255,0,0,2,248,47,128,0,11,208,11,208,0,5,0,0,80,0,0,0,0,0,0,21,85,85,84,0,127,255,255,253,0,127,255,255,253,0,127,255,255,253,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,149,85,84,0,127,255,255,248,0,127,255,255,248,0,127,255,255,248,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,149,85,84,0,127,255,255,253,0,127,255,255,253,0,127,255,255,253,0,
  // 0x1ebf  ế
  191,30,19,31,155,21,2,255,0,0,0,2,252,0,0,0,3,244,0,6,168,15,208,0,15,255,47,0,0,63,255,128,0,0,190,15,208,0,2,248,2,244,0,2,144,0,100,0,0,0,0,0,0,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,
  // 0x1ec0  Ề
  192,30,18,36,180,21,1,0,254,0,0,0,0,63,0,0,0,0,15,192,255,64,0,3,211,255,192,0,0,11,255,240,0,0,47,194,248,0,0,126,0,126,0,0,84,0,5,0,0,0,0,0,0,1,85,85,85,64,7,255,255,255,208,7,255,255,255,208,7,255,255,255,208,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,249,85,85,64,7,255,255,255,128,7,255,255,255,128,7,255,255,255,128,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,249,85,85,64,7,255,255,255,208,7,255,255,255,208,7,255,255,255,208,
  // 0x1ec1  ề
  193,30,19,31,155,21,1,255,253,0,0,0,0,127,0,0,0,0,31,128,170,0,0,7,211,255,192,0,0,11,255,224,0,0,47,195,248,0,0,126,0,189,0,0,164,0,26,0,0,0,0,0,0,0,0,20,0,0,0,11,255,224,0,0,191,255,253,0,2,255,255,255,64,7,253,0,127,192,15,240,0,47,224,31,224,0,15,240,47,208,0,11,240,63,192,0,11,244,63,255,255,255,244,63,255,255,255,244,63,255,255,255,244,63,192,0,0,0,63,192,0,0,0,47,208,0,0,0,31,240,0,0,0,15,248,0,0,0,7,254,0,2,208,2,255,255,255,208,0,191,255,255,208,0,11,255,254,64,0,0,21,64,0,
  // 0x1ec2  Ể
  194,30,17,39,195,21,3,0,0,0,0,80,0,0,0,0,255,64,0,0,0,91,192,0,0,0,3,192,0,0,0,31,192,0,31,240,61,0,0,63,252,60,0,0,255,254,0,0,2,248,63,128,0,11,208,11,208,0,5,0,1,80,0,0,0,0,0,0,21,85,85,84,0,127,255,255,253,0,127,255,255,253,0,127,255,255,253,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,149,85,84,0,127,255,255,248,0,127,255,255,248,0,127,255,255,248,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,149,85,84,0,127,255,255,253,0,127,255,255,253,0,127,255,255,253,0,
  // 0x1ec3  ể
  195,30,18,33,165,21,2,255,0,0,0,63,192,0,0,0,43,224,0,0,0,1,240,0,0,0,7,224,0,6,168,31,64,0,31,254,30,0,0,63,255,64,0,0,254,15,208,0,2,244,3,240,0,2,128,0,100,0,0,0,0,0,0,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,
  // 0x1ec4  Ễ
  196,30,16,39,156,21,3,0,0,185,0,240,3,255,210,224,11,239,255,208,15,0,191,128,0,0,0,0,0,10,160,0,0,63,252,0,0,191,254,0,2,248,63,64,7,208,11,208,5,0,0,80,0,0,0,0,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,
  // 0x1ec5  ễ
  197,30,18,34,170,21,2,255,0,42,0,40,0,0,255,224,184,0,2,251,255,240,0,3,192,127,208,0,1,64,1,0,0,0,2,168,0,0,0,15,254,0,0,0,47,255,64,0,0,190,31,208,0,2,248,2,240,0,2,128,0,100,0,0,0,0,0,0,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,
  // 0x1ec6  Ệ
  198,30,16,42,168,21,3,249,0,5,80,0,0,31,252,0,0,63,254,0,0,255,191,128,3,252,31,208,15,224,7,244,10,64,0,168,0,0,0,0,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,0,0,0,0,0,0,0,0,0,2,128,0,0,15,240,0,0,15,244,0,0,15,240,0,0,7,208,0,
  // 0x1ec7  ệ
  199,30,18,36,180,21,2,249,0,1,84,0,0,0,15,253,0,0,0,63,255,0,0,0,191,191,192,0,1,253,15,240,0,7,240,2,252,0,10,128,0,104,0,0,0,0,0,0,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,0,0,0,0,0,0,0,160,0,0,0,3,252,0,0,0,3,253,0,0,0,3,252,0,0,0,1,244,0,0,
  // 0x1ec8  Ỉ
  200,30,11,37,111,13,1,0,1,164,0,7,255,128,7,255,224,0,7,240,0,7,224,0,31,208,0,255,64,0,252,0,0,188,0,0,0,0,85,85,84,191,255,248,191,255,248,11,255,128,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,2,254,0,47,255,228,191,255,248,191,255,248,
  // 0x1ec9  ỉ
  201,30,8,31,62,10,2,0,21,64,255,240,255,252,0,253,0,253,2,252,31,240,31,64,15,0,0,0,0,0,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,
  // 0x1eca  Ị
  202,30,11,34,102,13,1,249,85,85,84,191,255,248,191,255,248,11,255,128,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,2,254,0,47,255,228,191,255,248,191,255,248,0,0,0,0,0,0,0,100,0,1,253,0,2,254,0,2,254,0,0,184,0,
  // 0x1ecb  ị
  203,30,5,35,70,10,3,249,20,0,255,0,255,0,255,0,125,0,0,0,0,0,0,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,0,0,0,0,40,0,255,0,255,64,255,0,125,0,
  // 0x1ecc  Ọ
  204,30,25,34,238,29,2,249,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,0,0,0,0,0,0,0,0,0,1,144,0,0,0,0,0,7,244,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,2,224,0,0,0,
  // 0x1ecd  ọ
  205,30,19,28,140,23,2,249,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,0,0,0,0,0,0,0,96,0,0,0,3,252,0,0,0,3,253,0,0,0,3,253,0,0,0,0,180,0,0,
  // 0x1ece  Ỏ
  206,30,25,38,10,29,2,255,0,0,6,144,0,0,0,0,0,31,254,0,0,0,0,0,31,255,128,0,0,0,0,0,31,192,0,0,0,0,0,31,128,0,0,0,0,0,127,64,0,0,0,0,3,253,0,0,0,0,0,3,240,0,0,0,0,0,2,224,0,0,0,0,0,0,0,0,0,0,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x1ecf  ỏ
  207,30,19,32,160,23,2,255,0,1,84,0,0,0,11,255,64,0,0,11,255,192,0,0,0,15,208,0,0,0,11,208,0,0,0,31,192,0,0,0,255,64,0,0,0,248,0,0,0,0,244,0,0,0,0,0,0,0,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,
  // 0x1ed0  Ố
  208,30,25,37,3,29,2,255,0,0,0,0,3,248,0,0,0,0,0,11,224,0,0,0,11,248,31,128,0,0,0,47,254,62,0,0,0,0,127,191,64,0,0,0,0,253,31,192,0,0,0,3,240,3,240,0,0,0,1,64,0,80,0,0,0,0,0,0,0,0,0,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x1ed1  ố
  209,30,20,31,155,23,2,255,0,0,0,1,253,0,0,0,3,248,0,2,169,11,224,0,15,255,15,64,0,47,255,192,0,0,127,11,224,0,0,248,1,248,0,1,144,0,40,0,0,0,0,0,0,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,
  // 0x1ed2  Ồ
  210,30,25,37,3,29,2,255,11,240,0,0,0,0,0,2,248,0,0,0,0,0,0,189,11,248,0,0,0,0,47,31,254,0,0,0,0,0,127,191,64,0,0,0,0,253,31,192,0,0,0,3,240,3,240,0,0,0,1,64,0,80,0,0,0,0,0,0,0,0,0,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x1ed3  ồ
  211,30,20,31,155,23,1,255,254,0,0,0,0,63,64,0,0,0,15,192,170,64,0,3,226,255,192,0,0,7,255,240,0,0,31,194,252,0,0,63,0,126,0,0,100,0,10,0,0,0,0,0,0,0,0,4,0,0,0,11,255,244,0,0,191,255,255,0,2,255,255,255,192,7,254,0,127,240,15,244,0,15,244,31,240,0,7,252,47,208,0,3,252,63,192,0,2,253,63,192,0,1,254,63,192,0,1,254,63,192,0,1,254,63,192,0,1,254,63,192,0,2,253,47,208,0,3,252,31,240,0,7,252,15,244,0,15,248,7,254,0,127,240,2,255,255,255,192,0,127,255,255,0,0,11,255,244,0,0,0,21,0,0,
  // 0x1ed4  Ổ
  212,30,25,40,24,29,2,255,0,0,0,0,20,0,0,0,0,0,0,127,128,0,0,0,0,0,23,208,0,0,0,0,0,2,224,0,0,0,0,0,7,208,0,0,0,11,248,47,0,0,0,0,47,253,45,0,0,0,0,127,191,64,0,0,0,0,253,31,192,0,0,0,3,240,3,240,0,0,0,1,64,0,80,0,0,0,0,0,0,0,0,0,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x1ed5  ổ
  213,30,19,33,165,23,2,255,0,0,0,47,208,0,0,0,26,240,0,0,0,0,244,0,0,0,2,240,0,2,169,15,128,0,15,255,15,0,0,47,255,192,0,0,127,11,224,0,0,248,1,248,0,1,144,0,40,0,0,0,0,0,0,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,
  // 0x1ed6  Ỗ
  214,30,25,40,24,29,2,255,0,0,110,0,116,0,0,0,1,255,224,244,0,0,0,3,235,255,240,0,0,0,7,128,127,192,0,0,0,1,0,0,0,0,0,0,0,6,164,0,0,0,0,0,31,253,0,0,0,0,0,63,255,0,0,0,0,0,253,31,192,0,0,0,3,240,3,240,0,0,0,1,64,0,80,0,0,0,0,0,0,0,0,0,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x1ed7  ỗ
  215,30,19,34,170,23,2,255,0,26,64,28,0,0,191,244,60,0,0,251,255,248,0,2,208,47,240,0,1,64,1,0,0,0,1,168,0,0,0,7,255,0,0,0,31,255,192,0,0,63,75,224,0,0,252,1,248,0,1,144,0,40,0,0,0,0,0,0,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,
  // 0x1ed8  Ộ
  216,30,25,42,38,29,2,249,0,0,1,84,0,0,0,0,0,15,253,0,0,0,0,0,63,255,0,0,0,0,0,191,191,192,0,0,0,2,253,15,224,0,0,0,7,240,3,248,0,0,0,10,128,0,104,0,0,0,0,0,0,0,0,0,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,0,0,0,0,0,0,0,0,0,1,144,0,0,0,0,0,7,244,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,2,224,0,0,0,
  // 0x1ed9  ộ
  217,30,19,36,180,23,2,249,0,1,84,0,0,0,7,255,0,0,0,15,255,128,0,0,63,239,224,0,0,255,7,248,0,2,248,1,253,0,2,144,0,42,0,0,0,0,0,0,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,0,0,0,0,0,0,0,96,0,0,0,3,252,0,0,0,3,253,0,0,0,3,253,0,0,0,0,180,0,0,
  // 0x1eda  Ớ
  218,30,28,36,252,29,2,255,0,0,0,5,80,0,0,0,0,0,63,240,0,0,0,0,0,127,192,0,0,0,0,0,255,0,0,0,0,0,3,252,0,0,0,0,0,11,240,0,0,0,0,0,10,128,0,0,0,0,0,0,0,0,0,255,0,0,107,234,64,0,255,0,11,255,255,248,1,254,0,127,255,255,255,66,253,1,255,254,175,255,215,252,3,255,128,0,127,255,240,15,252,0,0,15,255,128,31,244,0,0,3,254,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,1,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x1edb  ớ
  219,30,23,30,180,24,2,255,0,0,1,84,0,0,0,0,15,248,0,0,0,0,47,224,0,0,0,0,127,128,0,0,0,0,254,0,0,0,0,3,248,0,0,0,0,2,144,0,11,248,0,0,0,0,11,244,0,0,16,0,15,240,0,47,255,208,15,240,2,255,255,252,63,208,11,255,255,255,255,128,31,248,1,255,253,0,63,208,0,63,224,0,127,192,0,15,240,0,191,64,0,15,240,0,255,0,0,11,244,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,11,244,0,191,64,0,15,240,0,127,192,0,15,240,0,63,208,0,63,224,0,31,248,0,255,192,0,11,255,255,255,0,0,1,255,255,252,0,0,0,47,255,208,0,0,0,0,84,0,0,0,
  // 0x1edc  Ờ
  220,30,28,36,252,29,2,255,0,1,84,0,0,0,0,0,2,255,0,0,0,0,0,0,191,128,0,0,0,0,0,47,208,0,0,0,0,0,11,240,0,0,0,0,0,2,252,0,0,0,0,0,0,104,0,0,0,0,0,0,0,0,0,255,0,0,107,234,64,0,255,0,11,255,255,248,1,254,0,127,255,255,255,66,253,1,255,254,175,255,215,252,3,255,128,0,127,255,240,15,252,0,0,15,255,128,31,244,0,0,3,254,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,1,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x1edd  ờ
  221,30,23,30,180,24,2,255,0,85,0,0,0,0,0,255,192,0,0,0,0,63,208,0,0,0,0,15,240,0,0,0,0,3,252,0,0,0,0,0,254,0,0,0,0,0,26,0,11,248,0,0,0,0,11,244,0,0,16,0,15,240,0,47,255,208,15,240,2,255,255,252,63,208,11,255,255,255,255,128,31,248,1,255,253,0,63,208,0,63,224,0,127,192,0,15,240,0,191,64,0,15,240,0,255,0,0,11,244,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,11,244,0,191,64,0,15,240,0,127,192,0,15,240,0,63,208,0,63,224,0,31,248,0,255,192,0,11,255,255,255,0,0,1,255,255,252,0,0,0,47,255,208,0,0,0,0,84,0,0,0,
  // 0x1ede  Ở
  222,30,28,38,10,29,2,255,0,0,5,80,0,0,0,0,0,47,253,0,0,0,0,0,47,255,0,0,0,0,0,0,63,64,0,0,0,0,0,47,64,0,0,0,0,0,127,0,0,0,0,0,7,253,0,0,0,0,0,3,224,0,0,0,0,0,3,208,0,0,0,0,0,0,0,0,0,255,0,0,107,234,64,0,255,0,11,255,255,248,1,254,0,127,255,255,255,66,253,1,255,254,175,255,215,252,3,255,128,0,127,255,240,15,252,0,0,15,255,128,31,244,0,0,3,254,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,1,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x1edf  ở
  223,30,23,32,192,24,2,255,0,5,80,0,0,0,0,15,255,0,0,0,0,15,255,192,0,0,0,0,15,192,0,0,0,0,15,192,0,0,0,0,47,192,0,0,0,2,255,0,0,0,0,1,244,0,0,0,0,1,240,0,11,248,0,0,0,0,11,244,0,0,16,0,15,240,0,47,255,208,15,240,2,255,255,252,63,208,11,255,255,255,255,128,31,248,1,255,253,0,63,208,0,63,224,0,127,192,0,15,240,0,191,64,0,15,240,0,255,0,0,11,244,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,11,244,0,191,64,0,15,240,0,127,192,0,15,240,0,63,208,0,63,224,0,31,248,0,255,192,0,11,255,255,255,0,0,1,255,255,252,0,0,0,47,255,208,0,0,0,0,84,0,0,0,
  // 0x1ee0  Ỡ
  224,30,28,35,245,29,2,255,0,0,20,0,20,0,0,0,2,255,128,61,0,0,0,11,255,249,252,0,0,0,15,235,255,248,0,0,0,31,0,191,240,0,0,0,25,0,6,64,0,0,0,0,0,0,0,0,255,0,0,107,234,64,0,255,0,11,255,255,248,1,254,0,127,255,255,255,66,253,1,255,254,175,255,215,252,3,255,128,0,127,255,240,15,252,0,0,15,255,128,31,244,0,0,3,254,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,1,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x1ee1  ỡ
  225,30,23,29,174,24,2,255,0,4,0,5,0,0,0,255,208,15,0,0,3,255,253,127,0,0,7,251,255,253,0,0,11,192,127,248,0,0,6,64,5,64,11,248,0,0,0,0,11,244,0,0,16,0,15,240,0,47,255,208,15,240,2,255,255,252,63,208,11,255,255,255,255,128,31,248,1,255,253,0,63,208,0,63,224,0,127,192,0,15,240,0,191,64,0,15,240,0,255,0,0,11,244,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,11,244,0,191,64,0,15,240,0,127,192,0,15,240,0,63,208,0,63,224,0,31,248,0,255,192,0,11,255,255,255,0,0,1,255,255,252,0,0,0,47,255,208,0,0,0,0,84,0,0,0,
  // 0x1ee2  Ợ
  226,30,28,35,245,29,2,249,0,0,0,0,0,0,255,0,0,107,234,64,0,255,0,11,255,255,248,1,254,0,127,255,255,255,66,253,1,255,254,175,255,215,252,3,255,128,0,127,255,240,15,252,0,0,15,255,128,31,244,0,0,3,254,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,1,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,0,0,0,0,0,0,0,0,0,1,144,0,0,0,0,0,11,244,0,0,0,0,0,15,248,0,0,0,0,0,11,248,0,0,0,0,0,2,224,0,0,0,
  // 0x1ee3  ợ
  227,30,23,30,180,24,2,249,0,0,0,0,11,248,0,0,0,0,11,244,0,0,16,0,15,240,0,47,255,208,15,240,2,255,255,252,63,208,11,255,255,255,255,128,31,248,1,255,253,0,63,208,0,63,224,0,127,192,0,15,240,0,191,64,0,15,240,0,255,0,0,11,244,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,11,244,0,191,64,0,15,240,0,127,192,0,15,240,0,63,208,0,63,224,0,31,248,0,255,192,0,11,255,255,255,0,0,1,255,255,252,0,0,0,47,255,208,0,0,0,0,84,0,0,0,0,0,0,0,0,0,0,0,100,0,0,0,0,2,252,0,0,0,0,3,253,0,0,0,0,3,253,0,0,0,0,0,180,0,0,0,
  // 0x1ee4  Ụ
  228,30,21,34,204,27,3,249,85,0,0,0,21,64,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,128,0,0,63,192,127,192,0,0,127,128,63,208,0,0,255,64,47,240,0,2,255,0,15,254,64,31,253,0,7,255,255,255,244,0,0,255,255,255,208,0,0,31,255,254,0,0,0,0,21,64,0,0,0,0,0,0,0,0,0,0,25,0,0,0,0,0,127,128,0,0,0,0,191,192,0,0,0,0,127,128,0,0,0,0,46,0,0,0,
  // 0x1ee5  ụ
  229,30,17,27,135,23,3,249,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,192,255,128,0,255,192,191,208,7,255,192,63,255,255,239,192,31,255,255,79,192,2,255,248,15,192,0,21,0,0,0,0,0,0,0,0,0,2,128,0,0,0,15,240,0,0,0,15,244,0,0,0,15,240,0,0,0,7,208,0,0,
  // 0x1ee6  Ủ
  230,30,21,38,228,27,3,255,0,0,105,0,0,0,0,1,255,224,0,0,0,1,255,244,0,0,0,0,1,252,0,0,0,0,1,248,0,0,0,0,7,244,0,0,0,0,63,208,0,0,0,0,63,0,0,0,0,0,46,0,0,0,0,0,0,0,0,0,85,0,0,0,21,64,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,128,0,0,63,192,127,192,0,0,127,128,63,208,0,0,255,64,47,240,0,2,255,0,15,254,64,31,253,0,7,255,255,255,244,0,0,255,255,255,208,0,0,31,255,254,0,0,0,0,21,64,0,0,
  // 0x1ee7  ủ
  231,30,17,32,160,23,3,255,0,5,80,0,0,0,31,254,0,0,0,31,255,64,0,0,0,47,128,0,0,0,31,128,0,0,0,127,64,0,0,3,253,0,0,0,3,240,0,0,0,3,224,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,192,255,128,0,255,192,191,208,7,255,192,63,255,255,239,192,31,255,255,79,192,2,255,248,15,192,0,21,0,0,0,
  // 0x1ee8  Ứ
  232,30,28,36,252,30,3,255,0,0,0,85,0,0,0,0,0,2,255,0,0,0,0,0,7,252,0,0,0,0,0,15,240,0,0,0,0,0,47,192,0,0,0,0,0,127,0,0,0,0,0,0,104,0,0,0,0,0,0,0,0,0,0,255,85,0,0,0,21,65,255,191,64,0,0,63,194,253,191,64,0,0,63,195,252,191,64,0,0,63,203,248,191,64,0,0,63,255,224,191,64,0,0,63,255,128,191,64,0,0,63,228,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,127,192,0,0,127,128,0,63,208,0,0,255,64,0,47,240,0,2,255,0,0,15,254,64,31,253,0,0,3,255,255,255,248,0,0,0,255,255,255,208,0,0,0,31,255,254,0,0,0,0,0,21,64,0,0,0,
  // 0x1ee9  ứ
  233,30,24,30,180,26,3,255,0,0,5,80,0,0,0,0,47,240,0,0,0,0,127,192,0,0,0,0,255,0,0,0,0,2,252,0,0,0,0,7,240,0,0,0,0,10,128,0,0,255,0,0,0,0,0,255,0,0,0,0,1,254,255,0,0,47,194,253,255,0,0,47,199,252,255,0,0,47,255,240,255,0,0,47,255,192,255,0,0,47,249,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,127,192,0,255,128,0,255,192,0,191,208,7,255,192,0,63,255,255,239,192,0,31,255,255,79,192,0,2,255,248,15,192,0,0,21,0,0,0,0,
  // 0x1eea  Ừ
  234,30,28,36,252,30,3,255,0,21,80,0,0,0,0,0,31,240,0,0,0,0,0,11,252,0,0,0,0,0,2,254,0,0,0,0,0,0,191,64,0,0,0,0,0,31,192,0,0,0,0,0,6,144,0,0,0,0,0,0,0,0,0,255,85,0,0,0,21,65,255,191,64,0,0,63,194,253,191,64,0,0,63,195,252,191,64,0,0,63,203,248,191,64,0,0,63,255,224,191,64,0,0,63,255,128,191,64,0,0,63,228,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,127,192,0,0,127,128,0,63,208,0,0,255,64,0,47,240,0,2,255,0,0,15,254,64,31,253,0,0,3,255,255,255,248,0,0,0,255,255,255,208,0,0,0,31,255,254,0,0,0,0,0,21,64,0,0,0,
  // 0x1eeb  ừ
  235,30,24,30,180,26,3,255,1,85,0,0,0,0,1,255,0,0,0,0,0,191,192,0,0,0,0,47,208,0,0,0,0,11,240,0,0,0,0,1,252,0,0,0,0,0,105,0,0,255,0,0,0,0,0,255,0,0,0,0,1,254,255,0,0,47,194,253,255,0,0,47,199,252,255,0,0,47,255,240,255,0,0,47,255,192,255,0,0,47,249,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,127,192,0,255,128,0,255,192,0,191,208,7,255,192,0,63,255,255,239,192,0,31,255,255,79,192,0,2,255,248,15,192,0,0,21,0,0,0,0,
  // 0x1eec  Ử
  236,30,28,38,10,30,3,255,0,0,105,64,0,0,0,0,0,255,240,0,0,0,0,0,255,248,0,0,0,0,0,1,252,0,0,0,0,0,0,252,0,0,0,0,0,7,248,0,0,0,0,0,63,224,0,0,0,0,0,47,0,0,0,0,0,0,47,0,0,0,0,0,0,0,0,0,0,255,85,0,0,0,21,65,255,191,64,0,0,63,194,253,191,64,0,0,63,195,252,191,64,0,0,63,203,248,191,64,0,0,63,255,224,191,64,0,0,63,255,128,191,64,0,0,63,228,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,127,192,0,0,127,128,0,63,208,0,0,255,64,0,47,240,0,2,255,0,0,15,254,64,31,253,0,0,3,255,255,255,248,0,0,0,255,255,255,208,0,0,0,31,255,254,0,0,0,0,0,21,64,0,0,0,
  // 0x1eed  ử
  237,30,24,32,192,26,3,255,0,5,80,0,0,0,0,31,254,0,0,0,0,31,255,64,0,0,0,0,47,128,0,0,0,0,31,128,0,0,0,0,127,64,0,0,0,3,254,0,0,0,0,3,240,0,0,0,0,3,224,0,0,255,0,0,0,0,0,255,0,0,0,0,1,254,255,0,0,47,194,253,255,0,0,47,199,252,255,0,0,47,255,240,255,0,0,47,255,192,255,0,0,47,249,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,127,192,0,255,128,0,255,192,0,191,208,7,255,192,0,63,255,255,239,192,0,31,255,255,79,192,0,2,255,248,15,192,0,0,21,0,0,0,0,
  // 0x1eee  Ữ
  238,30,28,35,245,30,3,255,0,1,64,0,80,0,0,0,31,248,3,224,0,0,0,127,255,155,192,0,0,0,254,191,255,192,0,0,0,240,11,255,0,0,0,0,160,0,100,0,0,0,0,0,0,0,0,0,255,85,0,0,0,21,65,255,191,64,0,0,63,194,253,191,64,0,0,63,195,252,191,64,0,0,63,203,248,191,64,0,0,63,255,224,191,64,0,0,63,255,128,191,64,0,0,63,228,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,127,192,0,0,127,128,0,63,208,0,0,255,64,0,47,240,0,2,255,0,0,15,254,64,31,253,0,0,3,255,255,255,248,0,0,0,255,255,255,208,0,0,0,31,255,254,0,0,0,0,0,21,64,0,0,0,
  // 0x1eef  ữ
  239,30,24,29,174,26,3,255,0,20,0,4,0,0,2,255,128,61,0,0,7,255,249,188,0,0,15,235,255,248,0,0,15,0,191,240,0,0,9,0,6,64,0,255,0,0,0,0,0,255,0,0,0,0,1,254,255,0,0,47,194,253,255,0,0,47,199,252,255,0,0,47,255,240,255,0,0,47,255,192,255,0,0,47,249,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,127,192,0,255,128,0,255,192,0,191,208,7,255,192,0,63,255,255,239,192,0,31,255,255,79,192,0,2,255,248,15,192,0,0,21,0,0,0,0,
  // 0x1ef0  Ự
  240,30,28,35,245,30,3,249,0,0,0,0,0,0,255,85,0,0,0,21,65,255,191,64,0,0,63,194,253,191,64,0,0,63,195,252,191,64,0,0,63,203,248,191,64,0,0,63,255,224,191,64,0,0,63,255,128,191,64,0,0,63,228,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,191,64,0,0,63,192,0,127,192,0,0,127,128,0,63,208,0,0,255,64,0,47,240,0,2,255,0,0,15,254,64,31,253,0,0,3,255,255,255,248,0,0,0,255,255,255,208,0,0,0,31,255,254,0,0,0,0,0,21,64,0,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,0,0,0,127,128,0,0,0,0,0,127,192,0,0,0,0,0,127,192,0,0,0,0,0,46,0,0,0,0,
  // 0x1ef1  ự
  241,30,24,30,180,26,3,249,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,1,254,255,0,0,47,194,253,255,0,0,47,199,252,255,0,0,47,255,240,255,0,0,47,255,192,255,0,0,47,249,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,47,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,127,192,0,255,128,0,255,192,0,191,208,7,255,192,0,63,255,255,239,192,0,31,255,255,79,192,0,2,255,248,15,192,0,0,21,0,0,0,0,0,0,0,0,0,0,0,2,128,0,0,0,0,15,240,0,0,0,0,15,244,0,0,0,0,15,240,0,0,0,0,7,208,0,0,0,
  // 0x1ef2  Ỳ
  242,30,21,35,210,22,0,0,0,5,80,0,0,0,0,15,244,0,0,0,0,7,252,0,0,0,0,1,255,0,0,0,0,0,127,64,0,0,0,0,15,208,0,0,0,0,2,144,0,0,0,0,0,0,0,0,85,0,0,0,21,64,191,192,0,0,63,192,63,208,0,0,191,128,31,240,0,1,255,0,15,244,0,3,253,0,7,252,0,7,252,0,3,253,0,15,244,0,1,255,0,31,240,0,0,191,64,63,208,0,0,63,192,127,128,0,0,47,224,255,0,0,0,15,241,254,0,0,0,11,251,252,0,0,0,3,255,248,0,0,0,1,255,240,0,0,0,0,255,208,0,0,0,0,127,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,
  // 0x1ef3  ỳ
  243,30,20,38,190,20,0,247,0,21,64,0,0,0,63,208,0,0,0,31,240,0,0,0,7,252,0,0,0,1,253,0,0,0,0,127,0,0,0,0,10,64,0,0,0,0,0,0,0,0,0,0,0,191,64,0,3,253,127,192,0,3,252,63,192,0,11,248,47,224,0,15,240,15,240,0,31,240,15,240,0,47,208,7,248,0,63,192,3,252,0,127,128,2,253,0,191,64,0,254,0,255,0,0,255,1,254,0,0,127,66,252,0,0,63,195,252,0,0,47,199,244,0,0,15,219,240,0,0,15,239,224,0,0,7,255,208,0,0,3,255,192,0,0,2,255,128,0,0,0,255,0,0,0,0,255,0,0,0,2,253,0,0,0,3,252,0,0,0,7,248,0,0,0,31,240,0,0,21,191,224,0,0,127,255,128,0,0,127,254,0,0,0,47,224,0,0,0,
  // 0x1ef4  Ỵ
  244,30,21,34,204,22,0,249,85,0,0,0,21,64,191,192,0,0,63,192,63,208,0,0,191,128,31,240,0,1,255,0,15,244,0,3,253,0,7,252,0,7,252,0,3,253,0,15,244,0,1,255,0,31,240,0,0,191,64,63,208,0,0,63,192,127,128,0,0,47,224,255,0,0,0,15,241,254,0,0,0,11,251,252,0,0,0,3,255,248,0,0,0,1,255,240,0,0,0,0,255,208,0,0,0,0,127,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,0,0,127,128,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,46,0,0,0,
  // 0x1ef5  ỵ
  245,30,20,29,145,20,0,247,191,64,0,3,253,127,192,0,3,252,63,192,0,11,248,47,224,0,15,240,15,240,0,31,240,15,240,0,47,208,7,248,0,63,192,3,252,0,127,128,2,253,0,191,64,0,254,0,255,0,0,255,1,254,0,0,127,66,252,0,0,63,195,252,0,0,47,199,244,0,0,15,219,240,0,0,15,239,224,0,0,7,255,208,0,0,3,255,192,0,0,2,255,128,0,0,0,255,0,0,0,0,255,0,0,0,2,253,0,0,0,3,252,10,0,0,7,248,63,192,0,31,240,63,192,21,191,224,63,192,127,255,128,31,64,127,254,0,0,0,47,224,0,0,0,
  // 0x1ef6  Ỷ
  246,30,21,37,222,22,0,0,0,0,105,64,0,0,0,0,255,240,0,0,0,0,255,248,0,0,0,0,1,252,0,0,0,0,0,252,0,0,0,0,7,248,0,0,0,0,63,224,0,0,0,0,47,0,0,0,0,0,47,0,0,0,0,0,0,0,0,0,85,0,0,0,21,64,191,192,0,0,63,192,63,208,0,0,191,128,31,240,0,1,255,0,15,244,0,3,253,0,7,252,0,7,252,0,3,253,0,15,244,0,1,255,0,31,240,0,0,191,64,63,208,0,0,63,192,127,128,0,0,47,224,255,0,0,0,15,241,254,0,0,0,11,251,252,0,0,0,3,255,248,0,0,0,1,255,240,0,0,0,0,255,208,0,0,0,0,127,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,
  // 0x1ef7  ỷ
  247,30,20,40,200,20,0,247,0,1,84,0,0,0,7,255,128,0,0,7,255,224,0,0,0,7,240,0,0,0,3,240,0,0,0,31,224,0,0,0,255,128,0,0,0,252,0,0,0,0,188,0,0,0,0,0,0,0,0,0,0,0,0,191,64,0,3,253,127,192,0,3,252,63,192,0,11,248,47,224,0,15,240,15,240,0,31,240,15,240,0,47,208,7,248,0,63,192,3,252,0,127,128,2,253,0,191,64,0,254,0,255,0,0,255,1,254,0,0,127,66,252,0,0,63,195,252,0,0,47,199,244,0,0,15,219,240,0,0,15,239,224,0,0,7,255,208,0,0,3,255,192,0,0,2,255,128,0,0,0,255,0,0,0,0,255,0,0,0,2,253,0,0,0,3,252,0,0,0,7,248,0,0,0,31,240,0,0,21,191,224,0,0,127,255,128,0,0,127,254,0,0,0,47,224,0,0,0,
  // 0x1ef8  Ỹ
  248,30,21,34,204,22,0,0,0,1,64,0,80,0,0,31,248,2,224,0,0,127,255,155,208,0,0,254,191,255,192,0,0,244,11,255,0,0,0,160,0,100,0,0,0,0,0,0,0,0,85,0,0,0,21,64,191,192,0,0,63,192,63,208,0,0,191,128,31,240,0,1,255,0,15,244,0,3,253,0,7,252,0,7,252,0,3,253,0,15,244,0,1,255,0,31,240,0,0,191,64,63,208,0,0,63,192,127,128,0,0,47,224,255,0,0,0,15,241,254,0,0,0,11,251,252,0,0,0,3,255,248,0,0,0,1,255,240,0,0,0,0,255,208,0,0,0,0,127,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,
  // 0x1ef9  ỹ
  249,30,20,37,185,20,0,247,0,5,0,1,64,0,127,224,11,128,1,255,254,111,64,3,250,255,255,0,3,208,47,252,0,2,128,1,144,0,0,0,0,0,0,0,0,0,0,0,191,64,0,3,253,127,192,0,3,252,63,192,0,11,248,47,224,0,15,240,15,240,0,31,240,15,240,0,47,208,7,248,0,63,192,3,252,0,127,128,2,253,0,191,64,0,254,0,255,0,0,255,1,254,0,0,127,66,252,0,0,63,195,252,0,0,47,199,244,0,0,15,219,240,0,0,15,239,224,0,0,7,255,208,0,0,3,255,192,0,0,2,255,128,0,0,0,255,0,0,0,0,255,0,0,0,2,253,0,0,0,3,252,0,0,0,7,248,0,0,0,31,240,0,0,21,191,224,0,0,127,255,128,0,0,127,254,0,0,0,47,224,0,0,0,
};

#endif // HAS_GRAPHICAL_TFT
