/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Latin Extended-A 37pt, capital 'A' height: 27px, width: 100%, range: 0x0100-0x017f
extern const uint8_t NotoSans_Medium_Latin_Extended_A_27[20794] = {
  130,27,0,1,127,1,35,247, // unifont_t
  // 0x0100  Ā
  24,32,192,24,0,0,0,1,85,85,80,0,0,11,255,255,224,0,0,11,255,255,224,0,0,6,170,170,144,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x0101  ā
  18,27,135,21,1,255,0,85,85,84,0,0,255,255,253,0,0,255,255,253,0,0,170,170,168,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x0102  Ă
  24,34,204,24,0,0,0,10,0,0,160,0,0,15,128,2,240,0,0,11,249,111,224,0,0,3,255,255,192,0,0,0,255,254,0,0,0,0,6,144,0,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x0103  ă
  18,29,145,21,1,255,1,160,0,26,0,1,240,0,62,0,0,254,86,252,0,0,127,255,248,0,0,31,255,208,0,0,1,169,0,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x0104  Ą
  24,36,216,24,0,247,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,0,0,0,0,1,248,0,0,0,0,3,224,0,0,0,0,15,192,0,0,0,0,31,128,0,0,0,0,31,128,0,0,0,0,31,209,0,0,0,0,15,255,0,0,0,0,7,255,0,0,0,0,0,84,
  // 0x0105  ą
  18,30,150,21,1,247,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,15,208,0,5,64,15,128,0,0,0,63,0,0,0,0,188,0,0,0,0,248,0,0,0,1,248,0,0,0,0,253,16,0,0,0,255,240,0,0,0,63,240,0,0,0,1,64,
  // 0x0106  Ć
  20,36,180,23,2,255,0,0,0,5,80,0,0,0,63,240,0,0,0,191,192,0,0,0,255,0,0,0,3,252,0,0,0,11,224,0,0,0,10,64,0,0,0,0,0,0,0,0,26,234,64,0,7,255,255,253,0,47,255,255,255,0,255,255,175,253,3,255,208,0,108,11,254,0,0,0,15,248,0,0,0,47,240,0,0,0,63,208,0,0,0,127,192,0,0,0,127,192,0,0,0,191,128,0,0,0,191,64,0,0,0,255,64,0,0,0,255,64,0,0,0,191,128,0,0,0,191,128,0,0,0,127,192,0,0,0,63,192,0,0,0,63,208,0,0,0,47,240,0,0,0,15,248,0,0,0,11,254,0,0,0,3,255,228,1,188,0,255,255,255,252,0,47,255,255,252,0,2,255,255,244,0,0,5,84,0,
  // 0x0107  ć
  15,30,120,18,2,255,0,0,5,84,0,0,31,244,0,0,63,208,0,0,191,64,0,1,253,0,0,3,244,0,0,6,128,0,0,0,0,0,0,0,84,0,0,47,255,228,2,255,255,248,11,255,255,244,31,253,1,176,63,224,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,191,64,0,0,127,192,0,0,63,208,0,0,47,248,0,120,15,255,255,248,2,255,255,248,0,127,255,224,0,1,84,0,
  // 0x0108  Ĉ
  20,36,180,23,2,255,0,0,5,80,0,0,0,47,248,0,0,0,127,253,0,0,1,254,191,64,0,3,248,47,192,0,15,208,7,240,0,26,0,0,164,0,0,0,0,0,0,0,26,234,64,0,7,255,255,253,0,47,255,255,255,0,255,255,175,253,3,255,208,0,108,11,254,0,0,0,15,248,0,0,0,47,240,0,0,0,63,208,0,0,0,127,192,0,0,0,127,192,0,0,0,191,128,0,0,0,191,64,0,0,0,255,64,0,0,0,255,64,0,0,0,191,128,0,0,0,191,128,0,0,0,127,192,0,0,0,63,192,0,0,0,63,208,0,0,0,47,240,0,0,0,15,248,0,0,0,11,254,0,0,0,3,255,228,1,188,0,255,255,255,252,0,47,255,255,252,0,2,255,255,244,0,0,5,84,0,
  // 0x0109  ĉ
  15,30,120,18,2,255,0,5,80,0,0,15,252,0,0,63,255,0,0,255,191,192,2,252,31,224,11,240,3,248,10,64,0,104,0,0,0,0,0,0,84,0,0,47,255,228,2,255,255,248,11,255,255,244,31,253,1,176,63,224,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,191,64,0,0,127,192,0,0,63,208,0,0,47,248,0,120,15,255,255,248,2,255,255,248,0,127,255,224,0,1,84,0,
  // 0x010a  Ċ
  20,35,175,23,2,255,0,0,1,64,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,7,208,0,0,0,0,0,0,0,0,0,0,0,0,0,26,234,64,0,7,255,255,253,0,47,255,255,255,0,255,255,175,253,3,255,208,0,108,11,254,0,0,0,15,248,0,0,0,47,240,0,0,0,63,208,0,0,0,127,192,0,0,0,127,192,0,0,0,191,128,0,0,0,191,64,0,0,0,255,64,0,0,0,255,64,0,0,0,191,128,0,0,0,191,128,0,0,0,127,192,0,0,0,63,192,0,0,0,63,208,0,0,0,47,240,0,0,0,15,248,0,0,0,11,254,0,0,0,3,255,228,1,188,0,255,255,255,252,0,47,255,255,252,0,2,255,255,244,0,0,5,84,0,
  // 0x010b  ċ
  15,29,116,18,2,255,0,1,80,0,0,7,244,0,0,11,248,0,0,11,248,0,0,2,240,0,0,0,0,0,0,0,0,0,0,0,84,0,0,47,255,228,2,255,255,248,11,255,255,244,31,253,1,176,63,224,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,191,64,0,0,127,192,0,0,63,208,0,0,47,248,0,120,15,255,255,248,2,255,255,248,0,127,255,224,0,1,84,0,
  // 0x010c  Č
  20,36,180,23,2,255,0,5,0,0,80,0,31,192,3,244,0,7,244,31,208,0,2,253,191,128,0,0,191,254,0,0,0,63,252,0,0,0,10,160,0,0,0,0,0,0,0,0,26,234,64,0,7,255,255,253,0,47,255,255,255,0,255,255,175,253,3,255,208,0,108,11,254,0,0,0,15,248,0,0,0,47,240,0,0,0,63,208,0,0,0,127,192,0,0,0,127,192,0,0,0,191,128,0,0,0,191,64,0,0,0,255,64,0,0,0,255,64,0,0,0,191,128,0,0,0,191,128,0,0,0,127,192,0,0,0,63,192,0,0,0,63,208,0,0,0,47,240,0,0,0,15,248,0,0,0,11,254,0,0,0,3,255,228,1,188,0,255,255,255,252,0,47,255,255,252,0,2,255,255,244,0,0,5,84,0,
  // 0x010d  č
  15,30,120,18,2,255,5,0,0,20,15,224,2,252,3,252,15,240,0,255,63,192,0,63,255,0,0,31,253,0,0,6,164,0,0,0,0,0,0,0,84,0,0,47,255,228,2,255,255,248,11,255,255,244,31,253,1,176,63,224,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,191,64,0,0,127,192,0,0,63,208,0,0,47,248,0,120,15,255,255,248,2,255,255,248,0,127,255,224,0,1,84,0,
  // 0x010e  Ď
  22,35,210,27,3,0,0,80,0,5,64,0,0,254,0,47,192,0,0,63,128,255,0,0,0,15,247,252,0,0,0,3,255,240,0,0,0,1,255,208,0,0,0,0,170,64,0,0,0,0,0,0,0,0,21,85,84,0,0,0,127,255,255,244,0,0,127,255,255,255,64,0,127,255,255,255,224,0,127,128,1,191,252,0,127,128,0,11,254,0,127,128,0,2,255,64,127,128,0,0,255,192,127,128,0,0,127,192,127,128,0,0,63,208,127,128,0,0,47,224,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,47,224,127,128,0,0,63,208,127,128,0,0,63,192,127,128,0,0,191,192,127,128,0,1,255,64,127,128,0,7,255,0,127,128,0,47,252,0,127,149,91,255,244,0,127,255,255,255,192,0,127,255,255,253,0,0,127,255,254,64,0,0,
  // 0x010f  ď
  24,29,174,23,2,255,0,0,0,15,240,191,0,0,0,15,240,254,0,0,0,15,240,253,0,0,0,15,240,252,0,0,0,15,242,240,0,0,0,15,242,224,0,0,0,15,240,0,0,1,64,15,240,0,0,191,254,15,240,0,3,255,255,207,240,0,15,255,255,255,240,0,47,248,1,255,240,0,63,208,0,127,240,0,127,192,0,47,240,0,191,64,0,31,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,191,64,0,15,240,0,191,128,0,47,240,0,63,208,0,63,240,0,47,244,1,255,240,0,15,255,255,255,240,0,3,255,255,203,240,0,0,191,254,7,240,0,0,1,64,0,0,0,
  // 0x0110  Đ
  24,27,162,27,1,0,1,85,85,64,0,0,7,255,255,255,64,0,7,255,255,255,244,0,7,255,255,255,254,0,7,248,0,27,255,192,7,248,0,0,191,224,7,248,0,0,47,244,7,248,0,0,15,252,7,248,0,0,7,252,7,248,0,0,3,253,7,248,0,0,2,254,7,248,0,0,1,255,191,255,255,64,1,255,255,255,255,128,1,255,255,255,255,128,1,255,171,254,170,64,1,255,7,248,0,0,2,254,7,248,0,0,3,253,7,248,0,0,3,252,7,248,0,0,11,252,7,248,0,0,31,244,7,248,0,0,127,240,7,248,0,2,255,192,7,253,85,191,255,64,7,255,255,255,252,0,7,255,255,255,208,0,7,255,255,228,0,0,
  // 0x0111  đ
  21,29,174,23,2,255,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,3,255,255,255,128,0,7,255,255,255,128,0,3,255,255,255,128,0,0,0,15,240,0,0,0,0,15,240,0,0,47,232,15,240,0,2,255,255,79,240,0,11,255,255,239,240,0,31,254,91,255,240,0,63,224,0,191,240,0,127,192,0,63,240,0,191,128,0,31,240,0,255,64,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,64,0,15,240,0,191,128,0,47,240,0,63,208,0,63,240,0,63,244,1,255,240,0,15,255,255,255,240,0,3,255,255,203,240,0,0,191,254,7,240,0,0,1,64,0,0,0,
  // 0x0112  Ē
  16,32,128,21,3,0,1,85,85,80,7,255,255,240,7,255,255,240,6,170,170,160,0,0,0,0,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,
  // 0x0113  ē
  18,27,135,21,2,255,1,85,85,80,0,3,255,255,244,0,3,255,255,244,0,2,170,170,160,0,0,0,0,0,0,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,
  // 0x0114  Ĕ
  16,34,136,21,3,0,10,64,0,160,11,192,1,240,7,249,111,240,3,255,255,192,0,191,255,0,0,6,144,0,0,0,0,0,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,
  // 0x0115  ĕ
  18,29,145,21,2,255,6,128,0,104,0,7,192,0,248,0,3,249,91,240,0,1,255,255,224,0,0,127,255,64,0,0,6,164,0,0,0,0,0,0,0,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,
  // 0x0116  Ė
  16,34,136,21,3,0,0,1,64,0,0,11,240,0,0,15,244,0,0,15,244,0,0,3,224,0,0,0,0,0,0,0,0,0,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,
  // 0x0117  ė
  18,29,145,21,2,255,0,0,80,0,0,0,3,248,0,0,0,11,252,0,0,0,7,248,0,0,0,2,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,
  // 0x0118  Ę
  16,36,144,21,3,247,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,0,0,3,240,0,0,15,192,0,0,47,64,0,0,63,0,0,0,63,0,0,0,63,68,0,0,47,253,0,0,15,253,0,0,0,80,
  // 0x0119  ę
  18,30,150,21,2,247,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,255,0,0,0,85,248,0,0,0,3,240,0,0,0,11,192,0,0,0,15,192,0,0,0,31,128,0,0,0,15,209,0,0,0,15,255,0,0,0,3,255,0,0,0,0,20,0,
  // 0x011a  Ě
  16,35,140,21,3,0,5,0,0,84,15,208,3,248,3,248,15,224,1,254,127,128,0,127,255,0,0,47,252,0,0,10,164,0,0,0,0,0,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,
  // 0x011b  ě
  18,30,150,21,2,255,5,64,0,20,0,11,224,1,252,0,2,252,11,240,0,0,255,127,192,0,0,63,255,64,0,0,15,253,0,0,0,6,168,0,0,0,0,0,0,0,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,
  // 0x011c  Ĝ
  22,36,216,27,2,255,0,0,1,84,0,0,0,0,15,254,0,0,0,0,47,255,64,0,0,0,127,191,192,0,0,1,254,11,240,0,0,3,244,2,252,0,0,6,128,0,105,0,0,0,0,0,0,0,0,0,6,190,148,0,0,2,255,255,255,144,0,31,255,255,255,224,0,191,255,235,255,192,2,255,224,0,7,128,7,255,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,128,0,0,0,0,191,64,0,0,0,0,255,64,0,127,255,240,191,64,0,127,255,240,191,64,0,127,255,240,191,128,0,0,15,240,127,192,0,0,15,240,63,192,0,0,15,240,63,208,0,0,15,240,47,240,0,0,15,240,15,252,0,0,15,240,7,255,0,0,15,240,2,255,228,0,95,240,0,191,255,255,255,240,0,31,255,255,255,240,0,1,255,255,254,64,0,0,1,85,0,0,
  // 0x011d  ĝ
  18,38,190,23,2,247,0,1,84,0,0,0,11,255,0,0,0,31,255,128,0,0,63,239,208,0,0,254,11,244,0,3,248,1,253,0,6,144,0,41,0,0,0,0,0,0,0,1,64,0,0,0,191,253,7,240,3,255,255,203,240,15,255,255,255,240,47,248,2,255,240,63,208,0,127,240,127,192,0,47,240,191,64,0,31,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,191,64,0,15,240,127,128,0,31,240,63,208,0,63,240,47,244,1,255,240,15,255,255,255,240,3,255,255,207,240,0,191,254,15,240,0,1,64,15,240,0,0,0,15,240,0,0,0,31,224,0,0,0,47,208,20,0,0,191,192,47,165,87,255,128,47,255,255,254,0,31,255,255,244,0,1,175,254,64,0,
  // 0x011e  Ğ
  22,35,210,27,2,255,0,2,128,0,104,0,0,3,208,0,252,0,0,2,254,91,244,0,0,0,255,255,240,0,0,0,63,255,128,0,0,0,5,164,0,0,0,0,0,0,0,0,0,0,6,190,148,0,0,2,255,255,255,144,0,31,255,255,255,224,0,191,255,235,255,192,2,255,224,0,7,128,7,255,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,128,0,0,0,0,191,64,0,0,0,0,255,64,0,127,255,240,191,64,0,127,255,240,191,64,0,127,255,240,191,128,0,0,15,240,127,192,0,0,15,240,63,192,0,0,15,240,63,208,0,0,15,240,47,240,0,0,15,240,15,252,0,0,15,240,7,255,0,0,15,240,2,255,228,0,95,240,0,191,255,255,255,240,0,31,255,255,255,240,0,1,255,255,254,64,0,0,1,85,0,0,
  // 0x011f  ğ
  18,37,185,23,2,247,2,144,0,40,0,3,224,0,188,0,1,254,91,248,0,0,255,255,240,0,0,47,255,192,0,0,1,164,0,0,0,0,0,0,0,0,1,64,0,0,0,191,253,7,240,3,255,255,203,240,15,255,255,255,240,47,248,2,255,240,63,208,0,127,240,127,192,0,47,240,191,64,0,31,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,191,64,0,15,240,127,128,0,31,240,63,208,0,63,240,47,244,1,255,240,15,255,255,255,240,3,255,255,207,240,0,191,254,15,240,0,1,64,15,240,0,0,0,15,240,0,0,0,31,224,0,0,0,47,208,20,0,0,191,192,47,165,87,255,128,47,255,255,254,0,31,255,255,244,0,1,175,254,64,0,
  // 0x0120  Ġ
  22,35,210,27,2,255,0,0,0,80,0,0,0,0,3,252,0,0,0,0,3,252,0,0,0,0,3,252,0,0,0,0,1,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,190,148,0,0,2,255,255,255,144,0,31,255,255,255,224,0,191,255,235,255,192,2,255,224,0,7,128,7,255,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,128,0,0,0,0,191,64,0,0,0,0,255,64,0,127,255,240,191,64,0,127,255,240,191,64,0,127,255,240,191,128,0,0,15,240,127,192,0,0,15,240,63,192,0,0,15,240,63,208,0,0,15,240,47,240,0,0,15,240,15,252,0,0,15,240,7,255,0,0,15,240,2,255,228,0,95,240,0,191,255,255,255,240,0,31,255,255,255,240,0,1,255,255,254,64,0,0,1,85,0,0,
  // 0x0121  ġ
  18,37,185,23,2,247,0,0,80,0,0,0,2,252,0,0,0,3,253,0,0,0,3,253,0,0,0,1,248,0,0,0,0,0,0,0,0,0,0,0,0,0,1,64,0,0,0,191,253,7,240,3,255,255,203,240,15,255,255,255,240,47,248,2,255,240,63,208,0,127,240,127,192,0,47,240,191,64,0,31,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,191,64,0,15,240,127,128,0,31,240,63,208,0,63,240,47,244,1,255,240,15,255,255,255,240,3,255,255,207,240,0,191,254,15,240,0,1,64,15,240,0,0,0,15,240,0,0,0,31,224,0,0,0,47,208,20,0,0,191,192,47,165,87,255,128,47,255,255,254,0,31,255,255,244,0,1,175,254,64,0,
  // 0x0122  Ģ
  22,36,216,27,2,247,0,0,6,190,148,0,0,2,255,255,255,144,0,31,255,255,255,224,0,191,255,235,255,192,2,255,224,0,7,128,7,255,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,128,0,0,0,0,191,64,0,0,0,0,255,64,0,127,255,240,191,64,0,127,255,240,191,64,0,127,255,240,191,128,0,0,15,240,127,192,0,0,15,240,63,192,0,0,15,240,63,208,0,0,15,240,47,240,0,0,15,240,15,252,0,0,15,240,7,255,0,0,15,240,2,255,228,0,95,240,0,191,255,255,255,240,0,31,255,255,255,240,0,1,255,255,254,64,0,0,1,85,0,0,0,0,0,0,0,0,0,0,1,252,0,0,0,0,2,252,0,0,0,0,3,248,0,0,0,0,3,240,0,0,0,0,7,208,0,0,0,0,15,192,0,0,0,0,0,0,0,0,
  // 0x0123  ģ
  18,38,190,23,2,247,0,0,5,0,0,0,0,62,0,0,0,0,189,0,0,0,0,252,0,0,0,2,248,0,0,0,3,248,0,0,0,2,160,0,0,0,0,0,0,0,0,1,64,0,0,0,191,253,7,240,3,255,255,203,240,15,255,255,255,240,47,248,2,255,240,63,208,0,127,240,127,192,0,47,240,191,64,0,31,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,191,64,0,15,240,127,128,0,31,240,63,208,0,63,240,47,244,1,255,240,15,255,255,255,240,3,255,255,207,240,0,191,254,15,240,0,1,64,15,240,0,0,0,15,240,0,0,0,31,224,0,0,0,47,208,20,0,0,191,192,47,165,87,255,128,47,255,255,254,0,31,255,255,244,0,1,175,254,64,0,
  // 0x0124  Ĥ
  21,35,210,28,3,0,0,0,21,64,0,0,0,0,255,224,0,0,0,2,255,244,0,0,0,7,251,252,0,0,0,31,208,255,0,0,0,127,64,47,192,0,0,104,0,6,144,0,0,0,0,0,0,0,21,0,0,0,21,64,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,149,85,85,127,192,127,255,255,255,255,192,127,255,255,255,255,192,127,255,255,255,255,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,
  // 0x0125  ĥ
  23,37,222,23,254,0,0,21,64,0,0,0,0,191,224,0,0,0,1,255,248,0,0,0,7,250,253,0,0,0,15,224,191,64,0,0,63,128,31,192,0,0,104,0,2,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,1,0,0,0,63,193,255,248,0,0,63,207,255,255,64,0,63,239,255,255,208,0,63,254,0,127,240,0,63,244,0,31,240,0,63,240,0,15,240,0,63,208,0,11,244,0,63,192,0,11,244,0,63,192,0,11,244,0,63,192,0,11,244,0,63,192,0,11,244,0,63,192,0,11,244,0,63,192,0,11,244,0,63,192,0,11,244,0,63,192,0,11,244,0,63,192,0,11,244,0,63,192,0,11,244,0,63,192,0,11,244,0,63,192,0,11,244,0,63,192,0,11,244,
  // 0x0126  Ħ
  28,27,189,28,0,0,0,84,0,0,0,85,0,1,254,0,0,0,255,0,1,254,0,0,0,255,0,1,254,0,0,0,255,0,86,254,85,85,85,255,84,255,255,255,255,255,255,254,255,255,255,255,255,255,254,171,255,170,170,170,255,169,1,254,0,0,0,255,0,1,254,0,0,0,255,0,1,254,0,0,0,255,0,1,254,85,85,85,255,0,1,255,255,255,255,255,0,1,255,255,255,255,255,0,1,255,255,255,255,255,0,1,254,0,0,0,255,0,1,254,0,0,0,255,0,1,254,0,0,0,255,0,1,254,0,0,0,255,0,1,254,0,0,0,255,0,1,254,0,0,0,255,0,1,254,0,0,0,255,0,1,254,0,0,0,255,0,1,254,0,0,0,255,0,1,254,0,0,0,255,0,1,254,0,0,0,255,0,1,254,0,0,0,255,0,
  // 0x0127  ħ
  21,28,168,23,0,0,3,252,0,0,0,0,3,252,0,0,0,0,3,252,0,0,0,0,191,255,255,240,0,0,191,255,255,240,0,0,191,255,255,240,0,0,3,252,0,0,0,0,3,252,0,0,0,0,3,252,1,84,0,0,3,252,47,255,208,0,3,252,255,255,248,0,3,255,255,255,253,0,3,255,208,3,255,0,3,255,0,0,255,0,3,254,0,0,255,64,3,253,0,0,191,64,3,252,0,0,191,64,3,252,0,0,191,64,3,252,0,0,191,64,3,252,0,0,191,64,3,252,0,0,191,64,3,252,0,0,191,64,3,252,0,0,191,64,3,252,0,0,191,64,3,252,0,0,191,64,3,252,0,0,191,64,3,252,0,0,191,64,3,252,0,0,191,64,
  // 0x0128  Ĩ
  14,34,136,13,0,0,1,64,1,64,47,248,3,208,127,255,155,192,254,191,255,128,240,11,255,0,144,0,100,0,0,0,0,0,21,85,85,0,47,255,254,0,47,255,254,0,2,255,224,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,191,128,0,11,255,249,0,47,255,254,0,47,255,254,0,
  // 0x0129  ĩ
  14,28,112,10,254,0,1,64,0,80,15,253,1,240,63,255,215,224,126,191,255,192,248,7,255,64,160,0,100,0,0,0,0,0,0,0,0,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,
  // 0x012a  Ī
  11,32,96,13,1,0,85,85,84,255,255,252,255,255,252,170,170,168,0,0,0,85,85,84,191,255,248,191,255,248,11,255,128,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,2,254,0,47,255,228,191,255,248,191,255,248,
  // 0x012b  ī
  12,26,78,10,255,0,21,85,85,191,255,254,191,255,254,106,170,169,0,0,0,0,0,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,
  // 0x012c  Ĭ
  13,34,136,13,0,0,104,0,10,64,124,0,15,64,63,149,191,0,31,255,253,0,7,255,244,0,0,106,64,0,0,0,0,0,21,85,85,0,47,255,254,0,47,255,254,0,2,255,224,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,191,128,0,11,255,249,0,47,255,254,0,47,255,254,0,
  // 0x012d  ĭ
  12,28,84,10,255,0,160,0,10,248,0,47,191,150,254,63,255,252,15,255,224,0,105,0,0,0,0,0,0,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,
  // 0x012e  Į
  11,36,108,13,1,247,85,85,84,191,255,248,191,255,248,11,255,128,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,2,254,0,47,255,228,191,255,248,191,255,248,0,11,192,0,47,64,0,126,0,0,188,0,0,252,0,0,254,0,0,127,248,0,47,248,0,1,64,
  // 0x012f  į
  7,37,74,10,1,247,1,64,15,240,15,240,15,240,7,208,0,0,0,0,0,0,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,11,208,47,64,62,0,189,0,252,0,190,0,127,248,47,248,1,64,
  // 0x0130  İ
  11,34,102,13,1,0,0,84,0,1,253,0,2,255,0,1,254,0,0,188,0,0,0,0,0,0,0,85,85,84,191,255,248,191,255,248,11,255,128,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,2,254,0,47,255,228,191,255,248,191,255,248,
  // 0x0131  ı
  4,20,20,10,3,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x0132  Ĳ
  20,35,175,24,1,248,85,85,84,0,84,191,255,248,2,253,191,255,248,2,253,11,255,128,2,253,1,254,0,2,253,1,254,0,2,253,1,254,0,2,253,1,254,0,2,253,1,254,0,2,253,1,254,0,2,253,1,254,0,2,253,1,254,0,2,253,1,254,0,2,253,1,254,0,2,253,1,254,0,2,253,1,254,0,2,253,1,254,0,2,253,1,254,0,2,253,1,254,0,2,253,1,254,0,2,253,1,254,0,2,253,1,254,0,2,253,1,254,0,2,253,2,254,0,2,253,47,255,228,2,253,191,255,248,2,253,191,255,248,2,253,0,0,0,2,253,0,0,0,3,252,0,0,0,7,252,0,0,20,111,248,0,0,63,255,240,0,0,63,255,208,0,0,47,254,0,0,0,0,0,0,
  // 0x0133  ĳ
  15,37,148,20,3,247,20,0,1,64,255,0,15,240,255,0,15,244,255,0,15,240,125,0,7,224,0,0,0,0,0,0,0,0,0,0,0,0,255,0,15,240,255,0,15,240,255,0,15,240,255,0,15,240,255,0,15,240,255,0,15,240,255,0,15,240,255,0,15,240,255,0,15,240,255,0,15,240,255,0,15,240,255,0,15,240,255,0,15,240,255,0,15,240,255,0,15,240,255,0,15,240,255,0,15,240,255,0,15,240,255,0,15,240,255,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,31,240,0,37,191,224,0,63,255,192,0,63,255,64,0,47,248,0,
  // 0x0134  Ĵ
  15,43,172,11,253,248,0,5,80,0,0,31,252,0,0,63,255,0,0,255,191,128,3,252,31,224,11,224,3,244,10,64,0,168,0,0,0,0,0,5,80,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,15,240,0,0,31,240,0,81,191,224,0,255,255,192,0,255,255,0,0,191,248,0,0,0,0,0,0,
  // 0x0135  ĵ
  14,38,152,10,254,247,0,21,64,0,0,191,224,0,1,255,244,0,7,250,253,0,15,224,191,0,63,64,31,192,104,0,2,144,0,0,0,0,0,0,0,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,127,192,0,150,255,128,0,255,255,0,0,255,253,0,0,191,144,0,0,
  // 0x0136  Ķ
  20,36,180,23,3,247,21,0,0,1,85,127,128,0,7,253,127,128,0,15,244,127,128,0,63,224,127,128,0,255,128,127,128,2,255,0,127,128,11,252,0,127,128,31,240,0,127,128,127,192,0,127,128,255,64,0,127,131,253,0,0,127,143,248,0,0,127,175,244,0,0,127,255,252,0,0,127,255,254,0,0,127,245,255,64,0,127,192,191,192,0,127,128,63,224,0,127,128,31,244,0,127,128,11,252,0,127,128,3,255,0,127,128,0,255,128,127,128,0,127,192,127,128,0,47,240,127,128,0,15,248,127,128,0,7,253,127,128,0,2,255,0,0,0,0,0,0,0,0,0,0,0,0,190,0,0,0,0,254,0,0,0,0,252,0,0,0,1,248,0,0,0,3,240,0,0,0,3,208,0,0,0,0,0,0,0,
  // 0x0137  ķ
  17,37,185,21,3,247,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,255,64,255,0,3,254,0,255,0,15,248,0,255,0,63,224,0,255,0,191,128,0,255,2,255,0,0,255,11,252,0,0,255,31,240,0,0,255,127,192,0,0,255,255,224,0,0,255,255,244,0,0,255,231,252,0,0,255,130,255,0,0,255,0,255,128,0,255,0,63,208,0,255,0,31,240,0,255,0,11,252,0,255,0,3,254,0,255,0,1,255,64,255,0,0,191,192,0,0,0,0,0,0,0,0,0,0,0,11,224,0,0,0,15,224,0,0,0,31,192,0,0,0,47,128,0,0,0,63,0,0,0,0,61,0,0,0,0,0,0,0,0,
  // 0x0138  ĸ
  17,20,100,21,3,0,255,0,0,255,64,255,0,3,254,0,255,0,11,252,0,255,0,47,240,0,255,0,127,192,0,255,1,255,64,0,255,3,253,0,0,255,15,248,0,0,255,47,224,0,0,255,191,224,0,0,255,255,244,0,0,255,251,252,0,0,255,210,255,0,0,255,0,255,128,0,255,0,63,208,0,255,0,31,240,0,255,0,11,252,0,255,0,3,254,0,255,0,0,255,64,255,0,0,127,192,
  // 0x0139  Ĺ
  16,35,140,20,3,0,0,85,0,0,1,255,0,0,3,253,0,0,15,244,0,0,31,208,0,0,63,64,0,0,104,0,0,0,0,0,0,0,21,0,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,85,127,255,255,255,127,255,255,255,127,255,255,255,
  // 0x013a  ĺ
  8,37,74,10,3,0,0,85,3,255,11,252,15,240,63,192,190,0,164,0,0,0,0,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,
  // 0x013b  Ļ
  16,36,144,20,3,247,21,0,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,85,127,255,255,255,127,255,255,255,127,255,255,255,0,0,0,0,0,0,0,0,0,3,248,0,0,3,244,0,0,7,240,0,0,11,208,0,0,15,192,0,0,31,64,0,0,0,0,0,
  // 0x013c  ļ
  6,37,74,10,2,247,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,0,0,0,0,15,208,31,208,47,192,63,64,63,0,124,0,0,0,
  // 0x013d  Ľ
  16,27,108,20,3,0,21,0,0,85,127,128,0,255,127,128,0,254,127,128,0,252,127,128,1,248,127,128,2,240,127,128,1,144,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,85,127,255,255,255,127,255,255,255,127,255,255,255,
  // 0x013e  ľ
  11,28,84,10,3,0,255,7,244,255,11,240,255,15,208,255,15,192,255,31,64,255,30,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,
  // 0x013f  Ŀ
  16,27,108,20,3,0,21,0,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,1,64,127,128,15,224,127,128,31,240,127,128,31,240,127,128,11,208,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,85,127,255,255,255,127,255,255,255,127,255,255,255,
  // 0x0140  ŀ
  10,28,84,11,3,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,5,64,255,31,208,255,47,224,255,47,224,255,15,128,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,
  // 0x0141  Ł
  19,27,135,20,0,0,0,84,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,1,0,0,1,254,15,64,0,1,254,191,192,0,1,255,255,128,0,1,255,252,0,0,2,255,208,0,0,31,254,0,0,0,127,254,0,0,0,63,254,0,0,0,26,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,85,85,84,1,255,255,255,252,1,255,255,255,252,1,255,255,255,252,
  // 0x0142  ł
  10,28,84,10,0,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,254,208,3,255,240,3,255,240,7,255,64,47,252,0,255,252,0,255,252,0,55,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,
  // 0x0143  Ń
  22,35,210,29,3,0,0,0,0,21,64,0,0,0,0,191,192,0,0,0,0,255,64,0,0,0,3,253,0,0,0,0,11,244,0,0,0,0,31,192,0,0,0,0,26,0,0,0,0,0,0,0,0,0,21,64,0,0,1,80,127,240,0,0,11,240,127,248,0,0,11,240,127,252,0,0,11,240,127,255,0,0,11,240,127,255,64,0,11,240,127,127,192,0,11,240,127,63,224,0,11,240,127,15,244,0,11,240,127,11,252,0,11,240,127,3,254,0,11,240,127,1,255,0,11,240,127,0,191,192,11,240,127,0,63,208,11,240,127,0,31,240,7,240,127,0,15,248,7,240,127,0,3,253,7,240,127,0,2,255,7,240,127,0,0,255,135,240,127,0,0,127,199,240,127,0,0,47,247,240,127,0,0,15,251,240,127,0,0,7,255,240,127,0,0,3,255,240,127,0,0,0,255,240,127,0,0,0,191,240,127,0,0,0,63,240,
  // 0x0144  ń
  18,29,145,23,3,0,0,0,5,84,0,0,0,31,244,0,0,0,63,224,0,0,0,191,128,0,0,1,254,0,0,0,3,244,0,0,0,6,144,0,0,0,0,0,0,0,0,0,4,0,0,253,7,255,244,0,253,63,255,254,0,255,255,255,255,64,255,248,1,255,192,255,208,0,127,192,255,192,0,63,192,255,64,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,
  // 0x0145  Ņ
  22,36,216,29,3,247,21,64,0,0,1,80,127,240,0,0,11,240,127,248,0,0,11,240,127,252,0,0,11,240,127,255,0,0,11,240,127,255,64,0,11,240,127,127,192,0,11,240,127,63,224,0,11,240,127,15,244,0,11,240,127,11,252,0,11,240,127,3,254,0,11,240,127,1,255,0,11,240,127,0,191,192,11,240,127,0,63,208,11,240,127,0,31,240,7,240,127,0,15,248,7,240,127,0,3,253,7,240,127,0,2,255,7,240,127,0,0,255,135,240,127,0,0,127,199,240,127,0,0,47,247,240,127,0,0,15,251,240,127,0,0,7,255,240,127,0,0,3,255,240,127,0,0,0,255,240,127,0,0,0,191,240,127,0,0,0,63,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,224,0,0,0,0,15,224,0,0,0,0,31,192,0,0,0,0,47,128,0,0,0,0,63,0,0,0,0,0,61,0,0,0,0,0,0,0,0,0,
  // 0x0146  ņ
  18,30,150,23,3,247,0,0,4,0,0,253,7,255,244,0,253,63,255,254,0,255,255,255,255,64,255,248,1,255,192,255,208,0,127,192,255,192,0,63,192,255,64,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,0,0,0,0,0,0,0,0,0,0,0,1,252,0,0,0,2,252,0,0,0,3,244,0,0,0,3,240,0,0,0,11,208,0,0,0,15,128,0,0,0,0,0,0,0,
  // 0x0147  Ň
  22,35,210,29,3,0,0,20,0,1,80,0,0,63,64,11,224,0,0,15,224,63,128,0,0,3,249,255,0,0,0,1,255,252,0,0,0,0,191,240,0,0,0,0,42,144,0,0,0,0,0,0,0,0,21,64,0,0,1,80,127,240,0,0,11,240,127,248,0,0,11,240,127,252,0,0,11,240,127,255,0,0,11,240,127,255,64,0,11,240,127,127,192,0,11,240,127,63,224,0,11,240,127,15,244,0,11,240,127,11,252,0,11,240,127,3,254,0,11,240,127,1,255,0,11,240,127,0,191,192,11,240,127,0,63,208,11,240,127,0,31,240,7,240,127,0,15,248,7,240,127,0,3,253,7,240,127,0,2,255,7,240,127,0,0,255,135,240,127,0,0,127,199,240,127,0,0,47,247,240,127,0,0,15,251,240,127,0,0,7,255,240,127,0,0,3,255,240,127,0,0,0,255,240,127,0,0,0,191,240,127,0,0,0,63,240,
  // 0x0148  ň
  18,29,145,23,3,0,5,64,0,20,0,11,224,2,252,0,3,252,11,240,0,0,255,127,192,0,0,63,255,64,0,0,31,253,0,0,0,6,168,0,0,0,0,0,0,0,0,0,4,0,0,253,7,255,244,0,253,63,255,254,0,255,255,255,255,64,255,248,1,255,192,255,208,0,127,192,255,192,0,63,192,255,64,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,
  // 0x0149  ŉ
  24,27,162,26,0,0,5,80,0,0,0,0,31,240,0,0,0,0,31,224,0,0,0,0,47,208,0,0,0,0,63,192,0,0,0,0,63,128,0,0,0,0,63,0,0,0,64,0,127,15,208,127,255,64,189,15,227,255,255,224,168,15,255,255,255,244,0,15,255,128,31,252,0,15,253,0,3,252,0,15,252,0,2,253,0,15,244,0,2,253,0,15,244,0,1,253,0,15,240,0,1,253,0,15,240,0,1,253,0,15,240,0,1,253,0,15,240,0,1,253,0,15,240,0,1,253,0,15,240,0,1,253,0,15,240,0,1,253,0,15,240,0,1,253,0,15,240,0,1,253,0,15,240,0,1,253,0,15,240,0,1,253,0,15,240,0,1,253,
  // 0x014a  Ŋ
  22,35,210,29,3,248,21,64,0,0,1,80,127,240,0,0,11,240,127,248,0,0,11,240,127,253,0,0,11,240,127,255,0,0,11,240,127,255,128,0,11,240,127,127,208,0,11,240,127,47,240,0,11,240,127,15,248,0,11,240,127,7,253,0,11,240,127,2,255,0,11,240,127,0,255,128,11,240,127,0,127,208,11,240,127,0,47,240,7,240,127,0,15,248,7,240,127,0,7,253,7,240,127,0,2,255,7,240,127,0,0,255,135,240,127,0,0,63,215,240,127,0,0,47,247,240,127,0,0,15,255,240,127,0,0,3,255,240,127,0,0,1,255,240,127,0,0,0,255,240,127,0,0,0,63,240,127,0,0,0,31,240,127,0,0,0,11,240,0,0,0,0,7,240,0,0,0,0,11,240,0,0,0,0,15,240,0,0,0,64,191,224,0,0,0,255,255,192,0,0,0,255,255,0,0,0,0,255,248,0,0,0,0,0,0,0,
  // 0x014b  ŋ
  18,30,150,23,3,247,0,0,4,0,0,253,7,255,244,0,253,63,255,254,0,255,255,255,255,64,255,248,1,255,192,255,208,0,63,192,255,192,0,63,208,255,64,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,0,0,0,47,208,0,0,0,47,208,0,0,0,47,208,0,0,0,47,208,0,0,0,63,192,0,0,37,255,192,0,0,63,255,64,0,0,63,254,0,0,0,47,228,0,
  // 0x014c  Ō
  25,33,231,29,2,255,0,1,85,85,80,0,0,0,3,255,255,240,0,0,0,3,255,255,240,0,0,0,2,170,170,160,0,0,0,0,0,0,0,0,0,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x014d  ō
  19,27,135,23,2,255,0,85,85,84,0,1,255,255,252,0,1,255,255,252,0,0,170,170,168,0,0,0,0,0,0,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,
  // 0x014e  Ŏ
  25,35,245,29,2,255,0,6,128,0,164,0,0,0,7,192,0,244,0,0,0,3,249,107,240,0,0,0,2,255,255,208,0,0,0,0,127,255,64,0,0,0,0,6,148,0,0,0,0,0,0,0,0,0,0,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x014f  ŏ
  19,29,145,23,2,255,2,144,0,41,0,2,240,0,124,0,1,254,91,252,0,0,255,255,240,0,0,47,255,192,0,0,1,164,0,0,0,0,0,0,0,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,
  // 0x0150  Ő
  25,36,252,29,2,255,0,0,21,64,84,0,0,0,0,191,131,253,0,0,0,0,254,11,244,0,0,0,3,252,15,224,0,0,0,7,240,47,128,0,0,0,15,192,126,0,0,0,0,26,0,100,0,0,0,0,0,0,0,0,0,0,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x0151  ő
  19,30,150,23,2,255,0,5,64,85,0,0,63,208,255,0,0,191,67,252,0,0,254,7,244,0,2,248,15,208,0,7,224,47,64,0,6,64,41,0,0,0,0,0,0,0,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,
  // 0x0152  Œ
  31,28,224,35,2,255,0,0,107,249,85,85,85,84,0,11,255,255,255,255,255,248,0,127,255,255,255,255,255,248,1,255,254,175,255,255,255,248,7,255,64,0,255,0,0,0,15,252,0,0,255,0,0,0,31,240,0,0,255,0,0,0,63,224,0,0,255,0,0,0,63,192,0,0,255,0,0,0,127,192,0,0,255,0,0,0,191,128,0,0,255,0,0,0,191,64,0,0,255,149,85,80,191,64,0,0,255,255,255,240,255,64,0,0,255,255,255,240,255,64,0,0,255,255,255,240,191,64,0,0,255,0,0,0,191,128,0,0,255,0,0,0,127,192,0,0,255,0,0,0,63,192,0,0,255,0,0,0,63,208,0,0,255,0,0,0,47,240,0,0,255,0,0,0,15,248,0,0,255,0,0,0,11,254,0,0,255,0,0,0,3,255,208,6,255,149,85,84,0,255,255,255,255,255,255,248,0,47,255,255,255,255,255,248,0,2,255,255,255,255,255,248,0,0,5,80,0,0,0,0,
  // 0x0153  œ
  32,21,168,35,2,255,0,47,255,128,1,255,248,0,2,255,255,244,15,255,255,128,11,255,255,253,63,255,255,224,31,248,1,255,255,128,31,244,63,208,0,63,254,0,7,248,127,192,0,47,252,0,3,252,191,64,0,15,248,0,2,253,255,0,0,15,244,0,1,253,255,0,0,15,255,255,255,253,255,0,0,11,255,255,255,254,255,0,0,11,255,255,255,253,255,0,0,15,244,0,0,0,255,0,0,15,244,0,0,0,191,64,0,15,248,0,0,0,127,128,0,47,252,0,0,0,63,208,0,63,254,0,0,0,31,244,1,255,255,208,0,120,11,255,255,254,63,255,255,248,2,255,255,248,15,255,255,248,0,47,255,144,1,255,255,208,0,0,80,0,0,1,80,0,
  // 0x0154  Ŕ
  20,35,175,23,3,0,0,0,1,84,0,0,0,15,248,0,0,0,47,224,0,0,0,127,128,0,0,0,254,0,0,0,3,248,0,0,0,2,144,0,0,0,0,0,0,0,21,85,84,0,0,127,255,255,224,0,127,255,255,253,0,127,255,255,255,64,127,128,6,255,192,127,128,0,127,208,127,128,0,47,224,127,128,0,31,240,127,128,0,31,240,127,128,0,31,224,127,128,0,47,208,127,128,0,127,192,127,128,6,255,64,127,255,255,254,0,127,255,255,244,0,127,255,255,192,0,127,149,127,208,0,127,128,15,240,0,127,128,11,248,0,127,128,3,253,0,127,128,1,255,0,127,128,0,255,128,127,128,0,63,192,127,128,0,47,240,127,128,0,15,244,127,128,0,7,252,127,128,0,3,254,
  // 0x0155  ŕ
  12,29,87,16,3,0,0,0,85,0,3,255,0,11,252,0,15,240,0,63,192,0,190,0,0,164,0,0,0,0,0,0,20,252,7,255,253,31,255,254,127,255,255,255,85,255,244,0,255,208,0,255,128,0,255,64,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,
  // 0x0156  Ŗ
  20,36,180,23,3,247,21,85,84,0,0,127,255,255,224,0,127,255,255,253,0,127,255,255,255,64,127,128,6,255,192,127,128,0,127,208,127,128,0,47,224,127,128,0,31,240,127,128,0,31,240,127,128,0,31,224,127,128,0,47,208,127,128,0,127,192,127,128,6,255,64,127,255,255,254,0,127,255,255,244,0,127,255,255,192,0,127,149,127,208,0,127,128,15,240,0,127,128,11,248,0,127,128,3,253,0,127,128,1,255,0,127,128,0,255,128,127,128,0,63,192,127,128,0,47,240,127,128,0,15,244,127,128,0,7,252,127,128,0,3,254,0,0,0,0,0,0,0,0,0,0,0,0,190,0,0,0,0,254,0,0,0,0,253,0,0,0,1,252,0,0,0,2,240,0,0,0,3,224,0,0,0,0,0,0,0,
  // 0x0157  ŗ
  13,30,120,16,2,247,0,0,5,0,63,1,255,192,63,71,255,192,63,159,255,192,63,255,213,64,63,253,0,0,63,244,0,0,63,224,0,0,63,208,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,0,0,0,0,0,0,0,0,15,208,0,0,31,192,0,0,47,192,0,0,63,64,0,0,62,0,0,0,124,0,0,0,0,0,0,0,
  // 0x0158  Ř
  20,35,175,23,3,0,5,64,0,20,0,11,240,1,252,0,2,252,11,244,0,0,191,111,208,0,0,63,255,64,0,0,15,254,0,0,0,6,168,0,0,0,0,0,0,0,21,85,84,0,0,127,255,255,224,0,127,255,255,253,0,127,255,255,255,64,127,128,6,255,192,127,128,0,127,208,127,128,0,47,224,127,128,0,31,240,127,128,0,31,240,127,128,0,31,224,127,128,0,47,208,127,128,0,127,192,127,128,6,255,64,127,255,255,254,0,127,255,255,244,0,127,255,255,192,0,127,149,127,208,0,127,128,15,240,0,127,128,11,248,0,127,128,3,253,0,127,128,1,255,0,127,128,0,255,128,127,128,0,63,192,127,128,0,47,240,127,128,0,15,244,127,128,0,7,252,127,128,0,3,254,
  // 0x0159  ř
  14,29,116,16,2,0,20,0,1,64,127,0,15,208,31,208,127,64,11,246,254,0,2,255,248,0,0,255,240,0,0,42,128,0,0,0,0,0,0,0,5,0,63,1,255,192,63,71,255,192,63,159,255,192,63,255,213,64,63,253,0,0,63,244,0,0,63,224,0,0,63,208,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,
  // 0x015a  Ś
  17,36,180,20,2,255,0,0,5,80,0,0,0,31,244,0,0,0,63,208,0,0,0,191,64,0,0,1,253,0,0,0,3,244,0,0,0,6,128,0,0,0,0,0,0,0,0,26,234,64,0,2,255,255,253,0,15,255,255,255,0,63,254,175,254,0,127,208,0,108,0,191,128,0,0,0,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,191,192,0,0,0,63,244,0,0,0,31,255,64,0,0,11,255,244,0,0,1,255,255,128,0,0,31,255,240,0,0,1,191,252,0,0,0,15,255,0,0,0,2,255,64,0,0,0,191,128,0,0,0,127,128,0,0,0,127,128,0,0,0,191,128,128,0,0,255,0,254,64,27,254,0,255,255,255,252,0,255,255,255,240,0,111,255,254,64,0,0,21,64,0,0,
  // 0x015b  ś
  15,30,120,18,2,255,0,0,21,64,0,0,255,128,0,2,255,0,0,7,252,0,0,15,240,0,0,47,128,0,0,41,0,0,0,0,0,0,0,5,64,0,2,255,255,64,47,255,255,240,127,255,255,208,255,64,6,192,254,0,0,0,255,0,0,0,255,128,0,0,191,244,0,0,63,255,128,0,11,255,252,0,0,191,255,128,0,7,255,208,0,0,127,240,0,0,15,240,0,0,11,244,0,0,11,240,228,0,31,240,255,234,255,208,255,255,255,128,111,255,248,0,0,85,0,0,
  // 0x015c  Ŝ
  17,36,180,20,2,255,0,5,80,0,0,0,15,252,0,0,0,63,255,0,0,0,255,191,192,0,2,252,31,224,0,11,240,3,248,0,10,64,0,104,0,0,0,0,0,0,0,26,234,64,0,2,255,255,253,0,15,255,255,255,0,63,254,175,254,0,127,208,0,108,0,191,128,0,0,0,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,191,192,0,0,0,63,244,0,0,0,31,255,64,0,0,11,255,244,0,0,1,255,255,128,0,0,31,255,240,0,0,1,191,252,0,0,0,15,255,0,0,0,2,255,64,0,0,0,191,128,0,0,0,127,128,0,0,0,127,128,0,0,0,191,128,128,0,0,255,0,254,64,27,254,0,255,255,255,252,0,255,255,255,240,0,111,255,254,64,0,0,21,64,0,0,
  // 0x015d  ŝ
  15,30,120,18,2,255,0,21,64,0,0,191,224,0,2,255,244,0,7,251,253,0,15,224,191,0,63,64,47,192,104,0,2,144,0,0,0,0,0,5,64,0,2,255,255,64,47,255,255,240,127,255,255,208,255,64,6,192,254,0,0,0,255,0,0,0,255,128,0,0,191,244,0,0,63,255,128,0,11,255,252,0,0,191,255,128,0,7,255,208,0,0,127,240,0,0,15,240,0,0,11,244,0,0,11,240,228,0,31,240,255,234,255,208,255,255,255,128,111,255,248,0,0,85,0,0,
  // 0x015e  Ş
  17,36,180,20,2,247,0,26,234,64,0,2,255,255,253,0,15,255,255,255,0,63,254,175,254,0,127,208,0,108,0,191,128,0,0,0,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,191,192,0,0,0,63,244,0,0,0,31,255,64,0,0,11,255,244,0,0,1,255,255,128,0,0,31,255,240,0,0,1,191,252,0,0,0,15,255,0,0,0,2,255,64,0,0,0,191,128,0,0,0,127,128,0,0,0,127,128,0,0,0,191,128,128,0,0,255,0,254,64,27,254,0,255,255,255,252,0,255,255,255,240,0,111,255,254,64,0,0,31,192,0,0,0,15,128,0,0,0,47,240,0,0,0,7,252,0,0,0,0,253,0,0,0,0,253,0,0,0,150,252,0,0,0,255,244,0,0,0,255,128,0,0,
  // 0x015f  ş
  15,30,120,18,2,247,0,5,64,0,2,255,255,64,47,255,255,240,127,255,255,208,255,64,6,192,254,0,0,0,255,0,0,0,255,128,0,0,191,244,0,0,63,255,128,0,11,255,252,0,0,191,255,128,0,7,255,208,0,0,127,240,0,0,15,240,0,0,11,244,0,0,11,240,228,0,31,240,255,234,255,208,255,255,255,128,111,255,248,0,0,111,64,0,0,63,0,0,0,127,208,0,0,27,244,0,0,2,248,0,0,1,248,0,1,91,244,0,3,255,240,0,2,254,64,0,
  // 0x0160  Š
  17,36,180,20,2,255,5,0,0,20,0,15,224,2,252,0,3,252,15,240,0,0,255,63,192,0,0,63,255,0,0,0,31,253,0,0,0,6,164,0,0,0,0,0,0,0,0,26,234,64,0,2,255,255,253,0,15,255,255,255,0,63,254,175,254,0,127,208,0,108,0,191,128,0,0,0,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,191,192,0,0,0,63,244,0,0,0,31,255,64,0,0,11,255,244,0,0,1,255,255,128,0,0,31,255,240,0,0,1,191,252,0,0,0,15,255,0,0,0,2,255,64,0,0,0,191,128,0,0,0,127,128,0,0,0,127,128,0,0,0,191,128,128,0,0,255,0,254,64,27,254,0,255,255,255,252,0,255,255,255,240,0,111,255,254,64,0,0,21,64,0,0,
  // 0x0161  š
  15,30,120,18,2,255,84,0,1,64,127,0,31,208,31,208,127,64,11,246,253,0,2,255,248,0,0,255,240,0,0,42,128,0,0,0,0,0,0,5,64,0,2,255,255,64,47,255,255,240,127,255,255,208,255,64,6,192,254,0,0,0,255,0,0,0,255,128,0,0,191,244,0,0,63,255,128,0,11,255,252,0,0,191,255,128,0,7,255,208,0,0,127,240,0,0,15,240,0,0,11,244,0,0,11,240,228,0,31,240,255,234,255,208,255,255,255,128,111,255,248,0,0,85,0,0,
  // 0x0162  Ţ
  21,36,216,21,0,247,21,85,85,85,85,0,191,255,255,255,255,64,191,255,255,255,255,64,191,255,255,255,255,64,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,62,0,0,0,0,0,125,0,0,0,0,0,255,128,0,0,0,0,31,240,0,0,0,0,3,240,0,0,0,0,3,244,0,0,0,2,111,240,0,0,0,7,255,208,0,0,0,3,250,0,0,0,
  // 0x0163  ţ
  14,34,136,14,0,247,0,20,0,0,0,125,0,0,0,189,0,0,0,253,0,0,1,253,0,0,11,255,255,192,127,255,255,192,127,255,255,192,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,1,254,0,0,1,255,64,0,0,255,255,208,0,127,255,208,0,31,255,192,0,3,244,0,0,7,192,0,0,15,248,0,0,1,254,0,0,0,63,0,0,0,63,0,0,102,255,0,0,127,252,0,0,127,144,0,
  // 0x0164  Ť
  21,35,210,21,0,0,0,80,0,5,64,0,0,254,0,47,192,0,0,63,128,255,0,0,0,15,247,252,0,0,0,7,255,240,0,0,0,1,255,192,0,0,0,0,170,64,0,0,0,0,0,0,0,0,21,85,85,85,85,0,191,255,255,255,255,64,191,255,255,255,255,64,191,255,255,255,255,64,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,
  // 0x0165  ť
  19,29,145,14,0,255,0,0,0,7,244,0,0,0,11,240,0,0,0,15,224,0,20,0,15,192,0,125,0,15,64,0,189,0,30,0,0,253,0,0,0,1,253,0,0,0,11,255,255,192,0,127,255,255,192,0,127,255,255,192,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,1,254,0,0,0,1,255,64,0,0,0,255,255,208,0,0,127,255,208,0,0,31,255,192,0,0,0,84,0,0,
  // 0x0166  Ŧ
  21,27,162,21,0,0,21,85,85,85,85,0,191,255,255,255,255,64,191,255,255,255,255,64,191,255,255,255,255,64,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,3,255,255,255,224,0,3,255,255,255,224,0,3,255,255,255,224,0,1,85,191,149,64,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,
  // 0x0167  ŧ
  14,26,104,14,0,255,0,20,0,0,0,125,0,0,0,189,0,0,0,253,0,0,1,253,0,0,11,255,255,192,127,255,255,192,127,255,255,192,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,43,255,170,64,63,255,255,128,63,255,255,128,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,1,254,0,0,1,255,64,0,0,255,255,208,0,127,255,208,0,31,255,192,0,0,84,0,
  // 0x0168  Ũ
  21,35,210,27,3,255,0,1,64,0,80,0,0,31,248,3,224,0,0,127,255,155,208,0,0,254,191,255,192,0,0,240,11,255,0,0,0,160,0,100,0,0,0,0,0,0,0,0,85,0,0,0,21,64,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,128,0,0,63,192,127,192,0,0,127,128,63,208,0,0,255,64,47,240,0,2,255,0,15,254,64,31,253,0,7,255,255,255,244,0,0,255,255,255,208,0,0,31,255,254,0,0,0,0,21,64,0,0,
  // 0x0169  ũ
  17,29,145,23,3,255,0,20,0,5,0,1,255,128,62,0,7,255,249,188,0,15,235,255,252,0,15,0,191,240,0,10,0,6,64,0,0,0,0,0,0,0,0,0,0,0,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,192,255,128,0,255,192,191,208,7,255,192,63,255,255,239,192,31,255,255,79,192,2,255,248,15,192,0,21,0,0,0,
  // 0x016a  Ū
  21,33,198,27,3,255,0,21,85,85,0,0,0,63,255,255,64,0,0,63,255,255,64,0,0,42,170,170,0,0,0,0,0,0,0,0,85,0,0,0,21,64,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,128,0,0,63,192,127,192,0,0,127,128,63,208,0,0,255,64,47,240,0,2,255,0,15,254,64,31,253,0,7,255,255,255,244,0,0,255,255,255,208,0,0,31,255,254,0,0,0,0,21,64,0,0,
  // 0x016b  ū
  17,27,135,23,3,255,1,85,85,80,0,3,255,255,244,0,3,255,255,244,0,2,170,170,160,0,0,0,0,0,0,0,0,0,0,0,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,192,255,128,0,255,192,191,208,7,255,192,63,255,255,239,192,31,255,255,79,192,2,255,248,15,192,0,21,0,0,0,
  // 0x016c  Ŭ
  21,35,210,27,3,255,0,104,0,6,128,0,0,124,0,15,128,0,0,63,149,191,0,0,0,31,255,254,0,0,0,7,255,244,0,0,0,0,106,64,0,0,0,0,0,0,0,0,85,0,0,0,21,64,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,128,0,0,63,192,127,192,0,0,127,128,63,208,0,0,255,64,47,240,0,2,255,0,15,254,64,31,253,0,7,255,255,255,244,0,0,255,255,255,208,0,0,31,255,254,0,0,0,0,21,64,0,0,
  // 0x016d  ŭ
  17,29,145,23,3,255,6,128,0,104,0,7,192,0,248,0,3,249,91,240,0,1,255,255,224,0,0,127,255,64,0,0,6,164,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,192,255,128,0,255,192,191,208,7,255,192,63,255,255,239,192,31,255,255,79,192,2,255,248,15,192,0,21,0,0,0,
  // 0x016e  Ů
  21,38,228,27,3,255,0,0,21,0,0,0,0,1,255,208,0,0,0,3,251,244,0,0,0,7,192,184,0,0,0,11,128,124,0,0,0,7,192,184,0,0,0,3,246,244,0,0,0,1,255,224,0,0,0,0,25,0,0,0,0,0,0,0,0,0,85,0,0,0,21,64,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,128,0,0,63,192,127,192,0,0,127,128,63,208,0,0,255,64,47,240,0,2,255,0,15,254,64,31,253,0,7,255,255,255,244,0,0,255,255,255,208,0,0,31,255,254,0,0,0,0,21,64,0,0,
  // 0x016f  ů
  17,32,160,23,3,255,0,1,80,0,0,0,31,253,0,0,0,63,191,64,0,0,124,11,128,0,0,184,7,192,0,0,124,11,128,0,0,63,111,64,0,0,31,254,0,0,0,1,144,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,192,255,128,0,255,192,191,208,7,255,192,63,255,255,239,192,31,255,255,79,192,2,255,248,15,192,0,21,0,0,0,
  // 0x0170  Ű
  21,36,216,27,3,255,0,1,84,5,64,0,0,11,248,63,208,0,0,15,240,127,128,0,0,47,192,254,0,0,0,127,2,248,0,0,0,252,7,224,0,0,0,160,6,64,0,0,0,0,0,0,0,0,85,0,0,0,21,64,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,128,0,0,63,192,127,192,0,0,127,128,63,208,0,0,255,64,47,240,0,2,255,0,15,254,64,31,253,0,7,255,255,255,244,0,0,255,255,255,208,0,0,31,255,254,0,0,0,0,21,64,0,0,
  // 0x0171  ű
  17,30,150,23,3,255,0,21,64,84,0,0,191,131,253,0,0,255,7,248,0,2,252,15,224,0,7,240,47,128,0,15,192,126,0,0,10,0,100,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,192,255,128,0,255,192,191,208,7,255,192,63,255,255,239,192,31,255,255,79,192,2,255,248,15,192,0,21,0,0,0,
  // 0x0172  Ų
  21,36,216,27,3,247,85,0,0,0,21,64,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,128,0,0,63,192,127,192,0,0,127,128,63,208,0,0,255,64,47,240,0,2,255,0,15,254,64,31,253,0,7,255,255,255,244,0,0,255,255,255,208,0,0,31,255,255,128,0,0,0,21,127,0,0,0,0,0,188,0,0,0,0,0,248,0,0,0,0,1,248,0,0,0,0,2,248,0,0,0,0,1,253,16,0,0,0,0,255,240,0,0,0,0,127,240,0,0,0,0,5,64,0,
  // 0x0173  ų
  18,29,145,23,3,247,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,192,255,128,0,255,192,191,208,7,255,192,63,255,255,239,192,31,255,255,79,192,2,255,248,15,192,0,21,0,63,0,0,0,0,252,0,0,0,1,244,0,0,0,3,240,0,0,0,3,240,0,0,0,3,244,64,0,0,2,255,208,0,0,0,255,208,0,0,0,5,0,
  // 0x0174  Ŵ
  34,35,59,35,0,0,0,0,0,1,84,0,0,0,0,0,0,0,7,255,0,0,0,0,0,0,0,15,255,192,0,0,0,0,0,0,63,239,224,0,0,0,0,0,0,191,7,248,0,0,0,0,0,2,248,0,254,0,0,0,0,0,2,144,0,42,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,1,84,0,0,5,80,127,128,0,3,254,0,0,15,240,63,192,0,3,255,0,0,15,240,63,192,0,11,255,0,0,31,224,47,208,0,15,255,64,0,47,208,31,224,0,15,255,128,0,63,192,15,240,0,31,239,192,0,63,192,15,240,0,47,207,208,0,127,128,11,244,0,63,143,224,0,191,64,7,248,0,63,75,240,0,255,0,3,252,0,127,7,240,0,255,0,3,252,0,255,3,244,1,254,0,2,253,0,254,3,252,2,253,0,1,254,1,253,2,252,3,252,0,0,255,2,252,1,253,3,252,0,0,255,3,248,0,254,7,248,0,0,191,67,244,0,191,11,244,0,0,127,135,240,0,127,15,240,0,0,63,203,240,0,63,79,240,0,0,47,207,224,0,63,143,224,0,0,31,223,208,0,47,223,192,0,0,15,239,192,0,31,239,192,0,0,15,255,128,0,15,255,128,0,0,11,255,64,0,11,255,64,0,0,7,255,0,0,7,255,0,0,0,3,255,0,0,3,255,0,0,0,3,254,0,0,3,254,0,0,
  // 0x0175  ŵ
  30,29,232,30,0,0,0,0,0,21,64,0,0,0,0,0,0,255,224,0,0,0,0,0,2,255,244,0,0,0,0,0,7,251,252,0,0,0,0,0,31,224,191,0,0,0,0,0,63,64,47,192,0,0,0,0,104,0,6,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,128,0,127,192,0,47,208,63,192,0,191,224,0,63,192,63,192,0,255,240,0,63,192,47,208,0,255,240,0,127,64,31,224,2,251,244,0,191,0,15,240,3,246,248,0,255,0,15,240,3,241,252,0,254,0,11,244,7,240,253,1,253,0,7,248,11,224,254,2,252,0,3,252,15,208,191,3,252,0,2,252,31,192,127,7,248,0,1,253,47,192,63,75,240,0,0,254,63,128,63,139,240,0,0,255,63,0,31,207,224,0,0,191,127,0,15,223,208,0,0,127,190,0,15,239,192,0,0,63,253,0,11,255,192,0,0,63,252,0,7,255,128,0,0,31,248,0,3,255,64,0,0,15,244,0,2,255,0,0,
  // 0x0176  Ŷ
  21,35,210,22,0,0,0,0,21,64,0,0,0,0,255,208,0,0,0,2,255,240,0,0,0,11,251,252,0,0,0,31,208,255,0,0,0,127,64,47,192,0,0,168,0,6,144,0,0,0,0,0,0,0,85,0,0,0,21,64,191,192,0,0,63,192,63,208,0,0,191,128,31,240,0,1,255,0,15,244,0,3,253,0,7,252,0,7,252,0,3,253,0,15,244,0,1,255,0,31,240,0,0,191,64,63,208,0,0,63,192,127,128,0,0,47,224,255,0,0,0,15,241,254,0,0,0,11,251,252,0,0,0,3,255,248,0,0,0,1,255,240,0,0,0,0,255,208,0,0,0,0,127,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,
  // 0x0177  ŷ
  20,38,190,20,0,247,0,0,85,0,0,0,3,255,64,0,0,11,255,192,0,0,47,239,240,0,0,127,67,252,0,1,253,0,191,0,2,160,0,26,64,0,0,0,0,0,0,0,0,0,0,191,64,0,3,253,127,192,0,3,252,63,192,0,11,248,47,224,0,15,240,15,240,0,31,240,15,240,0,47,208,7,248,0,63,192,3,252,0,127,128,2,253,0,191,64,0,254,0,255,0,0,255,1,254,0,0,127,66,252,0,0,63,195,252,0,0,47,199,244,0,0,15,219,240,0,0,15,239,224,0,0,7,255,208,0,0,3,255,192,0,0,2,255,128,0,0,0,255,0,0,0,0,255,0,0,0,2,253,0,0,0,3,252,0,0,0,7,248,0,0,0,31,240,0,0,21,191,224,0,0,127,255,128,0,0,127,254,0,0,0,47,224,0,0,0,
  // 0x0178  Ÿ
  21,33,198,22,0,0,0,31,192,127,0,0,0,47,192,191,0,0,0,47,192,127,0,0,0,10,64,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,0,21,64,191,192,0,0,63,192,63,208,0,0,191,128,31,240,0,1,255,0,15,244,0,3,253,0,7,252,0,7,252,0,3,253,0,15,244,0,1,255,0,31,240,0,0,191,64,63,208,0,0,63,192,127,128,0,0,47,224,255,0,0,0,15,241,254,0,0,0,11,251,252,0,0,0,3,255,248,0,0,0,1,255,240,0,0,0,0,255,208,0,0,0,0,127,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,
  // 0x0179  Ź
  19,35,175,21,1,0,0,0,1,85,0,0,0,3,254,0,0,0,15,248,0,0,0,31,224,0,0,0,63,128,0,0,0,254,0,0,0,0,164,0,0,0,0,0,0,0,21,85,85,85,84,127,255,255,255,248,127,255,255,255,248,127,255,255,255,248,0,0,0,47,240,0,0,0,63,192,0,0,0,255,128,0,0,2,255,0,0,0,3,252,0,0,0,15,248,0,0,0,47,240,0,0,0,63,192,0,0,0,255,128,0,0,2,255,0,0,0,7,252,0,0,0,15,244,0,0,0,47,240,0,0,0,127,192,0,0,0,255,64,0,0,2,255,0,0,0,7,252,0,0,0,15,244,0,0,0,47,240,0,0,0,127,229,85,85,84,191,255,255,255,252,191,255,255,255,252,191,255,255,255,252,
  // 0x017a  ź
  16,29,116,18,1,0,0,0,21,80,0,0,63,224,0,0,255,128,0,1,254,0,0,3,248,0,0,15,224,0,0,10,64,0,0,0,0,0,0,0,0,0,63,255,255,252,63,255,255,252,63,255,255,252,0,0,15,244,0,0,31,240,0,0,63,192,0,0,255,64,0,2,254,0,0,7,252,0,0,15,240,0,0,47,208,0,0,127,192,0,0,255,0,0,3,253,0,0,11,248,0,0,31,240,0,0,63,208,0,0,191,255,255,253,191,255,255,253,191,255,255,253,
  // 0x017b  Ż
  19,34,170,21,1,0,0,0,20,0,0,0,0,254,0,0,0,1,255,0,0,0,1,255,0,0,0,0,189,0,0,0,0,0,0,0,0,0,0,0,0,21,85,85,85,84,127,255,255,255,248,127,255,255,255,248,127,255,255,255,248,0,0,0,47,240,0,0,0,63,192,0,0,0,255,128,0,0,2,255,0,0,0,3,252,0,0,0,15,248,0,0,0,47,240,0,0,0,63,192,0,0,0,255,128,0,0,2,255,0,0,0,7,252,0,0,0,15,244,0,0,0,47,240,0,0,0,127,192,0,0,0,255,64,0,0,2,255,0,0,0,7,252,0,0,0,15,244,0,0,0,47,240,0,0,0,127,229,85,85,84,191,255,255,255,252,191,255,255,255,252,191,255,255,255,252,
  // 0x017c  ż
  16,28,112,18,1,0,0,1,64,0,0,15,224,0,0,31,240,0,0,31,240,0,0,11,208,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,252,63,255,255,252,63,255,255,252,0,0,15,244,0,0,31,240,0,0,63,192,0,0,255,64,0,2,254,0,0,7,252,0,0,15,240,0,0,47,208,0,0,127,192,0,0,255,0,0,3,253,0,0,11,248,0,0,31,240,0,0,63,208,0,0,191,255,255,253,191,255,255,253,191,255,255,253,
  // 0x017d  Ž
  19,35,175,21,1,0,1,80,0,5,0,2,252,0,127,0,0,191,2,253,0,0,47,219,244,0,0,15,255,208,0,0,3,255,128,0,0,1,170,0,0,0,0,0,0,0,21,85,85,85,84,127,255,255,255,248,127,255,255,255,248,127,255,255,255,248,0,0,0,47,240,0,0,0,63,192,0,0,0,255,128,0,0,2,255,0,0,0,3,252,0,0,0,15,248,0,0,0,47,240,0,0,0,63,192,0,0,0,255,128,0,0,2,255,0,0,0,7,252,0,0,0,15,244,0,0,0,47,240,0,0,0,127,192,0,0,0,255,64,0,0,2,255,0,0,0,7,252,0,0,0,15,244,0,0,0,47,240,0,0,0,127,229,85,85,84,191,255,255,255,252,191,255,255,255,252,191,255,255,255,252,
  // 0x017e  ž
  16,29,116,18,1,0,21,0,0,80,47,192,7,240,11,240,47,208,2,253,191,64,0,255,253,0,0,63,248,0,0,26,160,0,0,0,0,0,0,0,0,0,63,255,255,252,63,255,255,252,63,255,255,252,0,0,15,244,0,0,31,240,0,0,63,192,0,0,255,64,0,2,254,0,0,7,252,0,0,15,240,0,0,47,208,0,0,127,192,0,0,255,0,0,3,253,0,0,11,248,0,0,31,240,0,0,63,208,0,0,191,255,255,253,191,255,255,253,191,255,255,253,
  // 0x017f  ſ
  11,29,87,13,3,0,0,5,0,2,255,248,31,255,248,63,255,240,127,208,16,191,64,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,
};

#endif // HAS_GRAPHICAL_TFT
