/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Vietnamese 36pt, capital 'A' height: 26px, width: 100%, range: 0x0102-0x1ef9, glyphs: 107
extern const uint8_t NotoSans_Medium_Vietnamese_26[18855] = {
  162,26,2,1,249,30,34,247, // unifont_t
  // 0x0102  Ă
  2,1,24,33,198,24,0,0,0,15,0,2,224,0,0,15,128,7,208,0,0,11,255,255,192,0,0,3,255,255,0,0,0,0,191,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x0103  ă
  3,1,17,28,140,21,1,255,2,224,0,60,0,1,244,0,188,0,0,255,255,248,0,0,127,255,224,0,0,11,255,64,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x0110  Đ
  16,1,23,26,156,26,1,0,6,170,170,144,0,0,7,255,255,255,128,0,7,255,255,255,244,0,7,254,170,255,254,0,7,244,0,7,255,128,7,244,0,0,191,208,7,244,0,0,47,240,7,244,0,0,15,244,7,244,0,0,11,248,7,244,0,0,7,252,7,244,0,0,3,252,91,249,85,0,3,252,255,255,255,64,3,252,255,255,255,64,3,252,255,255,255,0,3,252,7,244,0,0,3,252,7,244,0,0,7,252,7,244,0,0,11,248,7,244,0,0,15,244,7,244,0,0,47,240,7,244,0,0,191,208,7,244,0,7,255,128,7,249,85,191,254,0,7,255,255,255,248,0,7,255,255,255,128,0,7,255,255,228,0,0,
  // 0x0111  đ
  17,1,20,29,145,23,2,255,0,0,0,5,64,0,0,0,31,208,0,0,0,31,208,0,1,85,111,229,0,11,255,255,255,0,11,255,255,255,0,1,85,111,229,0,0,0,31,208,0,5,64,31,208,0,191,253,31,208,7,255,255,159,208,31,255,255,255,208,63,240,2,255,208,127,192,0,127,208,191,128,0,63,208,255,0,0,47,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,47,208,191,64,0,63,208,127,192,0,127,208,63,240,1,255,208,31,255,255,239,208,7,255,255,143,208,0,191,253,15,208,0,5,64,0,0,
  // 0x0128  Ĩ
  40,1,14,33,132,13,255,0,1,160,0,160,15,254,1,240,47,255,251,224,62,31,255,192,124,1,255,0,0,0,0,0,0,0,0,0,6,170,170,0,11,255,255,64,7,255,255,0,0,47,224,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,2,255,253,0,11,255,255,64,11,255,255,64,
  // 0x0129  ĩ
  41,1,14,27,108,10,254,0,2,144,1,144,31,253,3,208,63,255,239,192,189,47,255,128,244,2,254,0,0,0,0,0,0,0,0,0,0,21,64,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,
  // 0x0168  Ũ
  104,1,21,34,204,27,3,255,0,6,128,2,128,0,0,63,248,7,192,0,0,191,255,239,128,0,0,248,127,255,0,0,1,240,7,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,0,0,0,106,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,191,64,191,64,0,0,191,0,127,128,0,0,255,0,63,192,0,1,255,0,63,224,0,3,253,0,15,253,0,47,248,0,7,255,255,255,240,0,1,255,255,255,128,0,0,47,255,249,0,0,0,0,21,0,0,0,
  // 0x0169  ũ
  105,1,17,28,140,23,3,255,0,104,0,40,0,3,255,128,124,0,11,255,254,248,0,15,135,255,240,0,31,0,127,192,0,0,0,0,0,0,0,0,0,0,0,85,0,0,21,64,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,127,128,254,0,0,127,128,255,0,0,255,128,255,64,1,255,128,191,192,7,255,128,127,255,255,255,128,47,255,255,47,128,7,255,248,31,128,0,21,0,0,0,
  // 0x01a0  Ơ
  160,1,28,29,203,29,2,255,0,0,0,0,0,1,84,0,0,0,0,0,3,253,0,1,191,254,64,3,252,0,31,255,255,248,3,252,0,255,255,255,255,11,244,3,255,229,91,255,239,240,11,254,0,0,127,255,192,15,248,0,0,15,253,0,47,240,0,0,11,252,0,63,208,0,0,3,253,0,127,192,0,0,2,254,0,191,128,0,0,1,255,0,191,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,191,64,0,0,0,255,0,191,128,0,0,1,255,0,127,192,0,0,2,254,0,63,192,0,0,3,253,0,63,224,0,0,7,252,0,31,244,0,0,15,248,0,15,253,0,0,63,240,0,3,255,144,2,255,208,0,0,255,255,255,255,64,0,0,47,255,255,252,0,0,0,6,255,255,144,0,0,0,0,5,80,0,0,0,
  // 0x01a1  ơ
  161,1,22,24,144,23,2,255,0,0,0,0,5,80,0,0,0,0,15,240,0,0,0,0,31,224,0,6,169,0,31,208,0,191,255,224,63,192,7,255,255,253,255,64,15,254,91,255,253,0,63,224,0,191,224,0,127,192,0,63,192,0,191,64,0,31,208,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,224,0,127,128,0,47,208,0,63,192,0,63,192,0,31,244,1,255,128,0,11,255,255,255,0,0,2,255,255,248,0,0,0,111,255,144,0,0,0,1,80,0,0,0,
  // 0x01af  Ư
  175,1,27,29,203,29,3,255,0,0,0,0,0,1,84,0,0,0,0,0,3,252,170,0,0,0,106,67,252,255,0,0,0,127,71,248,255,0,0,0,127,75,240,255,0,0,0,127,175,208,255,0,0,0,127,255,128,255,0,0,0,127,249,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,191,64,0,191,64,0,0,191,0,0,127,128,0,0,255,0,0,63,192,0,1,255,0,0,63,224,0,3,253,0,0,15,253,0,47,252,0,0,7,255,255,255,240,0,0,1,255,255,255,192,0,0,0,31,255,253,0,0,0,0,0,21,0,0,0,0,
  // 0x01b0  ư
  176,1,24,24,144,25,3,255,0,0,0,0,1,84,0,0,0,0,2,253,0,0,0,0,3,252,84,0,0,21,67,252,254,0,0,63,135,244,254,0,0,63,239,240,254,0,0,63,255,192,254,0,0,63,253,0,254,0,0,63,192,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,127,128,0,254,0,0,127,128,0,255,0,0,255,128,0,255,64,1,255,128,0,191,192,7,255,128,0,63,255,255,255,128,0,31,255,255,47,128,0,7,255,248,31,128,0,0,21,0,0,0,0,
  // 0x0303  ̃
  3,3,14,6,24,0,238,21,2,144,1,144,31,253,3,208,63,255,239,192,189,47,255,128,244,2,254,0,0,0,0,0,
  // 0x0309  ̉
  9,3,8,9,18,0,242,21,106,64,191,244,107,252,0,253,0,252,7,248,31,224,15,64,10,0,
  // 0x0323  ̣
  35,3,4,5,5,0,243,249,40,255,255,255,40,
  // 0x0340  ̀
  64,3,8,7,14,0,250,21,170,0,191,128,63,208,15,240,2,252,0,190,0,0,
  // 0x0341  ́
  65,3,8,7,14,0,254,21,0,170,2,254,7,252,15,240,63,128,190,0,0,0,
  // 0x1ea0  Ạ
  160,30,24,33,198,24,0,249,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,128,0,0,0,0,15,240,0,0,0,0,31,240,0,0,0,0,15,240,0,0,0,0,6,128,0,0,
  // 0x1ea1  ạ
  161,30,17,27,135,21,1,249,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,0,0,0,0,0,0,0,164,0,0,0,2,252,0,0,0,3,253,0,0,0,2,252,0,0,0,0,164,0,0,
  // 0x1ea2  Ả
  162,30,24,36,216,24,0,0,0,0,42,128,0,0,0,0,127,248,0,0,0,0,106,253,0,0,0,0,0,190,0,0,0,0,0,189,0,0,0,0,6,252,0,0,0,0,15,224,0,0,0,0,15,128,0,0,0,0,10,64,0,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x1ea3  ả
  163,30,17,31,155,21,1,255,0,6,164,0,0,0,15,255,64,0,0,10,191,192,0,0,0,15,192,0,0,0,15,192,0,0,0,127,128,0,0,1,253,0,0,0,1,240,0,0,0,0,160,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x1ea4  Ấ
  164,30,24,35,210,24,0,0,0,0,0,0,15,224,0,0,0,0,47,128,0,0,47,240,126,0,0,0,127,252,184,0,0,0,254,254,0,0,0,3,244,63,64,0,0,15,192,11,208,0,0,5,0,0,64,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x1ea5  ấ
  165,30,19,30,150,21,1,255,0,0,0,1,252,0,0,0,3,240,0,3,254,15,192,0,15,255,94,0,0,47,239,192,0,0,126,7,240,0,1,244,0,252,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x1ea6  Ầ
  166,30,24,35,210,24,0,0,15,208,0,0,0,0,3,240,0,0,0,0,1,248,47,240,0,0,0,61,127,248,0,0,0,0,254,254,0,0,0,3,244,63,64,0,0,15,192,11,208,0,0,4,0,0,64,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x1ea7  ầ
  167,30,18,30,150,21,0,255,127,0,0,0,0,47,128,0,0,0,11,208,255,128,0,1,227,255,208,0,0,11,251,240,0,0,31,193,252,0,0,62,0,63,0,0,0,0,0,0,0,0,0,0,0,0,1,170,144,0,0,127,255,253,0,0,255,255,255,128,0,190,85,255,192,0,16,0,47,208,0,0,0,15,224,0,0,0,15,240,0,0,0,15,240,0,1,170,255,240,0,127,255,255,240,2,255,255,175,240,11,253,0,15,240,15,240,0,15,240,31,224,0,15,240,31,224,0,31,240,31,224,0,63,240,15,244,0,255,240,11,255,175,251,240,3,255,255,199,240,0,191,254,3,240,0,5,64,0,0,
  // 0x1ea8  Ẩ
  168,30,24,38,228,24,0,0,0,0,0,0,80,0,0,0,0,1,254,0,0,0,0,0,95,64,0,0,0,0,11,128,0,0,0,0,47,0,0,0,47,240,184,0,0,0,127,248,116,0,0,1,254,253,0,0,0,3,244,63,64,0,0,15,192,11,192,0,0,4,0,0,64,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x1ea9  ẩ
  169,30,19,33,165,21,1,255,0,0,0,5,0,0,0,0,47,224,0,0,0,21,240,0,0,0,0,244,0,0,0,6,240,0,3,254,15,64,0,11,255,75,0,0,47,223,192,0,0,127,7,240,0,0,248,0,252,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x1eaa  Ẫ
  170,30,24,38,228,24,0,0,0,0,168,0,208,0,0,3,255,146,208,0,0,11,239,255,192,0,0,15,1,255,0,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,63,248,0,0,0,0,254,253,0,0,0,3,244,63,64,0,0,11,192,11,208,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x1eab  ẫ
  171,30,17,33,165,21,1,255,0,31,128,44,0,0,191,249,124,0,0,250,255,244,0,1,208,31,224,0,0,0,0,0,0,0,2,253,0,0,0,11,255,0,0,0,31,239,192,0,0,127,7,240,0,1,244,0,252,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x1eac  Ậ
  172,30,24,41,246,24,0,249,0,0,26,160,0,0,0,0,63,248,0,0,0,0,255,253,0,0,0,2,253,191,0,0,0,11,240,47,192,0,0,31,128,7,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,128,0,0,0,0,15,240,0,0,0,0,31,240,0,0,0,0,15,240,0,0,0,0,6,128,0,0,
  // 0x1ead  ậ
  173,30,17,35,175,21,1,249,0,2,169,0,0,0,7,255,0,0,0,15,255,192,0,0,63,143,240,0,0,254,3,248,0,3,244,0,190,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,0,0,0,0,0,0,0,160,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,0,160,0,0,
  // 0x1eae  Ắ
  174,30,24,37,222,24,0,0,0,0,0,21,0,0,0,0,0,254,0,0,0,0,1,248,0,0,0,0,3,224,0,0,0,11,70,66,208,0,0,11,192,7,192,0,0,3,245,111,192,0,0,2,255,255,0,0,0,0,127,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x1eaf  ắ
  175,30,17,32,160,21,1,255,0,0,5,64,0,0,0,31,192,0,0,0,63,0,0,0,0,188,0,0,0,240,160,120,0,0,244,0,248,0,0,190,91,240,0,0,63,255,224,0,0,11,255,64,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x1eb0  Ằ
  176,30,24,37,222,24,0,0,0,0,84,0,0,0,0,0,252,0,0,0,0,0,127,0,0,0,0,0,31,64,0,0,0,11,66,130,208,0,0,11,128,7,192,0,0,7,245,111,128,0,0,2,255,255,0,0,0,0,191,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x1eb1  ằ
  177,30,17,32,160,21,1,255,0,21,0,0,0,0,47,128,0,0,0,11,208,0,0,0,2,240,0,0,1,240,100,120,0,0,244,0,248,0,0,254,91,240,0,0,63,255,224,0,0,11,255,64,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x1eb2  Ẳ
  178,30,24,38,228,24,0,0,0,0,9,64,0,0,0,0,47,240,0,0,0,0,0,244,0,0,0,0,0,240,0,0,0,0,7,224,0,0,0,11,71,66,208,0,0,11,128,7,192,0,0,7,245,111,128,0,0,2,255,255,0,0,0,0,191,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x1eb3  ẳ
  179,30,17,33,165,21,1,255,0,1,160,0,0,0,3,253,0,0,0,0,31,0,0,0,0,31,0,0,0,0,252,0,0,0,240,160,124,0,0,244,0,184,0,0,190,91,244,0,0,63,255,224,0,0,11,255,64,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x1eb4  Ẵ
  180,30,24,38,228,24,0,0,0,0,168,0,144,0,0,3,255,146,208,0,0,11,239,255,192,0,0,15,1,191,64,0,0,0,0,0,0,0,0,10,0,2,128,0,0,11,128,3,192,0,0,7,229,111,192,0,0,3,255,255,0,0,0,0,191,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x1eb5  ẵ
  181,30,17,33,165,21,1,255,0,26,64,28,0,0,127,248,124,0,0,250,255,248,0,1,224,31,224,0,0,0,0,0,0,0,160,0,40,0,0,240,0,184,0,0,254,87,244,0,0,63,255,224,0,0,11,255,64,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x1eb6  Ặ
  182,30,24,40,240,24,0,249,0,15,64,2,240,0,0,15,128,7,224,0,0,7,255,255,192,0,0,2,255,255,64,0,0,0,127,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,128,0,0,0,0,15,240,0,0,0,0,31,240,0,0,0,0,15,240,0,0,0,0,6,128,0,0,
  // 0x1eb7  ặ
  183,30,17,34,170,21,1,249,1,240,0,61,0,0,244,0,188,0,0,255,255,248,0,0,63,255,240,0,0,11,255,128,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,0,0,0,0,0,0,1,160,0,0,0,7,248,0,0,0,7,252,0,0,0,7,248,0,0,0,1,160,0,0,
  // 0x1eb8  Ẹ
  184,30,15,33,132,20,3,249,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,0,0,0,0,0,0,0,0,0,6,128,0,0,15,224,0,0,31,240,0,0,15,224,0,0,6,128,0,
  // 0x1eb9  ẹ
  185,30,17,27,135,21,2,249,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,0,0,0,0,0,0,1,160,0,0,0,3,248,0,0,0,7,252,0,0,0,3,248,0,0,0,1,160,0,0,
  // 0x1eba  Ẻ
  186,30,15,36,144,20,3,0,0,42,144,0,0,63,252,0,0,42,254,0,0,0,126,0,0,0,126,0,0,6,252,0,0,15,240,0,0,11,192,0,0,6,128,0,0,0,0,0,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x1ebb  ẻ
  187,30,17,31,155,21,2,255,0,6,164,0,0,0,15,255,0,0,0,10,191,128,0,0,0,15,192,0,0,0,15,192,0,0,0,191,64,0,0,2,253,0,0,0,2,240,0,0,0,1,160,0,0,0,0,0,0,0,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,
  // 0x1ebc  Ẽ
  188,30,15,33,132,20,3,0,0,164,0,100,7,255,64,244,15,255,251,240,47,75,255,224,61,0,191,128,0,0,0,0,0,0,0,0,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x1ebd  ẽ
  189,30,17,28,140,21,2,255,0,104,0,40,0,3,255,128,124,0,11,255,254,248,0,15,135,255,240,0,31,0,127,192,0,0,0,0,0,0,0,0,0,0,0,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,
  // 0x1ebe  Ế
  190,30,18,35,175,20,3,0,0,0,0,15,224,0,0,0,47,128,0,47,240,126,0,0,127,248,244,0,0,254,253,0,0,3,244,63,64,0,15,192,11,192,0,4,0,0,64,0,0,0,0,0,0,106,170,170,168,0,191,255,255,252,0,191,255,255,252,0,191,170,170,168,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,255,255,244,0,191,255,255,244,0,191,255,255,244,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,149,85,84,0,191,255,255,252,0,191,255,255,252,0,191,255,255,252,0,
  // 0x1ebf  ế
  191,30,19,30,150,21,2,255,0,0,0,3,244,0,0,0,15,208,0,11,252,31,64,0,47,254,45,0,0,127,127,64,0,0,252,15,208,0,3,224,2,240,0,0,0,0,0,0,0,0,0,0,0,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,
  // 0x1ec0  Ề
  192,30,17,35,175,20,1,0,254,0,0,0,0,63,0,0,0,0,15,193,255,0,0,3,215,255,192,0,0,15,239,224,0,0,63,66,244,0,0,188,0,189,0,0,80,0,4,0,0,0,0,0,0,6,170,170,170,128,11,255,255,255,192,11,255,255,255,192,11,250,170,170,128,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,255,255,255,64,11,255,255,255,64,11,255,255,255,64,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,249,85,85,64,11,255,255,255,192,11,255,255,255,192,11,255,255,255,192,
  // 0x1ec1  ề
  193,30,18,30,150,21,1,255,253,0,0,0,0,63,0,0,0,0,15,130,255,0,0,2,199,255,192,0,0,15,239,224,0,0,63,66,244,0,0,252,0,189,0,0,0,0,0,0,0,0,0,0,0,0,2,170,64,0,0,63,255,244,0,1,255,255,253,0,3,254,70,255,64,15,244,0,63,192,31,224,0,47,208,47,192,0,15,224,63,192,0,15,224,63,234,170,175,240,63,255,255,255,240,63,255,255,255,240,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,47,224,0,0,0,15,244,0,0,0,11,253,0,6,192,3,255,255,255,192,0,191,255,255,192,0,27,255,254,0,0,0,21,64,0,
  // 0x1ec2  Ể
  194,30,17,38,190,20,3,0,0,0,0,80,0,0,0,1,254,0,0,0,0,95,64,0,0,0,11,128,0,0,0,47,0,0,47,240,184,0,0,127,248,116,0,0,254,253,0,0,3,244,63,64,0,15,192,11,192,0,4,0,0,64,0,0,0,0,0,0,106,170,170,168,0,191,255,255,252,0,191,255,255,252,0,191,170,170,168,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,255,255,244,0,191,255,255,244,0,191,255,255,244,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,149,85,84,0,191,255,255,252,0,191,255,255,252,0,191,255,255,252,0,
  // 0x1ec3  ể
  195,30,18,33,165,21,2,255,0,0,0,20,0,0,0,0,191,128,0,0,0,23,208,0,0,0,3,208,0,0,0,27,192,0,15,252,46,0,0,47,254,44,0,0,127,127,64,0,1,252,15,192,0,3,224,2,240,0,0,0,0,0,0,0,0,0,0,0,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,
  // 0x1ec4  Ễ
  196,30,15,38,152,20,3,0,0,168,1,208,3,255,147,208,11,239,255,192,15,1,255,0,0,0,0,0,0,31,224,0,0,63,248,0,0,254,253,0,3,244,63,64,15,192,11,192,4,0,0,64,0,0,0,0,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x1ec5  ễ
  197,30,17,33,165,21,2,255,0,110,0,116,0,1,255,229,240,0,3,235,255,224,0,3,128,127,128,0,0,0,0,0,0,0,11,248,0,0,0,31,253,0,0,0,63,191,64,0,0,252,15,192,0,3,224,2,240,0,0,0,0,0,0,0,0,0,0,0,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,
  // 0x1ec6  Ệ
  198,30,15,41,164,20,3,249,0,10,160,0,0,63,252,0,0,191,254,0,1,253,127,64,7,244,31,208,31,192,3,244,0,0,0,0,0,0,0,0,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,0,0,0,0,0,0,0,0,0,6,128,0,0,15,224,0,0,31,240,0,0,15,224,0,0,6,128,0,
  // 0x1ec7  ệ
  199,30,17,35,175,21,2,249,0,6,164,0,0,0,31,252,0,0,0,63,255,0,0,0,255,63,192,0,3,248,15,224,0,15,208,2,248,0,0,0,0,0,0,0,0,0,0,0,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,0,0,0,0,0,0,1,160,0,0,0,3,248,0,0,0,7,252,0,0,0,3,248,0,0,0,1,160,0,0,
  // 0x1ec8  Ỉ
  200,30,11,36,108,13,1,0,2,164,0,7,255,128,6,191,208,0,11,224,0,11,208,0,111,192,0,254,0,0,248,0,0,180,0,0,0,0,106,170,160,191,255,244,127,255,240,2,254,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,47,255,208,191,255,244,191,255,244,
  // 0x1ec9  ỉ
  201,30,7,30,60,10,2,0,106,64,255,240,171,252,0,252,0,252,7,248,31,208,31,0,10,0,0,0,21,64,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,
  // 0x1eca  Ị
  202,30,11,33,99,13,1,249,106,170,160,191,255,244,127,255,240,2,254,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,47,255,208,191,255,244,191,255,244,0,0,0,0,0,0,0,164,0,2,253,0,3,253,0,2,253,0,0,164,0,
  // 0x1ecb  ị
  203,30,4,34,34,10,3,249,104,255,255,255,40,0,0,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,40,255,255,255,40,
  // 0x1ecc  Ọ
  204,30,24,33,198,28,2,249,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,0,0,0,0,0,0,0,0,2,144,0,0,0,0,15,240,0,0,0,0,15,244,0,0,0,0,15,240,0,0,0,0,2,144,0,0,
  // 0x1ecd  ọ
  205,30,18,27,135,22,2,249,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,0,0,0,0,0,0,1,160,0,0,0,3,252,0,0,0,7,252,0,0,0,3,252,0,0,0,1,160,0,0,
  // 0x1ece  Ỏ
  206,30,24,37,222,28,2,255,0,0,10,144,0,0,0,0,47,253,0,0,0,0,42,255,0,0,0,0,0,63,64,0,0,0,0,63,0,0,0,0,1,191,0,0,0,0,7,248,0,0,0,0,3,208,0,0,0,0,3,192,0,0,0,0,0,0,0,0,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,
  // 0x1ecf  ỏ
  207,30,18,31,155,22,2,255,0,6,164,0,0,0,15,255,64,0,0,10,191,192,0,0,0,15,192,0,0,0,15,192,0,0,0,127,128,0,0,1,253,0,0,0,1,240,0,0,0,0,160,0,0,0,0,0,0,0,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,
  // 0x1ed0  Ố
  208,30,24,36,216,28,2,255,0,0,0,0,11,240,0,0,0,0,15,192,0,0,15,244,63,0,0,0,63,252,120,0,0,0,191,191,0,0,0,2,248,47,128,0,0,7,208,7,224,0,0,1,0,0,64,0,0,0,0,0,0,0,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,
  // 0x1ed1  ố
  209,30,19,30,150,22,2,255,0,0,0,3,248,0,0,0,7,224,0,7,253,15,128,0,15,255,46,0,0,63,191,128,0,0,253,11,224,0,2,240,1,244,0,0,0,0,0,0,0,0,0,0,0,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,
  // 0x1ed2  Ồ
  210,30,24,36,216,28,2,255,11,240,0,0,0,0,2,244,0,0,0,0,0,188,15,244,0,0,0,46,63,252,0,0,0,0,191,191,0,0,0,2,248,31,192,0,0,7,208,7,224,0,0,1,0,0,64,0,0,0,0,0,0,0,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,
  // 0x1ed3  ồ
  211,30,19,30,150,22,1,255,254,0,0,0,0,63,64,0,0,0,15,193,255,64,0,2,211,255,192,0,0,15,235,240,0,0,47,66,248,0,0,189,0,126,0,0,0,0,0,0,0,0,0,0,0,0,1,170,64,0,0,47,255,248,0,1,255,255,255,0,3,255,150,255,192,15,248,0,47,224,31,240,0,15,240,47,208,0,7,248,63,192,0,3,252,63,192,0,3,252,63,192,0,3,252,63,192,0,3,252,63,192,0,3,252,63,192,0,3,252,63,192,0,7,248,31,224,0,11,244,15,240,0,15,240,7,253,0,127,224,2,255,255,255,192,0,191,255,254,0,0,27,255,228,0,0,0,84,0,0,
  // 0x1ed4  Ổ
  212,30,24,39,234,28,2,255,0,0,0,0,16,0,0,0,0,0,255,64,0,0,0,0,91,192,0,0,0,0,3,192,0,0,0,0,31,128,0,0,31,244,61,0,0,0,63,252,56,0,0,0,255,191,0,0,0,2,248,47,128,0,0,7,208,7,224,0,0,1,0,0,64,0,0,0,0,0,0,0,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,
  // 0x1ed5  ổ
  213,30,18,33,165,22,2,255,0,0,0,20,0,0,0,0,63,192,0,0,0,22,224,0,0,0,1,240,0,0,0,11,208,0,7,253,31,0,0,15,255,13,0,0,63,191,128,0,0,253,11,224,0,2,240,1,244,0,0,0,0,0,0,0,0,0,0,0,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,
  // 0x1ed6  Ỗ
  214,30,24,39,234,28,2,255,0,0,105,0,176,0,0,2,255,209,224,0,0,7,235,255,208,0,0,11,64,191,64,0,0,0,0,0,0,0,0,0,11,240,0,0,0,0,47,252,0,0,0,0,191,190,0,0,0,1,248,47,128,0,0,7,208,7,224,0,0,1,0,0,64,0,0,0,0,0,0,0,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,
  // 0x1ed7  ỗ
  215,30,18,33,165,22,2,255,0,46,64,56,0,0,255,244,184,0,1,250,255,240,0,2,192,47,208,0,0,0,0,0,0,0,3,252,0,0,0,15,255,0,0,0,47,191,128,0,0,190,11,224,0,2,244,1,244,0,0,0,0,0,0,0,0,0,0,0,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,
  // 0x1ed8  Ộ
  216,30,24,41,246,28,2,249,0,0,10,164,0,0,0,0,47,252,0,0,0,0,127,254,0,0,0,1,254,127,128,0,0,3,244,15,224,0,0,15,208,2,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,0,0,0,0,0,0,0,0,2,144,0,0,0,0,15,240,0,0,0,0,15,244,0,0,0,0,15,240,0,0,0,0,2,144,0,0,
  // 0x1ed9  ộ
  217,30,18,35,175,22,2,249,0,2,168,0,0,0,15,255,0,0,0,47,255,128,0,0,127,95,208,0,1,253,7,244,0,7,240,0,253,0,0,0,0,0,0,0,0,0,0,0,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,0,0,0,0,0,0,1,160,0,0,0,3,252,0,0,0,7,252,0,0,0,3,252,0,0,0,1,160,0,0,
  // 0x1eda  Ớ
  218,30,28,35,245,29,2,255,0,0,0,42,144,0,0,0,0,0,127,192,0,0,0,0,0,255,64,0,0,0,0,2,253,0,0,0,0,0,7,240,0,0,0,0,0,15,192,0,0,0,0,0,0,0,0,1,84,0,0,0,0,0,3,253,0,1,191,254,64,3,252,0,31,255,255,248,3,252,0,255,255,255,255,11,244,3,255,229,91,255,239,240,11,254,0,0,127,255,192,15,248,0,0,15,253,0,47,240,0,0,11,252,0,63,208,0,0,3,253,0,127,192,0,0,2,254,0,191,128,0,0,1,255,0,191,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,191,64,0,0,0,255,0,191,128,0,0,1,255,0,127,192,0,0,2,254,0,63,192,0,0,3,253,0,63,224,0,0,7,252,0,31,244,0,0,15,248,0,15,253,0,0,63,240,0,3,255,144,2,255,208,0,0,255,255,255,255,64,0,0,47,255,255,252,0,0,0,6,255,255,144,0,0,0,0,5,80,0,0,0,
  // 0x1edb  ớ
  219,30,22,29,174,23,2,255,0,0,10,164,0,0,0,0,47,240,0,0,0,0,63,192,0,0,0,0,255,0,0,0,0,2,252,0,0,0,0,7,240,0,5,80,0,0,0,0,15,240,0,0,0,0,31,224,0,6,169,0,31,208,0,191,255,224,63,192,7,255,255,253,255,64,15,254,91,255,253,0,63,224,0,191,224,0,127,192,0,63,192,0,191,64,0,31,208,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,224,0,127,128,0,47,208,0,63,192,0,63,192,0,31,244,1,255,128,0,11,255,255,255,0,0,2,255,255,248,0,0,0,111,255,144,0,0,0,1,80,0,0,0,
  // 0x1edc  Ờ
  220,30,28,35,245,29,2,255,0,2,168,0,0,0,0,0,2,255,0,0,0,0,0,0,191,64,0,0,0,0,0,47,192,0,0,0,0,0,11,240,0,0,0,0,0,2,248,0,0,0,0,0,0,0,0,1,84,0,0,0,0,0,3,253,0,1,191,254,64,3,252,0,31,255,255,248,3,252,0,255,255,255,255,11,244,3,255,229,91,255,239,240,11,254,0,0,127,255,192,15,248,0,0,15,253,0,47,240,0,0,11,252,0,63,208,0,0,3,253,0,127,192,0,0,2,254,0,191,128,0,0,1,255,0,191,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,191,64,0,0,0,255,0,191,128,0,0,1,255,0,127,192,0,0,2,254,0,63,192,0,0,3,253,0,63,224,0,0,7,252,0,31,244,0,0,15,248,0,15,253,0,0,63,240,0,3,255,144,2,255,208,0,0,255,255,255,255,64,0,0,47,255,255,252,0,0,0,6,255,255,144,0,0,0,0,5,80,0,0,0,
  // 0x1edd  ờ
  221,30,22,29,174,23,2,255,0,170,0,0,0,0,0,255,128,0,0,0,0,63,208,0,0,0,0,15,240,0,0,0,0,3,248,0,0,0,0,0,189,0,5,80,0,0,0,0,15,240,0,0,0,0,31,224,0,6,169,0,31,208,0,191,255,224,63,192,7,255,255,253,255,64,15,254,91,255,253,0,63,224,0,191,224,0,127,192,0,63,192,0,191,64,0,31,208,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,224,0,127,128,0,47,208,0,63,192,0,63,192,0,31,244,1,255,128,0,11,255,255,255,0,0,2,255,255,248,0,0,0,111,255,144,0,0,0,1,80,0,0,0,
  // 0x1ede  Ở
  222,30,28,37,3,29,2,255,0,0,26,144,0,0,0,0,0,63,252,0,0,0,0,0,42,255,0,0,0,0,0,0,63,0,0,0,0,0,0,63,0,0,0,0,0,2,253,0,0,0,0,0,11,244,0,0,0,0,0,7,192,0,0,0,0,0,6,128,0,1,84,0,0,0,0,0,3,253,0,1,191,254,64,3,252,0,31,255,255,248,3,252,0,255,255,255,255,11,244,3,255,229,91,255,239,240,11,254,0,0,127,255,192,15,248,0,0,15,253,0,47,240,0,0,11,252,0,63,208,0,0,3,253,0,127,192,0,0,2,254,0,191,128,0,0,1,255,0,191,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,191,64,0,0,0,255,0,191,128,0,0,1,255,0,127,192,0,0,2,254,0,63,192,0,0,3,253,0,63,224,0,0,7,252,0,31,244,0,0,15,248,0,15,253,0,0,63,240,0,3,255,144,2,255,208,0,0,255,255,255,255,64,0,0,47,255,255,252,0,0,0,6,255,255,144,0,0,0,0,5,80,0,0,0,
  // 0x1edf  ở
  223,30,22,31,186,23,2,255,0,10,164,0,0,0,0,15,255,0,0,0,0,10,191,128,0,0,0,0,31,192,0,0,0,0,31,128,0,0,0,1,191,64,0,0,0,2,253,0,0,0,0,2,240,0,5,80,0,1,160,0,15,240,0,0,0,0,31,224,0,6,169,0,31,208,0,191,255,224,63,192,7,255,255,253,255,64,15,254,91,255,253,0,63,224,0,191,224,0,127,192,0,63,192,0,191,64,0,31,208,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,224,0,127,128,0,47,208,0,63,192,0,63,192,0,31,244,1,255,128,0,11,255,255,255,0,0,2,255,255,248,0,0,0,111,255,144,0,0,0,1,80,0,0,0,
  // 0x1ee0  Ỡ
  224,30,28,34,238,29,2,255,0,0,100,0,40,0,0,0,3,255,128,184,0,0,0,15,255,251,244,0,0,0,31,71,255,240,0,0,0,46,0,127,128,0,0,0,0,0,0,0,1,84,0,0,0,0,0,3,253,0,1,191,254,64,3,252,0,31,255,255,248,3,252,0,255,255,255,255,11,244,3,255,229,91,255,239,240,11,254,0,0,127,255,192,15,248,0,0,15,253,0,47,240,0,0,11,252,0,63,208,0,0,3,253,0,127,192,0,0,2,254,0,191,128,0,0,1,255,0,191,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,191,64,0,0,0,255,0,191,128,0,0,1,255,0,127,192,0,0,2,254,0,63,192,0,0,3,253,0,63,224,0,0,7,252,0,31,244,0,0,15,248,0,15,253,0,0,63,240,0,3,255,144,2,255,208,0,0,255,255,255,255,64,0,0,47,255,255,252,0,0,0,6,255,255,144,0,0,0,0,5,80,0,0,0,
  // 0x1ee1  ỡ
  225,30,22,28,168,23,2,255,0,41,0,25,0,0,1,255,208,62,0,0,3,255,254,252,0,0,11,210,255,248,0,0,15,64,47,224,5,80,0,0,0,0,15,240,0,0,0,0,31,224,0,6,169,0,31,208,0,191,255,224,63,192,7,255,255,253,255,64,15,254,91,255,253,0,63,224,0,191,224,0,127,192,0,63,192,0,191,64,0,31,208,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,224,0,127,128,0,47,208,0,63,192,0,63,192,0,31,244,1,255,128,0,11,255,255,255,0,0,2,255,255,248,0,0,0,111,255,144,0,0,0,1,80,0,0,0,
  // 0x1ee2  Ợ
  226,30,28,35,245,29,2,249,0,0,0,0,0,1,84,0,0,0,0,0,3,253,0,1,191,254,64,3,252,0,31,255,255,248,3,252,0,255,255,255,255,11,244,3,255,229,91,255,239,240,11,254,0,0,127,255,192,15,248,0,0,15,253,0,47,240,0,0,11,252,0,63,208,0,0,3,253,0,127,192,0,0,2,254,0,191,128,0,0,1,255,0,191,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,255,64,0,0,0,255,0,191,64,0,0,0,255,0,191,128,0,0,1,255,0,127,192,0,0,2,254,0,63,192,0,0,3,253,0,63,224,0,0,7,252,0,31,244,0,0,15,248,0,15,253,0,0,63,240,0,3,255,144,2,255,208,0,0,255,255,255,255,64,0,0,47,255,255,252,0,0,0,6,255,255,144,0,0,0,0,5,80,0,0,0,0,0,0,0,0,0,0,0,0,2,128,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,2,128,0,0,0,
  // 0x1ee3  ợ
  227,30,22,30,180,23,2,249,0,0,0,0,5,80,0,0,0,0,15,240,0,0,0,0,31,224,0,6,169,0,31,208,0,191,255,224,63,192,7,255,255,253,255,64,15,254,91,255,253,0,63,224,0,191,224,0,127,192,0,63,192,0,191,64,0,31,208,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,224,0,127,128,0,47,208,0,63,192,0,63,192,0,31,244,1,255,128,0,11,255,255,255,0,0,2,255,255,248,0,0,0,111,255,144,0,0,0,1,80,0,0,0,0,0,0,0,0,0,0,0,160,0,0,0,0,3,252,0,0,0,0,3,252,0,0,0,0,3,252,0,0,0,0,0,160,0,0,0,
  // 0x1ee4  Ụ
  228,30,21,33,198,27,3,249,170,0,0,0,106,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,191,64,191,64,0,0,191,0,127,128,0,0,255,0,63,192,0,1,255,0,63,224,0,3,253,0,15,253,0,47,248,0,7,255,255,255,240,0,1,255,255,255,128,0,0,47,255,249,0,0,0,0,21,0,0,0,0,0,0,0,0,0,0,0,41,0,0,0,0,0,255,0,0,0,0,0,255,64,0,0,0,0,255,0,0,0,0,0,41,0,0,0,
  // 0x1ee5  ụ
  229,30,17,27,135,23,3,249,85,0,0,21,64,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,127,128,254,0,0,127,128,255,0,0,255,128,255,64,1,255,128,191,192,7,255,128,127,255,255,255,128,47,255,255,47,128,7,255,248,31,128,0,21,0,0,0,0,0,0,0,0,0,6,128,0,0,0,15,224,0,0,0,31,240,0,0,0,15,224,0,0,0,6,128,0,0,
  // 0x1ee6  Ủ
  230,30,21,37,222,27,3,255,0,0,169,0,0,0,0,2,255,208,0,0,0,2,175,240,0,0,0,0,3,244,0,0,0,0,3,240,0,0,0,0,27,240,0,0,0,0,63,128,0,0,0,0,61,0,0,0,0,0,60,0,0,0,0,0,0,0,0,0,170,0,0,0,106,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,191,64,191,64,0,0,191,0,127,128,0,0,255,0,63,192,0,1,255,0,63,224,0,3,253,0,15,253,0,47,248,0,7,255,255,255,240,0,1,255,255,255,128,0,0,47,255,249,0,0,0,0,21,0,0,0,
  // 0x1ee7  ủ
  231,30,17,31,155,23,3,255,0,26,144,0,0,0,47,253,0,0,0,42,255,0,0,0,0,63,0,0,0,0,63,0,0,0,1,254,0,0,0,7,248,0,0,0,3,208,0,0,0,2,128,0,0,0,0,0,0,0,85,0,0,21,64,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,127,128,254,0,0,127,128,255,0,0,255,128,255,64,1,255,128,191,192,7,255,128,127,255,255,255,128,47,255,255,47,128,7,255,248,31,128,0,21,0,0,0,
  // 0x1ee8  Ứ
  232,30,27,35,245,29,3,255,0,0,1,170,0,0,0,0,0,3,253,0,0,0,0,0,15,244,0,0,0,0,0,47,208,0,0,0,0,0,63,64,0,0,0,0,0,253,0,0,0,0,0,0,0,0,0,1,84,0,0,0,0,0,3,252,170,0,0,0,106,67,252,255,0,0,0,127,71,248,255,0,0,0,127,75,240,255,0,0,0,127,175,208,255,0,0,0,127,255,128,255,0,0,0,127,249,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,191,64,0,191,64,0,0,191,0,0,127,128,0,0,255,0,0,63,192,0,1,255,0,0,63,224,0,3,253,0,0,15,253,0,47,252,0,0,7,255,255,255,240,0,0,1,255,255,255,192,0,0,0,31,255,253,0,0,0,0,0,21,0,0,0,0,
  // 0x1ee9  ứ
  233,30,24,29,174,25,3,255,0,0,26,160,0,0,0,0,63,208,0,0,0,0,255,64,0,0,0,1,253,0,0,0,0,3,244,0,0,0,0,15,208,0,1,84,0,0,0,0,2,253,0,0,0,0,3,252,84,0,0,21,67,252,254,0,0,63,135,244,254,0,0,63,239,240,254,0,0,63,255,192,254,0,0,63,253,0,254,0,0,63,192,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,127,128,0,254,0,0,127,128,0,255,0,0,255,128,0,255,64,1,255,128,0,191,192,7,255,128,0,63,255,255,255,128,0,31,255,255,47,128,0,7,255,248,31,128,0,0,21,0,0,0,0,
  // 0x1eea  Ừ
  234,30,27,35,245,29,3,255,0,42,144,0,0,0,0,0,31,240,0,0,0,0,0,11,248,0,0,0,0,0,2,253,0,0,0,0,0,0,127,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,0,1,84,0,0,0,0,0,3,252,170,0,0,0,106,67,252,255,0,0,0,127,71,248,255,0,0,0,127,75,240,255,0,0,0,127,175,208,255,0,0,0,127,255,128,255,0,0,0,127,249,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,191,64,0,191,64,0,0,191,0,0,127,128,0,0,255,0,0,63,192,0,1,255,0,0,63,224,0,3,253,0,0,15,253,0,47,252,0,0,7,255,255,255,240,0,0,1,255,255,255,192,0,0,0,31,255,253,0,0,0,0,0,21,0,0,0,0,
  // 0x1eeb  ừ
  235,30,24,29,174,25,3,255,2,169,0,0,0,0,1,255,0,0,0,0,0,191,128,0,0,0,0,47,208,0,0,0,0,7,240,0,0,0,0,1,252,0,1,84,0,0,0,0,2,253,0,0,0,0,3,252,84,0,0,21,67,252,254,0,0,63,135,244,254,0,0,63,239,240,254,0,0,63,255,192,254,0,0,63,253,0,254,0,0,63,192,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,127,128,0,254,0,0,127,128,0,255,0,0,255,128,0,255,64,1,255,128,0,191,192,7,255,128,0,63,255,255,255,128,0,31,255,255,47,128,0,7,255,248,31,128,0,0,21,0,0,0,0,
  // 0x1eec  Ử
  236,30,27,37,3,29,3,255,0,0,169,0,0,0,0,0,1,255,224,0,0,0,0,1,175,240,0,0,0,0,0,2,244,0,0,0,0,0,2,244,0,0,0,0,0,27,240,0,0,0,0,0,63,128,0,0,0,0,0,62,0,0,0,0,0,0,45,0,0,1,84,0,0,0,0,0,3,252,170,0,0,0,106,67,252,255,0,0,0,127,71,248,255,0,0,0,127,75,240,255,0,0,0,127,175,208,255,0,0,0,127,255,128,255,0,0,0,127,249,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,191,64,0,191,64,0,0,191,0,0,127,128,0,0,255,0,0,63,192,0,1,255,0,0,63,224,0,3,253,0,0,15,253,0,47,252,0,0,7,255,255,255,240,0,0,1,255,255,255,192,0,0,0,31,255,253,0,0,0,0,0,21,0,0,0,0,
  // 0x1eed  ử
  237,30,24,31,186,25,3,255,0,26,144,0,0,0,0,47,253,0,0,0,0,26,255,0,0,0,0,0,47,64,0,0,0,0,63,0,0,0,0,1,255,0,0,0,0,3,248,0,0,0,0,3,208,0,1,84,0,2,128,0,2,253,0,0,0,0,3,252,84,0,0,21,67,252,254,0,0,63,135,244,254,0,0,63,239,240,254,0,0,63,255,192,254,0,0,63,253,0,254,0,0,63,192,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,127,128,0,254,0,0,127,128,0,255,0,0,255,128,0,255,64,1,255,128,0,191,192,7,255,128,0,63,255,255,255,128,0,31,255,255,47,128,0,7,255,248,31,128,0,0,21,0,0,0,0,
  // 0x1eee  Ữ
  238,30,27,34,238,29,3,255,0,6,128,2,128,0,0,0,63,248,7,192,0,0,0,255,255,239,128,0,0,0,248,127,255,0,0,0,1,240,7,252,0,0,0,0,0,0,0,0,1,84,0,0,0,0,0,3,252,170,0,0,0,106,67,252,255,0,0,0,127,71,248,255,0,0,0,127,75,240,255,0,0,0,127,175,208,255,0,0,0,127,255,128,255,0,0,0,127,249,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,191,64,0,191,64,0,0,191,0,0,127,128,0,0,255,0,0,63,192,0,1,255,0,0,63,224,0,3,253,0,0,15,253,0,47,252,0,0,7,255,255,255,240,0,0,1,255,255,255,192,0,0,0,31,255,253,0,0,0,0,0,21,0,0,0,0,
  // 0x1eef  ữ
  239,30,24,28,168,25,3,255,0,104,0,40,0,0,3,255,128,124,0,0,11,255,254,248,0,0,15,135,255,240,0,0,31,0,127,192,1,84,0,0,0,0,2,253,0,0,0,0,3,252,84,0,0,21,67,252,254,0,0,63,135,244,254,0,0,63,239,240,254,0,0,63,255,192,254,0,0,63,253,0,254,0,0,63,192,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,127,128,0,254,0,0,127,128,0,255,0,0,255,128,0,255,64,1,255,128,0,191,192,7,255,128,0,63,255,255,255,128,0,31,255,255,47,128,0,7,255,248,31,128,0,0,21,0,0,0,0,
  // 0x1ef0  Ự
  240,30,27,35,245,29,3,249,0,0,0,0,0,1,84,0,0,0,0,0,3,252,170,0,0,0,106,67,252,255,0,0,0,127,71,248,255,0,0,0,127,75,240,255,0,0,0,127,175,208,255,0,0,0,127,255,128,255,0,0,0,127,249,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,127,64,0,255,0,0,0,191,64,0,191,64,0,0,191,0,0,127,128,0,0,255,0,0,63,192,0,1,255,0,0,63,224,0,3,253,0,0,15,253,0,47,252,0,0,7,255,255,255,240,0,0,1,255,255,255,192,0,0,0,31,255,253,0,0,0,0,0,21,0,0,0,0,0,0,0,0,0,0,0,0,0,41,0,0,0,0,0,0,191,64,0,0,0,0,0,255,64,0,0,0,0,0,191,64,0,0,0,0,0,41,0,0,0,0,
  // 0x1ef1  ự
  241,30,24,30,180,25,3,249,0,0,0,0,1,84,0,0,0,0,2,253,0,0,0,0,3,252,84,0,0,21,67,252,254,0,0,63,135,244,254,0,0,63,239,240,254,0,0,63,255,192,254,0,0,63,253,0,254,0,0,63,192,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,63,128,0,254,0,0,127,128,0,254,0,0,127,128,0,255,0,0,255,128,0,255,64,1,255,128,0,191,192,7,255,128,0,63,255,255,255,128,0,31,255,255,47,128,0,7,255,248,31,128,0,0,21,0,0,0,0,0,0,0,0,0,0,0,6,128,0,0,0,0,15,224,0,0,0,0,31,240,0,0,0,0,15,224,0,0,0,0,6,128,0,0,0,
  // 0x1ef2  Ỳ
  242,30,21,34,204,21,0,0,0,26,160,0,0,0,0,15,244,0,0,0,0,3,252,0,0,0,0,0,254,0,0,0,0,0,63,64,0,0,0,0,15,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,64,0,0,106,128,127,192,0,0,255,64,63,208,0,1,255,0,31,240,0,3,252,0,11,244,0,7,248,0,3,252,0,15,240,0,2,253,0,31,224,0,0,255,0,63,192,0,0,191,128,127,128,0,0,63,192,255,0,0,0,47,226,253,0,0,0,15,243,252,0,0,0,7,255,244,0,0,0,3,255,240,0,0,0,1,255,208,0,0,0,0,255,128,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,
  // 0x1ef3  ỳ
  243,30,19,37,185,19,0,247,0,106,128,0,0,0,63,208,0,0,0,15,240,0,0,0,3,248,0,0,0,0,253,0,0,0,0,63,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,1,84,191,64,0,7,248,63,192,0,15,240,63,192,0,15,240,31,224,0,31,208,15,240,0,63,192,11,244,0,63,128,3,248,0,191,64,3,252,0,255,0,1,253,0,254,0,0,255,2,252,0,0,191,3,252,0,0,63,71,244,0,0,63,203,240,0,0,31,207,224,0,0,15,223,208,0,0,11,255,192,0,0,3,255,128,0,0,3,255,0,0,0,1,255,0,0,0,1,253,0,0,0,3,252,0,0,0,3,248,0,0,0,11,244,0,0,0,47,240,0,0,38,255,192,0,0,127,255,64,0,0,127,253,0,0,0,42,144,0,0,0,
  // 0x1ef4  Ỵ
  244,30,21,33,198,21,0,249,170,64,0,0,106,128,127,192,0,0,255,64,63,208,0,1,255,0,31,240,0,3,252,0,11,244,0,7,248,0,3,252,0,15,240,0,2,253,0,31,224,0,0,255,0,63,192,0,0,191,128,127,128,0,0,63,192,255,0,0,0,47,226,253,0,0,0,15,243,252,0,0,0,7,255,244,0,0,0,3,255,240,0,0,0,1,255,208,0,0,0,0,255,128,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,0,0,191,64,0,0,0,0,191,128,0,0,0,0,191,64,0,0,0,0,25,0,0,0,
  // 0x1ef5  ỵ
  245,30,19,29,145,19,0,247,85,0,0,1,84,191,64,0,7,248,63,192,0,15,240,63,192,0,15,240,31,224,0,31,208,15,240,0,63,192,11,244,0,63,128,3,248,0,191,64,3,252,0,255,0,1,253,0,254,0,0,255,2,252,0,0,191,3,252,0,0,63,71,244,0,0,63,203,240,0,0,31,207,224,0,0,15,223,208,0,0,11,255,192,0,0,3,255,128,0,0,3,255,0,0,0,1,255,0,0,0,1,253,0,0,0,3,252,0,0,0,3,248,25,0,0,11,244,127,128,0,47,240,191,128,38,255,192,127,128,127,255,64,25,0,127,253,0,0,0,42,144,0,0,0,
  // 0x1ef6  Ỷ
  246,30,21,36,216,21,0,0,0,0,105,0,0,0,0,1,255,224,0,0,0,1,175,244,0,0,0,0,2,248,0,0,0,0,2,244,0,0,0,0,27,240,0,0,0,0,63,192,0,0,0,0,62,0,0,0,0,0,45,0,0,0,0,0,0,0,0,0,170,64,0,0,106,128,127,192,0,0,255,64,63,208,0,1,255,0,31,240,0,3,252,0,11,244,0,7,248,0,3,252,0,15,240,0,2,253,0,31,224,0,0,255,0,63,192,0,0,191,128,127,128,0,0,63,192,255,0,0,0,47,226,253,0,0,0,15,243,252,0,0,0,7,255,244,0,0,0,3,255,240,0,0,0,1,255,208,0,0,0,0,255,128,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,
  // 0x1ef7  ỷ
  247,30,19,39,195,19,0,247,0,2,164,0,0,0,7,255,128,0,0,6,191,208,0,0,0,11,208,0,0,0,11,208,0,0,0,111,192,0,0,0,254,0,0,0,0,248,0,0,0,0,164,0,0,0,0,0,0,0,85,0,0,1,84,191,64,0,7,248,63,192,0,15,240,63,192,0,15,240,31,224,0,31,208,15,240,0,63,192,11,244,0,63,128,3,248,0,191,64,3,252,0,255,0,1,253,0,254,0,0,255,2,252,0,0,191,3,252,0,0,63,71,244,0,0,63,203,240,0,0,31,207,224,0,0,15,223,208,0,0,11,255,192,0,0,3,255,128,0,0,3,255,0,0,0,1,255,0,0,0,1,253,0,0,0,3,252,0,0,0,3,248,0,0,0,11,244,0,0,0,47,240,0,0,38,255,192,0,0,127,255,64,0,0,127,253,0,0,0,42,144,0,0,0,
  // 0x1ef8  Ỹ
  248,30,21,33,198,21,0,0,0,6,144,2,128,0,0,63,252,7,192,0,0,191,255,239,192,0,0,248,127,255,0,0,0,240,7,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,64,0,0,106,128,127,192,0,0,255,64,63,208,0,1,255,0,31,240,0,3,252,0,11,244,0,7,248,0,3,252,0,15,240,0,2,253,0,31,224,0,0,255,0,63,192,0,0,191,128,127,128,0,0,63,192,255,0,0,0,47,226,253,0,0,0,15,243,252,0,0,0,7,255,244,0,0,0,3,255,240,0,0,0,1,255,208,0,0,0,0,255,128,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,
  // 0x1ef9  ỹ
  249,30,19,36,180,19,0,247,0,26,64,10,0,0,255,240,31,0,2,255,255,190,0,3,225,255,252,0,3,192,31,244,0,0,0,0,0,0,0,0,0,0,0,85,0,0,1,84,191,64,0,7,248,63,192,0,15,240,63,192,0,15,240,31,224,0,31,208,15,240,0,63,192,11,244,0,63,128,3,248,0,191,64,3,252,0,255,0,1,253,0,254,0,0,255,2,252,0,0,191,3,252,0,0,63,71,244,0,0,63,203,240,0,0,31,207,224,0,0,15,223,208,0,0,11,255,192,0,0,3,255,128,0,0,3,255,0,0,0,1,255,0,0,0,1,253,0,0,0,3,252,0,0,0,3,248,0,0,0,11,244,0,0,0,47,240,0,0,38,255,192,0,0,127,255,64,0,0,127,253,0,0,0,42,144,0,0,0,
};

#endif // HAS_GRAPHICAL_TFT
