/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Korean 36pt, capital 'A' height: 26px, width: 100%, range: 0xac70-0xd788, glyphs: 110
extern const uint8_t NotoSans_Medium_Korean_26[17586] = {
  162,26,112,172,136,215,34,247, // unifont_t
  // 0xac70  거
  112,172,27,34,238,33,2,253,0,0,0,0,0,1,84,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,63,255,255,255,0,3,248,63,255,255,255,0,3,248,63,255,255,255,0,3,248,0,0,0,191,0,3,248,0,0,0,255,0,3,248,0,0,0,254,0,3,248,0,0,0,254,0,3,248,0,0,1,253,0,3,248,0,0,2,252,0,3,248,0,0,3,252,0,3,248,0,0,7,244,255,255,248,0,0,15,240,255,255,248,0,0,47,224,255,255,248,0,0,63,192,0,3,248,0,0,255,64,0,3,248,0,2,255,0,0,3,248,0,11,252,0,0,3,248,0,63,240,0,0,3,248,1,255,208,0,0,3,248,11,255,64,0,0,3,248,127,252,0,0,0,3,248,255,224,0,0,0,3,248,127,64,0,0,0,3,248,36,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,
  // 0xace0  고
  224,172,29,26,208,33,2,1,3,255,255,255,255,255,240,0,3,255,255,255,255,255,240,0,3,255,255,255,255,255,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,1,80,0,15,240,0,0,0,3,248,0,15,224,0,0,0,3,248,0,15,224,0,0,0,3,248,0,15,224,0,0,0,3,248,0,31,208,0,0,0,3,248,0,47,192,0,0,0,3,248,0,47,192,0,0,0,3,248,0,63,192,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,
  // 0xadf8  그
  248,173,29,26,208,33,2,1,3,255,255,255,255,255,208,0,3,255,255,255,255,255,208,0,3,255,255,255,255,255,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,127,64,0,0,0,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,
  // 0xae09  급
  9,174,30,31,248,33,2,254,1,255,255,255,255,255,224,0,1,255,255,255,255,255,224,0,1,255,255,255,255,255,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,63,192,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,252,0,0,0,15,224,0,1,252,0,0,0,15,224,0,1,252,0,0,0,15,224,0,1,252,0,0,0,15,224,0,1,255,255,255,255,255,224,0,1,255,255,255,255,255,224,0,1,255,255,255,255,255,224,0,1,252,0,0,0,15,224,0,1,252,0,0,0,15,224,0,1,252,0,0,0,15,224,0,1,255,255,255,255,255,224,0,1,255,255,255,255,255,224,0,1,255,255,255,255,255,224,0,
  // 0xae30  기
  48,174,27,34,238,33,2,253,0,0,0,0,0,1,84,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,31,255,255,255,192,3,248,31,255,255,255,192,3,248,31,255,255,255,192,3,248,0,0,0,63,192,3,248,0,0,0,63,128,3,248,0,0,0,63,128,3,248,0,0,0,127,64,3,248,0,0,0,191,0,3,248,0,0,0,255,0,3,248,0,0,1,254,0,3,248,0,0,3,252,0,3,248,0,0,7,248,0,3,248,0,0,15,244,0,3,248,0,0,47,240,0,3,248,0,0,127,192,0,3,248,0,1,255,64,0,3,248,0,7,254,0,0,3,248,0,47,248,0,0,3,248,0,255,240,0,0,3,248,7,255,128,0,0,3,248,127,253,0,0,0,3,248,191,244,0,0,0,3,248,63,128,0,0,0,3,248,24,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,
  // 0xae45  깅
  69,174,27,34,238,33,2,253,0,0,0,0,0,1,80,0,0,0,0,0,3,248,0,0,0,0,0,3,248,15,255,255,255,192,3,248,15,255,255,255,128,3,248,15,255,255,255,128,3,248,0,0,0,63,64,3,248,0,0,0,127,0,3,248,0,0,0,255,0,3,248,0,0,0,254,0,3,248,0,0,3,252,0,3,248,0,0,11,248,0,3,248,0,0,31,240,0,3,248,0,0,127,192,0,3,248,0,2,255,64,0,3,248,0,31,253,0,0,3,248,1,255,244,0,0,3,248,111,255,128,0,0,3,248,191,253,0,0,0,3,248,63,208,0,0,0,3,248,40,0,0,0,0,2,164,0,0,6,255,254,64,0,0,0,191,255,255,253,0,0,7,255,255,255,255,128,0,31,254,0,1,191,224,0,63,224,0,0,15,244,0,63,128,0,0,7,248,0,63,64,0,0,3,248,0,63,128,0,0,7,248,0,63,224,0,0,15,244,0,31,254,64,1,191,224,0,7,255,255,255,255,128,0,0,191,255,255,253,0,0,0,6,191,254,64,0,
  // 0xb044  끄
  68,176,29,25,200,33,2,2,15,255,255,195,255,255,240,0,15,255,255,195,255,255,240,0,15,255,255,195,255,255,240,0,0,0,63,192,0,11,240,0,0,0,63,128,0,11,240,0,0,0,63,128,0,11,240,0,0,0,63,128,0,11,240,0,0,0,63,128,0,11,240,0,0,0,63,64,0,15,240,0,0,0,127,64,0,15,240,0,0,0,191,0,0,15,224,0,0,0,191,0,0,15,224,0,0,0,255,0,0,15,224,0,0,0,254,0,0,31,208,0,0,1,253,0,0,31,208,0,0,2,253,0,0,47,192,0,0,3,252,0,0,63,192,0,0,3,252,0,0,63,192,0,0,0,100,0,0,22,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,
  // 0xb0b4  내
  180,176,27,34,238,33,3,253,0,0,0,0,0,1,80,0,0,0,1,252,3,244,0,0,0,1,252,3,244,0,0,0,1,252,3,244,106,0,0,1,252,3,244,191,0,0,1,252,3,244,191,0,0,1,252,3,244,191,0,0,1,252,3,244,191,0,0,1,252,3,244,191,0,0,1,252,3,244,191,0,0,1,252,3,244,191,0,0,1,252,3,244,191,0,0,1,252,3,244,191,0,0,1,252,3,244,191,0,0,1,255,255,244,191,0,0,1,255,255,244,191,0,0,1,255,255,244,191,0,0,1,252,3,244,191,0,0,1,252,3,244,191,0,0,1,252,3,244,191,0,0,1,252,3,244,191,0,90,225,252,3,244,191,255,255,225,252,3,244,191,255,255,241,252,3,244,191,255,250,65,252,3,244,0,0,0,1,252,3,244,0,0,0,1,252,3,244,0,0,0,1,252,3,244,0,0,0,1,252,3,244,0,0,0,1,252,3,244,0,0,0,1,252,3,244,0,0,0,1,252,3,244,0,0,0,0,0,3,244,0,0,0,0,0,3,244,
  // 0xb178  노
  120,177,30,27,216,33,2,1,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,
  // 0xb204  누
  4,178,30,32,0,33,2,253,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,255,255,255,255,255,240,0,1,255,255,255,255,255,240,0,1,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,
  // 0xb274  뉴
  116,178,29,32,0,33,2,253,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,3,248,0,11,240,0,0,0,3,248,0,11,240,0,0,0,3,248,0,11,240,0,0,0,3,248,0,11,240,0,0,0,3,248,0,11,240,0,0,0,3,248,0,11,240,0,0,0,3,248,0,11,240,0,0,0,3,248,0,11,240,0,0,0,3,248,0,11,240,0,0,0,3,248,0,11,240,0,0,0,3,248,0,11,240,0,0,0,3,248,0,11,240,0,0,
  // 0xb2c8  니
  200,178,26,34,238,33,3,253,0,0,0,0,0,10,144,0,0,0,0,0,15,224,0,0,0,0,0,15,224,21,0,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,20,15,224,127,64,21,175,252,15,224,127,255,255,255,252,15,224,127,255,255,255,252,15,224,127,255,255,165,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,
  // 0xb2e4  다
  228,178,29,34,16,33,3,253,0,0,0,0,0,85,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,255,255,255,252,0,191,0,0,255,255,255,252,0,191,0,0,255,255,255,252,0,191,0,0,255,0,0,0,0,191,0,0,255,0,0,0,0,191,0,0,255,0,0,0,0,191,0,0,255,0,0,0,0,191,0,0,255,0,0,0,0,191,0,0,255,0,0,0,0,191,0,0,255,0,0,0,0,191,255,192,255,0,0,0,0,191,255,192,255,0,0,0,0,191,255,192,255,0,0,0,0,191,0,0,255,0,0,0,0,191,0,0,255,0,0,0,0,191,0,0,255,0,0,0,0,191,0,0,255,0,0,0,0,191,0,0,255,0,0,0,0,191,0,0,255,0,21,175,224,191,0,0,255,255,255,255,240,191,0,0,255,255,255,255,240,191,0,0,255,255,254,148,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,
  // 0xb2f9  당
  249,178,29,34,16,33,3,253,0,0,0,0,0,21,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,255,255,255,248,0,127,64,0,255,255,255,248,0,127,64,0,255,255,255,248,0,127,64,0,255,0,0,0,0,127,64,0,255,0,0,0,0,127,64,0,255,0,0,0,0,127,64,0,255,0,0,0,0,127,255,192,255,0,0,0,0,127,255,192,255,0,0,0,0,127,255,192,255,0,0,0,0,127,64,0,255,0,0,0,0,127,64,0,255,0,1,107,224,127,64,0,255,255,255,255,224,127,64,0,255,255,255,255,240,127,64,0,255,255,255,165,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,21,0,0,0,0,107,255,228,0,0,0,0,11,255,255,255,208,0,0,0,127,255,255,255,248,0,0,0,255,228,0,27,254,0,0,2,254,0,0,1,255,0,0,3,252,0,0,0,127,64,0,3,248,0,0,0,63,128,0,3,252,0,0,0,127,64,0,2,254,0,0,1,255,0,0,0,255,228,0,31,254,0,0,0,127,255,255,255,248,0,0,0,11,255,255,255,208,0,0,0,0,111,255,228,0,0,0,
  // 0xb3c4  도
  196,179,30,27,216,33,2,1,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,
  // 0xb3cc  돌
  204,179,29,32,0,33,2,253,1,255,255,255,255,255,208,0,1,255,255,255,255,255,208,0,1,255,255,255,255,255,208,0,1,253,0,0,0,0,0,0,1,253,0,0,0,0,0,0,1,253,0,0,0,0,0,0,1,253,0,0,0,0,0,0,1,255,255,255,255,255,240,0,1,255,255,255,255,255,240,0,1,255,255,255,255,255,224,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,1,170,170,170,170,175,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,255,255,255,255,255,244,0,2,255,255,255,255,255,244,0,2,255,255,255,255,255,244,0,
  // 0xb3d9  동
  217,179,29,32,0,33,2,253,1,255,255,255,255,255,224,0,1,255,255,255,255,255,224,0,1,255,255,255,255,255,224,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,255,255,255,255,255,240,0,1,255,255,255,255,255,240,0,1,255,255,255,255,255,240,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,255,250,0,0,0,0,11,255,255,255,244,0,0,0,63,255,255,255,255,0,0,0,255,224,0,6,255,192,0,1,254,0,0,0,63,208,0,2,252,0,0,0,31,224,0,2,252,0,0,0,31,224,0,1,255,0,0,0,63,208,0,0,255,228,0,6,255,192,0,0,63,255,255,255,255,0,0,0,7,255,255,255,244,0,0,0,0,26,255,233,0,0,0,
  // 0xb418  되
  24,180,27,34,238,33,2,253,0,0,0,0,0,1,80,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,15,255,255,255,252,3,248,15,255,255,255,252,3,248,15,255,255,255,252,3,248,15,240,0,0,0,3,248,15,240,0,0,0,3,248,15,240,0,0,0,3,248,15,240,0,0,0,3,248,15,240,0,0,0,3,248,15,240,0,0,0,3,248,15,240,0,0,0,3,248,15,240,0,0,0,3,248,15,255,255,255,252,3,248,15,255,255,255,252,3,248,15,255,255,255,252,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,150,171,195,248,255,255,255,255,255,195,248,255,255,255,255,255,195,248,191,255,255,170,80,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,
  // 0xb41c  된
  28,180,28,34,238,33,2,253,0,0,0,0,0,1,80,0,0,0,0,0,3,248,0,0,0,0,0,3,248,3,255,255,255,244,3,248,3,255,255,255,244,3,248,3,255,255,255,244,3,248,3,244,0,0,0,3,248,3,244,0,0,0,3,248,3,244,0,0,0,3,248,3,244,0,0,0,3,248,3,244,0,0,0,3,248,3,255,255,255,248,3,248,3,255,255,255,248,3,248,3,255,255,255,248,3,248,0,0,127,64,0,3,248,0,0,63,64,0,3,248,0,0,63,64,0,3,248,0,0,63,64,0,3,248,0,0,127,154,191,131,248,255,255,255,255,255,131,248,255,255,255,255,255,131,248,191,255,254,169,64,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,47,192,0,0,3,248,0,63,192,0,0,2,164,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,255,255,255,255,254,0,63,255,255,255,255,254,0,63,255,255,255,255,254,0,0,0,0,0,0,0,
  // 0xb428  됨
  40,180,27,33,231,33,2,254,0,0,0,0,0,2,164,0,0,0,0,0,3,248,3,255,255,255,244,3,248,3,255,255,255,244,3,248,3,255,255,255,244,3,248,3,248,0,0,0,3,248,3,244,0,0,0,3,248,3,244,0,0,0,3,248,3,244,0,0,0,3,248,3,244,0,0,0,3,248,3,255,255,255,248,3,248,3,255,255,255,248,3,248,3,255,255,255,248,3,248,0,0,63,64,0,3,248,0,0,63,64,0,3,248,0,0,63,64,0,3,248,0,0,127,154,191,195,248,255,255,255,255,255,195,248,255,255,255,255,255,131,248,191,255,234,149,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,0,0,0,63,255,255,255,255,248,0,63,255,255,255,255,248,0,63,255,255,255,255,248,0,63,192,0,0,3,248,0,63,192,0,0,3,248,0,63,192,0,0,3,248,0,63,192,0,0,3,248,0,63,192,0,0,3,248,0,63,255,255,255,255,248,0,63,255,255,255,255,248,0,63,255,255,255,255,248,
  // 0xb4a4  뒤
  164,180,27,34,238,33,2,253,0,0,0,0,0,2,164,0,0,0,0,0,3,248,7,255,255,255,244,3,248,7,255,255,255,244,3,248,7,255,255,255,244,3,248,7,244,0,0,0,3,248,7,244,0,0,0,3,248,7,244,0,0,0,3,248,7,244,0,0,0,3,248,7,244,0,0,0,3,248,7,244,0,0,0,3,248,7,244,0,0,0,3,248,7,255,255,255,248,3,248,7,255,255,255,248,3,248,7,255,255,255,248,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,21,67,248,255,255,255,255,255,195,248,255,255,255,255,255,195,248,255,255,255,254,149,3,248,255,255,255,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,0,0,0,3,248,
  // 0xb4dc  드
  220,180,30,27,216,33,2,1,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,
  // 0xb514  디
  20,181,25,35,245,33,4,252,0,0,0,0,0,21,0,0,0,0,0,0,63,128,0,0,0,0,0,63,128,0,0,0,0,0,63,128,255,255,255,253,0,63,128,255,255,255,253,0,63,128,255,255,255,253,0,63,128,254,0,0,0,0,63,128,254,0,0,0,0,63,128,254,0,0,0,0,63,128,254,0,0,0,0,63,128,254,0,0,0,0,63,128,254,0,0,0,0,63,128,254,0,0,0,0,63,128,254,0,0,0,0,63,128,254,0,0,0,0,63,128,254,0,0,0,0,63,128,254,0,0,0,0,63,128,254,0,0,0,0,63,128,254,0,0,0,0,63,128,254,0,0,0,0,63,128,254,0,0,0,0,63,128,254,0,5,107,240,63,128,255,255,255,255,240,63,128,255,255,255,255,240,63,128,255,255,255,165,0,63,128,0,0,0,0,0,63,128,0,0,0,0,0,63,128,0,0,0,0,0,63,128,0,0,0,0,0,63,128,0,0,0,0,0,63,128,0,0,0,0,0,63,128,0,0,0,0,0,63,128,0,0,0,0,0,63,128,0,0,0,0,0,0,0,
  // 0xb77c  라
  124,183,29,34,16,33,3,253,0,0,0,0,0,21,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,255,255,255,252,0,191,0,0,255,255,255,252,0,191,0,0,255,255,255,252,0,191,0,0,0,0,2,252,0,191,0,0,0,0,2,252,0,191,0,0,0,0,2,252,0,191,0,0,0,0,2,252,0,191,0,0,0,0,2,252,0,191,0,0,0,0,2,252,0,191,0,0,255,255,255,252,0,191,0,0,255,255,255,252,0,191,255,192,255,255,255,252,0,191,255,192,255,0,0,0,0,191,255,192,255,0,0,0,0,191,0,0,255,0,0,0,0,191,0,0,255,0,0,0,0,191,0,0,255,0,0,0,0,191,0,0,255,0,0,0,0,191,0,0,255,0,5,107,240,191,0,0,255,255,255,255,240,191,0,0,255,255,255,255,240,191,0,0,255,255,254,148,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,
  // 0xb7ec  러
  236,183,26,34,238,33,3,253,0,0,0,0,0,10,160,0,0,0,0,0,15,224,0,0,0,0,0,15,224,255,255,255,244,0,15,224,255,255,255,244,0,15,224,255,255,255,244,0,15,224,0,0,3,244,0,15,224,0,0,3,244,0,15,224,0,0,3,244,0,15,224,0,0,3,244,0,15,224,0,0,3,244,0,15,224,0,0,3,244,0,15,224,0,0,3,244,0,15,224,255,255,255,244,191,255,224,255,255,255,244,191,255,224,255,255,255,244,191,255,224,254,0,0,0,0,15,224,254,0,0,0,0,15,224,254,0,0,0,0,15,224,254,0,0,0,0,15,224,254,0,0,0,0,15,224,254,0,0,0,0,15,224,254,0,5,107,192,15,224,255,255,255,255,192,15,224,255,255,255,255,192,15,224,255,255,254,148,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,
  // 0xb808  레
  8,184,27,34,238,33,3,253,0,0,0,0,0,1,84,0,0,0,0,106,3,248,0,0,0,0,191,3,248,0,0,0,0,191,3,248,255,255,253,0,191,3,248,255,255,253,0,191,3,248,255,255,253,0,191,3,248,0,0,253,0,191,3,248,0,0,253,0,191,3,248,0,0,253,0,191,3,248,0,0,253,0,191,3,248,0,0,253,0,191,3,248,0,0,253,63,255,3,248,255,255,253,63,255,3,248,255,255,253,63,255,3,248,255,255,253,0,191,3,248,253,0,0,0,191,3,248,253,0,0,0,191,3,248,253,0,0,0,191,3,248,253,0,0,0,191,3,248,253,0,0,0,191,3,248,253,0,0,0,191,3,248,253,0,90,240,191,3,248,255,255,255,240,191,3,248,255,255,255,240,191,3,248,255,255,233,64,191,3,248,0,0,0,0,191,3,248,0,0,0,0,191,3,248,0,0,0,0,191,3,248,0,0,0,0,191,3,248,0,0,0,0,191,3,248,0,0,0,0,191,3,248,0,0,0,0,21,3,248,0,0,0,0,0,3,248,
  // 0xb825  력
  37,184,26,35,245,33,3,252,0,0,0,0,0,10,144,0,0,0,0,0,15,224,255,255,255,240,0,15,224,255,255,255,240,0,15,224,255,255,255,240,0,15,224,0,0,11,240,255,255,224,0,0,11,240,255,255,224,0,0,11,240,255,255,224,0,0,11,240,0,15,224,191,255,255,240,0,15,224,255,255,255,240,0,15,224,255,255,255,240,0,15,224,255,0,0,0,255,255,224,255,0,0,0,255,255,224,255,0,0,0,255,255,224,255,0,0,0,0,15,224,255,0,5,191,0,15,224,255,255,255,255,0,15,224,255,255,255,255,0,15,224,255,255,254,165,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,5,64,0,0,0,0,0,0,0,0,255,255,255,255,255,224,0,255,255,255,255,255,224,0,255,255,255,255,255,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,0,0,
  // 0xb85c  로
  92,184,30,27,216,33,2,1,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,255,255,255,255,255,244,0,2,255,255,255,255,255,244,0,2,255,255,255,255,255,244,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,
  // 0xb8cc  료
  204,184,30,27,216,33,2,1,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,255,255,255,255,255,244,0,2,255,255,255,255,255,244,0,2,255,255,255,255,255,244,0,0,1,253,0,15,224,0,0,0,1,253,0,15,224,0,0,0,1,253,0,15,224,0,0,0,1,253,0,15,224,0,0,0,1,253,0,15,224,0,0,0,1,253,0,15,224,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,
  // 0xb974  르
  116,185,30,27,216,33,2,1,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,255,255,255,255,255,244,0,2,255,255,255,255,255,244,0,2,255,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,
  // 0xb9ac  리
  172,185,26,34,238,33,3,253,0,0,0,0,0,5,64,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,127,255,255,254,0,15,224,127,255,255,254,0,15,224,127,255,255,254,0,15,224,0,0,0,254,0,15,224,0,0,0,254,0,15,224,0,0,0,254,0,15,224,0,0,0,254,0,15,224,0,0,0,254,0,15,224,0,0,0,254,0,15,224,127,255,255,254,0,15,224,127,255,255,254,0,15,224,127,255,255,254,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,0,0,0,15,224,127,64,5,106,253,15,224,127,255,255,255,253,15,224,127,255,255,255,253,15,224,127,255,255,169,64,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,
  // 0xb9b0  린
  176,185,27,34,238,33,3,253,0,0,0,0,0,5,64,0,0,0,0,0,15,224,0,0,0,0,0,15,224,191,255,255,253,0,15,224,191,255,255,253,0,15,224,191,255,255,253,0,15,224,0,0,1,253,0,15,224,0,0,1,253,0,15,224,0,0,1,253,0,15,224,0,0,1,253,0,15,224,191,255,255,253,0,15,224,191,255,255,253,0,15,224,191,255,255,252,0,15,224,191,0,0,0,0,15,224,191,0,0,0,0,15,224,191,0,0,0,0,15,224,191,0,0,0,0,15,224,191,0,1,107,248,15,224,191,255,255,255,252,15,224,191,255,255,255,252,15,224,191,255,255,165,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,106,0,0,0,15,224,0,255,0,0,0,15,224,0,255,0,0,0,5,64,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,255,255,255,255,244,0,255,255,255,255,255,244,0,255,255,255,255,255,244,0,0,0,0,0,0,0,
  // 0xb9bd  립
  189,185,26,33,231,33,3,254,0,0,0,0,0,10,144,0,0,0,0,0,15,224,191,255,255,253,0,15,224,191,255,255,253,0,15,224,191,255,255,253,0,15,224,0,0,1,253,0,15,224,0,0,1,253,0,15,224,0,0,1,253,0,15,224,0,0,1,253,0,15,224,191,255,255,253,0,15,224,191,255,255,253,0,15,224,191,255,255,252,0,15,224,191,0,0,0,0,15,224,191,0,0,0,0,15,224,191,0,0,22,180,15,224,191,255,255,255,248,15,224,191,255,255,255,252,15,224,191,255,255,233,64,15,224,0,0,0,0,0,10,144,0,0,0,0,0,0,0,0,106,0,0,0,10,144,0,191,0,0,0,15,224,0,191,0,0,0,15,224,0,191,0,0,0,15,224,0,191,255,255,255,255,224,0,191,255,255,255,255,224,0,191,255,255,255,255,224,0,191,0,0,0,15,224,0,191,0,0,0,15,224,0,191,0,0,0,15,224,0,191,255,255,255,255,224,0,191,255,255,255,255,224,0,191,255,255,255,255,224,
  // 0xb9c1  링
  193,185,26,34,238,33,3,253,0,0,0,0,0,5,64,0,0,0,0,0,15,224,0,0,0,0,0,15,224,191,255,255,253,0,15,224,191,255,255,253,0,15,224,191,255,255,253,0,15,224,0,0,1,253,0,15,224,0,0,1,253,0,15,224,0,0,1,253,0,15,224,127,255,255,253,0,15,224,191,255,255,253,0,15,224,191,255,255,253,0,15,224,191,0,0,0,0,15,224,191,0,0,0,0,15,224,191,0,0,0,0,15,224,191,0,0,90,248,15,224,191,255,255,255,248,15,224,191,255,255,255,252,15,224,191,255,255,233,64,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,0,0,0,0,27,255,250,64,0,0,2,255,255,255,248,0,0,47,255,255,255,255,0,0,127,228,0,6,255,192,0,255,64,0,0,47,224,0,254,0,0,0,15,240,0,254,0,0,0,15,224,0,255,64,0,0,47,224,0,127,245,0,6,255,192,0,31,255,255,255,255,0,0,2,255,255,255,248,0,0,0,26,255,250,64,0,
  // 0xba48  멈
  72,186,26,33,231,33,3,254,0,0,0,0,0,5,80,0,0,0,0,0,15,224,0,0,0,0,0,15,224,255,255,255,253,0,15,224,255,255,255,253,0,15,224,255,255,255,253,0,15,224,255,0,1,253,0,15,224,255,0,1,253,0,15,224,255,0,1,253,0,15,224,255,0,1,255,255,255,224,255,0,1,255,255,255,224,255,0,1,255,255,255,224,255,0,1,253,0,15,224,255,0,1,253,0,15,224,255,0,1,253,0,15,224,255,255,255,253,0,15,224,255,255,255,253,0,15,224,191,255,255,253,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,10,144,0,0,0,0,0,0,0,0,191,255,255,255,255,224,0,191,255,255,255,255,224,0,191,255,255,255,255,224,0,191,0,0,0,15,224,0,191,0,0,0,15,224,0,191,0,0,0,15,224,0,191,0,0,0,15,224,0,191,0,0,0,15,224,0,191,0,0,0,15,224,0,191,255,255,255,255,224,0,191,255,255,255,255,224,0,191,255,255,255,255,224,
  // 0xba54  메
  84,186,27,34,238,33,3,253,0,0,0,0,0,2,164,0,0,0,0,127,3,248,0,0,0,0,127,3,248,0,0,0,0,127,3,248,255,255,255,64,127,3,248,255,255,255,64,127,3,248,255,255,255,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,255,255,3,248,253,0,63,255,255,3,248,253,0,63,255,255,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,255,255,255,64,127,3,248,255,255,255,64,127,3,248,255,255,255,64,127,3,248,0,0,0,0,127,3,248,0,0,0,0,127,3,248,0,0,0,0,127,3,248,0,0,0,0,127,3,248,0,0,0,0,127,3,248,0,0,0,0,127,3,248,0,0,0,0,127,3,248,0,0,0,0,21,3,248,0,0,0,0,0,3,244,
  // 0xba74  면
  116,186,27,34,238,33,3,253,0,0,0,0,0,6,144,0,0,0,0,0,15,224,0,0,0,0,0,15,224,191,255,255,253,0,15,224,255,255,255,253,0,15,224,255,255,255,253,0,15,224,255,0,1,255,255,255,224,255,0,1,255,255,255,224,255,0,1,255,255,255,224,255,0,1,253,0,15,224,255,0,1,253,0,15,224,255,0,1,253,0,15,224,255,0,1,253,0,15,224,255,0,1,255,255,255,224,255,0,1,255,255,255,224,255,0,1,255,255,255,224,255,255,255,253,0,15,224,255,255,255,253,0,15,224,255,255,255,253,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,42,0,0,0,15,224,0,127,64,0,0,15,224,0,127,64,0,0,10,144,0,127,64,0,0,0,0,0,127,64,0,0,0,0,0,127,64,0,0,0,0,0,127,64,0,0,0,0,0,127,64,0,0,0,0,0,127,255,255,255,255,248,0,127,255,255,255,255,248,0,127,255,255,255,255,248,0,0,0,0,0,0,0,
  // 0xbaa8  모
  168,186,30,27,216,33,2,1,3,255,255,255,255,255,240,0,3,255,255,255,255,255,240,0,3,255,255,255,255,255,240,0,3,248,0,0,0,15,240,0,3,248,0,0,0,15,240,0,3,248,0,0,0,15,240,0,3,248,0,0,0,15,240,0,3,248,0,0,0,15,240,0,3,248,0,0,0,15,240,0,3,248,0,0,0,15,240,0,3,248,0,0,0,15,240,0,3,248,0,0,0,15,240,0,3,248,0,0,0,15,240,0,3,255,255,255,255,255,240,0,3,255,255,255,255,255,240,0,3,255,255,255,255,255,240,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,
  // 0xbabb  못
  187,186,29,32,0,33,2,253,1,255,255,255,255,255,208,0,1,255,255,255,255,255,208,0,1,255,255,255,255,255,208,0,1,252,0,0,0,15,208,0,1,252,0,0,0,15,208,0,1,252,0,0,0,15,208,0,1,252,0,0,0,15,208,0,1,252,0,0,0,15,208,0,1,255,255,255,255,255,208,0,1,255,255,255,255,255,208,0,1,255,255,255,255,255,208,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,128,0,0,0,0,0,0,255,192,0,0,0,0,0,3,255,240,0,0,0,0,0,15,251,252,0,0,0,0,0,127,226,255,64,0,0,0,7,255,128,191,244,0,0,6,255,254,0,47,255,228,0,11,255,240,0,3,255,252,0,7,254,0,0,0,47,244,0,2,64,0,0,0,0,96,0,
  // 0xbbf8  미
  248,187,26,35,245,33,3,252,0,0,0,0,0,5,64,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,127,255,255,255,0,15,224,127,255,255,255,0,15,224,127,255,255,255,0,15,224,127,0,0,255,0,15,224,127,0,0,255,0,15,224,127,0,0,255,0,15,224,127,0,0,255,0,15,224,127,0,0,255,0,15,224,127,0,0,255,0,15,224,127,0,0,255,0,15,224,127,0,0,255,0,15,224,127,0,0,255,0,15,224,127,0,0,255,0,15,224,127,0,0,255,0,15,224,127,0,0,255,0,15,224,127,0,0,255,0,15,224,127,0,0,255,0,15,224,127,0,0,255,0,15,224,127,0,0,255,0,15,224,127,255,255,255,0,15,224,127,255,255,255,0,15,224,127,255,255,255,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,0,0,
  // 0xbc00  밀
  0,188,27,34,238,33,3,253,0,0,0,0,0,10,144,0,0,0,0,0,15,224,127,255,255,255,0,15,224,191,255,255,255,0,15,224,191,255,255,255,0,15,224,191,0,0,191,0,15,224,191,0,0,191,0,15,224,191,0,0,191,0,15,224,191,0,0,191,0,15,224,191,0,0,191,0,15,224,191,0,0,191,0,15,224,191,0,0,191,0,15,224,191,0,0,191,0,15,224,191,255,255,255,0,15,224,191,255,255,255,0,15,224,191,255,255,255,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,5,80,0,0,0,0,0,0,0,0,191,255,255,255,255,224,0,191,255,255,255,255,224,0,191,255,255,255,255,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,191,255,255,255,255,224,0,191,255,255,255,255,224,0,191,170,170,170,170,144,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,0,0,0,0,0,0,191,255,255,255,255,248,0,191,255,255,255,255,248,0,191,255,255,255,255,248,
  // 0xbc14  바
  20,188,29,34,16,33,3,253,0,0,0,0,0,106,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,169,0,0,169,0,191,0,0,254,0,1,253,0,191,0,0,254,0,1,253,0,191,0,0,254,0,1,253,0,191,0,0,254,0,1,253,0,191,0,0,254,0,1,253,0,191,0,0,254,0,1,253,0,191,0,0,254,0,1,253,0,191,0,0,254,0,1,253,0,191,0,0,255,255,255,253,0,191,0,0,255,255,255,253,0,191,255,192,255,255,255,253,0,191,255,192,254,0,1,253,0,191,255,192,254,0,1,253,0,191,0,0,254,0,1,253,0,191,0,0,254,0,1,253,0,191,0,0,254,0,1,253,0,191,0,0,254,0,1,253,0,191,0,0,254,0,1,253,0,191,0,0,254,0,1,253,0,191,0,0,255,255,255,253,0,191,0,0,255,255,255,253,0,191,0,0,255,255,255,253,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,
  // 0xbc84  버
  132,188,26,35,245,33,3,252,0,0,0,0,0,5,80,0,0,0,0,0,15,240,0,0,0,0,0,15,240,170,0,1,168,0,15,240,254,0,1,253,0,15,240,254,0,1,253,0,15,240,254,0,1,253,0,15,240,254,0,1,253,0,15,240,254,0,1,253,0,15,240,254,0,1,253,0,15,240,254,0,1,253,0,15,240,254,0,1,253,0,15,240,255,255,255,253,0,15,240,255,255,255,255,255,255,240,255,255,255,255,255,255,240,254,0,1,255,255,255,240,254,0,1,253,0,15,240,254,0,1,253,0,15,240,254,0,1,253,0,15,240,254,0,1,253,0,15,240,254,0,1,253,0,15,240,254,0,1,253,0,15,240,254,0,1,253,0,15,240,255,255,255,253,0,15,240,255,255,255,253,0,15,240,255,255,255,253,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,0,0,
  // 0xbca0  베
  160,188,27,34,238,33,3,253,0,0,0,0,0,1,84,0,0,0,0,127,3,248,0,0,0,0,127,3,248,0,0,21,0,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,255,255,255,64,127,3,248,255,255,255,255,255,3,248,255,255,255,255,255,3,248,253,0,63,255,255,3,248,253,0,63,128,191,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,253,0,63,64,127,3,248,255,255,255,64,127,3,248,255,255,255,64,127,3,248,255,255,255,64,127,3,248,0,0,0,0,127,3,248,0,0,0,0,127,3,248,0,0,0,0,127,3,248,0,0,0,0,127,3,248,0,0,0,0,127,3,248,0,0,0,0,127,3,248,0,0,0,0,21,3,248,0,0,0,0,0,3,248,
  // 0xbca8  벨
  168,188,28,34,238,33,3,253,0,0,0,0,0,1,80,0,0,0,0,126,3,244,169,0,26,64,191,3,244,254,0,47,192,191,3,244,254,0,47,192,191,3,244,254,0,47,192,191,3,244,255,255,255,192,191,3,244,255,255,255,192,191,3,244,255,255,255,255,255,3,244,254,0,47,255,255,3,244,254,0,47,255,255,3,244,254,0,47,192,191,3,244,254,0,47,192,191,3,244,254,0,47,192,191,3,244,255,255,255,192,191,3,244,255,255,255,192,191,3,244,255,255,255,128,191,3,244,0,0,0,0,126,3,244,0,0,0,0,0,0,0,0,127,255,255,255,255,244,0,127,255,255,255,255,244,0,127,255,255,255,255,244,0,0,0,0,0,7,244,0,0,0,0,0,7,244,0,0,0,0,0,7,244,0,127,255,255,255,255,244,0,127,255,255,255,255,244,0,127,234,170,170,170,160,0,127,64,0,0,0,0,0,127,64,0,0,0,0,0,127,64,0,0,0,0,0,127,255,255,255,255,254,0,127,255,255,255,255,254,0,127,255,255,255,255,253,
  // 0xbcf8  본
  248,188,29,32,0,33,2,253,1,253,0,0,0,15,208,0,1,253,0,0,0,15,208,0,1,253,0,0,0,15,208,0,1,253,0,0,0,15,208,0,1,255,255,255,255,255,208,0,1,255,255,255,255,255,208,0,1,255,255,255,255,255,208,0,1,253,0,0,0,15,208,0,1,253,0,0,0,15,208,0,1,253,0,0,0,15,208,0,1,255,255,255,255,255,208,0,1,255,255,255,255,255,208,0,1,255,255,255,255,255,208,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,255,255,255,255,255,240,0,1,255,255,255,255,255,240,0,1,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,
  // 0xbe44  비
  68,190,26,34,238,33,3,253,0,0,0,0,0,5,80,0,0,0,0,0,15,224,0,0,0,0,0,15,224,106,0,0,106,0,15,224,127,0,0,191,0,15,224,127,0,0,191,0,15,224,127,0,0,191,0,15,224,127,0,0,191,0,15,224,127,0,0,191,0,15,224,127,0,0,191,0,15,224,127,0,0,191,0,15,224,127,0,0,191,0,15,224,127,255,255,255,0,15,224,127,255,255,255,0,15,224,127,255,255,255,0,15,224,127,0,0,191,0,15,224,127,0,0,191,0,15,224,127,0,0,191,0,15,224,127,0,0,191,0,15,224,127,0,0,191,0,15,224,127,0,0,191,0,15,224,127,0,0,191,0,15,224,127,0,0,191,0,15,224,127,255,255,255,0,15,224,127,255,255,255,0,15,224,127,255,255,255,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,
  // 0xc0ac  사
  172,192,31,34,16,33,1,253,0,0,0,0,0,5,80,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,106,0,0,11,240,0,0,0,127,0,0,11,240,0,0,0,127,0,0,11,240,0,0,0,127,0,0,11,240,0,0,0,127,0,0,11,240,0,0,0,191,0,0,11,240,0,0,0,191,0,0,11,240,0,0,0,191,64,0,11,240,0,0,0,191,64,0,11,240,0,0,0,255,128,0,11,240,0,0,0,255,192,0,11,240,0,0,1,255,192,0,11,255,252,0,2,255,224,0,11,255,252,0,3,255,240,0,11,255,252,0,11,247,244,0,11,240,0,0,31,227,252,0,11,240,0,0,63,193,255,0,11,240,0,0,191,128,255,128,11,240,0,2,255,0,63,224,11,240,0,11,253,0,47,248,11,240,0,127,248,0,11,255,11,240,0,127,224,0,2,252,11,240,0,47,128,0,0,116,11,240,0,9,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,
  // 0xc0bd  삽
  189,192,30,33,8,33,2,254,0,0,0,0,0,26,128,0,0,0,0,0,0,31,192,0,0,1,252,0,0,31,192,0,0,1,252,0,0,31,192,0,0,2,252,0,0,31,192,0,0,2,253,0,0,31,192,0,0,2,253,0,0,31,192,0,0,3,254,0,0,31,192,0,0,3,255,0,0,31,255,240,0,11,255,64,0,31,255,240,0,15,255,192,0,31,255,240,0,47,223,240,0,31,208,0,0,191,139,252,0,31,192,0,2,255,3,255,0,31,192,0,11,253,0,255,224,31,192,0,191,248,0,127,248,31,192,0,255,208,0,15,240,31,192,0,127,64,0,1,208,31,192,0,36,0,0,0,0,31,192,0,0,0,0,0,0,0,0,0,0,106,0,0,0,26,128,0,0,191,0,0,0,31,192,0,0,191,0,0,0,31,192,0,0,191,0,0,0,31,192,0,0,191,255,255,255,255,192,0,0,191,255,255,255,255,192,0,0,191,255,255,255,255,192,0,0,191,0,0,0,31,192,0,0,191,0,0,0,31,192,0,0,191,0,0,0,31,192,0,0,191,255,255,255,255,192,0,0,191,255,255,255,255,192,0,0,191,255,255,255,255,192,0,
  // 0xc0c8  새
  200,192,29,34,16,33,1,253,0,0,0,0,0,0,21,64,0,0,0,0,15,208,63,128,0,0,0,0,15,208,63,128,0,1,84,0,15,208,63,128,0,2,252,0,15,208,63,128,0,2,252,0,15,208,63,128,0,2,252,0,15,208,63,128,0,2,252,0,15,208,63,128,0,2,252,0,15,208,63,128,0,2,252,0,15,208,63,128,0,3,252,0,15,208,63,128,0,3,252,0,15,208,63,128,0,3,252,0,15,208,63,128,0,3,252,0,15,208,63,128,0,7,253,0,15,255,255,128,0,11,255,0,15,255,255,128,0,15,255,0,15,255,255,128,0,31,255,64,15,208,63,128,0,47,239,192,15,208,63,128,0,127,79,224,15,208,63,128,0,255,15,244,15,208,63,128,2,253,3,253,15,208,63,128,11,252,2,255,79,208,63,128,47,244,0,255,207,208,63,128,127,208,0,63,79,208,63,128,47,128,0,10,15,208,63,128,9,0,0,0,15,208,63,128,0,0,0,0,15,208,63,128,0,0,0,0,15,208,63,128,0,0,0,0,15,208,63,128,0,0,0,0,15,208,63,128,0,0,0,0,15,208,63,128,0,0,0,0,5,64,63,128,0,0,0,0,0,0,63,128,
  // 0xc124  설
  36,193,28,34,238,33,2,253,0,0,0,0,0,2,164,0,0,84,0,0,3,248,0,1,253,0,0,3,248,0,1,253,0,0,3,248,0,1,253,0,0,3,248,0,1,253,0,0,3,248,0,2,254,0,191,255,248,0,3,255,0,191,255,248,0,7,255,64,191,255,248,0,15,255,192,0,3,248,0,31,239,224,0,3,248,0,127,203,252,0,3,248,1,255,67,255,0,3,248,11,254,0,255,224,3,248,191,248,0,127,248,3,248,255,208,0,11,240,3,248,63,64,0,1,144,3,248,20,0,0,0,0,2,164,0,0,0,0,0,0,0,0,31,255,255,255,255,248,0,31,255,255,255,255,248,0,31,255,255,255,255,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,31,255,255,255,255,248,0,31,255,255,255,255,248,0,31,250,170,170,170,168,0,31,208,0,0,0,0,0,31,208,0,0,0,0,0,31,208,0,0,0,0,0,31,255,255,255,255,255,0,31,255,255,255,255,255,0,31,255,255,255,255,255,
  // 0xc18c  소
  140,193,30,28,224,33,2,1,0,0,0,21,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,128,0,0,0,0,0,0,255,192,0,0,0,0,0,1,255,192,0,0,0,0,0,3,255,224,0,0,0,0,0,7,255,240,0,0,0,0,0,15,243,252,0,0,0,0,0,63,209,255,0,0,0,0,1,255,128,255,192,0,0,0,11,254,0,63,248,0,0,0,191,248,0,15,255,128,0,47,255,224,0,2,255,254,0,47,254,0,0,0,127,254,0,15,228,0,0,0,7,252,0,9,0,0,127,0,0,20,0,0,0,0,127,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,127,64,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,
  // 0xc18d  속
  141,193,30,33,8,33,2,253,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,191,128,0,0,0,0,0,0,255,192,0,0,0,0,0,1,255,208,0,0,0,0,0,3,255,240,0,0,0,0,0,15,247,252,0,0,0,0,0,127,210,255,64,0,0,0,7,255,128,191,228,0,0,1,191,253,0,31,255,144,0,31,255,240,0,3,255,253,0,15,254,64,42,0,127,252,0,7,144,0,127,64,1,180,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,255,255,224,0,3,255,255,255,255,255,224,0,3,255,255,255,255,255,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,
  // 0xc2a4  스
  164,194,30,28,224,33,2,1,0,0,0,21,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,128,0,0,0,0,0,0,255,128,0,0,0,0,0,0,255,192,0,0,0,0,0,2,255,208,0,0,0,0,0,3,255,240,0,0,0,0,0,15,247,248,0,0,0,0,0,47,210,254,0,0,0,0,0,191,192,255,128,0,0,0,3,255,0,127,224,0,0,0,47,252,0,31,253,0,0,6,255,240,0,7,255,228,0,63,255,128,0,0,255,255,0,31,253,0,0,0,31,253,0,15,144,0,0,0,1,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,
  // 0xc2ac  슬
  172,194,29,34,16,33,2,253,0,0,0,21,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,191,128,0,0,0,0,0,0,255,192,0,0,0,0,0,1,255,208,0,0,0,0,0,3,255,244,0,0,0,0,0,31,247,253,0,0,0,0,0,255,192,255,192,0,0,0,31,255,64,127,253,64,0,31,255,248,0,11,255,253,0,15,255,144,0,0,191,252,0,15,228,0,0,0,6,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,1,170,170,170,170,175,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,255,255,255,255,255,244,0,2,255,255,255,255,255,244,0,2,255,255,255,255,255,244,0,
  // 0xc2dc  시
  220,194,27,33,231,33,2,253,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,255,0,0,3,248,0,0,255,0,0,3,248,0,0,255,0,0,3,248,0,0,255,0,0,3,248,0,0,255,0,0,3,248,0,0,255,0,0,3,248,0,0,255,0,0,3,248,0,0,255,0,0,3,248,0,1,255,0,0,3,248,0,1,255,64,0,3,248,0,3,255,128,0,3,248,0,3,255,192,0,3,248,0,11,255,224,0,3,248,0,15,235,240,0,3,248,0,47,195,252,0,3,248,0,127,194,254,0,3,248,0,255,64,255,64,3,248,3,254,0,127,208,3,248,31,252,0,47,248,3,248,191,240,0,11,255,3,248,255,192,0,2,253,3,248,127,0,0,0,120,3,248,40,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,2,164,
  // 0xc2dd  식
  221,194,27,34,238,33,2,253,0,0,0,0,0,2,164,0,0,0,0,0,3,248,0,0,254,0,0,3,248,0,0,254,0,0,3,248,0,0,254,0,0,3,248,0,0,254,0,0,3,248,0,0,255,0,0,3,248,0,1,255,0,0,3,248,0,2,255,0,0,3,248,0,3,255,128,0,3,248,0,7,255,192,0,3,248,0,15,255,240,0,3,248,0,63,203,248,0,3,248,0,255,131,254,0,3,248,3,255,0,255,208,3,248,47,252,0,127,252,3,248,255,244,0,15,252,3,248,127,192,0,2,244,3,248,45,0,0,0,16,3,248,0,0,0,0,0,3,248,0,0,0,0,0,1,84,0,0,0,0,0,0,0,0,127,255,255,255,255,248,0,127,255,255,255,255,248,0,127,255,255,255,255,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,
  // 0xc5b4  어
  180,197,27,34,238,33,2,253,0,0,0,0,0,1,84,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,27,249,0,0,3,252,0,191,255,192,0,3,252,2,255,255,240,0,3,252,11,254,111,248,0,3,252,15,240,3,253,0,3,252,47,208,0,254,0,3,252,63,192,0,191,0,3,252,63,64,0,127,0,3,252,127,0,0,63,64,3,252,127,0,0,63,128,3,252,191,0,0,63,255,255,252,191,0,0,47,255,255,252,191,0,0,63,255,255,252,191,0,0,63,128,3,252,127,0,0,63,128,3,252,63,64,0,63,64,3,252,63,128,0,191,0,3,252,47,192,0,255,0,3,252,31,224,2,253,0,3,252,11,248,11,252,0,3,252,3,255,255,240,0,3,252,0,255,255,208,0,3,252,0,47,254,0,0,3,252,0,0,64,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,
  // 0xc5c6  없
  198,197,30,35,24,33,2,252,0,0,0,0,0,1,84,0,0,0,0,0,0,3,248,0,0,47,254,0,0,3,248,0,1,255,255,224,0,3,248,0,11,255,255,252,0,3,248,0,47,244,7,255,0,3,248,0,63,192,0,191,64,3,248,0,127,64,0,63,192,3,248,0,191,0,0,47,255,255,248,0,191,0,0,31,255,255,248,0,191,0,0,47,255,255,248,0,127,64,0,63,192,3,248,0,63,192,0,191,64,3,248,0,47,244,7,255,0,3,248,0,11,255,255,252,0,3,248,0,1,255,255,240,0,3,248,0,0,47,254,64,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,0,0,2,252,1,252,0,127,64,0,2,252,1,252,0,127,64,0,2,252,1,252,0,127,64,0,2,252,1,252,0,127,64,0,2,255,255,252,0,191,128,0,2,255,255,252,0,255,192,0,2,254,171,252,1,255,208,0,2,252,1,252,3,255,224,0,2,252,1,252,11,251,244,0,2,252,1,252,31,243,253,0,2,252,1,252,191,193,255,128,2,255,255,255,255,64,191,240,2,255,255,253,253,0,31,208,1,255,255,252,176,0,2,128,0,0,0,0,0,0,0,0,
  // 0xc5d1  엑
  209,197,28,34,238,33,2,253,0,0,0,0,0,0,84,0,0,0,0,26,128,253,0,0,0,0,31,192,253,0,191,244,0,31,192,253,3,255,255,0,31,192,253,15,255,255,192,31,192,253,63,224,47,240,31,192,253,127,64,7,240,31,192,253,191,0,3,248,31,192,253,254,0,2,255,255,192,253,253,0,2,255,255,192,253,253,0,2,255,255,192,253,254,0,3,248,31,192,253,191,0,3,244,31,192,253,63,128,15,240,31,192,253,47,244,127,224,31,192,253,15,255,255,192,31,192,253,3,255,254,0,31,192,253,0,111,228,0,31,192,253,0,0,0,0,31,192,253,0,0,0,0,5,64,168,0,0,0,0,0,0,0,0,47,255,255,255,255,253,0,47,255,255,255,255,253,0,47,255,255,255,255,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,
  // 0xc5d4  엔
  212,197,28,34,238,33,2,253,0,0,0,0,0,0,84,0,0,0,0,31,192,253,0,0,0,0,31,192,253,0,111,228,0,31,192,253,3,255,254,0,31,192,253,15,255,255,192,31,192,253,47,244,127,224,31,192,253,63,128,15,240,31,192,253,191,0,3,244,31,192,253,254,0,3,248,31,192,253,253,0,2,255,255,192,253,253,0,2,255,255,192,253,254,0,2,255,255,192,253,191,0,3,248,31,192,253,127,64,11,240,31,192,253,63,224,47,240,31,192,253,15,255,255,192,31,192,253,3,255,255,0,31,192,253,0,191,244,0,31,192,253,0,0,0,0,31,192,253,0,0,0,0,31,192,253,0,0,0,0,31,192,253,0,15,224,0,31,192,253,0,15,224,0,31,192,253,0,15,224,0,0,0,253,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,255,255,255,255,255,0,15,255,255,255,255,255,0,15,255,255,255,255,255,0,0,0,0,0,0,0,
  // 0xc5f4  열
  244,197,28,34,238,33,2,253,0,0,0,0,0,2,164,0,0,0,0,0,3,248,0,47,254,64,0,3,248,1,255,255,244,0,3,248,11,255,255,255,255,255,248,47,244,7,255,255,255,248,63,192,0,191,255,255,248,127,64,0,63,192,3,248,191,0,0,47,192,3,248,191,0,0,31,192,3,248,191,0,0,47,192,3,248,127,64,0,63,255,255,248,63,192,0,191,255,255,248,47,248,7,255,255,255,248,11,255,255,252,0,3,248,1,255,255,224,0,3,248,0,27,253,0,0,3,248,0,0,0,0,0,1,84,0,0,0,0,0,0,0,0,31,255,255,255,255,248,0,31,255,255,255,255,248,0,31,255,255,255,255,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,31,255,255,255,255,248,0,31,255,255,255,255,248,0,31,250,170,170,170,168,0,31,208,0,0,0,0,0,31,208,0,0,0,0,0,31,208,0,0,0,0,0,31,255,255,255,255,255,0,31,255,255,255,255,255,0,31,255,255,255,255,255,
  // 0xc608  예
  8,198,28,34,238,33,2,253,0,0,0,0,0,0,169,0,0,0,0,31,192,254,0,0,0,0,31,192,254,0,111,208,0,31,192,254,2,255,252,0,31,192,254,7,255,254,0,31,192,254,15,250,255,64,31,192,254,47,192,63,192,31,192,254,63,128,31,255,255,192,254,63,0,15,255,255,192,254,127,0,11,255,255,192,254,190,0,7,240,31,192,254,190,0,7,240,31,192,254,254,0,7,240,31,192,254,254,0,7,240,31,192,254,254,0,7,240,31,192,254,254,0,7,240,31,192,254,190,0,7,240,31,192,254,190,0,7,240,31,192,254,127,0,11,255,255,192,254,63,0,15,255,255,192,254,63,128,31,255,255,192,254,47,192,63,192,31,192,254,15,250,255,64,31,192,254,7,255,254,0,31,192,254,2,255,252,0,31,192,254,0,111,208,0,31,192,254,0,0,0,0,31,192,254,0,0,0,0,31,192,254,0,0,0,0,31,192,254,0,0,0,0,31,192,254,0,0,0,0,31,192,254,0,0,0,0,5,64,254,0,0,0,0,0,0,254,
  // 0xc624  오
  36,198,30,28,224,33,2,1,0,0,6,255,228,0,0,0,0,1,255,255,255,208,0,0,0,15,255,255,255,252,0,0,0,63,249,64,91,255,0,0,0,255,128,0,0,191,192,0,2,254,0,0,0,47,224,0,3,252,0,0,0,15,240,0,7,244,0,0,0,7,244,0,7,240,0,0,0,3,244,0,7,240,0,0,0,3,244,0,7,244,0,0,0,7,244,0,3,252,0,0,0,15,240,0,2,253,0,0,0,47,224,0,0,255,128,0,0,191,192,0,0,127,249,0,27,255,64,0,0,31,255,255,255,253,0,0,0,2,255,255,255,224,0,0,0,0,27,255,249,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,
  // 0xc628  온
  40,198,29,33,8,33,2,253,0,0,27,255,249,0,0,0,0,7,255,255,255,244,0,0,0,47,255,255,255,254,0,0,0,255,249,0,27,255,192,0,1,255,64,0,0,127,208,0,3,252,0,0,0,15,240,0,3,252,0,0,0,15,240,0,3,252,0,0,0,15,240,0,3,252,0,0,0,15,240,0,1,255,64,0,0,127,224,0,0,255,244,0,11,255,192,0,0,63,255,255,255,255,0,0,0,7,255,255,255,244,0,0,0,0,26,255,233,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,255,255,255,255,255,240,0,1,255,255,255,255,255,240,0,1,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,
  // 0xc644  완
  68,198,30,33,8,33,2,254,0,0,0,0,0,5,64,0,0,0,0,0,0,31,208,0,0,10,254,128,0,31,208,0,0,191,255,248,0,31,208,0,3,255,255,255,0,31,208,0,11,252,0,191,128,31,208,0,15,240,0,47,192,31,208,0,31,208,0,15,208,31,208,0,31,192,0,15,224,31,208,0,31,192,0,15,208,31,208,0,15,208,0,15,208,31,208,0,15,240,0,63,192,31,208,0,7,254,65,255,64,31,255,224,2,255,255,254,0,31,255,224,0,63,255,244,0,31,255,224,0,1,254,0,0,31,208,0,0,0,253,0,0,31,208,0,0,1,254,86,174,31,208,0,255,255,255,255,255,31,208,0,255,255,255,255,254,31,208,0,255,255,250,165,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,85,0,0,0,31,208,0,0,191,0,0,0,31,208,0,0,191,0,0,0,31,192,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,255,255,255,255,244,0,0,191,255,255,255,255,244,0,0,191,255,255,255,255,244,0,
  // 0xc6d0  원
  208,198,29,34,16,33,1,253,0,0,0,0,0,0,85,0,0,0,0,0,0,0,254,0,0,1,191,232,0,0,254,0,0,31,255,255,128,0,254,0,0,191,255,255,240,0,254,0,1,255,64,11,248,0,254,0,2,252,0,3,252,0,254,0,3,252,0,1,252,0,254,0,3,252,0,1,252,0,254,0,2,253,0,3,252,0,254,0,0,255,128,31,244,0,254,0,0,127,255,255,224,0,254,0,0,11,255,255,64,0,254,0,0,0,106,148,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,85,171,224,254,0,127,255,255,255,255,224,254,0,63,255,255,255,255,224,254,0,63,255,255,249,64,0,254,0,0,0,31,208,0,0,254,0,0,0,31,208,31,255,254,0,0,0,31,208,31,255,254,0,0,0,31,208,10,170,254,0,0,21,95,208,0,0,254,0,0,63,159,208,0,0,254,0,0,63,128,0,0,0,170,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,255,255,255,255,255,128,0,63,255,255,255,255,255,128,0,63,255,255,255,255,255,128,0,0,0,0,0,0,0,0,
  // 0xc704  위
  4,199,27,34,238,33,2,253,0,0,0,0,0,1,84,0,0,0,0,0,3,248,0,2,255,224,0,3,248,0,47,255,254,0,3,248,0,255,255,255,192,3,248,3,255,64,127,240,3,248,7,248,0,15,244,3,248,15,240,0,3,248,3,248,15,224,0,3,248,3,248,15,224,0,3,248,3,248,15,240,0,3,248,3,248,7,248,0,15,244,3,248,3,255,64,127,240,3,248,0,255,255,255,192,3,248,0,47,255,254,0,3,248,0,2,191,160,0,3,248,0,0,0,0,0,3,248,0,0,0,85,171,195,248,255,255,255,255,255,195,248,255,255,255,255,255,131,248,255,255,255,233,64,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,63,64,0,3,248,0,0,0,0,0,3,248,
  // 0xc73c  으
  60,199,30,28,224,33,2,1,0,0,6,255,228,0,0,0,0,1,255,255,255,208,0,0,0,11,255,255,255,248,0,0,0,63,253,64,95,255,0,0,0,255,208,0,1,255,192,0,1,255,0,0,0,63,208,0,3,252,0,0,0,15,240,0,3,248,0,0,0,11,240,0,7,244,0,0,0,7,244,0,7,240,0,0,0,3,244,0,7,244,0,0,0,7,244,0,3,248,0,0,0,11,240,0,3,252,0,0,0,15,240,0,1,254,0,0,0,47,224,0,0,255,208,0,1,255,192,0,0,63,253,64,95,255,0,0,0,15,255,255,255,252,0,0,0,1,255,255,255,208,0,0,0,0,27,255,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,
  // 0xc74c  음
  76,199,29,32,0,33,2,254,0,0,26,255,233,0,0,0,0,7,255,255,255,244,0,0,0,63,255,255,255,255,0,0,0,255,228,0,6,255,192,0,2,255,0,0,0,63,224,0,3,252,0,0,0,15,240,0,3,252,0,0,0,15,240,0,3,252,0,0,0,15,240,0,2,255,0,0,0,63,224,0,0,255,228,0,6,255,192,0,0,63,255,255,255,255,0,0,0,7,255,255,255,248,0,0,0,0,43,255,250,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,252,0,0,0,15,224,0,2,252,0,0,0,15,224,0,2,252,0,0,0,15,224,0,2,252,0,0,0,15,224,0,2,252,0,0,0,15,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,
  // 0xc774  이
  116,199,26,34,238,33,3,253,0,0,0,0,0,5,80,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,31,248,0,0,15,224,0,255,255,128,0,15,224,3,255,255,224,0,15,224,15,253,111,244,0,15,224,47,224,3,252,0,15,224,63,192,1,254,0,15,224,127,64,0,255,0,15,224,191,0,0,191,0,15,224,255,0,0,63,64,15,224,254,0,0,63,128,15,224,254,0,0,63,128,15,224,253,0,0,63,128,15,224,254,0,0,63,128,15,224,254,0,0,63,128,15,224,255,0,0,63,64,15,224,191,0,0,127,0,15,224,127,64,0,255,0,15,224,63,128,0,254,0,15,224,47,208,3,252,0,15,224,15,248,31,248,0,15,224,7,255,255,240,0,15,224,1,255,255,192,0,15,224,0,47,254,0,0,15,224,0,0,64,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,15,224,
  // 0xc77c  일
  124,199,28,34,238,33,2,253,0,0,0,0,0,1,80,0,0,0,0,0,3,248,0,27,254,64,0,3,248,1,255,255,244,0,3,248,11,255,255,253,0,3,248,31,248,6,255,64,3,248,63,208,0,127,192,3,248,127,128,0,47,192,3,248,127,0,0,31,208,3,248,191,0,0,15,208,3,248,127,0,0,31,208,3,248,127,128,0,47,192,3,248,63,208,0,127,192,3,248,31,248,6,255,64,3,248,11,255,255,253,0,3,248,1,255,255,244,0,3,248,0,27,254,64,0,3,248,0,0,0,0,0,2,164,0,0,0,0,0,0,0,0,47,255,255,255,255,248,0,47,255,255,255,255,248,0,47,255,255,255,255,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,47,255,255,255,255,248,0,47,255,255,255,255,248,0,47,234,170,170,170,164,0,47,192,0,0,0,0,0,47,192,0,0,0,0,0,47,192,0,0,0,0,0,47,255,255,255,255,254,0,47,255,255,255,255,254,0,47,255,255,255,255,254,
  // 0xc77d  읽
  125,199,27,35,245,33,2,252,0,0,0,0,0,1,84,0,0,0,0,0,3,248,0,27,254,64,0,3,248,1,255,255,240,0,3,248,11,255,255,253,0,3,248,31,248,6,255,64,3,248,63,208,0,127,192,3,248,127,128,0,47,192,3,248,127,0,0,31,208,3,248,191,0,0,15,208,3,248,127,0,0,31,208,3,248,127,128,0,47,192,3,248,63,208,0,127,192,3,248,31,248,6,255,64,3,248,11,255,255,253,0,3,248,1,255,255,244,0,3,248,0,27,254,64,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,0,0,1,255,255,248,255,255,248,1,255,255,248,255,255,248,1,255,255,248,255,255,248,0,0,3,248,0,3,248,0,0,3,248,0,3,248,0,0,3,248,0,3,248,0,255,255,248,0,3,248,0,255,255,248,0,3,248,0,255,170,164,0,3,248,0,253,0,0,0,3,248,0,253,0,0,0,3,248,0,253,0,22,128,3,248,0,255,255,255,192,3,248,0,255,255,255,192,3,248,0,255,254,165,0,3,248,0,0,0,0,0,0,0,
  // 0xc785  입
  133,199,27,33,231,33,2,254,0,0,0,0,0,1,84,0,0,0,0,0,3,248,0,27,254,64,0,3,248,0,255,255,244,0,3,248,7,255,255,254,0,3,248,31,249,6,255,64,3,248,63,208,0,63,192,3,248,127,128,0,31,208,3,248,127,64,0,15,224,3,248,191,0,0,15,224,3,248,127,64,0,15,224,3,248,127,128,0,31,208,3,248,63,208,0,63,192,3,248,31,248,2,255,64,3,248,11,255,255,254,0,3,248,1,255,255,244,0,3,248,0,27,255,64,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,192,0,0,3,248,0,47,192,0,0,3,248,0,47,192,0,0,3,248,0,47,192,0,0,3,248,0,47,255,255,255,255,248,0,47,255,255,255,255,248,0,47,255,255,255,255,248,0,47,192,0,0,3,248,0,47,192,0,0,3,248,0,47,192,0,0,3,248,0,47,255,255,255,255,248,0,47,255,255,255,255,248,0,47,255,255,255,255,248,
  // 0xc790  자
  144,199,31,34,16,33,1,253,0,0,0,0,0,5,80,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,47,255,255,255,252,11,240,0,47,255,255,255,252,11,240,0,47,255,255,255,252,11,240,0,0,0,127,0,0,11,240,0,0,0,127,0,0,11,240,0,0,0,127,0,0,11,240,0,0,0,191,0,0,11,240,0,0,0,191,64,0,11,240,0,0,0,191,64,0,11,240,0,0,0,255,128,0,11,240,0,0,0,255,192,0,11,255,252,0,1,255,192,0,11,255,252,0,3,255,224,0,11,255,252,0,3,251,240,0,11,240,0,0,11,243,248,0,11,240,0,0,31,210,253,0,11,240,0,0,63,192,255,64,11,240,0,0,255,64,127,192,11,240,0,2,255,0,47,244,11,240,0,15,252,0,15,254,11,240,0,127,244,0,3,255,11,240,0,63,208,0,0,188,11,240,0,31,0,0,0,20,11,240,0,4,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,
  // 0xc791  작
  145,199,30,34,16,33,2,253,0,0,0,0,0,5,64,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,127,255,255,255,240,31,192,0,127,255,255,255,240,31,192,0,127,255,255,255,240,31,192,0,0,2,252,0,0,31,192,0,0,2,253,0,0,31,192,0,0,2,253,0,0,31,192,0,0,3,255,0,0,31,255,240,0,7,255,64,0,31,255,240,0,15,255,192,0,31,255,240,0,47,239,224,0,31,208,0,0,127,143,248,0,31,192,0,1,255,7,254,0,31,192,0,11,253,1,255,208,31,192,0,191,248,0,127,248,31,192,0,255,208,0,15,240,31,192,0,127,0,0,1,208,31,192,0,36,0,0,0,0,31,192,0,0,0,0,0,0,5,64,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,192,0,0,255,255,255,255,255,192,0,0,255,255,255,255,255,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,
  // 0xc798  잘
  152,199,31,34,16,33,1,253,0,0,0,0,0,6,160,0,0,0,0,0,0,7,240,0,31,255,255,255,252,7,240,0,31,255,255,255,252,7,240,0,31,255,255,255,252,7,240,0,0,0,191,0,0,7,240,0,0,0,191,64,0,7,240,0,0,0,255,64,0,7,240,0,0,0,255,192,0,7,255,252,0,1,255,208,0,7,255,252,0,3,255,240,0,7,255,252,0,11,251,248,0,7,240,0,0,47,227,255,0,7,240,0,0,255,192,255,224,7,240,0,11,255,0,63,254,7,240,0,127,252,0,11,253,7,240,0,63,224,0,0,188,7,240,0,14,0,0,0,0,7,240,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,240,0,0,63,255,255,255,255,240,0,0,63,255,255,255,255,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,47,255,255,255,255,240,0,0,47,255,255,255,255,240,0,0,47,234,170,170,170,160,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,255,255,255,255,253,0,0,47,255,255,255,255,253,0,0,47,255,255,255,255,253,0,
  // 0xc7a5  장
  165,199,30,34,16,33,2,253,0,0,0,0,0,5,64,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,127,255,255,255,240,31,192,0,127,255,255,255,240,31,192,0,127,255,255,255,240,31,192,0,0,2,252,0,0,31,192,0,0,2,253,0,0,31,192,0,0,2,254,0,0,31,192,0,0,3,254,0,0,31,255,240,0,3,255,0,0,31,255,240,0,11,255,128,0,31,255,240,0,15,255,208,0,31,192,0,0,63,207,244,0,31,192,0,0,255,71,253,0,31,192,0,3,255,2,255,208,31,192,0,47,252,0,191,248,31,192,0,255,240,0,31,240,31,192,0,191,128,0,1,208,31,192,0,56,0,0,0,0,31,192,0,0,0,0,0,0,5,64,0,0,0,26,255,233,0,0,0,0,2,255,255,255,244,0,0,0,31,255,255,255,254,0,0,0,63,249,0,6,255,128,0,0,191,128,0,0,127,192,0,0,255,0,0,0,31,208,0,0,254,0,0,0,15,224,0,0,255,0,0,0,31,208,0,0,191,128,0,0,127,192,0,0,63,249,0,6,255,128,0,0,31,255,255,255,254,0,0,0,2,255,255,255,244,0,0,0,0,26,255,249,0,0,0,
  // 0xc7ac  재
  172,199,29,34,16,33,1,253,0,0,0,0,0,0,26,64,0,0,0,0,15,224,63,128,0,0,0,0,15,224,63,128,0,0,0,0,15,224,63,128,47,255,255,255,15,224,63,128,47,255,255,255,15,224,63,128,47,255,255,255,15,224,63,128,0,3,252,0,15,224,63,128,0,3,248,0,15,224,63,128,0,3,252,0,15,224,63,128,0,3,252,0,15,224,63,128,0,3,252,0,15,224,63,128,0,3,252,0,15,224,63,128,0,3,252,0,15,224,63,128,0,7,253,0,15,255,255,128,0,11,254,0,15,255,255,128,0,15,255,0,15,255,255,128,0,15,255,64,15,224,63,128,0,47,239,192,15,224,63,128,0,63,95,224,15,224,63,128,0,255,15,240,15,224,63,128,1,254,7,252,15,224,63,128,3,252,2,255,79,224,63,128,31,248,0,255,207,224,63,128,127,224,0,63,143,224,63,128,63,192,0,11,15,224,63,128,14,0,0,0,15,224,63,128,0,0,0,0,15,224,63,128,0,0,0,0,15,224,63,128,0,0,0,0,15,224,63,128,0,0,0,0,15,224,63,128,0,0,0,0,15,224,63,128,0,0,0,0,5,80,63,128,0,0,0,0,0,0,47,128,
  // 0xc800  저
  0,200,28,34,238,33,1,253,0,0,0,0,0,0,85,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,31,255,255,255,254,0,255,31,255,255,255,254,0,255,31,255,255,255,254,0,255,0,0,63,64,0,0,255,0,0,63,64,0,0,255,0,0,127,64,0,0,255,0,0,127,128,0,0,255,0,0,127,128,0,0,255,0,0,191,192,31,255,255,0,0,255,192,31,255,255,0,0,255,208,31,255,255,0,1,255,224,0,0,255,0,3,255,240,0,0,255,0,7,243,248,0,0,255,0,15,241,253,0,0,255,0,47,208,255,0,0,255,0,127,192,127,192,0,255,0,255,64,63,240,0,255,3,255,0,15,252,0,255,31,252,0,7,255,64,255,127,240,0,1,255,0,255,47,208,0,0,61,0,255,14,0,0,0,4,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,254,
  // 0xc804  전
  4,200,28,34,238,33,2,253,0,0,0,0,0,1,84,0,0,0,0,0,3,248,0,0,0,0,0,3,248,63,255,255,255,244,3,248,63,255,255,255,244,3,248,63,255,255,255,244,3,248,0,0,254,0,0,3,248,0,0,254,0,0,3,248,0,1,254,0,0,3,248,0,1,255,0,0,3,248,0,2,255,0,63,255,248,0,3,255,128,63,255,248,0,11,255,192,63,255,248,0,15,255,224,0,3,248,0,63,203,248,0,3,248,0,255,131,254,0,3,248,3,255,1,255,208,3,248,47,252,0,127,252,3,248,255,240,0,31,248,3,248,127,128,0,2,240,3,248,41,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,31,208,0,0,3,248,0,31,208,0,0,3,248,0,31,208,0,0,0,0,0,31,208,0,0,0,0,0,31,208,0,0,0,0,0,31,208,0,0,0,0,0,31,208,0,0,0,0,0,31,255,255,255,255,254,0,31,255,255,255,255,254,0,31,255,255,255,255,254,0,0,0,0,0,0,0,
  // 0xc815  정
  21,200,27,34,238,33,2,253,0,0,0,0,0,1,84,0,0,0,0,0,3,248,0,0,0,0,0,3,248,63,255,255,255,244,3,248,63,255,255,255,244,3,248,63,255,255,255,244,3,248,0,0,254,0,0,3,248,0,1,254,0,0,3,248,0,1,255,0,0,3,248,0,2,255,0,47,255,248,0,3,255,128,47,255,248,0,11,255,192,47,255,248,0,15,239,240,0,3,248,0,63,203,252,0,3,248,0,255,131,255,0,3,248,7,255,0,255,224,3,248,127,252,0,63,252,3,248,255,240,0,15,244,3,248,127,128,0,1,240,3,248,40,0,0,0,0,3,248,0,0,0,0,0,0,0,0,0,1,175,250,64,0,0,0,127,255,255,253,0,0,3,255,255,255,255,192,0,15,254,64,1,191,240,0,47,224,0,0,15,244,0,63,192,0,0,3,252,0,63,192,0,0,3,252,0,63,192,0,0,3,252,0,47,224,0,0,15,244,0,15,254,64,1,191,240,0,3,255,255,255,255,192,0,0,191,255,255,253,0,0,0,1,191,254,64,0,
  // 0xc81c  제
  28,200,29,34,16,33,1,253,0,0,0,0,0,0,42,64,0,0,0,0,7,240,63,128,0,0,0,0,11,240,63,128,0,0,0,0,11,240,63,128,47,255,255,255,11,240,63,128,47,255,255,255,11,240,63,128,47,255,255,255,11,240,63,128,0,3,248,0,11,240,63,128,0,3,248,0,11,240,63,128,0,3,248,0,11,240,63,128,0,3,252,0,11,240,63,128,0,3,252,0,11,240,63,128,0,3,252,31,255,240,63,128,0,7,252,31,255,240,63,128,0,11,253,31,255,240,63,128,0,15,254,0,11,240,63,128,0,15,255,0,11,240,63,128,0,31,255,64,11,240,63,128,0,63,175,192,11,240,63,128,0,127,31,208,11,240,63,128,0,255,15,240,11,240,63,128,2,253,7,248,11,240,63,128,7,252,3,254,11,240,63,128,31,240,0,255,203,240,63,128,127,208,0,63,139,240,63,128,63,128,0,15,11,240,63,128,14,0,0,0,11,240,63,128,0,0,0,0,11,240,63,128,0,0,0,0,11,240,63,128,0,0,0,0,11,240,63,128,0,0,0,0,11,240,63,128,0,0,0,0,11,240,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,64,
  // 0xc8fd  죽
  253,200,30,32,0,33,2,253,7,255,255,255,255,255,248,0,7,255,255,255,255,255,248,0,7,255,255,255,255,255,248,0,0,0,0,255,192,0,0,0,0,0,2,255,224,0,0,0,0,0,7,255,244,0,0,0,0,0,47,243,253,0,0,0,0,1,255,192,255,208,0,0,0,111,255,64,127,254,64,0,31,255,248,0,15,255,253,0,15,255,144,0,1,191,252,0,15,232,0,0,0,10,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,3,255,255,255,255,255,224,0,3,255,255,255,255,255,224,0,3,255,255,255,255,255,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,
  // 0xc900  준
  0,201,30,32,0,33,2,253,7,255,255,255,255,255,248,0,7,255,255,255,255,255,248,0,7,255,255,255,255,255,248,0,0,0,0,255,192,0,0,0,0,0,1,255,208,0,0,0,0,0,3,255,240,0,0,0,0,0,15,247,252,0,0,0,0,0,127,210,255,64,0,0,0,2,255,128,191,228,0,0,1,191,254,0,47,255,144,0,31,255,244,0,7,255,253,0,15,255,64,0,0,127,252,0,7,144,0,0,0,1,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,2,252,0,63,128,0,0,0,2,252,0,63,128,0,0,0,2,252,0,63,128,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,
  // 0xc911  중
  17,201,29,32,0,33,2,253,7,255,255,255,255,255,248,0,7,255,255,255,255,255,248,0,7,255,255,255,255,255,248,0,0,0,0,255,192,0,0,0,0,0,2,255,224,0,0,0,0,0,7,255,244,0,0,0,0,0,47,243,254,0,0,0,0,1,255,192,255,208,0,0,0,111,255,64,127,254,64,0,31,255,248,0,11,255,253,0,15,255,144,0,1,191,252,0,15,232,0,0,0,10,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,107,255,229,0,0,0,0,11,255,255,255,244,0,0,0,63,255,255,255,255,0,0,0,255,208,0,6,255,192,0,1,254,0,0,0,63,208,0,2,252,0,0,0,31,224,0,2,252,0,0,0,31,224,0,1,255,0,0,0,63,208,0,0,255,228,0,6,255,192,0,0,63,255,255,255,255,0,0,0,7,255,255,255,244,0,0,0,0,26,255,233,0,0,0,
  // 0xc990  즐
  144,201,29,32,0,33,2,253,7,255,255,255,255,255,248,0,7,255,255,255,255,255,248,0,7,255,255,255,255,255,248,0,0,0,0,255,192,0,0,0,0,0,2,255,224,0,0,0,0,0,11,255,248,0,0,0,0,0,191,226,255,128,0,0,0,95,255,128,191,253,64,0,31,255,253,0,31,255,254,0,15,255,144,0,1,191,252,0,11,164,0,0,0,6,188,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,1,170,170,170,170,175,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,255,255,255,255,255,244,0,2,255,255,255,255,255,244,0,2,255,255,255,255,255,244,0,
  // 0xc9c0  지
  192,201,27,34,238,33,2,253,0,0,0,0,0,1,84,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,63,255,255,255,252,3,248,63,255,255,255,252,3,248,63,255,255,255,252,3,248,0,0,255,0,0,3,248,0,0,255,0,0,3,248,0,0,255,0,0,3,248,0,0,255,0,0,3,248,0,0,255,0,0,3,248,0,0,255,0,0,3,248,0,1,255,0,0,3,248,0,2,255,64,0,3,248,0,3,255,192,0,3,248,0,3,255,192,0,3,248,0,11,255,224,0,3,248,0,15,215,244,0,3,248,0,63,195,252,0,3,248,0,191,129,255,0,3,248,1,255,0,191,192,3,248,7,253,0,63,240,3,248,47,248,0,15,254,3,248,255,224,0,3,254,3,248,191,128,0,0,188,3,248,61,0,0,0,20,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,
  // 0xcc98  처
  152,204,27,35,245,33,2,252,0,0,0,0,0,2,164,0,0,253,0,0,3,252,0,0,253,0,0,3,252,0,0,253,0,0,3,252,0,0,253,0,0,3,252,0,0,253,0,0,3,252,63,255,255,255,244,3,252,63,255,255,255,244,3,252,63,255,255,255,244,3,252,0,0,253,0,0,3,252,0,0,253,0,0,3,252,0,0,253,0,0,3,252,0,1,254,0,0,3,252,0,1,254,0,0,3,252,0,2,255,0,127,255,252,0,3,255,0,127,255,252,0,3,255,64,127,255,252,0,11,255,192,0,3,252,0,15,239,208,0,3,252,0,47,203,240,0,3,252,0,127,131,252,0,3,252,0,255,2,254,0,3,252,3,253,0,255,128,3,252,15,252,0,63,244,3,252,191,240,0,15,252,3,252,255,192,0,3,248,3,252,62,0,0,0,176,3,252,20,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,0,0,
  // 0xcd08  초
  8,205,30,29,232,33,2,1,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,11,255,255,255,255,255,248,0,11,255,255,255,255,255,248,0,11,255,255,255,255,255,248,0,0,0,0,127,128,0,0,0,0,0,0,191,128,0,0,0,0,0,0,255,192,0,0,0,0,0,1,255,208,0,0,0,0,0,3,255,240,0,0,0,0,0,15,251,252,0,0,0,0,0,63,226,255,0,0,0,0,2,255,192,255,224,0,0,0,47,255,0,47,254,0,0,27,255,248,0,11,255,249,0,31,255,208,0,1,255,254,0,15,253,0,21,0,27,252,0,10,64,0,127,64,0,104,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,
  // 0xcd95  축
  149,205,29,34,16,33,2,253,0,0,0,21,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,7,255,255,255,255,255,240,0,7,255,255,255,255,255,240,0,7,255,255,255,255,255,240,0,0,0,0,255,192,0,0,0,0,0,0,255,192,0,0,0,0,0,3,255,240,0,0,0,0,0,31,251,253,0,0,0,0,1,191,210,255,144,0,0,1,175,255,64,191,254,80,0,31,255,248,0,11,255,253,0,15,255,128,0,0,191,252,0,10,144,0,0,0,1,168,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,3,255,255,255,255,255,224,0,3,255,255,255,255,255,224,0,3,255,255,255,255,255,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,
  // 0xcd9c  출
  156,205,29,34,16,33,2,253,0,0,0,42,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,3,255,255,255,255,255,240,0,3,255,255,255,255,255,244,0,3,255,255,255,255,255,244,0,0,0,0,255,192,0,0,0,0,0,2,255,224,0,0,0,0,0,11,255,248,0,0,0,0,0,127,243,255,64,0,0,1,111,255,192,255,254,80,0,47,255,253,0,31,255,254,0,15,255,144,0,1,191,252,0,10,80,0,0,0,1,104,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,2,170,170,255,234,170,144,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,1,170,170,170,170,175,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,255,255,255,255,255,244,0,2,255,255,255,255,255,244,0,2,255,255,255,255,255,244,0,
  // 0xcda4  춤
  164,205,29,33,8,33,2,254,0,0,0,21,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,3,255,255,255,255,255,240,0,3,255,255,255,255,255,240,0,3,255,255,255,255,255,240,0,0,0,0,255,192,0,0,0,0,0,1,255,208,0,0,0,0,0,7,255,244,0,0,0,0,0,127,247,255,64,0,0,0,27,255,192,255,249,0,0,31,255,253,0,31,255,253,0,15,255,208,0,1,255,252,0,15,164,0,0,0,6,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,252,0,0,0,15,224,0,2,252,0,0,0,15,224,0,2,252,0,0,0,15,224,0,2,252,0,0,0,15,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,
  // 0xcde8  취
  232,205,27,34,238,33,2,253,0,0,21,0,0,1,84,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,15,255,255,255,252,3,248,15,255,255,255,252,3,248,15,255,255,255,252,3,248,0,0,127,128,0,3,248,0,0,191,192,0,3,248,0,0,255,192,0,3,248,0,2,255,240,0,3,248,0,11,255,252,0,3,248,0,63,242,255,128,3,248,6,255,192,191,253,3,248,47,255,0,31,253,3,248,15,248,0,2,252,3,248,11,64,0,0,20,3,248,0,0,0,0,0,3,248,0,0,0,85,175,195,248,255,255,255,255,255,195,248,255,255,255,255,255,195,248,255,255,255,233,64,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,127,64,0,3,248,0,0,0,0,0,3,248,
  // 0xce58  치
  88,206,27,34,238,33,2,253,0,0,0,0,0,2,164,0,0,191,0,0,3,248,0,0,191,0,0,3,248,0,0,191,0,0,3,248,0,0,191,0,0,3,248,0,0,191,0,0,3,248,63,255,255,255,252,3,248,63,255,255,255,252,3,248,63,255,255,255,252,3,248,0,0,191,0,0,3,248,0,0,191,0,0,3,248,0,0,191,0,0,3,248,0,0,191,0,0,3,248,0,0,255,64,0,3,248,0,0,255,128,0,3,248,0,1,255,192,0,3,248,0,2,255,208,0,3,248,0,3,255,224,0,3,248,0,11,247,244,0,3,248,0,15,227,252,0,3,248,0,63,193,255,0,3,248,0,255,128,191,128,3,248,2,255,0,63,240,3,248,15,252,0,31,253,3,248,127,244,0,7,255,3,248,63,208,0,0,253,3,248,30,0,0,0,24,3,248,4,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,
  // 0xce68  침
  104,206,27,33,231,33,2,254,0,0,106,0,0,1,84,0,0,191,0,0,3,248,0,0,191,0,0,3,248,0,0,191,0,0,3,248,47,255,255,255,252,3,248,63,255,255,255,252,3,248,63,255,255,255,252,3,248,0,0,255,0,0,3,248,0,0,255,0,0,3,248,0,0,255,64,0,3,248,0,1,255,192,0,3,248,0,3,255,208,0,3,248,0,11,255,240,0,3,248,0,31,231,252,0,3,248,0,127,194,255,64,3,248,2,255,64,255,244,3,248,47,254,0,63,254,3,248,127,248,0,11,253,3,248,63,208,0,0,184,3,248,29,0,0,0,0,3,248,0,0,0,0,0,1,80,0,0,0,0,0,0,0,0,47,255,255,255,255,248,0,47,255,255,255,255,248,0,47,255,255,255,255,248,0,47,192,0,0,3,248,0,47,192,0,0,3,248,0,47,192,0,0,3,248,0,47,192,0,0,3,248,0,47,192,0,0,3,248,0,47,255,255,255,255,248,0,47,255,255,255,255,248,0,47,255,255,255,255,248,
  // 0xce74  카
  116,206,30,34,16,33,2,253,0,0,0,0,0,21,64,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,15,255,255,255,128,47,192,0,15,255,255,255,128,47,192,0,15,255,255,255,128,47,192,0,0,0,0,63,64,47,192,0,0,0,0,127,64,47,192,0,0,0,0,127,0,47,192,0,0,0,0,191,0,47,192,0,0,0,0,255,0,47,192,0,0,5,90,254,0,47,192,0,191,255,255,253,0,47,192,0,191,255,255,252,0,47,255,240,127,254,171,248,0,47,255,240,16,0,11,244,0,47,255,240,0,0,31,240,0,47,192,0,0,0,63,208,0,47,192,0,0,0,255,128,0,47,192,0,0,2,255,0,0,47,192,0,0,11,253,0,0,47,192,0,0,63,244,0,0,47,192,0,1,255,208,0,0,47,192,0,11,255,64,0,0,47,192,0,191,252,0,0,0,47,192,0,191,224,0,0,0,47,192,0,63,0,0,0,0,47,192,0,4,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,
  // 0xcf1c  켜
  28,207,27,34,238,33,2,253,0,0,0,0,0,1,84,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,31,255,255,255,64,3,248,31,255,255,255,0,3,248,31,255,255,255,0,3,248,0,0,0,127,0,3,248,0,0,0,191,0,3,248,0,0,0,191,0,3,248,0,0,0,255,255,255,248,0,0,0,255,255,255,248,0,0,86,255,255,255,248,255,255,255,252,0,3,248,255,255,255,248,0,3,248,255,255,239,244,0,3,248,84,0,15,240,0,3,248,0,0,47,224,0,3,248,0,0,63,192,0,3,248,0,0,255,67,255,255,248,0,3,255,3,255,255,248,0,15,252,3,255,255,248,0,63,240,0,0,3,248,1,255,208,0,0,3,248,11,255,0,0,0,3,248,191,252,0,0,0,3,248,255,224,0,0,0,3,248,63,0,0,0,0,3,248,20,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,
  // 0xd0d1  탑
  209,208,29,33,8,33,3,254,0,0,0,0,0,106,0,0,0,0,0,0,0,127,0,0,255,255,255,252,0,127,0,0,255,255,255,252,0,127,0,0,255,255,255,252,0,127,0,0,255,0,0,0,0,127,0,0,255,0,0,0,0,127,0,0,255,0,0,0,0,127,0,0,255,0,0,0,0,127,255,192,255,255,255,248,0,127,255,192,255,255,255,248,0,127,255,192,255,255,255,248,0,127,64,0,255,0,0,0,0,127,0,0,255,0,0,0,0,127,0,0,255,0,0,90,128,127,0,0,255,255,255,255,208,127,0,0,255,255,255,255,208,127,0,0,255,255,255,165,0,127,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,0,0,1,168,0,0,0,106,0,0,2,252,0,0,0,127,0,0,2,252,0,0,0,127,0,0,2,252,0,0,0,127,0,0,2,255,255,255,255,255,0,0,2,255,255,255,255,255,0,0,2,255,255,255,255,255,0,0,2,252,0,0,0,127,0,0,2,252,0,0,0,127,0,0,2,252,0,0,0,127,0,0,2,255,255,255,255,255,0,0,2,255,255,255,255,255,0,0,2,255,255,255,255,255,0,0,
  // 0xd130  터
  48,209,26,34,238,33,3,253,0,0,0,0,0,10,160,0,0,0,0,0,15,240,0,0,0,0,0,15,240,191,255,255,253,0,15,240,191,255,255,253,0,15,240,191,255,255,253,0,15,240,191,0,0,0,0,15,240,191,0,0,0,0,15,240,191,0,0,0,0,15,240,191,0,0,0,0,15,240,191,0,0,0,0,15,240,191,0,0,0,0,15,240,191,0,0,0,0,15,240,191,255,255,240,255,255,240,191,255,255,240,255,255,240,191,255,255,240,255,255,240,191,0,0,0,0,15,240,191,0,0,0,0,15,240,191,0,0,0,0,15,240,191,0,0,0,0,15,240,191,0,0,0,0,15,240,191,0,0,0,0,15,240,191,0,1,106,192,15,240,191,255,255,255,208,15,240,191,255,255,255,208,15,240,191,255,255,165,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,
  // 0xd14c  테
  76,209,27,34,238,33,3,253,0,0,0,0,0,2,164,0,0,0,0,191,3,248,0,0,0,0,191,3,248,0,0,0,0,191,3,248,255,255,255,0,191,3,248,255,255,255,0,191,3,248,255,255,255,0,191,3,248,253,0,0,0,191,3,248,253,0,0,0,191,3,248,253,0,0,0,191,3,248,253,0,0,0,191,3,248,253,0,0,0,191,3,248,253,0,0,0,191,3,248,255,255,248,255,255,3,248,255,255,248,255,255,3,248,255,255,248,255,255,3,248,253,0,0,0,191,3,248,253,0,0,0,191,3,248,253,0,0,0,191,3,248,253,0,0,0,191,3,248,253,0,0,0,191,3,248,253,0,0,0,191,3,248,253,0,22,144,191,3,248,255,255,255,224,191,3,248,255,255,255,224,191,3,248,255,255,250,64,191,3,248,0,0,0,0,191,3,248,0,0,0,0,191,3,248,0,0,0,0,191,3,248,0,0,0,0,191,3,248,0,0,0,0,191,3,248,0,0,0,0,191,3,248,0,0,0,0,21,3,248,0,0,0,0,0,3,244,
  // 0xd1a0  토
  160,209,30,27,216,33,2,1,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,253,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,255,255,255,255,255,192,0,2,255,255,255,255,255,192,0,2,255,255,255,255,255,192,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,
  // 0xd2b8  트
  184,210,30,27,216,33,2,1,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,255,255,255,255,255,192,0,2,255,255,255,255,255,192,0,2,255,255,255,255,255,192,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,
  // 0xd39c  펜
  156,211,30,34,16,33,1,253,0,0,0,0,0,0,21,0,0,0,0,0,2,160,63,64,0,0,0,0,3,244,63,64,0,0,0,0,3,244,63,64,63,255,255,255,3,244,63,64,63,255,255,255,3,244,63,64,63,255,255,255,3,244,63,64,1,252,11,224,3,244,63,64,1,252,11,224,3,244,63,64,1,252,11,224,3,244,63,64,1,252,11,227,255,244,63,64,1,252,11,227,255,244,63,64,1,252,11,227,255,244,63,64,1,252,11,224,3,244,63,64,1,252,11,224,3,244,63,64,1,252,11,224,3,244,63,64,1,252,11,246,131,244,63,64,127,255,255,255,195,244,63,64,63,255,255,255,195,244,63,64,63,255,254,165,3,244,63,64,0,0,0,0,3,244,63,64,0,0,0,0,3,244,63,64,0,1,84,0,3,244,63,64,0,3,252,0,3,244,63,64,0,3,252,0,2,160,63,64,0,3,252,0,0,0,21,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,255,255,255,255,255,208,0,3,255,255,255,255,255,208,0,3,255,255,255,255,255,208,0,0,0,0,0,0,0,0,
  // 0xd504  프
  4,213,30,26,208,33,2,1,15,255,255,255,255,255,248,0,15,255,255,255,255,255,248,0,15,255,255,255,255,255,248,0,0,3,248,0,15,240,0,0,0,3,248,0,15,240,0,0,0,3,248,0,15,240,0,0,0,3,248,0,15,240,0,0,0,3,248,0,15,240,0,0,0,3,248,0,15,240,0,0,0,3,248,0,15,240,0,0,0,3,248,0,15,240,0,0,0,3,248,0,15,240,0,0,0,3,248,0,15,240,0,0,0,3,248,0,15,240,0,0,11,255,255,255,255,255,248,0,11,255,255,255,255,255,248,0,11,255,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,
  // 0xd558  하
  88,213,31,34,16,33,1,253,0,0,0,0,0,5,80,0,0,0,191,0,0,11,240,0,0,0,191,0,0,11,240,0,0,0,191,0,0,11,240,0,0,0,191,0,0,11,240,0,0,0,191,0,0,11,240,0,127,255,255,255,254,11,240,0,127,255,255,255,254,11,240,0,127,255,255,255,254,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,2,255,144,0,11,240,0,0,31,255,252,0,11,240,0,0,191,255,255,64,11,240,0,2,255,65,191,192,11,255,252,3,252,0,31,224,11,255,252,7,244,0,15,240,11,255,252,11,240,0,7,240,11,240,0,11,240,0,7,244,11,240,0,11,240,0,7,244,11,240,0,11,240,0,7,240,11,240,0,7,244,0,15,240,11,240,0,3,252,0,31,224,11,240,0,2,255,65,191,192,11,240,0,0,191,255,255,64,11,240,0,0,31,255,252,0,11,240,0,0,2,255,144,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,
  // 0xd569  합
  105,213,30,33,8,33,2,254,0,1,168,0,0,0,0,0,0,1,253,0,0,31,192,0,0,1,253,0,0,31,192,0,0,1,253,0,0,31,192,0,255,255,255,255,252,31,192,0,255,255,255,255,252,31,192,0,255,255,255,255,252,31,192,0,0,0,0,0,0,31,192,0,0,10,254,128,0,31,192,0,0,255,255,248,0,31,255,240,3,255,255,255,0,31,255,240,15,248,0,191,128,31,255,240,15,224,0,47,192,31,192,0,31,192,0,31,208,31,192,0,31,208,0,31,208,31,192,0,15,224,0,63,192,31,192,0,11,253,1,255,128,31,192,0,3,255,255,254,0,31,192,0,0,191,255,244,0,31,192,0,0,6,170,64,0,31,192,0,0,0,0,0,0,0,0,0,0,191,0,0,0,31,192,0,0,191,0,0,0,31,192,0,0,191,0,0,0,31,192,0,0,191,255,255,255,255,192,0,0,191,255,255,255,255,192,0,0,191,255,255,255,255,192,0,0,191,0,0,0,31,192,0,0,191,0,0,0,31,192,0,0,191,0,0,0,31,192,0,0,191,255,255,255,255,192,0,0,191,255,255,255,255,192,0,0,191,255,255,255,255,192,0,
  // 0xd648  홈
  72,214,29,34,16,33,2,253,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,47,255,255,255,255,255,253,0,47,255,255,255,255,255,254,0,47,255,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,111,255,254,64,0,0,0,11,255,255,255,248,0,0,0,127,254,170,175,255,64,0,0,255,128,0,0,191,192,0,0,255,0,0,0,63,192,0,0,255,0,0,0,63,192,0,0,191,228,0,6,255,128,0,0,47,255,255,255,254,0,0,0,6,255,255,255,228,0,0,0,0,5,191,148,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,252,0,0,0,15,224,0,2,252,0,0,0,15,224,0,2,252,0,0,0,15,224,0,2,252,0,0,0,15,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,2,255,255,255,255,255,224,0,
  // 0xd654  화
  84,214,31,34,16,33,1,253,0,0,0,0,0,7,240,0,0,0,63,128,0,7,240,0,0,0,63,128,0,7,240,0,0,0,63,128,0,7,240,0,63,255,255,255,255,71,240,0,63,255,255,255,255,71,240,0,63,255,255,255,255,71,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,1,174,144,0,7,240,0,0,31,255,254,0,7,240,0,0,127,255,255,192,7,240,0,0,255,128,127,224,7,240,0,2,253,0,15,240,7,240,0,3,248,0,7,244,7,244,0,3,244,0,3,244,7,255,252,3,248,0,3,244,7,255,252,2,252,0,11,240,7,255,252,1,255,64,111,224,7,240,0,0,191,255,255,192,7,240,0,0,31,255,254,0,7,240,0,0,1,191,208,0,7,240,0,0,0,63,128,0,7,240,0,0,0,63,128,0,7,240,0,0,0,127,150,175,135,240,0,127,255,255,255,255,199,240,0,127,255,255,255,255,135,240,0,63,255,254,169,64,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,
  // 0xd788  히
  136,215,27,34,238,33,2,253,0,0,0,0,0,1,80,0,0,191,0,0,3,248,0,0,191,0,0,3,248,0,0,191,0,0,3,248,0,0,191,0,0,3,248,0,0,191,0,0,3,248,127,255,255,255,255,3,248,127,255,255,255,255,3,248,127,255,255,255,255,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,2,255,144,0,3,248,0,31,255,252,0,3,248,0,255,255,255,64,3,248,2,255,65,191,192,3,248,3,252,0,31,224,3,248,11,244,0,15,240,3,248,15,240,0,7,244,3,248,15,224,0,3,244,3,248,15,224,0,3,244,3,248,15,240,0,7,244,3,248,11,244,0,15,240,3,248,3,252,0,31,224,3,248,2,255,65,191,192,3,248,0,255,255,255,64,3,248,0,47,255,252,0,3,248,0,2,255,144,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,
};

#endif // HAS_GRAPHICAL_TFT
