/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Katakana 36pt, capital 'A' height: 26px, width: 100%, range: 0x30a0-0x8868, glyphs: 103
extern const uint8_t NotoSans_Medium_Katakana_26[14440] = {
  162,26,160,48,104,136,34,247, // unifont_t
  // 0x30a0  ゠
  160,48,16,8,32,36,10,10,85,85,85,85,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,85,85,85,85,
  // 0x30a1  ァ
  161,48,26,25,175,36,6,252,85,85,85,85,85,85,0,255,255,255,255,255,255,128,255,255,255,255,255,255,208,255,255,255,255,255,255,128,0,0,0,0,0,255,0,0,0,0,0,2,253,0,0,0,31,192,11,248,0,0,0,47,208,31,240,0,0,0,31,192,127,192,0,0,0,31,194,255,64,0,0,0,31,195,253,0,0,0,0,47,192,180,0,0,0,0,47,192,0,0,0,0,0,63,128,0,0,0,0,0,63,128,0,0,0,0,0,191,0,0,0,0,0,0,255,0,0,0,0,0,2,253,0,0,0,0,0,11,252,0,0,0,0,0,47,244,0,0,0,0,0,255,224,0,0,0,0,11,255,128,0,0,0,0,7,253,0,0,0,0,0,0,240,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30a2  ア
  162,48,30,29,232,36,4,254,191,255,255,255,255,255,255,64,191,255,255,255,255,255,255,208,191,255,255,255,255,255,255,208,106,85,85,85,85,85,255,128,0,0,0,0,0,1,255,0,0,0,0,0,0,3,253,0,0,0,0,0,0,15,248,0,0,0,2,253,0,47,240,0,0,0,2,253,0,191,192,0,0,0,2,253,2,255,64,0,0,0,2,252,31,253,0,0,0,0,2,252,47,244,0,0,0,0,2,252,11,208,0,0,0,0,2,252,1,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,63,208,0,0,0,0,0,0,191,192,0,0,0,0,0,2,255,64,0,0,0,0,0,11,254,0,0,0,0,0,0,127,252,0,0,0,0,0,6,255,240,0,0,0,0,0,7,255,128,0,0,0,0,0,0,253,0,0,0,0,0,0,0,32,0,0,0,0,0,0,
  // 0x30a3  ィ
  163,48,25,25,175,36,4,253,0,0,0,0,0,60,0,0,0,0,0,0,255,0,0,0,0,0,3,255,64,0,0,0,0,15,253,0,0,0,0,0,127,244,0,0,0,0,2,255,192,0,0,0,0,31,254,0,0,0,0,0,191,244,0,0,0,0,11,255,192,0,0,0,0,191,255,128,0,0,0,27,255,255,128,0,0,6,255,255,191,128,0,0,191,255,228,127,128,0,0,127,254,0,127,128,0,0,63,144,0,127,128,0,0,4,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,
  // 0x30a4  イ
  164,48,28,30,210,36,3,255,0,0,0,0,0,0,32,0,0,0,0,0,0,252,0,0,0,0,0,3,255,0,0,0,0,0,15,255,0,0,0,0,0,63,248,0,0,0,0,1,255,224,0,0,0,0,7,255,128,0,0,0,0,63,253,0,0,0,0,1,255,240,0,0,0,0,31,255,128,0,0,0,0,191,253,0,0,0,0,27,255,252,0,0,0,1,255,255,252,0,0,0,47,255,251,252,0,0,27,255,255,67,252,0,0,255,255,244,3,252,0,0,191,254,0,3,252,0,0,63,144,0,3,252,0,0,36,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,7,252,0,0,0,0,0,7,252,0,0,0,0,0,7,252,0,0,
  // 0x30a5  ゥ
  165,48,24,27,162,36,6,252,0,0,15,240,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,21,85,95,229,85,80,191,255,255,255,255,254,127,255,255,255,255,255,127,255,255,255,255,255,127,0,0,0,1,254,127,0,0,0,1,254,127,0,0,0,2,253,127,0,0,0,3,252,127,0,0,0,3,252,127,0,0,0,11,244,127,0,0,0,15,240,0,0,0,0,47,224,0,0,0,0,127,192,0,0,0,0,255,128,0,0,0,3,255,0,0,0,0,31,253,0,0,0,0,191,244,0,0,0,27,255,208,0,0,6,255,255,0,0,0,15,255,244,0,0,0,3,255,128,0,0,0,0,228,0,0,0,0,0,0,0,0,0,
  // 0x30a6  ウ
  166,48,28,32,224,36,4,254,0,0,1,254,0,0,0,0,0,1,255,0,0,0,0,0,0,254,0,0,0,0,0,0,254,0,0,0,0,0,0,254,0,0,0,0,0,0,254,0,0,0,85,85,85,255,85,85,96,127,255,255,255,255,255,254,127,255,255,255,255,255,255,127,255,255,255,255,255,254,127,64,0,0,0,2,254,127,64,0,0,0,3,253,127,64,0,0,0,3,252,127,64,0,0,0,7,252,127,64,0,0,0,11,248,127,64,0,0,0,15,244,127,64,0,0,0,15,240,127,64,0,0,0,47,224,21,0,0,0,0,63,208,0,0,0,0,0,191,192,0,0,0,0,0,255,64,0,0,0,0,3,255,0,0,0,0,0,15,252,0,0,0,0,0,63,244,0,0,0,0,1,255,224,0,0,0,0,11,255,128,0,0,0,0,191,254,0,0,0,0,27,255,244,0,0,0,3,255,255,128,0,0,0,1,255,253,0,0,0,0,0,127,144,0,0,0,0,0,20,0,0,0,0,
  // 0x30a7  ェ
  167,48,26,21,147,36,5,255,5,85,85,85,85,85,0,15,255,255,255,255,255,0,15,255,255,255,255,255,0,15,255,255,255,255,255,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,191,255,255,255,255,255,224,191,255,255,255,255,255,224,191,255,255,255,255,255,224,105,85,85,85,85,85,144,
  // 0x30a8  エ
  168,48,30,24,192,36,3,1,15,255,255,255,255,255,255,0,15,255,255,255,255,255,255,0,15,255,255,255,255,255,255,0,10,170,170,191,234,170,170,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,254,170,170,170,170,170,170,240,
  // 0x30a9  ォ
  169,48,25,26,182,36,6,253,0,0,0,10,160,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,0,0,11,224,0,0,0,0,0,11,224,0,0,21,0,0,11,224,1,64,63,255,255,255,255,255,192,63,255,255,255,255,255,192,63,255,255,255,255,255,192,0,0,0,191,240,0,0,0,0,1,255,240,0,0,0,0,3,255,240,0,0,0,0,15,255,240,0,0,0,0,63,231,240,0,0,0,0,255,135,240,0,0,0,7,255,7,240,0,0,0,47,252,7,240,0,0,0,255,240,7,240,0,0,7,255,128,7,240,0,0,127,253,0,7,240,0,0,255,244,0,7,240,0,0,63,128,0,7,240,0,0,13,0,21,11,240,0,0,0,0,47,255,240,0,0,0,0,47,255,224,0,0,0,0,31,255,128,0,0,
  // 0x30aa  オ
  170,48,30,31,248,36,3,254,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,26,85,85,85,127,213,86,144,47,255,255,255,255,255,255,208,47,255,255,255,255,255,255,208,47,255,255,255,255,255,255,208,0,0,0,1,255,192,0,0,0,0,0,3,255,192,0,0,0,0,0,15,255,192,0,0,0,0,0,63,255,192,0,0,0,0,0,255,223,192,0,0,0,0,3,255,31,192,0,0,0,0,15,252,31,192,0,0,0,0,63,240,31,192,0,0,0,1,255,192,31,192,0,0,0,11,255,0,31,192,0,0,0,47,252,0,31,192,0,0,1,255,240,0,31,192,0,0,31,255,128,0,31,208,0,0,191,253,0,0,31,208,0,0,191,240,0,0,31,208,0,0,63,64,0,0,31,208,0,0,8,0,0,64,47,208,0,0,0,0,2,255,255,208,0,0,0,0,1,255,255,192,0,0,0,0,1,255,255,64,0,0,0,0,0,85,100,0,0,0,
  // 0x30ab  カ
  171,48,27,31,217,36,4,254,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,244,0,0,0,0,0,7,244,0,0,0,0,0,7,244,0,0,0,0,0,7,244,0,0,0,101,85,91,249,85,86,128,191,255,255,255,255,255,248,191,255,255,255,255,255,252,191,255,255,255,255,255,252,0,0,15,240,0,3,252,0,0,15,224,0,3,248,0,0,31,208,0,3,248,0,0,31,208,0,3,248,0,0,47,192,0,3,248,0,0,63,192,0,3,244,0,0,127,128,0,3,244,0,0,191,0,0,3,244,0,0,255,0,0,7,244,0,2,254,0,0,7,240,0,7,252,0,0,11,240,0,15,248,0,0,11,240,0,47,240,0,0,15,240,0,191,208,0,0,15,224,2,255,128,0,0,31,208,11,255,0,5,0,127,192,63,252,0,11,255,255,192,255,240,0,11,255,255,64,63,128,0,7,255,254,0,14,0,0,1,90,160,0,0,0,0,0,0,0,0,
  // 0x30ac  ガ
  172,48,31,33,8,36,3,254,0,0,0,0,0,0,1,64,0,0,0,0,0,0,11,192,0,0,3,252,0,7,195,240,0,0,3,252,0,11,209,244,0,0,3,252,0,3,240,252,0,0,3,248,0,1,244,124,0,0,3,248,0,0,252,0,0,0,3,248,0,0,116,0,0,0,3,248,0,0,0,0,127,255,255,255,255,255,244,0,127,255,255,255,255,255,253,0,127,255,255,255,255,255,252,0,37,85,91,245,85,87,252,0,0,0,11,240,0,2,252,0,0,0,15,240,0,2,252,0,0,0,15,224,0,2,252,0,0,0,31,208,0,2,252,0,0,0,47,192,0,3,252,0,0,0,63,192,0,3,248,0,0,0,127,128,0,3,248,0,0,0,191,64,0,3,248,0,0,0,255,0,0,3,244,0,0,3,254,0,0,7,244,0,0,7,252,0,0,7,240,0,0,15,248,0,0,11,240,0,0,63,240,0,0,15,240,0,0,255,192,0,0,15,240,0,3,255,64,0,0,47,224,0,31,254,0,7,234,255,208,0,191,248,0,7,255,255,192,0,127,224,0,7,255,255,64,0,15,64,0,3,255,249,0,0,0,0,0,0,0,0,0,0,
  // 0x30ad  キ
  173,48,29,31,248,36,4,254,0,0,27,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,47,208,0,0,0,0,0,0,31,224,0,0,0,0,0,0,15,224,0,1,128,0,0,0,15,240,22,255,192,0,0,0,11,255,255,255,192,0,0,90,255,255,255,255,208,0,255,255,255,255,255,229,0,0,255,255,255,254,64,0,0,0,255,255,151,252,0,0,0,0,185,64,2,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,254,0,0,27,0,0,0,0,255,1,175,255,0,0,0,0,255,255,255,255,64,0,1,175,255,255,255,255,64,107,255,255,255,255,250,80,0,255,255,255,255,228,0,0,0,255,255,249,127,192,0,0,0,255,164,0,63,192,0,0,0,80,0,0,47,192,0,0,0,0,0,0,31,208,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,11,244,0,0,0,0,0,0,11,248,0,0,0,0,0,0,7,252,0,0,0,0,0,0,2,64,0,0,0,
  // 0x30ae  ギ
  174,48,31,33,8,36,3,254,0,0,0,0,0,0,11,192,0,0,0,0,0,2,71,224,0,0,1,144,0,15,195,240,0,0,47,224,0,3,224,248,0,0,15,224,0,2,244,184,0,0,15,240,0,0,252,0,0,0,11,240,0,0,164,0,0,0,11,240,1,111,208,0,0,0,7,250,255,255,208,0,0,1,175,255,255,255,224,0,171,255,255,255,255,254,144,0,255,255,255,255,229,0,0,0,191,255,251,252,0,0,0,0,127,164,1,253,0,0,0,0,16,0,0,254,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,1,0,0,0,0,191,0,22,255,64,0,0,0,127,175,255,255,128,0,0,22,255,255,255,255,192,5,175,255,255,255,255,229,0,255,255,255,255,250,64,0,0,191,255,255,191,192,0,0,0,127,250,64,31,208,0,0,0,37,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,248,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,228,0,0,0,
  // 0x30af  ク
  175,48,29,33,8,36,3,253,0,0,0,116,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,255,64,0,0,0,0,0,2,254,0,0,0,0,0,0,7,252,0,0,0,0,0,0,15,252,0,1,96,0,0,0,31,255,255,255,254,0,0,0,63,255,255,255,255,128,0,0,255,255,255,255,255,0,0,2,255,0,0,2,255,0,0,11,252,0,0,3,253,0,0,47,244,0,0,3,252,0,0,191,224,0,0,11,252,0,3,255,128,0,0,15,244,0,31,254,0,0,0,31,240,0,191,244,0,0,0,63,208,0,47,208,0,0,0,191,192,0,7,0,0,0,0,255,64,0,0,0,0,0,3,255,0,0,0,0,0,0,11,252,0,0,0,0,0,0,31,244,0,0,0,0,0,0,127,224,0,0,0,0,0,1,255,192,0,0,0,0,0,11,255,0,0,0,0,0,0,63,252,0,0,0,0,0,1,255,240,0,0,0,0,0,31,255,192,0,0,0,0,1,255,254,0,0,0,0,0,111,255,240,0,0,0,0,0,191,255,64,0,0,0,0,0,47,248,0,0,0,0,0,0,11,64,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30b0  グ
  176,48,33,34,50,36,2,253,0,0,0,0,0,0,0,244,0,0,0,0,0,0,0,32,252,0,0,0,0,228,0,1,244,126,0,0,0,0,255,64,0,252,63,0,0,0,2,255,0,0,126,31,128,0,0,3,253,0,0,63,9,0,0,0,11,252,0,0,31,64,0,0,0,15,248,0,1,104,0,0,0,0,63,255,255,255,253,0,0,0,0,191,255,255,255,255,64,0,0,1,255,255,255,255,255,0,0,0,3,254,0,0,3,253,0,0,0,15,252,0,0,3,252,0,0,0,63,240,0,0,7,252,0,0,0,255,192,0,0,15,244,0,0,7,255,64,0,0,31,240,0,0,47,252,0,0,0,47,224,0,0,255,240,0,0,0,127,192,0,0,63,192,0,0,0,255,128,0,0,10,0,0,0,1,255,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,63,240,0,0,0,0,0,0,0,255,208,0,0,0,0,0,0,2,255,128,0,0,0,0,0,0,15,254,0,0,0,0,0,0,0,127,248,0,0,0,0,0,0,2,255,224,0,0,0,0,0,0,47,255,64,0,0,0,0,0,2,255,253,0,0,0,0,0,0,127,255,224,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,63,228,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,
  // 0x30b1  ケ
  177,48,31,32,0,36,2,254,0,0,16,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,191,128,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,2,254,0,0,0,0,0,0,3,254,170,170,170,170,168,0,7,255,255,255,255,255,252,0,15,255,255,255,255,255,252,0,47,255,255,255,255,255,252,0,127,192,0,15,240,0,0,0,255,128,0,15,224,0,0,3,255,0,0,31,224,0,0,11,253,0,0,31,224,0,0,47,248,0,0,47,208,0,0,191,240,0,0,63,192,0,0,47,192,0,0,63,192,0,0,2,0,0,0,127,128,0,0,0,0,0,0,255,64,0,0,0,0,0,1,255,0,0,0,0,0,0,3,254,0,0,0,0,0,0,7,252,0,0,0,0,0,0,15,248,0,0,0,0,0,0,63,240,0,0,0,0,0,0,255,208,0,0,0,0,0,3,255,128,0,0,0,0,0,15,255,0,0,0,0,0,0,191,252,0,0,0,0,0,1,255,224,0,0,0,0,0,0,47,128,0,0,0,0,0,0,5,0,0,0,0,0,
  // 0x30b2  ゲ
  178,48,33,34,50,36,2,253,0,0,0,0,0,0,0,176,0,0,0,0,0,0,0,17,248,0,0,0,101,0,0,1,240,188,0,0,0,191,192,0,0,252,63,0,0,0,255,64,0,0,189,47,64,0,0,255,0,0,0,63,13,0,0,1,254,0,0,0,31,0,0,0,3,253,0,0,0,4,0,0,0,3,252,0,0,0,0,0,0,0,11,255,255,255,255,255,248,0,0,15,255,255,255,255,255,248,0,0,63,255,255,255,255,255,248,0,0,127,234,170,191,250,170,164,0,0,255,64,0,47,208,0,0,0,3,255,0,0,47,208,0,0,0,11,252,0,0,63,192,0,0,0,47,248,0,0,63,192,0,0,0,191,240,0,0,63,192,0,0,0,255,192,0,0,127,128,0,0,0,31,0,0,0,191,64,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,191,208,0,0,0,0,0,0,2,255,192,0,0,0,0,0,0,11,255,0,0,0,0,0,0,0,63,253,0,0,0,0,0,0,2,255,244,0,0,0,0,0,0,1,255,192,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,
  // 0x30b3  コ
  179,48,26,27,189,36,5,255,58,170,170,170,170,170,160,63,255,255,255,255,255,240,63,255,255,255,255,255,240,63,255,255,255,255,255,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,234,170,170,170,191,240,0,0,0,0,0,15,240,0,0,0,0,0,10,160,
  // 0x30b4  ゴ
  180,48,29,34,16,36,5,254,0,0,0,0,0,0,20,0,0,0,0,0,0,16,252,0,0,0,0,0,1,244,126,0,0,0,0,0,0,252,63,0,0,0,0,0,0,189,15,128,0,0,0,0,0,63,11,128,0,0,0,0,0,47,64,0,0,0,0,0,0,8,0,0,255,255,255,255,255,255,192,0,255,255,255,255,255,255,192,0,255,255,255,255,255,255,192,0,170,170,170,170,170,191,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,255,255,255,255,255,255,192,0,255,255,255,255,255,255,192,0,255,255,255,255,255,255,192,0,254,170,170,170,170,191,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,42,128,0,
  // 0x30b5  サ
  181,48,32,32,0,36,2,253,0,1,168,0,0,127,128,0,0,2,253,0,0,127,64,0,0,2,252,0,0,127,64,0,0,1,252,0,0,127,64,0,0,1,252,0,0,127,64,0,0,1,252,0,0,127,64,0,0,1,252,0,0,127,64,0,170,86,254,85,85,191,149,168,191,255,255,255,255,255,255,253,191,255,255,255,255,255,255,253,191,255,255,255,255,255,255,253,0,1,252,0,0,127,64,0,0,1,252,0,0,127,64,0,0,1,252,0,0,127,64,0,0,1,252,0,0,127,64,0,0,1,252,0,0,127,0,0,0,1,252,0,0,191,0,0,0,2,252,0,0,191,0,0,0,2,252,0,0,255,0,0,0,2,253,0,0,254,0,0,0,0,0,0,2,253,0,0,0,0,0,0,3,252,0,0,0,0,0,0,7,252,0,0,0,0,0,0,15,244,0,0,0,0,0,0,63,240,0,0,0,0,0,1,255,192,0,0,0,0,0,11,255,64,0,0,0,0,0,191,253,0,0,0,0,0,3,255,240,0,0,0,0,0,0,191,128,0,0,0,0,0,0,40,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30b6  ザ
  182,48,34,33,41,36,1,253,0,0,0,0,0,0,0,6,0,0,0,85,0,0,42,129,15,0,0,0,254,0,0,63,207,75,128,0,0,254,0,0,63,199,199,192,0,0,254,0,0,63,131,211,208,0,0,254,0,0,63,130,226,208,0,0,254,0,0,63,129,224,0,0,0,254,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,127,255,255,255,255,255,255,254,0,127,255,255,255,255,255,255,254,0,127,255,255,255,255,255,255,254,0,42,150,255,85,85,127,213,169,0,0,0,254,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,0,0,254,0,0,127,64,0,0,0,0,254,0,0,127,64,0,0,0,0,254,0,0,191,0,0,0,0,0,169,0,0,255,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,127,240,0,0,0,0,0,0,1,255,192,0,0,0,0,0,0,31,255,64,0,0,0,0,0,1,255,253,0,0,0,0,0,0,0,255,240,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,4,0,0,0,0,0,
  // 0x30b7  シ
  183,48,30,29,232,36,3,255,0,2,208,0,0,0,0,0,0,7,252,0,0,0,0,0,0,15,255,128,0,0,0,0,0,2,255,240,0,0,0,0,0,0,127,253,0,0,0,0,0,0,11,253,0,0,0,0,0,0,1,248,0,0,0,0,0,0,0,32,0,0,0,0,14,0,0,0,0,0,1,64,47,208,0,0,0,0,3,192,127,252,0,0,0,0,15,208,47,255,128,0,0,0,47,240,2,255,240,0,0,0,127,208,0,127,240,0,0,1,255,128,0,11,208,0,0,3,255,0,0,1,128,0,0,31,252,0,0,0,0,0,0,127,240,0,0,0,0,0,2,255,192,0,0,0,0,0,11,255,64,0,0,0,0,0,127,252,0,0,0,0,0,2,255,240,0,0,0,0,0,31,255,128,0,0,0,0,2,255,253,0,0,0,0,0,111,255,224,0,0,0,0,31,255,255,64,0,0,0,11,255,255,244,0,0,0,0,7,255,254,64,0,0,0,0,2,255,208,0,0,0,0,0,0,228,0,0,0,0,0,0,
  // 0x30b8  ジ
  184,48,31,31,248,36,3,255,0,0,0,0,0,0,1,0,0,0,0,0,0,0,31,64,0,3,192,0,0,8,15,192,0,11,248,0,0,63,7,240,0,31,255,0,0,47,66,244,0,7,255,224,0,15,192,252,0,0,191,252,0,7,224,180,0,0,31,252,0,3,240,0,0,0,2,244,0,1,128,0,0,0,0,96,0,0,0,0,29,0,0,0,0,0,2,0,63,192,0,0,0,0,11,64,191,248,0,0,0,0,31,192,63,255,64,0,0,0,63,224,7,255,224,0,0,0,255,192,0,191,224,0,0,2,255,64,0,31,192,0,0,11,254,0,0,2,64,0,0,47,248,0,0,0,0,0,0,191,224,0,0,0,0,0,3,255,128,0,0,0,0,0,31,254,0,0,0,0,0,0,191,248,0,0,0,0,0,7,255,208,0,0,0,0,0,47,255,64,0,0,0,0,6,255,248,0,0,0,0,0,191,255,208,0,0,0,0,111,255,254,0,0,0,0,15,255,255,224,0,0,0,0,15,255,254,0,0,0,0,0,3,255,144,0,0,0,0,0,2,228,0,0,0,0,0,0,
  // 0x30b9  ス
  185,48,30,29,232,36,3,254,0,0,0,0,0,1,0,0,1,255,255,255,255,255,208,0,1,255,255,255,255,255,240,0,1,255,255,255,255,255,224,0,1,234,170,170,170,191,192,0,0,0,0,0,0,191,128,0,0,0,0,0,0,255,64,0,0,0,0,0,2,255,0,0,0,0,0,0,3,253,0,0,0,0,0,0,11,248,0,0,0,0,0,0,15,240,0,0,0,0,0,0,63,208,0,0,0,0,0,0,191,192,0,0,0,0,0,1,255,0,0,0,0,0,0,3,254,0,0,0,0,0,0,15,255,64,0,0,0,0,0,63,255,208,0,0,0,0,0,255,255,244,0,0,0,0,7,255,15,253,0,0,0,0,31,252,7,255,64,0,0,0,191,240,1,255,208,0,0,7,255,192,0,127,240,0,0,47,254,0,0,31,252,0,1,255,248,0,0,7,255,0,47,255,208,0,0,2,255,192,127,254,0,0,0,0,191,208,47,244,0,0,0,0,63,128,11,64,0,0,0,0,13,0,0,0,0,0,0,0,0,0,
  // 0x30ba  ズ
  186,48,32,35,24,36,3,253,0,0,0,0,0,0,0,64,0,0,0,0,0,0,7,208,0,0,0,0,0,11,195,240,0,0,0,0,0,7,224,248,0,0,0,0,0,2,240,188,0,0,0,0,0,0,248,61,3,170,170,170,170,175,252,0,3,255,255,255,255,255,224,0,3,255,255,255,255,255,192,0,3,255,255,255,255,255,128,0,0,0,0,0,0,255,0,0,0,0,0,0,2,254,0,0,0,0,0,0,3,253,0,0,0,0,0,0,11,252,0,0,0,0,0,0,15,244,0,0,0,0,0,0,47,224,0,0,0,0,0,0,127,192,0,0,0,0,0,0,255,64,0,0,0,0,0,2,255,0,0,0,0,0,0,7,252,0,0,0,0,0,0,31,252,0,0,0,0,0,0,127,255,0,0,0,0,0,1,255,255,192,0,0,0,0,7,255,191,240,0,0,0,0,47,252,47,252,0,0,0,0,191,240,11,255,0,0,0,3,255,192,2,255,192,0,0,47,255,0,0,191,240,0,0,255,248,0,0,47,248,0,11,255,208,0,0,15,254,0,191,255,0,0,0,3,255,64,255,248,0,0,0,0,255,128,63,192,0,0,0,0,126,0,13,0,0,0,0,0,36,0,0,0,0,0,0,0,0,0,
  // 0x30bb  セ
  187,48,30,30,240,36,2,255,0,0,127,64,0,0,0,0,0,0,191,128,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,111,128,0,0,127,64,1,175,255,240,0,0,127,70,191,255,255,240,0,0,127,255,255,255,255,208,0,111,255,255,255,249,191,128,191,255,255,255,229,0,255,0,255,255,255,228,0,2,254,0,191,255,255,64,0,3,252,0,126,64,127,64,0,15,244,0,0,0,127,64,0,47,224,0,0,0,127,64,0,127,192,0,0,0,127,64,1,255,0,0,0,0,127,64,3,253,0,0,0,0,127,64,0,120,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,128,0,0,0,0,0,0,63,192,0,0,5,64,0,0,63,254,170,175,255,128,0,0,47,255,255,255,255,128,0,0,15,255,255,255,255,64,0,0,1,191,255,255,165,0,
  // 0x30bc  ゼ
  188,48,34,33,41,36,1,254,0,0,0,0,0,0,0,124,0,0,0,0,0,0,0,24,63,0,0,0,0,0,0,0,125,31,64,0,0,63,192,0,0,63,15,192,0,0,63,192,0,0,31,135,208,0,0,63,192,0,0,15,194,0,0,0,63,192,0,0,7,192,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,1,64,0,0,0,63,192,0,1,191,224,0,0,0,63,192,6,255,255,248,0,0,0,63,219,255,255,255,240,0,0,0,127,255,255,255,255,224,0,5,191,255,255,255,228,63,192,0,127,255,255,255,144,0,191,64,0,127,255,255,192,0,1,255,0,0,63,249,63,192,0,3,252,0,0,41,0,63,192,0,11,248,0,0,0,0,63,192,0,47,240,0,0,0,0,63,192,0,127,192,0,0,0,0,63,192,1,255,64,0,0,0,0,63,192,0,190,0,0,0,0,0,63,192,0,24,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,47,244,0,1,107,192,0,0,0,31,255,255,255,255,192,0,0,0,15,255,255,255,255,192,0,0,0,2,255,255,255,255,192,0,0,0,0,5,105,85,64,0,0,
  // 0x30bd  ソ
  189,48,27,28,196,36,4,255,1,0,0,0,0,7,148,47,64,0,0,0,11,252,255,192,0,0,0,11,248,63,224,0,0,0,15,244,47,240,0,0,0,15,240,15,252,0,0,0,31,240,7,253,0,0,0,47,224,3,255,0,0,0,63,208,0,255,64,0,0,63,192,0,191,192,0,0,127,128,0,63,224,0,0,255,64,0,47,64,0,1,255,0,0,8,0,0,3,254,0,0,0,0,0,7,252,0,0,0,0,0,15,248,0,0,0,0,0,47,240,0,0,0,0,0,127,208,0,0,0,0,0,255,192,0,0,0,0,3,255,0,0,0,0,0,15,253,0,0,0,0,0,127,244,0,0,0,0,2,255,208,0,0,0,0,15,255,128,0,0,0,0,191,253,0,0,0,0,11,255,240,0,0,0,0,31,255,128,0,0,0,0,7,253,0,0,0,0,0,0,208,0,0,0,0,
  // 0x30be  ゾ
  190,48,31,33,8,36,3,254,0,0,0,0,0,0,2,192,0,0,0,0,0,7,11,224,0,0,0,0,0,31,195,240,0,0,0,0,0,11,209,248,0,0,0,0,0,3,240,188,1,0,0,0,0,1,244,32,31,128,0,0,0,0,144,0,127,208,0,0,0,7,228,0,63,240,0,0,0,11,252,0,15,248,0,0,0,11,248,0,11,252,0,0,0,15,244,0,3,254,0,0,0,15,240,0,1,255,64,0,0,31,224,0,0,255,192,0,0,47,208,0,0,127,208,0,0,63,192,0,0,47,240,0,0,127,192,0,0,15,128,0,0,255,64,0,0,9,0,0,1,255,0,0,0,0,0,0,3,254,0,0,0,0,0,0,11,252,0,0,0,0,0,0,15,244,0,0,0,0,0,0,63,240,0,0,0,0,0,0,191,208,0,0,0,0,0,2,255,64,0,0,0,0,0,11,254,0,0,0,0,0,0,47,252,0,0,0,0,0,1,255,240,0,0,0,0,0,11,255,192,0,0,0,0,0,127,254,0,0,0,0,0,7,255,248,0,0,0,0,0,15,255,208,0,0,0,0,0,2,254,0,0,0,0,0,0,0,160,0,0,0,0,0,
  // 0x30bf  タ
  191,48,29,33,8,36,3,253,0,0,0,189,0,0,0,0,0,0,0,255,64,0,0,0,0,0,1,255,0,0,0,0,0,0,3,253,0,0,0,0,0,0,11,252,0,0,16,0,0,0,15,255,255,255,253,0,0,0,63,255,255,255,255,128,0,0,191,255,255,255,255,64,0,1,255,64,0,2,255,0,0,7,253,0,0,2,254,0,0,31,248,0,0,3,252,0,0,63,240,0,0,7,252,0,1,255,192,0,0,15,244,0,11,255,1,192,0,31,240,0,63,252,7,248,0,63,208,0,255,240,15,255,64,191,192,0,63,128,3,255,224,255,64,0,9,0,0,127,255,255,0,0,0,0,0,15,255,252,0,0,0,0,0,2,255,248,0,0,0,0,0,0,127,253,0,0,0,0,0,0,255,255,128,0,0,0,0,3,255,255,224,0,0,0,0,31,253,127,240,0,0,0,0,191,244,31,192,0,0,0,3,255,208,3,64,0,0,0,47,255,0,0,0,0,0,2,255,248,0,0,0,0,0,127,255,208,0,0,0,0,1,255,254,0,0,0,0,0,0,127,224,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30c0  ダ
  192,48,33,35,59,36,2,253,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,244,0,0,0,0,16,0,0,112,252,0,0,0,0,190,64,0,248,62,0,0,0,0,255,64,0,189,47,64,0,0,2,254,0,0,63,15,64,0,0,3,252,0,0,47,68,0,0,0,15,252,0,1,110,0,0,0,0,31,255,255,255,254,0,0,0,0,63,255,255,255,255,128,0,0,0,255,255,255,255,255,0,0,0,2,255,0,0,1,255,0,0,0,7,252,0,0,3,253,0,0,0,31,244,0,0,3,252,0,0,0,127,224,0,0,11,248,0,0,2,255,128,0,0,15,244,0,0,11,254,2,208,0,47,240,0,0,63,248,11,252,0,63,208,0,0,255,224,15,255,64,191,192,0,0,47,64,2,255,240,255,64,0,0,5,0,0,127,255,254,0,0,0,0,0,0,11,255,252,0,0,0,0,0,0,1,255,248,0,0,0,0,0,0,0,191,253,0,0,0,0,0,0,1,255,255,128,0,0,0,0,0,7,255,255,240,0,0,0,0,0,47,252,127,240,0,0,0,0,0,255,240,15,192,0,0,0,0,7,255,192,3,0,0,0,0,0,127,254,0,0,0,0,0,0,6,255,248,0,0,0,0,0,0,191,255,192,0,0,0,0,0,1,255,253,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,
  // 0x30c1  チ
  193,48,30,31,248,36,3,254,0,0,0,0,0,1,0,0,0,0,0,0,1,127,192,0,0,0,0,6,191,255,224,0,3,255,255,255,255,255,240,0,3,255,255,255,255,249,0,0,2,255,255,255,228,0,0,0,0,85,80,31,208,0,0,0,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,149,85,85,111,229,85,85,96,0,0,0,47,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,128,0,0,0,0,0,0,191,64,0,0,0,0,0,0,255,0,0,0,0,0,0,2,254,0,0,0,0,0,0,7,253,0,0,0,0,0,0,31,248,0,0,0,0,0,0,127,240,0,0,0,0,0,1,255,208,0,0,0,0,0,31,255,64,0,0,0,0,0,63,253,0,0,0,0,0,0,11,240,0,0,0,0,0,0,1,128,0,0,0,0,0,
  // 0x30c2  ヂ
  194,48,32,31,248,36,2,253,0,0,0,0,0,27,128,0,0,0,0,0,91,255,208,0,1,85,106,191,255,255,240,0,3,255,255,255,255,255,144,96,2,255,255,255,254,64,1,244,1,255,234,111,224,0,240,188,0,0,0,15,224,0,252,62,0,0,0,15,224,0,125,47,0,0,0,15,224,0,63,8,0,0,0,15,224,0,31,0,0,0,0,15,224,0,0,0,85,85,85,95,229,85,85,96,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,0,0,0,31,208,0,0,0,0,0,0,47,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,127,128,0,0,0,0,0,0,255,64,0,0,0,0,0,1,255,0,0,0,0,0,0,3,254,0,0,0,0,0,0,11,252,0,0,0,0,0,0,47,244,0,0,0,0,0,0,191,240,0,0,0,0,0,7,255,192,0,0,0,0,0,47,255,0,0,0,0,0,0,31,248,0,0,0,0,0,0,3,208,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30c3  ッ
  195,48,25,24,168,36,6,253,0,0,27,0,0,0,0,0,0,127,64,0,52,0,30,0,63,128,0,127,128,255,0,47,192,0,191,64,127,64,31,208,0,191,0,63,192,15,240,0,255,0,47,208,11,240,1,254,0,15,224,3,244,2,253,0,15,240,3,128,3,252,0,7,244,0,0,11,244,0,3,208,0,0,15,240,0,0,0,0,0,47,224,0,0,0,0,0,127,192,0,0,0,0,0,255,64,0,0,0,0,3,254,0,0,0,0,0,15,252,0,0,0,0,0,127,240,0,0,0,0,2,255,192,0,0,0,0,31,255,0,0,0,0,0,255,252,0,0,0,0,31,255,224,0,0,0,0,63,255,64,0,0,0,0,15,248,0,0,0,0,0,3,64,0,0,0,0,
  // 0x30c4  ツ
  196,48,30,29,232,36,3,255,0,0,0,96,0,0,0,0,0,0,11,244,0,0,4,0,5,0,7,248,0,0,47,144,191,0,3,252,0,0,47,224,191,128,2,253,0,0,63,208,63,192,0,255,0,0,63,192,47,208,0,191,0,0,127,128,15,240,0,127,128,0,191,64,15,244,0,63,192,0,255,0,7,248,0,47,192,1,254,0,3,252,0,25,0,3,253,0,2,253,0,0,0,3,252,0,1,249,0,0,0,11,248,0,0,64,0,0,0,15,240,0,0,0,0,0,0,63,224,0,0,0,0,0,0,127,192,0,0,0,0,0,0,255,64,0,0,0,0,0,3,255,0,0,0,0,0,0,15,252,0,0,0,0,0,0,63,244,0,0,0,0,0,1,255,208,0,0,0,0,0,11,255,64,0,0,0,0,0,63,253,0,0,0,0,0,2,255,244,0,0,0,0,0,47,255,192,0,0,0,0,7,255,254,0,0,0,0,0,11,255,240,0,0,0,0,0,2,255,64,0,0,0,0,0,0,180,0,0,0,0,0,
  // 0x30c5  ヅ
  197,48,33,33,41,36,2,254,0,0,0,0,0,0,1,244,0,0,0,0,0,0,2,224,252,0,0,0,0,0,0,3,240,126,0,0,0,0,0,0,0,252,63,0,0,0,0,96,0,0,189,31,64,0,0,3,248,0,0,62,4,0,2,0,3,252,0,0,16,0,0,127,128,1,253,0,0,4,0,0,63,192,0,255,0,0,47,208,0,47,208,0,191,0,0,63,208,0,15,240,0,127,128,0,63,192,0,15,244,0,63,192,0,127,192,0,7,248,0,47,208,0,191,128,0,3,252,0,31,208,0,255,0,0,2,253,0,9,0,1,255,0,0,0,255,0,0,0,3,253,0,0,0,253,0,0,0,7,252,0,0,0,64,0,0,0,15,244,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,11,253,0,0,0,0,0,0,0,47,248,0,0,0,0,0,0,0,255,224,0,0,0,0,0,0,7,255,192,0,0,0,0,0,0,47,254,0,0,0,0,0,0,1,255,248,0,0,0,0,0,0,31,255,208,0,0,0,0,0,2,255,255,0,0,0,0,0,0,3,255,244,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,0,52,0,0,0,0,0,0,
  // 0x30c6  テ
  198,48,30,31,248,36,3,253,0,101,85,85,85,85,96,0,0,127,255,255,255,255,240,0,0,127,255,255,255,255,240,0,0,127,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,240,191,255,255,255,255,255,255,240,191,255,255,255,255,255,255,240,85,85,85,95,245,85,85,80,0,0,0,15,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,127,128,0,0,0,0,0,0,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,7,253,0,0,0,0,0,0,31,252,0,0,0,0,0,0,127,240,0,0,0,0,0,2,255,192,0,0,0,0,0,31,255,0,0,0,0,0,0,11,252,0,0,0,0,0,0,1,208,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30c7  デ
  199,48,32,35,24,36,3,253,0,0,0,0,0,0,0,80,0,0,0,0,0,0,2,240,0,0,0,0,0,1,160,252,0,0,0,0,0,2,244,189,0,0,0,0,0,0,252,63,0,255,255,255,255,253,125,31,0,255,255,255,255,253,63,0,0,255,255,255,255,253,25,0,0,85,85,85,85,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,224,255,255,255,255,255,255,255,224,255,255,255,255,255,255,255,224,165,85,85,111,229,85,85,144,0,0,0,47,208,0,0,0,0,0,0,47,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,127,128,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,3,254,0,0,0,0,0,0,11,252,0,0,0,0,0,0,31,248,0,0,0,0,0,0,127,240,0,0,0,0,0,2,255,192,0,0,0,0,0,31,255,0,0,0,0,0,0,47,252,0,0,0,0,0,0,7,224,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30c8  ト
  200,48,20,30,150,36,11,255,21,64,0,0,0,127,192,0,0,0,127,128,0,0,0,127,128,0,0,0,63,128,0,0,0,63,128,0,0,0,63,128,0,0,0,63,128,0,0,0,63,128,0,0,0,63,128,0,0,0,63,224,0,0,0,63,255,128,0,0,63,255,253,0,0,63,255,255,228,0,63,175,255,255,128,63,129,191,255,248,63,128,7,255,254,63,128,0,47,252,63,128,0,2,252,63,128,0,0,36,63,128,0,0,0,63,128,0,0,0,63,128,0,0,0,63,128,0,0,0,63,128,0,0,0,63,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,192,0,0,0,127,192,0,0,0,
  // 0x30c9  ド
  201,48,22,30,180,36,10,254,85,64,0,0,44,0,191,128,0,0,190,0,127,128,0,116,63,0,127,128,0,252,31,192,127,64,0,126,11,208,127,64,0,63,67,208,127,64,0,15,193,0,127,64,0,11,128,0,127,64,0,0,0,0,127,64,0,0,0,0,127,224,0,0,0,0,127,255,128,0,0,0,127,255,253,0,0,0,127,255,255,228,0,0,127,175,255,255,128,0,127,65,191,255,248,0,127,64,7,255,253,0,127,64,0,47,252,0,127,64,0,2,248,0,127,64,0,0,32,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,
  // 0x30ca  ナ
  202,48,31,31,248,36,3,254,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,191,255,255,255,255,255,255,244,191,255,255,255,255,255,255,244,191,255,255,255,255,255,255,244,106,170,170,175,250,170,170,160,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,47,208,0,0,0,0,0,0,63,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,191,128,0,0,0,0,0,0,255,0,0,0,0,0,0,3,255,0,0,0,0,0,0,11,252,0,0,0,0,0,0,47,248,0,0,0,0,0,0,191,240,0,0,0,0,0,3,255,192,0,0,0,0,0,47,255,0,0,0,0,0,0,127,252,0,0,0,0,0,0,15,224,0,0,0,0,0,0,2,64,0,0,0,0,0,
  // 0x30cb  ニ
  203,48,29,23,184,36,3,1,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,2,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,
  // 0x30cc  ヌ
  204,48,25,30,210,36,5,253,0,0,0,0,0,20,0,47,255,255,255,255,253,0,47,255,255,255,255,255,128,47,255,255,255,255,255,64,26,170,170,170,170,255,0,0,0,0,0,2,254,0,0,0,0,0,3,253,0,0,0,0,0,3,252,0,0,0,0,0,11,248,0,0,56,0,0,15,240,0,0,255,64,0,31,224,0,2,255,240,0,63,208,0,0,127,254,0,191,192,0,0,11,255,192,255,64,0,0,1,255,251,254,0,0,0,0,47,255,252,0,0,0,0,7,255,244,0,0,0,0,0,255,248,0,0,0,0,1,255,255,0,0,0,0,7,255,255,208,0,0,0,47,253,255,244,0,0,0,255,244,47,254,0,0,7,255,208,7,255,128,0,127,255,0,1,255,64,7,255,248,0,0,126,0,191,255,208,0,0,8,0,255,254,0,0,0,0,0,63,224,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30cd  ネ
  205,48,31,32,0,36,3,254,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,5,85,85,127,213,86,128,0,15,255,255,255,255,255,240,0,15,255,255,255,255,255,252,0,15,255,255,255,255,255,244,0,0,0,0,0,0,191,208,0,0,0,0,0,1,255,128,0,0,0,0,0,7,254,0,0,0,0,0,0,31,248,0,0,0,0,0,0,191,240,0,0,0,0,0,3,255,128,0,0,0,0,0,31,254,0,0,0,0,0,0,191,244,0,0,0,0,0,11,255,208,29,0,0,0,0,191,255,192,127,192,0,0,27,255,255,192,255,248,0,6,255,255,191,192,47,255,64,255,255,248,47,192,7,255,224,255,255,64,47,192,0,191,248,127,228,0,47,192,0,31,240,41,0,0,47,192,0,2,192,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,
  // 0x30ce  ノ
  206,48,24,28,168,36,5,255,0,0,0,0,0,249,0,0,0,0,1,255,0,0,0,0,2,255,0,0,0,0,3,253,0,0,0,0,7,252,0,0,0,0,11,248,0,0,0,0,15,244,0,0,0,0,31,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,255,128,0,0,0,1,255,0,0,0,0,3,254,0,0,0,0,11,252,0,0,0,0,31,244,0,0,0,0,63,240,0,0,0,0,255,192,0,0,0,3,255,64,0,0,0,15,254,0,0,0,0,127,248,0,0,0,2,255,224,0,0,0,15,255,128,0,0,0,191,254,0,0,0,11,255,244,0,0,0,191,255,192,0,0,0,191,253,0,0,0,0,47,224,0,0,0,0,10,0,0,0,0,0,
  // 0x30cf  ハ
  207,48,32,26,208,36,2,0,0,0,20,0,0,116,0,0,0,0,63,208,7,252,0,0,0,0,63,192,3,253,0,0,0,0,63,192,1,255,0,0,0,0,127,128,0,255,64,0,0,0,191,64,0,127,192,0,0,0,255,0,0,63,192,0,0,0,255,0,0,47,224,0,0,1,254,0,0,15,240,0,0,2,253,0,0,11,248,0,0,3,252,0,0,7,252,0,0,3,252,0,0,3,253,0,0,11,248,0,0,2,255,0,0,15,240,0,0,0,255,0,0,31,240,0,0,0,255,128,0,63,208,0,0,0,127,192,0,127,192,0,0,0,63,192,0,255,128,0,0,0,63,224,1,255,0,0,0,0,31,240,3,254,0,0,0,0,15,244,11,252,0,0,0,0,15,248,15,248,0,0,0,0,11,252,63,240,0,0,0,0,7,252,127,208,0,0,0,0,3,254,27,192,0,0,0,0,2,228,0,0,0,0,0,0,0,0,
  // 0x30d0  バ
  208,48,33,30,14,36,2,0,0,0,0,0,0,0,0,244,0,0,0,0,0,0,0,96,252,0,0,0,0,0,0,1,248,62,0,0,0,0,0,0,0,189,47,64,0,0,0,0,0,16,63,15,64,0,0,57,64,6,240,47,68,0,0,0,127,192,11,248,14,0,0,0,0,127,128,3,252,0,0,0,0,0,191,64,2,254,0,0,0,0,0,255,0,0,255,0,0,0,0,0,255,0,0,191,128,0,0,0,1,254,0,0,63,192,0,0,0,2,253,0,0,63,208,0,0,0,3,252,0,0,31,240,0,0,0,3,252,0,0,15,244,0,0,0,7,248,0,0,11,248,0,0,0,15,244,0,0,3,252,0,0,0,15,240,0,0,3,253,0,0,0,47,224,0,0,1,255,0,0,0,63,192,0,0,0,255,0,0,0,127,192,0,0,0,191,128,0,0,255,64,0,0,0,127,192,0,1,255,0,0,0,0,63,208,0,3,253,0,0,0,0,47,224,0,11,252,0,0,0,0,31,240,0,31,244,0,0,0,0,15,244,0,63,240,0,0,0,0,15,248,0,191,208,0,0,0,0,11,252,0,191,128,0,0,0,0,7,252,0,7,0,0,0,0,0,3,64,0,
  // 0x30d1  パ
  209,48,33,31,23,36,2,255,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,31,255,0,0,0,0,0,0,0,61,15,64,0,0,0,0,0,0,120,3,192,0,0,0,0,0,16,120,3,192,0,0,62,64,7,240,61,11,128,0,0,127,192,11,248,31,255,0,0,0,127,128,3,252,7,248,0,0,0,191,64,2,254,0,0,0,0,0,255,0,0,255,0,0,0,0,0,255,0,0,191,128,0,0,0,1,254,0,0,63,192,0,0,0,2,253,0,0,63,208,0,0,0,3,252,0,0,31,240,0,0,0,3,252,0,0,15,244,0,0,0,7,248,0,0,11,248,0,0,0,15,244,0,0,3,252,0,0,0,15,240,0,0,3,253,0,0,0,47,224,0,0,1,255,0,0,0,63,208,0,0,0,255,0,0,0,127,192,0,0,0,255,64,0,0,255,128,0,0,0,127,192,0,1,255,0,0,0,0,63,192,0,3,254,0,0,0,0,63,208,0,7,252,0,0,0,0,47,240,0,15,248,0,0,0,0,31,240,0,47,240,0,0,0,0,15,244,0,127,224,0,0,0,0,11,248,0,255,192,0,0,0,0,7,252,0,47,64,0,0,0,0,3,228,0,1,0,0,0,0,0,1,0,0,
  // 0x30d2  ヒ
  210,48,23,30,180,36,8,255,170,0,0,0,0,0,255,0,0,0,0,0,254,0,0,0,0,0,254,0,0,0,0,0,254,0,0,0,0,0,254,0,0,0,0,64,254,0,0,0,11,192,254,0,0,0,191,224,254,0,0,31,255,240,254,0,6,255,255,208,254,1,255,255,248,0,255,191,255,255,64,0,255,255,255,208,0,0,255,255,244,0,0,0,255,249,0,0,0,0,255,64,0,0,0,0,254,0,0,0,0,0,254,0,0,0,0,0,254,0,0,0,0,0,254,0,0,0,0,0,254,0,0,0,0,0,254,0,0,0,0,0,254,0,0,0,0,0,254,0,0,0,0,0,255,0,0,0,0,0,255,208,0,0,86,188,191,255,255,255,255,252,63,255,255,255,255,252,11,255,255,255,255,252,0,90,170,170,149,0,
  // 0x30d3  ビ
  211,48,27,32,224,36,6,255,0,0,0,0,0,1,128,0,0,0,0,0,11,208,0,0,0,0,11,195,240,191,64,0,0,7,209,248,191,64,0,0,3,240,252,191,64,0,0,1,248,120,191,64,0,0,0,188,0,127,0,0,0,0,16,0,127,0,0,0,1,192,0,127,0,0,0,31,224,0,127,0,0,1,255,240,0,127,0,0,111,255,244,0,127,0,27,255,255,128,0,127,75,255,255,244,0,0,127,255,255,254,0,0,0,127,255,255,128,0,0,0,127,255,208,0,0,0,0,127,228,0,0,0,0,0,127,0,0,0,0,0,0,127,0,0,0,0,0,0,127,0,0,0,0,0,0,127,0,0,0,0,0,0,127,0,0,0,0,0,0,127,0,0,0,0,0,0,127,0,0,0,0,0,0,127,64,0,0,0,0,0,127,64,0,0,0,0,0,127,208,0,0,0,89,0,63,255,170,171,255,254,0,47,255,255,255,255,254,0,11,255,255,255,255,254,0,0,111,255,255,254,164,0,
  // 0x30d4  ピ
  212,48,28,31,217,36,6,255,0,0,0,0,0,11,224,0,0,0,0,0,127,252,191,64,0,0,0,244,46,191,64,0,0,1,224,15,191,64,0,0,1,224,15,191,64,0,0,0,244,46,127,0,0,0,0,127,252,127,0,0,0,2,219,224,127,0,0,0,47,224,0,127,0,0,6,255,240,0,127,0,0,191,255,240,0,127,0,111,255,254,64,0,127,95,255,255,224,0,0,127,255,255,249,0,0,0,127,255,254,64,0,0,0,127,255,144,0,0,0,0,127,208,0,0,0,0,0,127,0,0,0,0,0,0,127,0,0,0,0,0,0,127,0,0,0,0,0,0,127,0,0,0,0,0,0,127,0,0,0,0,0,0,127,0,0,0,0,0,0,127,0,0,0,0,0,0,127,64,0,0,0,0,0,127,64,0,0,0,0,0,127,208,0,0,0,90,0,63,255,170,171,255,254,0,47,255,255,255,255,254,0,11,255,255,255,255,254,0,0,111,255,255,254,164,0,
  // 0x30d5  フ
  213,48,26,28,196,36,5,254,255,255,255,255,255,255,128,255,255,255,255,255,255,240,255,255,255,255,255,255,240,170,170,170,170,170,191,240,0,0,0,0,0,47,224,0,0,0,0,0,63,208,0,0,0,0,0,63,192,0,0,0,0,0,127,192,0,0,0,0,0,191,64,0,0,0,0,0,255,0,0,0,0,0,1,255,0,0,0,0,0,3,253,0,0,0,0,0,7,252,0,0,0,0,0,15,248,0,0,0,0,0,47,240,0,0,0,0,0,127,208,0,0,0,0,1,255,192,0,0,0,0,7,255,0,0,0,0,0,31,253,0,0,0,0,0,191,244,0,0,0,0,7,255,208,0,0,0,0,63,255,64,0,0,0,6,255,252,0,0,0,1,191,255,224,0,0,0,1,255,255,64,0,0,0,0,127,244,0,0,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30d6  ブ
  214,48,31,34,16,36,4,254,0,0,0,0,0,0,2,64,0,0,0,0,0,9,15,192,0,0,0,0,0,63,11,208,0,0,0,0,0,31,131,240,0,0,0,0,0,15,193,248,0,0,0,0,0,3,240,244,186,170,170,170,170,171,208,0,255,255,255,255,255,255,240,0,255,255,255,255,255,255,248,0,255,255,255,255,255,255,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,224,0,0,0,0,0,0,47,208,0,0,0,0,0,0,63,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,191,128,0,0,0,0,0,0,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,3,253,0,0,0,0,0,0,7,252,0,0,0,0,0,0,15,248,0,0,0,0,0,0,63,240,0,0,0,0,0,0,191,208,0,0,0,0,0,2,255,128,0,0,0,0,0,11,255,0,0,0,0,0,0,63,252,0,0,0,0,0,1,255,240,0,0,0,0,0,11,255,192,0,0,0,0,0,191,255,0,0,0,0,0,31,255,248,0,0,0,0,1,255,255,208,0,0,0,0,0,191,253,0,0,0,0,0,0,47,208,0,0,0,0,0,0,8,0,0,0,0,0,0,
  // 0x30d7  プ
  215,48,32,33,8,36,4,254,0,0,0,0,0,0,47,128,0,0,0,0,0,0,255,244,0,0,0,0,0,2,240,124,0,0,0,0,0,3,192,60,0,0,0,0,0,3,192,45,186,170,170,170,170,171,192,60,191,255,255,255,255,255,240,188,191,255,255,255,255,255,255,244,191,255,255,255,255,255,255,128,0,0,0,0,0,15,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,47,224,0,0,0,0,0,0,63,208,0,0,0,0,0,0,127,192,0,0,0,0,0,0,191,128,0,0,0,0,0,0,255,64,0,0,0,0,0,1,255,0,0,0,0,0,0,3,254,0,0,0,0,0,0,7,252,0,0,0,0,0,0,15,248,0,0,0,0,0,0,47,240,0,0,0,0,0,0,191,208,0,0,0,0,0,2,255,192,0,0,0,0,0,11,255,0,0,0,0,0,0,47,252,0,0,0,0,0,0,255,240,0,0,0,0,0,11,255,192,0,0,0,0,0,191,255,0,0,0,0,0,31,255,248,0,0,0,0,1,255,255,208,0,0,0,0,0,191,253,0,0,0,0,0,0,47,208,0,0,0,0,0,0,8,0,0,0,0,0,0,
  // 0x30d8  ヘ
  216,48,32,23,184,36,2,1,0,0,2,248,0,0,0,0,0,0,11,255,0,0,0,0,0,0,47,255,192,0,0,0,0,0,191,255,240,0,0,0,0,1,255,175,252,0,0,0,0,3,254,7,255,0,0,0,0,15,252,1,255,192,0,0,0,63,240,0,127,240,0,0,0,191,208,0,47,248,0,0,1,255,128,0,11,254,0,0,7,255,0,0,3,255,128,0,31,252,0,0,0,255,208,0,127,244,0,0,0,63,244,0,191,224,0,0,0,15,253,0,63,192,0,0,0,7,255,0,15,0,0,0,0,2,255,192,1,0,0,0,0,0,191,240,0,0,0,0,0,0,63,252,0,0,0,0,0,0,15,254,0,0,0,0,0,0,7,255,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,180,0,0,0,0,0,0,0,16,
  // 0x30d9  ベ
  217,48,32,27,216,36,2,0,0,0,0,0,0,0,7,64,0,0,0,0,0,0,31,192,0,0,0,0,0,30,15,224,0,0,0,0,0,63,3,240,0,0,2,244,0,31,130,248,0,0,15,254,0,15,208,252,0,0,63,255,128,7,240,96,0,0,255,255,224,3,244,0,0,2,255,191,248,1,128,0,0,7,253,11,254,0,0,0,0,31,244,2,255,128,0,0,0,63,224,0,191,224,0,0,0,255,192,0,47,244,0,0,3,255,0,0,15,253,0,0,11,253,0,0,3,255,64,0,47,248,0,0,0,255,208,0,191,240,0,0,0,127,240,0,255,192,0,0,0,31,252,0,63,64,0,0,0,11,255,0,15,0,0,0,0,2,255,192,0,0,0,0,0,0,255,240,0,0,0,0,0,0,63,248,0,0,0,0,0,0,31,254,0,0,0,0,0,0,7,254,0,0,0,0,0,0,2,248,0,0,0,0,0,0,0,240,0,0,0,0,0,0,0,0,
  // 0x30da  ペ
  218,48,32,27,216,36,2,0,0,0,0,0,0,0,190,0,0,0,0,0,0,3,255,208,0,0,0,0,0,15,130,240,0,0,0,0,0,15,0,180,0,0,2,244,0,30,0,120,0,0,15,254,0,15,0,180,0,0,63,255,128,15,129,240,0,0,255,255,224,3,255,208,0,2,255,191,248,0,190,64,0,7,253,11,254,0,0,0,0,31,244,2,255,128,0,0,0,63,224,0,191,224,0,0,0,255,192,0,47,244,0,0,3,255,0,0,15,253,0,0,11,253,0,0,3,255,64,0,63,248,0,0,0,255,208,0,255,240,0,0,0,127,240,0,191,192,0,0,0,31,252,0,63,64,0,0,0,11,255,0,14,0,0,0,0,2,255,192,0,0,0,0,0,0,255,240,0,0,0,0,0,0,63,248,0,0,0,0,0,0,31,254,0,0,0,0,0,0,7,254,0,0,0,0,0,0,2,248,0,0,0,0,0,0,0,240,0,0,0,0,0,0,0,0,
  // 0x30db  ホ
  219,48,31,32,0,36,3,254,0,0,0,5,64,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,63,255,255,255,255,255,255,224,63,255,255,255,255,255,255,224,63,255,255,255,255,255,255,224,41,85,85,111,229,85,85,144,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,0,0,31,208,0,0,0,0,4,0,31,208,0,64,0,0,31,64,31,208,7,208,0,0,63,192,31,208,15,240,0,0,127,128,31,208,7,252,0,0,255,0,31,208,3,253,0,2,254,0,31,208,0,255,0,7,252,0,31,208,0,191,128,15,244,0,31,208,0,63,208,63,224,0,31,208,0,31,240,255,192,0,31,208,0,15,244,255,0,0,31,208,0,7,244,45,0,0,31,208,0,3,128,0,0,0,31,208,0,0,0,0,0,64,47,208,0,0,0,0,0,191,255,208,0,0,0,0,0,191,255,192,0,0,0,0,0,191,255,128,0,0,0,0,0,21,84,0,0,0,0,
  // 0x30dc  ボ
  220,48,32,33,8,36,2,254,0,0,0,0,0,0,0,16,0,0,0,0,0,0,1,244,0,0,0,15,224,2,240,252,0,0,0,15,240,1,244,126,0,0,0,15,240,0,252,47,0,0,0,15,240,0,126,15,0,0,0,15,224,0,62,0,0,0,0,15,224,0,0,0,26,85,85,95,245,85,85,160,63,255,255,255,255,255,255,240,63,255,255,255,255,255,255,240,63,255,255,255,255,255,255,240,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,10,0,15,224,0,144,0,0,15,208,15,224,11,240,0,0,47,208,15,224,7,252,0,0,127,192,15,224,3,254,0,0,255,64,15,224,0,255,0,2,254,0,15,224,0,127,192,7,252,0,15,224,0,63,208,15,244,0,15,224,0,31,240,63,224,0,15,224,0,15,248,255,192,0,15,224,0,3,252,127,0,0,15,224,0,2,244,9,0,0,15,224,0,0,128,0,0,0,15,224,0,0,0,0,0,105,111,224,0,0,0,0,0,127,255,224,0,0,0,0,0,63,255,208,0,0,0,0,0,63,255,64,0,0,0,
  // 0x30dd  ポ
  221,48,32,34,16,36,2,254,0,0,0,0,0,0,11,144,0,0,0,0,0,0,127,248,0,0,0,0,0,0,244,124,0,0,0,15,240,0,224,30,0,0,0,15,240,1,224,30,0,0,0,15,240,0,224,30,0,0,0,15,224,0,244,124,0,0,0,15,224,0,127,248,0,0,0,15,224,0,11,144,26,85,85,95,245,85,85,160,63,255,255,255,255,255,255,240,63,255,255,255,255,255,255,240,63,255,255,255,255,255,255,240,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,10,0,15,224,0,144,0,0,15,208,15,224,11,240,0,0,47,208,15,224,7,252,0,0,127,192,15,224,3,254,0,0,255,64,15,224,0,255,0,2,254,0,15,224,0,127,192,7,252,0,15,224,0,63,208,15,244,0,15,224,0,31,240,63,224,0,15,224,0,15,248,255,192,0,15,224,0,3,252,127,0,0,15,224,0,2,244,9,0,0,15,224,0,0,128,0,0,0,15,224,0,0,0,0,0,105,111,224,0,0,0,0,0,127,255,224,0,0,0,0,0,63,255,208,0,0,0,0,0,63,255,64,0,0,0,
  // 0x30de  マ
  222,48,31,29,232,36,3,253,106,170,170,170,170,170,170,64,191,255,255,255,255,255,255,224,191,255,255,255,255,255,255,248,191,255,255,255,255,255,255,240,0,0,0,0,0,0,191,208,0,0,0,0,0,1,255,128,0,0,0,0,0,3,255,0,0,0,0,0,0,11,253,0,0,0,0,0,0,31,248,0,0,0,0,0,0,63,240,0,0,0,0,0,0,255,192,0,0,7,192,0,3,255,0,0,0,47,244,0,15,253,0,0,0,31,253,0,63,244,0,0,0,7,255,128,255,224,0,0,0,0,255,231,255,128,0,0,0,0,63,255,253,0,0,0,0,0,15,255,244,0,0,0,0,0,2,255,208,0,0,0,0,0,0,191,240,0,0,0,0,0,0,47,248,0,0,0,0,0,0,15,254,0,0,0,0,0,0,3,255,128,0,0,0,0,0,0,255,208,0,0,0,0,0,0,63,244,0,0,0,0,0,0,31,248,0,0,0,0,0,0,11,208,0,0,0,0,0,0,2,64,0,0,0,0,0,0,0,0,0,0,
  // 0x30df  ミ
  223,48,25,29,203,36,5,255,0,62,80,0,0,0,0,0,127,255,164,0,0,0,0,191,255,255,228,0,0,0,111,255,255,255,228,0,0,0,27,255,255,255,64,0,0,0,6,255,255,0,0,0,0,0,6,254,0,0,0,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,254,80,0,0,0,0,3,255,255,144,0,0,0,7,255,255,255,144,0,0,0,111,255,255,255,128,0,0,0,27,255,255,240,0,0,0,0,27,255,208,0,0,0,0,0,27,192,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,144,0,0,0,0,0,63,255,144,0,0,0,0,127,255,255,228,0,0,0,111,255,255,255,144,0,0,0,91,255,255,255,144,0,0,0,27,255,255,253,0,0,0,0,27,255,252,0,0,0,0,0,27,248,0,0,0,0,0,0,96,0,
  // 0x30e0  ム
  224,48,32,31,248,36,2,254,0,0,0,16,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,191,192,0,0,0,0,0,0,255,128,0,0,0,0,0,0,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,2,254,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,7,248,0,0,0,0,0,0,15,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,31,224,0,0,0,0,0,0,47,208,0,0,0,0,0,0,63,192,0,11,64,0,0,0,127,128,0,127,192,0,0,0,191,64,0,47,224,0,0,0,255,0,0,15,240,0,0,1,254,0,0,11,248,0,0,2,253,0,0,3,253,0,0,3,252,0,0,2,255,0,0,7,248,0,0,0,255,64,0,11,244,0,0,0,191,192,0,15,240,1,106,255,255,208,0,111,255,255,255,255,255,240,127,255,255,255,255,255,255,244,127,255,255,255,255,250,91,252,63,255,255,169,64,0,3,253,62,149,0,0,0,0,3,254,0,0,0,0,0,0,1,248,0,0,0,0,0,0,0,64,
  // 0x30e1  メ
  225,48,28,29,203,36,4,255,0,0,0,0,0,45,0,0,0,0,0,0,63,208,0,0,0,0,0,63,192,0,0,0,0,0,191,128,0,0,0,0,0,255,0,0,8,0,0,1,255,0,0,63,64,0,3,253,0,0,191,224,0,3,252,0,0,127,253,0,15,244,0,0,15,255,128,31,240,0,0,1,255,240,63,208,0,0,0,63,253,127,192,0,0,0,11,255,255,64,0,0,0,1,255,254,0,0,0,0,0,63,253,0,0,0,0,0,31,255,64,0,0,0,0,127,255,224,0,0,0,1,255,255,248,0,0,0,7,255,31,255,0,0,0,31,252,3,255,192,0,0,127,240,0,255,240,0,2,255,192,0,63,252,0,15,255,0,0,15,254,0,127,252,0,0,3,252,7,255,224,0,0,0,240,47,255,64,0,0,0,16,191,253,0,0,0,0,0,47,208,0,0,0,0,0,10,0,0,0,0,0,0,
  // 0x30e2  モ
  226,48,29,28,224,36,4,255,5,85,85,85,85,85,80,0,11,255,255,255,255,255,240,0,11,255,255,255,255,255,240,0,11,255,255,255,255,255,240,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,165,85,95,245,85,85,85,64,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,11,252,0,0,0,0,0,0,11,255,234,175,254,0,0,0,3,255,255,255,254,0,0,0,1,255,255,255,254,0,0,0,0,27,255,255,249,0,
  // 0x30e3  ャ
  227,48,26,26,182,36,5,253,0,1,128,0,0,0,0,0,47,208,0,0,0,0,0,15,224,0,0,0,0,0,15,240,0,0,0,0,0,11,240,0,0,107,192,0,3,244,1,175,255,240,0,3,254,255,255,255,224,0,91,255,255,255,255,192,191,255,255,255,144,63,128,191,255,255,64,0,255,0,127,249,255,0,2,253,0,37,0,191,0,7,248,0,0,0,127,64,31,240,0,0,0,63,128,127,192,0,0,0,63,192,255,0,0,0,0,47,192,45,0,0,0,0,31,208,0,0,0,0,0,15,224,0,0,0,0,0,11,240,0,0,0,0,0,7,244,0,0,0,0,0,3,248,0,0,0,0,0,3,252,0,0,0,0,0,2,252,0,0,0,0,0,1,254,0,0,0,0,0,0,255,0,0,0,0,0,0,228,0,0,0,
  // 0x30e4  ヤ
  228,48,31,31,248,36,2,254,0,1,184,0,0,0,0,0,0,7,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,2,253,0,0,0,0,0,0,1,254,0,0,0,1,128,0,0,255,0,0,1,191,244,0,0,255,0,22,255,255,252,0,0,191,171,255,255,255,248,0,1,191,255,255,255,239,240,90,255,255,255,255,144,47,208,255,255,255,254,64,0,127,192,191,255,255,208,0,0,255,0,63,228,15,240,0,3,253,0,36,0,15,240,0,15,248,0,0,0,11,244,0,47,240,0,0,0,7,248,0,191,192,0,0,0,3,252,2,255,64,0,0,0,3,252,2,253,0,0,0,0,2,253,0,40,0,0,0,0,1,254,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,191,128,0,0,0,0,0,0,127,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,47,208,0,0,0,0,0,0,31,224,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,244,0,0,0,0,0,0,11,248,0,0,0,0,0,0,6,64,0,0,0,
  // 0x30e5  ュ
  229,48,26,20,140,36,5,255,1,165,85,85,90,0,0,1,255,255,255,255,208,0,1,255,255,255,255,224,0,1,255,255,255,255,208,0,0,0,0,0,47,208,0,0,0,0,0,47,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,128,0,0,0,0,0,127,64,0,0,0,0,0,127,64,0,0,0,0,0,191,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,105,85,85,85,255,85,160,255,255,255,255,255,255,240,255,255,255,255,255,255,240,255,255,255,255,255,255,240,0,0,0,0,0,0,0,
  // 0x30e6  ユ
  230,48,32,25,200,36,2,1,0,0,0,0,0,1,0,0,0,127,255,255,255,255,208,0,0,127,255,255,255,255,244,0,0,127,255,255,255,255,240,0,0,42,170,170,170,175,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,224,0,0,0,0,0,0,47,224,0,0,0,0,0,0,47,208,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,128,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,127,170,170,170,171,255,170,253,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,0,0,0,0,0,0,0,0,
  // 0x30e7  ョ
  231,48,21,24,144,36,7,253,20,0,0,0,0,64,63,255,255,255,255,192,63,255,255,255,255,192,63,255,255,255,255,192,0,0,0,0,31,192,0,0,0,0,31,192,0,0,0,0,31,192,0,0,0,0,31,192,0,0,0,0,31,192,5,0,0,0,47,192,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,0,0,31,192,0,0,0,0,31,192,0,0,0,0,31,192,0,0,0,0,31,192,0,0,0,0,31,192,21,85,85,85,111,192,191,255,255,255,255,192,191,255,255,255,255,192,191,255,255,255,255,192,0,0,0,0,31,192,0,0,0,0,5,64,
  // 0x30e8  ヨ
  232,48,25,28,196,36,5,254,63,255,255,255,255,255,192,63,255,255,255,255,255,192,63,255,255,255,255,255,192,37,85,85,85,85,127,192,0,0,0,0,0,47,192,0,0,0,0,0,47,192,0,0,0,0,0,47,192,0,0,0,0,0,47,192,0,0,0,0,0,47,192,0,0,0,0,0,47,192,9,85,85,85,85,127,192,15,255,255,255,255,255,192,15,255,255,255,255,255,192,15,255,255,255,255,255,192,0,0,0,0,0,47,192,0,0,0,0,0,47,192,0,0,0,0,0,47,192,0,0,0,0,0,47,192,0,0,0,0,0,47,192,0,0,0,0,0,47,192,0,0,0,0,0,47,192,0,0,0,0,0,47,192,191,255,255,255,255,255,192,191,255,255,255,255,255,192,191,255,255,255,255,255,192,106,170,170,170,170,191,192,0,0,0,0,0,47,192,0,0,0,0,0,5,64,
  // 0x30e9  ラ
  233,48,27,30,210,36,5,254,1,85,85,85,85,86,0,3,255,255,255,255,255,0,3,255,255,255,255,255,0,3,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,224,255,255,255,255,255,255,252,255,255,255,255,255,255,244,85,85,85,85,85,95,240,0,0,0,0,0,31,240,0,0,0,0,0,47,208,0,0,0,0,0,63,192,0,0,0,0,0,191,128,0,0,0,0,0,255,0,0,0,0,0,3,254,0,0,0,0,0,11,252,0,0,0,0,0,47,240,0,0,0,0,0,255,208,0,0,0,0,7,255,128,0,0,0,0,47,254,0,0,0,0,2,255,248,0,0,0,0,111,255,208,0,0,0,15,255,254,0,0,0,0,11,255,244,0,0,0,0,3,254,64,0,0,0,0,0,144,0,0,0,0,
  // 0x30ea  リ
  234,48,22,30,180,36,7,254,106,64,0,0,63,208,127,128,0,0,63,208,127,128,0,0,47,192,127,128,0,0,47,192,127,128,0,0,47,192,127,128,0,0,47,192,127,128,0,0,47,192,127,128,0,0,47,192,127,128,0,0,47,192,127,128,0,0,47,192,127,128,0,0,47,192,127,128,0,0,47,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,128,127,128,0,0,191,128,0,0,0,0,255,64,0,0,0,1,255,0,0,0,0,3,254,0,0,0,0,11,252,0,0,0,0,47,244,0,0,0,0,255,224,0,0,0,11,255,128,0,0,1,191,254,0,0,0,15,255,244,0,0,0,3,255,128,0,0,0,0,248,0,0,0,0,0,0,0,0,0,
  // 0x30eb  ル
  235,48,33,29,5,36,2,255,0,1,84,0,21,64,0,0,0,0,3,252,0,127,128,0,0,0,0,3,252,0,127,128,0,0,0,0,3,252,0,63,128,0,0,0,0,3,252,0,63,128,0,0,0,0,3,252,0,63,128,0,0,0,0,3,252,0,63,128,0,0,0,0,3,252,0,63,128,0,0,0,0,3,252,0,63,128,0,0,0,0,3,252,0,63,128,0,0,0,0,3,252,0,63,128,0,0,0,0,3,248,0,63,128,0,0,0,0,3,248,0,63,128,0,0,0,0,3,248,0,63,128,0,0,0,0,3,244,0,63,128,0,0,0,0,7,244,0,63,128,0,8,0,0,7,240,0,63,128,0,61,0,0,11,240,0,63,128,0,191,0,0,15,240,0,63,128,2,255,64,0,31,224,0,63,128,11,253,0,0,63,192,0,63,128,63,244,0,0,127,192,0,63,129,255,224,0,0,255,64,0,63,139,255,64,0,3,255,0,0,63,255,253,0,0,11,253,0,0,63,255,240,0,0,47,248,0,0,127,255,128,0,0,191,240,0,0,127,252,0,0,0,47,192,0,0,63,208,0,0,0,7,0,0,0,10,0,0,0,0,
  // 0x30ec  レ
  236,48,26,28,196,36,7,255,127,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,1,0,63,192,0,0,0,7,192,63,192,0,0,0,31,208,63,192,0,0,0,127,224,63,192,0,0,1,255,192,63,192,0,0,11,255,0,63,192,0,0,127,252,0,63,192,0,2,255,224,0,63,192,0,31,255,64,0,63,192,1,255,252,0,0,63,192,31,255,224,0,0,63,198,255,255,0,0,0,63,255,255,244,0,0,0,63,255,255,64,0,0,0,127,255,224,0,0,0,0,47,249,0,0,0,0,0,7,64,0,0,0,0,0,
  // 0x30ed  ロ
  237,48,26,27,189,36,5,255,170,170,170,170,170,170,160,255,255,255,255,255,255,240,255,255,255,255,255,255,240,255,255,255,255,255,255,240,254,0,0,0,0,11,240,254,0,0,0,0,11,240,254,0,0,0,0,11,240,254,0,0,0,0,11,240,254,0,0,0,0,11,240,254,0,0,0,0,11,240,254,0,0,0,0,11,240,254,0,0,0,0,11,240,254,0,0,0,0,11,240,254,0,0,0,0,11,240,254,0,0,0,0,11,240,254,0,0,0,0,11,240,254,0,0,0,0,11,240,254,0,0,0,0,11,240,254,0,0,0,0,11,240,254,0,0,0,0,11,240,254,0,0,0,0,11,240,255,255,255,255,255,255,240,255,255,255,255,255,255,240,255,255,255,255,255,255,240,255,170,170,170,170,175,240,255,0,0,0,0,11,240,169,0,0,0,0,6,160,
  // 0x30ee  ヮ
  238,48,24,24,144,36,6,252,127,255,255,255,255,248,127,255,255,255,255,255,127,255,255,255,255,255,127,149,85,85,86,254,127,64,0,0,2,253,127,64,0,0,2,252,127,64,0,0,3,252,127,64,0,0,3,252,127,64,0,0,7,248,127,64,0,0,11,244,127,64,0,0,15,240,0,0,0,0,47,224,0,0,0,0,63,192,0,0,0,0,255,128,0,0,0,2,255,0,0,0,0,11,253,0,0,0,0,47,248,0,0,0,1,255,224,0,0,0,11,255,128,0,0,1,191,253,0,0,0,15,255,244,0,0,0,7,255,128,0,0,0,1,248,0,0,0,0,0,0,0,0,0,
  // 0x30ef  ワ
  239,48,28,28,196,36,4,254,191,255,255,255,255,255,244,127,255,255,255,255,255,254,127,255,255,255,255,255,254,127,170,170,170,170,171,253,127,64,0,0,0,3,252,127,64,0,0,0,3,252,127,64,0,0,0,3,252,127,64,0,0,0,7,248,127,64,0,0,0,11,244,127,64,0,0,0,15,244,127,64,0,0,0,15,240,127,64,0,0,0,31,224,191,128,0,0,0,63,208,0,0,0,0,0,127,192,0,0,0,0,0,255,128,0,0,0,0,1,255,0,0,0,0,0,3,254,0,0,0,0,0,15,252,0,0,0,0,0,63,244,0,0,0,0,0,255,224,0,0,0,0,7,255,192,0,0,0,0,47,254,0,0,0,0,2,255,248,0,0,0,0,111,255,208,0,0,0,3,255,255,0,0,0,0,1,255,244,0,0,0,0,0,191,64,0,0,0,0,0,20,0,0,0,0,
  // 0x30f0  ヰ
  240,48,30,31,248,36,3,254,0,0,0,0,2,164,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,47,255,255,255,255,255,255,208,47,255,255,255,255,255,255,208,47,255,255,255,255,255,255,208,21,86,253,85,87,249,85,64,0,2,252,0,3,248,0,0,0,2,252,0,3,248,0,0,0,2,252,0,3,248,0,0,0,2,252,0,3,248,0,0,0,2,252,0,3,248,0,0,0,2,252,0,3,248,0,0,0,2,252,0,3,248,0,0,0,2,252,0,3,248,0,0,0,2,252,0,3,248,0,0,169,87,253,85,91,253,85,160,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,2,164,0,0,
  // 0x30f1  ヱ
  241,48,31,26,208,36,3,0,10,170,170,170,170,170,171,0,15,255,255,255,255,255,255,208,15,255,255,255,255,255,255,224,15,255,255,255,255,255,255,192,0,0,0,0,0,0,255,64,0,0,0,0,0,2,254,0,0,0,0,0,0,7,252,0,0,0,0,191,64,15,244,0,0,0,0,191,64,63,224,0,0,0,0,191,64,255,192,0,0,0,0,191,67,255,0,0,0,0,0,191,65,252,0,0,0,0,0,191,64,32,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,254,170,170,255,234,170,171,244,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,244,0,0,0,0,0,0,0,0,
  // 0x30f2  ヲ
  242,48,27,29,203,36,5,254,106,85,85,85,85,90,128,127,255,255,255,255,255,244,127,255,255,255,255,255,252,127,255,255,255,255,255,248,0,0,0,0,0,15,244,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,31,224,0,0,0,0,0,47,208,0,0,0,0,0,63,192,31,255,255,255,255,255,192,31,255,255,255,255,255,128,31,255,255,255,255,255,0,5,85,85,85,86,255,0,0,0,0,0,2,254,0,0,0,0,0,3,252,0,0,0,0,0,15,248,0,0,0,0,0,47,240,0,0,0,0,0,191,192,0,0,0,0,1,255,64,0,0,0,0,11,254,0,0,0,0,0,63,252,0,0,0,0,1,255,224,0,0,0,0,31,255,128,0,0,0,2,255,253,0,0,0,0,127,255,224,0,0,0,0,63,255,64,0,0,0,0,15,244,0,0,0,0,0,6,64,0,0,0,0,
  // 0x30f3  ン
  243,48,29,28,224,36,5,255,3,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,63,248,0,0,0,0,0,0,31,255,0,0,0,0,0,0,3,255,208,0,0,0,0,0,0,191,244,0,0,0,0,0,0,47,253,0,0,0,28,0,0,7,255,64,0,0,61,0,0,1,254,0,0,0,127,0,0,0,120,0,0,0,255,64,0,0,0,0,0,3,255,0,0,0,0,0,0,11,252,0,0,0,0,0,0,31,244,0,0,0,0,0,0,127,224,0,0,0,0,0,1,255,192,0,0,0,0,0,11,255,0,0,0,0,0,0,47,252,0,0,0,0,0,0,255,240,0,0,0,0,0,7,255,192,0,0,0,0,0,63,255,0,0,0,0,0,2,255,248,0,0,0,0,0,111,255,208,0,0,0,0,27,255,254,0,0,0,0,22,255,255,240,0,0,0,0,255,255,255,64,0,0,0,0,127,255,224,0,0,0,0,0,63,249,0,0,0,0,0,0,9,0,0,0,0,0,0,0,
  // 0x30f4  ヴ
  244,48,31,35,24,36,3,253,0,0,0,0,0,0,0,64,0,0,0,0,0,0,11,192,0,0,0,85,0,11,135,224,0,0,0,255,0,15,194,244,0,0,0,255,0,3,224,252,0,0,0,255,0,2,240,188,0,0,0,255,0,0,248,16,0,0,0,255,0,0,160,0,0,0,0,255,0,0,16,0,127,255,255,255,255,255,253,0,63,255,255,255,255,255,255,0,63,255,255,255,255,255,255,0,63,149,85,85,85,86,255,0,63,64,0,0,0,2,254,0,63,64,0,0,0,2,253,0,63,64,0,0,0,3,252,0,63,64,0,0,0,3,252,0,63,64,0,0,0,7,248,0,63,64,0,0,0,15,244,0,63,128,0,0,0,15,240,0,127,64,0,0,0,47,224,0,0,0,0,0,0,63,192,0,0,0,0,0,0,191,192,0,0,0,0,0,1,255,64,0,0,0,0,0,7,254,0,0,0,0,0,0,31,252,0,0,0,0,0,0,127,240,0,0,0,0,0,2,255,208,0,0,0,0,0,47,255,64,0,0,0,0,6,255,252,0,0,0,0,1,191,255,224,0,0,0,0,1,255,255,64,0,0,0,0,0,191,244,0,0,0,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30f5  ヵ
  245,48,23,26,156,36,6,253,0,0,63,64,0,0,0,0,63,64,0,0,0,0,63,64,0,0,0,0,63,64,0,0,0,0,63,0,0,0,84,0,127,64,1,64,191,255,255,255,255,248,191,255,255,255,255,252,191,255,255,255,255,252,0,0,191,0,2,252,0,0,254,0,2,248,0,0,253,0,2,248,0,0,252,0,2,248,0,2,252,0,3,248,0,3,248,0,3,244,0,7,244,0,3,244,0,15,240,0,3,244,0,31,208,0,3,240,0,63,192,0,7,240,0,255,64,0,11,240,3,254,0,0,15,224,31,252,0,149,111,208,191,240,0,255,255,192,191,192,0,255,255,128,47,0,0,191,253,0,4,0,0,0,0,0,
  // 0x30f6  ヶ
  246,48,27,27,189,36,4,252,0,0,144,0,0,0,0,0,1,254,0,0,0,0,0,2,253,0,0,0,0,0,3,252,0,0,0,0,0,3,248,0,0,0,0,0,11,240,0,0,0,0,0,15,255,255,255,255,252,0,47,255,255,255,255,252,0,127,255,255,255,255,252,0,255,64,2,253,1,84,2,254,0,2,252,0,0,11,252,0,3,252,0,0,47,240,0,3,248,0,0,191,208,0,7,244,0,0,47,128,0,11,240,0,0,1,0,0,15,240,0,0,0,0,0,31,208,0,0,0,0,0,63,192,0,0,0,0,0,191,128,0,0,0,0,1,255,64,0,0,0,0,3,254,0,0,0,0,0,15,252,0,0,0,0,0,127,240,0,0,0,0,2,255,208,0,0,0,0,3,255,0,0,0,0,0,0,124,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30f7  ヷ
  247,48,31,35,24,36,3,253,0,0,0,0,0,0,1,128,0,0,0,0,0,6,15,208,0,0,0,0,0,47,71,240,0,0,0,0,0,15,195,244,0,0,0,0,0,11,208,248,0,0,0,0,0,3,224,64,0,0,0,0,0,1,0,0,127,255,255,255,255,255,248,0,127,255,255,255,255,255,255,0,63,255,255,255,255,255,255,0,63,234,170,170,170,171,254,0,63,128,0,0,0,2,253,0,63,128,0,0,0,3,253,0,63,128,0,0,0,3,252,0,63,128,0,0,0,3,252,0,63,128,0,0,0,7,248,0,63,128,0,0,0,11,248,0,63,128,0,0,0,15,244,0,127,128,0,0,0,31,240,0,127,128,0,0,0,47,224,0,0,0,0,0,0,63,208,0,0,0,0,0,0,191,192,0,0,0,0,0,0,255,64,0,0,0,0,0,3,255,0,0,0,0,0,0,11,253,0,0,0,0,0,0,47,248,0,0,0,0,0,0,191,240,0,0,0,0,0,3,255,192,0,0,0,0,0,31,255,0,0,0,0,0,1,255,252,0,0,0,0,0,31,255,224,0,0,0,0,3,255,255,64,0,0,0,0,1,255,248,0,0,0,0,0,0,127,128,0,0,0,0,0,0,20,0,0,0,0,0,
  // 0x30f8  ヸ
  248,48,33,33,41,36,2,254,0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,24,60,0,0,0,0,0,1,168,61,46,0,0,0,0,0,2,252,31,31,0,0,0,0,0,2,252,15,79,64,0,0,0,0,1,252,11,133,0,0,0,0,0,1,252,6,64,0,0,0,0,0,1,252,0,0,0,15,255,255,255,255,255,255,240,0,15,255,255,255,255,255,255,240,0,15,255,255,255,255,255,255,240,0,5,85,255,85,86,253,85,80,0,0,0,254,0,1,252,0,0,0,0,0,254,0,1,252,0,0,0,0,0,254,0,1,252,0,0,0,0,0,254,0,1,252,0,0,0,0,0,254,0,1,252,0,0,0,0,0,254,0,1,252,0,0,0,0,0,254,0,1,252,0,0,0,0,0,254,0,1,252,0,0,0,0,0,254,0,1,252,0,0,0,41,85,255,85,86,254,85,168,0,127,255,255,255,255,255,255,252,0,127,255,255,255,255,255,255,252,0,127,255,255,255,255,255,255,252,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,1,168,0,0,0,
  // 0x30f9  ヹ
  249,48,32,33,8,36,2,255,0,0,0,0,0,0,0,16,0,0,0,0,0,0,3,240,0,0,0,0,0,7,209,248,0,0,0,0,0,3,240,252,0,0,0,0,0,2,244,126,0,0,0,0,0,0,252,36,0,0,0,0,0,0,164,0,6,170,170,170,170,170,171,128,11,255,255,255,255,255,255,240,11,255,255,255,255,255,255,240,11,255,255,255,255,255,255,208,0,0,0,0,0,0,127,192,0,0,0,0,0,0,255,64,0,0,0,0,0,2,254,0,0,0,0,63,192,11,252,0,0,0,0,63,192,47,240,0,0,0,0,63,192,191,208,0,0,0,0,63,194,255,128,0,0,0,0,63,192,254,0,0,0,0,0,63,192,24,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,191,255,255,255,255,255,255,252,191,255,255,255,255,255,255,252,191,255,255,255,255,255,255,252,191,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0x30fa  ヺ
  250,48,30,35,24,36,4,253,0,0,0,0,0,0,10,0,0,0,0,0,0,40,63,64,0,0,0,0,0,189,15,192,0,0,0,0,0,63,11,208,0,0,0,0,0,47,131,224,0,0,0,0,0,15,129,0,170,85,85,85,85,110,64,0,255,255,255,255,255,255,224,0,255,255,255,255,255,255,248,0,255,255,255,255,255,255,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,31,224,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,63,255,255,255,255,255,128,0,63,255,255,255,255,255,64,0,63,255,255,255,255,255,0,0,21,85,85,85,86,254,0,0,0,0,0,0,3,252,0,0,0,0,0,0,7,248,0,0,0,0,0,0,15,240,0,0,0,0,0,0,63,224,0,0,0,0,0,0,255,192,0,0,0,0,0,2,255,0,0,0,0,0,0,15,253,0,0,0,0,0,0,63,248,0,0,0,0,0,2,255,208,0,0,0,0,0,31,255,64,0,0,0,0,2,255,253,0,0,0,0,0,191,255,224,0,0,0,0,0,191,255,64,0,0,0,0,0,47,244,0,0,0,0,0,0,10,64,0,0,0,0,0,
  // 0x30fb  ・
  251,48,8,8,16,36,14,10,31,244,127,253,255,255,255,255,255,255,255,255,63,252,11,224,
  // 0x30fc  ー
  252,48,30,5,40,36,3,11,191,255,255,255,255,255,255,208,191,255,255,255,255,255,255,208,191,255,255,255,255,255,255,208,191,255,255,255,255,255,255,208,0,0,0,0,0,0,0,0,
  // 0x30fd  ヽ
  253,48,17,18,90,36,10,4,6,0,0,0,0,47,128,0,0,0,191,240,0,0,0,63,252,0,0,0,15,255,0,0,0,3,255,192,0,0,0,255,224,0,0,0,63,248,0,0,0,15,254,0,0,0,3,255,128,0,0,0,255,208,0,0,0,63,244,0,0,0,31,252,0,0,0,11,255,0,0,0,2,255,128,0,0,0,255,192,0,0,0,126,0,0,0,0,40,0,
  // 0x30fe  ヾ
  254,48,20,24,120,36,9,3,0,0,0,1,208,0,0,0,7,240,0,0,15,194,248,0,0,11,208,252,0,0,3,240,126,2,0,1,248,63,31,192,0,252,0,191,240,0,116,0,63,252,0,0,0,15,255,0,0,0,3,255,192,0,0,0,191,240,0,0,0,63,252,0,0,0,15,254,0,0,0,3,255,128,0,0,0,255,208,0,0,0,63,244,0,0,0,31,252,0,0,0,7,255,0,0,0,2,255,128,0,0,0,255,192,0,0,0,63,0,0,0,0,24,0,0,0,0,0,0,
  // 0x30ff  ヿ
  255,48,22,31,186,36,7,254,85,85,85,85,85,64,255,255,255,255,255,224,255,255,255,255,255,224,255,255,255,255,255,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,
  // 0x4eee  仮
  238,78,34,35,59,36,1,252,0,0,100,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,1,253,47,255,255,255,255,192,0,2,252,47,255,255,255,255,192,0,3,244,47,255,255,255,255,192,0,15,240,47,192,0,0,0,0,0,31,208,47,128,0,0,0,0,0,63,192,47,128,0,0,0,0,0,127,64,47,128,0,0,0,0,0,255,64,47,128,0,0,0,0,3,255,64,47,128,0,0,0,0,11,255,64,47,192,0,0,0,0,31,255,64,47,255,255,255,254,0,127,255,64,47,255,255,255,255,0,255,191,64,47,255,255,255,255,0,190,63,64,47,255,0,0,190,0,60,63,64,47,255,0,0,253,0,16,63,64,47,175,128,1,252,0,0,63,64,63,159,192,3,248,0,0,63,64,63,79,208,3,244,0,0,63,64,63,71,240,11,240,0,0,63,64,63,3,248,15,208,0,0,63,64,63,1,253,63,192,0,0,63,64,127,0,255,127,64,0,0,63,64,190,0,63,255,0,0,0,63,64,254,0,47,252,0,0,0,63,64,253,0,15,252,0,0,0,63,65,252,0,63,255,0,0,0,63,67,248,1,255,255,208,0,0,63,67,244,11,254,127,248,0,0,63,79,240,191,248,15,255,128,0,63,95,211,255,208,2,255,224,0,63,79,192,254,0,0,127,192,0,63,66,64,116,0,0,7,0,0,0,0,0,0,0,0,0,0,
  // 0x540d  名
  13,84,31,34,16,36,1,253,0,0,0,249,0,0,0,0,0,0,2,254,0,0,0,0,0,0,3,252,0,0,0,0,0,0,15,244,0,0,0,0,0,0,47,255,255,255,208,0,0,0,191,255,255,255,240,0,0,1,255,255,255,255,224,0,0,11,253,0,0,47,192,0,0,47,244,0,0,127,128,0,0,255,240,0,0,255,0,0,11,255,252,0,2,253,0,0,63,255,255,64,7,252,0,0,63,224,191,224,15,240,0,0,15,64,31,248,63,208,0,0,4,0,7,254,255,128,0,0,0,0,1,255,254,0,0,0,0,0,0,127,248,0,0,0,0,0,0,191,224,0,0,0,0,0,3,255,255,255,255,252,0,0,47,255,255,255,255,252,0,1,255,255,255,255,255,252,0,31,255,240,0,0,2,252,6,255,255,240,0,0,1,252,127,255,215,240,0,0,1,252,63,253,7,240,0,0,1,252,31,128,7,240,0,0,1,252,4,0,7,240,0,0,1,252,0,0,7,240,0,0,1,252,0,0,7,240,0,0,1,252,0,0,7,255,255,255,255,252,0,0,7,255,255,255,255,252,0,0,7,255,255,255,255,252,0,0,7,240,0,0,2,252,0,0,6,160,0,0,1,252,
  // 0x5b9a  定
  154,91,33,35,59,36,1,252,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,208,0,0,0,0,0,127,0,15,192,0,0,0,0,0,127,0,15,192,0,0,0,0,0,127,0,15,192,0,0,0,0,0,127,0,15,195,255,255,255,255,252,127,0,5,67,255,255,255,255,252,21,0,0,3,255,255,255,255,252,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,7,224,3,248,0,0,0,0,0,7,240,3,248,0,0,0,0,0,11,240,3,248,0,0,0,0,0,15,224,3,255,255,255,192,0,0,15,208,3,255,255,255,192,0,0,31,224,3,255,255,255,192,0,0,47,240,3,248,0,0,0,0,0,63,244,3,248,0,0,0,0,0,127,252,3,248,0,0,0,0,0,255,255,3,248,0,0,0,0,1,253,63,211,248,0,0,0,0,3,252,31,251,248,0,0,0,0,11,244,7,255,253,0,0,0,0,47,240,1,255,255,255,255,255,192,127,192,0,47,255,255,255,255,128,47,64,0,1,191,255,255,255,64,9,0,0,0,0,5,85,85,0,0,0,0,0,0,0,0,0,0,
  // 0x7247  片
  71,114,32,35,24,36,1,252,0,0,0,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,213,85,95,245,85,84,0,47,255,255,255,255,255,253,0,47,255,255,255,255,255,253,0,47,255,255,255,255,255,253,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,213,85,85,85,80,0,0,63,255,255,255,255,244,0,0,63,255,255,255,255,244,0,0,127,255,255,255,255,244,0,0,127,0,0,0,7,244,0,0,191,0,0,0,7,244,0,0,255,0,0,0,7,244,0,0,254,0,0,0,7,244,0,2,252,0,0,0,7,244,0,3,252,0,0,0,7,244,0,11,248,0,0,0,7,244,0,15,240,0,0,0,7,244,0,63,224,0,0,0,7,244,0,127,192,0,0,0,7,244,0,31,0,0,0,0,7,244,0,9,0,0,0,0,7,244,0,0,0,0,0,0,0,0,0,
  // 0x793a  示
  58,121,33,32,32,36,1,253,0,21,85,85,85,85,85,64,0,0,191,255,255,255,255,255,224,0,0,191,255,255,255,255,255,224,0,0,191,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,85,85,85,85,85,85,85,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,2,64,2,252,0,24,0,0,0,11,244,2,252,1,253,0,0,0,15,240,2,252,0,255,0,0,0,31,208,2,252,0,127,128,0,0,63,192,2,252,0,47,208,0,0,191,64,2,252,0,15,240,0,0,255,0,2,252,0,11,244,0,3,253,0,2,252,0,3,252,0,11,248,0,2,252,0,2,254,0,47,240,0,2,252,0,0,255,0,127,208,0,2,252,0,0,191,64,31,64,0,2,252,0,0,63,64,1,0,21,87,252,0,0,36,0,0,0,47,255,248,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,15,254,128,0,0,0,0,
  // 0x7fa9  義
  169,127,33,34,50,36,2,253,0,0,96,0,0,30,64,0,0,0,3,252,0,0,63,192,0,0,0,1,253,0,0,63,64,0,0,0,0,191,0,0,255,0,0,0,31,255,255,255,255,255,255,244,0,31,255,255,255,255,255,255,244,0,10,170,170,175,250,170,170,160,0,0,0,0,15,224,0,0,0,0,1,255,255,255,255,255,255,64,0,1,255,255,255,255,255,255,64,0,0,85,85,95,245,85,85,0,0,0,0,0,15,224,0,0,0,0,170,170,170,175,250,170,170,170,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,0,0,0,100,0,0,64,0,0,1,90,255,252,63,66,244,0,0,63,255,255,254,47,135,255,64,0,63,235,254,64,47,128,191,224,0,0,2,248,0,31,192,15,224,0,0,2,248,0,31,192,1,128,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,170,171,254,170,175,250,170,170,0,0,2,248,0,3,240,15,128,0,0,2,254,191,131,244,63,128,0,170,255,255,255,129,252,254,0,0,255,255,255,233,0,255,248,0,0,255,171,248,0,0,255,208,13,0,0,2,248,0,27,255,224,15,64,0,2,248,2,255,255,249,47,64,2,171,248,63,255,135,255,255,0,3,255,244,31,248,0,255,254,0,2,255,144,10,64,0,27,248,0,
  // 0x8868  表
  104,136,34,34,50,36,1,253,0,0,0,2,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,7,255,255,255,255,255,255,253,0,7,255,255,255,255,255,255,253,0,7,255,255,255,255,255,255,253,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,170,170,171,254,170,170,160,0,0,191,255,255,255,255,255,240,0,0,191,255,255,255,255,255,240,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,0,0,0,191,239,128,0,0,0,0,0,7,255,15,192,0,116,0,0,0,47,248,15,208,2,254,0,0,2,255,208,7,240,15,253,0,0,47,255,64,3,244,127,240,0,7,255,255,0,2,254,255,64,0,191,255,191,0,0,255,248,0,0,63,244,63,0,0,191,208,0,0,30,64,63,0,0,63,208,0,0,0,0,63,0,0,31,240,0,0,0,0,63,0,27,139,253,0,0,0,0,63,91,255,194,255,128,0,0,0,127,255,255,192,191,248,0,0,111,255,255,249,0,31,255,128,0,255,255,249,0,0,7,255,208,0,191,249,0,0,0,0,127,64,0,57,0,0,0,0,0,6,0,
};

#endif // HAS_GRAPHICAL_TFT
