/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Cyrillic 36pt, capital 'A' height: 26px, width: 100%, range: 0x0401-0x0491, glyphs: 74
extern const uint8_t NotoSans_Medium_Cyrillic_26[10307] = {
  130,26,1,4,145,4,34,247, // unifont_t
  // 0x0401  Ё
  15,33,132,20,3,0,0,64,5,0,3,240,31,192,7,244,47,192,3,240,15,192,0,64,1,0,0,0,0,0,0,0,0,0,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x0402  Ђ
  255,
  // 0x0403  Ѓ
  255,
  // 0x0404  Є
  20,27,135,24,2,255,0,0,127,255,144,0,11,255,255,255,0,127,255,255,255,1,255,249,86,253,7,255,0,0,24,15,248,0,0,0,47,240,0,0,0,63,208,0,0,0,63,192,0,0,0,127,128,0,0,0,191,64,0,0,0,255,255,255,255,64,255,255,255,255,64,255,255,255,255,64,255,149,85,85,0,191,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,192,0,0,0,63,224,0,0,0,31,244,0,0,0,15,253,0,0,0,3,255,208,0,109,0,255,255,255,253,0,47,255,255,253,0,6,255,255,248,0,0,5,84,0,
  // 0x0405  Ѕ
  255,
  // 0x0406  І
  11,26,78,13,1,0,106,170,160,191,255,244,127,255,240,2,254,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,47,255,208,191,255,244,191,255,244,
  // 0x0407  Ї
  11,33,99,13,1,0,20,0,80,190,3,244,255,3,248,190,3,244,20,0,64,0,0,0,0,0,0,106,170,160,191,255,244,127,255,240,2,254,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,47,255,208,191,255,244,191,255,244,
  // 0x0408  Ј
  255,
  // 0x0409  Љ
  255,
  // 0x040a  Њ
  255,
  // 0x040b  Ћ
  255,
  // 0x040c  Ќ
  255,
  // 0x040d  Ѝ
  255,
  // 0x040e  Ў
  255,
  // 0x040f  Џ
  255,
  // 0x0410  А
  24,26,156,24,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x0411  Б
  18,26,130,22,3,0,106,170,170,170,0,191,255,255,255,0,191,255,255,255,0,191,234,170,170,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,255,255,128,0,191,255,255,248,0,191,255,255,255,0,191,64,23,255,128,191,64,0,127,192,191,64,0,47,208,191,64,0,31,224,191,64,0,31,224,191,64,0,47,224,191,64,0,63,208,191,64,0,191,192,191,149,91,255,128,191,255,255,254,0,191,255,255,248,0,191,255,254,64,0,
  // 0x0412  В
  19,26,130,24,3,0,106,170,169,64,0,191,255,255,248,0,191,255,255,255,64,191,170,175,255,192,191,64,0,127,224,191,64,0,47,240,191,64,0,15,240,191,64,0,15,240,191,64,0,31,224,191,64,0,63,208,191,64,1,255,128,191,255,255,254,0,191,255,255,224,0,191,255,255,255,0,191,64,5,255,208,191,64,0,47,240,191,64,0,15,244,191,64,0,7,248,191,64,0,7,248,191,64,0,11,248,191,64,0,15,244,191,64,0,47,240,191,64,22,255,224,191,255,255,255,192,191,255,255,254,0,191,255,255,144,0,
  // 0x0413  Г
  16,26,104,19,3,0,106,170,170,169,191,255,255,253,191,255,255,253,191,234,170,169,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,
  // 0x0414  Д
  25,33,231,26,0,249,0,0,42,170,170,144,0,0,0,127,255,255,224,0,0,0,127,255,255,224,0,0,0,191,170,191,224,0,0,0,191,0,31,224,0,0,0,255,0,31,224,0,0,0,254,0,31,224,0,0,1,253,0,31,224,0,0,2,253,0,31,224,0,0,3,252,0,31,224,0,0,3,252,0,31,224,0,0,7,248,0,31,224,0,0,11,244,0,31,224,0,0,15,240,0,31,224,0,0,31,224,0,31,224,0,0,47,208,0,31,224,0,0,63,192,0,31,224,0,0,127,128,0,31,224,0,0,255,0,0,31,224,0,0,255,0,0,31,224,0,2,253,0,0,31,224,0,3,252,0,0,31,224,0,95,249,85,85,111,229,64,255,255,255,255,255,255,192,255,255,255,255,255,255,192,255,255,255,255,255,255,192,255,0,0,0,0,63,192,255,0,0,0,0,63,192,255,0,0,0,0,63,192,255,0,0,0,0,63,192,255,0,0,0,0,63,192,255,0,0,0,0,63,192,255,0,0,0,0,63,192,
  // 0x0415  Е
  15,26,104,20,3,0,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x0416  Ж
  32,26,208,32,0,0,42,128,0,10,144,0,2,168,47,224,0,15,224,0,15,244,15,244,0,15,224,0,47,224,3,252,0,15,224,0,127,192,1,255,0,15,224,0,255,0,0,191,128,15,224,3,253,0,0,63,208,15,224,11,244,0,0,15,240,15,224,31,224,0,0,7,252,15,224,63,192,0,0,1,254,15,224,255,0,0,0,0,191,79,226,253,0,0,0,0,63,207,231,248,0,0,0,0,15,255,255,240,0,0,0,0,47,239,239,244,0,0,0,0,127,207,227,252,0,0,0,0,255,15,225,254,0,0,0,3,253,15,224,191,128,0,0,11,248,15,224,63,208,0,0,31,240,15,224,31,240,0,0,63,192,15,224,11,248,0,0,255,64,15,224,3,254,0,2,254,0,15,224,0,255,64,7,252,0,15,224,0,127,192,15,240,0,15,224,0,47,224,63,208,0,15,224,0,15,248,191,128,0,15,224,0,3,253,
  // 0x0417  З
  19,27,135,22,1,255,0,111,255,224,0,7,255,255,254,0,63,255,255,255,192,63,228,1,255,224,14,0,0,31,240,0,0,0,15,244,0,0,0,11,244,0,0,0,11,244,0,0,0,15,240,0,0,0,63,208,0,0,6,255,128,1,255,255,253,0,1,255,255,144,0,1,255,255,254,0,0,85,91,255,192,0,0,0,47,240,0,0,0,11,248,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,7,248,0,0,0,15,244,121,0,0,191,240,127,255,255,255,192,127,255,255,255,0,27,255,255,228,0,0,5,80,0,0,
  // 0x0418  И
  22,26,156,28,3,0,106,0,0,0,42,160,191,0,0,0,127,240,191,0,0,0,255,240,191,0,0,2,255,240,191,0,0,7,255,240,191,0,0,15,251,240,191,0,0,47,235,240,191,0,0,127,203,240,191,0,0,255,11,240,191,0,2,254,11,240,191,0,3,252,11,240,191,0,15,244,11,240,191,0,47,224,11,240,191,0,63,192,11,240,191,0,255,64,11,240,191,1,254,0,11,240,191,3,252,0,11,240,191,15,244,0,11,240,191,31,240,0,11,240,191,63,192,0,11,240,191,191,64,0,11,240,191,255,0,0,11,240,191,252,0,0,11,240,191,248,0,0,11,240,191,240,0,0,11,240,191,208,0,0,11,240,
  // 0x0419  Й
  22,34,204,28,3,0,0,127,0,2,248,0,0,127,0,3,248,0,0,63,128,11,244,0,0,47,250,191,224,0,0,11,255,255,128,0,0,1,191,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,0,0,0,42,160,191,0,0,0,127,240,191,0,0,0,255,240,191,0,0,2,255,240,191,0,0,7,255,240,191,0,0,15,251,240,191,0,0,47,235,240,191,0,0,127,203,240,191,0,0,255,11,240,191,0,2,254,11,240,191,0,3,252,11,240,191,0,15,244,11,240,191,0,47,224,11,240,191,0,63,192,11,240,191,0,255,64,11,240,191,1,254,0,11,240,191,3,252,0,11,240,191,15,244,0,11,240,191,31,240,0,11,240,191,63,192,0,11,240,191,191,64,0,11,240,191,255,0,0,11,240,191,252,0,0,11,240,191,248,0,0,11,240,191,240,0,0,11,240,191,208,0,0,11,240,
  // 0x041a  К
  20,26,130,23,3,0,106,0,0,2,168,191,64,0,15,244,191,64,0,63,208,191,64,0,191,128,191,64,2,254,0,191,64,7,252,0,191,64,31,240,0,191,64,63,192,0,191,64,255,64,0,191,67,253,0,0,191,75,248,0,0,191,111,224,0,0,191,255,192,0,0,191,191,208,0,0,191,95,240,0,0,191,75,252,0,0,191,66,255,0,0,191,64,255,128,0,191,64,63,224,0,191,64,15,244,0,191,64,7,252,0,191,64,2,255,0,191,64,0,191,192,191,64,0,63,224,191,64,0,15,248,191,64,0,3,253,
  // 0x041b  Л
  23,27,162,26,0,255,0,0,170,170,170,164,0,1,255,255,255,244,0,2,255,255,255,244,0,2,254,170,175,244,0,3,252,0,7,244,0,3,248,0,7,244,0,3,248,0,7,244,0,3,244,0,7,244,0,7,244,0,7,244,0,7,240,0,7,244,0,11,240,0,7,244,0,15,240,0,7,244,0,15,240,0,7,244,0,15,224,0,7,244,0,31,208,0,7,244,0,31,208,0,7,244,0,47,192,0,7,244,0,63,192,0,7,244,0,63,192,0,7,244,0,63,128,0,7,244,0,191,64,0,7,244,0,255,0,0,7,244,2,255,0,0,7,244,255,253,0,0,7,244,255,248,0,0,7,244,255,224,0,0,7,244,21,0,0,0,0,0,
  // 0x041c  М
  27,26,182,33,3,0,106,160,0,0,0,42,164,191,244,0,0,0,127,248,191,252,0,0,0,191,248,191,252,0,0,0,255,248,191,253,0,0,1,255,248,191,191,0,0,3,247,248,191,127,0,0,3,243,248,191,63,128,0,11,227,248,191,47,192,0,15,211,248,191,31,208,0,31,195,248,191,15,224,0,47,131,248,191,11,240,0,63,67,248,191,3,244,0,127,3,248,191,3,248,0,254,3,248,191,1,252,0,252,3,248,191,0,253,2,252,3,248,191,0,255,3,244,3,248,191,0,127,7,240,3,248,191,0,63,75,224,3,248,191,0,47,207,208,3,248,191,0,31,239,192,3,248,191,0,15,255,128,3,248,191,0,11,255,0,3,248,191,0,7,255,0,3,248,191,0,3,254,0,3,248,191,0,2,252,0,3,248,
  // 0x041d  Н
  21,26,156,27,3,0,106,0,0,0,106,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,255,255,255,255,64,191,255,255,255,255,64,191,255,255,255,255,64,191,85,85,85,191,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,
  // 0x041e  О
  24,27,162,28,2,255,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,
  // 0x041f  П
  20,26,130,26,3,0,106,170,170,170,170,191,255,255,255,255,191,255,255,255,255,191,234,170,170,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,191,64,0,0,255,
  // 0x0420  Р
  17,26,130,22,3,0,106,170,165,0,0,191,255,255,224,0,191,255,255,252,0,191,170,191,255,0,191,64,2,255,128,191,64,0,127,192,191,64,0,63,192,191,64,0,63,192,191,64,0,63,192,191,64,0,63,192,191,64,0,127,192,191,64,0,255,128,191,64,27,255,0,191,255,255,253,0,191,255,255,240,0,191,255,254,64,0,191,84,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,
  // 0x0421  С
  20,27,135,23,2,255,0,0,191,255,144,0,15,255,255,253,0,127,255,255,252,2,255,245,91,252,7,255,0,0,36,15,252,0,0,0,47,240,0,0,0,63,208,0,0,0,63,192,0,0,0,127,128,0,0,0,191,64,0,0,0,255,64,0,0,0,255,64,0,0,0,255,64,0,0,0,255,64,0,0,0,191,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,192,0,0,0,63,224,0,0,0,31,244,0,0,0,15,253,0,0,0,3,255,208,1,184,0,255,255,255,248,0,63,255,255,248,0,6,255,255,224,0,0,5,80,0,
  // 0x0422  Т
  20,26,130,20,0,0,106,170,170,170,170,191,255,255,255,255,191,255,255,255,255,106,170,255,170,169,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,
  // 0x0423  У
  23,27,162,23,0,255,106,128,0,0,2,168,63,192,0,0,11,244,31,224,0,0,15,240,15,240,0,0,47,208,7,248,0,0,63,192,3,252,0,0,127,128,1,254,0,0,255,0,0,255,0,1,254,0,0,127,128,2,253,0,0,63,192,3,252,0,0,31,224,11,244,0,0,15,240,15,240,0,0,7,248,31,208,0,0,3,252,63,192,0,0,1,253,63,128,0,0,0,255,191,0,0,0,0,127,254,0,0,0,0,63,253,0,0,0,0,31,252,0,0,0,0,15,244,0,0,0,0,47,240,0,0,0,0,127,208,0,0,25,6,255,128,0,0,31,255,255,0,0,0,31,255,252,0,0,0,31,255,208,0,0,0,0,84,0,0,0,0,
  // 0x0424  Ф
  26,27,189,30,2,255,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,6,191,255,228,0,0,0,191,255,255,255,208,0,3,255,255,255,255,248,0,15,255,151,249,111,254,0,63,244,3,248,2,255,64,127,192,3,248,0,127,192,255,64,3,248,0,47,208,255,0,3,248,0,31,224,254,0,3,248,0,15,224,254,0,3,248,0,15,224,254,0,3,248,0,15,224,255,0,3,248,0,31,224,255,0,3,248,0,47,208,191,128,3,248,0,63,192,63,224,3,248,0,255,128,31,253,3,248,11,255,0,11,255,255,255,255,252,0,1,255,255,255,255,224,0,0,31,255,255,254,0,0,0,0,23,253,64,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,3,248,0,0,0,0,0,1,80,0,0,0,
  // 0x0425  Х
  22,26,156,22,0,0,42,128,0,0,42,128,47,224,0,0,191,64,15,244,0,1,255,0,7,252,0,3,252,0,2,254,0,11,248,0,0,255,0,15,240,0,0,127,192,47,192,0,0,47,208,127,128,0,0,15,240,255,0,0,0,7,250,253,0,0,0,2,255,248,0,0,0,0,255,240,0,0,0,0,191,208,0,0,0,0,255,240,0,0,0,2,255,244,0,0,0,3,255,252,0,0,0,15,241,254,0,0,0,31,208,255,64,0,0,63,192,63,192,0,0,191,64,47,224,0,1,254,0,15,244,0,3,252,0,7,252,0,11,244,0,2,254,0,31,240,0,0,255,0,63,192,0,0,127,192,191,128,0,0,63,224,
  // 0x0426  Ц
  24,33,198,27,3,249,106,0,0,0,170,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,64,0,0,255,0,191,149,85,85,255,84,191,255,255,255,255,253,191,255,255,255,255,253,191,255,255,255,255,253,0,0,0,0,1,253,0,0,0,0,1,253,0,0,0,0,1,253,0,0,0,0,1,253,0,0,0,0,1,253,0,0,0,0,1,253,0,0,0,0,1,253,
  // 0x0427  Ч
  20,26,130,25,2,0,106,64,0,0,170,127,64,0,0,255,127,64,0,0,255,127,64,0,0,255,127,64,0,0,255,127,64,0,0,255,127,64,0,0,255,127,64,0,0,255,127,64,0,0,255,127,64,0,0,255,127,128,0,0,255,127,128,0,0,255,63,192,0,1,255,63,244,1,111,255,31,255,255,255,255,7,255,255,255,255,0,191,255,144,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,
  // 0x0428  Ш
  32,26,208,38,3,0,106,0,0,10,160,0,1,168,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,64,0,15,240,0,2,253,191,149,85,95,245,85,86,253,191,255,255,255,255,255,255,253,191,255,255,255,255,255,255,253,191,255,255,255,255,255,255,253,
  // 0x0429  Щ
  35,33,41,38,3,249,106,0,0,10,144,0,2,168,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,64,0,31,224,0,3,252,0,191,149,85,111,245,85,87,253,80,191,255,255,255,255,255,255,255,244,191,255,255,255,255,255,255,255,244,191,255,255,255,255,255,255,255,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,
  // 0x042a  Ъ
  24,26,156,25,0,0,170,170,160,0,0,0,255,255,240,0,0,0,255,255,240,0,0,0,170,175,240,0,0,0,0,11,240,0,0,0,0,11,240,0,0,0,0,11,240,0,0,0,0,11,240,0,0,0,0,11,240,0,0,0,0,11,240,0,0,0,0,11,244,0,0,0,0,11,255,255,228,0,0,11,255,255,255,128,0,11,255,255,255,224,0,11,244,1,191,244,0,11,240,0,11,252,0,11,240,0,3,253,0,11,240,0,2,253,0,11,240,0,2,253,0,11,240,0,2,253,0,11,240,0,3,252,0,11,240,0,11,252,0,11,245,85,191,244,0,11,255,255,255,224,0,11,255,255,255,64,0,11,255,255,228,0,
  // 0x042b  Ы
  25,26,182,31,3,0,106,0,0,0,0,42,128,191,64,0,0,0,63,192,191,64,0,0,0,63,192,191,64,0,0,0,63,192,191,64,0,0,0,63,192,191,64,0,0,0,63,192,191,64,0,0,0,63,192,191,64,0,0,0,63,192,191,64,0,0,0,63,192,191,64,0,0,0,63,192,191,64,0,0,0,63,192,191,255,254,64,0,63,192,191,255,255,244,0,63,192,191,255,255,254,0,63,192,191,64,27,255,64,63,192,191,64,0,191,192,63,192,191,64,0,63,192,63,192,191,64,0,47,208,63,192,191,64,0,47,208,63,192,191,64,0,63,208,63,192,191,64,0,63,192,63,192,191,64,0,255,192,63,192,191,64,91,255,0,63,192,191,255,255,253,0,63,192,191,255,255,244,0,63,192,191,255,254,64,0,63,192,
  // 0x042c  Ь
  19,26,130,23,3,0,106,0,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,255,255,144,0,191,255,255,253,0,191,255,255,255,64,191,64,6,255,208,191,64,0,47,224,191,64,0,15,240,191,64,0,15,240,191,64,0,11,244,191,64,0,15,240,191,64,0,15,240,191,64,0,63,224,191,149,86,255,192,191,255,255,255,64,191,255,255,252,0,191,255,255,144,0,
  // 0x042d  Э
  20,27,135,23,1,255,6,255,254,64,0,191,255,255,244,0,127,255,255,254,0,63,165,91,255,192,20,0,0,191,224,0,0,0,47,240,0,0,0,11,248,0,0,0,3,252,0,0,0,2,253,0,0,0,1,254,0,0,0,1,255,1,255,255,255,255,1,255,255,255,255,1,255,255,255,255,0,85,85,86,255,0,0,0,1,254,0,0,0,1,254,0,0,0,2,253,0,0,0,3,252,0,0,0,11,252,0,0,0,31,244,0,0,0,127,224,185,0,7,255,192,191,255,255,255,0,191,255,255,248,0,47,255,255,128,0,0,21,64,0,0,
  // 0x042e  Ю
  33,27,243,38,3,255,106,0,0,0,47,255,208,0,0,191,64,0,2,255,255,254,0,0,191,64,0,15,255,255,255,192,0,191,64,0,63,253,85,255,240,0,191,64,0,255,208,0,31,248,0,191,64,1,255,0,0,7,252,0,191,64,3,254,0,0,2,254,0,191,64,3,252,0,0,0,255,0,191,64,7,248,0,0,0,255,64,191,64,11,244,0,0,0,191,128,191,64,15,240,0,0,0,127,128,191,255,255,240,0,0,0,127,192,191,255,255,240,0,0,0,63,192,191,255,255,240,0,0,0,63,192,191,85,95,240,0,0,0,63,192,191,64,15,240,0,0,0,127,128,191,64,11,244,0,0,0,127,128,191,64,11,248,0,0,0,191,64,191,64,7,252,0,0,0,255,0,191,64,3,253,0,0,1,255,0,191,64,2,255,0,0,3,253,0,191,64,0,255,192,0,15,252,0,191,64,0,127,244,0,191,240,0,191,64,0,31,255,255,255,208,0,191,64,0,7,255,255,255,0,0,191,64,0,0,127,255,244,0,0,0,0,0,0,0,84,0,0,0,
  // 0x042f  Я
  19,26,130,23,1,0,0,1,106,170,168,0,47,255,255,252,1,255,255,255,252,3,255,234,171,252,11,253,0,3,252,15,240,0,3,252,31,240,0,3,252,31,224,0,3,252,31,224,0,3,252,15,240,0,3,252,15,248,0,3,252,7,254,0,3,252,2,255,250,171,252,0,191,255,255,252,0,11,255,255,252,0,15,250,171,252,0,31,240,3,252,0,63,192,3,252,0,191,128,3,252,1,255,0,3,252,3,253,0,3,252,11,248,0,3,252,31,240,0,3,252,63,224,0,3,252,191,192,0,3,252,255,64,0,3,252,
  // 0x0430  а
  17,21,105,21,1,255,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x0431  б
  18,29,145,22,2,255,0,0,0,1,64,0,0,6,255,208,0,6,255,255,224,0,127,255,255,224,1,255,255,148,0,7,255,64,0,0,15,244,0,0,0,47,208,0,0,0,63,192,0,0,0,63,64,0,0,0,191,2,255,224,0,191,31,255,252,0,255,127,255,255,0,255,253,1,255,192,255,224,0,63,192,255,128,0,47,224,255,0,0,31,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,191,0,0,15,240,127,128,0,31,224,63,192,0,47,208,47,224,0,63,192,15,248,1,255,128,7,255,255,255,0,1,255,255,248,0,0,47,255,208,0,0,0,80,0,0,
  // 0x0432  в
  17,20,100,21,3,0,85,85,84,0,0,255,255,255,208,0,255,255,255,252,0,255,170,175,254,0,255,0,1,255,0,255,0,0,255,0,255,0,0,255,0,255,0,2,254,0,255,170,175,248,0,255,255,255,144,0,255,255,255,244,0,255,85,91,254,0,255,0,0,255,64,255,0,0,127,128,255,0,0,127,128,255,0,0,191,128,255,0,2,255,0,255,255,255,254,0,255,255,255,248,0,255,255,254,128,0,
  // 0x0433  г
  13,20,80,16,3,0,85,85,85,0,255,255,255,64,255,255,255,64,255,170,170,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,
  // 0x0434  д
  21,27,162,22,0,249,0,1,85,85,80,0,0,3,255,255,244,0,0,3,255,255,244,0,0,3,250,175,244,0,0,7,244,7,244,0,0,7,240,7,244,0,0,11,240,7,244,0,0,15,240,7,244,0,0,15,224,7,244,0,0,31,208,7,244,0,0,47,192,7,244,0,0,63,128,7,244,0,0,127,64,7,244,0,0,255,0,7,244,0,1,254,0,7,244,0,3,252,0,7,244,0,11,244,0,7,244,0,127,255,255,255,255,192,127,255,255,255,255,192,127,255,255,255,255,192,127,0,0,0,31,192,127,0,0,0,31,192,127,0,0,0,31,192,127,0,0,0,31,192,127,0,0,0,31,192,127,0,0,0,31,192,127,0,0,0,31,192,
  // 0x0435  е
  17,21,105,21,2,255,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,
  // 0x0436  ж
  28,20,140,28,0,0,21,64,0,85,0,1,84,47,224,0,191,0,3,252,11,244,0,191,0,15,240,3,252,0,191,0,63,192,0,255,0,191,0,191,64,0,127,128,191,1,253,0,0,31,224,191,7,248,0,0,11,244,191,15,240,0,0,3,252,191,63,192,0,0,0,255,191,191,0,0,0,0,255,255,255,64,0,0,3,253,191,63,192,0,0,11,244,191,15,240,0,0,47,224,191,7,248,0,0,127,192,191,2,254,0,0,255,0,191,0,191,64,3,252,0,191,0,63,208,15,244,0,191,0,15,240,47,208,0,191,0,3,252,191,128,0,191,0,1,255,
  // 0x0437  з
  16,21,84,18,1,255,1,171,164,0,63,255,255,128,63,255,255,240,47,149,95,252,0,0,3,252,0,0,1,252,0,0,2,252,0,0,7,248,0,170,191,224,0,255,255,0,0,255,255,208,0,85,111,248,0,0,3,253,0,0,0,254,0,0,0,254,0,0,1,254,228,0,7,253,255,251,255,252,255,255,255,240,47,255,255,64,0,21,64,0,
  // 0x0438  и
  18,20,100,24,3,0,85,0,0,21,80,254,0,0,127,240,254,0,0,255,240,254,0,2,255,240,254,0,3,255,240,254,0,15,251,240,254,0,31,219,240,254,0,63,139,240,254,0,255,11,240,254,1,253,11,240,254,3,252,11,240,254,11,240,11,240,254,31,208,11,240,254,63,192,11,240,253,191,0,11,240,254,254,0,11,240,255,252,0,11,240,255,244,0,11,240,255,224,0,11,240,255,192,0,11,240,
  // 0x0439  й
  18,28,140,24,3,0,6,144,0,42,64,15,224,0,63,64,11,240,0,191,0,3,253,87,254,0,1,255,255,252,0,0,47,255,208,0,0,0,0,0,0,0,0,0,0,0,85,0,0,21,80,254,0,0,127,240,254,0,0,255,240,254,0,2,255,240,254,0,3,255,240,254,0,15,251,240,254,0,31,219,240,254,0,63,139,240,254,0,255,11,240,254,1,253,11,240,254,3,252,11,240,254,11,240,11,240,254,31,208,11,240,254,63,192,11,240,253,191,0,11,240,254,254,0,11,240,255,252,0,11,240,255,244,0,11,240,255,224,0,11,240,255,192,0,11,240,
  // 0x043a  к
  17,20,100,20,3,0,85,0,0,85,0,255,0,3,253,0,255,0,15,244,0,255,0,47,208,0,255,0,127,128,0,255,1,254,0,0,255,3,252,0,0,255,15,240,0,0,255,63,192,0,0,255,191,64,0,0,255,255,64,0,0,255,63,208,0,0,255,15,240,0,0,255,7,252,0,0,255,1,255,0,0,255,0,191,128,0,255,0,47,224,0,255,0,15,248,0,255,0,3,253,0,255,0,0,255,64,
  // 0x043b  л
  19,21,105,22,0,255,0,5,85,85,80,0,15,255,255,248,0,15,255,255,248,0,31,234,175,248,0,31,192,7,248,0,31,192,7,248,0,47,192,7,248,0,47,192,7,248,0,63,128,7,248,0,63,128,7,248,0,63,64,7,248,0,127,64,7,248,0,191,0,7,248,0,255,0,7,248,0,254,0,7,248,2,253,0,7,248,7,252,0,7,248,255,244,0,7,248,255,240,0,7,248,255,128,0,7,248,4,0,0,0,0,
  // 0x043c  м
  22,20,120,28,3,0,85,64,0,0,21,80,255,224,0,0,191,240,255,240,0,0,255,240,255,244,0,1,255,240,255,248,0,3,255,240,254,252,0,3,251,240,253,253,0,11,235,240,253,127,0,15,219,240,253,63,0,31,203,240,253,47,128,47,139,240,253,31,192,63,11,240,253,15,208,191,11,240,253,11,240,253,11,240,253,3,241,252,11,240,253,2,250,248,11,240,253,1,255,240,11,240,253,0,255,240,11,240,253,0,191,208,11,240,253,0,63,192,11,240,253,0,63,128,11,240,
  // 0x043d  н
  17,20,100,23,3,0,85,0,0,21,64,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,170,170,191,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,
  // 0x043e  о
  18,21,105,22,2,255,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,
  // 0x043f  п
  17,20,100,23,3,0,85,85,85,85,64,255,255,255,255,192,255,255,255,255,192,255,170,170,191,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,
  // 0x0440  р
  18,29,145,22,3,247,84,1,170,0,0,253,31,255,224,0,253,191,255,252,0,255,254,91,255,0,255,208,1,255,64,255,128,0,127,192,255,0,0,63,192,255,0,0,63,192,255,0,0,47,208,255,0,0,47,208,255,0,0,31,208,255,0,0,47,208,255,0,0,47,208,255,0,0,63,192,255,64,0,63,192,255,192,0,255,128,255,240,2,255,0,255,255,255,253,0,254,127,255,248,0,254,11,255,208,0,255,0,20,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,170,0,0,0,0,
  // 0x0441  с
  15,21,84,18,2,255,0,6,170,64,0,255,255,244,7,255,255,240,15,254,171,224,63,240,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,191,128,0,0,63,192,0,0,63,244,0,176,15,255,255,240,3,255,255,240,0,127,255,208,0,1,84,0,
  // 0x0442  т
  17,20,100,18,0,0,21,85,85,85,64,127,255,255,255,192,127,255,255,255,192,42,171,254,170,128,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,
  // 0x0443  у
  19,29,145,19,0,247,85,0,0,1,84,191,64,0,7,248,63,192,0,15,240,63,192,0,15,240,31,224,0,31,208,15,240,0,63,192,11,244,0,63,128,3,248,0,191,64,3,252,0,255,0,1,253,0,254,0,0,255,2,252,0,0,191,3,252,0,0,63,71,244,0,0,63,203,240,0,0,31,207,224,0,0,15,223,208,0,0,11,255,192,0,0,3,255,128,0,0,3,255,0,0,0,1,255,0,0,0,1,253,0,0,0,3,252,0,0,0,3,248,0,0,0,11,244,0,0,0,47,240,0,0,38,255,192,0,0,127,255,64,0,0,127,253,0,0,0,42,144,0,0,0,
  // 0x0444  ф
  23,37,222,27,2,247,0,0,5,64,0,0,0,0,15,208,0,0,0,0,15,208,0,0,0,0,15,208,0,0,0,0,15,208,0,0,0,0,15,208,0,0,0,0,15,208,0,0,0,0,15,208,0,0,0,1,111,229,0,0,0,47,255,255,224,0,2,255,255,255,253,0,11,255,175,235,255,128,47,244,15,208,191,208,63,208,15,208,31,240,191,128,15,208,11,244,255,0,15,208,3,252,255,0,15,208,3,252,255,0,15,208,3,252,255,0,15,208,3,252,255,0,15,208,3,252,255,0,15,208,3,252,191,64,15,208,7,248,127,192,15,208,15,244,63,224,15,208,47,240,15,253,15,209,255,192,3,255,255,255,255,64,0,191,255,255,252,0,0,11,255,255,144,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,10,128,0,0,
  // 0x0445  х
  18,20,100,20,1,0,85,0,0,21,64,191,192,0,63,192,63,208,0,255,64,15,240,2,254,0,7,252,3,252,0,3,253,15,244,0,0,255,31,224,0,0,127,255,192,0,0,47,255,0,0,0,15,254,0,0,0,15,253,0,0,0,47,255,0,0,0,127,255,192,0,0,255,47,224,0,2,254,15,240,0,7,252,7,252,0,15,240,2,254,0,47,224,0,255,64,127,192,0,127,192,255,0,0,47,224,
  // 0x0446  ц
  20,27,135,23,3,249,85,0,0,21,64,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,190,
  // 0x0447  ч
  18,20,100,23,2,0,21,0,0,5,64,127,64,0,31,224,127,64,0,31,224,127,64,0,31,224,127,64,0,31,224,127,64,0,31,224,127,64,0,31,224,127,64,0,31,224,127,64,0,31,224,127,192,0,127,224,63,245,91,255,224,31,255,255,255,224,7,255,255,95,224,0,106,144,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,
  // 0x0448  ш
  27,20,140,33,3,0,85,0,0,84,0,1,84,255,0,1,253,0,3,252,255,0,1,253,0,3,252,255,0,1,253,0,3,252,255,0,1,253,0,3,252,255,0,1,253,0,3,252,255,0,1,253,0,3,252,255,0,1,253,0,3,252,255,0,1,253,0,3,252,255,0,1,253,0,3,252,255,0,1,253,0,3,252,255,0,1,253,0,3,252,255,0,1,253,0,3,252,255,0,1,253,0,3,252,255,0,1,253,0,3,252,255,0,1,253,0,3,252,255,0,1,253,0,3,252,255,255,255,255,255,255,252,255,255,255,255,255,255,252,255,255,255,255,255,255,252,
  // 0x0449  щ
  30,27,216,33,3,249,85,0,0,84,0,1,84,0,255,0,1,253,0,3,252,0,255,0,1,253,0,3,252,0,255,0,1,253,0,3,252,0,255,0,1,253,0,3,252,0,255,0,1,253,0,3,252,0,255,0,1,253,0,3,252,0,255,0,1,253,0,3,252,0,255,0,1,253,0,3,252,0,255,0,1,253,0,3,252,0,255,0,1,253,0,3,252,0,255,0,1,253,0,3,252,0,255,0,1,253,0,3,252,0,255,0,1,253,0,3,252,0,255,0,1,253,0,3,252,0,255,0,1,253,0,3,252,0,255,0,1,253,0,3,252,0,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,11,224,
  // 0x044a  ъ
  24,20,120,25,0,0,21,85,80,0,0,0,191,255,244,0,0,0,191,255,244,0,0,0,106,175,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,254,170,148,0,0,7,255,255,255,128,0,7,255,255,255,240,0,7,249,85,111,252,0,7,244,0,3,253,0,7,244,0,1,253,0,7,244,0,1,253,0,7,244,0,2,253,0,7,244,0,11,252,0,7,255,255,255,244,0,7,255,255,255,208,0,7,255,255,249,0,
  // 0x044b  ы
  23,20,120,29,3,0,85,0,0,0,1,84,255,0,0,0,3,252,255,0,0,0,3,252,255,0,0,0,3,252,255,0,0,0,3,252,255,0,0,0,3,252,255,0,0,0,3,252,255,0,0,0,3,252,255,170,164,0,3,252,255,255,255,208,3,252,255,255,255,248,3,252,255,85,111,253,3,252,255,0,1,254,3,252,255,0,0,255,3,252,255,0,0,255,3,252,255,0,1,254,3,252,255,0,7,253,3,252,255,255,255,252,3,252,255,255,255,224,3,252,255,255,254,64,3,252,
  // 0x044c  ь
  17,20,100,22,3,0,85,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,170,169,0,0,255,255,255,244,0,255,255,255,254,0,255,85,91,255,64,255,0,0,191,128,255,0,0,63,192,255,0,0,63,192,255,0,0,127,128,255,0,1,255,64,255,255,255,254,0,255,255,255,248,0,255,255,255,128,0,
  // 0x044d  э
  15,21,84,18,1,255,6,170,64,0,127,255,253,0,127,255,255,64,62,86,255,208,0,0,47,240,0,0,11,244,0,0,7,248,0,0,3,252,5,85,87,252,11,255,255,252,11,255,255,252,6,170,171,252,0,0,3,252,0,0,3,252,0,0,11,244,0,0,15,240,144,0,127,224,255,239,255,192,255,255,254,0,127,255,228,0,0,84,0,0,
  // 0x044e  ю
  26,21,147,31,3,255,85,0,0,6,169,0,0,255,0,0,191,255,224,0,255,0,3,255,255,252,0,255,0,15,254,91,254,0,255,0,47,240,0,255,64,255,0,63,192,0,63,192,255,0,127,128,0,63,192,255,0,127,64,0,47,208,255,170,255,64,0,31,224,255,255,255,0,0,31,224,255,255,255,0,0,31,224,255,170,255,0,0,31,224,255,0,191,64,0,31,208,255,0,127,128,0,47,208,255,0,63,192,0,63,192,255,0,63,208,0,127,128,255,0,31,244,1,255,0,255,0,11,255,255,253,0,255,0,2,255,255,244,0,255,0,0,111,255,128,0,0,0,0,0,80,0,0,
  // 0x044f  я
  18,20,100,20,0,0,0,1,85,85,64,0,191,255,255,224,3,255,255,255,224,11,254,170,175,224,15,240,0,31,224,31,208,0,31,224,31,208,0,31,224,31,208,0,31,224,15,240,0,31,224,11,255,149,111,224,3,255,255,255,224,0,127,255,255,224,0,31,229,111,224,0,63,192,31,224,0,255,0,31,224,2,254,0,31,224,3,252,0,31,224,15,244,0,31,224,47,224,0,31,224,127,192,0,31,224,
  // 0x0450  ѐ
  255,
  // 0x0451  ё
  17,28,140,21,2,255,0,80,1,64,0,3,248,15,208,0,3,252,15,224,0,2,248,15,208,0,0,80,1,0,0,0,0,0,0,0,0,0,0,0,0,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,
  // 0x0452  ђ
  255,
  // 0x0453  ѓ
  255,
  // 0x0454  є
  15,21,84,18,2,255,0,6,170,64,0,255,255,248,7,255,255,244,31,254,86,240,63,224,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,85,85,64,255,255,255,128,255,255,255,128,255,170,170,64,255,0,0,0,255,0,0,0,191,64,0,0,63,192,0,0,47,244,0,36,15,255,255,248,3,255,255,248,0,127,255,224,0,0,84,0,
  // 0x0455  ѕ
  255,
  // 0x0456  і
  4,27,27,10,3,0,104,255,255,255,40,0,0,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x0457  ї
  11,27,81,10,255,0,4,0,80,63,1,252,127,66,252,63,1,252,4,0,16,0,0,0,0,0,0,0,85,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,
  // 0x0458  ј
  255,
  // 0x0459  љ
  255,
  // 0x045a  њ
  255,
  // 0x045b  ћ
  255,
  // 0x045c  ќ
  255,
  // 0x045d  ѝ
  255,
  // 0x045e  ў
  255,
  // 0x045f  џ
  255,
  // 0x0460  Ѡ
  255,
  // 0x0461  ѡ
  255,
  // 0x0462  Ѣ
  255,
  // 0x0463  ѣ
  255,
  // 0x0464  Ѥ
  255,
  // 0x0465  ѥ
  255,
  // 0x0466  Ѧ
  255,
  // 0x0467  ѧ
  255,
  // 0x0468  Ѩ
  255,
  // 0x0469  ѩ
  255,
  // 0x046a  Ѫ
  255,
  // 0x046b  ѫ
  255,
  // 0x046c  Ѭ
  255,
  // 0x046d  ѭ
  255,
  // 0x046e  Ѯ
  255,
  // 0x046f  ѯ
  255,
  // 0x0470  Ѱ
  255,
  // 0x0471  ѱ
  255,
  // 0x0472  Ѳ
  255,
  // 0x0473  ѳ
  255,
  // 0x0474  Ѵ
  255,
  // 0x0475  ѵ
  255,
  // 0x0476  Ѷ
  255,
  // 0x0477  ѷ
  255,
  // 0x0478  Ѹ
  255,
  // 0x0479  ѹ
  255,
  // 0x047a  Ѻ
  255,
  // 0x047b  ѻ
  255,
  // 0x047c  Ѽ
  255,
  // 0x047d  ѽ
  255,
  // 0x047e  Ѿ
  255,
  // 0x047f  ѿ
  255,
  // 0x0480  Ҁ
  255,
  // 0x0481  ҁ
  255,
  // 0x0482  ҂
  255,
  // 0x0483  ҃
  255,
  // 0x0484  ҄
  255,
  // 0x0485  ҅
  255,
  // 0x0486  ҆
  255,
  // 0x0487  ҇
  255,
  // 0x0488  ҈
  255,
  // 0x0489  ҉
  255,
  // 0x048a  Ҋ
  255,
  // 0x048b  ҋ
  255,
  // 0x048c  Ҍ
  255,
  // 0x048d  ҍ
  255,
  // 0x048e  Ҏ
  255,
  // 0x048f  ҏ
  255,
  // 0x0490  Ґ
  16,31,124,20,3,0,0,0,0,191,0,0,0,191,0,0,0,191,0,0,0,191,0,0,0,191,106,170,170,255,191,255,255,255,191,255,255,255,191,234,170,170,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,
  // 0x0491  ґ
  13,25,100,16,3,0,0,0,63,128,0,0,63,128,0,0,63,128,0,0,63,128,0,0,63,128,85,85,127,128,255,255,255,128,255,255,255,128,255,170,170,64,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,
};

#endif // HAS_GRAPHICAL_TFT
