/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Simplified Chinese 26pt, capital 'A' height: 19px, width: 100%, range: 0x201c-0xff1a, glyphs: 373
extern const uint8_t NotoSans_Medium_Simplified_Chinese_19[58924] = {
  162,19,28,32,26,255,25,249, // unifont_t
  // 0x201c  “
  28,32,10,7,21,10,0,12,6,65,144,15,67,208,31,3,192,47,11,192,62,15,192,125,31,128,125,31,64,
  // 0x201d  ”
  29,32,10,7,21,10,0,12,26,66,144,47,71,208,63,11,192,62,15,192,61,15,64,124,31,0,116,29,0,
  // 0x22bf  ⊿
  191,34,21,21,126,26,2,0,0,0,0,0,0,64,0,0,0,0,3,128,0,0,0,0,15,128,0,0,0,0,63,128,0,0,0,0,255,128,0,0,0,3,255,128,0,0,0,15,203,128,0,0,0,63,11,128,0,0,0,189,11,128,0,0,2,244,11,128,0,0,11,208,11,128,0,0,47,64,11,128,0,0,189,0,11,128,0,2,244,0,11,128,0,11,208,0,11,128,0,47,128,0,11,128,0,126,0,0,11,128,1,248,0,0,11,128,7,224,0,0,11,128,31,255,255,255,255,128,127,255,255,255,255,128,
  // 0x4e00  一
  0,78,24,3,18,26,1,9,170,170,170,170,170,170,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x4e09  三
  9,78,22,21,126,26,2,255,47,255,255,255,255,192,47,255,255,255,255,192,21,85,85,85,85,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,248,0,3,255,255,255,248,0,1,85,85,85,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,240,255,255,255,255,255,240,85,85,85,85,85,80,
  // 0x4e0a  上
  10,78,24,23,138,26,1,255,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,149,85,80,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,85,85,111,149,85,85,191,255,255,255,255,254,191,255,255,255,255,254,
  // 0x4e0b  下
  11,78,24,24,144,26,1,253,21,85,85,85,85,84,127,255,255,255,255,253,127,255,255,255,255,253,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,224,0,0,0,0,15,254,0,0,0,0,15,255,224,0,0,0,15,143,253,0,0,0,15,129,255,128,0,0,15,128,47,240,0,0,15,128,7,224,0,0,15,128,0,128,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,5,64,0,0,
  // 0x4e0d  不
  13,78,24,24,144,26,1,253,21,85,85,85,85,84,63,255,255,255,255,252,63,255,255,255,255,252,0,0,1,248,0,0,0,0,3,240,0,0,0,0,15,208,0,0,0,0,47,208,0,0,0,0,127,214,0,0,0,1,255,239,192,0,0,7,251,219,244,0,0,31,215,209,254,0,0,191,71,208,63,192,3,253,7,208,15,240,47,244,7,208,2,252,191,192,7,208,0,190,61,0,7,208,0,40,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,1,64,0,0,
  // 0x4e13  专
  19,78,23,26,156,26,1,253,0,0,4,0,0,0,0,0,31,0,0,0,0,0,47,0,0,0,1,85,127,85,85,64,7,255,255,255,255,208,7,255,255,255,255,208,0,0,252,0,0,0,0,0,244,0,0,0,21,86,245,85,85,84,127,255,255,255,255,252,127,255,255,255,255,252,0,7,192,0,0,0,0,11,192,0,0,0,0,15,192,0,1,0,0,31,255,255,255,192,0,47,255,255,255,192,0,0,0,0,191,0,0,0,0,2,252,0,0,0,0,7,240,0,0,11,224,31,192,0,0,15,255,191,0,0,0,0,127,253,0,0,0,0,2,255,208,0,0,0,0,31,248,0,0,0,0,1,240,0,0,0,0,0,16,0,
  // 0x4e1d  丝
  29,78,24,23,138,26,1,255,0,15,64,0,60,0,0,31,64,0,124,0,0,47,0,0,248,0,0,61,0,1,240,0,0,188,4,3,224,0,0,244,31,7,192,120,2,224,63,15,128,252,3,192,188,47,2,240,15,128,248,125,3,208,63,255,240,255,255,192,31,255,208,255,255,0,4,15,128,16,125,0,0,63,0,1,244,0,0,188,0,3,224,0,1,244,0,31,128,0,3,224,0,191,255,252,31,255,253,191,255,252,15,255,253,122,84,0,10,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,254,191,255,255,255,255,254,
  // 0x4e2a  个
  42,78,25,24,168,26,1,254,0,0,11,208,0,0,0,0,0,31,240,0,0,0,0,0,63,252,0,0,0,0,0,253,126,0,0,0,0,3,248,47,128,0,0,0,15,224,11,240,0,0,0,63,128,2,252,0,0,0,254,0,0,191,64,0,7,248,0,0,31,224,0,63,208,7,192,7,253,0,255,0,7,192,0,255,64,184,0,7,192,0,30,0,0,0,7,192,0,0,0,0,0,7,192,0,0,0,0,0,7,192,0,0,0,0,0,7,192,0,0,0,0,0,7,192,0,0,0,0,0,7,192,0,0,0,0,0,7,192,0,0,0,0,0,7,192,0,0,0,0,0,7,192,0,0,0,0,0,7,192,0,0,0,0,0,7,192,0,0,0,0,0,7,192,0,0,0,
  // 0x4e2d  中
  45,78,22,26,156,26,2,253,0,0,5,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,21,85,111,85,85,64,127,255,255,255,255,208,127,255,255,255,255,208,124,0,31,0,3,208,124,0,31,0,3,208,124,0,31,0,3,208,124,0,31,0,3,208,124,0,31,0,3,208,124,0,31,0,3,208,125,85,111,85,87,208,127,255,255,255,255,208,127,255,255,255,255,208,124,0,31,0,3,208,104,0,31,0,1,64,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,5,0,0,0,
  // 0x4e3a  为
  58,78,22,26,156,26,2,253,0,0,20,0,0,0,1,0,188,0,0,0,11,192,188,0,0,0,3,224,188,0,0,0,1,244,188,0,0,0,0,244,188,0,0,0,0,0,188,0,0,0,255,255,255,255,255,208,255,255,255,255,255,208,85,85,249,85,91,208,0,0,244,0,3,208,0,1,240,0,3,208,0,2,240,64,7,192,0,3,227,224,7,192,0,7,209,244,7,192,0,15,192,252,7,192,0,31,128,62,11,192,0,63,0,47,11,192,0,189,0,4,11,192,1,252,0,0,15,192,7,240,0,0,15,128,31,208,0,0,31,64,191,64,0,101,127,0,252,0,0,63,255,0,32,0,0,63,248,0,0,0,0,0,0,0,
  // 0x4e3b  主
  59,78,24,24,144,26,1,254,0,0,45,0,0,0,0,0,63,128,0,0,0,0,15,224,0,0,0,0,3,248,0,0,0,0,0,248,0,0,31,255,255,255,255,244,31,255,255,255,255,244,5,85,91,229,85,80,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,1,85,91,229,85,64,3,255,255,255,255,192,3,255,255,255,255,192,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,127,255,255,255,255,254,127,255,255,255,255,254,21,85,85,85,85,84,
  // 0x4e49  义
  73,78,24,24,144,26,1,254,0,0,10,0,0,0,0,0,15,64,0,0,0,0,15,128,3,144,1,128,7,192,3,224,3,208,3,224,11,192,2,240,1,240,15,192,0,244,0,224,31,64,0,252,0,0,63,0,0,125,0,0,125,0,0,47,0,0,252,0,0,15,128,2,244,0,0,11,208,3,224,0,0,3,240,15,192,0,0,0,252,63,64,0,0,0,127,190,0,0,0,0,47,248,0,0,0,0,15,244,0,0,0,0,127,254,0,0,0,2,254,127,192,0,0,31,244,15,248,0,1,255,128,2,255,128,111,252,0,0,127,253,191,144,0,0,7,253,56,0,0,0,0,40,
  // 0x4e4b  之
  75,78,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,5,85,91,213,85,64,31,255,255,255,255,244,31,255,255,255,255,240,0,0,0,0,11,208,0,0,0,0,31,128,0,0,0,0,63,0,0,0,0,0,253,0,0,0,0,3,244,0,0,0,0,11,224,0,0,0,0,47,192,0,0,180,0,191,0,0,0,248,2,252,0,0,1,244,11,240,0,0,3,252,63,192,0,0,7,254,254,0,0,0,15,239,244,0,0,0,47,79,244,0,0,0,63,2,255,234,85,85,253,0,63,255,255,254,120,0,1,191,255,253,0,0,0,0,0,0,
  // 0x4e86  了
  134,78,21,24,144,26,2,253,21,85,85,85,85,0,127,255,255,255,255,128,127,255,255,255,255,128,0,0,0,0,254,0,0,0,0,3,252,0,0,0,0,15,240,0,0,0,0,127,128,0,0,0,6,254,0,0,0,0,15,244,0,0,0,0,15,192,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,31,64,0,0,0,127,255,0,0,0,0,63,254,0,0,0,0,21,80,0,0,0,
  // 0x4e8c  二
  140,78,24,19,114,26,1,0,2,170,170,170,170,128,7,255,255,255,255,208,7,255,255,255,255,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,170,170,170,170,169,127,255,255,255,255,253,127,255,255,255,255,253,
  // 0x4e8e  于
  142,78,24,23,138,26,1,254,5,85,85,85,85,80,11,255,255,255,255,224,11,255,255,255,255,224,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,127,255,255,255,255,254,127,255,255,255,255,254,21,85,87,229,85,84,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,10,91,208,0,0,0,15,255,192,0,0,0,11,254,0,0,0,
  // 0x4ea4  交
  164,78,24,26,156,26,1,253,0,0,2,128,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,21,85,85,85,85,84,0,7,128,1,224,0,0,31,192,3,252,0,0,127,64,0,191,64,1,253,0,0,31,224,11,244,0,1,7,248,127,199,192,3,225,253,47,3,224,7,208,120,4,2,240,15,192,0,0,0,252,47,64,0,0,0,190,126,0,0,0,0,63,252,0,0,0,0,15,240,0,0,0,0,47,248,0,0,0,1,255,255,64,0,0,47,248,63,248,0,27,255,208,7,255,228,191,253,0,0,191,254,63,64,0,0,6,252,0,0,0,0,0,0,
  // 0x4eae  亮
  174,78,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,0,0,0,0,0,170,170,170,170,0,0,255,255,255,255,0,0,248,0,0,47,0,0,248,0,0,47,0,0,254,170,170,191,0,0,255,255,255,255,0,0,0,0,0,0,0,63,255,255,255,255,252,63,255,255,255,255,252,60,0,0,0,0,60,60,3,224,31,0,60,60,3,208,31,0,60,0,3,208,31,0,0,0,11,192,31,0,0,0,15,192,31,0,36,0,63,64,31,0,46,6,253,0,31,64,61,191,244,0,31,255,252,63,64,0,11,255,244,0,0,0,0,0,0,
  // 0x4ece  从
  206,78,24,23,138,26,1,254,0,31,0,3,224,0,0,47,0,3,224,0,0,47,0,3,208,0,0,47,0,3,208,0,0,47,0,3,208,0,0,63,0,7,224,0,0,62,0,7,224,0,0,62,0,7,240,0,0,62,0,11,240,0,0,126,0,15,240,0,0,127,64,15,244,0,0,191,208,31,248,0,0,255,240,47,188,0,0,249,252,63,61,0,1,244,189,126,63,0,2,240,62,252,47,64,3,240,25,248,15,192,11,208,3,244,15,208,15,192,11,224,3,240,47,128,47,192,2,252,127,0,191,64,0,255,189,0,125,0,0,61,24,0,20,0,0,4,
  // 0x4ee4  令
  228,78,24,26,156,26,1,253,0,0,1,64,0,0,0,0,15,224,0,0,0,0,63,244,0,0,0,0,190,253,0,0,0,1,252,63,64,0,0,7,240,15,208,0,0,31,208,7,244,0,0,191,64,1,254,0,2,253,0,0,127,192,31,251,255,255,239,248,191,71,255,255,210,255,124,0,0,0,0,125,16,0,0,0,0,4,0,0,0,0,0,0,11,255,255,255,255,192,11,255,255,255,255,192,0,0,61,0,11,192,0,0,61,0,11,192,0,0,61,0,11,192,0,0,61,0,11,192,0,0,61,0,11,192,0,0,61,7,255,128,0,0,61,3,255,0,0,0,61,0,80,0,0,0,61,0,0,0,0,0,20,0,0,0,
  // 0x4ee5  以
  229,78,24,23,138,26,1,254,1,80,0,0,1,64,3,224,0,0,7,208,3,224,24,0,7,192,3,224,126,0,11,192,3,224,63,64,11,192,3,224,15,192,15,128,3,224,7,224,15,128,3,224,3,240,31,64,3,224,0,244,47,0,2,240,0,64,63,0,2,240,0,0,62,0,2,240,0,0,188,0,2,240,0,0,252,0,2,240,20,2,244,0,2,241,252,3,248,0,2,255,252,15,253,0,7,255,144,63,191,64,191,248,0,255,15,208,191,64,7,252,7,244,116,0,47,240,1,252,0,2,255,128,0,191,0,3,253,0,0,62,0,0,208,0,0,8,
  // 0x4ef6  件
  246,78,24,25,150,26,1,253,0,46,0,11,192,0,0,62,14,11,192,0,0,124,31,11,192,0,0,252,47,11,192,0,1,244,62,11,192,0,3,240,63,255,255,248,11,208,127,255,255,248,15,208,253,91,213,80,63,208,244,11,192,0,191,211,240,11,192,0,251,208,208,11,192,0,115,208,0,11,192,0,3,209,85,91,213,85,3,210,255,255,255,255,3,210,255,255,255,255,3,208,0,11,192,0,3,208,0,11,192,0,3,208,0,11,192,0,3,208,0,11,192,0,3,208,0,11,192,0,3,208,0,11,192,0,3,208,0,11,192,0,3,208,0,11,192,0,3,208,0,11,192,0,1,64,0,1,64,0,
  // 0x4efd  份
  253,78,25,26,182,26,0,253,0,1,0,0,0,0,0,0,15,128,63,255,64,0,0,15,64,63,255,128,0,0,47,2,80,11,192,0,0,61,3,208,3,192,0,0,188,7,192,3,224,0,1,244,15,128,1,240,0,3,244,31,0,0,248,0,11,244,62,0,0,188,0,31,244,188,0,0,63,0,127,246,244,0,0,31,192,61,247,239,255,255,255,128,36,244,143,255,255,242,0,0,244,0,62,2,240,0,0,244,0,61,1,240,0,0,244,0,61,1,240,0,0,244,0,60,2,240,0,0,244,0,188,2,240,0,0,244,0,248,2,240,0,0,244,1,240,2,240,0,0,244,3,224,3,224,0,0,244,11,192,3,224,0,0,244,47,64,87,208,0,0,244,190,0,255,192,0,0,244,56,0,255,64,0,0,0,0,0,0,0,0,
  // 0x4f11  休
  17,79,24,25,150,26,1,253,0,15,64,15,64,0,0,31,64,15,128,0,0,47,0,15,128,0,0,62,0,15,128,0,0,252,0,15,128,0,1,248,0,15,128,0,3,241,85,95,149,84,11,243,255,255,255,254,31,243,255,255,255,254,127,240,0,63,240,0,254,240,0,191,244,0,245,240,0,255,252,0,97,240,2,255,189,0,1,240,3,223,159,0,1,240,15,207,143,128,1,240,31,79,135,192,1,240,62,15,131,240,1,240,252,15,129,248,1,243,244,15,128,190,1,251,224,15,128,63,1,242,128,15,128,12,1,240,0,15,128,0,1,240,0,15,128,0,1,240,0,15,128,0,0,80,0,5,0,0,
  // 0x4f20  传
  32,79,25,25,175,26,0,253,0,11,128,11,192,0,0,0,15,128,15,128,0,0,0,31,0,15,128,0,0,0,62,63,255,255,254,0,0,124,63,255,255,254,0,0,248,0,62,0,0,0,2,244,0,61,0,0,0,7,244,0,125,0,0,0,15,245,255,255,255,255,192,63,245,255,255,255,255,192,126,244,0,244,0,0,0,44,244,1,240,0,0,0,0,244,2,240,0,16,0,0,244,3,255,255,253,0,0,244,7,255,255,252,0,0,244,0,0,3,240,0,0,244,0,0,15,192,0,0,244,0,16,47,64,0,0,244,0,189,189,0,0,0,244,0,63,248,0,0,0,244,0,11,244,0,0,0,244,0,1,253,0,0,0,244,0,0,127,64,0,0,244,0,0,14,0,0,0,80,0,0,0,0,0,
  // 0x4f4d  位
  77,79,24,25,150,26,1,253,0,31,0,15,128,0,0,63,0,15,128,0,0,61,0,15,128,0,0,252,0,15,128,0,1,244,85,95,149,84,3,240,255,255,255,253,11,224,255,255,255,253,31,224,0,0,0,0,63,224,1,0,2,64,255,224,15,0,7,208,250,224,15,64,11,192,162,224,15,128,11,192,2,224,11,192,15,128,2,224,7,192,15,64,2,224,3,192,31,0,2,224,3,208,47,0,2,224,3,224,62,0,2,224,2,224,61,0,2,224,2,240,124,0,2,224,1,144,184,0,2,224,85,85,249,85,2,227,255,255,255,255,2,227,255,255,255,255,2,224,0,0,0,0,0,80,0,0,0,0,
  // 0x4f4e  低
  78,79,26,24,168,26,0,254,0,11,128,0,0,16,0,0,15,64,0,27,252,0,0,47,21,175,255,249,0,0,62,47,255,253,64,0,0,188,47,148,188,0,0,0,248,47,0,124,0,0,2,244,47,0,124,0,0,7,244,47,0,124,0,0,15,244,47,0,125,0,0,63,244,47,255,255,255,192,125,244,47,255,255,255,192,40,244,47,0,61,0,0,0,244,47,0,62,0,0,0,244,47,0,47,0,0,0,244,47,0,31,0,0,0,244,47,0,31,0,0,0,244,47,1,79,64,0,0,244,47,191,223,129,64,0,244,255,255,215,194,208,0,244,255,164,3,210,192,0,244,80,0,2,243,192,0,244,0,0,0,255,128,0,244,127,255,253,47,0,0,244,127,255,253,0,0,
  // 0x4f53  体
  83,79,24,26,156,26,1,253,0,0,0,5,0,0,0,61,0,15,64,0,0,124,0,15,64,0,0,248,0,15,64,0,0,244,0,15,64,0,2,241,85,95,85,84,3,211,255,255,255,254,15,211,255,255,255,254,31,208,0,191,240,0,63,208,0,255,240,0,255,208,1,255,248,0,251,208,3,223,124,0,115,208,7,207,110,0,3,208,15,79,79,0,3,208,47,15,75,192,3,208,61,15,67,208,3,208,252,15,66,240,3,210,240,15,64,252,3,219,239,255,255,191,3,219,143,255,255,46,3,210,0,31,64,4,3,208,0,15,64,0,3,208,0,15,64,0,3,208,0,15,64,0,3,208,0,15,64,0,1,64,0,0,0,0,
  // 0x4f59  余
  89,79,24,26,156,26,1,253,0,0,1,64,0,0,0,0,15,224,0,0,0,0,63,248,0,0,0,0,254,190,0,0,0,3,248,63,128,0,0,15,224,15,240,0,0,127,128,2,253,0,2,253,0,0,191,128,47,248,0,0,47,248,255,127,255,255,250,255,56,63,255,255,248,60,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,31,255,255,255,255,248,31,255,255,255,255,248,5,85,91,213,85,80,0,0,7,192,16,0,0,62,7,192,184,0,0,252,7,192,191,0,3,240,7,192,31,192,31,208,7,192,7,240,191,64,7,192,1,252,60,3,255,192,0,120,0,2,255,64,0,0,0,0,80,0,0,0,
  // 0x4f5c  作
  92,79,24,25,150,26,1,253,0,15,0,180,0,0,0,47,0,248,0,0,0,61,1,240,0,0,0,188,3,224,0,0,0,248,7,255,255,255,2,240,15,255,255,255,7,240,31,95,149,85,15,240,62,15,64,0,47,240,188,15,64,0,127,241,248,15,64,0,255,242,240,15,255,253,118,240,128,15,255,253,18,240,0,15,64,0,2,240,0,15,64,0,2,240,0,15,64,0,2,240,0,15,64,0,2,240,0,15,255,254,2,240,0,15,255,254,2,240,0,15,64,0,2,240,0,15,64,0,2,240,0,15,64,0,2,240,0,15,64,0,2,240,0,15,64,0,2,240,0,15,64,0,0,80,0,5,0,0,
  // 0x4f7f  使
  127,79,24,25,150,26,1,253,0,31,0,11,128,0,0,63,0,11,128,0,0,62,0,11,192,0,0,190,255,255,255,255,1,245,255,255,255,255,3,240,0,11,128,0,11,224,0,11,128,0,31,224,255,255,255,252,63,224,255,255,255,252,255,224,244,11,192,60,250,224,244,11,128,60,178,224,244,11,128,60,2,224,244,11,128,60,2,224,255,255,255,252,2,224,255,255,255,252,2,224,16,15,64,0,2,224,188,15,64,0,2,224,63,31,0,0,2,224,15,254,0,0,2,224,3,252,0,0,2,224,3,255,144,0,2,224,47,239,254,64,2,227,255,65,255,255,2,226,248,0,10,253,1,144,64,0,0,4,
  // 0x4f9b  供
  155,79,24,25,150,26,1,253,0,46,3,208,15,0,0,62,3,208,15,0,0,124,3,208,15,0,0,248,3,208,15,0,1,240,3,208,15,0,3,224,255,255,255,254,11,208,255,255,255,254,31,208,87,229,95,84,63,208,3,208,15,0,255,208,3,208,15,0,251,208,3,208,15,0,179,208,3,208,15,0,3,208,3,208,15,0,3,209,87,229,111,85,3,211,255,255,255,255,3,211,255,255,255,255,3,208,0,0,0,0,3,208,1,64,1,0,3,208,7,224,31,0,3,208,15,192,15,192,3,208,63,0,3,240,3,208,253,0,0,248,3,211,248,0,0,189,3,208,224,0,0,60,1,64,0,0,0,0,
  // 0x4fb5  侵
  181,79,25,25,175,26,0,253,0,11,64,0,0,0,0,0,15,143,255,255,252,0,0,31,15,255,255,252,0,0,62,0,0,0,124,0,0,124,7,255,255,252,0,0,248,11,255,255,252,0,2,244,0,0,0,124,0,3,244,0,0,0,124,0,15,244,31,255,255,252,0,63,244,31,255,255,252,0,126,244,0,0,0,0,0,60,244,191,255,255,255,128,0,244,255,255,255,255,128,0,244,244,0,0,11,128,0,244,244,0,0,11,128,0,244,255,255,255,255,128,0,244,15,255,255,244,0,0,244,1,240,3,224,0,0,244,0,252,15,192,0,0,244,0,63,191,0,0,0,244,0,15,252,0,0,0,244,1,191,255,144,0,0,244,191,254,111,255,128,0,244,127,144,1,191,64,0,80,16,0,0,1,0,
  // 0x4fdd  保
  221,79,24,25,150,26,1,253,0,31,0,0,0,0,0,47,63,255,255,244,0,61,63,255,255,244,0,188,60,0,0,244,0,244,60,0,0,244,2,240,60,0,0,244,7,224,60,0,0,244,15,224,61,0,0,244,47,224,63,255,255,244,191,224,63,255,255,244,254,224,0,11,128,0,178,224,0,11,128,0,18,224,0,11,192,0,2,227,255,255,255,255,2,227,255,255,255,255,2,224,0,127,244,0,2,224,0,255,252,0,2,224,3,251,239,0,2,224,15,203,143,192,2,224,63,11,131,240,2,225,253,11,129,253,2,231,244,11,128,127,2,226,208,11,128,29,2,224,0,11,128,0,0,80,0,5,64,0,
  // 0x4fe1  信
  225,79,24,25,150,26,1,253,0,30,0,0,0,0,0,47,15,255,255,224,0,61,15,255,255,224,0,188,0,0,0,0,0,248,0,0,0,0,3,242,255,255,255,255,11,226,255,255,255,255,31,224,0,0,0,0,127,224,47,255,255,240,254,224,47,255,255,240,246,224,0,0,0,0,162,224,0,0,0,0,2,224,47,255,255,240,2,224,47,255,255,240,2,224,0,0,0,0,2,224,0,0,0,0,2,224,63,255,255,244,2,224,63,255,255,244,2,224,61,0,0,244,2,224,61,0,0,244,2,224,61,0,0,244,2,224,63,255,255,244,2,224,63,255,255,244,2,224,61,0,0,244,0,0,4,0,0,0,
  // 0x503c  值
  60,80,24,26,156,26,1,253,0,0,0,5,64,0,0,46,0,11,192,0,0,61,0,15,128,0,0,189,255,255,255,252,0,249,255,255,255,252,1,240,0,31,0,0,3,224,0,31,0,0,11,208,0,46,0,0,15,192,63,255,255,224,63,192,63,255,255,224,191,192,60,0,2,224,251,192,63,170,171,224,115,192,63,255,255,224,3,192,60,0,2,224,3,192,60,0,2,224,3,192,62,170,171,224,3,192,63,255,255,224,3,192,60,0,2,224,3,192,60,0,2,224,3,192,63,255,255,224,3,192,62,170,171,224,3,192,60,0,2,224,3,192,60,0,2,224,3,199,255,255,255,255,3,199,255,255,255,255,2,128,0,0,0,0,
  // 0x503e  倾
  62,80,25,25,175,26,0,253,0,61,0,0,0,0,0,0,124,0,63,255,255,192,0,188,160,63,255,255,192,0,244,240,0,31,0,0,1,240,240,0,46,0,0,3,240,240,0,61,0,0,7,240,240,15,255,254,0,15,240,240,15,255,254,0,31,240,255,207,0,30,0,63,240,255,207,14,30,0,126,240,240,15,14,30,0,57,240,240,15,14,30,0,17,240,240,15,14,30,0,1,240,240,15,14,30,0,1,240,240,15,14,30,0,1,240,240,143,30,30,0,1,240,251,207,30,30,0,1,241,255,79,45,30,0,1,242,248,5,60,4,0,1,240,208,0,189,192,0,1,240,0,1,246,244,0,1,240,0,7,224,190,0,1,240,0,47,128,31,128,1,240,0,125,0,7,64,0,80,0,16,0,0,0,
  // 0x504f  偏
  79,80,25,25,175,26,0,253,0,31,0,0,0,0,0,0,46,191,255,255,255,192,0,61,191,255,255,255,192,0,124,0,0,0,0,0,0,248,0,0,0,0,0,1,244,47,255,255,255,0,3,240,47,255,255,255,0,7,240,46,0,0,47,0,15,240,46,0,0,47,0,63,240,47,255,255,255,0,126,240,47,255,255,255,0,60,240,46,0,0,0,0,36,240,45,0,0,0,0,0,240,63,255,255,255,64,0,240,63,255,255,255,64,0,240,63,195,75,15,64,0,240,127,195,75,15,64,0,240,191,255,255,255,64,0,240,251,255,255,255,64,0,241,243,195,75,15,64,0,243,227,195,75,15,64,0,247,195,195,75,15,64,0,243,131,195,75,191,64,0,240,3,195,75,62,0,0,0,0,0,0,0,0,
  // 0x505c  停
  92,80,25,26,182,26,0,253,0,0,0,1,64,0,0,0,11,128,3,224,0,0,0,15,64,3,224,0,0,0,47,191,255,255,255,192,0,61,191,255,255,255,192,0,188,0,0,0,0,0,0,248,10,170,170,168,0,3,244,15,255,255,252,0,7,244,15,64,0,124,0,15,244,15,64,0,124,0,63,244,15,234,170,252,0,126,244,15,255,255,252,0,60,244,0,0,0,0,0,0,244,255,255,255,255,192,0,244,255,255,255,255,192,0,244,240,0,0,3,192,0,244,240,0,0,3,192,0,244,243,255,255,243,192,0,244,83,255,255,240,0,0,244,0,3,224,0,0,0,244,0,3,224,0,0,0,244,0,3,224,0,0,0,244,0,3,224,0,0,0,244,1,255,208,0,0,0,244,0,255,192,0,0,0,0,0,0,0,0,0,
  // 0x50a8  储
  168,80,24,25,150,26,1,253,0,240,0,3,208,0,0,240,0,3,208,62,1,231,192,3,208,60,3,211,240,255,255,184,3,192,248,255,255,244,11,128,120,3,210,224,15,128,16,3,215,192,47,128,0,3,223,128,63,175,243,255,255,255,255,175,243,255,255,255,255,133,240,2,240,0,155,128,240,11,192,0,11,128,240,63,255,252,11,128,241,255,255,252,11,128,243,254,0,124,11,128,240,94,0,124,11,128,240,30,0,124,11,128,240,31,255,252,11,128,241,31,255,252,11,128,251,158,0,124,11,129,255,94,0,124,11,131,248,31,255,252,11,129,192,31,255,252,11,128,0,30,0,124,1,0,0,4,0,0,
  // 0x50cf  像
  207,80,25,26,182,26,0,253,0,0,0,64,0,0,0,0,31,1,240,0,0,0,0,46,3,255,253,0,0,0,61,11,255,255,0,0,0,188,47,0,125,0,0,0,248,125,0,248,0,0,1,242,255,255,255,255,0,3,242,254,171,250,191,0,11,240,124,3,208,31,0,15,240,60,3,208,31,0,63,240,62,171,250,191,0,126,240,63,255,255,255,0,60,240,0,190,60,0,0,16,240,11,252,45,11,0,0,241,255,111,31,63,64,0,240,244,47,207,253,0,0,240,1,251,219,224,0,0,240,47,210,247,192,0,0,241,254,7,243,240,0,0,240,144,47,241,244,0,0,240,1,252,244,189,0,0,240,31,208,240,63,128,0,242,254,2,240,15,128,0,241,224,255,208,2,0,0,240,0,191,64,0,0,0,0,0,0,0,0,0,
  // 0x5145  充
  69,81,24,25,150,26,1,253,0,0,7,192,0,0,0,0,7,192,0,0,21,85,91,213,85,84,63,255,255,255,255,252,63,255,255,255,255,252,0,1,244,0,64,0,0,3,240,7,208,0,0,7,208,3,244,0,0,11,192,0,253,0,0,15,128,0,127,64,31,255,255,255,255,208,31,255,255,255,255,240,10,170,85,80,1,252,0,1,160,10,64,160,0,3,224,15,64,0,0,3,224,15,64,0,0,3,208,15,64,0,0,7,208,15,64,0,0,15,192,15,64,29,0,47,64,15,64,31,0,191,0,15,64,31,7,252,0,15,128,46,191,240,0,15,255,253,63,64,0,7,255,248,16,0,0,0,21,64,
  // 0x5148  先
  72,81,24,26,156,26,1,253,0,0,1,64,0,0,0,40,3,192,0,0,0,61,3,192,0,0,0,188,3,192,0,0,0,253,87,213,85,64,0,255,255,255,255,208,2,255,255,255,255,208,3,224,3,192,0,0,11,192,3,192,0,0,15,128,3,192,0,0,7,0,3,192,0,0,0,0,3,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,21,87,229,95,149,84,0,3,208,15,64,0,0,7,208,15,64,0,0,11,192,15,64,0,0,15,192,15,64,0,0,31,64,15,64,40,0,63,0,15,64,46,0,253,0,15,64,46,11,248,0,15,213,125,127,224,0,11,255,252,63,0,0,2,255,244,4,0,0,0,0,0,
  // 0x5149  光
  73,81,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,2,192,7,192,3,208,3,224,7,192,7,208,2,240,7,192,15,192,0,248,7,192,31,64,0,188,7,192,63,0,0,61,7,192,125,0,0,61,7,192,120,0,0,0,7,192,0,0,21,85,91,213,85,84,191,255,255,255,255,254,191,255,255,255,255,254,0,3,224,15,64,0,0,3,208,15,64,0,0,3,208,15,64,0,0,7,192,15,64,0,0,15,192,15,64,0,0,15,128,15,64,0,0,47,0,15,64,29,0,127,0,15,64,31,2,252,0,15,64,47,31,244,0,15,128,62,255,192,0,15,255,253,61,0,0,7,255,248,0,0,0,0,21,64,
  // 0x5165  入
  101,81,24,24,144,26,1,253,0,63,255,224,0,0,0,63,255,224,0,0,0,21,87,224,0,0,0,0,2,224,0,0,0,0,2,240,0,0,0,0,6,240,0,0,0,0,15,240,0,0,0,0,31,244,0,0,0,0,47,248,0,0,0,0,63,188,0,0,0,0,62,125,0,0,0,0,188,62,0,0,0,0,252,47,0,0,0,2,244,15,128,0,0,3,240,11,208,0,0,15,208,3,240,0,0,47,192,2,252,0,0,127,0,0,254,0,1,253,0,0,63,128,11,248,0,0,31,240,63,224,0,0,7,253,191,128,0,0,1,254,45,0,0,0,0,56,0,0,0,0,0,0,
  // 0x5168  全
  104,81,24,25,150,26,1,254,0,0,5,64,0,0,0,0,15,240,0,0,0,0,63,248,0,0,0,0,189,190,0,0,0,2,248,63,128,0,0,11,224,15,224,0,0,63,128,3,248,0,0,254,0,0,191,64,7,244,0,0,31,224,63,208,0,0,7,253,255,191,255,255,255,254,56,191,255,255,254,28,0,0,7,208,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,3,255,255,255,255,128,3,255,255,255,255,128,0,0,7,208,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,208,0,0,63,255,255,255,255,252,63,255,255,255,255,252,
  // 0x5171  共
  113,81,24,25,150,26,1,253,0,15,128,2,240,0,0,15,128,2,240,0,0,15,128,2,240,0,0,15,128,2,240,0,0,15,128,2,240,0,47,255,255,255,255,252,47,255,255,255,255,252,5,95,213,87,245,84,0,15,128,2,240,0,0,15,128,2,240,0,0,15,128,2,240,0,0,15,128,2,240,0,0,15,128,2,240,0,21,95,213,87,245,85,191,255,255,255,255,254,191,255,255,255,255,254,0,0,0,0,0,0,0,2,0,1,128,0,0,11,224,11,240,0,0,63,128,2,253,0,0,254,0,0,127,64,11,248,0,0,31,224,63,208,0,0,3,252,47,0,0,0,0,248,0,0,0,0,0,0,
  // 0x5173  关
  115,81,18,25,125,26,4,253,2,128,0,62,0,7,208,0,125,0,3,240,0,252,0,0,244,1,244,0,0,184,3,224,0,5,165,85,149,0,47,255,255,255,128,47,255,255,255,128,0,1,240,0,0,0,1,240,0,0,0,1,240,0,0,0,1,240,0,0,191,255,255,255,224,191,255,255,255,224,21,87,253,85,64,0,3,252,0,0,0,7,254,0,0,0,15,223,64,0,0,47,79,192,0,0,126,7,240,0,2,252,2,253,0,31,240,0,191,144,255,128,0,31,240,188,0,0,3,192,16,0,0,0,0,
  // 0x5177  具
  119,81,24,24,144,26,1,253,0,191,255,255,255,0,0,191,255,255,255,0,0,184,0,0,47,0,0,184,0,0,47,0,0,191,255,255,255,0,0,191,255,255,255,0,0,184,0,0,47,0,0,184,0,0,47,0,0,191,255,255,255,0,0,191,255,255,255,0,0,184,0,0,47,0,0,184,0,0,47,0,0,191,255,255,255,0,0,191,255,255,255,0,0,0,0,0,0,0,127,255,255,255,255,253,127,255,255,255,255,253,21,85,85,85,85,84,0,7,192,3,208,0,0,127,240,15,254,0,11,255,64,1,255,224,127,244,0,0,27,253,46,64,0,0,1,244,0,0,0,0,0,0,
  // 0x5197  冗
  151,81,24,24,144,26,1,253,21,85,85,85,85,84,63,255,255,255,255,252,63,255,255,255,255,252,62,0,0,0,0,188,62,0,0,0,0,188,62,0,0,0,0,188,62,0,0,0,0,188,0,15,255,255,224,0,0,15,255,255,224,0,0,15,213,87,224,0,0,15,192,3,224,0,0,15,192,3,224,0,0,15,192,3,224,0,0,15,128,3,224,0,0,15,128,3,224,0,0,15,64,3,224,0,0,47,0,3,224,24,0,63,0,3,224,31,0,253,0,3,224,31,3,248,0,3,224,47,47,240,0,3,245,126,191,128,0,2,255,253,61,0,0,0,191,244,0,0,0,0,0,0,
  // 0x51b7  冷
  183,81,24,25,150,26,1,253,0,0,0,63,0,0,24,0,0,191,192,0,126,0,1,251,224,0,63,192,3,242,248,0,11,240,15,192,190,0,2,240,63,64,63,128,0,128,253,0,15,224,0,3,252,0,7,253,0,31,239,255,252,191,0,63,79,255,252,29,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,255,255,255,240,0,249,255,255,255,240,3,240,0,248,1,240,7,208,0,248,1,240,15,192,0,248,1,240,47,64,0,248,1,240,127,0,0,248,22,240,252,0,0,248,127,240,56,0,0,248,63,128,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,80,0,0,
  // 0x51c6  准
  198,81,24,25,150,26,1,253,0,0,3,208,46,0,8,0,7,192,62,0,63,0,15,128,61,0,47,208,31,64,188,0,7,244,63,0,248,0,0,244,127,255,255,253,0,32,255,255,255,253,0,2,253,1,240,0,0,7,253,1,240,0,0,31,253,1,240,0,0,15,63,255,255,248,0,1,63,255,255,248,0,0,62,1,240,0,0,80,61,1,240,0,0,240,61,1,240,0,2,244,62,1,240,0,3,224,63,255,255,248,11,192,63,255,255,248,31,128,61,1,240,0,63,0,61,1,240,0,253,0,61,1,240,0,120,0,63,255,255,255,0,0,63,255,255,255,0,0,62,0,0,0,0,0,20,0,0,0,
  // 0x51fa  出
  250,81,20,25,125,26,3,253,0,0,124,0,0,0,0,124,0,0,61,0,124,0,124,61,0,124,0,124,61,0,124,0,124,61,0,124,0,124,61,0,124,0,124,61,0,124,0,124,61,0,124,0,124,63,255,255,255,252,63,255,255,255,252,21,85,189,85,84,0,0,124,0,0,244,0,124,0,31,244,0,124,0,31,244,0,124,0,31,244,0,124,0,31,244,0,124,0,31,244,0,124,0,31,244,0,124,0,31,249,85,189,85,111,255,255,255,255,255,255,255,255,255,255,244,0,0,0,31,80,0,0,0,5,
  // 0x51fb  击
  251,81,24,26,156,26,1,253,0,0,1,64,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,1,85,87,229,85,80,7,255,255,255,255,224,7,255,255,255,255,224,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,127,255,255,255,255,253,127,255,255,255,255,253,21,85,91,229,85,84,0,0,3,208,0,0,2,128,3,208,2,128,3,208,3,208,7,192,3,208,3,208,7,192,3,208,3,208,7,192,3,208,3,208,7,192,3,208,3,208,7,192,3,229,87,229,91,192,3,255,255,255,255,192,3,255,255,255,255,192,0,0,0,0,7,192,0,0,0,0,1,64,
  // 0x5206  分
  6,82,24,25,150,26,1,253,0,2,128,2,128,0,0,7,224,7,208,0,0,15,192,3,240,0,0,31,128,1,248,0,0,63,0,0,189,0,0,189,0,0,63,0,2,248,0,0,31,192,7,240,0,0,11,240,31,208,0,0,3,252,191,213,85,85,85,255,254,255,255,255,255,126,52,255,255,255,255,8,0,0,61,0,31,0,0,0,124,0,47,0,0,0,188,0,47,0,0,0,252,0,47,0,0,1,248,0,47,0,0,3,240,0,62,0,0,7,224,0,62,0,0,15,192,0,62,0,0,127,64,0,61,0,2,254,0,0,188,0,47,244,0,255,252,0,15,128,0,255,240,0,4,0,0,21,0,0,
  // 0x5207  切
  7,82,24,25,150,26,1,253,2,128,0,0,0,0,3,192,0,0,0,0,3,192,47,255,255,253,3,192,47,255,255,253,3,192,5,111,85,125,3,192,0,31,0,61,3,193,188,31,0,61,11,255,252,31,0,61,255,255,164,31,0,61,255,208,0,47,0,60,67,192,0,47,0,124,3,192,0,62,0,124,3,192,0,62,0,124,3,192,0,61,0,124,3,192,116,124,0,124,3,192,184,188,0,124,3,208,244,248,0,188,3,255,241,244,0,188,2,255,227,240,0,252,0,21,11,208,0,248,0,0,47,192,0,248,0,0,191,1,87,244,0,2,252,1,255,240,0,0,240,0,255,128,0,0,0,0,0,0,
  // 0x521b  创
  27,82,23,26,156,26,1,253,0,1,0,0,0,0,0,7,192,0,0,184,0,15,192,0,0,184,0,31,224,1,80,184,0,62,248,2,224,184,0,188,126,2,224,184,1,240,47,66,224,184,7,208,11,210,224,184,31,128,3,242,224,184,126,0,0,242,224,184,255,255,255,194,224,184,59,255,255,66,224,184,7,192,15,66,224,184,7,192,15,2,224,184,7,192,15,2,224,184,7,192,31,2,224,184,7,192,47,2,224,184,7,199,254,2,224,184,7,195,248,1,144,184,7,192,0,128,0,184,7,192,0,240,0,184,7,192,0,240,0,184,3,208,2,240,0,184,3,255,255,208,255,248,1,255,255,128,191,240,0,0,0,0,21,0,
  // 0x521d  初
  29,82,24,26,156,26,1,253,0,80,0,0,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,244,15,255,255,253,0,244,15,255,255,253,0,248,5,95,149,125,191,255,224,15,64,61,191,255,208,15,0,61,0,7,192,31,0,61,0,15,128,31,0,61,0,47,0,31,0,60,0,125,56,47,0,124,0,252,244,47,0,124,3,255,208,62,0,124,11,255,192,61,0,124,47,251,208,61,0,124,254,246,240,124,0,124,248,244,224,252,0,188,32,244,0,244,0,188,0,244,2,240,0,188,0,244,7,224,0,248,0,244,15,192,0,248,0,244,127,65,86,244,0,244,254,1,255,240,0,244,56,0,255,128,0,80,0,0,0,0,
  // 0x522b  别
  43,82,23,25,150,26,1,253,0,0,0,0,0,184,47,255,255,0,0,184,47,255,255,0,0,184,46,0,31,3,208,184,46,0,31,3,208,184,46,0,31,3,208,184,46,0,31,3,208,184,46,0,47,3,208,184,47,255,255,3,208,184,47,255,255,3,208,184,0,20,0,3,208,184,0,60,0,3,208,184,0,124,0,3,208,184,127,255,255,67,208,184,127,255,255,67,208,184,0,184,15,67,208,184,0,248,15,3,208,184,0,244,15,3,208,184,1,240,31,0,0,184,3,224,31,0,0,184,11,208,47,0,0,184,31,132,126,0,0,184,191,15,253,0,191,248,120,11,248,0,127,240,16,0,0,0,21,0,
  // 0x5230  到
  48,82,23,25,150,26,1,253,0,0,0,0,0,104,191,255,255,224,0,124,191,255,255,224,0,124,0,252,0,7,192,124,0,244,0,7,192,124,1,240,124,7,192,124,3,224,62,7,192,124,3,208,15,71,192,124,27,255,255,199,192,124,191,255,255,231,192,124,186,149,1,247,192,124,0,15,0,71,192,124,0,15,0,7,192,124,0,15,0,7,192,124,63,255,255,135,192,124,63,255,255,135,192,124,0,31,64,7,192,124,0,15,0,6,128,124,0,15,0,0,0,124,0,15,0,80,0,124,0,111,255,224,0,124,191,255,255,224,0,188,255,255,164,0,191,252,101,0,0,0,127,240,0,0,0,0,21,64,
  // 0x5236  制
  54,82,23,26,156,26,1,253,0,1,0,0,0,0,10,75,128,0,0,60,15,75,128,0,16,60,15,11,128,0,244,60,31,255,255,224,244,60,63,255,255,224,244,60,125,11,128,0,244,60,252,11,128,0,244,60,36,11,128,0,244,60,255,255,255,248,244,60,255,255,255,248,244,60,0,11,128,0,244,60,0,11,128,0,244,60,0,11,128,0,244,60,47,255,255,240,244,60,47,255,255,240,244,60,45,11,129,240,244,60,45,11,129,240,180,60,45,11,129,240,0,60,45,11,129,240,0,60,45,11,129,240,0,60,45,11,175,224,0,60,45,11,143,192,0,124,0,11,128,0,63,252,0,11,128,0,47,244,0,0,0,0,5,64,
  // 0x5237  刷
  55,82,23,25,150,26,1,253,0,0,0,0,0,124,31,255,255,240,0,124,31,255,255,241,224,124,31,0,1,241,240,124,31,0,1,241,240,124,31,0,1,241,240,124,31,255,255,241,240,124,31,255,255,241,240,124,31,1,240,1,240,124,31,0,240,1,240,124,31,0,240,1,240,124,31,255,255,241,240,124,31,255,255,241,240,124,30,240,240,241,240,124,30,240,240,241,240,124,46,240,240,241,240,124,45,240,240,241,240,124,61,240,240,240,80,124,60,240,240,240,0,124,60,240,251,240,0,124,124,240,247,208,0,124,248,80,240,0,0,124,240,0,240,0,63,252,32,0,240,0,47,244,0,0,80,0,5,64,
  // 0x5272  割
  114,82,23,25,150,26,1,253,0,15,64,0,0,124,0,15,64,0,0,124,191,255,255,242,224,124,191,255,255,242,224,124,184,5,1,242,224,124,184,15,1,242,224,124,31,255,255,130,224,124,31,255,255,130,224,124,0,15,0,2,224,124,10,175,234,2,224,124,15,255,255,2,224,124,0,15,0,2,224,124,0,15,0,2,224,124,191,255,255,226,224,124,191,255,255,226,224,124,0,0,0,2,224,124,15,255,255,66,224,124,15,255,255,128,0,124,15,0,11,128,0,124,15,0,11,128,0,124,15,0,11,128,0,124,15,255,255,128,0,124,15,255,255,128,127,252,15,0,11,128,63,244,5,0,0,0,21,64,
  // 0x529b  力
  155,82,23,26,156,26,1,253,0,0,5,0,0,0,0,0,47,0,0,0,0,0,47,0,0,0,0,0,47,0,0,0,0,0,47,0,0,0,0,0,47,0,0,0,21,85,127,85,85,84,63,255,255,255,255,248,63,255,255,255,255,244,0,0,62,0,0,244,0,0,62,0,0,244,0,0,61,0,0,244,0,0,125,0,1,240,0,0,188,0,1,240,0,0,252,0,1,240,0,1,248,0,1,240,0,3,240,0,2,240,0,7,224,0,2,240,0,15,192,0,3,224,0,63,128,0,3,224,0,255,0,0,3,208,3,252,0,0,11,192,31,240,0,21,111,192,127,192,0,47,255,64,30,0,0,31,253,0,0,0,0,0,0,0,
  // 0x529f  功
  159,82,24,25,150,26,1,253,0,0,0,15,128,0,0,0,0,15,128,0,21,85,64,15,128,0,191,255,240,15,128,0,191,255,240,15,128,0,0,244,5,95,149,84,0,244,15,255,255,253,0,244,15,255,255,253,0,244,0,15,64,61,0,244,0,15,64,60,0,244,0,15,0,60,0,244,0,31,0,60,0,244,0,31,0,124,0,244,0,47,0,124,0,244,16,62,0,124,0,255,244,124,0,124,27,255,244,188,0,188,255,254,64,248,0,188,191,128,2,240,0,184,80,0,7,224,0,248,0,0,31,192,0,244,0,0,191,65,70,240,0,2,253,2,255,240,0,0,240,1,255,128,0,0,0,0,0,0,
  // 0x52a0  加
  160,82,23,25,150,26,1,253,0,240,0,0,0,0,0,240,0,0,0,0,0,240,0,0,0,0,0,240,0,31,255,248,21,249,85,31,255,248,191,255,255,31,85,248,191,255,255,31,0,184,0,240,31,31,0,184,1,240,47,31,0,184,1,240,47,31,0,184,1,240,47,31,0,184,1,240,46,31,0,184,2,240,46,31,0,184,2,224,46,31,0,184,3,208,46,31,0,184,3,208,46,31,0,184,7,192,62,31,0,184,11,192,62,31,0,184,15,128,61,31,0,184,15,64,61,31,85,248,63,0,61,31,255,248,126,21,188,31,255,248,252,47,252,31,0,184,112,31,224,31,0,168,0,0,0,0,0,0,
  // 0x52a8  动
  168,82,24,25,150,26,1,253,0,0,0,1,240,0,0,0,0,1,240,0,47,255,253,1,240,0,47,255,253,1,240,0,0,0,0,2,240,0,0,0,0,86,245,84,0,0,0,255,255,253,0,0,0,255,255,253,191,255,255,2,224,61,191,255,255,2,224,61,1,244,0,3,224,61,1,240,0,3,208,61,2,224,96,3,208,61,3,208,244,3,192,61,3,192,120,7,192,60,11,192,60,11,192,60,15,64,61,15,128,124,31,91,255,31,64,124,63,255,255,47,0,124,63,249,15,126,0,188,62,0,0,188,0,248,0,0,1,248,85,248,0,0,3,240,255,240,0,0,0,192,191,208,0,0,0,0,0,0,
  // 0x5316  化
  22,83,24,25,150,26,1,253,0,6,65,160,0,0,0,15,193,240,0,0,0,31,65,240,0,0,0,63,1,240,0,0,0,125,1,240,0,0,0,252,1,240,0,176,2,244,1,240,3,248,11,244,1,240,31,244,31,244,1,240,191,128,127,244,1,247,253,0,254,244,1,255,224,0,248,244,1,254,0,0,96,244,1,240,0,0,0,244,1,240,0,0,0,244,1,240,0,0,0,244,1,240,0,0,0,244,1,240,0,0,0,244,1,240,0,8,0,244,1,240,0,31,0,244,1,240,0,31,0,244,1,240,0,47,0,244,1,249,0,126,0,244,0,255,255,252,0,244,0,63,255,244,0,80,0,0,0,0,
  // 0x5347  升
  71,83,24,25,150,26,1,253,0,0,7,0,240,0,0,0,127,192,244,0,0,27,255,128,244,0,6,255,244,0,244,0,127,255,128,0,244,0,63,79,64,0,244,0,0,15,64,0,244,0,0,15,64,0,244,0,0,15,64,0,244,0,0,15,64,0,244,0,21,95,149,85,245,84,191,255,255,255,255,254,191,255,255,255,255,254,0,15,64,0,244,0,0,15,0,0,244,0,0,31,0,0,244,0,0,47,0,0,244,0,0,62,0,0,244,0,0,188,0,0,244,0,1,252,0,0,244,0,3,240,0,0,244,0,31,208,0,0,244,0,191,64,0,0,244,0,61,0,0,0,244,0,0,0,0,0,80,0,
  // 0x534a  半
  74,83,24,26,156,26,1,253,0,0,1,64,0,0,0,128,7,192,6,64,3,224,7,192,11,192,2,244,7,192,15,128,0,252,7,192,47,0,0,125,7,192,62,0,0,62,7,192,188,0,0,40,7,192,100,0,0,0,7,192,0,0,15,255,255,255,255,240,15,255,255,255,255,240,5,85,91,229,85,80,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,21,85,91,229,85,84,191,255,255,255,255,254,191,255,255,255,255,254,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,1,64,0,0,
  // 0x534f  协
  79,83,24,26,156,26,1,253,1,64,0,0,0,0,3,208,0,61,0,0,3,208,0,61,0,0,3,208,0,61,0,0,3,208,0,61,0,0,3,208,21,126,85,0,3,208,127,255,255,128,191,255,127,255,255,128,191,255,0,60,11,128,3,208,0,60,11,128,3,208,16,124,11,128,3,208,124,124,15,248,3,208,184,188,15,188,3,208,240,248,15,124,3,209,240,244,15,110,3,211,225,240,15,94,3,215,194,240,15,79,3,211,131,224,15,79,3,208,11,192,15,9,3,208,15,128,15,0,3,208,63,0,31,0,3,208,190,0,31,0,3,209,252,16,63,0,3,215,240,47,253,0,3,210,192,31,248,0,1,64,0,0,0,0,
  // 0x5355  单
  85,83,24,25,150,26,1,253,0,46,0,0,125,0,0,31,64,0,252,0,0,11,192,1,244,0,0,3,208,3,224,0,3,255,255,255,255,208,3,255,255,255,255,208,3,192,7,192,3,208,3,192,7,192,3,208,3,192,7,192,3,208,3,255,255,255,255,208,3,255,255,255,255,208,3,192,7,192,3,208,3,192,7,192,3,208,3,255,255,255,255,208,3,255,255,255,255,208,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,208,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,1,64,0,0,
  // 0x5361  卡
  97,83,24,26,156,26,1,253,0,0,5,64,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,255,255,192,0,0,15,255,255,192,0,0,15,213,85,64,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,21,85,95,213,85,85,191,255,255,255,255,254,191,255,255,255,255,254,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,253,0,0,0,0,15,255,244,0,0,0,15,155,255,128,0,0,15,128,127,224,0,0,15,128,2,192,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,5,64,0,0,
  // 0x5370  印
  112,83,22,25,150,26,2,253,0,7,192,0,0,0,0,127,240,85,85,80,107,255,210,255,255,240,127,248,2,255,255,240,126,64,2,240,1,240,124,0,2,240,1,240,124,0,2,240,1,240,124,0,2,240,1,240,124,0,2,240,1,240,127,255,242,240,1,240,127,255,242,240,1,240,125,85,82,240,1,240,124,0,2,240,1,240,124,0,2,240,1,240,124,0,2,240,1,240,124,0,2,240,1,240,124,0,2,240,1,240,127,255,242,240,2,240,127,255,242,240,255,240,125,85,82,240,191,208,124,0,2,240,41,0,40,0,2,240,0,0,0,0,2,240,0,0,0,0,2,240,0,0,0,0,0,80,0,0,
  // 0x5371  危
  113,83,24,26,156,26,1,253,0,2,64,0,0,0,0,11,192,0,0,0,0,15,255,255,64,0,0,63,255,255,192,0,0,125,0,47,64,0,0,252,0,63,0,0,3,244,0,125,0,0,15,255,255,255,255,253,63,255,255,255,255,253,255,240,0,0,0,0,58,224,0,0,0,0,2,224,0,0,0,0,2,224,255,255,255,0,2,224,255,255,255,0,2,224,244,0,31,0,3,224,244,0,31,0,3,208,244,0,47,0,3,208,244,0,62,0,7,192,244,31,253,0,11,192,244,15,248,4,15,128,244,0,0,31,31,0,244,0,0,46,63,0,248,0,0,62,252,0,191,255,255,252,116,0,47,255,255,244,0,0,0,0,0,0,
  // 0x5374  却
  116,83,23,26,156,26,1,253,0,5,0,0,0,0,0,46,0,0,0,0,0,46,0,31,255,252,0,46,0,31,255,252,0,47,0,31,85,188,63,255,255,31,0,188,63,255,255,31,0,188,0,46,0,31,0,188,0,46,0,31,0,188,0,46,0,31,0,188,0,46,0,31,0,188,255,255,255,223,0,188,255,255,255,223,0,188,1,248,0,31,0,188,1,244,0,31,0,188,2,240,0,31,0,188,3,224,240,31,0,188,3,208,188,31,0,188,7,192,61,31,5,252,15,128,63,31,15,248,111,255,255,95,15,224,255,255,255,159,0,0,186,80,7,223,0,0,0,0,2,31,0,0,0,0,0,31,0,0,0,0,0,5,0,0,
  // 0x5378  卸
  120,83,23,25,150,26,1,253,2,224,0,0,0,0,3,208,0,15,255,252,7,208,0,15,255,252,11,255,255,79,85,188,31,255,255,79,0,124,62,15,0,15,0,124,124,15,0,15,0,124,16,15,0,15,0,124,191,255,255,207,0,124,191,255,255,207,0,124,0,31,64,15,0,124,0,15,0,15,0,124,31,15,0,15,0,124,31,15,255,15,0,124,31,15,255,15,0,124,31,15,0,15,0,124,31,15,0,15,0,124,31,15,0,15,0,124,31,15,0,15,15,252,31,15,175,207,15,244,111,255,255,207,5,64,255,255,229,15,0,0,254,80,0,15,0,0,0,0,0,15,0,0,0,0,0,5,0,0,
  // 0x538b  压
  139,83,24,24,144,26,1,253,15,255,255,255,255,255,15,255,255,255,255,255,15,149,85,85,85,85,15,64,0,20,0,0,15,64,0,124,0,0,15,64,0,124,0,0,15,64,0,124,0,0,15,64,0,124,0,0,15,64,0,124,0,0,15,15,255,255,255,248,15,15,255,255,255,248,15,5,85,189,85,80,15,0,0,124,0,0,15,0,0,124,44,0,31,0,0,124,63,0,31,0,0,124,15,192,47,0,0,124,3,240,46,0,0,124,1,208,61,0,0,124,0,0,60,0,0,124,0,0,188,255,255,255,255,254,248,255,255,255,255,254,112,85,85,85,85,84,0,0,0,0,0,0,
  // 0x539f  原
  159,83,24,24,144,26,1,253,11,255,255,255,255,253,11,255,255,255,255,253,11,192,0,189,0,0,11,128,0,252,0,0,11,131,255,255,255,208,11,135,255,255,255,208,11,135,192,0,3,208,11,135,192,0,3,208,11,135,255,255,255,208,11,135,255,255,255,208,15,135,192,0,3,208,15,135,192,0,3,208,15,71,255,255,255,208,15,71,255,255,255,208,15,64,0,60,0,0,15,0,160,60,9,0,31,1,244,60,47,64,47,3,224,60,11,208,62,15,192,60,2,244,61,63,64,60,0,252,188,253,0,60,0,62,248,52,31,252,0,20,32,0,15,244,0,0,0,0,0,0,0,0,
  // 0x53cc  双
  204,83,24,24,144,26,1,253,21,85,80,85,85,80,127,255,252,255,255,252,127,255,248,255,255,248,0,0,244,184,0,248,0,0,244,124,0,244,4,0,240,124,1,244,45,1,240,60,2,240,63,2,240,61,2,240,15,195,224,46,3,224,3,227,208,31,7,208,1,255,192,15,79,192,0,255,192,15,143,128,0,63,128,11,239,0,0,47,128,7,254,0,0,63,208,3,252,0,0,127,240,1,248,0,0,253,244,3,252,0,2,244,252,15,254,0,7,240,124,63,191,64,15,192,32,254,15,224,63,64,11,252,3,248,253,0,31,224,1,254,52,0,11,64,0,60,0,0,0,0,0,0,
  // 0x53cd  反
  205,83,23,24,144,26,1,253,2,255,255,255,255,248,2,255,255,255,255,248,2,245,85,85,85,80,2,240,0,0,0,0,2,240,0,0,0,0,2,240,0,0,0,0,2,240,0,0,0,0,2,255,255,255,255,128,2,255,255,255,255,192,2,247,245,85,95,128,2,225,240,0,47,64,3,224,248,0,63,0,3,224,124,0,189,0,3,208,63,0,252,0,3,208,31,131,240,0,7,192,11,223,224,0,11,192,3,255,128,0,15,128,1,255,0,0,15,64,11,255,208,0,47,0,127,239,253,0,63,11,255,2,255,228,189,63,248,0,63,252,44,31,64,0,2,244,0,0,0,0,0,16,
  // 0x53d6  取
  214,83,24,24,144,26,1,253,191,255,255,192,0,0,191,255,255,192,0,0,15,128,125,191,255,252,15,128,61,191,255,252,15,128,61,25,85,188,15,128,61,60,0,188,15,255,253,61,0,248,15,255,253,46,0,244,15,128,61,31,0,240,15,128,61,15,2,240,15,128,61,15,131,224,15,255,253,11,199,208,15,255,253,3,223,192,15,128,61,2,255,128,15,128,61,1,255,0,15,128,61,0,254,0,15,150,189,0,254,0,175,255,253,3,255,64,255,255,189,11,255,208,250,64,61,47,199,244,0,0,62,255,1,254,0,0,62,248,0,127,0,0,61,160,0,12,0,0,20,0,0,0,
  // 0x53d8  变
  216,83,24,26,156,26,1,253,0,0,1,64,0,0,0,0,11,192,0,0,0,0,3,224,0,0,63,255,255,255,255,252,63,255,255,255,255,252,0,1,244,31,64,0,0,161,240,15,8,0,0,245,240,15,127,0,3,225,240,15,15,192,11,193,240,15,7,224,31,129,240,15,1,244,31,1,240,15,0,180,0,1,240,15,0,0,0,0,80,5,0,0,11,255,255,255,255,0,11,255,255,255,255,0,0,126,0,0,190,0,0,31,128,1,248,0,0,11,224,11,224,0,0,1,253,127,128,0,0,0,127,253,0,0,0,1,191,254,64,0,1,175,254,191,249,64,127,255,144,7,255,253,63,228,0,0,27,252,16,0,0,0,0,0,
  // 0x53f0  台
  240,83,23,26,156,26,2,253,0,0,64,0,0,0,0,2,240,0,0,0,0,3,240,0,0,0,0,11,208,0,0,0,0,15,192,7,128,0,0,47,64,11,240,0,0,126,0,2,252,0,0,252,0,0,191,0,90,254,171,255,255,192,255,255,255,255,255,224,255,255,170,165,87,244,0,0,0,0,0,244,0,0,0,0,0,64,1,85,85,85,84,0,7,255,255,255,253,0,7,255,255,255,253,0,7,192,0,0,61,0,7,192,0,0,61,0,7,192,0,0,61,0,7,192,0,0,61,0,7,192,0,0,61,0,7,192,0,0,61,0,7,255,255,255,253,0,7,255,255,255,253,0,7,213,85,85,125,0,1,64,0,0,20,0,
  // 0x5403  吃
  3,84,23,24,144,26,2,254,0,0,2,240,0,0,0,0,3,224,0,0,255,252,7,208,0,0,255,252,15,208,0,0,245,124,15,255,255,248,240,60,63,255,255,248,240,60,125,0,0,0,240,61,252,0,0,0,240,62,244,0,0,0,240,60,111,255,255,128,240,60,15,255,255,192,240,60,0,1,254,0,240,60,0,3,248,0,240,60,0,15,208,0,240,60,0,63,64,0,245,124,0,253,0,0,255,252,3,244,0,0,255,252,15,208,0,0,240,0,47,64,0,56,240,0,62,0,0,60,0,0,124,0,0,124,0,0,126,85,85,248,0,0,63,255,255,244,0,0,11,255,255,208,
  // 0x5408  合
  8,84,24,26,156,26,1,253,0,0,1,64,0,0,0,0,15,224,0,0,0,0,63,248,0,0,0,0,190,189,0,0,0,2,252,63,128,0,0,11,240,15,224,0,0,47,192,3,248,0,0,254,0,0,191,64,7,248,0,0,47,224,127,255,255,255,251,254,255,31,255,255,244,191,56,0,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,255,255,255,255,0,0,244,0,0,31,0,0,244,0,0,31,0,0,244,0,0,31,0,0,244,0,0,31,0,0,244,0,0,31,0,0,255,255,255,255,0,0,255,255,255,255,0,0,248,0,0,31,0,0,80,0,0,5,0,
  // 0x540d  名
  13,84,22,26,156,26,1,253,0,0,80,0,0,0,0,0,252,0,0,0,0,2,244,0,0,0,0,11,255,255,244,0,0,31,255,255,244,0,0,127,0,3,240,0,2,252,0,7,208,0,11,253,0,15,192,0,127,255,64,47,64,0,190,31,224,126,0,0,36,3,249,252,0,0,0,0,255,240,0,0,0,0,127,192,0,0,0,0,191,128,0,0,0,7,255,255,255,240,0,47,255,255,255,240,2,255,224,0,1,240,127,251,224,0,1,240,191,194,224,0,1,240,56,2,224,0,1,240,0,2,224,0,1,240,0,2,224,0,1,240,0,2,255,255,255,240,0,2,255,255,255,240,0,2,240,0,2,240,0,0,64,0,0,80,
  // 0x540e  后
  14,84,24,25,150,26,1,253,0,0,0,1,111,128,1,1,90,255,255,208,3,255,255,255,233,0,3,255,250,80,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,255,255,255,255,255,3,255,255,255,255,255,3,229,85,85,85,85,3,192,0,0,0,0,3,192,0,0,0,0,7,192,0,0,0,0,7,195,255,255,255,240,7,195,255,255,255,240,11,195,224,0,2,240,15,131,224,0,2,240,15,131,224,0,2,240,31,3,224,0,2,240,47,3,224,0,2,240,62,3,224,0,2,240,189,3,255,255,255,240,248,3,255,255,255,240,48,3,224,0,2,240,0,1,64,0,0,64,
  // 0x5411  向
  17,84,22,26,156,26,2,253,0,0,16,0,0,0,0,0,63,0,0,0,0,0,126,0,0,0,0,0,252,0,0,0,0,0,248,0,0,0,127,255,255,255,255,224,127,255,255,255,255,224,125,85,85,85,87,224,124,0,0,0,3,224,124,0,0,0,3,224,124,0,0,0,3,224,124,15,255,255,3,224,124,15,255,255,3,224,124,15,0,15,3,224,124,15,0,15,3,224,124,15,0,15,3,224,124,15,0,15,3,224,124,15,64,31,3,224,124,15,255,255,3,224,124,15,255,255,3,224,124,15,0,0,3,224,124,15,0,0,3,224,124,0,0,0,3,224,124,0,0,7,255,208,124,0,0,3,255,192,20,0,0,1,84,0,
  // 0x5426  否
  38,84,24,24,144,26,1,253,63,255,255,255,255,252,63,255,255,255,255,252,21,85,87,253,85,84,0,0,11,240,0,0,0,0,63,192,0,0,0,1,255,195,224,0,0,11,251,199,253,0,0,191,199,192,191,208,31,254,7,192,11,248,255,224,7,192,1,254,62,0,7,192,0,44,16,0,7,192,0,0,0,0,0,0,0,0,1,255,255,255,255,128,1,255,255,255,255,128,1,240,0,0,15,128,1,240,0,0,15,128,1,240,0,0,15,128,1,240,0,0,15,128,1,240,0,0,15,128,1,255,255,255,255,128,1,255,255,255,255,128,1,240,0,0,15,128,0,80,0,0,5,0,
  // 0x542f  启
  47,84,22,25,150,26,1,253,0,0,0,22,255,0,0,86,191,255,255,128,7,255,255,250,64,0,7,233,80,0,0,0,7,192,0,0,0,0,7,255,255,255,255,224,7,255,255,255,255,224,7,192,0,0,2,224,7,192,0,0,2,224,7,192,0,0,2,224,7,192,0,0,2,224,7,255,255,255,255,224,7,255,255,255,255,224,7,192,0,0,0,0,11,192,0,0,0,0,11,207,255,255,255,240,15,143,255,255,255,240,15,79,64,0,1,240,31,15,64,0,1,240,47,15,64,0,1,240,62,15,64,0,1,240,189,15,255,255,255,240,188,15,255,255,255,240,36,15,64,0,1,240,0,0,0,0,0,0,
  // 0x544a  告
  74,84,24,26,156,26,1,253,0,0,1,80,0,0,0,61,2,240,0,0,0,188,2,240,0,0,0,248,2,240,0,0,1,255,255,255,255,224,3,255,255,255,255,224,11,208,2,240,0,0,31,128,2,240,0,0,63,0,2,240,0,0,13,0,2,240,0,0,5,0,2,240,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,128,0,255,255,255,255,128,0,244,0,0,15,128,0,240,0,0,15,128,0,240,0,0,15,128,0,240,0,0,15,128,0,244,0,0,15,128,0,255,255,255,255,128,0,255,255,255,255,128,0,240,0,0,15,128,0,160,0,0,5,64,
  // 0x5468  周
  104,84,22,24,144,26,1,253,7,255,255,255,255,240,7,255,255,255,255,240,7,213,86,149,86,240,7,192,3,192,1,240,7,192,3,192,1,240,7,199,255,255,241,240,7,199,255,255,225,240,7,192,3,192,1,240,7,192,3,192,1,240,7,207,255,255,245,240,7,207,255,255,245,240,7,192,0,0,1,240,7,192,0,0,1,240,11,195,255,255,193,240,11,131,255,255,193,240,15,131,208,3,193,240,15,67,208,3,193,240,31,3,208,3,193,240,47,3,255,255,193,240,62,3,255,255,193,240,125,3,208,0,2,240,252,1,64,1,255,240,116,0,0,0,255,192,0,0,0,0,0,0,
  // 0x547d  命
  125,84,24,26,156,26,1,253,0,0,5,64,0,0,0,0,15,240,0,0,0,0,63,248,0,0,0,0,254,190,0,0,0,3,248,63,192,0,0,15,224,15,240,0,0,127,128,2,254,0,2,254,0,0,191,208,31,247,255,255,223,253,255,131,255,255,209,255,184,0,0,0,0,46,0,0,0,0,0,0,11,255,248,127,255,240,11,255,248,127,255,240,11,128,120,124,1,240,11,128,120,124,1,240,11,128,120,124,1,240,11,128,120,124,1,240,11,128,120,124,1,240,11,255,248,124,1,240,11,255,248,124,2,240,11,128,0,124,127,224,11,128,0,124,63,128,1,64,0,124,0,0,0,0,0,124,0,0,0,0,0,20,0,0,
  // 0x548c  和
  140,84,23,25,150,26,1,253,0,1,184,0,0,0,5,191,253,0,0,0,127,255,144,127,255,248,58,126,0,127,255,248,0,62,0,125,85,248,0,62,0,124,0,248,0,62,0,124,0,248,0,62,0,124,0,248,191,255,255,124,0,248,191,255,255,124,0,248,0,190,0,124,0,248,0,255,64,124,0,248,2,255,208,124,0,248,3,255,240,124,0,248,7,254,188,124,0,248,15,126,62,124,0,248,47,62,28,124,0,248,125,62,0,124,0,248,248,62,0,125,85,248,176,62,0,127,255,248,16,62,0,127,255,248,0,62,0,124,0,248,0,62,0,124,0,248,0,62,0,0,0,0,0,20,0,0,0,0,
  // 0x54cd  响
  205,84,23,26,156,26,2,253,0,0,0,4,0,0,0,0,0,31,128,0,0,0,0,47,0,0,255,248,0,62,0,0,255,248,0,125,0,0,244,184,191,255,255,244,240,120,191,255,255,244,240,120,184,0,0,244,240,120,184,0,0,244,240,120,184,0,0,244,240,120,184,191,240,244,240,120,184,190,240,244,240,120,184,176,112,244,240,120,184,176,112,244,240,120,184,176,112,244,240,120,184,176,112,244,255,248,184,176,112,244,255,248,184,190,240,244,244,0,184,191,240,244,240,0,184,176,0,244,160,0,184,80,0,244,0,0,184,0,0,244,0,0,184,0,0,244,0,0,184,0,47,240,0,0,184,0,31,208,0,0,0,0,0,0,
  // 0x55b7  喷
  183,85,23,25,150,26,2,253,0,0,0,31,0,0,0,0,0,31,0,0,255,240,255,255,255,224,255,240,255,255,255,224,240,240,0,31,0,0,240,240,31,26,31,0,240,240,31,0,31,0,240,243,255,255,255,248,240,243,255,255,255,248,240,240,31,0,31,0,240,240,5,0,5,0,240,240,127,255,255,192,240,240,127,255,255,192,240,240,120,0,3,192,240,240,120,5,3,192,255,240,120,31,3,192,255,240,120,31,3,192,240,0,120,31,3,192,240,0,120,46,3,192,224,0,104,61,82,128,0,0,1,252,253,0,0,0,47,224,47,208,0,11,255,64,3,252,0,7,224,0,0,120,0,0,0,0,0,0,
  // 0x5634  嘴
  52,86,23,26,156,26,2,253,0,0,1,0,64,0,0,0,11,66,208,0,0,1,203,66,208,128,255,242,203,234,235,224,255,242,203,254,255,64,224,242,203,66,244,0,224,242,203,66,208,36,224,242,203,174,208,60,224,251,255,253,255,248,224,251,255,192,255,240,224,241,15,234,128,0,224,240,47,255,240,0,224,240,188,3,192,0,224,242,254,175,234,144,224,255,255,255,255,208,255,247,184,15,2,208,255,240,125,111,87,208,240,0,191,255,255,208,224,0,184,15,2,208,224,0,184,15,2,208,0,0,255,255,255,208,0,1,250,170,171,208,0,7,224,0,2,208,0,31,192,0,175,208,0,10,0,0,191,128,0,0,0,0,0,0,
  // 0x5668  器
  104,86,24,24,144,26,1,253,15,255,248,47,255,240,15,255,248,47,255,240,15,64,184,46,1,240,15,64,184,46,1,240,15,64,184,46,1,240,15,255,248,47,255,240,15,255,254,47,255,240,0,0,15,128,0,0,0,0,63,0,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,15,240,15,224,0,0,127,192,3,248,0,2,255,0,0,255,128,111,252,0,0,63,253,255,255,252,63,255,255,43,255,252,63,255,232,7,128,124,60,3,208,7,128,124,60,3,208,7,128,124,60,3,208,7,255,252,63,255,208,7,255,252,63,255,208,7,128,124,60,3,208,0,0,0,0,0,0,
  // 0x5674  噴
  116,86,23,26,156,26,2,253,0,0,0,5,0,0,0,0,0,15,0,0,0,0,170,191,170,160,255,248,255,255,255,240,255,248,0,15,0,0,255,248,15,15,31,0,240,120,15,0,31,0,240,123,255,255,255,252,240,122,175,170,191,168,240,120,15,0,31,0,240,120,26,85,90,64,240,120,127,255,255,192,240,120,120,0,3,192,240,120,125,85,87,192,240,120,127,255,255,192,240,184,120,0,3,192,255,248,125,85,87,192,255,248,127,255,255,192,240,0,120,0,3,192,240,0,125,85,87,192,0,0,127,255,255,192,0,0,11,128,120,0,0,0,191,128,127,128,0,31,253,0,11,244,0,15,208,0,0,244,0,0,0,0,0,0,
  // 0x56de  回
  222,86,22,25,150,26,2,253,85,85,85,85,85,80,255,255,255,255,255,240,255,255,255,255,255,240,248,0,0,0,2,240,248,0,0,0,2,240,248,0,0,0,2,240,248,0,0,0,2,240,248,15,255,255,2,240,248,15,255,255,2,240,248,15,0,31,2,240,248,15,0,31,2,240,248,15,0,31,2,240,248,15,0,31,2,240,248,15,0,31,2,240,248,15,0,31,2,240,248,15,255,255,2,240,248,15,255,255,2,240,248,0,0,0,2,240,248,0,0,0,2,240,248,0,0,0,2,240,248,0,0,0,3,240,255,255,255,255,255,240,255,255,255,255,255,240,248,0,0,0,2,240,84,0,0,0,1,80,
  // 0x56e0  因
  224,86,22,24,144,26,2,253,255,255,255,255,255,240,255,255,255,255,255,240,249,85,85,85,86,240,248,0,15,0,2,240,248,0,31,0,2,240,248,0,31,0,2,240,248,0,31,0,2,240,248,255,255,255,242,240,248,255,255,255,242,240,248,0,63,128,2,240,248,0,63,192,2,240,248,0,127,192,2,240,248,0,190,224,2,240,248,1,244,244,2,240,248,3,240,188,2,240,248,15,208,63,66,240,248,191,64,31,242,240,248,253,0,7,242,240,248,96,0,0,130,240,248,0,0,0,2,240,255,255,255,255,255,240,255,255,255,255,255,240,249,85,85,85,86,240,80,0,0,0,1,80,
  // 0x56fa  固
  250,86,22,24,144,26,2,253,191,255,255,255,255,240,191,255,255,255,255,240,188,0,0,0,3,240,184,0,10,0,2,240,184,0,15,0,2,240,184,0,15,0,2,240,184,255,255,255,242,240,184,255,255,255,242,240,184,0,15,0,2,240,184,0,15,0,2,240,184,0,15,0,2,240,184,31,255,255,130,240,184,31,255,255,130,240,184,30,0,11,130,240,184,30,0,11,130,240,184,30,0,11,130,240,184,31,255,255,130,240,184,31,255,255,130,240,184,0,0,0,2,240,184,0,0,0,2,240,191,255,255,255,255,240,191,255,255,255,255,240,189,85,85,85,87,240,84,0,0,0,1,80,
  // 0x56fe  图
  254,86,22,24,144,26,2,253,255,255,255,255,255,240,255,255,255,255,255,240,244,0,80,0,2,240,244,1,240,0,2,240,244,7,255,255,194,240,244,31,255,255,194,240,244,191,128,31,66,240,246,251,224,189,2,240,244,144,255,244,2,240,244,0,127,224,2,240,244,27,255,254,66,240,251,255,208,111,254,240,246,249,164,1,246,240,244,64,255,144,2,240,244,0,7,248,2,240,244,9,0,32,2,240,244,47,254,64,2,240,244,6,191,254,2,240,244,0,1,191,2,240,244,0,0,1,2,240,255,255,255,255,255,240,255,255,255,255,255,240,248,0,0,0,2,240,16,0,0,0,0,64,
  // 0x5728  在
  40,87,24,24,144,26,1,254,0,0,125,0,0,0,0,0,188,0,0,0,0,0,248,0,0,0,21,85,249,85,85,84,127,255,255,255,255,253,127,255,255,255,255,253,0,11,192,0,0,0,0,31,128,6,128,0,0,63,0,11,192,0,0,189,0,11,192,0,1,252,0,11,192,0,3,244,0,11,192,0,15,244,63,255,255,244,127,244,63,255,255,244,254,244,0,11,192,0,116,244,0,11,192,0,16,244,0,11,192,0,0,244,0,11,192,0,0,244,0,11,192,0,0,244,0,11,192,0,0,244,0,11,192,0,0,244,0,11,192,0,0,244,255,255,255,253,0,244,255,255,255,253,
  // 0x574f  坏
  79,87,24,25,150,26,1,253,2,224,0,0,0,0,2,224,255,255,255,255,2,224,255,255,255,255,2,224,21,86,249,84,2,224,0,3,240,0,2,224,0,7,208,0,191,255,64,15,192,0,191,255,64,63,192,0,22,245,0,191,237,0,2,224,2,255,255,128,2,224,11,251,203,224,2,224,127,203,194,252,2,226,254,11,192,191,2,224,248,11,192,46,2,224,64,11,192,4,2,231,128,11,192,0,2,255,192,11,192,0,111,254,64,11,192,0,255,224,0,11,192,0,185,0,0,11,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,0,0,1,64,0,
  // 0x5757  块
  87,87,24,25,150,26,1,253,2,224,0,15,0,0,2,224,0,15,0,0,2,224,0,15,0,0,2,224,0,15,0,0,2,224,47,255,255,240,2,224,47,255,255,240,191,255,69,95,86,240,191,255,64,15,1,240,22,229,0,15,1,240,2,224,0,31,1,240,2,224,0,31,1,240,2,224,21,111,86,244,2,224,63,255,255,254,2,224,127,255,255,254,2,231,64,63,224,0,2,255,128,63,240,0,11,254,0,188,244,0,255,224,0,248,188,0,190,0,2,240,62,0,32,0,11,224,47,64,0,0,47,192,15,208,0,0,255,0,3,248,0,7,252,0,1,254,0,2,208,0,0,60,0,0,0,0,0,0,
  // 0x578b  型
  139,87,24,24,144,26,1,254,0,0,0,0,0,244,31,255,255,210,144,244,31,255,255,211,208,244,0,240,60,3,208,244,0,240,60,3,208,244,0,240,60,3,208,244,127,255,255,243,208,244,127,255,255,243,208,244,2,240,125,3,208,244,2,224,60,3,208,244,3,208,60,0,0,244,15,192,60,0,0,240,63,64,60,0,127,240,61,0,62,64,63,208,4,0,3,208,0,0,0,0,3,208,0,0,3,255,255,255,255,192,3,255,255,255,255,192,0,0,7,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,0,0,0,0,0,
  // 0x57ab  垫
  171,87,24,25,150,26,1,254,0,84,0,5,0,0,0,184,0,31,0,0,0,184,0,31,0,0,127,255,235,255,255,192,127,255,235,255,255,192,0,184,0,46,3,192,0,184,1,46,3,192,0,186,231,253,3,192,26,255,247,253,3,192,191,255,144,254,3,192,127,248,0,255,211,192,16,184,1,247,243,196,0,184,7,224,163,203,0,184,47,192,2,239,31,244,31,0,1,255,15,224,11,192,0,189,0,0,3,192,0,0,3,255,255,255,255,192,3,255,255,255,255,192,0,0,7,192,0,0,0,0,3,192,0,0,0,0,3,192,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,0,0,0,0,0,
  // 0x586b  填
  107,88,24,26,156,26,1,253,0,0,0,1,0,0,2,208,0,7,192,0,2,208,0,7,192,0,2,208,255,255,255,254,2,208,255,255,255,254,2,208,0,7,192,0,2,208,10,171,234,144,191,255,15,255,255,224,191,255,15,0,2,224,23,229,15,149,87,224,2,208,15,255,255,224,2,208,15,0,2,224,2,208,15,149,87,224,2,208,15,255,255,224,2,208,15,0,2,224,2,209,15,170,171,224,2,255,79,255,255,224,7,255,64,0,0,0,191,251,255,255,255,255,255,66,255,255,255,255,116,0,0,64,4,0,0,0,3,240,47,64,0,0,47,208,15,224,0,3,254,0,1,253,0,2,244,0,0,62,0,0,0,0,0,0,
  // 0x58f3  壳
  243,88,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,7,192,0,0,3,255,255,255,255,192,3,255,255,255,255,208,0,0,0,0,0,0,63,255,255,255,255,252,63,255,255,255,255,252,61,0,0,0,0,124,61,42,170,170,168,124,61,127,255,255,252,124,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,255,224,0,0,31,255,255,224,0,0,31,0,2,224,0,0,47,0,2,224,0,0,62,0,2,224,36,0,188,0,2,224,45,7,248,0,2,240,61,127,224,0,2,255,252,47,64,0,0,191,244,0,0,0,0,0,0,
  // 0x5907  备
  7,89,24,26,156,26,1,253,0,0,64,0,0,0,0,0,252,0,0,0,0,3,244,0,0,0,0,15,255,255,254,0,0,63,255,255,254,0,1,255,0,1,252,0,11,255,208,7,240,0,47,195,248,63,192,0,13,0,255,254,0,0,0,0,127,253,0,0,0,27,255,255,244,0,27,255,244,31,255,250,255,254,0,0,191,254,127,144,0,0,1,172,2,255,255,255,255,128,2,255,255,255,255,128,2,240,7,192,15,128,2,240,7,192,15,128,2,255,255,255,255,128,2,255,255,255,255,128,2,240,7,192,15,128,2,240,7,192,15,128,2,255,255,255,255,128,2,255,255,255,255,128,2,240,0,0,15,128,0,0,0,0,0,0,
  // 0x590d  复
  13,89,17,26,130,26,4,253,0,16,0,0,0,0,188,0,0,0,0,248,0,0,0,2,255,255,255,0,7,255,255,255,0,15,192,0,0,0,63,64,0,0,0,191,255,255,252,0,62,250,170,252,0,2,224,0,124,0,2,255,255,252,0,2,250,170,188,0,2,224,0,124,0,2,255,255,252,0,1,175,234,168,0,0,47,0,0,0,0,127,255,248,0,2,254,171,248,0,31,252,2,240,0,127,111,11,208,0,44,11,255,64,0,0,7,254,0,0,0,127,255,228,0,47,254,11,255,192,63,144,0,111,128,4,0,0,1,0,
  // 0x5916  外
  22,89,24,26,156,26,1,253,0,0,0,0,20,0,0,31,0,0,188,0,0,47,0,0,188,0,0,62,0,0,188,0,0,125,85,0,188,0,0,255,255,208,188,0,0,255,255,208,188,0,2,240,7,244,188,0,3,208,11,252,188,0,15,192,15,190,188,0,47,128,15,95,252,0,127,240,31,11,252,0,254,253,63,3,252,0,52,127,189,0,253,0,0,15,252,0,191,128,0,2,248,0,191,224,0,2,240,0,191,254,0,7,224,0,188,191,0,15,192,0,188,29,0,63,64,0,188,0,0,253,0,0,188,0,3,248,0,0,188,0,31,224,0,0,188,0,127,128,0,0,188,0,29,0,0,0,188,0,0,0,0,0,20,0,
  // 0x591a  多
  26,89,22,25,150,26,2,253,0,0,127,0,0,0,0,1,252,0,0,0,0,7,255,255,240,0,0,63,255,255,240,0,2,254,0,7,224,0,127,255,0,31,128,0,126,95,224,190,0,0,16,2,255,248,0,0,0,0,127,208,0,0,0,6,254,127,0,0,0,191,229,252,0,0,191,254,11,255,255,224,255,144,127,255,255,240,100,2,253,0,7,208,0,127,248,0,15,192,3,255,255,0,63,0,2,228,47,208,253,0,0,0,7,251,244,0,0,0,0,255,208,0,0,0,6,255,0,0,0,0,127,248,0,0,1,111,255,128,0,0,15,255,244,0,0,0,11,249,0,0,0,0,0,0,0,0,0,0,
  // 0x5927  大
  39,89,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,208,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,21,85,111,249,85,84,0,0,31,244,0,0,0,0,47,248,0,0,0,0,63,188,0,0,0,0,125,62,0,0,0,0,252,63,0,0,0,1,248,31,128,0,0,3,240,15,208,0,0,11,208,3,240,0,0,47,192,2,252,0,0,191,0,0,255,0,3,252,0,0,63,208,47,240,0,0,15,253,127,192,0,0,2,253,45,0,0,0,0,120,0,0,0,0,0,0,
  // 0x5929  天
  41,89,24,24,144,26,1,253,21,85,85,85,85,84,127,255,255,255,255,253,127,255,255,255,255,253,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,11,192,0,0,47,255,255,255,255,248,47,255,255,255,255,248,21,85,95,245,85,84,0,0,15,240,0,0,0,0,31,248,0,0,0,0,63,188,0,0,0,0,126,63,0,0,0,0,252,47,128,0,0,3,244,15,208,0,0,31,224,3,248,0,0,255,128,1,255,64,27,253,0,0,127,248,191,224,0,0,11,254,62,0,0,0,1,188,0,0,0,0,0,0,
  // 0x592a  太
  42,89,24,26,156,26,1,253,0,0,1,64,0,0,0,0,11,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,0,0,15,192,0,0,21,85,95,213,85,84,127,255,255,255,255,254,127,255,255,255,255,254,0,0,31,244,0,0,0,0,47,248,0,0,0,0,63,188,0,0,0,0,62,61,0,0,0,0,188,63,0,0,0,0,252,31,64,0,0,2,244,15,192,0,0,3,240,7,224,0,0,15,217,3,244,0,0,47,255,128,253,0,0,191,15,224,127,64,3,252,3,248,47,224,47,240,0,253,11,253,191,128,0,125,1,255,61,0,0,20,0,60,0,0,0,0,0,0,
  // 0x5931  失
  49,89,24,26,156,26,1,253,0,0,1,64,0,0,0,120,7,192,0,0,0,188,7,192,0,0,0,248,7,192,0,0,1,244,7,192,0,0,3,255,255,255,255,208,3,255,255,255,255,208,15,213,91,229,85,64,31,128,7,192,0,0,63,0,7,192,0,0,45,0,7,192,0,0,4,0,11,192,0,0,21,85,95,213,85,84,191,255,255,255,255,254,191,255,255,255,255,254,0,0,31,244,0,0,0,0,63,252,0,0,0,0,189,126,0,0,0,1,252,47,64,0,0,7,244,15,208,0,0,31,208,7,248,0,1,255,128,1,255,64,31,253,0,0,127,248,191,224,0,0,11,255,62,0,0,0,0,188,0,0,0,0,0,0,
  // 0x5934  头
  52,89,24,25,150,26,1,253,0,0,0,124,0,0,0,125,0,124,0,0,0,191,208,124,0,0,0,11,248,124,0,0,0,0,248,124,0,0,0,0,32,188,0,0,11,128,0,188,0,0,15,248,0,188,0,0,1,255,64,184,0,0,0,47,64,248,0,0,0,2,0,248,0,0,0,0,1,248,0,0,127,255,255,255,255,254,127,255,255,255,255,254,0,0,3,224,0,0,0,0,11,192,0,0,0,0,15,200,0,0,0,0,63,111,128,0,0,0,254,31,244,0,0,7,248,2,255,0,0,47,224,0,47,224,7,255,64,0,7,252,127,248,0,0,0,189,47,64,0,0,0,36,0,0,0,0,0,0,
  // 0x597d  好
  125,89,24,26,156,26,1,253,0,64,0,0,0,0,1,240,0,0,0,0,1,240,7,255,255,248,2,224,7,255,255,252,3,208,0,0,3,244,3,208,0,0,7,224,255,255,240,0,31,128,255,255,240,0,126,0,11,130,240,1,248,0,15,66,224,1,240,0,15,3,224,1,240,0,31,3,239,255,255,255,46,3,223,255,255,255,45,7,197,86,245,85,61,11,192,1,240,0,63,143,128,1,240,0,127,255,0,1,240,0,26,255,0,1,240,0,0,127,64,1,240,0,0,255,208,1,240,0,1,251,244,1,240,0,3,240,240,1,240,0,31,192,80,1,240,0,127,64,0,255,240,0,60,0,0,191,208,0,0,0,0,20,0,0,
  // 0x59cb  始
  203,89,24,26,156,26,1,253,0,64,0,1,0,0,1,240,0,7,208,0,1,240,0,11,192,0,2,224,0,15,128,0,3,208,0,15,64,0,3,208,0,47,7,192,255,255,240,62,3,208,255,255,240,60,2,240,15,130,240,188,0,248,15,66,229,254,255,253,15,3,239,255,255,255,31,3,223,250,149,95,46,3,208,0,0,13,46,7,192,0,0,0,61,11,192,0,0,0,62,15,129,255,255,252,127,223,65,255,255,252,123,255,1,240,0,188,0,191,1,240,0,188,0,191,193,240,0,188,1,251,241,240,0,188,3,240,241,240,0,188,31,192,17,255,255,252,127,0,1,255,255,252,60,0,1,240,0,188,0,0,0,80,0,0,
  // 0x5b50  子
  80,91,24,24,144,26,1,253,1,85,85,85,85,0,3,255,255,255,255,208,3,255,255,255,255,192,0,0,0,0,255,0,0,0,0,3,248,0,0,0,0,47,224,0,0,0,2,255,0,0,0,0,3,248,0,0,0,0,3,208,0,0,0,0,3,208,0,0,85,85,91,229,85,85,191,255,255,255,255,255,191,255,255,255,255,255,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,7,208,0,0,0,15,255,192,0,0,0,11,255,128,0,0,0,1,84,0,0,0,
  // 0x5b58  存
  88,91,24,26,156,26,1,253,0,0,16,0,0,0,0,0,124,0,0,0,0,0,252,0,0,0,0,0,248,0,0,0,127,255,255,255,255,253,127,255,255,255,255,253,21,91,229,85,85,84,0,15,192,0,0,0,0,31,64,0,0,0,0,63,15,255,255,224,0,189,15,255,255,240,1,248,0,0,31,192,3,240,0,0,127,0,15,240,0,2,252,0,63,240,0,3,224,0,255,240,0,3,208,0,185,240,255,255,255,255,16,240,255,255,255,255,0,240,85,87,213,84,0,240,0,3,208,0,0,240,0,3,208,0,0,240,0,3,208,0,0,240,0,3,208,0,0,240,3,255,192,0,0,240,3,255,128,0,0,0,0,64,0,0,
  // 0x5b89  安
  137,91,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,63,255,255,255,255,252,63,255,255,255,255,252,63,0,0,0,0,252,62,0,4,0,0,188,62,0,63,0,0,188,62,0,125,0,0,188,0,0,188,0,0,0,21,85,253,85,85,84,127,255,255,255,255,253,127,255,255,255,255,253,0,11,192,0,248,0,0,15,128,1,244,0,0,63,0,3,240,0,0,126,0,7,224,0,0,255,208,15,192,0,1,255,254,127,64,0,0,160,191,254,0,0,0,0,15,255,128,0,0,0,191,239,253,0,0,111,254,2,255,192,47,255,224,0,47,240,15,249,0,0,3,208,0,0,0,0,0,0,
  // 0x5b8c  完
  140,91,24,25,150,26,1,253,0,0,7,192,0,0,0,0,7,192,0,0,21,85,91,213,85,84,63,255,255,255,255,252,63,255,255,255,255,252,62,0,0,0,0,188,62,0,0,0,0,188,62,63,255,255,252,188,0,63,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,253,127,255,255,255,255,253,21,87,229,111,85,84,0,3,208,31,0,0,0,7,192,31,0,0,0,15,192,31,0,0,0,15,128,31,0,20,0,63,0,31,0,30,0,254,0,31,0,46,11,252,0,31,64,125,191,224,0,15,255,252,62,0,0,7,255,244,16,0,0,0,0,0,
  // 0x5b9a  定
  154,91,24,25,150,26,1,253,0,0,7,192,0,0,0,0,7,192,0,0,5,85,91,213,85,80,63,255,255,255,255,252,63,255,255,255,255,252,62,0,0,0,0,188,62,0,0,0,0,188,62,21,85,85,84,188,61,127,255,255,253,188,0,127,255,255,253,0,0,0,7,192,0,0,0,0,7,192,0,0,0,124,7,192,0,0,0,188,7,192,0,0,0,248,7,255,255,128,0,248,7,255,255,128,1,252,7,213,85,0,2,253,7,192,0,0,3,255,7,192,0,0,11,223,199,192,0,0,15,135,251,192,0,0,63,65,255,233,85,85,254,0,47,255,255,253,120,0,1,191,255,252,0,0,0,0,0,0,
  // 0x5ba2  客
  162,91,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,63,255,255,255,255,252,63,255,255,255,255,252,62,0,100,0,0,188,61,0,252,0,0,188,61,3,255,255,244,188,0,31,255,255,252,0,0,191,192,3,240,0,11,255,240,15,208,0,15,209,253,127,64,0,6,0,127,252,0,0,0,0,47,253,0,0,0,7,255,255,228,0,1,191,244,31,255,233,191,255,64,0,191,253,127,255,255,255,254,252,36,63,255,255,253,0,0,60,0,0,61,0,0,60,0,0,61,0,0,60,0,0,61,0,0,63,255,255,253,0,0,63,255,255,253,0,0,60,0,0,61,0,0,0,0,0,0,0,
  // 0x5bab  宫
  171,91,22,26,156,26,2,253,0,0,4,0,0,0,0,0,62,0,0,0,0,0,47,0,0,0,85,85,111,149,85,80,255,255,255,255,255,240,255,255,255,255,255,240,248,0,0,0,2,240,248,0,0,0,2,240,249,255,255,255,246,240,17,255,255,255,244,80,1,240,0,0,244,0,1,240,0,0,244,0,1,240,0,0,244,0,1,255,255,255,244,0,1,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,0,15,255,255,255,255,0,15,64,0,0,31,0,15,64,0,0,31,0,15,64,0,0,31,0,15,255,255,255,255,0,15,255,255,255,255,0,15,64,0,0,31,0,0,0,0,0,0,0,
  // 0x5bf9  对
  249,91,24,26,156,26,1,253,0,0,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,63,255,252,0,7,192,63,255,252,0,7,192,21,85,188,0,7,192,0,0,249,255,255,255,0,0,245,255,255,255,0,0,244,85,91,213,15,1,240,0,7,192,31,194,240,0,7,192,7,243,224,176,7,192,1,255,208,248,7,192,0,191,192,125,7,192,0,47,192,63,7,192,0,31,208,31,7,192,0,63,240,15,71,192,0,126,252,5,7,192,0,252,190,0,7,192,2,244,63,0,7,192,11,224,28,0,7,192,47,192,0,0,11,192,191,0,0,7,255,192,60,0,0,3,255,64,0,0,0,1,148,0,
  // 0x5c06  将
  6,92,24,26,156,26,1,253,0,20,0,0,0,64,0,124,0,0,111,224,0,124,22,255,255,240,0,124,255,255,229,0,116,124,169,64,0,16,188,124,0,31,0,124,61,124,124,15,64,252,47,124,61,15,130,240,15,188,31,11,135,208,15,188,15,6,79,128,0,124,14,0,47,0,0,124,0,0,15,64,0,124,0,0,15,64,0,124,255,255,255,255,0,124,255,255,255,255,2,252,1,0,15,128,31,252,7,0,15,64,191,252,15,192,15,64,253,124,3,224,15,64,176,124,1,244,15,64,0,124,0,252,15,64,0,124,0,116,15,64,0,124,0,0,15,64,0,124,0,11,255,64,0,124,0,7,254,0,0,20,0,1,80,0,
  // 0x5c0f  小
  15,92,24,25,150,26,1,253,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,144,3,208,10,0,0,248,3,208,63,0,1,244,3,208,31,128,2,240,3,208,15,192,3,224,3,208,7,224,7,208,3,208,3,240,11,192,3,208,1,244,15,192,3,208,0,252,31,64,3,208,0,188,63,0,3,208,0,126,190,0,3,208,0,63,188,0,3,208,0,47,20,0,3,208,0,29,0,0,3,208,0,0,0,0,3,208,0,0,0,0,7,208,0,0,0,15,255,208,0,0,0,11,255,128,0,0,0,2,148,0,0,0,
  // 0x5c31  就
  49,92,24,26,156,26,1,253,0,5,0,0,80,0,0,47,0,0,244,64,0,47,0,0,247,224,0,47,0,0,244,244,191,255,255,128,244,124,191,255,255,128,244,61,0,0,0,0,244,20,0,0,0,21,249,84,31,255,254,127,255,255,31,255,254,127,255,255,31,0,46,0,240,0,31,0,46,1,254,0,31,0,46,1,254,0,31,255,254,2,254,0,31,255,254,3,254,0,0,31,0,3,254,0,9,31,28,7,238,0,31,31,61,11,222,0,47,31,31,15,158,0,61,31,15,47,30,10,124,31,15,127,30,11,248,31,0,188,30,11,176,31,1,248,31,95,3,254,7,240,31,255,2,252,3,192,11,252,0,0,0,0,0,0,
  // 0x5c4f  屏
  79,92,24,24,144,26,1,253,7,255,255,255,255,240,7,255,255,255,255,240,7,192,0,0,1,240,7,192,0,0,1,240,7,255,255,255,255,240,7,255,255,255,255,240,7,192,120,0,31,0,7,192,188,0,63,0,7,192,61,0,61,0,7,192,46,0,124,0,7,207,255,255,255,252,7,207,255,255,255,252,11,192,31,0,184,0,11,128,31,0,184,0,15,128,31,0,184,0,15,191,255,255,255,254,15,127,255,255,255,254,31,0,62,0,184,0,47,0,124,0,184,0,62,1,252,0,184,0,125,7,240,0,184,0,252,63,208,0,184,0,116,15,0,0,184,0,0,0,0,0,84,0,
  // 0x5de5  工
  229,93,24,21,126,26,1,255,5,85,85,85,85,80,15,255,255,255,255,244,15,255,255,255,255,244,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,191,255,255,255,255,254,191,255,255,255,255,254,85,85,85,85,85,85,
  // 0x5dee  差
  238,93,24,25,150,26,1,253,0,47,0,0,252,0,0,31,64,1,244,0,0,11,192,3,224,0,31,255,255,255,255,244,31,255,255,255,255,244,0,0,7,208,0,0,0,0,7,192,0,0,3,255,255,255,255,192,3,255,255,255,255,192,0,0,7,192,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,47,0,0,0,0,0,62,0,0,0,0,0,62,255,255,255,192,0,188,255,255,255,192,0,252,0,61,0,0,1,244,0,61,0,0,3,240,0,61,0,0,11,208,0,61,0,0,47,128,0,61,0,0,191,31,255,255,255,252,124,31,255,255,255,252,0,0,0,0,0,0,
  // 0x5df2  已
  242,93,23,23,138,26,2,254,127,255,255,255,253,0,127,255,255,255,253,0,21,85,85,85,125,0,0,0,0,0,61,0,0,0,0,0,61,0,31,0,0,0,61,0,31,0,0,0,61,0,31,0,0,0,61,0,31,0,0,0,61,0,31,255,255,255,253,0,31,255,255,255,253,0,31,149,85,85,125,0,31,0,0,0,41,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,144,31,0,0,0,0,248,31,0,0,0,0,248,15,64,0,0,1,244,15,128,0,0,7,240,15,255,255,255,255,224,2,255,255,255,255,128,0,21,85,85,84,0,
  // 0x5e73  平
  115,94,24,24,144,26,1,253,5,85,85,85,85,80,15,255,255,255,255,240,15,255,255,255,255,240,0,0,7,192,0,0,0,160,7,192,14,64,0,244,7,192,31,64,0,252,7,192,47,0,0,124,7,192,61,0,0,62,7,192,188,0,0,46,7,192,244,0,0,0,7,192,16,0,85,85,91,229,85,85,191,255,255,255,255,254,191,255,255,255,255,254,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,1,64,0,0,
  // 0x5e76  并
  118,94,24,26,156,26,1,253,0,4,0,0,16,0,0,61,0,0,126,0,0,47,0,0,252,0,0,15,128,1,244,0,0,11,192,3,240,0,0,3,128,2,192,0,47,255,255,255,255,252,47,255,255,255,255,252,5,95,213,87,245,80,0,11,128,2,240,0,0,11,128,2,240,0,0,11,128,2,240,0,0,11,128,2,240,0,21,95,213,87,245,84,191,255,255,255,255,254,191,255,255,255,255,254,0,15,64,2,240,0,0,31,0,2,240,0,0,47,0,2,240,0,0,62,0,2,240,0,0,252,0,2,240,0,2,248,0,2,240,0,15,240,0,2,240,0,127,192,0,2,240,0,46,0,0,2,240,0,4,0,0,1,80,0,
  // 0x5e8a  床
  138,94,24,26,156,26,1,253,0,0,0,80,0,0,0,0,1,240,0,0,0,0,1,240,0,0,0,0,1,240,0,0,15,255,255,255,255,254,15,255,255,255,255,254,15,149,85,85,85,84,15,128,0,61,0,0,15,128,0,61,0,0,15,128,0,61,0,0,15,133,85,126,85,84,15,159,255,255,255,254,15,159,255,255,255,254,15,64,1,255,128,0,15,64,3,255,208,0,15,64,7,255,240,0,15,0,15,190,252,0,31,0,63,61,62,0,31,0,252,61,31,128,47,3,244,61,11,240,62,31,224,61,2,253,61,63,128,61,0,191,188,45,0,61,0,44,248,0,0,61,0,0,112,0,0,61,0,0,0,0,0,20,0,0,
  // 0x5e94  应
  148,94,24,26,156,26,1,253,0,0,0,80,0,0,0,0,3,240,0,0,0,0,1,244,0,0,0,0,0,248,0,0,15,255,255,255,255,253,15,255,255,255,255,253,15,149,85,85,85,84,15,128,0,0,0,0,15,128,1,224,0,224,15,130,2,240,1,240,15,143,65,240,2,240,15,139,192,244,3,224,15,135,192,184,7,192,15,131,208,124,11,192,15,66,240,124,15,128,15,65,240,61,31,0,15,64,244,62,62,0,15,0,248,36,60,0,31,0,184,0,184,0,47,0,0,0,244,0,46,0,0,2,240,0,62,0,0,3,208,0,125,127,255,255,255,255,188,127,255,255,255,255,184,21,85,85,85,84,0,0,0,0,0,0,
  // 0x5e9f  废
  159,94,24,26,156,26,1,253,0,0,0,80,0,0,0,0,2,240,0,0,0,0,0,248,0,0,15,255,255,255,255,254,15,255,255,255,255,254,15,149,85,85,85,84,15,65,160,124,8,0,15,66,240,188,62,0,15,67,224,248,31,128,15,71,208,244,11,192,15,79,193,244,3,128,15,95,255,255,255,252,15,79,255,255,255,252,15,64,3,192,0,0,15,64,11,192,0,0,15,0,31,255,255,128,31,0,63,255,255,192,31,0,191,64,47,64,47,1,255,192,126,0,47,7,243,245,252,0,62,47,192,255,240,0,61,255,0,127,224,0,188,184,11,255,255,64,252,17,255,224,127,253,116,0,254,0,6,252,0,0,80,0,0,16,
  // 0x5ea6  度
  166,94,24,26,156,26,1,253,0,0,0,80,0,0,0,0,1,240,0,0,0,0,1,240,0,0,15,255,255,255,255,253,15,255,255,255,255,253,15,128,20,0,20,0,15,64,61,0,61,0,15,64,61,0,61,0,15,127,255,255,255,253,15,127,255,255,255,253,15,64,61,0,61,0,15,64,61,0,61,0,15,64,63,255,253,0,15,64,63,255,253,0,15,64,0,0,0,0,15,0,0,0,0,0,15,31,255,255,255,208,31,31,255,255,255,192,31,0,124,0,31,128,46,0,47,64,127,0,61,0,11,231,248,0,61,0,2,255,208,0,188,0,111,255,249,0,248,127,255,230,255,254,112,63,228,0,27,252,0,4,0,0,0,20,
  // 0x5f00  开
  0,95,24,24,144,26,1,253,47,255,255,255,255,252,47,255,255,255,255,252,5,91,213,86,245,80,0,11,192,1,240,0,0,11,192,1,240,0,0,11,192,1,240,0,0,11,192,1,240,0,0,11,192,1,240,0,0,11,192,1,240,0,0,11,192,1,240,0,191,255,255,255,255,254,191,255,255,255,255,254,21,95,213,86,245,84,0,15,128,1,240,0,0,15,64,1,240,0,0,47,0,1,240,0,0,63,0,1,240,0,0,125,0,1,240,0,0,252,0,1,240,0,3,244,0,1,240,0,15,224,0,1,240,0,127,192,0,1,240,0,46,0,0,1,240,0,4,0,0,0,80,0,
  // 0x5f03  弃
  3,95,24,25,150,26,1,253,0,0,7,192,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,1,248,0,0,0,0,2,240,1,224,0,0,3,208,2,252,0,0,11,192,0,127,64,5,95,255,255,255,208,63,255,255,255,255,244,47,234,149,80,0,252,0,5,64,1,144,32,0,15,128,2,224,0,0,15,128,2,224,0,0,15,128,3,240,0,191,255,255,255,255,254,191,255,255,255,255,254,0,31,64,2,224,0,0,47,0,2,224,0,0,126,0,2,224,0,1,252,0,2,224,0,11,240,0,2,224,0,191,192,0,2,224,0,62,0,0,2,224,0,16,0,0,1,64,0,
  // 0x5f0f  式
  15,95,24,25,150,26,1,253,0,0,0,47,11,0,0,0,0,47,15,192,0,0,0,47,3,240,0,0,0,31,0,240,21,85,85,111,85,164,127,255,255,255,255,254,127,255,255,255,255,254,0,0,0,31,64,0,0,0,0,15,64,0,0,0,0,15,64,0,5,85,85,15,128,0,47,255,255,143,128,0,47,255,255,139,192,0,0,15,0,11,192,0,0,15,0,7,192,0,0,15,0,3,208,0,0,15,0,3,224,0,0,15,0,3,240,8,0,15,0,1,240,15,0,15,91,208,248,15,0,111,255,224,188,31,63,255,249,64,127,46,63,249,0,0,47,253,41,0,0,0,11,252,0,0,0,0,1,80,
  // 0x5f15  引
  21,95,20,25,125,26,2,253,0,0,0,0,31,127,255,252,0,31,127,255,252,0,31,0,0,60,0,31,0,0,60,0,31,0,0,60,0,31,0,0,124,0,31,63,255,252,0,31,63,255,252,0,31,61,0,0,0,31,60,0,0,0,31,124,0,0,0,31,188,0,0,0,31,191,255,252,0,31,255,255,252,0,31,244,0,124,0,31,0,0,124,0,31,0,0,188,0,31,0,0,188,0,31,0,0,248,0,31,0,0,244,0,31,0,2,240,0,31,11,255,240,0,31,3,255,208,0,31,1,85,0,0,5,
  // 0x5f39  弹
  57,95,24,25,150,26,1,253,0,0,2,192,3,224,127,255,3,240,7,208,127,255,0,244,11,192,0,31,0,188,31,0,0,31,0,32,62,0,0,31,31,255,255,252,0,31,31,255,255,252,63,255,31,3,208,124,63,255,31,3,208,124,60,0,31,255,255,252,60,0,31,255,255,252,60,0,31,3,208,124,60,0,31,3,208,124,63,255,31,255,255,252,127,255,31,255,255,252,0,31,0,3,208,0,0,31,0,3,208,0,0,30,0,3,224,0,0,46,191,255,255,255,0,46,191,255,255,255,0,61,0,3,208,0,0,61,0,3,208,0,47,252,0,3,208,0,31,244,0,3,208,0,5,0,0,1,64,0,
  // 0x5f52  归
  82,95,22,25,150,26,2,253,0,46,0,0,0,0,0,46,0,0,0,0,0,46,31,255,255,224,248,46,31,255,255,224,248,46,5,85,87,224,248,46,0,0,2,224,248,46,0,0,2,224,248,46,0,0,2,224,248,46,0,0,2,224,248,46,0,0,2,224,248,46,1,85,87,224,248,46,11,255,255,224,248,46,11,255,255,224,248,62,0,0,2,224,248,62,0,0,2,224,248,61,0,0,2,224,0,124,0,0,2,224,0,188,0,0,2,224,0,248,0,0,2,224,2,244,21,85,87,224,3,240,63,255,255,224,15,208,63,255,255,224,63,128,0,0,2,224,30,0,0,0,2,224,0,0,0,0,0,0,
  // 0x5f84  径
  132,95,24,24,144,26,1,254,0,61,0,0,0,0,0,252,63,255,255,244,3,244,63,255,255,240,15,208,2,192,3,224,127,128,3,224,7,192,253,9,1,244,31,128,52,47,64,189,63,0,0,62,0,63,252,0,0,252,0,15,240,0,3,244,0,127,253,0,15,240,7,253,191,228,63,240,255,224,11,255,255,240,254,1,65,189,249,240,80,3,192,4,97,240,0,3,192,0,1,240,0,7,192,0,1,240,63,255,255,248,1,240,63,255,255,248,1,240,0,3,192,0,1,240,0,3,192,0,1,240,0,3,192,0,1,241,255,255,255,255,1,241,255,255,255,255,1,240,0,0,0,0,
  // 0x5f85  待
  133,95,24,25,150,26,1,253,0,61,0,7,192,0,0,252,0,7,192,0,2,244,0,7,192,0,15,208,63,255,255,248,63,128,63,255,255,248,189,4,0,11,192,0,48,47,0,7,192,0,0,125,0,7,192,0,0,249,255,255,255,255,3,241,255,255,255,255,15,240,0,0,15,128,63,240,0,0,15,64,255,240,0,0,15,64,249,240,255,255,255,255,97,240,255,255,255,255,1,240,1,0,15,128,1,240,11,0,15,64,1,240,15,192,15,64,1,240,7,224,15,64,1,240,2,240,15,64,1,240,0,244,15,64,1,240,0,64,15,64,1,240,0,11,255,64,1,240,0,3,254,0,0,80,0,1,80,0,
  // 0x5faa  循
  170,95,24,25,150,26,1,253,0,124,0,0,6,224,0,248,0,90,255,244,3,240,127,255,254,64,15,192,127,165,244,0,127,0,124,0,244,0,252,20,124,0,244,0,112,62,127,255,255,255,0,188,127,255,255,255,2,244,124,0,240,0,7,240,124,0,240,0,47,224,120,255,255,252,191,224,184,255,255,252,254,224,184,240,0,124,178,224,184,240,0,124,2,224,184,250,170,252,2,224,244,255,255,252,2,224,244,240,0,124,2,224,240,240,0,124,2,225,240,255,255,252,2,226,240,250,170,252,2,227,224,240,0,124,2,231,192,250,170,252,2,231,192,255,255,252,2,225,64,240,0,124,0,0,0,0,0,0,
  // 0x5fae  微
  174,95,24,26,156,26,1,253,0,0,4,0,0,0,1,240,14,0,61,0,3,224,14,0,60,0,15,199,78,44,60,0,63,7,78,44,124,0,253,7,78,44,184,0,244,151,78,44,255,255,16,251,78,44,255,255,3,247,255,254,240,124,7,215,255,255,240,120,15,192,0,7,244,184,63,192,0,11,244,180,255,203,255,255,120,240,251,203,255,253,60,240,163,192,241,240,62,240,3,192,241,224,47,208,3,192,241,224,31,192,3,193,225,224,15,192,3,193,225,225,15,128,3,194,209,255,31,192,3,195,195,254,63,224,3,203,195,208,253,244,3,207,64,3,240,189,3,206,0,15,208,63,3,192,0,7,0,13,1,64,0,0,0,0,
  // 0x5fc3  心
  195,95,24,24,144,26,1,254,0,0,248,0,0,0,0,2,255,128,0,0,0,0,127,248,0,0,0,0,7,255,64,0,0,0,0,127,192,0,0,0,0,11,64,0,0,0,0,0,0,0,0,3,208,0,0,0,0,3,208,0,2,0,6,67,208,0,31,64,15,131,208,0,15,192,15,131,208,0,7,224,15,67,208,0,3,240,31,3,208,0,0,248,31,3,208,0,0,188,63,3,208,0,0,126,61,3,208,0,16,63,188,3,208,0,60,47,252,3,208,0,60,30,112,3,208,0,60,0,0,3,208,0,124,0,0,3,224,1,252,0,0,2,255,255,244,0,0,0,191,255,208,0,
  // 0x5ffd  忽
  253,95,24,24,144,26,1,254,0,11,128,0,0,0,0,15,128,0,0,0,0,63,64,0,0,0,0,127,255,255,255,240,1,255,255,255,255,224,3,240,61,15,131,224,31,192,252,31,3,224,127,66,240,63,3,224,44,11,208,125,3,208,0,47,128,248,3,208,0,190,3,240,3,192,7,248,15,192,7,192,15,208,63,64,15,192,3,1,253,7,255,64,0,3,244,3,254,0,0,0,139,64,0,0,0,0,15,240,1,0,3,211,209,252,31,64,3,211,208,56,15,208,11,195,208,0,83,240,31,67,208,0,180,252,127,3,224,1,244,126,124,3,255,255,240,45,0,0,191,255,208,0,
  // 0x6027  性
  39,96,24,26,156,26,1,253,1,80,0,1,64,0,2,224,0,3,208,0,2,224,7,195,208,0,2,224,11,195,208,0,2,224,15,131,208,0,18,254,15,67,208,0,58,255,31,255,255,252,58,235,111,255,255,252,122,227,254,87,229,84,182,227,252,3,208,0,178,224,252,3,208,0,242,224,180,3,208,0,242,224,16,3,208,0,2,224,0,7,224,0,2,224,31,255,255,244,2,224,31,255,255,244,2,224,0,3,208,0,2,224,0,3,208,0,2,224,0,3,208,0,2,224,0,3,208,0,2,224,0,3,208,0,2,224,0,3,208,0,2,224,255,255,255,254,2,224,255,255,255,254,2,224,85,85,85,84,0,64,0,0,0,0,
  // 0x603b  总
  59,96,24,24,144,26,1,254,0,11,0,0,244,0,0,15,192,1,244,0,0,7,208,3,240,0,0,3,240,7,208,0,0,1,224,15,192,0,1,255,255,255,255,64,1,255,255,255,255,64,1,245,85,85,95,64,1,244,0,0,31,64,1,244,0,0,31,64,1,244,0,0,31,64,1,244,0,0,31,64,1,255,255,255,255,64,1,255,255,255,255,64,0,0,3,0,0,0,0,5,79,208,0,64,10,79,195,248,3,192,15,79,192,190,3,240,31,15,192,45,0,248,47,15,192,4,16,124,62,15,192,0,61,62,188,11,208,0,125,29,24,7,255,255,252,0,0,2,255,255,244,0,
  // 0x6062  恢
  98,96,24,25,150,26,1,253,2,224,46,0,0,0,2,224,46,0,0,0,2,224,46,0,0,0,2,225,255,255,255,255,2,234,255,255,255,255,54,253,46,0,16,0,58,239,46,0,184,0,54,235,46,0,184,0,118,231,110,0,184,4,114,227,110,52,184,46,178,224,46,116,184,60,226,224,45,116,184,60,66,224,45,176,184,180,2,224,61,240,184,240,2,224,61,224,252,160,2,224,60,0,252,0,2,224,60,2,253,0,2,224,184,3,223,0,2,224,244,7,207,64,2,224,240,15,71,192,2,226,240,62,3,240,2,227,225,252,0,252,2,235,199,240,0,127,2,227,131,128,0,30,1,64,0,0,0,0,
  // 0x606f  息
  111,96,24,26,156,26,1,253,0,0,1,64,0,0,0,0,11,208,0,0,0,0,15,192,0,0,0,255,255,255,255,0,0,255,255,255,255,0,0,244,0,0,15,0,0,255,255,255,255,0,0,255,255,255,255,0,0,244,0,0,15,0,0,244,0,0,15,0,0,255,255,255,255,0,0,255,255,255,255,0,0,244,0,0,15,0,0,244,0,0,15,0,0,255,255,255,255,0,0,255,255,255,255,0,0,0,11,0,0,0,0,0,15,192,1,0,7,199,195,240,15,128,11,199,192,252,11,224,15,71,192,112,2,244,63,7,192,0,240,252,189,7,192,0,240,63,120,3,255,255,240,30,0,1,255,255,208,0,0,0,0,0,0,0,
  // 0x611f  感
  31,97,24,25,150,26,1,254,0,0,0,20,20,0,0,0,0,61,63,64,0,0,0,61,11,192,11,255,255,255,255,253,11,255,255,255,255,253,11,64,0,31,0,0,11,64,0,15,3,128,15,111,255,207,75,192,15,90,170,139,143,128,15,64,0,7,239,0,15,95,255,131,254,0,15,31,171,130,252,0,31,30,7,130,248,14,46,30,7,135,252,15,61,31,255,175,255,30,188,26,170,190,31,253,244,0,30,24,3,252,32,0,47,192,0,0,2,67,199,240,7,0,3,215,192,240,15,192,11,199,192,0,131,240,15,135,192,0,244,252,63,3,208,1,240,125,189,3,255,255,240,62,20,1,255,255,192,0,
  // 0x620f  戏
  15,98,24,25,150,26,1,253,0,0,0,62,10,0,0,0,0,62,31,128,0,0,0,62,11,224,191,255,240,62,2,240,191,255,240,62,0,208,0,1,240,47,0,0,0,2,224,47,107,253,60,3,219,255,255,254,62,3,219,255,250,80,31,71,197,111,0,64,11,207,128,15,0,244,3,255,64,15,65,240,1,255,0,15,131,224,0,190,0,15,135,192,0,127,0,11,207,128,0,255,128,7,255,0,2,255,208,3,252,0,7,227,240,3,244,8,15,193,244,15,240,31,63,64,240,63,248,30,253,0,1,254,190,61,120,0,11,244,63,252,0,0,3,192,31,252,0,0,0,0,2,240,0,0,0,0,0,0,
  // 0x6210  成
  16,98,24,26,156,26,1,253,0,0,0,20,0,0,0,0,0,61,61,0,0,0,0,61,63,128,0,0,0,61,11,240,0,0,0,61,1,208,15,255,255,255,255,254,15,255,255,255,255,254,15,213,85,126,85,85,15,128,0,62,0,0,15,128,0,47,1,144,15,192,0,47,2,240,15,255,253,47,3,224,15,255,252,31,7,192,15,128,60,15,79,128,15,128,60,15,159,64,15,128,60,15,254,0,15,128,60,11,252,0,15,64,124,7,244,0,15,64,188,7,240,13,31,47,248,31,240,31,47,31,240,127,248,30,62,0,2,253,188,46,125,0,15,244,63,189,252,0,31,208,31,252,52,0,6,0,7,240,0,0,0,0,0,0,
  // 0x6237  户
  55,98,21,26,156,26,1,253,0,0,0,64,0,0,0,0,11,192,0,0,0,0,3,208,0,0,0,0,3,240,0,0,0,0,2,244,0,0,3,255,255,255,255,192,3,255,255,255,255,192,3,224,0,0,7,192,3,224,0,0,7,192,3,224,0,0,7,192,3,224,0,0,7,192,3,224,0,0,7,192,3,255,255,255,255,192,3,255,255,255,255,192,3,229,85,85,91,192,3,208,0,0,7,192,3,208,0,0,0,0,7,192,0,0,0,0,11,192,0,0,0,0,15,128,0,0,0,0,15,64,0,0,0,0,47,0,0,0,0,0,62,0,0,0,0,0,253,0,0,0,0,0,120,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6240  所
  64,98,24,25,150,26,1,253,0,0,0,0,0,180,127,255,255,0,27,253,127,255,255,58,255,224,0,0,0,63,249,0,0,0,0,62,64,0,0,0,0,60,0,0,31,255,253,60,0,0,31,255,253,60,0,0,31,0,61,61,85,85,31,0,61,63,255,255,31,0,61,63,255,255,31,0,61,60,3,208,31,255,253,124,3,208,47,255,253,124,3,208,47,0,0,188,3,208,46,0,0,184,3,208,46,0,0,244,3,208,61,0,1,240,3,208,61,0,2,240,3,208,60,0,3,208,3,208,124,0,11,192,3,208,248,0,31,128,3,208,244,0,63,0,3,208,176,0,13,0,3,208,0,0,0,0,1,64,
  // 0x6247  扇
  71,98,23,23,138,26,1,254,63,255,255,255,255,252,63,255,255,255,255,252,0,0,0,0,0,0,3,255,255,255,255,208,7,255,255,255,255,224,7,192,0,0,3,224,7,192,0,0,3,224,7,255,255,255,255,224,7,255,255,255,255,224,7,192,0,0,0,0,7,192,0,0,0,0,7,239,255,143,255,240,7,223,255,143,255,240,11,198,7,130,65,240,11,143,135,135,209,240,15,67,215,129,241,240,15,65,135,128,129,240,31,0,103,128,45,240,62,27,251,139,253,240,125,127,71,159,145,240,252,52,11,136,1,240,244,0,255,128,47,240,16,0,190,0,31,208,
  // 0x624b  手
  75,98,24,25,150,26,1,253,0,0,0,5,191,0,0,86,175,255,255,192,15,255,255,255,164,0,11,254,171,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,15,255,255,255,255,240,15,255,255,255,255,240,5,85,87,229,85,80,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,21,85,91,229,85,85,191,255,255,255,255,254,191,255,255,255,255,254,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,7,208,0,0,0,31,255,192,0,0,0,15,255,64,0,0,0,5,80,0,0,0,
  // 0x6253  打
  83,98,24,25,150,26,1,254,0,80,0,0,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,244,15,255,255,255,0,244,15,255,255,255,0,244,5,85,126,85,191,255,224,0,62,0,191,255,224,0,62,0,21,249,64,0,62,0,0,244,0,0,62,0,0,244,0,0,62,0,0,244,0,0,62,0,0,249,160,0,62,0,1,255,240,0,62,0,191,255,144,0,62,0,191,248,0,0,62,0,116,244,0,0,62,0,0,244,0,0,62,0,0,244,0,0,62,0,0,244,0,0,62,0,0,244,0,0,62,0,0,244,0,0,62,0,17,244,0,170,189,0,63,240,0,127,252,0,47,208,0,63,224,0,
  // 0x6267  执
  103,98,24,26,156,26,1,253,1,80,0,84,0,0,2,224,0,184,0,0,2,224,0,184,0,0,2,224,0,184,0,0,2,224,0,184,0,0,2,224,0,184,0,0,191,255,127,255,255,64,191,255,127,255,255,64,2,224,0,184,15,64,2,224,0,184,15,64,2,224,0,248,15,64,2,224,0,244,15,64,2,251,126,244,15,64,3,255,191,240,15,64,191,254,7,252,15,64,255,224,2,255,79,64,166,224,3,255,239,64,2,224,3,211,239,64,2,224,11,192,79,64,2,224,15,128,15,64,2,224,47,0,11,78,2,224,190,0,11,143,2,226,252,0,7,223,63,235,240,0,3,254,63,195,192,0,1,252,4,0,0,0,0,0,
  // 0x6279  批
  121,98,24,26,156,26,1,253,1,64,0,0,0,0,3,208,61,0,244,0,3,208,61,0,244,0,3,208,61,0,244,0,3,208,61,0,244,0,3,208,61,0,244,0,255,255,61,0,244,0,255,255,61,0,244,40,3,224,61,0,244,189,3,208,63,252,251,248,3,208,63,252,255,208,3,208,62,84,254,0,3,239,61,0,248,0,27,255,61,0,244,0,255,249,61,0,244,0,255,208,61,0,244,0,83,208,61,0,244,0,3,208,61,0,244,0,3,208,61,0,244,0,3,208,61,0,244,13,3,208,61,0,244,15,3,208,63,188,244,15,3,210,255,253,248,46,127,211,255,164,191,253,63,130,144,0,63,248,0,0,0,0,0,0,
  // 0x6296  抖
  150,98,24,26,156,26,1,253,0,80,0,0,5,0,1,240,0,0,15,64,1,240,0,64,15,64,1,240,1,244,15,64,1,240,1,254,15,64,1,240,0,63,143,64,191,255,192,11,79,64,191,255,192,1,15,64,2,244,0,0,15,64,1,240,3,0,15,64,1,240,15,224,15,64,1,240,3,253,15,64,1,241,192,126,15,64,2,255,192,12,15,64,191,255,128,0,15,64,255,244,0,0,15,170,165,240,0,6,191,255,1,240,43,255,255,250,1,240,63,255,175,64,1,240,42,64,15,64,1,240,0,0,15,64,1,240,0,0,15,64,1,240,0,0,15,64,127,240,0,0,15,64,63,208,0,0,15,64,0,0,0,0,5,0,
  // 0x62a5  报
  165,98,24,25,150,26,1,253,1,240,0,0,0,0,1,240,15,255,255,244,1,240,15,255,255,244,1,240,15,64,0,244,1,240,15,64,0,240,191,255,207,64,1,240,191,255,207,67,255,240,86,245,79,67,255,192,1,240,15,64,0,0,1,240,15,64,0,0,1,240,15,255,255,252,1,246,143,255,255,252,2,255,207,125,0,244,191,255,143,111,0,240,255,244,15,79,66,240,181,240,15,79,195,208,1,240,15,67,235,192,1,240,15,66,255,64,1,240,15,64,255,0,1,240,15,64,255,64,1,240,15,67,255,208,1,240,15,111,215,253,191,240,15,255,64,254,127,208,15,120,0,40,20,0,0,0,0,0,
  // 0x62ac  抬
  172,98,24,26,156,26,1,253,0,80,0,0,0,0,1,240,0,47,0,0,1,240,0,63,0,0,1,240,0,62,0,0,1,240,0,124,0,0,1,240,0,252,11,0,255,255,192,244,15,192,255,255,194,240,7,224,1,244,3,208,2,240,1,240,27,234,255,252,1,240,127,255,255,253,1,240,127,250,149,47,1,246,192,0,0,30,1,255,192,0,0,0,111,255,192,0,0,0,255,244,15,255,255,240,250,240,15,255,255,240,1,240,15,64,1,240,1,240,15,64,1,240,1,240,15,64,1,240,1,240,15,64,1,240,1,240,15,64,1,240,1,240,15,255,255,240,63,240,15,255,255,240,63,208,15,128,1,240,0,0,5,0,0,0,
  // 0x62bd  抽
  189,98,24,26,156,26,1,253,0,80,0,1,64,0,1,240,0,3,208,0,1,240,0,3,208,0,1,240,0,3,208,0,1,240,0,3,208,0,1,240,0,3,208,0,255,255,133,87,229,84,255,255,175,255,255,253,2,240,47,255,255,253,1,240,46,3,208,61,1,240,46,3,208,61,1,240,46,3,208,61,1,242,110,3,208,61,2,255,174,3,224,61,191,255,111,255,255,253,255,240,47,255,255,253,166,240,46,3,208,61,1,240,46,3,208,61,1,240,46,3,208,61,1,240,46,3,208,61,1,240,46,3,208,61,1,240,47,255,255,253,2,240,47,255,255,253,127,224,46,85,85,125,63,192,46,0,0,61,0,0,4,0,0,0,
  // 0x62d4  拔
  212,98,24,26,156,26,1,253,0,80,0,20,0,0,1,240,0,188,29,0,1,240,0,188,47,192,1,240,0,188,7,244,1,240,0,184,0,248,1,240,0,184,0,16,255,255,191,255,255,254,255,255,191,255,255,254,1,240,0,248,0,0,1,240,0,252,0,0,1,240,0,252,1,160,1,240,0,253,2,224,1,246,128,254,3,208,6,255,129,255,3,192,191,254,66,255,71,192,255,240,3,235,207,128,165,240,3,211,223,64,1,240,7,194,255,0,1,240,15,128,253,0,1,240,31,64,253,0,1,240,63,2,255,0,1,240,189,7,255,208,2,241,248,47,195,248,127,227,240,255,0,255,63,193,192,120,0,29,0,0,0,0,0,0,
  // 0x62e9  择
  233,98,24,26,156,26,1,253,0,64,0,0,0,0,2,240,0,0,0,0,2,240,47,255,255,244,2,240,47,255,255,240,2,240,3,224,7,224,2,240,0,244,15,192,255,255,128,189,47,0,255,255,128,47,252,0,2,240,0,15,244,0,2,240,0,191,254,0,2,240,27,252,47,249,2,240,191,208,2,255,2,251,100,3,208,28,27,255,128,3,208,0,255,249,15,255,255,240,191,240,15,255,255,240,2,240,0,7,208,0,2,240,0,3,208,0,2,240,0,3,208,0,2,240,127,255,255,255,2,240,127,255,255,255,2,240,0,7,208,0,2,240,0,3,208,0,63,224,0,3,208,0,63,192,0,3,208,0,0,0,0,1,64,0,
  // 0x6309  按
  9,99,24,26,156,26,1,253,0,80,0,0,0,0,1,240,0,3,208,0,1,240,0,3,208,0,1,240,0,3,208,0,1,240,63,255,255,254,1,240,63,255,255,254,255,255,189,0,0,62,255,255,189,9,0,46,2,240,61,31,0,46,1,240,0,47,0,0,1,240,0,61,0,0,1,240,63,255,255,255,1,251,255,255,255,255,7,255,193,244,7,224,255,254,1,240,7,192,255,240,2,224,11,192,81,240,3,208,15,128,1,240,7,248,31,0,1,240,15,255,190,0,1,240,2,95,253,0,1,240,0,3,255,64,1,240,0,47,239,240,2,240,6,255,67,253,127,224,255,244,0,190,63,192,126,64,0,28,0,0,0,0,0,0,
  // 0x6321  挡
  33,99,23,26,156,26,1,253,0,64,0,0,0,0,2,240,0,3,208,0,2,240,5,3,208,16,2,240,47,3,208,124,2,240,15,3,208,248,2,240,15,131,208,244,255,255,139,195,209,240,255,255,131,195,210,224,22,245,3,195,211,192,2,240,0,3,209,64,2,240,5,87,229,80,2,240,63,255,255,252,2,241,127,255,255,252,2,255,128,0,0,188,191,255,64,0,0,188,255,240,0,0,0,188,166,240,31,255,255,252,2,240,31,255,255,252,2,240,0,0,0,188,2,240,0,0,0,188,2,240,0,0,0,188,2,240,127,255,255,252,2,240,127,255,255,252,127,224,21,85,85,188,63,192,0,0,0,184,0,0,0,0,0,0,
  // 0x6324  挤
  36,99,24,25,150,26,1,254,1,64,0,0,0,0,3,208,0,31,0,0,3,208,0,15,128,0,3,208,0,11,192,0,3,208,255,255,255,254,3,208,255,255,255,254,255,254,7,192,11,192,255,254,2,224,15,64,3,208,0,244,63,0,3,208,0,126,252,0,3,208,0,47,244,0,3,208,0,191,253,0,3,233,175,254,191,254,7,254,255,208,11,254,191,248,102,144,10,88,255,208,3,208,15,64,163,208,3,208,15,64,3,208,3,208,15,64,3,208,3,208,15,64,3,208,3,208,15,64,3,208,11,192,15,64,3,208,31,128,15,64,23,208,127,0,15,64,127,194,252,0,15,64,63,64,144,0,15,64,
  // 0x635f  损
  95,99,24,26,156,26,1,253,0,64,0,0,0,0,3,224,0,0,0,0,3,224,15,255,255,224,3,224,15,255,255,224,3,224,15,128,3,224,3,224,15,128,3,224,255,255,79,255,255,224,255,255,79,255,255,224,3,224,0,0,0,0,3,224,0,0,0,0,3,224,31,255,255,244,3,224,31,255,255,244,3,225,31,0,0,244,3,255,159,0,0,244,47,255,159,7,192,244,255,244,31,7,192,244,251,224,31,7,192,244,67,224,31,7,192,244,3,224,31,11,192,244,3,224,31,15,128,244,3,224,0,63,29,0,3,224,1,253,63,128,3,224,31,244,11,244,127,209,255,192,1,254,63,192,249,0,0,62,20,0,0,0,0,4,
  // 0x6362  换
  98,99,24,26,156,26,1,253,1,64,0,0,0,0,3,208,0,188,0,0,3,208,0,248,0,0,3,208,2,255,255,128,3,208,7,255,255,192,3,208,15,128,31,64,255,254,63,0,62,0,255,255,255,255,255,240,3,224,127,255,255,240,3,208,47,7,193,240,3,208,31,7,193,240,3,208,31,7,193,240,3,234,31,7,193,240,7,255,31,7,193,240,255,253,31,11,193,240,255,208,255,255,255,254,83,208,255,255,255,254,3,208,0,47,208,0,3,208,0,63,240,0,3,208,0,252,248,0,3,208,2,244,62,0,3,208,15,224,31,128,3,208,127,128,11,244,127,211,253,0,1,255,63,195,224,0,0,45,20,0,0,0,0,0,
  // 0x6389  掉
  137,99,24,26,156,26,1,253,0,64,0,1,0,0,3,224,0,11,192,0,3,224,0,11,192,0,3,224,0,11,255,254,3,224,0,11,255,254,3,224,0,11,192,0,255,255,0,11,192,0,255,255,127,255,255,244,3,224,63,255,255,244,3,224,60,0,0,244,3,224,60,0,0,244,3,224,63,255,255,244,3,230,63,255,255,244,3,255,124,0,0,244,191,255,60,0,0,244,255,224,63,255,255,244,103,224,63,255,255,244,3,224,0,11,192,0,3,224,0,11,192,0,3,225,255,255,255,255,3,225,255,255,255,255,3,224,0,11,192,0,3,224,0,11,192,0,191,208,0,11,192,0,127,128,0,11,192,0,0,0,0,1,64,0,
  // 0x63a2  探
  162,99,24,26,156,26,1,253,1,64,0,0,0,0,3,208,0,0,0,0,3,208,127,255,255,253,3,208,127,255,255,253,3,208,124,0,0,45,3,208,120,124,60,45,255,255,120,184,60,45,255,255,0,248,60,0,3,224,0,240,60,14,3,208,3,240,60,15,3,208,111,192,63,254,3,208,127,1,95,252,3,235,32,7,192,0,3,255,0,7,192,0,191,255,0,7,192,0,255,224,191,255,255,254,167,208,191,255,255,254,3,208,0,63,252,0,3,208,0,255,254,0,3,208,3,247,207,128,3,208,15,199,199,224,3,208,127,7,193,252,3,211,252,7,192,127,127,208,224,7,192,28,63,128,0,7,192,0,0,0,0,0,0,0,
  // 0x63a5  接
  165,99,24,26,156,26,1,253,0,80,0,0,0,0,1,240,0,7,192,0,1,240,0,7,192,0,1,240,63,255,255,252,1,240,63,255,255,252,1,240,1,208,11,192,255,255,2,224,15,128,255,255,1,240,15,0,2,240,0,240,31,0,1,240,0,244,46,0,1,240,255,255,255,255,1,240,255,255,255,255,1,241,0,62,0,0,2,255,0,124,0,0,191,255,255,255,255,255,255,240,255,255,255,255,230,240,2,240,15,128,1,240,3,208,15,64,1,240,11,192,47,0,1,240,15,253,126,0,1,240,11,191,252,0,1,240,0,15,254,0,2,240,1,191,255,224,127,225,255,253,7,252,63,192,254,64,0,120,4,0,64,0,0,0,
  // 0x63a7  控
  167,99,24,26,156,26,1,253,1,64,0,1,64,0,3,208,0,7,192,0,3,208,0,7,192,0,3,208,255,255,255,254,3,208,255,255,255,254,3,208,244,120,60,46,255,255,244,184,60,30,255,255,244,184,60,26,3,224,0,244,60,0,3,208,1,240,60,13,3,208,3,224,60,30,3,208,47,192,63,253,3,255,191,0,47,248,11,255,36,0,0,0,255,244,0,0,0,0,255,208,63,255,255,248,83,208,63,255,255,248,3,208,0,11,192,0,3,208,0,7,192,0,3,208,0,7,192,0,3,208,0,7,192,0,3,208,0,7,192,0,3,209,255,255,255,255,127,209,255,255,255,255,63,128,0,0,0,0,0,0,0,0,0,0,
  // 0x63d0  提
  208,99,24,26,156,26,1,253,1,64,0,0,0,0,3,208,31,255,255,240,3,208,31,255,255,240,3,208,31,0,0,240,3,208,31,0,0,240,3,208,31,255,255,240,255,255,31,170,170,240,255,255,31,0,0,240,3,208,31,0,0,240,3,208,31,255,255,240,3,208,31,255,255,240,3,208,0,0,0,0,3,214,191,255,255,253,7,255,191,255,255,253,191,254,0,7,192,0,255,208,14,7,192,0,167,208,15,7,192,0,3,208,31,7,255,240,3,208,47,7,255,240,3,208,63,71,192,0,3,208,63,199,192,0,3,208,250,247,192,0,3,209,240,255,192,0,127,199,224,47,255,255,63,131,192,6,255,254,0,0,0,0,0,0,
  // 0x63d2  插
  210,99,24,25,150,26,1,253,3,208,0,0,1,160,3,208,1,90,255,244,3,208,63,255,255,228,3,208,63,171,208,0,3,208,0,3,192,0,255,255,0,7,192,0,255,255,255,255,255,254,3,208,255,255,255,254,3,208,0,3,192,0,3,208,0,87,192,0,3,209,123,255,207,252,3,255,127,215,207,252,111,255,124,3,192,60,255,244,124,3,192,60,251,208,124,3,192,60,3,208,127,243,207,252,3,208,127,243,207,252,3,208,124,3,192,60,3,208,124,3,192,60,3,208,124,3,192,60,3,208,124,7,192,60,3,208,127,255,255,252,127,208,127,255,255,252,63,128,124,0,0,60,0,0,20,0,0,20,
  // 0x6536  收
  54,101,24,25,150,26,1,253,0,7,192,47,0,0,0,7,192,62,0,0,0,7,192,61,0,0,31,7,192,124,0,0,31,7,192,253,85,85,31,7,192,255,255,255,31,7,194,255,255,255,31,7,195,244,0,244,31,7,203,248,1,240,31,7,223,252,2,240,31,7,255,124,3,224,31,7,238,61,3,208,31,7,200,47,11,192,31,7,192,15,79,128,31,7,192,15,175,0,31,111,192,7,254,0,111,255,192,3,252,0,255,251,192,2,248,0,185,7,192,11,253,0,0,7,192,47,255,64,0,7,192,191,31,208,0,7,203,252,7,252,0,7,239,224,1,255,0,7,207,64,0,45,0,1,64,0,0,0,
  // 0x653e  放
  62,101,24,26,156,26,1,253,0,20,0,0,0,0,0,124,0,11,192,0,0,124,0,15,128,0,0,124,0,15,64,0,0,189,0,15,64,0,255,255,254,47,64,0,255,255,254,63,255,255,3,208,0,63,255,255,3,208,0,189,1,240,3,208,0,254,2,224,3,255,250,255,3,208,3,255,255,255,3,192,3,208,251,207,71,192,3,208,184,75,207,128,3,192,244,7,223,64,3,192,244,3,255,0,7,192,244,2,254,0,7,192,244,0,252,0,11,128,244,1,253,0,15,64,244,3,255,0,31,0,244,15,239,192,62,0,240,127,75,240,189,1,243,253,3,253,248,127,251,244,0,190,112,63,195,128,0,28,0,0,0,0,0,0,
  // 0x6570  数
  112,101,24,26,156,26,1,253,0,21,0,1,0,0,24,46,14,3,208,0,46,46,47,3,208,0,15,46,60,7,192,0,10,46,52,11,192,0,191,255,255,143,213,85,255,255,255,143,255,255,0,191,64,31,255,255,2,255,240,63,0,244,11,255,253,63,65,240,63,110,63,191,130,240,253,46,13,255,130,240,112,46,2,251,195,224,0,188,1,227,215,208,0,244,0,67,235,192,255,255,255,194,255,128,255,255,255,192,255,64,7,192,248,0,191,0,15,128,244,0,190,0,47,226,240,1,255,0,47,255,208,7,255,192,0,127,224,31,203,224,1,255,253,255,66,252,191,244,127,253,0,255,63,64,9,224,0,44,16,0,0,0,0,0,
  // 0x6572  敲
  114,101,24,26,156,26,1,253,0,0,0,0,80,0,0,46,0,0,240,0,0,46,0,0,240,0,0,46,0,0,240,0,255,255,255,128,255,254,255,255,255,128,255,254,0,0,0,0,244,0,11,255,248,0,240,0,11,234,248,0,240,0,11,64,184,1,244,0,11,234,248,255,255,252,11,255,248,255,255,248,0,0,0,29,0,244,63,255,254,31,0,240,63,255,255,15,2,240,60,0,15,11,131,224,60,85,15,7,203,192,60,255,143,3,239,128,60,210,143,1,255,0,60,210,143,0,254,0,60,231,143,1,255,0,60,255,143,11,255,208,60,208,15,127,199,248,60,0,191,254,1,255,60,0,253,116,0,44,0,0,0,0,0,0,
  // 0x6574  整
  116,101,24,25,150,26,1,254,0,4,0,1,64,0,0,46,0,3,208,0,106,191,170,71,192,0,127,255,255,75,255,254,0,46,0,31,255,254,63,255,255,63,2,240,62,127,111,255,67,208,60,46,15,251,199,192,62,191,175,34,239,128,63,255,255,0,255,0,0,255,208,0,255,0,7,255,253,7,255,208,127,110,47,191,195,253,124,46,4,253,0,189,16,4,0,16,0,4,15,255,255,255,255,240,15,255,255,255,255,240,0,0,3,192,0,0,0,0,3,192,0,0,0,184,3,255,255,0,0,184,3,255,255,64,0,184,3,192,0,0,0,184,3,192,0,0,191,255,255,255,255,254,191,255,255,255,255,254,
  // 0x6599  料
  153,101,24,26,156,26,1,253,0,0,0,0,1,64,0,184,0,0,7,192,16,184,100,16,7,192,180,184,184,124,7,192,56,184,240,127,71,192,60,184,240,15,215,192,60,185,224,2,199,192,45,186,208,0,71,192,29,186,192,0,7,192,0,248,64,128,7,192,255,255,250,244,7,192,255,255,249,254,7,192,2,248,0,47,71,192,3,254,0,10,7,192,7,255,64,0,7,192,15,255,192,0,7,218,30,186,240,1,175,255,61,184,246,255,255,250,124,184,151,255,235,192,248,184,3,144,7,192,240,184,0,0,7,192,80,184,0,0,7,192,0,184,0,0,7,192,0,184,0,0,7,192,0,184,0,0,7,192,0,80,0,0,1,64,
  // 0x659c  斜
  156,101,25,26,182,26,0,253,0,5,0,0,0,80,0,0,15,208,0,0,248,0,0,47,244,0,0,248,0,0,62,253,3,208,248,0,0,252,63,67,244,248,0,2,244,15,208,252,248,0,7,224,7,208,62,248,0,31,192,2,64,8,248,0,127,255,255,0,0,248,0,46,255,255,6,0,248,0,0,7,192,15,192,248,0,0,7,192,3,244,248,0,47,255,255,208,188,248,0,47,255,255,208,32,248,0,0,11,192,0,0,248,64,1,7,193,0,1,255,192,3,199,207,1,191,255,192,7,199,203,175,255,253,0,11,135,199,223,228,248,0,15,7,195,212,0,248,0,47,7,194,224,0,248,0,61,7,193,128,0,248,0,8,7,192,0,0,248,0,0,255,192,0,0,248,0,0,255,0,0,0,248,0,0,0,0,0,0,0,0,
  // 0x65ad  断
  173,101,23,25,150,26,2,253,80,15,0,0,1,208,240,15,4,0,111,244,243,143,30,123,255,208,242,207,45,127,228,0,241,223,60,124,0,0,240,223,116,124,0,0,240,143,96,124,0,0,240,15,0,124,0,0,247,255,254,124,0,0,247,255,254,127,255,252,240,31,0,127,255,252,240,63,192,124,15,64,240,127,244,124,15,64,240,255,125,188,15,64,243,223,28,184,15,64,255,143,0,184,15,64,247,15,0,244,15,64,240,15,0,244,15,64,240,5,1,240,15,64,255,255,255,224,15,64,255,255,255,208,15,64,240,0,15,192,15,64,240,0,31,64,15,64,80,0,10,0,15,64,0,0,0,0,0,0,
  // 0x65b0  新
  176,101,24,26,156,26,1,253,0,20,0,0,0,0,0,62,0,0,1,184,0,62,0,17,191,253,127,255,255,63,255,144,127,255,255,63,144,0,11,0,180,61,0,0,11,64,244,61,0,0,7,128,240,61,0,0,3,129,224,61,0,0,191,255,255,126,0,0,191,255,255,127,255,255,0,62,0,63,255,255,0,62,0,61,3,192,0,62,0,61,3,192,191,255,255,61,3,192,191,255,255,61,3,192,0,190,0,60,3,192,1,255,128,124,3,192,3,255,240,188,3,192,15,254,252,248,3,192,47,62,61,240,3,192,253,62,2,240,3,192,180,62,7,224,3,192,16,62,15,192,3,192,0,62,7,64,3,192,0,20,0,0,0,0,
  // 0x65b9  方
  185,101,24,26,156,26,1,253,0,0,2,128,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,191,255,255,255,255,254,191,255,255,255,255,254,21,85,253,85,85,84,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,249,85,85,0,0,1,255,255,255,128,0,2,255,255,255,64,0,3,240,0,15,64,0,3,224,0,15,64,0,7,208,0,15,0,0,15,192,0,31,0,0,31,128,0,31,0,0,63,0,0,47,0,0,253,0,0,63,0,3,248,0,0,62,0,31,240,0,0,189,0,191,128,3,255,252,0,61,0,1,255,240,0,0,0,0,20,0,0,
  // 0x65e0  无
  224,101,24,24,144,26,1,253,5,85,85,85,85,80,15,255,255,255,255,240,15,255,255,255,255,240,0,0,11,192,0,0,0,0,11,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,191,255,255,255,255,254,191,255,255,255,255,254,21,85,95,85,85,84,0,0,47,100,0,0,0,0,62,248,0,0,0,0,62,248,0,0,0,0,188,248,0,0,0,0,252,248,0,0,0,2,244,248,0,0,0,11,224,248,0,30,0,47,192,248,0,31,1,255,0,252,0,47,27,252,0,189,85,126,191,224,0,127,255,252,62,0,0,47,255,244,0,0,0,0,0,0,
  // 0x65f6  时
  246,101,23,25,150,26,2,253,0,0,0,0,31,0,0,0,0,0,31,0,255,255,64,0,31,0,255,255,64,0,31,0,244,15,64,0,31,0,244,15,95,255,255,252,244,15,95,255,255,252,244,15,69,85,111,84,244,15,64,0,31,0,255,255,67,128,31,0,255,255,71,192,31,0,244,15,67,240,31,0,244,15,65,248,31,0,244,15,64,188,31,0,244,15,64,62,31,0,244,15,64,46,31,0,244,15,64,0,31,0,255,255,64,0,31,0,255,255,64,0,31,0,244,0,0,0,31,0,244,0,0,0,31,0,160,0,0,21,127,0,0,0,0,63,254,0,0,0,0,63,248,0,0,0,0,0,0,0,
  // 0x660e  明
  14,102,22,24,144,26,2,253,255,255,131,255,255,240,255,255,131,255,255,240,244,11,131,192,0,240,244,7,131,192,0,240,244,7,131,192,0,240,244,7,131,192,0,240,244,7,131,255,255,240,255,255,131,255,255,240,255,255,131,208,1,240,244,11,131,192,0,240,244,7,131,192,0,240,244,7,131,192,0,240,244,7,135,208,1,240,244,7,135,255,255,240,255,255,139,255,255,240,255,255,143,128,0,240,244,0,15,64,0,240,244,0,31,0,0,240,160,0,62,0,0,240,0,0,189,0,0,240,0,1,248,0,1,240,0,7,240,1,255,240,0,3,192,0,255,208,0,0,0,0,20,0,
  // 0x662f  是
  47,102,24,24,144,26,1,253,3,255,255,255,255,128,3,255,255,255,255,128,3,224,0,0,11,128,3,250,170,170,175,128,3,255,255,255,255,128,3,224,0,0,11,128,3,224,0,0,11,128,3,255,255,255,255,128,2,255,255,255,255,128,0,0,0,0,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,3,224,0,0,0,124,3,208,0,0,0,188,3,208,0,0,0,248,3,255,255,224,0,252,3,255,255,224,2,253,3,224,0,0,3,255,67,208,0,0,15,207,227,208,0,0,47,67,255,229,0,21,191,0,191,255,255,254,124,0,6,255,255,253,0,0,0,0,0,0,
  // 0x6682  暂
  130,102,24,26,156,26,1,253,0,16,0,0,0,0,0,188,0,0,6,244,127,255,255,95,255,248,191,255,255,95,233,0,7,192,0,31,0,0,15,139,128,31,0,0,47,11,128,31,0,0,63,255,255,159,255,254,63,255,255,175,255,254,0,11,128,46,7,192,5,111,255,125,7,192,127,255,254,124,7,192,122,91,128,188,7,192,0,11,128,244,7,192,0,1,0,16,2,128,1,255,255,255,255,128,2,255,255,255,255,128,2,240,0,0,15,128,2,240,0,0,15,128,2,255,255,255,255,128,2,250,170,170,175,128,2,240,0,0,15,128,2,240,0,0,15,128,2,255,255,255,255,128,2,255,255,255,255,128,1,144,0,0,6,64,
  // 0x66ab  暫
  171,102,24,26,156,26,1,253,0,20,0,0,0,0,0,46,0,0,2,240,127,255,255,106,191,248,42,191,170,63,254,64,0,46,0,62,64,0,47,255,254,61,0,0,44,46,14,61,0,0,47,255,254,63,255,254,44,46,14,63,255,254,47,255,254,60,11,128,0,46,0,124,11,128,85,126,85,248,11,128,191,255,255,240,11,128,0,46,3,208,11,128,0,25,0,128,6,128,0,255,255,255,255,0,0,255,255,255,255,0,0,244,0,0,31,0,0,244,0,0,31,0,0,255,255,255,255,0,0,254,170,170,191,0,0,244,0,0,31,0,0,244,0,0,31,0,0,255,255,255,255,0,0,255,255,255,255,0,0,160,0,0,5,0,
  // 0x66f4  更
  244,102,24,24,144,26,1,253,63,255,255,255,255,252,63,255,255,255,255,252,0,0,7,224,0,0,0,0,3,208,0,0,3,255,255,255,255,224,3,255,255,255,255,224,3,208,3,208,3,224,3,208,3,208,3,224,3,255,255,255,255,224,3,255,255,255,255,224,3,208,3,208,3,224,3,208,3,208,3,224,3,208,3,208,3,224,3,255,255,255,255,224,3,255,255,255,255,224,0,112,11,192,0,0,0,252,15,128,0,0,0,63,127,0,0,0,0,15,253,0,0,0,0,31,255,144,0,0,6,255,255,255,234,85,127,253,2,255,255,254,47,64,0,1,171,253,0,0,0,0,0,0,
  // 0x6700  最
  0,103,24,25,150,26,1,253,0,170,170,170,170,64,1,255,255,255,255,64,1,240,0,0,15,64,1,250,170,170,175,64,1,255,255,255,255,64,1,240,0,0,15,64,1,240,0,0,15,64,1,255,255,255,255,64,0,170,170,170,170,64,0,0,0,0,0,0,127,255,255,255,255,253,127,255,255,255,255,253,7,192,61,0,0,0,7,234,189,191,255,244,7,255,253,255,255,240,7,192,61,45,2,240,7,192,61,31,3,208,7,255,253,15,143,192,7,234,189,7,255,0,7,192,61,2,253,0,7,255,253,2,254,0,191,255,253,47,239,224,190,149,62,254,3,254,0,0,61,160,0,108,0,0,0,0,0,0,
  // 0x6709  有
  9,103,24,25,150,26,1,253,0,0,124,0,0,0,0,0,188,0,0,0,0,0,248,0,0,0,127,255,255,255,255,253,127,255,255,255,255,253,21,91,213,85,85,84,0,15,192,0,0,0,0,47,64,0,0,0,0,63,255,255,255,64,0,191,255,255,255,64,1,255,0,0,15,64,7,255,0,0,15,64,15,255,0,0,15,64,127,111,255,255,255,64,189,47,255,255,255,64,32,47,0,0,15,64,0,47,0,0,15,64,0,47,255,255,255,64,0,47,255,255,255,64,0,47,0,0,15,64,0,47,0,0,15,64,0,47,0,0,15,64,0,47,0,15,255,0,0,47,0,11,254,0,0,5,0,1,64,0,
  // 0x671f  期
  31,103,23,25,150,26,1,253,11,128,124,0,0,0,11,128,124,15,255,252,11,128,124,15,255,252,191,255,255,207,64,124,191,255,255,207,0,60,11,128,124,15,0,60,11,128,124,15,0,60,11,255,252,15,255,252,11,255,252,15,255,252,11,128,124,15,64,124,11,128,124,15,0,60,11,255,252,15,0,60,11,255,252,15,0,60,11,128,124,15,255,252,11,128,124,31,255,252,11,128,124,31,0,124,255,255,255,159,0,60,255,255,255,174,0,60,1,64,64,61,0,60,3,210,240,61,0,60,15,192,248,124,0,60,47,64,125,188,0,124,190,0,46,248,31,252,120,0,0,176,15,244,0,0,0,0,4,0,
  // 0x673a  机
  58,103,25,26,182,26,1,253,0,20,0,0,0,0,0,0,188,0,0,0,0,0,0,188,0,255,255,128,0,0,188,0,255,255,128,0,0,188,0,245,95,128,0,0,188,0,240,11,128,0,191,255,244,240,11,128,0,191,255,244,240,11,128,0,21,253,80,240,11,128,0,0,252,0,240,11,128,0,1,252,0,240,11,128,0,3,254,0,240,11,128,0,3,255,129,240,11,128,0,11,255,209,240,11,128,0,15,189,241,240,11,128,0,46,188,182,240,11,128,0,60,188,34,224,11,128,0,248,188,3,224,11,128,0,240,188,3,208,11,134,0,96,188,11,192,11,135,64,0,188,15,128,11,135,64,0,188,31,64,11,135,64,0,188,63,0,11,203,0,0,188,189,0,7,255,0,0,188,56,0,2,253,0,0,16,0,0,0,0,0,
  // 0x6740  杀
  64,103,24,25,150,26,1,253,0,64,0,0,46,0,3,248,0,0,255,0,2,255,128,7,248,0,0,31,253,63,208,0,0,1,255,254,0,0,0,0,63,253,0,0,0,2,255,255,208,0,0,127,248,31,253,0,27,255,128,1,255,128,63,244,0,0,47,208,14,64,3,208,3,128,0,0,3,208,0,0,0,0,7,208,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,3,208,0,0,0,40,3,208,32,0,0,190,3,208,253,0,1,248,3,208,63,64,7,240,3,208,11,224,47,192,3,208,2,244,191,0,3,208,0,188,56,1,255,192,0,52,0,0,255,128,0,0,0,0,80,0,0,0,
  // 0x675f  束
  95,103,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,63,255,255,255,255,252,63,255,255,255,255,252,0,0,7,208,0,0,0,0,7,192,0,0,0,0,7,192,0,0,3,255,255,255,255,208,3,255,255,255,255,208,3,208,7,208,7,208,3,192,7,192,3,208,3,192,7,192,3,208,3,192,7,192,3,208,3,255,255,255,255,208,3,255,255,255,255,208,0,0,127,253,0,0,0,0,255,255,0,0,0,3,251,223,192,0,0,31,215,199,244,0,0,255,71,192,255,64,11,252,7,192,63,228,191,208,7,192,11,254,62,0,7,192,0,188,16,0,7,192,0,4,0,0,1,64,0,0,
  // 0x6761  条
  97,103,24,25,150,26,1,253,0,0,252,0,0,0,0,2,244,0,0,0,0,11,255,255,248,0,0,47,255,255,252,0,0,191,128,2,244,0,7,255,224,11,224,0,47,226,248,47,192,0,15,64,191,254,0,0,4,0,47,252,0,0,0,0,191,255,64,0,0,31,254,127,249,64,27,255,224,7,255,253,63,253,3,192,47,252,46,64,7,192,0,100,0,0,7,208,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,191,254,0,0,0,3,247,223,192,0,0,31,199,195,248,0,1,255,7,192,255,64,31,248,7,192,47,249,191,128,7,192,2,253,56,0,7,192,0,40,0,0,1,64,0,0,
  // 0x6765  来
  101,103,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,208,0,0,0,0,7,208,0,0,5,85,91,213,85,80,15,255,255,255,255,244,15,255,255,255,255,244,0,16,7,208,9,0,0,244,7,208,15,128,0,188,7,208,47,0,0,61,7,208,62,0,0,63,7,208,124,0,0,31,7,208,248,0,21,89,91,229,117,84,127,255,255,255,255,253,127,255,255,255,255,253,0,0,127,253,0,0,0,0,255,255,0,0,0,3,247,223,192,0,0,31,199,211,244,0,0,127,7,208,253,0,2,252,7,208,63,128,47,240,7,208,15,244,255,128,7,208,2,255,61,0,7,208,0,124,0,0,7,208,0,0,0,0,1,64,0,0,
  // 0x677f  板
  127,103,24,26,156,26,1,253,0,80,0,0,0,0,0,244,0,0,0,0,0,244,3,255,255,254,0,244,3,255,255,254,0,244,3,208,0,0,0,244,3,192,0,0,191,255,211,192,0,0,191,255,211,192,0,0,1,244,3,192,0,0,2,244,7,255,255,252,3,244,7,255,255,252,3,252,7,253,0,188,7,255,7,253,0,248,15,255,135,223,0,244,14,247,219,207,2,240,45,245,235,143,131,224,60,244,139,135,203,192,248,244,15,67,255,128,240,244,15,1,255,0,160,244,31,0,254,0,0,244,62,1,255,0,0,244,125,11,255,208,0,244,252,63,199,248,0,245,244,255,1,255,0,244,176,116,0,44,0,80,0,0,0,0,
  // 0x6797  林
  151,103,24,26,156,26,1,253,0,20,0,0,84,0,0,60,0,0,248,0,0,60,0,0,248,0,0,60,0,0,248,0,0,60,0,0,248,0,0,60,0,0,248,0,191,255,252,255,255,253,191,255,252,255,255,253,21,189,80,86,254,84,0,255,0,2,254,0,0,255,128,3,255,0,2,255,224,7,255,64,3,254,244,15,255,192,7,252,188,31,255,192,15,124,56,62,250,224,31,60,16,124,249,240,61,60,0,248,248,248,252,60,3,240,248,189,244,60,11,208,248,63,112,60,15,192,248,30,0,60,3,0,248,8,0,60,0,0,248,0,0,60,0,0,248,0,0,60,0,0,248,0,0,60,0,0,248,0,0,20,0,0,80,0,
  // 0x67f1  柱
  241,103,24,26,156,26,1,253,0,84,0,0,0,0,0,184,0,15,64,0,0,184,0,31,224,0,0,184,0,3,248,0,0,184,0,0,253,0,0,184,0,0,60,0,191,255,247,255,255,254,191,255,247,255,255,254,21,253,81,85,249,84,1,248,0,0,244,0,2,252,0,0,244,0,3,254,0,0,244,0,7,255,64,0,244,0,11,255,192,1,248,0,15,186,243,255,255,253,46,184,243,255,255,253,60,184,80,0,244,0,248,184,0,0,244,0,240,184,0,0,244,0,96,184,0,0,244,0,0,184,0,0,244,0,0,184,0,0,244,0,0,184,63,255,255,255,0,184,63,255,255,255,0,184,5,85,85,85,0,0,0,0,0,0,
  // 0x6821  校
  33,104,24,25,150,26,1,253,0,240,0,2,224,0,0,240,0,2,224,0,0,240,0,2,224,0,0,240,0,3,240,0,0,240,47,255,255,254,191,249,111,255,255,254,191,255,192,0,1,0,2,244,0,248,11,192,2,240,1,244,3,224,3,248,3,224,1,244,3,252,15,192,0,188,11,255,63,240,11,191,15,255,109,248,15,157,30,247,192,124,31,0,45,242,208,62,63,0,60,240,128,31,189,0,248,240,0,15,252,0,240,240,0,7,240,0,96,240,0,11,248,0,0,240,0,47,254,0,0,240,0,254,63,192,0,240,11,248,15,248,0,240,127,208,2,255,0,240,61,0,0,124,0,80,0,0,0,0,
  // 0x683c  格
  60,104,24,26,156,26,1,253,0,16,0,0,0,0,0,244,0,31,0,0,0,244,0,63,0,0,0,244,0,126,0,0,0,244,0,255,255,240,0,244,1,255,255,240,0,244,3,240,3,208,191,255,239,248,11,192,191,255,255,189,31,64,1,244,125,47,126,0,2,252,8,15,252,0,3,254,0,7,244,0,3,255,64,31,253,0,11,251,192,191,127,192,15,246,219,248,15,253,30,244,255,224,1,255,60,244,127,255,255,252,184,244,19,255,255,240,240,244,3,192,1,240,160,244,3,192,1,240,0,244,3,192,1,240,0,244,3,192,1,240,0,244,3,255,255,240,0,244,3,255,255,240,0,244,3,208,1,240,0,0,1,64,0,0,
  // 0x68af  梯
  175,104,24,26,156,26,1,253,0,80,0,0,0,0,0,240,2,224,3,224,0,240,1,240,3,208,0,240,0,244,11,192,0,240,0,180,11,64,0,240,31,255,255,252,191,255,223,255,255,252,191,255,192,3,208,124,2,244,0,3,208,124,2,240,0,3,208,124,3,244,15,255,255,252,3,252,15,255,255,252,11,255,15,67,208,0,15,255,79,3,208,0,15,247,239,3,208,0,45,242,239,255,255,254,60,240,63,255,255,254,184,240,40,15,208,61,240,240,0,63,208,61,96,240,0,255,208,61,0,240,3,243,208,124,0,240,31,195,219,252,0,240,255,3,215,244,0,240,120,3,208,0,0,240,0,3,208,0,0,80,0,1,64,0,
  // 0x68c0  检
  192,104,24,26,156,26,1,253,0,64,0,1,0,0,2,224,0,11,192,0,2,224,0,15,192,0,2,224,0,63,224,0,2,224,0,190,248,0,2,240,2,244,126,0,191,255,11,224,47,128,191,255,47,192,11,240,3,224,255,0,2,254,3,243,251,255,255,127,7,248,211,255,255,13,11,253,0,0,0,0,15,255,0,1,0,0,31,235,68,11,64,180,46,227,46,7,128,240,62,224,15,7,129,240,186,224,15,3,194,208,242,224,11,67,195,192,98,224,11,131,199,128,2,224,7,128,15,0,2,224,0,0,30,0,2,224,0,0,60,0,2,224,255,255,255,253,2,224,255,255,255,253,2,224,0,0,0,0,0,80,0,0,0,0,
  // 0x69fd  槽
  253,105,24,26,156,26,1,253,0,0,0,20,4,0,1,240,0,60,61,0,1,240,0,60,61,0,1,240,191,255,255,255,1,240,191,255,255,255,1,240,0,60,61,0,191,255,154,190,190,168,191,255,175,255,255,252,2,240,45,44,60,60,3,240,46,190,190,188,3,240,47,255,255,252,7,248,45,44,60,60,11,252,45,44,60,60,15,255,47,255,255,252,31,251,90,170,170,168,46,243,128,0,0,0,61,242,11,255,255,240,181,240,11,255,255,240,241,240,11,128,0,240,161,240,11,234,170,240,1,240,11,255,255,240,1,240,11,128,0,240,1,240,11,128,0,240,1,240,11,255,255,240,1,240,11,255,255,240,0,80,6,64,0,160,
  // 0x6a21  模
  33,106,24,26,156,26,1,253,0,64,0,0,0,0,2,224,0,244,15,0,2,224,0,244,15,0,2,224,127,255,255,253,2,224,127,255,255,253,2,224,0,244,15,0,191,255,0,160,10,0,191,255,47,255,255,240,2,224,47,255,255,240,3,240,46,0,0,240,3,248,47,170,170,240,11,252,47,255,255,240,15,254,46,0,0,240,15,239,110,0,0,240,31,231,175,255,255,240,63,227,26,175,234,160,126,224,0,11,192,0,246,224,0,11,128,0,242,224,255,255,255,253,98,224,255,255,255,253,2,224,0,63,248,0,2,224,0,189,62,0,2,224,7,244,31,208,2,225,255,208,7,254,2,224,253,0,0,189,1,80,64,0,0,4,
  // 0x6a59  橙
  89,106,24,25,150,26,1,253,0,240,0,0,36,0,0,240,47,253,120,144,0,240,47,253,62,240,0,240,0,60,47,64,0,240,40,184,31,45,191,255,255,240,15,254,191,255,203,224,7,240,2,244,7,255,255,240,2,240,31,191,254,253,3,244,126,0,0,63,7,253,255,255,255,233,11,255,107,255,255,240,15,251,135,128,1,240,30,243,199,128,1,240,45,242,135,128,1,240,60,240,7,255,255,240,184,240,7,255,255,240,240,240,0,80,6,64,160,240,1,240,15,128,0,240,0,240,15,0,0,240,0,244,31,0,0,240,0,180,29,0,0,240,191,255,255,255,0,240,191,255,255,255,0,160,0,0,0,0,
  // 0x6b62  止
  98,107,24,24,144,26,1,255,0,0,0,80,0,0,0,0,1,244,0,0,0,0,1,244,0,0,0,0,1,244,0,0,0,0,1,244,0,0,0,0,1,244,0,0,0,80,1,244,0,0,0,240,1,244,0,0,0,240,1,244,0,0,0,240,1,249,85,80,0,240,1,255,255,244,0,240,1,255,255,244,0,240,1,244,0,0,0,240,1,244,0,0,0,240,1,244,0,0,0,240,1,244,0,0,0,240,1,244,0,0,0,240,1,244,0,0,0,240,1,244,0,0,0,240,1,244,0,0,0,240,1,244,0,0,86,249,86,249,85,85,191,255,255,255,255,254,191,255,255,255,255,254,
  // 0x6b63  正
  99,107,24,23,138,26,1,254,5,85,85,85,85,84,47,255,255,255,255,252,47,255,255,255,255,252,0,0,2,240,0,0,0,0,2,240,0,0,0,0,2,240,0,0,0,0,2,240,0,0,0,80,2,240,0,0,0,240,2,240,0,0,0,240,2,245,85,64,0,240,2,255,255,224,0,240,2,255,255,224,0,240,2,240,0,0,0,240,2,240,0,0,0,240,2,240,0,0,0,240,2,240,0,0,0,240,2,240,0,0,0,240,2,240,0,0,0,240,2,240,0,0,0,240,2,240,0,0,191,255,255,255,255,254,191,255,255,255,255,254,21,85,85,85,85,84,
  // 0x6b65  步
  101,107,24,26,156,26,1,253,0,0,1,64,0,0,0,0,3,208,0,0,0,16,3,208,0,0,0,248,3,213,85,64,0,248,3,255,255,192,0,248,3,255,255,192,0,248,3,208,0,0,0,248,3,208,0,0,21,249,87,213,85,84,191,255,255,255,255,254,191,255,255,255,255,254,0,0,3,192,0,0,0,62,3,192,4,0,0,189,3,192,15,192,2,248,3,192,31,64,15,224,3,192,63,0,127,128,3,192,126,0,46,1,255,193,252,0,4,0,255,71,240,0,0,0,0,47,208,0,0,0,1,255,64,0,0,0,47,252,0,0,0,91,255,208,0,0,7,255,249,0,0,0,3,254,64,0,0,0,0,0,0,0,0,0,
  // 0x6bd4  比
  212,107,24,24,144,26,1,254,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,16,2,240,0,62,0,244,2,245,84,62,11,252,2,255,253,62,191,208,2,255,253,63,254,0,2,240,0,63,208,0,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,13,2,240,0,62,0,15,2,240,111,62,0,31,2,255,255,62,0,31,191,255,249,47,85,126,191,249,0,31,255,253,121,0,0,11,255,244,
  // 0x6ca1  没
  161,108,24,25,150,26,1,253,10,0,0,0,0,0,31,224,15,255,254,0,7,252,15,255,254,0,0,188,15,64,62,0,0,20,15,64,62,0,0,0,15,64,62,13,0,0,31,0,62,15,52,0,62,0,62,15,191,64,252,0,47,254,47,243,244,0,15,252,2,224,128,0,0,0,0,0,255,255,255,224,0,0,255,255,255,224,0,0,91,85,91,192,0,56,15,192,15,128,0,124,7,208,47,64,0,248,3,244,190,0,1,240,0,254,248,0,3,224,0,63,240,0,11,208,0,127,224,0,15,192,7,255,254,0,47,1,191,244,191,244,62,11,255,64,31,255,8,3,228,0,1,188,0,0,0,0,0,0,
  // 0x6ce2  波
  226,108,24,26,156,26,1,253,0,0,0,1,0,0,10,0,0,11,128,0,31,208,0,11,128,0,11,248,0,11,128,0,1,252,0,15,192,16,0,36,255,255,255,254,0,0,255,255,255,253,0,0,248,11,128,124,32,0,248,11,128,248,190,0,248,11,128,240,127,224,248,11,128,0,7,208,255,255,255,224,0,64,255,255,255,240,0,0,251,208,3,208,0,0,246,224,7,192,0,80,244,240,15,128,0,244,240,188,31,64,1,241,240,62,62,0,3,241,240,31,252,0,7,211,224,15,244,0,15,195,208,15,248,0,31,71,192,127,255,64,63,15,199,253,47,244,61,31,127,240,7,254,12,30,15,64,0,124,0,0,4,0,0,0,
  // 0x6ce8  注
  232,108,24,24,144,26,1,254,11,64,0,240,0,0,15,244,2,254,0,0,7,253,0,191,192,0,0,125,0,15,244,0,0,8,0,2,240,0,0,0,85,85,229,84,0,0,255,255,255,253,36,0,255,255,255,253,191,64,0,11,192,0,127,240,0,11,192,0,3,224,0,11,192,0,0,64,0,11,192,0,0,0,0,11,192,0,0,0,63,255,255,244,0,24,63,255,255,244,0,61,21,95,213,80,0,188,0,11,192,0,0,248,0,11,192,0,2,240,0,11,192,0,7,224,0,11,192,0,15,192,0,11,192,0,47,67,255,255,255,255,47,3,255,255,255,255,5,1,85,85,85,85,
  // 0x6d17  洗
  23,109,25,26,182,26,1,253,0,0,0,1,64,0,0,10,0,14,75,192,0,0,31,208,15,75,192,0,0,11,244,31,11,192,0,0,0,252,47,11,192,0,0,0,32,63,255,255,252,0,0,0,127,255,255,252,0,0,0,189,91,213,80,0,52,0,248,11,192,0,0,191,3,240,11,192,0,0,63,208,224,11,192,0,0,7,225,85,91,213,85,0,0,131,255,255,255,255,0,0,3,255,255,255,255,0,0,0,2,240,124,0,0,0,96,3,224,124,0,0,0,248,3,224,124,0,0,1,240,3,208,124,0,0,2,240,7,192,124,0,0,3,208,11,192,124,9,0,11,192,15,64,124,15,64,15,128,63,0,124,15,0,47,1,253,0,124,15,0,62,15,244,0,63,255,0,12,3,192,0,47,252,0,0,0,0,0,0,0,0,
  // 0x6d3b  活
  59,109,24,25,150,26,1,253,10,0,0,0,27,224,31,208,0,91,255,244,11,252,127,255,255,64,0,252,63,255,192,0,0,20,20,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,16,0,85,91,213,85,125,2,255,255,255,255,127,210,255,255,255,255,11,240,0,7,192,0,0,208,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,52,63,255,255,244,0,124,63,255,255,244,0,248,61,0,0,244,1,240,61,0,0,244,3,224,61,0,0,244,11,192,61,0,0,244,15,128,61,0,0,244,63,0,63,255,255,244,62,0,63,255,255,244,8,0,62,0,0,244,0,0,20,0,0,0,
  // 0x6d41  流
  65,109,24,26,156,26,1,253,0,0,0,5,0,0,15,64,0,15,64,0,31,224,0,15,64,0,7,252,0,15,64,0,0,126,255,255,255,254,0,2,255,255,255,254,0,0,0,252,1,0,0,0,1,244,11,0,36,0,2,240,15,192,191,0,3,208,7,224,127,225,255,255,255,248,7,224,255,255,255,252,0,128,85,85,0,62,0,0,5,5,6,68,0,0,30,15,11,128,0,48,30,15,11,128,0,124,30,15,11,128,0,248,46,15,11,128,1,240,46,15,11,128,3,224,61,15,11,128,11,208,124,15,11,139,15,128,252,15,11,139,47,2,244,15,11,139,62,11,224,15,7,255,12,3,128,0,2,252,0,0,0,0,0,0,
  // 0x6d4b  测
  75,109,23,25,150,26,1,253,14,0,0,0,0,44,47,210,255,254,0,60,7,247,255,255,29,60,0,243,192,15,30,60,0,3,193,15,30,60,0,3,203,79,30,60,0,3,203,79,30,60,52,3,203,79,30,60,191,67,203,79,30,60,47,211,203,79,30,60,7,195,203,79,30,60,0,3,203,79,30,60,0,3,203,79,30,60,0,3,203,79,30,60,0,67,203,79,30,60,2,227,203,15,30,60,3,211,203,15,30,60,7,195,207,15,30,60,11,192,14,0,0,60,15,64,46,224,0,60,47,0,124,184,0,60,62,1,240,61,0,60,125,15,208,15,15,252,28,7,0,6,11,244,0,0,0,0,0,0,
  // 0x6d88  消
  136,109,23,26,156,26,1,253,0,0,0,1,64,0,14,0,16,11,192,32,31,208,188,11,192,124,7,248,61,11,192,248,0,184,47,11,193,240,0,32,15,75,195,224,0,0,11,75,194,192,0,0,0,11,192,0,56,0,63,255,255,244,191,64,63,255,255,244,31,224,61,85,85,244,3,224,60,0,0,244,0,128,60,0,0,244,0,0,63,255,255,244,0,0,63,255,255,244,0,48,61,0,0,244,0,188,60,0,0,244,0,248,61,0,0,244,1,240,63,255,255,244,3,224,63,255,255,244,7,192,60,0,0,244,15,192,60,0,0,244,47,64,60,0,0,244,63,0,60,0,127,240,13,0,60,0,63,224,0,0,20,0,20,0,
  // 0x6de1  淡
  225,109,24,24,144,26,1,254,0,0,0,11,128,0,15,64,0,15,128,0,31,240,31,15,128,244,2,252,61,15,66,240,0,120,124,15,67,208,0,0,248,31,15,128,0,0,176,47,135,0,16,0,0,127,248,0,125,0,1,253,255,64,191,192,11,244,31,240,11,241,255,192,2,252,1,192,253,15,128,116,0,0,0,15,64,0,0,0,45,15,64,184,0,96,61,15,64,248,0,248,124,15,130,240,1,244,248,31,199,208,3,241,240,63,239,128,7,208,80,127,245,0,15,192,1,252,252,0,47,64,11,240,63,128,63,1,191,192,15,249,45,7,254,0,2,254,0,2,144,0,0,44,
  // 0x6df7  混
  247,109,24,25,150,26,1,253,10,0,0,0,0,0,31,208,255,255,255,240,11,248,255,255,255,240,0,248,244,0,1,240,0,32,244,0,1,240,0,0,255,255,255,240,0,0,255,255,255,240,36,0,244,0,1,240,191,0,244,0,1,240,127,208,255,255,255,240,7,208,255,255,255,240,0,64,0,0,0,0,0,0,184,1,240,0,0,0,184,1,240,0,0,80,184,1,240,120,0,244,191,253,247,253,0,244,191,253,255,224,2,240,184,1,253,0,3,208,184,1,240,0,11,192,184,1,240,13,15,128,185,105,240,15,47,6,255,253,244,31,62,15,255,228,255,254,12,11,144,0,127,248,0,0,0,0,0,0,
  // 0x6e05  清
  5,110,24,26,156,26,1,253,0,0,0,5,0,0,15,64,0,15,128,0,31,244,170,175,234,168,2,252,255,255,255,252,0,120,0,15,128,0,0,0,42,175,234,164,0,0,127,255,255,244,0,0,0,15,128,0,36,0,0,15,128,0,191,3,255,255,255,255,127,226,255,255,255,254,7,224,0,0,0,0,0,128,47,255,255,240,0,0,47,255,255,240,0,0,46,0,1,240,0,52,47,170,170,240,0,124,47,255,255,240,0,248,46,0,1,240,1,240,46,0,1,240,3,224,47,255,255,240,11,192,47,170,171,240,15,128,46,0,1,240,47,0,46,0,1,240,62,0,46,0,127,240,8,0,46,0,63,208,0,0,0,0,0,0,
  // 0x6e29  温
  41,110,24,24,144,26,1,254,6,0,0,0,0,0,15,224,63,255,255,208,7,253,63,255,255,208,0,124,60,0,3,208,0,4,60,0,3,208,0,0,63,255,255,208,0,0,63,255,255,208,36,0,60,0,3,208,191,64,60,0,3,208,47,224,63,255,255,208,3,224,63,255,255,208,0,64,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,244,0,116,255,255,255,244,0,248,240,240,240,244,1,244,240,240,240,244,3,240,240,240,240,244,7,208,240,240,240,244,15,192,240,240,240,244,31,64,240,240,240,244,63,0,240,240,240,244,61,15,255,255,255,255,8,15,255,255,255,255,
  // 0x6e38  游
  56,110,24,26,156,26,1,253,0,0,20,0,0,0,13,0,46,0,188,0,47,192,46,0,248,0,11,240,46,0,244,0,1,245,126,81,255,255,0,95,255,255,255,255,0,15,255,255,229,85,0,0,240,11,192,0,36,0,240,15,128,0,191,64,240,7,255,253,47,208,240,0,255,253,3,192,255,244,0,248,0,1,255,244,2,240,0,1,240,240,11,192,0,2,224,240,11,128,2,130,224,247,255,255,3,211,208,247,255,255,7,195,192,240,15,128,11,199,192,240,11,128,15,75,128,240,11,128,31,15,65,240,11,128,63,31,1,240,11,128,61,62,3,224,15,128,124,188,127,210,255,64,4,36,63,129,254,0,0,0,0,0,0,0,
  // 0x6e90  源
  144,110,24,25,150,26,1,253,14,0,0,0,0,0,47,225,255,255,255,254,7,249,255,255,255,254,0,245,244,1,244,0,0,17,240,1,240,0,0,1,240,2,240,0,0,1,242,255,255,252,36,1,242,255,255,252,190,1,242,208,0,124,127,209,242,208,0,124,11,209,242,255,255,252,1,129,242,250,170,252,0,1,242,208,0,124,0,2,242,255,255,252,0,210,226,255,255,252,1,243,224,1,240,0,3,227,208,145,240,160,7,211,193,241,241,244,11,203,195,225,240,252,15,143,135,193,240,61,47,31,79,129,240,63,62,63,47,1,240,30,125,61,8,63,240,0,24,24,0,47,208,0,0,0,0,0,0,0,
  // 0x6ea2  溢
  162,110,24,25,150,26,1,253,14,0,0,63,252,0,47,208,5,63,254,0,11,248,31,0,31,0,0,240,62,0,15,192,0,0,252,0,7,240,0,3,251,255,254,253,0,7,215,255,252,124,56,1,64,0,0,0,191,64,0,0,0,0,47,208,0,63,254,0,7,192,14,127,255,0,0,64,63,0,15,128,0,0,125,0,11,208,0,0,252,0,3,244,0,3,240,0,0,254,1,223,255,255,255,254,2,243,255,255,255,228,3,208,180,176,225,224,7,192,180,176,225,224,15,128,180,176,225,224,31,64,180,176,225,224,47,0,184,176,226,224,62,15,255,255,255,255,44,15,255,255,255,255,0,0,0,0,0,0,
  // 0x6ed1  滑
  209,110,24,24,144,26,1,254,9,0,0,0,0,0,15,208,31,255,255,192,11,248,31,255,255,192,0,188,30,0,3,192,0,0,30,15,255,192,0,0,30,15,171,192,0,0,30,15,3,192,36,0,30,15,3,192,191,3,255,255,255,254,111,227,255,255,255,254,2,211,192,0,0,46,0,3,239,255,255,254,0,0,47,255,255,192,0,0,46,0,3,192,0,48,46,0,3,192,0,188,47,255,255,192,0,248,47,255,255,192,2,240,46,0,3,192,3,224,47,255,255,192,11,192,47,255,255,192,15,128,46,0,3,192,63,0,46,0,3,192,45,0,46,0,255,192,4,0,46,0,255,64,
  // 0x6f0f  漏
  15,111,24,25,150,26,1,253,8,0,0,0,0,0,47,130,255,255,255,248,31,242,255,255,255,248,2,242,224,0,0,184,0,82,224,0,0,184,0,2,255,255,255,248,0,2,255,255,255,248,32,2,224,0,0,0,125,2,224,0,0,0,191,194,255,255,255,254,11,226,255,255,255,253,0,66,208,2,192,0,0,3,255,255,255,252,0,3,255,255,255,252,1,131,253,2,192,60,3,227,237,210,221,60,3,211,237,250,223,124,11,199,237,42,195,124,15,139,173,2,208,60,15,79,110,226,237,60,47,31,45,250,223,124,62,62,45,42,194,60,124,61,45,2,192,60,60,44,45,2,195,252,0,0,25,1,65,160,
  // 0x6fc0  激
  192,111,24,26,156,26,1,253,0,0,4,0,16,0,14,0,31,0,60,0,47,208,47,0,124,0,7,246,191,168,188,0,0,227,255,252,184,0,0,3,128,60,248,0,0,3,128,60,255,255,0,3,255,253,255,255,56,3,234,190,240,120,191,67,128,63,240,184,47,195,234,255,240,180,7,195,255,255,240,244,0,0,31,7,116,240,0,0,31,1,56,240,0,15,255,255,61,224,0,79,255,255,47,208,1,224,180,0,31,192,3,224,180,0,15,192,3,208,191,248,15,128,11,192,255,248,31,128,15,128,240,184,63,208,31,2,240,184,190,240,63,7,208,181,244,189,125,47,143,255,224,63,44,46,15,231,64,13,0,4,0,0,0,0,
  // 0x706f  灯
  111,112,24,25,150,26,1,253,0,124,0,0,0,0,0,124,1,85,85,85,0,124,7,255,255,255,0,124,7,255,255,255,0,124,0,0,62,0,44,124,184,0,62,0,44,124,244,0,62,0,60,124,240,0,62,0,60,125,208,0,62,0,60,191,192,0,62,0,120,185,64,0,62,0,116,184,0,0,62,0,0,184,0,0,62,0,0,248,0,0,62,0,0,248,0,0,62,0,0,254,0,0,62,0,1,255,128,0,62,0,3,247,208,0,62,0,3,210,244,0,62,0,11,192,244,0,62,0,31,128,16,0,62,0,63,0,0,106,190,0,189,0,0,127,253,0,36,0,0,63,244,0,0,0,0,0,0,0,
  // 0x70b9  点
  185,112,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,255,255,248,0,0,7,255,255,248,0,0,7,208,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,11,208,0,0,2,255,255,255,255,192,2,255,255,255,255,192,2,224,0,0,11,192,2,224,0,0,11,192,2,224,0,0,11,192,2,224,0,0,11,192,2,255,255,255,255,192,2,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,64,3,208,160,45,11,192,7,192,240,47,3,224,15,128,244,31,1,244,47,64,244,15,128,252,126,0,248,11,192,125,124,0,248,7,128,56,0,0,0,0,0,0,
  // 0x70ed  热
  237,112,24,26,156,26,1,253,0,20,0,21,0,0,0,184,0,46,0,0,0,184,0,46,0,0,0,184,0,46,0,0,127,255,223,255,255,192,127,255,223,255,255,192,0,184,0,62,7,192,0,184,0,61,7,192,0,184,0,61,7,128,0,191,230,60,7,128,6,255,239,252,7,128,191,255,71,252,7,128,191,248,0,255,71,128,100,184,1,255,231,192,0,184,3,227,247,201,0,184,15,192,147,207,0,184,63,128,3,223,31,244,61,0,2,254,15,224,4,0,0,188,0,0,0,0,2,192,3,208,160,45,7,224,11,192,244,47,2,240,31,64,244,15,64,252,63,0,248,15,128,125,188,0,248,11,128,61,4,0,0,0,0,0,
  // 0x7247  片
  71,114,23,26,156,26,1,253,0,0,0,20,0,0,1,160,0,62,0,0,1,240,0,62,0,0,1,240,0,62,0,0,1,240,0,62,0,0,1,240,0,62,0,0,1,240,0,62,0,0,1,249,85,127,85,80,1,255,255,255,255,244,1,255,255,255,255,244,1,240,0,0,0,0,1,240,0,0,0,0,2,240,0,0,0,0,2,240,0,0,0,0,2,255,255,255,248,0,3,255,255,255,248,0,3,250,170,170,248,0,3,224,0,0,248,0,7,208,0,0,248,0,15,192,0,0,248,0,15,128,0,0,248,0,47,64,0,0,248,0,127,0,0,0,248,0,253,0,0,0,248,0,56,0,0,0,248,0,0,0,0,0,84,0,
  // 0x7269  物
  105,114,24,26,156,26,1,253,0,20,0,0,0,0,0,124,0,184,0,0,40,124,0,244,0,0,61,124,0,240,0,0,60,124,2,240,0,0,60,124,3,255,255,254,63,255,211,255,255,254,127,255,219,203,203,174,185,189,95,75,79,110,244,124,63,15,15,46,240,124,125,31,31,61,96,124,40,61,46,61,0,124,16,124,61,61,0,127,240,248,124,61,6,255,241,240,184,60,255,253,3,208,244,60,191,188,15,193,240,60,80,124,63,3,208,124,0,124,29,11,192,124,0,124,0,15,64,188,0,124,0,63,0,248,0,124,0,188,0,244,0,124,2,244,86,240,0,124,7,224,191,240,0,124,0,128,127,128,0,20,0,0,0,0,
  // 0x7279  特
  121,114,24,26,156,26,1,253,0,20,0,1,80,0,0,124,0,2,224,0,45,124,0,2,224,0,61,124,11,255,255,248,60,124,11,255,255,248,61,189,64,2,240,0,63,255,208,2,224,0,127,255,208,2,224,0,180,124,0,2,240,0,244,124,63,255,255,255,240,124,63,255,255,255,96,124,0,0,11,192,0,124,80,0,11,192,0,127,240,0,11,192,6,255,255,255,255,254,255,253,47,255,255,254,190,188,0,64,11,192,80,124,3,208,11,192,0,124,2,240,11,192,0,124,0,252,11,192,0,124,0,61,11,192,0,124,0,36,11,192,0,124,0,0,11,192,0,124,0,3,255,128,0,124,0,3,255,64,0,20,0,1,80,0,
  // 0x7387  率
  135,115,24,25,150,26,1,253,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,208,0,0,47,255,255,255,255,252,47,255,255,255,255,252,0,0,31,0,0,64,14,0,61,4,1,244,31,210,248,46,11,224,3,251,240,124,47,64,0,176,189,240,24,0,0,0,47,212,0,0,0,28,15,95,40,0,6,252,61,15,255,128,127,235,255,255,219,244,62,7,255,251,241,253,16,0,7,192,208,36,0,0,7,192,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,0,7,208,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,1,64,0,0,
  // 0x73af  环
  175,115,24,24,144,26,1,253,255,255,63,255,255,254,255,255,63,255,255,254,3,208,21,87,245,84,3,208,0,3,224,0,3,208,0,7,208,0,3,208,0,15,192,0,3,208,0,31,192,0,3,208,0,63,236,0,191,253,0,127,254,0,191,253,0,255,223,128,3,208,3,255,203,208,3,208,11,235,195,240,3,208,47,203,192,248,3,208,191,11,192,189,3,208,61,11,192,56,3,209,20,11,192,0,3,255,0,11,192,0,27,255,0,11,192,0,255,228,0,11,192,0,185,0,0,11,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,0,0,1,64,0,
  // 0x7528  用
  40,117,22,24,144,26,1,253,1,85,85,85,85,80,3,255,255,255,255,240,3,255,255,255,255,240,3,208,3,208,1,240,3,208,3,208,1,240,3,208,3,208,1,240,3,224,7,224,1,240,3,255,255,255,255,240,3,255,255,255,255,240,3,208,3,208,1,240,3,208,3,208,1,240,3,208,3,208,1,240,3,208,3,208,1,240,3,255,255,255,255,240,7,255,255,255,255,240,7,213,87,229,86,240,11,128,3,208,1,240,15,64,3,208,1,240,15,0,3,208,1,240,47,0,3,208,1,240,62,0,3,208,1,240,252,0,3,210,255,240,120,0,3,209,255,208,16,0,0,0,84,0,
  // 0x7535  电
  53,117,22,24,144,26,3,254,0,0,124,0,0,0,0,0,124,0,0,0,0,0,124,0,0,0,85,85,189,85,84,0,255,255,255,255,254,0,255,255,255,255,254,0,248,0,124,0,62,0,248,0,124,0,62,0,248,0,124,0,62,0,255,255,255,255,254,0,255,255,255,255,254,0,252,0,189,0,62,0,248,0,124,0,62,0,248,0,124,0,62,0,248,0,124,0,62,0,255,255,255,255,254,0,255,255,255,255,254,0,253,85,189,85,85,0,248,0,124,0,1,224,0,0,124,0,2,240,0,0,124,0,3,224,0,0,126,85,91,208,0,0,63,255,255,192,0,0,11,255,254,0,
  // 0x7565  略
  101,117,23,26,156,26,2,253,0,0,0,20,0,0,0,0,0,62,0,0,255,255,128,188,0,0,255,255,128,255,255,208,242,199,131,255,255,208,241,195,139,224,11,192,241,195,175,240,15,128,241,195,255,252,63,0,241,195,253,126,189,0,241,195,244,47,244,0,255,255,128,15,240,0,255,255,128,15,248,0,241,195,128,127,255,64,241,195,130,252,63,244,241,195,239,224,11,252,241,195,255,128,2,244,241,195,155,255,255,224,242,195,139,255,255,208,255,255,139,128,3,208,255,255,139,128,3,208,240,0,11,128,3,208,240,0,11,128,3,208,0,0,11,255,255,208,0,0,11,255,255,208,0,0,11,192,3,208,0,0,0,0,0,0,
  // 0x767d  白
  125,118,20,26,130,26,3,253,0,0,80,0,0,0,0,252,0,0,0,1,248,0,0,0,2,240,0,0,21,87,245,85,84,127,255,255,255,253,127,255,255,255,253,124,0,0,0,61,124,0,0,0,61,124,0,0,0,61,124,0,0,0,61,124,0,0,0,61,124,0,0,0,61,127,255,255,255,253,127,255,255,255,253,125,85,85,85,125,124,0,0,0,61,124,0,0,0,61,124,0,0,0,61,124,0,0,0,61,124,0,0,0,61,127,255,255,255,253,127,255,255,255,253,125,85,85,85,125,124,0,0,0,61,20,0,0,0,20,
  // 0x7684  的
  132,118,22,26,156,26,2,253,0,64,0,16,0,0,0,248,0,62,0,0,1,240,0,61,0,0,2,240,0,188,0,0,3,224,0,252,0,0,255,255,208,255,255,240,255,255,210,255,255,240,244,2,211,224,0,240,244,2,219,192,0,240,244,2,255,128,0,240,244,2,235,0,0,240,244,2,208,120,1,240,255,255,208,125,1,240,255,255,208,47,1,240,244,2,208,15,129,240,244,2,208,7,209,240,244,2,208,3,242,224,244,2,208,1,194,224,244,2,208,0,2,224,244,2,208,0,3,208,248,3,208,0,3,208,255,255,208,0,7,192,255,255,208,5,95,192,244,0,0,15,255,128,180,0,0,15,253,0,0,0,0,0,0,0,
  // 0x76d1  监
  209,118,24,25,150,26,1,254,0,1,64,0,0,0,6,3,224,11,192,0,15,67,224,15,128,0,15,67,224,15,64,0,15,67,224,47,255,253,15,67,224,63,255,253,15,67,224,125,0,0,15,67,224,248,0,0,15,67,225,240,244,0,15,67,227,224,254,0,15,67,235,192,63,128,15,67,225,64,15,224,10,67,224,0,3,240,0,1,80,0,0,128,0,0,0,0,0,0,3,255,255,255,255,192,3,255,255,255,255,192,3,208,184,30,3,192,3,208,184,30,3,192,3,208,184,30,3,192,3,208,184,30,3,192,3,208,184,30,3,192,3,208,184,47,7,208,191,255,255,255,255,255,191,255,255,255,255,255,
  // 0x76f4  直
  244,118,24,26,156,26,1,253,0,0,1,80,0,0,0,0,3,240,0,0,0,0,3,224,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,7,208,0,0,0,0,7,192,0,0,0,3,255,255,255,64,15,67,255,255,255,128,15,67,192,0,15,128,15,67,192,0,15,128,15,67,255,255,255,128,15,67,234,170,175,128,15,67,192,0,15,128,15,67,234,170,175,128,15,67,255,255,255,128,15,67,192,0,15,128,15,67,192,0,15,128,15,67,255,255,255,128,15,67,255,255,255,64,15,64,0,0,0,0,15,64,0,0,0,0,15,255,255,255,255,254,15,255,255,255,255,254,15,64,0,0,0,0,5,0,0,0,0,0,
  // 0x7701  省
  1,119,24,26,156,26,1,253,0,0,1,64,0,0,0,0,3,192,0,0,0,46,3,192,60,0,0,126,3,192,63,64,1,252,3,192,15,224,11,240,3,192,2,248,63,192,7,192,248,190,63,3,255,199,244,56,8,1,255,175,208,0,0,0,2,255,0,0,0,0,127,244,0,0,0,111,255,64,0,0,191,255,255,255,255,128,127,255,255,255,255,128,20,46,0,0,15,128,0,47,170,170,175,128,0,47,255,255,255,128,0,46,0,0,15,128,0,46,0,0,15,128,0,47,255,255,255,128,0,47,170,170,175,128,0,46,0,0,15,128,0,46,0,0,15,128,0,47,255,255,255,128,0,47,255,255,255,128,0,25,0,0,6,64,
  // 0x7720  眠
  32,119,24,24,144,26,2,253,255,253,31,255,255,240,255,253,31,255,255,240,244,61,31,0,0,240,240,61,31,0,0,240,240,61,31,0,0,240,240,61,31,0,1,240,255,253,31,255,255,240,255,253,31,255,255,240,240,61,31,2,224,0,240,61,31,2,224,0,240,61,31,1,240,0,255,253,31,255,255,252,255,253,31,255,255,252,240,61,31,85,245,80,240,61,31,0,244,0,240,61,31,0,244,0,244,61,31,0,184,0,255,253,31,0,124,20,255,253,31,0,60,29,240,0,31,91,126,45,240,1,191,255,159,60,0,2,255,249,15,252,0,1,229,0,3,244,0,0,0,0,0,0,
  // 0x786e  确
  110,120,23,25,150,26,1,253,0,0,0,46,0,0,191,255,240,61,0,0,191,255,240,191,255,0,3,224,0,255,255,64,3,208,1,240,47,0,3,208,3,224,61,0,7,192,11,192,188,0,11,192,47,255,255,252,11,128,31,255,255,252,15,255,215,192,240,60,31,255,211,192,240,60,47,67,211,255,255,252,63,67,211,255,255,252,127,67,211,192,240,60,255,67,211,192,240,60,255,67,211,192,240,124,107,67,211,255,255,252,11,67,215,255,255,252,11,67,219,128,0,60,11,255,223,64,0,60,11,255,223,0,0,60,11,64,63,0,0,124,11,64,125,0,31,252,0,0,40,0,15,244,0,0,0,0,0,0,
  // 0x79bb  离
  187,121,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,208,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,0,9,0,0,1,240,248,62,15,128,1,240,127,244,15,128,1,240,47,252,15,128,1,242,253,47,15,128,1,241,144,5,15,128,1,255,255,255,255,128,1,255,255,255,255,128,0,0,15,128,0,0,0,0,31,64,0,0,15,255,255,255,255,240,15,255,255,255,255,240,15,64,61,11,2,240,15,64,124,11,129,240,15,64,190,171,209,240,15,111,255,255,241,240,15,111,165,64,181,240,15,64,0,0,2,240,15,64,0,0,191,240,15,64,0,0,63,208,5,0,0,0,0,0,
  // 0x79fb  移
  251,121,24,25,150,26,1,253,0,6,128,3,224,0,6,255,208,15,192,0,191,254,64,47,255,244,126,248,0,255,255,244,0,184,7,244,3,240,0,184,47,253,11,192,0,184,14,47,95,64,191,255,224,11,253,0,191,255,224,7,244,0,21,249,64,127,224,0,2,252,11,254,252,0,3,254,15,226,240,0,7,255,133,7,255,254,15,251,224,31,255,254,30,185,240,190,0,124,60,184,135,253,0,248,188,184,15,255,130,240,244,184,6,11,251,224,160,184,0,1,255,128,0,184,0,1,254,0,0,184,0,15,248,0,0,184,2,255,192,0,0,184,63,253,0,0,0,184,31,144,0,0,0,16,0,0,0,0,
  // 0x7a7a  空
  122,122,24,25,150,26,1,254,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,63,255,255,255,255,252,63,255,255,255,255,252,62,1,244,47,0,188,61,1,240,31,0,124,61,2,240,31,0,124,61,3,224,31,0,0,0,11,192,31,0,36,0,47,128,31,0,124,6,254,0,31,255,248,63,244,0,11,255,240,31,64,0,0,0,0,0,0,0,0,0,0,2,255,255,255,255,192,2,255,255,255,255,192,0,0,7,208,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,0,0,0,0,
  // 0x7aef  端
  239,122,24,26,156,26,1,253,0,0,0,1,64,0,2,224,0,3,208,0,2,224,15,3,208,124,2,224,15,3,208,124,2,224,15,3,208,124,2,224,15,3,208,124,191,255,143,255,255,252,191,255,143,255,255,252,0,0,0,0,0,0,56,15,0,0,0,0,60,31,63,255,255,255,60,30,63,255,255,255,44,46,0,7,208,0,45,45,0,7,192,0,29,60,0,11,192,0,30,60,31,255,255,253,30,60,31,255,255,253,25,120,30,29,44,61,0,127,238,29,44,61,107,255,238,29,44,61,255,249,46,29,44,61,185,0,30,29,44,61,0,0,30,29,44,61,0,0,30,29,46,253,0,0,30,29,45,248,0,0,4,0,0,0,
  // 0x7b2c  第
  44,123,24,26,156,26,1,253,0,64,0,4,0,0,2,240,0,31,0,0,3,208,0,63,0,0,11,255,254,127,255,254,31,255,254,255,255,254,63,62,3,240,188,0,252,31,11,208,61,0,52,13,2,64,24,0,11,255,255,255,255,208,11,255,255,255,255,208,0,0,3,192,3,208,0,0,3,192,3,208,2,255,255,255,255,208,2,255,255,255,255,208,3,208,7,192,0,0,3,192,3,192,0,0,7,255,255,255,255,252,15,255,255,255,255,252,11,64,191,192,0,248,0,3,251,192,0,248,0,31,211,192,0,244,1,255,67,192,1,240,31,248,3,192,255,240,127,192,3,192,191,208,24,0,3,192,0,0,0,0,1,64,0,0,
  // 0x7b49  等
  73,123,24,26,156,26,1,253,0,0,0,4,0,0,2,240,0,31,0,0,3,224,0,63,0,0,11,255,254,127,255,254,15,255,255,255,255,254,63,62,3,240,188,0,253,31,7,224,61,0,120,14,3,192,45,0,0,0,7,192,0,0,3,255,255,255,255,208,3,255,255,255,255,208,0,0,7,192,0,0,0,0,7,208,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,0,0,0,244,0,0,0,0,0,244,0,63,255,255,255,255,252,63,255,255,255,255,252,0,30,0,0,244,0,0,47,192,0,244,0,0,11,240,0,244,0,0,1,248,0,244,0,0,0,160,255,240,0,0,0,0,191,224,0,0,0,0,0,0,0,
  // 0x7bb1  箱
  177,123,24,26,156,26,1,253,0,64,0,4,0,0,2,240,0,31,0,0,3,224,0,63,0,0,7,255,254,127,255,254,15,255,254,255,255,254,47,62,2,244,252,0,126,31,7,224,61,0,188,15,67,192,46,0,16,61,0,0,0,0,0,61,0,255,255,248,0,61,0,255,255,248,127,255,253,244,0,184,127,255,253,240,0,184,0,189,0,240,0,184,0,255,0,255,255,248,2,255,192,255,255,248,3,255,240,240,0,184,11,253,252,240,0,184,31,61,124,255,255,248,126,61,20,255,255,248,252,61,0,240,0,184,112,61,0,240,0,184,0,61,0,255,255,248,0,61,0,255,255,248,0,61,0,240,0,184,0,20,0,0,0,0,
  // 0x7c7b  类
  123,124,24,26,156,26,1,253,0,0,1,64,0,0,0,32,3,192,9,0,0,248,3,192,47,0,0,125,3,192,125,0,0,47,3,192,248,0,0,31,71,209,244,0,63,255,255,255,255,252,63,255,255,255,255,252,0,0,255,254,0,0,0,7,251,223,208,0,0,127,195,195,253,0,7,254,3,192,191,228,127,244,3,192,11,252,46,64,2,130,144,100,0,0,7,194,253,0,0,0,11,192,46,0,63,255,255,255,255,253,63,255,255,255,255,253,0,0,63,248,0,0,0,0,126,189,0,0,0,2,252,63,64,0,0,31,244,15,244,0,27,255,192,3,255,229,127,254,0,0,191,254,63,144,0,0,6,252,0,0,0,0,0,0,
  // 0x7d22  索
  34,125,23,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,63,255,255,255,255,252,63,255,255,255,255,252,0,0,7,192,0,0,0,0,7,192,0,0,63,255,255,255,255,252,63,255,255,255,255,252,61,0,127,0,0,124,60,0,252,2,0,60,60,23,240,15,208,60,0,255,192,63,64,0,0,127,129,252,0,0,0,11,251,240,240,0,0,2,255,128,253,0,0,2,252,0,63,128,63,255,255,255,255,240,63,255,255,255,255,252,0,4,7,192,0,52,0,47,71,193,248,0,1,253,7,192,191,64,31,240,7,192,31,224,127,128,7,192,2,252,45,0,7,192,0,116,0,0,1,64,0,0,
  // 0x7d2b  紫
  43,125,24,26,156,26,1,253,0,5,0,20,0,0,0,15,0,61,0,0,9,15,0,61,1,224,15,15,255,61,111,248,15,15,255,63,255,128,15,15,0,63,224,0,15,15,0,61,0,0,15,15,0,61,0,30,15,31,255,62,0,62,191,255,255,63,255,253,255,250,109,11,255,248,80,0,190,1,0,0,0,82,244,11,208,0,2,255,192,63,128,0,0,127,193,253,20,0,0,7,255,224,190,0,0,0,255,0,31,192,191,255,255,255,255,240,191,255,255,255,255,252,0,0,7,208,0,126,0,29,7,192,116,16,0,190,7,193,254,0,11,248,7,192,47,208,127,208,7,192,3,252,46,0,7,192,0,184,0,0,1,64,0,0,
  // 0x7ea2  红
  162,126,24,24,144,26,1,254,0,124,0,0,0,0,0,188,0,0,0,0,0,248,15,255,255,252,2,240,15,255,255,252,3,224,5,87,245,84,15,193,128,2,240,0,31,67,240,2,240,0,62,11,208,2,240,0,255,255,128,2,240,0,255,255,0,2,240,0,101,253,0,2,240,0,1,244,0,2,240,0,7,224,0,2,240,0,15,193,64,2,240,0,127,255,208,2,240,0,255,255,208,2,240,0,126,80,0,2,240,0,0,0,0,2,240,0,0,0,0,2,240,0,0,111,192,2,240,0,175,255,239,255,255,255,255,249,31,255,255,255,185,0,5,85,85,85,0,0,0,0,0,0,
  // 0x7ea7  级
  167,126,24,26,156,26,1,253,0,16,0,0,0,0,0,188,0,0,0,0,0,248,47,255,255,192,1,240,47,255,255,128,3,224,5,249,95,64,7,192,0,244,31,0,15,130,0,244,31,0,15,7,192,244,46,0,62,11,192,244,61,0,125,111,64,240,61,0,255,254,0,240,127,252,191,252,1,244,255,252,0,244,2,252,0,184,3,224,2,253,0,240,11,198,195,254,1,240,47,255,195,239,67,224,191,253,3,219,199,192,190,64,7,195,239,128,80,0,79,193,255,0,0,27,223,64,254,0,2,255,239,1,255,0,127,249,62,7,255,192,191,64,189,47,199,248,100,1,252,255,1,255,0,0,176,184,0,44,0,0,0,0,0,0,
  // 0x7ebf  线
  191,126,24,26,156,26,1,253,0,0,0,5,0,0,0,56,0,15,73,0,0,188,0,15,95,192,0,248,0,15,67,240,1,240,0,15,64,128,3,224,0,15,133,180,7,193,64,111,255,248,15,67,219,255,255,148,47,11,199,255,192,0,127,255,64,11,192,0,127,255,0,11,192,104,57,188,0,11,239,253,0,248,6,255,255,248,3,240,15,255,228,0,11,193,78,147,208,56,47,255,192,3,224,188,127,255,128,2,241,244,63,144,0,1,247,224,16,0,0,0,255,128,0,1,192,0,254,0,1,191,208,11,252,4,47,255,64,127,253,15,127,208,27,254,47,79,52,0,47,224,15,254,0,0,13,0,3,252,0,0,0,0,0,16,
  // 0x7ec6  细
  198,126,23,25,150,26,1,254,0,16,0,0,0,0,0,61,0,0,0,0,0,188,15,255,255,252,0,248,15,255,255,252,1,240,15,150,245,188,3,224,15,65,224,60,11,192,15,65,224,60,15,65,223,65,224,60,62,3,239,65,224,60,255,255,207,65,224,60,255,255,79,65,224,60,121,190,15,130,240,124,0,248,15,255,255,252,3,240,15,255,255,252,15,192,79,65,224,60,63,255,223,65,224,60,255,255,223,65,224,60,126,144,15,65,224,60,0,0,15,65,224,60,0,0,15,65,224,60,0,26,239,65,224,60,111,255,239,255,255,252,255,250,79,255,255,252,165,0,15,149,85,124,0,0,15,64,0,40,
  // 0x7ec8  终
  200,126,24,26,156,26,1,253,0,0,0,4,0,0,0,188,0,47,0,0,0,248,0,62,0,0,2,240,0,191,255,240,3,224,1,255,255,240,7,192,3,244,3,224,15,67,79,252,11,192,47,7,255,126,31,128,125,15,189,31,191,0,255,255,4,11,252,0,255,253,0,7,248,0,84,248,0,47,255,0,2,240,1,254,47,224,7,192,47,244,7,254,31,69,111,128,0,190,127,255,200,15,144,8,255,255,128,11,252,0,122,64,0,0,191,0,0,0,0,0,14,0,0,0,0,144,0,0,0,111,211,254,0,0,191,255,209,191,244,0,255,249,0,7,255,128,164,0,0,0,47,240,0,0,0,0,2,208,0,0,0,0,0,0,
  // 0x7ed3  结
  211,126,24,26,156,26,1,253,0,0,0,1,80,0,0,184,0,2,240,0,0,252,0,2,240,0,1,244,0,2,240,0,3,240,31,255,255,254,7,208,31,255,255,254,15,130,69,87,245,84,47,7,224,2,240,0,125,15,192,2,240,0,255,255,64,2,240,0,255,254,11,255,255,252,84,252,11,255,255,252,2,244,1,85,85,84,7,224,0,0,0,0,15,193,144,0,0,0,127,255,211,255,255,244,255,255,147,255,255,244,126,80,3,208,0,244,0,0,3,208,0,244,0,0,3,208,0,244,0,91,227,208,0,244,175,255,227,208,0,244,255,250,67,255,255,244,185,0,3,255,255,244,0,0,3,208,0,244,0,0,1,64,0,0,
  // 0x7ed9  给
  217,126,24,26,156,26,1,253,0,0,0,1,0,0,0,184,0,3,208,0,0,248,0,11,208,0,1,240,0,15,240,0,3,224,0,47,248,0,7,192,0,126,61,0,15,131,64,252,47,0,47,11,195,240,15,192,125,31,143,208,3,244,255,255,127,255,255,254,191,253,126,255,255,124,16,248,20,0,0,4,2,240,0,0,0,0,7,192,0,0,0,0,31,154,199,255,255,208,127,255,199,255,255,208,191,249,7,192,3,208,121,0,7,192,3,208,0,0,7,192,3,208,0,0,71,192,3,208,0,111,199,192,3,208,127,255,199,192,3,208,191,228,7,255,255,208,100,0,7,255,255,208,0,0,7,192,3,208,0,0,1,64,1,64,
  // 0x7edf  统
  223,126,24,26,156,26,1,253,0,16,0,1,64,0,0,188,0,11,192,0,0,248,0,3,224,0,2,240,0,2,224,0,3,224,31,255,255,254,11,192,31,255,255,254,15,131,128,47,128,0,47,11,192,63,2,0,125,31,128,188,11,192,255,255,1,244,3,224,191,253,7,224,87,240,84,248,63,255,255,252,2,240,47,255,250,189,7,208,26,164,20,61,15,219,128,244,61,0,127,255,128,244,61,0,255,254,0,240,61,0,126,64,0,240,61,0,0,0,1,240,61,0,0,6,130,224,61,8,1,191,195,208,61,15,111,254,79,192,61,15,191,208,63,128,61,30,120,1,254,0,63,253,0,0,248,0,31,248,0,0,0,0,0,0,
  // 0x7ee7  继
  231,126,24,25,150,26,1,254,0,64,0,0,0,0,0,244,5,0,60,0,1,244,31,0,60,16,2,240,31,56,60,60,3,208,31,60,60,120,7,192,31,29,60,176,15,66,31,14,60,240,31,11,223,14,60,208,61,15,95,0,60,0,255,255,31,191,255,254,191,252,31,191,255,254,84,248,31,0,254,0,2,240,31,2,255,64,7,192,31,3,255,192,15,69,95,11,189,240,63,255,159,15,60,184,255,254,95,61,60,61,126,64,31,124,60,44,0,0,31,48,60,0,0,0,95,0,60,0,0,111,223,0,60,0,191,255,159,0,0,0,191,144,31,255,255,255,80,0,31,255,255,255,0,0,0,0,0,0,
  // 0x7eea  绪
  234,126,24,26,156,26,1,253,0,0,0,5,0,0,0,180,0,15,64,0,0,248,0,15,64,36,1,240,0,15,64,124,2,224,15,255,254,248,3,192,15,255,255,240,11,129,0,15,71,208,15,3,192,15,79,128,61,15,192,15,127,64,190,191,127,255,255,255,255,254,63,255,255,255,121,252,0,15,208,0,0,244,0,63,128,0,2,224,0,255,0,0,7,192,11,255,255,244,31,171,191,255,255,244,127,255,191,240,0,244,127,144,16,240,0,244,16,0,0,255,255,244,0,0,64,255,255,244,0,111,192,240,0,244,127,255,128,240,0,244,191,144,0,255,255,244,80,0,0,255,255,244,0,0,0,240,0,244,0,0,0,0,0,0,
  // 0x7eed  续
  237,126,24,26,156,26,1,253,0,0,0,1,64,0,0,180,0,3,208,0,0,244,0,3,208,0,1,240,11,255,255,240,3,224,11,255,255,240,3,192,0,3,208,0,11,130,0,3,208,0,31,11,175,255,255,252,61,15,47,255,255,252,191,254,0,0,0,120,191,252,1,209,240,180,101,244,1,249,240,240,2,224,8,46,240,80,7,192,31,65,240,0,15,175,7,210,224,0,63,255,0,194,224,0,191,228,63,255,255,253,116,0,63,255,255,253,0,2,0,15,192,0,0,127,64,31,92,0,27,254,0,127,63,64,255,224,1,252,11,224,189,0,11,240,2,248,16,0,127,192,0,126,0,0,61,0,0,44,0,0,0,0,0,0,
  // 0x7eff  绿
  255,126,24,25,150,26,1,253,0,224,0,0,0,0,0,244,11,255,255,240,2,240,11,255,255,240,3,224,0,0,0,240,7,192,0,0,0,240,15,128,3,255,255,240,31,11,67,255,255,240,61,31,64,0,1,240,255,255,0,0,1,240,191,252,31,255,255,255,81,248,31,255,255,255,3,240,0,2,224,0,7,192,7,2,224,56,31,70,15,194,224,253,127,255,3,242,243,240,191,250,0,242,255,192,121,0,0,15,254,0,0,0,0,127,255,0,0,27,3,250,235,208,6,255,111,210,226,248,191,249,62,2,224,191,191,64,20,2,224,29,80,0,0,63,224,0,0,0,0,47,128,0,0,0,0,0,0,0,
  // 0x7f16  编
  22,127,23,25,150,26,1,254,0,64,0,1,128,0,0,244,0,3,208,0,1,240,0,2,240,0,3,224,31,255,255,252,3,192,31,255,255,252,11,192,31,0,0,124,15,74,31,0,0,124,31,15,95,0,0,124,61,31,31,255,255,252,190,253,31,255,255,252,255,252,31,0,0,0,105,244,31,0,0,0,2,224,31,255,255,252,7,192,47,255,255,252,15,85,47,211,143,44,63,255,47,211,143,44,191,228,62,211,143,44,100,0,62,255,255,252,0,6,61,255,255,252,0,191,125,211,143,44,31,253,185,211,143,44,255,208,241,211,143,44,189,2,241,211,143,44,64,3,209,211,143,188,0,0,129,208,0,184,
  // 0x7f3a  缺
  58,127,24,26,156,26,1,253,4,0,0,1,64,0,15,64,0,3,208,0,31,0,0,3,208,0,47,0,0,3,208,0,47,255,248,3,208,0,63,255,249,255,255,240,124,124,1,255,255,240,188,124,0,87,229,240,244,124,0,3,208,240,32,188,0,3,208,240,255,255,252,3,208,240,255,255,252,3,208,240,0,124,0,3,225,244,0,124,2,255,255,255,60,124,122,255,255,255,60,124,120,7,248,0,60,124,120,7,252,0,60,124,120,15,253,0,60,124,120,15,111,0,60,188,120,47,31,64,63,255,248,126,15,192,63,255,248,252,3,240,60,0,127,244,2,252,56,0,31,208,0,191,0,0,15,64,0,45,0,0,0,0,0,0,
  // 0x7f51  网
  81,127,22,24,144,26,2,253,191,255,255,255,255,240,191,255,255,255,255,240,185,87,229,95,86,240,184,3,208,15,1,240,184,3,192,15,1,240,184,3,192,31,1,240,184,67,195,31,1,240,186,227,203,239,1,240,184,255,195,254,1,240,184,127,192,254,1,240,184,31,192,63,1,240,184,11,208,63,129,240,184,15,240,63,209,240,184,15,252,126,241,240,184,31,60,184,245,240,184,46,16,244,33,240,184,60,1,240,1,240,184,188,3,224,1,240,184,244,7,192,1,240,186,240,15,128,1,240,184,144,3,0,2,240,184,0,0,1,255,224,184,0,0,0,255,192,16,0,0,0,20,0,
  // 0x7f6e  置
  110,127,23,24,144,26,2,253,63,255,255,255,255,192,63,171,234,254,175,192,61,3,192,60,7,192,63,171,234,254,175,192,63,255,255,255,255,192,0,0,15,64,0,0,255,255,255,255,255,240,255,255,255,255,255,240,0,0,31,0,0,0,0,5,111,85,85,0,62,15,255,255,255,0,62,15,0,0,15,0,62,15,85,85,95,0,62,15,255,255,255,0,62,15,0,0,15,0,62,15,255,255,255,0,62,15,85,85,95,0,62,15,85,85,95,0,62,15,255,255,255,0,62,0,0,0,0,0,63,255,255,255,255,248,63,255,255,255,255,252,62,0,0,0,0,0,0,0,0,0,0,0,
  // 0x7f72  署
  114,127,24,25,150,26,1,253,10,170,170,170,170,160,15,255,255,255,255,240,15,64,240,15,0,240,15,64,240,15,0,240,15,234,250,191,171,240,15,255,255,255,255,240,0,0,15,64,0,0,0,0,15,64,0,208,3,255,255,255,243,240,2,255,255,255,255,208,0,0,15,64,127,64,0,0,15,66,252,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,111,244,0,0,0,11,255,255,255,192,6,255,255,255,255,192,255,255,0,0,3,192,126,95,170,170,171,192,16,15,255,255,255,192,0,15,0,0,3,192,0,15,0,0,3,192,0,15,255,255,255,192,0,15,255,255,255,192,0,5,0,0,1,64,
  // 0x8005  者
  5,128,24,25,150,26,1,253,0,0,61,0,0,64,0,0,61,0,1,240,0,0,62,0,3,240,7,255,255,255,239,192,7,255,255,255,255,0,0,0,61,0,253,0,0,0,61,3,244,0,0,0,61,31,208,0,191,255,255,255,255,254,191,255,255,255,255,254,0,0,47,224,0,0,0,1,255,64,0,0,0,11,252,0,0,0,0,191,255,255,255,64,31,255,255,255,255,64,255,239,0,0,15,64,125,31,0,0,15,64,0,31,255,255,255,64,0,31,255,255,255,64,0,31,0,0,15,64,0,31,0,0,15,64,0,31,255,255,255,64,0,31,255,255,255,64,0,31,0,0,15,64,0,0,0,0,0,0,
  // 0x806a  聪
  106,128,24,25,150,26,1,253,0,0,0,240,3,208,191,255,240,184,3,208,191,255,240,60,7,192,30,11,128,62,15,64,30,11,128,29,31,0,30,11,131,255,255,248,31,255,131,255,255,248,31,255,131,192,0,184,30,11,131,192,0,184,30,11,131,192,0,184,30,11,131,192,0,184,30,11,131,255,255,248,31,255,131,255,255,248,31,255,128,0,64,0,30,11,128,3,208,0,30,11,128,61,240,32,30,11,247,124,184,180,47,255,251,124,60,120,255,255,143,60,16,60,190,75,143,60,2,110,0,11,158,60,3,207,0,11,173,60,3,207,0,11,132,63,255,128,0,11,128,15,254,0,0,1,0,0,0,0,
  // 0x80fd  能
  253,128,24,26,156,26,1,253,0,64,0,20,0,0,0,248,0,46,0,0,1,240,16,46,0,64,3,224,240,46,7,240,7,208,252,47,191,224,11,192,125,47,253,0,255,255,255,47,128,0,255,255,255,110,0,20,85,80,15,174,0,31,0,0,0,47,0,46,31,255,252,47,255,253,31,255,252,15,255,248,31,0,124,0,0,0,31,0,124,46,0,0,31,255,252,46,0,0,31,255,252,46,1,240,31,0,124,46,47,244,31,0,124,47,255,64,31,255,252,47,228,0,31,255,252,46,0,0,31,0,124,46,0,14,31,0,124,46,0,15,31,0,124,47,0,31,31,15,252,47,255,254,31,11,244,11,255,248,0,0,0,0,0,0,
  // 0x81ea  自
  234,129,18,26,130,26,4,253,0,0,64,0,0,0,2,240,0,0,0,3,240,0,0,0,3,208,0,0,255,255,255,255,240,255,255,255,255,240,249,85,85,86,240,248,0,0,1,240,248,0,0,1,240,248,0,0,1,240,255,255,255,255,240,255,255,255,255,240,248,0,0,1,240,248,0,0,1,240,248,0,0,1,240,248,0,0,1,240,255,255,255,255,240,255,255,255,255,240,248,0,0,1,240,248,0,0,1,240,248,0,0,1,240,248,0,0,1,240,255,255,255,255,240,255,255,255,255,240,248,0,0,1,240,80,0,0,0,80,
  // 0x81f3  至
  243,129,24,23,138,26,1,254,63,255,255,255,255,252,63,255,255,255,255,252,0,2,252,1,64,0,0,2,240,3,192,0,0,3,224,7,244,0,0,11,192,1,253,0,0,15,128,0,127,128,21,111,255,255,255,224,47,255,255,255,255,248,31,234,149,80,0,252,0,0,7,192,0,32,0,0,7,192,0,0,0,0,7,192,0,0,3,255,255,255,255,208,3,255,255,255,255,208,0,0,7,208,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,0,0,0,0,0,
  // 0x83dc  菜
  220,131,24,26,156,26,1,253,0,6,64,1,144,0,0,11,192,3,224,0,127,255,255,255,255,253,127,255,255,255,255,253,0,11,192,3,224,0,0,11,192,3,224,0,0,6,128,1,191,128,0,85,170,255,255,208,47,255,255,255,254,64,15,255,234,148,1,0,0,64,11,0,3,224,7,208,15,128,7,208,2,240,7,192,15,128,0,244,3,128,47,0,0,164,7,192,44,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,1,255,254,0,0,0,7,251,239,192,0,0,47,199,199,248,0,6,255,7,192,255,144,191,244,7,192,31,254,127,128,7,192,2,252,36,0,7,192,0,20,0,0,1,64,0,0,
  // 0x84dd  蓝
  221,132,24,25,150,26,1,254,0,6,64,1,144,0,0,11,128,2,224,0,127,255,255,255,255,253,127,255,255,255,255,253,0,11,128,2,224,0,0,6,64,1,144,0,0,1,64,31,0,0,5,67,208,47,0,0,11,131,208,63,255,248,11,131,208,127,255,248,11,131,208,248,32,0,11,131,209,240,248,0,11,131,211,224,125,0,11,131,210,192,47,0,11,131,208,0,15,64,0,2,144,0,9,0,0,0,0,0,0,0,3,255,255,255,255,192,3,255,255,255,255,192,3,208,180,30,3,192,3,208,180,30,3,192,3,208,180,30,3,192,3,208,180,30,7,192,191,255,255,255,255,255,191,255,255,255,255,255,
  // 0x86c7  蛇
  199,134,24,24,144,26,1,254,0,180,0,0,240,0,0,180,0,0,240,0,0,180,0,0,240,0,0,180,0,1,240,0,0,180,7,255,255,254,63,255,247,255,255,254,63,255,247,128,0,46,56,176,247,128,0,46,56,176,246,252,0,46,56,176,240,124,0,0,56,176,240,124,1,240,56,176,240,124,31,244,63,255,240,125,255,128,63,255,240,127,248,0,56,180,0,127,64,0,20,180,0,124,0,0,0,181,224,124,0,0,0,180,240,124,0,0,0,180,240,124,0,25,0,250,244,124,0,30,175,255,248,124,0,46,255,255,188,124,0,61,185,64,60,63,255,252,0,0,0,31,255,244,
  // 0x884c  行
  76,136,24,25,150,26,1,253,0,63,0,0,0,0,0,253,11,255,255,252,3,244,11,255,255,252,15,224,1,85,85,84,63,128,0,0,0,0,254,5,0,0,0,0,52,15,192,0,0,0,0,47,64,0,0,0,0,126,5,85,85,84,0,252,47,255,255,255,3,244,47,255,255,255,15,244,0,0,31,0,63,244,0,0,31,0,254,244,0,0,31,0,184,244,0,0,31,0,16,244,0,0,31,0,0,244,0,0,31,0,0,244,0,0,31,0,0,244,0,0,31,0,0,244,0,0,31,0,0,244,0,0,31,0,0,244,0,0,47,0,0,244,0,63,255,0,0,244,0,31,253,0,0,160,0,5,80,0,
  // 0x88ab  被
  171,136,24,26,156,26,1,253,0,0,0,0,80,0,1,240,0,0,240,0,1,240,0,0,240,0,1,240,0,0,240,0,1,240,0,1,244,0,2,240,11,255,255,255,191,255,203,255,255,254,191,255,203,128,240,61,0,15,75,128,240,60,0,47,11,128,240,184,0,61,75,128,240,0,0,248,251,255,255,248,3,250,219,255,255,248,11,255,75,252,1,244,63,255,79,189,1,240,255,247,207,110,3,224,249,242,207,79,71,208,81,240,79,15,207,128,1,240,31,3,255,0,1,240,47,2,253,0,1,240,61,2,254,0,1,240,124,15,255,192,1,240,252,127,143,248,1,241,246,254,2,255,1,240,176,240,0,124,0,80,0,0,0,0,
  // 0x88c5  装
  197,136,24,26,156,26,1,253,0,5,0,1,64,0,0,15,0,3,224,0,44,15,0,3,224,0,63,79,0,3,224,0,11,223,63,255,255,254,2,79,63,255,255,254,0,15,0,3,224,0,0,31,0,3,224,0,2,239,0,3,224,0,111,239,0,3,224,0,254,15,15,255,255,252,96,15,15,255,255,252,0,15,1,64,0,0,0,5,7,192,0,0,0,0,7,192,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,2,252,248,0,208,0,47,224,61,11,240,27,255,64,47,127,128,191,223,64,15,248,0,36,15,64,19,248,0,0,15,239,240,191,144,3,255,255,240,31,254,2,254,144,0,1,188,0,0,0,0,0,4,
  // 0x8981  要
  129,137,24,24,144,26,1,253,63,255,255,255,255,252,63,255,255,255,255,252,0,1,240,31,0,0,0,1,240,31,0,0,15,255,255,255,255,240,15,255,255,255,255,240,15,65,240,31,1,240,15,65,240,31,1,240,15,65,240,31,1,240,15,255,255,255,255,240,15,255,255,255,255,240,0,0,188,0,0,0,0,1,244,0,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,31,64,1,244,0,0,63,0,3,240,0,0,191,228,15,192,0,0,255,255,255,64,0,0,0,127,255,228,0,0,91,255,239,255,144,63,255,249,0,127,248,47,233,0,0,1,240,0,0,0,0,0,0,
  // 0x89d2  角
  210,137,22,26,156,26,1,253,0,1,64,0,0,0,0,3,240,0,0,0,0,11,255,255,64,0,0,31,255,255,192,0,0,63,0,31,64,0,0,252,0,63,0,0,3,248,0,189,0,0,15,255,255,255,255,224,63,255,255,255,255,224,46,244,2,240,2,224,4,244,2,240,2,224,0,244,2,240,2,224,0,255,255,255,255,224,0,255,255,255,255,224,0,244,2,240,2,224,0,240,2,240,2,224,1,240,2,240,2,224,1,255,255,255,255,224,2,255,255,255,255,224,3,208,0,0,2,224,11,192,0,0,2,224,15,128,0,0,2,224,63,0,0,0,3,224,253,0,0,15,255,224,56,0,0,7,255,128,0,0,0,1,80,0,
  // 0x8ba1  计
  161,139,24,25,150,26,1,253,1,64,0,3,224,0,7,224,0,3,224,0,2,248,0,3,224,0,0,190,0,3,224,0,0,47,0,3,224,0,0,8,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,255,248,21,87,245,85,255,248,127,255,255,255,85,248,127,255,255,255,0,248,0,3,224,0,0,248,0,3,224,0,0,248,0,3,224,0,0,248,0,3,224,0,0,248,0,3,224,0,0,248,0,3,224,0,0,248,112,3,224,0,0,250,240,3,224,0,0,255,224,3,224,0,0,255,64,3,224,0,3,252,0,3,224,0,2,224,0,3,224,0,0,128,0,3,224,0,0,0,0,1,64,0,
  // 0x8bae  议
  174,139,24,25,150,26,1,253,1,0,0,28,0,0,15,128,0,62,0,80,11,208,124,31,0,248,2,240,60,15,128,244,0,244,61,7,193,240,0,80,62,3,210,240,0,0,47,2,3,240,0,0,31,0,3,208,191,240,15,64,7,192,191,240,11,128,11,192,22,240,7,192,15,128,1,240,3,224,31,0,1,240,2,240,63,0,1,240,0,248,125,0,1,240,0,252,252,0,1,240,0,63,244,0,1,240,0,47,224,0,1,240,128,15,208,0,1,247,208,63,244,0,1,255,192,254,254,0,2,254,7,244,127,128,3,244,63,208,31,248,3,210,255,64,3,255,1,0,244,0,0,125,0,0,64,0,0,4,
  // 0x8bbe  设
  190,139,24,25,150,26,1,253,2,0,0,0,0,0,11,192,1,255,255,0,7,240,1,255,255,0,0,252,1,240,15,0,0,125,2,224,15,0,0,20,2,224,15,0,0,0,3,208,15,0,0,0,15,192,15,64,255,240,63,64,15,254,255,240,254,0,7,254,86,240,116,0,0,0,1,240,16,0,0,64,1,240,63,255,255,244,1,240,63,255,255,240,1,240,15,64,3,224,1,240,7,192,11,192,1,240,3,224,15,128,1,240,128,248,62,0,1,247,192,126,252,0,1,255,192,47,240,0,2,254,0,127,248,0,7,244,11,254,255,144,7,192,255,224,31,254,2,0,190,0,1,252,0,0,0,0,0,4,
  // 0x8bd5  试
  213,139,24,25,150,26,1,253,2,0,0,0,184,208,11,192,0,0,185,240,3,240,0,0,184,188,0,252,0,0,188,61,0,60,0,0,188,20,0,16,255,255,255,255,0,0,255,255,255,255,0,0,85,85,189,85,191,240,0,0,124,0,191,240,0,0,124,0,21,240,0,0,124,0,0,240,63,255,124,0,0,240,63,255,60,0,0,240,2,224,61,0,0,240,2,224,61,0,0,240,2,224,62,0,0,240,2,224,46,0,0,240,2,224,47,8,0,242,194,230,95,15,1,255,195,255,143,79,2,255,191,254,79,223,7,248,63,144,7,254,3,208,32,0,3,252,1,0,0,0,0,248,0,0,0,0,0,0,
  // 0x8bef  误
  239,139,24,25,150,26,1,253,1,0,0,0,0,0,15,128,15,255,255,244,11,224,15,255,255,244,2,248,15,0,0,244,0,188,15,0,0,244,0,32,15,0,0,244,0,0,15,255,255,244,0,0,15,255,255,244,255,240,0,0,0,0,255,240,0,0,0,0,86,240,0,0,0,0,1,240,47,255,255,252,1,240,47,255,255,252,1,240,0,3,192,0,1,240,0,7,192,0,1,240,127,255,255,255,1,240,127,255,255,255,1,240,64,31,240,0,1,247,192,47,248,0,1,255,192,126,189,0,3,254,1,252,63,128,3,244,31,240,15,244,2,208,255,192,3,255,0,0,125,0,0,124,0,0,0,0,0,4,
  // 0x8bf7  请
  247,139,24,25,150,26,1,253,1,0,0,7,192,0,15,64,0,7,192,0,15,208,63,255,255,252,3,244,63,255,255,252,0,188,0,7,192,0,0,32,31,255,255,244,0,0,26,175,234,160,0,0,0,7,192,0,255,240,191,255,255,254,255,240,255,255,255,255,86,240,0,0,0,0,1,240,15,255,255,240,1,240,15,255,255,240,1,240,15,0,1,240,1,240,15,0,1,240,1,240,15,255,255,240,1,240,15,170,171,240,1,241,143,0,1,240,1,251,207,170,171,240,1,255,79,255,255,240,2,253,15,0,1,240,7,240,15,0,1,240,3,192,15,0,127,240,1,0,15,0,63,192,0,0,0,0,0,0,
  // 0x8bfb  读
  251,139,24,26,156,26,1,253,0,0,0,1,64,0,5,0,0,7,192,0,15,128,0,7,192,0,11,224,47,255,255,240,2,252,47,255,255,240,0,188,0,7,192,0,0,16,0,7,192,0,0,0,191,255,255,252,0,0,191,255,255,252,255,240,0,0,0,120,255,240,3,130,208,180,86,240,2,242,224,240,1,240,16,126,224,80,1,240,62,2,224,0,1,240,15,195,208,0,1,240,2,195,208,0,1,240,255,255,255,254,1,240,255,255,255,254,1,243,0,31,128,0,1,255,128,63,44,0,1,255,0,189,63,64,2,252,3,248,15,224,3,240,47,224,2,248,7,192,255,64,0,126,2,0,184,0,0,29,0,0,0,0,0,0,
  // 0x8c03  调
  3,140,23,25,150,26,1,253,1,0,0,0,0,0,15,128,63,255,255,252,11,224,63,255,255,252,2,244,60,0,0,60,0,252,60,3,192,60,0,48,60,3,192,60,0,0,60,191,253,60,0,0,60,127,253,60,255,240,60,3,192,60,255,240,60,3,192,60,86,240,60,255,255,60,1,240,60,255,255,60,1,240,60,0,0,60,1,240,60,0,0,60,1,240,60,191,252,60,1,240,124,191,252,60,1,240,120,176,44,60,1,241,184,176,44,60,1,255,244,191,252,60,2,255,240,191,252,60,3,254,240,176,0,60,11,227,224,0,0,60,7,135,192,0,15,252,1,2,128,0,15,244,0,0,0,0,0,0,
  // 0x8d25  败
  37,141,24,25,150,26,1,253,0,0,0,3,128,0,47,255,252,7,192,0,47,255,252,11,128,0,45,0,124,15,64,0,44,40,60,31,255,254,44,60,60,47,255,254,44,60,60,61,1,240,44,60,60,124,1,224,44,60,60,248,1,224,44,60,62,252,2,208,44,60,63,253,3,192,44,60,60,238,3,192,44,60,60,15,7,192,44,60,60,15,75,64,44,60,60,7,207,0,44,124,60,3,239,0,44,184,60,1,253,0,0,244,0,0,252,0,0,243,192,0,253,0,2,227,224,3,255,64,7,193,240,15,207,208,31,128,188,127,67,248,190,0,61,253,0,255,56,0,16,176,0,44,0,0,0,0,0,0,
  // 0x8d2a  贪
  42,141,24,26,156,26,1,253,0,0,0,64,0,0,0,0,3,240,0,0,0,0,47,248,0,0,0,1,254,191,64,0,0,47,245,31,249,0,6,255,139,129,255,228,191,248,7,224,31,255,62,64,1,240,0,188,16,255,255,255,253,0,0,255,255,255,254,0,0,0,0,1,248,0,0,0,0,7,240,0,0,0,0,11,208,0,1,255,255,255,255,64,1,255,255,255,255,64,1,240,0,0,15,64,1,240,7,192,15,64,1,240,7,192,15,64,1,240,7,192,15,64,1,240,15,192,15,64,1,160,47,89,10,0,0,1,254,63,228,0,0,47,244,11,255,128,27,255,128,0,47,248,15,244,0,0,1,240,1,0,0,0,0,0,
  // 0x8d77  起
  119,141,24,25,150,26,1,253,0,61,0,0,0,0,0,61,0,63,255,244,0,61,0,63,255,244,63,255,253,0,0,244,63,255,253,0,0,244,0,61,0,0,0,244,0,61,0,0,0,244,0,61,0,0,0,244,191,255,255,63,255,244,191,255,255,63,255,244,0,31,0,62,0,244,0,31,0,61,0,0,46,31,0,61,0,0,46,31,0,61,0,0,46,31,255,61,0,4,46,31,255,61,0,15,63,31,0,62,0,31,63,31,0,63,0,46,63,223,0,47,255,253,63,255,0,11,255,248,125,255,0,0,0,0,124,191,229,85,85,85,248,31,255,255,255,255,240,1,191,255,255,253,32,0,0,0,0,0,
  // 0x8d85  超
  133,141,24,26,156,26,1,253,0,20,0,0,0,0,0,60,0,0,0,0,0,60,0,255,255,252,0,60,0,255,255,252,63,255,252,3,192,124,63,255,252,7,192,124,0,60,0,11,128,124,0,60,0,15,64,188,0,61,0,63,0,248,191,255,254,252,63,244,191,255,255,244,31,224,0,45,0,64,0,0,0,45,0,127,255,248,46,45,0,127,255,248,45,46,0,124,0,248,61,47,252,124,0,248,61,47,252,124,0,248,63,45,0,124,0,248,63,109,0,127,255,248,63,253,0,127,255,248,63,253,0,0,0,0,125,254,0,0,0,0,184,127,233,85,85,85,244,15,255,255,255,255,240,1,191,255,255,253,16,0,0,0,0,0,
  // 0x8ddd  距
  221,141,24,24,144,26,1,253,47,255,241,255,255,254,47,255,241,255,255,254,45,0,241,240,0,0,45,0,241,240,0,0,45,0,241,240,0,0,45,0,241,240,0,0,47,255,241,255,255,248,47,255,241,255,255,248,0,124,1,245,85,248,0,60,1,240,0,248,20,60,1,240,0,248,60,60,1,240,0,248,60,63,245,240,0,248,60,63,245,244,0,248,60,60,1,255,255,248,60,60,1,255,255,248,60,60,1,240,0,0,60,60,5,240,0,0,61,127,253,240,0,0,127,255,249,244,0,0,255,249,1,255,255,255,249,0,1,255,255,255,0,0,1,240,0,0,0,0,0,80,0,0,
  // 0x8f6c  转
  108,143,24,25,150,26,1,253,0,244,0,0,248,0,0,240,0,0,244,0,1,240,0,2,244,0,255,255,243,255,255,252,255,255,243,255,255,252,3,192,0,3,192,0,7,192,0,7,192,0,11,109,0,11,192,0,15,61,15,255,255,255,30,61,15,255,255,255,61,61,0,47,0,0,127,255,240,62,0,0,63,255,240,62,0,80,16,62,0,127,255,252,0,61,0,255,255,244,0,61,0,0,3,224,0,63,248,0,15,192,175,255,248,24,47,64,255,255,64,63,125,0,185,61,0,47,248,0,0,61,0,3,252,0,0,61,0,0,191,64,0,61,0,0,31,192,0,61,0,0,7,128,0,20,0,0,0,0,
  // 0x8f6f  软
  111,143,24,26,156,26,1,253,0,0,0,4,0,0,0,60,0,15,64,0,0,124,0,15,0,0,21,189,84,31,0,0,191,255,253,47,0,0,191,255,253,63,255,255,2,240,0,63,255,254,3,208,0,124,0,61,3,207,0,184,0,60,11,207,64,244,160,60,15,79,66,240,244,120,31,15,66,208,244,180,63,255,252,64,240,0,63,255,252,0,244,0,20,15,64,1,248,0,0,15,64,2,252,0,0,15,64,2,252,0,0,31,253,3,254,0,175,255,254,7,239,0,255,255,148,15,143,64,186,79,64,47,11,192,0,15,64,126,3,240,0,15,65,252,1,252,0,15,71,240,0,191,0,15,66,192,0,44,0,5,0,0,0,0,
  // 0x8f74  轴
  116,143,23,26,156,26,1,253,0,0,0,0,80,0,0,240,0,0,240,0,1,240,0,0,240,0,2,240,0,0,240,0,191,255,240,0,240,0,191,255,240,0,240,0,3,192,3,255,255,252,7,192,3,255,255,252,11,110,3,208,244,60,15,46,3,192,240,60,31,46,3,192,240,60,61,46,3,192,240,60,127,255,243,192,240,60,63,255,243,192,244,60,16,46,3,255,255,252,0,46,3,255,255,252,0,46,3,192,240,60,0,47,243,192,240,60,111,255,243,192,240,60,191,255,83,192,240,60,186,110,3,192,240,60,0,46,3,192,244,60,0,46,3,255,255,252,0,46,3,255,255,252,0,46,3,192,0,60,0,4,1,64,0,20,
  // 0x8f7d  载
  125,143,24,25,150,26,1,253,0,11,128,7,194,0,0,11,128,7,203,192,31,255,255,199,195,240,31,255,255,199,192,248,0,11,128,7,192,112,0,11,128,7,192,0,191,255,255,255,255,254,191,255,255,255,255,254,0,61,0,3,192,0,0,124,0,3,208,164,63,255,255,243,208,244,63,255,255,243,209,240,3,224,0,3,226,224,7,194,224,2,227,208,15,130,224,2,247,192,47,255,255,225,255,64,15,255,255,224,255,0,0,2,224,0,253,0,0,2,224,16,252,8,42,255,255,241,252,15,63,255,255,247,254,15,41,82,224,31,175,174,0,2,224,190,15,253,0,2,224,56,2,244,0,0,0,0,0,0,
  // 0x8f91  辑
  145,143,24,26,156,26,1,253,0,64,0,0,0,0,0,240,2,255,255,240,1,240,2,255,255,240,22,245,66,224,0,240,255,255,226,224,0,240,255,255,226,255,255,240,3,192,2,255,255,240,7,148,0,0,0,0,11,109,0,0,0,0,15,45,15,255,255,254,31,45,15,255,255,254,61,45,1,224,1,240,127,255,209,224,1,240,63,255,209,255,255,240,16,62,1,255,255,240,0,45,1,224,1,240,0,45,1,250,171,240,1,191,241,255,255,240,255,255,241,224,1,240,191,254,1,224,1,240,100,45,2,250,255,255,0,45,47,255,255,255,0,45,31,169,65,240,0,45,0,0,1,240,0,45,0,0,1,240,0,0,0,0,0,0,
  // 0x8f93  输
  147,143,24,26,156,26,1,253,0,0,0,0,64,0,3,208,0,2,224,0,3,192,0,11,224,0,7,192,0,47,252,0,255,255,128,189,63,0,255,255,135,244,15,224,15,64,47,208,2,254,15,0,191,255,255,254,15,120,55,255,255,200,30,120,0,0,0,0,44,120,0,0,0,44,60,120,31,255,142,60,191,255,159,255,142,60,127,255,158,7,142,60,16,184,31,255,142,60,0,120,31,255,142,60,0,120,30,7,142,60,0,191,158,7,142,60,111,255,159,255,142,60,191,252,31,255,142,60,100,120,30,7,142,60,0,120,30,7,128,60,0,120,30,7,128,60,0,120,30,63,139,252,0,120,30,63,7,244,0,20,0,0,0,0,
  // 0x8fb9  边
  185,143,24,25,150,26,1,253,14,0,0,62,0,0,47,128,0,62,0,0,11,224,0,62,0,0,2,248,0,62,0,0,0,244,255,255,255,252,0,0,255,255,255,252,0,0,85,126,85,188,0,0,0,124,0,188,85,80,0,124,0,188,255,224,0,188,0,188,255,224,0,248,0,184,2,224,0,244,0,248,2,224,1,240,0,248,2,224,3,240,0,248,2,224,7,208,0,244,2,224,15,192,0,244,2,224,63,64,1,240,2,224,254,1,87,240,2,226,248,3,255,224,7,240,160,2,255,128,47,254,0,0,0,0,254,47,250,85,86,175,248,3,255,255,255,255,112,0,111,255,255,253,0,0,0,0,0,0,
  // 0x8fc1  迁
  193,143,24,25,150,26,1,253,11,0,0,0,27,192,15,208,0,107,255,240,3,248,255,255,254,64,0,188,255,239,128,0,0,32,0,15,64,0,4,0,0,15,64,0,63,64,0,15,64,0,47,224,0,15,64,0,3,244,0,15,128,0,0,163,255,255,255,254,0,3,255,255,255,254,0,0,0,15,64,0,191,240,0,15,64,0,191,240,0,15,64,0,1,240,0,15,64,0,0,240,0,15,64,0,0,240,0,15,64,0,0,240,0,15,64,0,0,240,0,15,64,0,3,248,0,15,64,0,31,254,0,10,64,0,191,95,229,80,5,85,189,7,255,255,255,254,48,0,111,255,255,253,0,0,0,0,0,0,
  // 0x8fd0  运
  208,143,24,25,150,26,1,253,11,0,0,0,0,0,31,224,63,255,255,240,3,248,63,255,255,240,0,184,5,85,85,80,0,16,0,0,0,0,24,0,0,0,0,0,127,64,0,0,0,0,31,226,255,255,255,255,3,242,255,255,255,255,0,128,0,253,0,0,0,0,0,248,0,0,0,0,1,240,30,0,191,240,2,240,31,64,191,240,3,208,11,192,2,240,7,192,3,224,2,240,15,128,6,244,2,240,111,255,255,252,2,241,255,255,255,253,2,240,254,149,0,62,7,244,0,0,0,20,31,254,0,0,0,0,191,111,229,0,1,85,252,11,255,255,255,254,112,0,111,255,255,253,0,0,0,0,0,0,
  // 0x8fd1  近
  209,143,24,25,150,26,1,253,8,0,0,0,27,208,63,0,9,175,255,240,31,192,31,255,249,0,7,240,31,148,0,0,0,244,31,0,0,0,0,64,31,0,0,0,0,0,31,0,0,0,0,0,31,255,255,254,0,0,31,255,255,254,0,0,31,85,125,84,191,240,47,0,124,0,191,240,46,0,124,0,1,240,62,0,124,0,1,240,61,0,124,0,1,240,124,0,124,0,1,240,248,0,124,0,1,241,244,0,124,0,1,243,240,0,124,0,1,242,208,0,124,0,3,248,64,0,124,0,31,254,0,0,20,0,191,111,249,85,85,85,189,7,255,255,255,254,48,0,111,255,255,253,0,0,0,0,0,0,
  // 0x8fd4  返
  212,143,24,25,150,26,1,253,8,0,0,0,0,0,63,0,63,255,255,252,47,192,63,255,255,252,7,240,61,0,0,0,1,240,61,0,0,0,0,64,61,0,0,0,0,0,63,255,255,240,0,0,63,255,255,240,0,0,62,240,3,224,0,0,60,244,3,208,191,240,124,188,11,192,191,240,124,125,15,128,2,240,124,63,63,0,2,240,184,15,253,0,2,240,244,11,252,0,2,241,240,7,248,0,2,242,240,47,255,0,2,243,225,255,127,224,2,247,207,252,11,254,7,245,67,208,1,252,31,254,1,0,0,20,191,111,229,85,85,85,252,11,255,255,255,254,112,0,111,255,255,253,0,0,0,0,0,0,
  // 0x8fd8  还
  216,143,24,25,150,26,1,253,9,0,0,0,0,0,47,64,85,85,85,84,15,209,255,255,255,252,3,241,255,255,255,252,0,248,0,7,208,0,0,96,0,15,192,0,0,0,0,47,64,0,0,0,0,127,0,0,85,80,0,255,24,0,255,224,3,255,126,0,255,224,15,239,47,128,2,224,63,95,11,224,2,225,254,31,3,248,2,231,248,31,0,253,2,227,208,31,0,60,2,224,64,31,0,0,2,224,0,31,0,0,2,224,0,31,0,0,2,224,0,31,0,0,11,244,0,31,0,0,63,254,0,0,0,0,254,31,250,149,90,175,248,3,255,255,255,255,112,0,47,255,255,253,0,0,0,0,0,0,
  // 0x8fdb  进
  219,143,24,25,150,26,1,253,4,0,1,144,26,0,47,0,2,224,47,0,31,192,2,224,47,0,7,224,2,224,47,0,1,248,87,245,111,84,0,176,255,255,255,252,0,0,255,255,255,252,0,0,2,224,47,0,0,0,2,224,47,0,191,240,2,224,47,0,191,240,2,224,47,0,1,241,255,255,255,253,1,241,255,255,255,253,1,240,87,229,111,84,1,240,7,192,47,0,1,240,15,192,47,0,1,240,15,128,47,0,1,240,63,0,47,0,1,240,190,0,47,0,3,244,56,0,47,0,31,254,0,0,0,0,127,31,249,85,85,106,188,2,255,255,255,254,48,0,27,255,255,253,0,0,0,0,0,0,
  // 0x8fde  连
  222,143,24,26,156,26,1,253,0,0,0,64,0,0,30,0,0,248,0,0,31,128,1,244,0,0,11,209,255,255,255,252,2,241,255,255,255,252,0,244,11,192,0,0,0,64,15,130,144,0,0,0,15,67,208,0,0,0,47,3,208,0,0,0,126,3,224,0,255,224,255,255,255,240,255,224,127,255,255,240,2,224,0,3,208,0,2,224,0,3,208,0,2,224,0,3,208,0,2,226,255,255,255,253,2,226,255,255,255,253,2,224,85,87,229,84,2,224,0,3,208,0,2,224,0,3,208,0,11,244,0,3,208,0,63,255,0,3,208,0,254,31,250,149,90,175,252,3,255,255,255,255,48,0,47,255,255,253,0,0,0,0,0,0,
  // 0x8ff7  迷
  247,143,24,25,150,26,1,253,8,0,0,15,64,0,62,0,180,15,64,244,47,192,188,15,64,244,7,240,61,15,66,240,1,244,46,15,67,208,0,160,31,15,75,128,0,0,13,15,71,0,0,0,0,15,64,0,0,3,255,255,255,253,0,3,255,255,255,253,191,240,0,191,244,0,191,240,0,255,244,0,1,240,2,255,188,0,1,240,7,207,111,0,1,240,31,79,79,128,1,240,127,15,71,224,1,241,252,15,66,252,1,243,240,15,64,189,1,241,192,15,64,40,3,248,0,15,64,0,31,254,0,10,0,0,191,111,249,85,85,85,189,7,255,255,255,254,48,0,111,255,255,253,0,0,0,0,0,0,
  // 0x9000  退
  0,144,24,24,144,26,1,253,46,0,47,255,255,208,63,192,47,255,255,208,11,240,46,0,3,208,2,248,46,0,3,208,0,176,47,255,255,208,0,0,47,255,255,208,0,0,46,0,3,208,0,0,46,0,3,208,0,0,47,255,255,208,191,240,47,255,255,208,191,240,46,7,192,116,1,240,46,3,210,252,1,240,46,2,255,224,1,240,46,0,255,64,1,240,46,0,189,0,1,240,46,27,127,64,1,240,127,255,79,228,1,241,255,249,3,253,3,248,249,0,0,188,31,254,64,0,0,0,191,111,249,85,85,85,189,7,255,255,255,254,48,0,111,255,255,253,0,0,0,0,0,0,
  // 0x9009  选
  9,144,24,26,156,26,1,253,0,0,0,1,64,0,4,0,5,11,192,0,62,0,15,75,192,0,47,128,31,11,192,0,11,224,63,255,255,248,2,240,127,255,255,248,0,208,248,11,192,0,0,1,240,11,192,0,0,0,96,11,192,0,0,0,0,11,192,0,0,2,255,255,255,254,191,242,255,255,255,254,191,240,1,240,188,0,2,240,1,240,188,0,2,240,2,240,188,0,2,240,3,224,188,0,2,240,11,192,188,14,2,240,47,128,188,31,2,240,191,0,125,46,2,243,252,0,127,253,2,249,224,0,47,248,11,255,64,0,0,0,63,139,249,85,85,90,190,1,255,255,255,254,56,0,27,255,255,253,0,0,0,0,0,0,
  // 0x901f  速
  31,144,24,26,156,26,1,253,0,0,0,5,0,0,8,0,0,15,64,0,63,0,0,15,64,0,31,210,255,255,255,253,7,246,255,255,255,253,1,244,0,15,64,0,0,80,0,15,64,0,0,0,191,255,255,244,0,0,191,255,255,244,0,0,184,15,64,244,0,0,184,15,64,244,191,240,184,15,64,244,191,240,191,255,255,244,1,240,191,255,255,244,1,240,0,191,224,0,1,240,1,255,248,0,1,240,7,223,191,0,1,240,47,143,79,208,1,241,254,15,67,248,1,243,248,15,64,253,3,248,208,15,64,36,31,254,0,15,64,0,191,111,249,85,85,85,189,7,255,255,255,254,48,0,111,255,255,253,0,0,0,0,0,0,
  // 0x90e8  部
  232,144,24,25,150,26,1,253,0,31,0,0,0,0,0,31,0,11,255,253,0,31,0,11,255,255,127,255,255,203,213,125,127,255,255,203,128,188,1,0,24,11,128,248,7,128,61,11,129,240,3,192,60,11,130,240,3,208,184,11,131,208,2,144,116,11,135,192,255,255,255,219,139,192,255,255,255,219,131,224,0,0,0,11,128,244,0,0,0,11,128,124,15,255,255,11,128,61,15,255,255,11,128,61,15,0,31,11,128,62,15,0,15,11,128,61,15,0,15,11,133,189,15,0,15,11,143,252,15,0,31,11,139,224,15,255,255,11,128,0,15,255,255,11,128,0,15,0,15,11,128,0,5,0,5,5,64,0,
  // 0x914d  配
  77,145,24,24,144,26,1,253,191,255,255,63,255,252,191,255,255,63,255,252,0,227,128,21,85,124,0,227,128,0,0,60,0,227,128,0,0,60,63,255,254,0,0,60,63,255,254,0,0,60,60,163,30,0,0,60,60,163,30,47,255,252,60,163,30,47,255,252,60,211,30,47,85,124,60,195,110,46,0,60,63,195,254,46,0,0,61,0,30,46,0,0,60,0,30,46,0,0,62,170,190,46,0,0,63,255,254,46,0,4,60,0,30,46,0,15,60,0,30,46,0,15,60,0,30,46,0,31,63,255,254,47,64,126,63,255,254,31,255,253,60,0,30,11,255,244,20,0,0,0,0,0,
  // 0x91ca  释
  202,145,24,25,150,26,1,253,0,91,224,0,0,0,191,255,243,255,255,253,191,253,3,255,255,252,0,184,0,184,1,244,116,184,180,61,3,240,60,184,240,31,79,192,45,186,208,7,255,0,13,186,192,3,252,0,0,184,0,47,255,128,191,255,247,255,15,253,191,255,255,244,2,255,1,252,11,65,240,45,2,254,0,1,240,0,3,255,64,1,240,0,11,255,195,255,255,248,15,250,243,255,255,248,62,184,224,1,240,0,188,184,0,1,240,0,244,184,15,255,255,254,96,184,15,255,255,254,0,184,0,1,244,0,0,184,0,1,240,0,0,184,0,1,240,0,0,184,0,1,240,0,0,80,0,0,80,0,
  // 0x91cd  重
  205,145,24,24,144,26,1,254,0,0,5,106,255,64,7,255,255,255,255,128,3,255,175,229,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,7,192,0,0,0,0,7,192,0,0,3,255,255,255,255,192,3,250,175,234,175,192,3,224,7,192,7,192,3,255,255,255,255,192,3,250,171,234,175,192,3,224,7,192,7,192,3,250,175,234,175,192,3,255,255,255,255,192,0,0,7,192,0,0,0,0,7,192,0,0,11,255,255,255,255,240,11,255,255,255,255,240,0,0,7,192,0,0,0,0,7,192,0,0,191,255,255,255,255,254,191,255,255,255,255,254,
  // 0x91cf  量
  207,145,24,24,144,26,1,254,0,85,85,85,85,0,1,255,255,255,255,64,1,240,0,0,15,64,1,255,255,255,255,64,1,245,85,85,95,64,1,245,85,85,95,64,1,255,255,255,255,64,0,0,0,0,0,0,191,255,255,255,255,254,127,255,255,255,255,254,0,0,0,0,0,0,3,255,255,255,255,192,3,229,91,213,91,192,3,229,87,213,91,192,3,255,255,255,255,192,3,208,3,192,7,192,3,255,255,255,255,192,1,85,91,213,85,64,0,0,3,192,0,0,7,255,255,255,255,224,6,170,171,234,170,144,0,0,3,192,0,0,191,255,255,255,255,254,191,255,255,255,255,254,
  // 0x9488  针
  136,148,24,25,150,26,1,253,2,224,0,0,244,0,3,208,0,0,244,0,11,208,0,0,244,0,15,255,240,0,244,0,63,255,240,0,244,0,253,0,0,0,244,0,244,0,0,0,244,0,111,255,208,0,244,0,15,255,223,255,255,254,0,248,15,255,255,254,0,184,15,255,255,254,0,184,0,0,244,0,0,184,0,0,244,0,127,255,240,0,244,0,127,255,240,0,244,0,0,184,0,0,244,0,0,184,0,0,244,0,0,184,0,0,244,0,0,184,0,0,244,0,0,184,180,0,244,0,0,255,244,0,244,0,1,255,192,0,244,0,2,253,0,0,244,0,0,208,0,0,244,0,0,0,0,0,80,0,
  // 0x94ae  钮
  174,148,24,26,156,26,1,253,1,0,0,0,0,0,7,192,0,0,0,0,11,128,11,255,255,252,15,234,155,255,255,252,31,255,224,11,192,184,63,255,224,11,128,184,188,0,0,15,128,248,244,0,0,15,64,248,255,255,192,15,64,244,111,255,192,15,0,244,0,244,0,15,0,244,0,240,11,255,255,240,0,240,11,255,255,240,0,244,1,111,86,240,191,255,224,46,1,240,191,255,224,62,1,240,0,240,0,61,2,240,0,240,0,61,2,224,0,240,0,60,2,224,0,240,128,124,3,224,0,251,208,124,3,208,0,255,192,188,3,208,2,253,191,255,255,255,3,224,191,255,255,255,2,64,21,85,85,85,0,0,0,0,0,0,
  // 0x9519  错
  25,149,24,26,156,26,1,253,0,0,0,20,5,0,3,208,0,60,15,64,7,192,0,60,15,64,11,213,64,60,15,64,31,255,219,255,255,252,63,255,219,255,255,252,252,0,0,60,15,64,180,0,0,60,15,64,47,255,192,60,15,64,15,255,207,255,255,255,0,244,15,255,255,255,0,244,0,0,0,0,0,244,0,0,0,0,0,244,2,255,255,240,127,255,226,255,255,240,127,255,226,224,0,240,0,244,2,224,0,240,0,244,2,224,0,240,0,244,2,255,255,240,0,244,2,255,255,240,0,246,194,224,0,240,0,255,210,224,0,240,2,255,66,255,255,240,3,244,2,255,255,240,1,128,2,224,0,240,0,0,0,0,0,0,
  // 0x955c  镜
  92,149,24,26,156,26,1,253,0,0,0,1,144,0,3,208,0,2,240,0,3,208,7,255,255,252,11,192,7,255,255,252,15,255,192,40,3,128,63,255,192,60,7,192,189,0,0,60,11,128,244,0,15,255,255,254,47,255,143,255,255,254,15,255,128,0,0,0,1,244,2,170,170,164,0,240,3,255,255,248,0,240,3,192,0,184,1,244,3,229,85,248,127,255,211,255,255,248,127,255,211,192,0,184,0,240,3,192,0,184,0,240,3,255,255,248,0,240,2,191,191,164,0,240,128,61,31,0,0,247,208,60,31,0,1,255,192,188,31,14,3,254,2,244,31,15,7,240,127,208,31,255,2,128,63,64,11,253,0,0,0,0,0,0,
  // 0x957f  长
  127,149,24,25,150,26,1,253,0,62,0,0,9,0,0,62,0,0,47,192,0,62,0,0,191,0,0,62,0,3,252,0,0,62,0,47,224,0,0,62,1,255,128,0,0,62,31,252,0,0,0,62,15,208,0,0,0,62,2,0,0,0,0,62,0,0,0,0,127,255,255,255,255,253,127,255,255,255,255,253,21,127,86,245,85,84,0,62,0,248,0,0,0,62,0,188,0,0,0,62,0,62,0,0,0,62,0,47,128,0,0,62,0,11,224,0,0,62,0,3,248,0,0,62,1,160,255,64,0,63,191,224,63,244,0,127,255,224,11,254,0,191,228,0,0,188,0,57,0,0,0,4,0,0,0,0,0,0,
  // 0x95ed  闭
  237,149,22,25,150,26,2,253,44,0,0,0,0,0,63,3,255,255,255,240,15,195,255,255,255,240,7,224,85,85,86,240,2,128,0,0,1,240,0,0,0,188,1,240,248,0,0,188,1,240,248,0,0,188,1,240,248,21,85,189,81,240,248,191,255,255,241,240,248,191,255,255,241,240,248,0,7,252,1,240,248,0,15,252,1,240,248,0,63,188,1,240,248,0,252,188,1,240,248,7,240,188,1,240,248,47,192,188,1,240,249,254,0,188,1,240,248,244,0,188,1,240,248,64,21,252,1,240,248,0,63,248,1,240,248,0,63,224,2,240,248,0,0,0,191,224,248,0,0,0,63,192,80,0,0,0,0,0,
  // 0x95f2  闲
  242,149,22,25,150,26,2,253,29,0,0,0,0,0,47,66,255,255,255,240,11,194,255,255,255,240,3,240,0,0,1,240,0,248,0,0,1,240,80,160,5,0,1,240,244,0,15,0,1,240,244,0,15,0,1,240,244,0,15,0,1,240,244,255,255,255,241,240,244,255,255,255,241,240,244,0,127,208,1,240,244,0,255,240,1,240,244,2,255,252,1,240,244,7,223,63,1,240,244,15,79,15,193,240,244,127,15,3,225,240,245,252,15,2,225,240,244,176,15,0,65,240,244,0,15,0,1,240,244,0,15,0,1,240,244,0,15,1,86,240,244,0,0,3,255,224,244,0,0,1,255,128,80,0,0,0,0,0,
  // 0x95f4  间
  244,149,22,25,150,26,2,253,28,0,0,0,0,0,63,3,255,255,255,240,15,195,255,255,255,240,7,209,85,85,86,240,2,64,0,0,2,240,16,0,0,0,2,240,184,0,0,0,2,240,184,15,255,255,2,240,184,15,255,255,2,240,184,15,0,15,2,240,184,15,0,15,2,240,184,15,0,15,2,240,184,15,255,255,2,240,184,15,255,255,2,240,184,15,0,15,2,240,184,15,0,15,2,240,184,15,0,15,2,240,184,15,0,15,2,240,184,15,255,255,2,240,184,15,255,255,2,240,184,0,0,0,2,240,184,0,0,0,2,240,184,0,0,0,63,224,184,0,0,0,63,192,16,0,0,0,0,0,
  // 0x9608  阈
  8,150,22,25,150,26,2,253,15,0,0,0,0,0,31,130,255,255,255,224,7,226,255,255,255,224,2,244,0,0,2,224,0,248,2,214,2,224,184,16,2,215,130,224,184,0,2,210,130,224,184,255,255,255,242,224,184,255,255,255,242,224,184,0,1,224,2,224,184,21,80,225,210,224,184,127,244,227,194,224,184,112,52,243,194,224,184,112,52,247,130,224,184,117,180,191,2,224,184,127,244,126,2,224,184,0,0,124,34,224,184,1,108,188,58,224,184,255,253,254,118,224,184,254,91,223,242,224,184,0,31,7,226,224,184,0,4,0,2,224,184,0,0,2,255,224,184,0,0,1,255,128,80,0,0,0,0,0,
  // 0x964d  降
  77,150,23,26,156,26,2,253,0,0,0,16,0,0,0,0,0,124,0,0,255,253,0,248,0,0,255,254,2,255,255,128,240,60,7,255,255,128,240,124,31,208,31,0,240,180,191,240,62,0,240,240,244,189,252,0,241,240,16,63,240,0,242,208,0,47,240,0,241,240,2,255,254,64,240,184,127,244,63,248,240,60,255,65,246,244,240,61,96,1,240,0,240,45,63,255,255,240,240,45,63,255,255,240,244,61,11,129,240,0,247,252,7,129,240,0,243,244,7,129,240,0,240,1,255,255,255,248,240,1,255,255,255,248,240,0,0,1,240,0,240,0,0,1,240,0,240,0,0,1,240,0,240,0,0,1,240,0,80,0,0,0,80,0,
  // 0x9650  限
  80,150,23,24,144,26,2,253,255,254,47,255,255,208,255,255,47,255,255,208,244,47,47,0,3,208,244,61,47,0,3,208,244,60,47,0,3,208,244,120,47,255,255,208,244,244,47,255,255,208,244,240,47,0,3,208,244,240,47,0,3,208,244,188,47,0,3,208,244,61,47,255,255,208,244,30,47,255,255,208,244,15,47,11,128,64,244,15,47,7,193,240,244,47,47,3,199,224,247,254,47,2,255,64,246,248,47,1,253,0,244,0,47,0,252,0,244,0,47,0,126,0,244,0,47,175,111,128,244,2,191,255,79,240,244,3,255,228,3,252,244,2,228,0,0,176,80,0,0,0,0,0,
  // 0x9664  除
  100,150,23,26,156,26,2,253,0,0,0,5,0,0,0,0,0,63,64,0,255,253,0,191,192,0,255,253,1,246,240,0,240,60,7,224,252,0,240,124,31,192,63,64,240,180,190,0,15,224,240,243,248,0,3,252,241,227,239,255,255,184,242,208,15,255,255,16,240,240,0,31,0,0,240,184,0,31,0,0,240,60,0,31,0,0,240,61,191,255,255,240,240,45,191,255,255,240,240,45,0,31,0,0,244,61,0,31,0,0,247,252,46,31,15,0,243,244,60,31,15,128,240,0,188,31,7,192,240,1,244,31,2,240,240,3,224,31,0,244,240,7,192,31,0,184,240,1,3,255,0,0,240,0,2,253,0,0,0,0,0,0,0,0,
  // 0x9669  险
  105,150,23,26,156,26,2,253,0,0,0,4,0,0,0,0,0,15,0,0,255,253,0,63,64,0,255,254,0,127,192,0,244,60,0,251,240,0,244,124,3,224,252,0,244,184,15,192,63,0,244,240,63,0,15,208,245,241,253,0,3,248,246,227,255,255,253,252,245,242,203,255,253,36,244,184,0,0,0,0,244,60,0,0,0,0,244,61,20,15,1,224,244,45,60,15,2,224,244,45,45,15,3,192,244,61,30,11,71,128,247,252,15,7,143,64,247,244,15,7,143,0,244,0,11,0,45,0,244,0,0,0,60,0,244,0,0,0,180,0,244,1,255,255,255,248,244,1,255,255,255,248,244,0,0,0,0,0,80,0,0,0,0,0,
  // 0x96f6  零
  246,150,24,24,144,26,1,253,7,255,255,255,255,208,7,255,255,255,255,208,0,0,3,192,0,0,63,255,255,255,255,252,62,170,171,234,170,188,60,0,3,192,0,60,60,255,227,207,255,60,60,0,3,192,0,60,1,255,224,15,255,64,0,85,95,229,85,0,0,0,127,252,0,0,0,7,252,127,128,0,0,127,224,11,253,0,27,255,234,171,255,249,255,210,255,255,135,254,120,0,0,0,0,28,2,170,170,170,170,0,3,255,255,255,255,0,0,0,61,0,15,0,0,0,61,0,15,0,0,0,61,3,255,0,0,0,61,3,253,0,0,0,61,0,0,0,0,0,20,0,0,0,
  // 0x9700  需
  0,151,24,23,138,26,1,254,7,255,255,255,255,208,7,255,255,255,255,208,0,0,3,192,0,0,63,255,255,255,255,252,62,170,171,234,170,188,60,0,3,192,0,60,60,255,227,207,255,60,60,106,147,198,169,60,0,170,147,198,170,0,1,255,227,207,255,64,0,0,3,192,0,0,0,0,0,0,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,11,128,0,0,7,255,255,255,255,240,7,255,255,255,255,240,7,192,180,15,1,240,7,192,180,15,1,240,7,192,180,15,1,240,7,192,180,15,1,240,7,192,180,15,47,240,7,192,180,15,31,208,
  // 0x9752  青
  82,151,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,11,255,255,255,255,240,15,255,255,255,255,240,0,0,7,192,0,0,0,0,7,192,0,0,3,255,255,255,255,192,2,255,255,255,255,128,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,255,255,255,255,0,0,244,0,0,31,0,0,255,255,255,255,0,0,254,170,170,191,0,0,244,0,0,31,0,0,254,170,170,191,0,0,255,255,255,255,0,0,244,0,0,31,0,0,244,0,0,31,0,0,244,0,15,255,0,0,244,0,15,248,0,0,0,0,0,0,0,
  // 0x975e  非
  94,151,24,25,150,26,1,253,0,1,240,15,0,0,0,1,240,15,0,0,0,1,240,15,0,0,0,2,240,15,64,0,63,255,240,15,255,253,63,255,240,15,255,253,0,1,240,15,0,0,0,1,240,15,0,0,0,1,240,15,0,0,0,2,240,15,64,0,47,255,240,15,255,252,47,255,240,15,255,252,0,1,240,15,0,0,0,2,240,15,0,0,0,2,245,15,0,0,1,111,255,15,64,0,255,255,254,15,255,255,191,239,192,15,255,255,80,15,128,15,0,0,0,63,0,15,0,0,0,189,0,15,0,0,3,248,0,15,0,0,47,224,0,15,0,0,31,64,0,15,0,0,4,0,0,5,0,0,
  // 0x9760  靠
  96,151,24,26,156,26,1,253,0,0,1,64,0,0,0,184,3,192,0,0,0,254,171,234,170,128,3,255,255,255,255,208,11,192,3,192,0,0,47,234,175,234,170,168,63,255,255,255,255,252,0,0,3,192,0,0,1,170,170,170,170,128,2,255,255,255,255,192,2,224,0,0,7,192,2,250,170,170,171,192,2,255,255,255,255,192,0,0,240,15,0,0,42,170,240,15,170,168,63,255,240,15,255,252,0,0,240,15,0,0,5,86,240,15,170,164,31,255,240,15,255,248,0,1,240,15,0,0,111,255,240,15,170,170,191,171,208,15,255,255,0,31,192,15,0,0,6,255,0,15,0,0,7,244,0,15,0,0,1,0,0,5,0,0,
  // 0x9762  面
  98,151,24,24,144,26,1,253,127,255,255,255,255,254,127,255,255,255,255,254,21,85,95,213,85,84,0,0,15,192,0,0,0,0,15,64,0,0,0,0,31,64,0,0,31,255,255,255,255,244,31,255,255,255,255,244,31,2,208,11,64,244,31,2,208,11,64,244,31,2,255,255,64,244,31,2,255,255,64,244,31,2,208,11,64,244,31,2,208,11,64,244,31,2,208,11,64,244,31,2,255,255,64,244,31,2,255,255,64,244,31,2,208,11,64,244,31,2,208,11,64,244,31,3,224,15,129,244,31,255,255,255,255,244,31,255,255,255,255,244,31,0,0,0,0,244,5,0,0,0,0,80,
  // 0x9875  页
  117,152,23,24,144,26,1,253,63,255,255,255,255,252,63,255,255,255,255,252,0,0,31,192,0,0,0,0,15,64,0,0,0,0,47,0,0,0,2,255,255,255,255,192,2,255,255,255,255,192,2,240,0,0,11,192,2,240,1,64,11,192,2,240,3,208,11,192,2,240,3,208,11,192,2,240,3,208,11,192,2,240,3,208,11,192,2,240,3,208,11,192,2,240,7,208,11,192,2,240,7,192,11,192,2,240,15,192,11,192,1,144,47,95,69,64,0,0,254,47,244,0,0,11,248,2,255,64,1,255,208,0,47,240,127,254,0,0,7,252,63,144,0,0,0,184,0,0,0,0,0,0,
  // 0x9879  项
  121,152,24,24,144,26,1,253,0,0,63,255,255,255,85,85,63,255,255,255,255,255,128,11,192,0,255,255,128,15,192,0,2,224,0,31,128,0,2,224,15,255,255,244,2,224,15,255,255,244,2,224,15,0,0,244,2,224,15,2,128,244,2,224,15,3,208,244,2,224,15,3,208,244,2,224,15,3,208,244,2,224,15,3,208,244,2,224,15,3,208,244,2,255,207,3,192,244,27,255,207,7,192,244,255,248,15,11,192,244,254,64,0,15,132,0,80,0,0,63,46,0,0,0,1,253,47,208,0,0,31,244,3,248,0,1,255,128,0,190,0,0,249,0,0,45,0,0,0,0,0,0,
  // 0x9884  预
  132,152,24,24,144,26,1,253,127,255,243,255,255,255,127,255,243,255,255,255,0,7,208,0,248,0,4,31,128,0,244,0,47,190,0,255,255,252,15,248,0,255,255,252,2,252,0,240,0,188,0,191,0,240,0,124,0,47,0,240,164,124,255,255,252,240,244,124,255,255,252,240,244,124,0,244,180,240,244,124,0,244,240,240,244,124,0,244,240,240,244,124,0,245,208,240,244,124,0,244,0,240,240,124,0,244,0,241,240,124,0,244,0,83,240,0,0,244,0,11,219,64,0,244,0,47,139,224,0,244,1,254,2,248,63,240,15,244,0,190,47,224,7,128,0,44,4,0,0,0,0,0,
  // 0x9891  频
  145,152,24,26,156,26,1,253,0,5,0,0,0,0,0,15,0,0,0,0,0,15,0,191,255,254,14,15,0,191,255,254,14,15,253,0,61,0,14,15,253,0,124,0,14,15,0,0,184,0,14,15,0,63,255,252,31,31,0,63,255,252,255,255,255,60,0,60,255,255,255,60,60,60,0,61,0,60,60,60,4,61,0,60,60,60,15,61,31,60,60,60,30,61,46,60,60,60,61,61,61,60,60,60,124,61,124,60,120,60,244,61,248,60,120,60,32,63,240,60,180,60,0,7,208,20,244,20,0,31,128,1,251,64,0,190,0,3,219,208,7,248,0,31,193,248,127,208,2,254,0,126,62,0,3,244,0,30,16,0,0,0,0,0,
  // 0x989d  额
  157,152,24,25,150,26,1,253,0,124,0,0,0,0,0,62,0,191,255,254,127,255,255,191,255,254,127,255,255,0,124,0,120,0,15,0,184,0,120,160,15,0,244,0,101,240,10,127,255,252,3,255,248,127,255,252,15,255,252,120,0,60,63,1,244,120,56,60,189,215,224,120,60,60,35,255,128,120,124,60,0,255,208,120,124,60,11,251,252,120,120,60,191,208,191,120,120,60,125,0,12,120,184,60,31,255,248,120,180,60,11,255,248,120,240,60,11,64,184,21,240,20,11,64,184,3,231,128,11,64,184,11,199,240,11,255,248,63,65,252,11,255,250,253,0,63,11,64,186,224,0,13,0,0,0,0,0,0,
  // 0x98ce  风
  206,152,24,25,150,26,1,253,1,85,85,85,85,0,3,255,255,255,255,128,3,255,255,255,255,128,3,224,0,0,11,128,3,224,0,0,11,128,3,224,0,11,75,128,3,227,192,15,11,128,3,227,224,31,11,128,3,225,244,62,11,128,3,224,189,124,11,128,3,224,63,248,11,128,3,208,15,240,11,128,3,208,7,240,11,128,3,208,11,240,11,128,7,192,31,252,11,128,7,192,63,190,11,192,11,192,189,63,7,192,15,130,248,15,199,192,15,75,240,11,211,198,31,31,192,3,227,199,63,11,0,1,67,215,125,0,0,0,2,255,252,0,0,0,0,254,52,0,0,0,0,124,0,0,0,0,0,0,
  // 0x9971  饱
  113,153,24,25,150,26,1,253,7,192,0,184,0,0,7,192,0,244,0,0,11,128,1,240,0,0,15,64,3,255,255,248,15,255,211,255,255,248,31,255,203,128,0,184,62,7,159,0,0,184,60,15,127,255,244,184,188,31,127,255,244,184,246,224,59,192,244,184,114,224,7,192,244,244,2,224,7,192,244,244,2,224,7,192,244,244,2,224,7,192,244,244,2,224,7,255,244,244,2,224,7,255,244,244,2,224,7,192,63,240,2,224,7,192,63,208,2,227,135,192,0,0,2,255,199,192,0,13,3,255,7,192,0,31,3,248,3,208,0,62,11,208,3,255,255,253,3,64,0,191,255,244,0,0,0,0,0,0,
  // 0x9a6c  马
  108,154,23,24,144,26,1,253,11,255,255,255,253,0,11,255,255,255,253,0,1,85,85,85,125,0,0,0,0,0,60,0,0,56,0,0,124,0,0,124,0,0,124,0,0,124,0,0,188,0,0,124,0,0,188,0,0,188,0,0,184,0,0,184,0,0,248,0,0,248,0,0,248,0,0,255,255,255,255,252,0,255,255,255,255,252,0,0,0,0,0,184,0,0,0,0,0,248,21,85,85,85,64,244,127,255,255,255,208,244,127,255,255,255,209,240,0,0,0,0,1,240,0,0,0,0,3,240,0,0,0,0,7,224,0,0,0,15,255,192,0,0,0,15,255,64,0,0,0,0,0,0,
  // 0x9a71  驱
  113,154,24,24,144,26,1,253,127,255,131,255,255,253,127,255,131,255,255,253,0,11,131,208,0,0,4,11,67,192,0,0,30,11,67,193,0,244,46,11,67,207,65,240,45,15,67,203,194,224,45,15,3,195,227,208,61,15,3,193,251,192,60,15,3,192,191,128,60,15,3,192,63,0,63,255,227,192,47,64,63,255,227,192,127,192,0,2,227,192,255,224,0,2,227,193,242,240,0,22,211,195,224,248,107,250,211,207,192,124,255,211,211,223,64,56,164,3,195,198,0,0,0,3,195,192,0,0,0,7,195,255,255,255,3,255,67,255,255,255,3,254,0,0,0,0,0,0,0,0,0,0,
  // 0x9ad8  高
  216,154,22,26,156,26,2,253,0,0,5,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,255,255,255,255,255,240,255,255,255,255,255,240,0,0,0,0,0,0,0,170,170,170,160,0,0,255,255,255,240,0,0,244,0,1,240,0,0,244,0,1,240,0,0,254,170,171,240,0,0,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,208,63,255,255,255,255,208,60,0,0,0,3,208,60,10,170,170,3,208,60,15,255,255,3,208,60,15,0,15,3,208,60,15,0,15,3,208,60,15,170,191,3,208,60,15,255,255,3,208,60,15,0,2,255,192,60,5,0,1,255,128,20,0,0,0,64,0,
  // 0x9ec4  黄
  196,158,24,26,156,26,1,253,0,1,64,1,64,0,0,7,192,3,208,0,0,7,208,3,208,0,11,255,255,255,255,240,11,255,255,255,255,240,0,7,192,3,208,0,0,7,192,3,208,0,127,255,255,255,255,254,127,255,255,255,255,254,0,0,7,208,0,0,0,0,3,192,0,0,2,170,175,250,170,128,3,255,255,255,255,192,3,224,3,192,7,192,3,224,3,192,7,192,3,255,255,255,255,192,3,250,171,234,175,192,3,224,3,192,7,192,3,224,3,192,7,192,3,255,255,255,255,192,2,171,234,171,170,128,0,7,192,3,208,0,0,127,224,7,254,64,31,254,0,0,111,248,63,208,0,0,1,248,4,0,0,0,0,16,
  // 0x9ede  點
  222,158,24,26,156,26,1,253,0,0,0,0,84,0,42,170,169,0,184,0,63,255,253,0,184,0,60,44,29,0,184,0,63,108,237,0,184,0,62,172,237,0,184,0,61,237,221,0,191,255,61,238,93,0,191,255,60,44,29,0,184,0,62,190,189,0,184,0,63,255,253,0,184,0,0,60,0,0,184,0,0,60,0,0,184,0,63,255,254,127,255,252,63,255,253,127,255,252,0,60,0,124,0,124,0,63,191,124,0,124,191,255,255,124,0,124,186,149,0,124,0,124,0,70,56,124,0,124,44,215,45,124,0,124,60,227,143,124,0,124,60,243,203,191,255,252,184,178,193,127,255,252,240,80,0,124,0,124,0,0,0,20,0,20,
  // 0x9f50  齐
  80,159,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,47,0,0,252,0,0,15,192,3,240,0,0,3,240,15,208,0,0,0,253,127,64,0,0,0,63,253,0,0,0,0,111,254,0,0,0,27,255,255,249,0,107,255,244,11,255,254,127,254,0,0,111,253,62,95,0,0,188,104,0,31,0,0,188,0,0,31,0,0,188,0,0,31,0,0,188,0,0,47,0,0,188,0,0,63,0,0,188,0,0,62,0,0,188,0,0,253,0,0,188,0,2,248,0,0,188,0,31,240,0,0,188,0,11,192,0,0,188,0,1,0,0,0,84,0,
  // 0xff1a  ：
  26,255,4,17,17,26,11,1,190,255,255,125,0,0,0,0,0,0,0,0,0,190,255,255,125,
};

#endif // HAS_GRAPHICAL_TFT
