/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Korean 26pt, capital 'A' height: 19px, width: 100%, range: 0xac70-0xd788, glyphs: 110
extern const uint8_t NotoSans_Medium_Korean_19[15510] = {
  162,19,112,172,136,215,25,249, // unifont_t
  // 0xac70  거
  112,172,20,25,125,24,1,253,0,0,0,0,62,0,0,0,0,63,0,0,0,0,63,63,255,255,0,63,63,255,255,0,63,0,0,47,0,63,0,0,63,0,63,0,0,62,0,63,0,0,125,0,63,0,0,188,0,63,0,0,252,255,255,0,2,244,255,255,0,3,240,0,63,0,15,192,0,63,0,63,128,0,63,0,254,0,0,63,7,248,0,0,63,127,208,0,0,63,127,64,0,0,63,36,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,21,
  // 0xace0  고
  224,172,22,20,120,24,1,0,7,255,255,255,252,0,7,255,255,255,252,0,0,0,0,0,188,0,0,0,0,0,124,0,0,0,0,0,124,0,0,0,0,0,124,0,0,0,0,0,188,0,0,0,0,0,188,0,0,0,188,0,188,0,0,0,252,0,252,0,0,0,252,0,252,0,0,0,252,0,248,0,0,0,252,0,248,0,0,0,252,1,244,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,
  // 0xadf8  그
  248,173,22,18,108,24,1,1,7,255,255,255,252,0,7,255,255,255,252,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,244,0,0,0,0,1,244,0,0,0,0,2,240,0,0,0,0,2,240,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,
  // 0xae09  급
  9,174,22,23,138,24,1,254,3,255,255,255,252,0,3,255,255,255,252,0,0,0,0,0,252,0,0,0,0,0,188,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,1,248,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,3,224,0,0,252,0,3,224,0,0,252,0,3,224,0,0,252,0,3,255,255,255,252,0,3,255,255,255,252,0,3,224,0,0,252,0,3,224,0,0,252,0,3,224,0,0,252,0,3,255,255,255,252,0,3,255,255,255,252,0,
  // 0xae30  기
  48,174,19,25,125,24,2,253,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,127,255,254,0,248,127,255,254,0,248,0,0,62,0,248,0,0,125,0,248,0,0,189,0,248,0,0,188,0,248,0,0,248,0,248,0,2,244,0,248,0,3,240,0,248,0,11,208,0,248,0,47,128,0,248,0,191,0,0,248,2,252,0,0,248,31,240,0,0,248,191,192,0,0,248,254,0,0,0,248,96,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,80,
  // 0xae45  깅
  69,174,19,25,125,24,2,253,0,0,0,0,248,0,0,0,0,248,63,255,254,0,248,63,255,253,0,248,0,0,125,0,248,0,0,188,0,248,0,0,248,0,248,0,2,240,0,248,0,11,224,0,248,0,47,192,0,248,0,255,0,0,248,11,252,0,0,248,255,224,0,0,248,254,0,0,0,248,80,0,0,0,164,0,7,255,249,0,0,127,255,255,192,1,253,0,27,240,3,240,0,1,248,3,224,0,0,248,3,240,0,1,248,1,253,0,27,240,0,127,255,255,192,0,7,255,249,0,0,0,0,0,0,
  // 0xb044  끄
  68,176,22,18,108,24,1,1,15,255,226,255,252,0,15,255,226,255,252,0,0,3,224,0,124,0,0,3,224,0,124,0,0,3,224,0,124,0,0,3,208,0,124,0,0,7,208,0,188,0,0,7,192,0,188,0,0,11,192,0,188,0,0,15,192,0,252,0,0,15,128,0,248,0,0,31,64,0,248,0,0,31,0,1,244,0,0,1,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,
  // 0xb0b4  내
  180,176,20,25,125,24,2,253,0,0,1,160,125,0,0,2,240,125,0,0,2,240,125,188,0,2,240,125,188,0,2,240,125,188,0,2,240,125,188,0,2,240,125,188,0,2,240,125,188,0,2,240,125,188,0,2,240,125,188,0,2,255,253,188,0,2,255,253,188,0,2,240,125,188,0,2,240,125,188,0,2,240,125,189,90,242,240,125,191,255,242,240,125,191,254,146,240,125,0,0,2,240,125,0,0,2,240,125,0,0,2,240,125,0,0,2,240,125,0,0,2,240,125,0,0,0,0,125,0,0,0,0,20,
  // 0xb178  노
  120,177,22,20,120,24,1,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,31,64,0,0,0,0,31,64,0,0,0,0,31,64,0,0,0,0,31,64,0,0,0,0,31,64,0,0,0,0,31,64,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,
  // 0xb204  누
  4,178,22,24,144,24,1,253,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,5,0,0,0,
  // 0xb274  뉴
  116,178,22,24,144,24,1,253,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,47,64,31,64,0,0,31,0,31,64,0,0,31,0,31,64,0,0,31,0,31,64,0,0,31,0,31,64,0,0,31,0,31,64,0,0,31,0,31,64,0,0,31,0,31,64,0,0,31,0,31,64,0,0,5,0,5,0,0,
  // 0xb2c8  니
  200,178,19,25,125,24,2,253,0,0,0,0,248,0,0,0,0,248,40,0,0,0,248,125,0,0,0,248,125,0,0,0,248,125,0,0,0,248,125,0,0,0,248,125,0,0,0,248,125,0,0,0,248,125,0,0,0,248,125,0,0,0,248,125,0,0,0,248,125,0,0,0,248,125,0,0,0,248,125,0,0,16,248,126,85,175,240,248,127,255,255,240,248,127,255,165,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,80,
  // 0xb2e4  다
  228,178,21,25,150,24,2,253,0,0,0,3,208,0,0,0,0,3,208,0,191,255,252,3,208,0,191,255,252,3,208,0,188,0,0,3,208,0,188,0,0,3,208,0,188,0,0,3,208,0,188,0,0,3,208,0,188,0,0,3,208,0,188,0,0,3,255,192,188,0,0,3,255,192,188,0,0,3,224,0,188,0,0,3,208,0,188,0,0,3,208,0,188,0,0,3,208,0,188,0,26,131,208,0,191,255,255,195,208,0,191,255,254,131,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,1,64,0,
  // 0xb2f9  당
  249,178,21,25,150,24,2,253,0,0,0,3,224,0,0,0,0,3,224,0,255,255,248,3,224,0,255,255,248,3,224,0,252,0,0,3,224,0,252,0,0,3,224,0,252,0,0,3,255,192,252,0,0,3,255,192,252,0,0,3,240,0,252,0,0,3,224,0,252,5,111,195,224,0,255,255,255,195,224,0,255,255,233,67,224,0,0,0,0,3,224,0,0,0,0,1,80,0,0,27,255,244,0,0,0,255,255,255,64,0,3,249,0,47,208,0,11,208,0,3,224,0,11,192,0,3,240,0,11,208,0,3,224,0,3,249,0,47,208,0,0,255,255,255,64,0,0,27,255,244,0,0,0,0,0,0,0,0,
  // 0xb3c4  도
  196,179,22,20,120,24,1,0,3,255,255,255,252,0,3,255,255,255,252,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,47,64,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,
  // 0xb3cc  돌
  204,179,22,24,144,24,1,253,3,255,255,255,252,0,3,255,255,255,252,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,47,64,0,0,0,0,31,64,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,0,0,252,0,0,0,0,0,188,0,3,255,255,255,252,0,3,255,255,255,252,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,0,0,0,0,
  // 0xb3d9  동
  217,179,22,24,144,24,1,253,3,255,255,255,252,0,3,255,255,255,252,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,47,64,0,0,0,0,31,64,0,0,0,0,47,64,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,249,0,0,0,191,255,255,224,0,2,253,0,7,244,0,3,224,0,0,252,0,3,224,0,0,252,0,3,249,0,7,248,0,0,191,255,255,224,0,0,7,255,249,0,0,0,0,0,0,0,0,
  // 0xb418  되
  24,180,20,25,125,24,1,253,0,0,0,0,62,0,0,0,0,62,15,255,255,240,62,15,255,255,240,62,15,192,0,0,62,15,128,0,0,62,15,128,0,0,62,15,128,0,0,62,15,128,0,0,62,15,128,0,0,62,15,255,255,240,62,15,255,255,240,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,7,229,105,62,191,255,255,254,62,127,255,255,165,62,0,0,0,0,62,0,0,0,0,62,0,0,0,0,62,0,0,0,0,62,0,0,0,0,62,0,0,0,0,20,
  // 0xb41c  된
  28,180,21,24,144,24,1,254,0,0,0,0,62,0,0,0,0,0,62,0,11,255,255,224,62,0,11,255,255,224,62,0,11,192,0,0,62,0,11,192,0,0,62,0,11,192,0,0,62,0,11,208,0,0,62,0,11,255,255,240,62,0,11,255,255,240,62,0,0,3,208,0,62,0,0,3,208,0,62,0,0,7,229,88,62,0,191,255,255,253,62,0,127,255,254,164,62,0,0,0,0,0,62,0,0,0,0,0,62,0,0,252,0,0,62,0,0,252,0,0,20,0,0,252,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,255,255,255,255,64,0,255,255,255,255,64,
  // 0xb428  됨
  40,180,20,24,120,24,1,254,0,0,0,0,62,11,255,255,240,62,11,255,255,240,62,11,208,0,0,62,11,192,0,0,62,11,192,0,0,62,11,192,0,0,62,11,255,255,240,62,11,255,255,240,62,0,7,224,0,62,0,3,208,0,62,0,7,230,173,62,127,255,255,254,62,127,255,234,80,62,0,0,0,0,62,0,0,0,0,0,0,255,255,255,254,0,255,255,255,254,0,252,0,0,62,0,252,0,0,62,0,252,0,0,62,0,252,0,0,62,0,255,255,255,254,0,255,255,255,254,
  // 0xb4a4  뒤
  164,180,20,25,125,24,1,253,0,0,0,0,62,11,255,255,224,62,11,255,255,224,62,11,192,0,0,62,11,192,0,0,62,11,192,0,0,62,11,192,0,0,62,11,192,0,0,62,11,255,255,240,62,11,255,255,240,62,0,0,0,0,62,0,0,0,0,62,0,0,5,89,62,191,255,255,254,62,191,255,255,169,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,2,128,0,62,0,0,0,0,21,
  // 0xb4dc  드
  220,180,22,20,120,24,1,0,3,255,255,255,252,0,3,255,255,255,252,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,
  // 0xb514  디
  20,181,18,25,125,24,3,253,0,0,0,3,224,0,0,0,3,224,255,255,252,3,224,255,255,252,3,224,248,0,0,3,224,244,0,0,3,224,244,0,0,3,224,244,0,0,3,224,244,0,0,3,224,244,0,0,3,224,244,0,0,3,224,244,0,0,3,224,244,0,0,3,224,244,0,0,3,224,244,0,0,3,224,244,0,22,131,224,255,255,255,195,224,255,255,254,131,224,0,0,0,3,224,0,0,0,3,224,0,0,0,3,224,0,0,0,3,224,0,0,0,3,224,0,0,0,3,224,0,0,0,1,64,
  // 0xb77c  라
  124,183,21,25,150,24,2,253,0,0,0,3,224,0,0,0,0,3,224,0,255,255,252,3,224,0,255,255,252,3,224,0,0,0,252,3,224,0,0,0,188,3,224,0,0,0,188,3,224,0,0,0,188,3,224,0,0,0,188,3,224,0,191,255,252,3,224,0,191,255,252,3,255,192,188,0,0,3,255,192,188,0,0,3,224,0,188,0,0,3,224,0,188,0,0,3,224,0,188,0,22,131,224,0,191,255,255,195,224,0,191,255,254,131,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,1,64,0,
  // 0xb7ec  러
  236,183,19,25,125,24,2,253,0,0,0,0,252,0,0,0,0,252,255,255,248,0,252,255,255,248,0,252,0,0,248,0,252,0,0,248,0,252,0,0,248,0,252,0,0,248,0,252,0,0,248,0,252,255,255,248,255,252,255,255,248,255,252,252,0,0,0,252,252,0,0,0,252,252,0,0,0,252,252,0,0,0,252,252,0,22,64,252,255,255,255,128,252,255,255,250,64,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,80,
  // 0xb808  레
  8,184,20,25,125,24,2,253,0,0,0,80,61,0,0,0,248,61,0,0,0,248,61,255,255,64,248,61,255,255,64,248,61,0,15,64,248,61,0,15,64,248,61,0,15,64,248,61,0,15,64,248,61,255,255,111,248,61,255,255,111,248,61,248,0,0,248,61,248,0,0,248,61,248,0,0,248,61,248,0,0,248,61,248,1,96,248,61,255,255,244,248,61,255,255,224,248,61,0,0,0,248,61,0,0,0,248,61,0,0,0,248,61,0,0,0,248,61,0,0,0,248,61,0,0,0,0,61,0,0,0,0,20,
  // 0xb825  력
  37,184,19,25,125,24,2,253,0,0,0,0,248,255,255,244,0,252,255,255,244,0,252,0,1,244,0,252,0,0,244,255,252,0,0,244,255,252,0,1,244,0,252,191,255,244,0,252,191,255,244,0,252,188,0,0,255,252,188,0,0,255,252,188,1,89,0,252,191,255,254,0,252,191,255,233,0,252,0,0,0,0,248,0,0,0,0,0,3,255,255,255,252,3,255,255,255,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,84,
  // 0xb85c  로
  92,184,22,20,120,24,1,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,0,0,188,0,0,0,0,0,188,0,0,0,0,0,188,0,3,255,255,255,252,0,3,255,255,255,252,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,
  // 0xb8cc  료
  204,184,22,20,120,24,1,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,0,0,188,0,0,0,0,0,188,0,0,0,0,0,188,0,3,255,255,255,252,0,3,255,255,255,252,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,0,15,128,47,0,0,0,15,128,47,0,0,0,15,128,47,0,0,0,15,128,47,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,
  // 0xb974  르
  116,185,22,20,120,24,1,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,0,0,188,0,0,0,0,0,188,0,0,0,0,0,188,0,3,255,255,255,252,0,3,255,255,255,252,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,
  // 0xb9ac  리
  172,185,19,25,125,24,2,253,0,0,0,0,248,0,0,0,0,248,127,255,254,0,248,127,255,254,0,248,0,0,126,0,248,0,0,62,0,248,0,0,62,0,248,0,0,62,0,248,0,0,62,0,248,127,255,254,0,248,127,255,254,0,248,125,0,0,0,248,125,0,0,0,248,125,0,0,0,248,125,0,0,0,248,125,0,21,160,248,127,255,255,240,248,127,255,254,144,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,80,
  // 0xb9b0  린
  176,185,20,24,120,24,2,254,0,0,0,0,248,0,0,0,0,248,191,255,252,0,248,191,255,252,0,248,0,0,124,0,248,0,0,124,0,248,0,0,124,0,248,127,255,252,0,248,127,255,252,0,248,124,0,0,0,248,124,0,0,0,248,124,0,0,0,248,125,1,91,224,248,127,255,255,240,248,127,255,250,64,248,0,0,0,0,248,0,0,0,0,248,3,240,0,0,248,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,255,255,255,253,3,255,255,255,253,
  // 0xb9bd  립
  189,185,19,24,120,24,2,254,0,0,0,0,248,191,255,252,0,248,191,255,252,0,248,0,0,188,0,248,0,0,124,0,248,0,0,124,0,248,127,255,252,0,248,127,255,252,0,248,124,0,0,0,248,124,0,0,0,248,125,1,90,224,248,127,255,255,224,248,127,255,250,80,248,0,0,0,0,84,1,80,0,0,84,2,240,0,0,248,2,240,0,0,248,2,255,255,255,248,2,255,255,255,248,2,240,0,0,248,2,240,0,0,248,2,240,0,0,248,2,255,255,255,248,2,255,255,255,248,
  // 0xb9c1  링
  193,185,19,25,125,24,2,253,0,0,0,0,248,0,0,0,0,248,191,255,252,0,248,191,255,252,0,248,0,0,124,0,248,0,0,124,0,248,127,255,252,0,248,127,255,252,0,248,124,0,0,0,248,124,0,0,0,248,124,0,21,144,248,127,255,255,224,248,127,255,254,144,248,0,0,0,0,248,0,0,0,0,164,0,6,255,248,0,0,127,255,255,192,1,254,64,27,240,3,240,0,1,248,3,224,0,0,252,3,240,0,0,248,1,253,0,27,240,0,127,255,255,208,0,7,255,249,0,0,0,0,0,0,
  // 0xba48  멈
  72,186,19,24,120,24,2,254,0,0,0,0,248,0,0,0,0,252,191,255,252,0,252,191,255,252,0,252,188,0,124,0,252,188,0,125,0,252,188,0,127,255,252,188,0,127,255,252,188,0,124,0,252,188,0,124,0,252,191,255,252,0,252,191,255,252,0,252,0,0,0,0,252,0,0,0,0,168,0,0,0,0,0,2,255,255,255,252,2,255,255,255,252,2,240,0,0,252,2,240,0,0,252,2,240,0,0,252,2,240,0,0,252,2,240,0,0,252,2,255,255,255,252,2,255,255,255,252,
  // 0xba54  메
  84,186,20,25,125,24,2,253,0,0,0,84,61,0,0,0,248,61,0,0,0,248,61,255,255,192,248,61,255,255,192,248,61,248,7,192,248,61,248,7,192,248,61,248,7,192,248,61,248,7,192,248,61,248,7,255,248,61,248,7,255,248,61,248,7,208,248,61,248,7,192,248,61,248,7,192,248,61,248,7,192,248,61,248,7,192,248,61,255,255,192,248,61,255,255,192,248,61,0,0,0,248,61,0,0,0,248,61,0,0,0,248,61,0,0,0,248,61,0,0,0,248,61,0,0,0,0,61,0,0,0,0,20,
  // 0xba74  면
  116,186,20,24,120,24,2,254,0,0,0,0,252,0,0,0,0,252,191,255,252,0,252,191,255,252,0,252,188,0,127,255,252,188,0,127,255,252,188,0,125,0,252,188,0,124,0,252,188,0,124,0,252,188,0,127,255,252,188,0,127,255,252,188,0,125,0,252,191,255,252,0,252,191,255,252,0,252,0,0,0,0,252,0,0,0,0,252,1,240,0,0,252,2,240,0,0,168,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,244,0,0,0,2,255,255,255,253,2,255,255,255,253,
  // 0xbaa8  모
  168,186,22,20,120,24,1,0,7,255,255,255,252,0,7,255,255,255,252,0,7,208,0,0,188,0,7,208,0,0,188,0,7,208,0,0,188,0,7,208,0,0,188,0,7,208,0,0,188,0,7,208,0,0,188,0,7,208,0,0,188,0,7,255,255,255,252,0,7,255,255,255,252,0,0,0,47,64,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,
  // 0xbabb  못
  187,186,22,24,144,24,1,253,3,255,255,255,252,0,3,255,255,255,252,0,3,224,0,0,252,0,3,224,0,0,252,0,3,224,0,0,252,0,3,224,0,0,252,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,47,64,0,0,0,0,31,0,0,0,0,0,31,64,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,0,0,26,0,0,0,0,0,47,64,0,0,0,0,63,128,0,0,0,0,127,192,0,0,0,1,255,240,0,0,0,11,241,253,0,0,1,191,208,127,228,0,15,254,0,11,255,0,7,224,0,0,189,0,0,0,0,0,0,0,
  // 0xbbf8  미
  248,187,19,25,125,24,2,253,0,0,0,0,248,0,0,0,0,248,127,255,254,0,248,127,255,254,0,248,125,0,62,0,248,124,0,62,0,248,124,0,62,0,248,124,0,62,0,248,124,0,62,0,248,124,0,62,0,248,124,0,62,0,248,124,0,62,0,248,124,0,62,0,248,124,0,62,0,248,124,0,62,0,248,124,0,62,0,248,127,255,254,0,248,127,255,254,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,80,
  // 0xbc00  밀
  0,188,20,25,125,24,2,253,0,0,0,0,248,127,255,254,0,248,127,255,254,0,248,125,0,62,0,248,124,0,62,0,248,124,0,62,0,248,124,0,62,0,248,124,0,62,0,248,124,0,62,0,248,127,255,254,0,248,127,255,254,0,248,0,0,0,0,248,0,0,0,0,84,0,0,0,0,0,2,255,255,255,248,2,255,255,255,248,0,0,0,0,248,0,0,0,0,248,2,255,255,255,248,2,255,255,255,248,2,240,0,0,0,2,240,0,0,0,2,255,255,255,253,2,255,255,255,253,0,0,0,0,0,
  // 0xbc14  바
  20,188,21,25,150,24,2,253,0,0,0,3,208,0,0,0,0,3,208,0,252,0,125,3,208,0,252,0,125,3,208,0,252,0,125,3,208,0,252,0,125,3,208,0,252,0,125,3,208,0,252,0,125,3,208,0,255,255,253,3,208,0,255,255,253,3,255,192,252,0,125,3,255,192,252,0,125,3,224,0,252,0,125,3,208,0,252,0,125,3,208,0,252,0,125,3,208,0,252,0,125,3,208,0,255,255,253,3,208,0,255,255,253,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,1,64,0,
  // 0xbc84  버
  132,188,19,25,125,24,2,253,0,0,0,0,252,0,0,0,0,252,252,0,124,0,252,252,0,124,0,252,252,0,124,0,252,252,0,124,0,252,252,0,124,0,252,252,0,124,0,252,255,255,253,0,252,255,255,255,255,252,252,0,127,255,252,252,0,124,0,252,252,0,124,0,252,252,0,124,0,252,252,0,124,0,252,252,0,124,0,252,255,255,252,0,252,255,255,252,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,84,
  // 0xbca0  베
  160,188,20,25,125,24,2,253,0,0,0,164,61,0,0,0,248,61,164,2,128,248,61,248,7,192,248,61,248,7,192,248,61,248,7,192,248,61,248,7,192,248,61,248,7,192,248,61,255,255,192,248,61,255,255,255,248,61,248,7,255,248,61,248,7,208,248,61,248,7,192,248,61,248,7,192,248,61,248,7,192,248,61,248,7,192,248,61,255,255,192,248,61,255,255,192,248,61,0,0,0,248,61,0,0,0,248,61,0,0,0,248,61,0,0,0,248,61,0,0,0,248,61,0,0,0,0,61,0,0,0,0,20,
  // 0xbca8  벨
  168,188,20,25,125,24,2,253,0,0,0,164,124,184,3,208,244,124,188,3,208,244,124,188,3,208,244,124,191,255,208,244,124,191,255,255,244,124,188,3,255,244,124,188,3,224,244,124,188,3,208,244,124,188,3,208,244,124,191,255,208,244,124,191,255,208,244,124,0,0,0,244,124,0,0,0,0,0,1,255,255,255,252,1,255,255,255,252,0,0,0,0,124,0,0,0,0,124,1,255,255,255,252,1,255,255,255,252,1,240,0,0,0,1,240,0,0,0,1,255,255,255,255,1,255,255,255,255,0,0,0,0,0,
  // 0xbcf8  본
  248,188,22,23,138,24,1,254,3,224,0,0,252,0,3,224,0,0,252,0,3,224,0,0,252,0,3,255,255,255,252,0,3,255,255,255,252,0,3,224,0,0,252,0,3,224,0,0,252,0,3,224,0,0,252,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,31,0,0,0,0,0,31,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,
  // 0xbe44  비
  68,190,19,25,125,24,2,253,0,0,0,0,248,0,0,0,0,248,124,0,63,0,248,124,0,63,0,248,124,0,63,0,248,124,0,63,0,248,124,0,63,0,248,124,0,63,0,248,127,255,255,0,248,127,255,255,0,248,125,0,63,0,248,124,0,63,0,248,124,0,63,0,248,124,0,63,0,248,124,0,63,0,248,124,0,63,0,248,127,255,255,0,248,127,255,255,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,80,
  // 0xc0ac  사
  172,192,22,25,150,24,1,253,0,0,0,0,244,0,0,0,0,0,244,0,0,15,128,0,244,0,0,15,128,0,244,0,0,15,128,0,244,0,0,15,128,0,244,0,0,15,128,0,244,0,0,31,128,0,244,0,0,31,192,0,244,0,0,47,192,0,248,0,0,63,208,0,255,240,0,127,240,0,255,240,0,253,240,0,244,0,1,244,252,0,244,0,3,240,190,0,244,0,15,208,63,128,244,0,127,128,15,240,244,0,191,0,3,224,244,0,56,0,0,128,244,0,0,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,80,0,
  // 0xc0bd  삽
  189,192,22,24,144,24,1,254,0,0,0,0,248,0,0,15,64,0,248,0,0,15,128,0,248,0,0,15,128,0,248,0,0,31,128,0,248,0,0,31,192,0,248,0,0,63,208,0,255,240,0,127,240,0,255,240,0,253,248,0,248,0,3,244,254,0,248,0,31,224,63,224,248,0,191,128,11,224,248,0,61,0,1,128,248,0,0,0,0,0,84,0,0,80,0,0,84,0,1,244,0,0,248,0,1,244,0,0,248,0,1,255,255,255,248,0,1,255,255,255,248,0,1,244,0,0,248,0,1,244,0,0,248,0,1,244,0,0,248,0,1,255,255,255,248,0,1,255,255,255,248,0,
  // 0xc0c8  새
  200,192,21,25,150,24,1,253,0,0,0,40,15,64,0,0,0,124,15,64,0,41,0,124,15,64,0,62,0,124,15,64,0,62,0,124,15,64,0,62,0,124,15,64,0,62,0,124,15,64,0,62,0,124,15,64,0,62,0,124,15,64,0,127,0,125,31,64,0,191,0,127,255,64,0,255,64,127,255,64,0,255,192,124,15,64,2,247,208,124,15,64,7,227,240,124,15,64,15,193,252,124,15,64,63,64,191,124,15,64,254,0,46,124,15,64,56,0,4,124,15,64,0,0,0,124,15,64,0,0,0,124,15,64,0,0,0,124,15,64,0,0,0,124,15,64,0,0,0,0,15,64,0,0,0,0,5,0,
  // 0xc124  설
  36,193,21,24,144,24,1,254,0,5,0,0,63,0,0,15,128,0,63,0,0,15,128,0,63,0,0,15,192,0,63,0,0,31,192,191,255,0,0,47,208,191,255,0,0,63,240,0,63,0,0,190,248,0,63,0,2,248,254,0,63,0,11,240,63,208,63,0,127,192,15,240,63,0,63,0,2,208,63,0,20,0,0,0,42,0,0,0,0,0,0,0,0,191,255,255,255,0,0,191,255,255,255,0,0,0,0,0,63,0,0,0,0,0,63,0,0,127,255,255,255,0,0,127,255,255,255,0,0,124,0,0,0,0,0,125,0,0,0,0,0,127,255,255,255,128,0,127,255,255,255,128,
  // 0xc18c  소
  140,193,22,21,126,24,1,0,0,0,26,0,0,0,0,0,47,64,0,0,0,0,47,64,0,0,0,0,47,64,0,0,0,0,63,128,0,0,0,0,191,192,0,0,0,0,255,240,0,0,0,3,241,248,0,0,0,31,208,191,64,0,1,255,64,47,224,0,47,253,0,11,255,64,31,224,0,0,191,0,9,0,26,0,6,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,
  // 0xc18d  속
  141,193,22,25,150,24,1,253,0,0,26,0,0,0,0,0,47,64,0,0,0,0,47,64,0,0,0,0,63,192,0,0,0,0,255,224,0,0,0,3,246,248,0,0,0,47,224,255,64,0,11,255,64,47,253,0,15,248,5,2,255,0,10,64,31,0,25,0,0,0,31,0,0,0,0,0,31,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,7,255,255,255,252,0,7,255,255,255,252,0,0,0,0,0,252,0,0,0,0,0,188,0,0,0,0,0,188,0,0,0,0,0,188,0,0,0,0,0,188,0,0,0,0,0,188,0,0,0,0,0,20,0,
  // 0xc2a4  스
  164,194,22,21,126,24,1,0,0,0,21,0,0,0,0,0,47,64,0,0,0,0,47,64,0,0,0,0,47,64,0,0,0,0,63,128,0,0,0,0,127,192,0,0,0,0,255,224,0,0,0,3,242,244,0,0,0,15,224,254,0,0,0,127,128,63,192,0,11,254,0,15,253,0,47,244,0,2,255,64,15,64,0,0,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,
  // 0xc2ac  슬
  172,194,22,25,150,24,1,253,0,0,31,64,0,0,0,0,47,64,0,0,0,0,63,192,0,0,0,0,191,208,0,0,0,2,250,248,0,0,0,47,224,255,64,0,11,255,64,47,254,0,15,248,0,2,255,0,9,0,0,0,21,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,0,0,252,0,0,0,0,0,188,0,3,255,255,255,252,0,3,255,255,255,252,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,0,0,0,0,
  // 0xc2dc  시
  220,194,20,24,120,24,1,254,0,0,0,0,41,0,0,0,0,62,0,6,128,0,62,0,11,192,0,62,0,11,192,0,62,0,11,192,0,62,0,11,192,0,62,0,15,192,0,62,0,15,208,0,62,0,15,208,0,62,0,31,240,0,62,0,63,244,0,62,0,125,248,0,62,0,252,189,0,62,3,244,63,64,62,11,240,31,208,62,127,192,7,248,62,191,0,1,244,62,56,0,0,16,62,0,0,0,0,62,0,0,0,0,62,0,0,0,0,62,0,0,0,0,62,0,0,0,0,62,
  // 0xc2dd  식
  221,194,20,25,125,24,1,253,0,0,0,0,62,0,15,192,0,62,0,15,192,0,62,0,15,192,0,62,0,15,192,0,62,0,15,192,0,62,0,31,224,0,62,0,63,240,0,62,0,189,248,0,62,1,252,190,0,62,11,240,63,208,62,127,208,15,244,62,63,0,1,224,62,20,0,0,0,62,0,0,0,0,41,0,0,0,0,0,0,255,255,255,254,0,255,255,255,254,0,0,0,0,62,0,0,0,0,62,0,0,0,0,62,0,0,0,0,62,0,0,0,0,62,0,0,0,0,62,0,0,0,0,20,
  // 0xc5b4  어
  180,197,20,25,125,24,1,253,0,0,0,0,63,0,0,0,0,63,0,127,128,0,63,3,255,240,0,63,11,250,252,0,63,15,128,126,0,63,47,0,47,0,63,62,0,31,0,63,61,0,15,64,63,61,0,15,255,255,125,0,15,255,255,61,0,15,128,63,61,0,15,64,63,62,0,31,0,63,47,0,63,0,63,15,128,125,0,63,11,246,252,0,63,3,255,240,0,63,0,127,128,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,21,
  // 0xc5c6  없
  198,197,22,25,150,24,1,253,0,0,0,0,63,0,0,191,144,0,63,0,7,255,252,0,63,0,31,213,191,0,63,0,63,0,47,64,63,0,62,0,15,128,63,0,125,0,15,255,255,0,125,0,15,255,255,0,62,0,15,128,63,0,47,128,127,0,63,0,11,255,253,0,63,0,1,255,224,0,63,0,0,0,0,0,46,0,0,0,0,0,0,0,2,144,40,1,240,0,3,208,61,2,240,0,3,208,61,2,240,0,3,255,253,3,240,0,3,255,253,3,248,0,3,208,61,11,252,0,3,208,61,31,127,0,3,208,61,190,31,192,3,255,255,252,11,240,3,255,253,224,2,208,0,0,0,0,0,0,
  // 0xc5d1  엑
  209,197,20,25,125,24,1,253,0,0,0,21,31,0,0,0,62,31,2,255,64,62,31,15,255,224,62,31,63,66,248,62,31,61,0,188,62,31,124,0,127,254,31,124,0,127,254,31,124,0,124,62,31,62,0,248,62,31,47,66,244,62,31,15,255,224,62,31,2,255,64,62,31,0,0,0,62,31,0,0,0,25,10,0,0,0,0,0,0,191,255,255,255,0,191,255,255,255,0,0,0,0,31,0,0,0,0,31,0,0,0,0,31,0,0,0,0,31,0,0,0,0,31,0,0,0,0,31,0,0,0,0,5,
  // 0xc5d4  엔
  212,197,21,24,144,24,1,254,0,0,0,41,31,0,0,0,0,62,31,0,2,255,64,62,31,0,15,255,224,62,31,0,47,66,244,62,31,0,61,0,248,62,31,0,124,0,124,62,31,0,124,0,127,254,31,0,124,0,127,254,31,0,124,0,188,62,31,0,62,0,248,62,31,0,47,151,240,62,31,0,11,255,208,62,31,0,1,190,0,62,31,0,0,0,0,62,31,0,0,0,0,62,31,0,0,125,0,62,31,0,0,125,0,41,31,0,0,125,0,0,5,0,0,125,0,0,0,0,0,125,0,0,0,0,0,125,0,0,0,0,0,127,255,255,255,192,0,127,255,255,255,192,
  // 0xc5f4  열
  244,197,21,24,144,24,1,254,0,0,0,0,63,0,1,255,224,0,63,0,11,255,252,0,63,0,31,128,127,255,255,0,63,0,31,255,255,0,61,0,15,128,63,0,124,0,15,192,63,0,61,0,15,192,63,0,63,0,31,255,255,0,31,213,191,255,255,0,7,255,252,0,63,0,0,191,224,0,63,0,0,0,0,0,42,0,0,0,0,0,0,0,0,191,255,255,255,0,0,191,255,255,255,0,0,0,0,0,63,0,0,0,0,0,63,0,0,127,255,255,255,0,0,127,255,255,255,0,0,124,0,0,0,0,0,124,0,0,0,0,0,127,255,255,255,128,0,127,255,255,255,128,
  // 0xc608  예
  8,198,21,25,150,24,1,253,0,0,0,21,15,64,0,0,0,62,15,64,1,253,0,62,15,64,7,255,128,62,15,64,15,239,208,62,15,64,47,3,240,62,15,64,62,1,255,254,15,64,61,0,255,254,15,64,60,0,244,62,15,64,124,0,248,62,15,64,124,0,248,62,15,64,124,0,248,62,15,64,124,0,244,62,15,64,61,0,255,254,15,64,62,1,255,254,15,64,47,3,240,62,15,64,15,239,208,62,15,64,7,255,128,62,15,64,1,253,0,62,15,64,0,0,0,62,15,64,0,0,0,62,15,64,0,0,0,62,15,64,0,0,0,62,15,64,0,0,0,0,15,64,0,0,0,0,5,0,
  // 0xc624  오
  36,198,22,20,120,24,1,0,0,2,255,248,0,0,0,63,255,255,128,0,1,254,64,31,240,0,3,240,0,1,252,0,7,208,0,0,189,0,11,192,0,0,61,0,11,192,0,0,62,0,7,208,0,0,189,0,3,240,0,1,252,0,0,254,64,31,240,0,0,127,255,255,128,0,0,6,255,249,0,0,0,0,31,64,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,
  // 0xc628  온
  40,198,22,23,138,24,1,254,0,7,255,253,0,0,0,191,255,255,224,0,3,253,0,11,248,0,7,224,0,0,252,0,7,208,0,0,188,0,3,224,0,0,252,0,2,253,0,7,248,0,0,191,255,255,224,0,0,11,255,249,0,0,0,0,31,64,0,0,0,0,31,0,0,0,0,0,47,64,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,
  // 0xc644  완
  68,198,22,24,144,24,1,254,0,0,0,0,248,0,0,111,224,0,248,0,3,255,254,0,248,0,11,224,47,64,248,0,15,64,11,192,248,0,31,0,7,192,248,0,31,0,7,192,248,0,15,128,15,192,248,0,11,245,127,64,255,240,2,255,253,0,255,240,0,31,208,0,252,0,0,15,128,0,248,0,0,15,213,168,248,0,191,255,255,252,248,0,127,255,254,144,248,0,0,0,0,0,248,0,0,0,0,0,248,0,1,240,0,0,248,0,1,240,0,0,168,0,1,240,0,0,0,0,1,240,0,0,0,0,1,244,0,0,0,0,1,255,255,255,253,0,1,255,255,255,253,0,
  // 0xc6d0  원
  208,198,21,24,144,24,1,254,0,0,0,0,63,0,0,111,248,0,63,0,2,255,255,64,63,0,11,224,31,192,63,0,15,128,3,208,63,0,15,128,3,208,63,0,11,224,31,192,63,0,2,255,255,64,63,0,0,111,248,0,63,0,0,0,0,0,63,0,0,0,86,173,63,0,191,255,255,253,63,0,191,255,255,164,63,0,0,7,208,0,63,0,0,7,208,127,255,0,0,7,208,191,255,0,0,7,208,0,63,0,2,247,208,0,63,0,2,240,0,0,21,0,2,240,0,0,0,0,2,240,0,0,0,0,2,240,0,0,0,0,2,255,255,255,255,64,2,255,255,255,255,64,
  // 0xc704  위
  4,199,20,25,125,24,1,253,0,0,0,0,62,0,47,248,0,62,1,255,255,64,62,7,245,111,192,62,15,192,3,224,62,15,128,2,240,62,15,128,2,240,62,15,192,3,224,62,7,244,31,208,62,2,255,255,128,62,0,127,253,0,62,0,0,0,0,62,0,0,21,173,62,191,255,255,254,62,127,255,254,148,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,2,144,0,62,0,0,0,0,21,
  // 0xc73c  으
  60,199,22,21,126,24,1,0,0,1,191,228,0,0,0,31,255,255,64,0,0,255,149,111,224,0,2,248,0,3,248,0,3,240,0,0,252,0,11,192,0,0,125,0,11,192,0,0,62,0,11,192,0,0,62,0,11,192,0,0,125,0,3,224,0,0,252,0,2,248,0,3,248,0,0,255,149,111,224,0,0,47,255,255,64,0,0,1,191,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,
  // 0xc74c  음
  76,199,22,23,138,24,1,254,0,6,255,249,0,0,0,191,255,255,224,0,3,253,0,7,248,0,7,224,0,0,252,0,7,208,0,0,189,0,7,240,0,0,252,0,2,254,64,27,248,0,0,191,255,255,208,0,0,6,255,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,3,208,0,0,188,0,3,208,0,0,188,0,3,208,0,0,188,0,3,224,0,0,188,0,3,255,255,255,252,0,3,255,255,255,252,0,
  // 0xc774  이
  116,199,19,25,125,24,2,253,0,0,0,0,248,0,0,0,0,248,1,191,64,0,248,7,255,224,0,248,31,235,248,0,248,63,0,252,0,248,61,0,62,0,248,188,0,63,0,248,188,0,47,0,248,252,0,31,0,248,248,0,31,0,248,252,0,31,0,248,188,0,47,0,248,188,0,63,0,248,61,0,62,0,248,63,0,252,0,248,31,235,248,0,248,7,255,224,0,248,1,191,64,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,84,
  // 0xc77c  일
  124,199,20,24,120,24,2,254,0,0,0,0,248,7,255,128,0,248,47,255,244,0,248,127,65,252,0,248,252,0,62,0,248,248,0,47,0,248,244,0,47,0,248,248,0,47,0,248,252,0,126,0,248,63,70,252,0,248,31,255,244,0,248,2,254,128,0,248,0,0,0,0,164,0,0,0,0,0,2,255,255,255,248,2,255,255,255,248,0,0,0,0,248,0,0,0,0,248,2,255,255,255,248,2,255,255,255,248,2,240,0,0,0,2,240,0,0,0,2,255,255,255,253,2,255,255,255,253,
  // 0xc77d  읽
  125,199,19,25,125,24,2,253,0,0,0,0,248,2,254,64,0,248,31,255,244,0,248,63,86,252,0,248,252,0,126,0,248,248,0,47,0,248,244,0,47,0,248,248,0,47,0,248,252,0,62,0,248,63,70,252,0,248,31,255,244,0,248,2,254,128,0,248,0,0,0,0,164,0,0,0,0,0,15,255,243,255,248,15,255,243,255,248,0,2,240,0,248,0,2,240,0,248,15,255,240,0,248,15,255,240,0,248,15,128,0,0,248,15,192,21,0,248,15,255,254,0,248,15,255,249,0,248,0,0,0,0,0,
  // 0xc785  입
  133,199,19,24,120,24,2,254,0,0,0,0,248,2,255,128,0,248,31,255,244,0,248,63,150,252,0,248,252,0,63,0,248,248,0,47,0,248,244,0,31,0,248,248,0,47,0,248,252,0,63,0,248,127,65,253,0,248,47,255,248,0,248,3,255,192,0,248,0,0,0,0,248,0,0,0,0,0,2,240,0,0,248,2,240,0,0,248,2,240,0,0,248,2,255,255,255,248,2,255,255,255,248,2,240,0,0,248,2,240,0,0,248,2,240,0,0,248,2,255,255,255,248,2,255,255,255,248,
  // 0xc790  자
  144,199,22,25,150,24,1,253,0,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,244,0,127,255,255,208,244,0,127,255,255,208,244,0,0,15,128,0,244,0,0,15,128,0,244,0,0,15,128,0,244,0,0,31,128,0,244,0,0,31,192,0,248,0,0,47,192,0,255,240,0,63,224,0,255,240,0,126,240,0,244,0,0,248,248,0,244,0,2,244,189,0,244,0,7,224,63,64,244,0,47,192,31,224,244,0,255,0,7,240,244,0,125,0,0,208,244,0,32,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,80,0,
  // 0xc791  작
  145,199,22,25,150,24,1,253,0,0,0,0,248,0,0,0,0,0,248,0,63,255,255,208,248,0,63,255,255,208,248,0,0,15,128,0,248,0,0,31,192,0,248,0,0,47,192,0,255,240,0,63,208,0,255,240,0,191,240,0,248,0,1,248,252,0,248,0,7,240,127,64,248,0,127,208,47,240,248,0,191,64,7,208,248,0,56,0,0,64,248,0,0,0,0,0,164,0,0,0,0,0,0,0,3,255,255,255,248,0,3,255,255,255,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,80,0,
  // 0xc798  잘
  152,199,22,25,150,24,1,253,0,0,0,0,248,0,63,255,255,208,248,0,63,255,255,208,248,0,0,31,128,0,248,0,0,31,128,0,248,0,0,47,192,0,255,240,0,63,208,0,255,240,0,191,240,0,248,0,1,248,253,0,248,0,11,240,127,128,248,0,127,208,31,240,248,0,191,64,7,208,248,0,56,0,0,64,248,0,0,0,0,0,0,0,2,255,255,255,248,0,2,255,255,255,248,0,0,0,0,0,248,0,0,0,0,0,248,0,1,255,255,255,248,0,1,255,255,255,248,0,1,240,0,0,0,0,1,240,0,0,0,0,1,255,255,255,253,0,1,255,255,255,253,0,0,0,0,0,0,0,
  // 0xc7a5  장
  165,199,22,25,150,24,1,253,0,0,0,0,248,0,0,0,0,0,248,0,63,255,255,208,248,0,63,255,255,208,248,0,0,15,128,0,248,0,0,31,128,0,248,0,0,31,192,0,255,240,0,63,208,0,255,240,0,127,240,0,248,0,0,253,252,0,248,0,3,244,191,64,248,0,47,224,47,240,248,0,191,128,7,208,248,0,61,0,0,64,248,0,0,0,0,0,84,0,0,2,255,249,0,0,0,63,255,255,192,0,0,254,64,27,240,0,2,244,0,0,248,0,2,240,0,0,252,0,2,244,0,0,252,0,0,254,64,11,244,0,0,63,255,255,208,0,0,6,255,249,0,0,0,0,0,0,0,0,
  // 0xc7ac  재
  172,199,21,25,150,24,1,253,0,0,0,40,15,64,0,0,0,61,15,64,0,0,0,61,15,64,127,255,253,61,15,64,127,255,253,61,15,64,0,61,0,61,15,64,0,61,0,61,15,64,0,62,0,61,15,64,0,126,0,61,15,64,0,127,0,61,31,64,0,191,0,63,255,64,0,255,64,63,255,64,0,255,128,61,15,64,2,247,208,61,15,64,3,227,240,61,15,64,15,193,252,61,15,64,63,128,191,125,15,64,255,0,62,61,15,64,60,0,4,61,15,64,16,0,0,61,15,64,0,0,0,61,15,64,0,0,0,61,15,64,0,0,0,61,15,64,0,0,0,0,15,64,0,0,0,0,5,0,
  // 0xc800  저
  0,200,20,25,125,24,1,253,0,0,0,0,62,0,0,0,0,63,0,0,0,0,63,63,255,255,240,63,63,255,255,240,63,0,15,128,0,63,0,15,192,0,63,0,15,192,0,63,0,15,192,0,63,0,31,192,191,255,0,47,208,191,255,0,63,240,0,63,0,125,244,0,63,0,252,252,0,63,2,244,126,0,63,7,240,63,128,63,47,192,15,240,63,191,64,3,244,63,61,0,0,224,63,16,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,21,
  // 0xc804  전
  4,200,21,24,144,24,1,254,0,0,0,0,63,0,0,0,0,0,63,0,63,255,255,224,63,0,63,255,255,224,63,0,0,15,192,0,63,0,0,15,192,0,63,0,0,15,192,0,63,0,0,31,208,63,255,0,0,63,224,63,255,0,0,127,244,0,63,0,0,252,253,0,63,0,7,244,127,128,63,0,47,208,31,240,63,0,127,64,3,224,63,0,40,0,0,64,63,0,0,0,0,0,63,0,0,40,0,0,63,0,0,124,0,0,63,0,0,124,0,0,0,0,0,124,0,0,0,0,0,124,0,0,0,0,0,125,0,0,0,0,0,127,255,255,255,64,0,127,255,255,255,64,
  // 0xc815  정
  21,200,20,25,125,24,1,253,0,0,0,0,62,0,0,0,0,63,63,255,255,224,63,63,255,255,224,63,0,15,192,0,63,0,15,192,0,63,0,31,192,63,255,0,63,224,63,255,0,127,244,0,63,0,252,253,0,63,3,244,63,128,63,47,224,31,240,63,127,128,3,224,63,45,0,0,64,63,0,0,0,0,21,0,1,191,254,0,0,15,255,255,240,0,127,144,6,252,0,252,0,0,126,0,252,0,0,63,0,252,0,0,62,0,127,128,6,253,0,31,255,255,244,0,1,191,254,64,0,0,0,0,0,
  // 0xc81c  제
  28,200,21,25,150,24,1,253,0,0,0,21,15,64,0,0,0,62,15,64,0,0,0,62,15,64,127,255,253,62,15,64,127,255,253,62,15,64,0,61,0,62,15,64,0,61,0,62,15,64,0,61,0,62,15,64,0,126,0,62,15,64,0,126,31,254,15,64,0,191,31,254,15,64,0,255,0,62,15,64,0,255,128,62,15,64,2,247,192,62,15,64,3,227,224,62,15,64,15,194,244,62,15,64,47,128,254,62,15,64,191,0,63,62,15,64,124,0,12,62,15,64,16,0,0,62,15,64,0,0,0,62,15,64,0,0,0,62,15,64,0,0,0,62,15,64,0,0,0,0,15,64,0,0,0,0,5,0,
  // 0xc8fd  죽
  253,200,22,24,144,24,1,253,11,255,255,255,254,0,11,255,255,255,254,0,0,0,127,192,0,0,0,0,191,208,0,0,0,2,251,244,0,0,0,31,240,255,64,0,10,255,128,63,250,0,31,249,0,7,255,0,10,64,0,0,26,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,47,64,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,64,0,0,7,255,255,255,252,0,7,255,255,255,252,0,0,0,0,0,188,0,0,0,0,0,188,0,0,0,0,0,188,0,0,0,0,0,188,0,0,0,0,0,188,0,0,0,0,0,84,0,
  // 0xc900  준
  0,201,22,23,138,24,1,254,11,255,255,255,254,0,11,255,255,255,254,0,0,0,63,192,0,0,0,0,127,192,0,0,0,0,255,240,0,0,0,7,241,253,0,0,0,127,208,191,208,0,31,255,0,31,255,0,15,244,0,1,255,0,5,0,0,0,5,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,31,128,0,0,0,0,15,64,0,0,0,0,15,64,0,0,3,224,15,64,0,0,3,224,15,64,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,
  // 0xc911  중
  17,201,22,24,144,24,1,253,11,255,255,255,254,0,11,255,255,255,254,0,0,0,127,192,0,0,0,0,191,208,0,0,0,2,251,244,0,0,0,31,240,255,64,0,11,255,128,63,254,0,15,249,0,7,255,0,10,64,0,0,26,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,47,64,0,0,0,0,31,0,0,0,0,0,31,64,0,0,0,10,255,249,0,0,0,191,255,255,208,0,2,253,0,7,244,0,3,224,0,0,252,0,3,224,0,0,252,0,3,253,0,7,248,0,0,191,255,255,224,0,0,7,255,249,0,0,0,0,0,0,0,0,
  // 0xc990  즐
  144,201,22,24,144,24,1,253,11,255,255,255,254,0,11,255,255,255,254,0,0,0,63,192,0,0,0,0,191,224,0,0,0,7,250,252,0,0,1,191,224,191,228,0,31,254,0,31,255,64,15,144,0,0,111,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,0,0,252,0,0,0,0,0,188,0,3,255,255,255,252,0,3,255,255,255,252,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,0,0,0,0,
  // 0xc9c0  지
  192,201,20,25,125,24,1,253,0,0,0,0,62,0,0,0,0,62,0,0,0,0,62,63,255,255,240,62,63,255,255,240,62,0,11,192,0,62,0,11,192,0,62,0,15,192,0,62,0,15,192,0,62,0,15,208,0,62,0,15,224,0,62,0,47,240,0,62,0,62,244,0,62,0,188,252,0,62,1,248,127,0,62,3,240,47,128,62,31,208,15,244,62,127,128,3,248,62,62,0,0,176,62,20,0,0,0,62,0,0,0,0,62,0,0,0,0,62,0,0,0,0,62,0,0,0,0,62,0,0,0,0,20,
  // 0xcc98  처
  152,204,20,25,125,24,1,253,0,10,64,0,63,0,15,128,0,63,0,15,128,0,63,0,15,128,0,63,63,255,255,224,63,63,255,255,224,63,0,15,192,0,63,0,15,128,0,63,0,15,192,0,63,0,15,192,0,63,0,31,192,191,255,0,47,208,191,255,0,63,240,0,63,0,125,244,0,63,0,248,252,0,63,3,240,63,0,63,15,224,31,208,63,127,128,11,244,63,62,0,1,224,63,20,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,21,
  // 0xcd08  초
  8,205,22,21,126,24,1,0,0,0,31,64,0,0,0,0,31,64,0,0,0,0,47,64,0,0,15,255,255,255,254,0,15,255,255,255,254,0,0,0,47,64,0,0,0,0,63,128,0,0,0,0,127,192,0,0,0,0,255,240,0,0,0,7,245,253,0,0,0,127,208,191,128,0,27,255,0,31,254,64,31,244,0,1,255,0,9,0,31,64,26,0,0,0,31,64,0,0,0,0,31,64,0,0,0,0,31,64,0,0,0,0,31,64,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,
  // 0xcd95  축
  149,205,22,25,150,24,1,253,0,0,31,0,0,0,0,0,31,0,0,0,11,255,255,255,253,0,11,255,255,255,253,0,0,0,63,128,0,0,0,0,63,192,0,0,0,0,255,240,0,0,0,7,246,253,0,0,1,191,208,191,228,0,31,254,0,31,255,0,15,144,0,0,111,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,47,64,0,0,0,0,31,0,0,0,0,0,31,64,0,0,7,255,255,255,252,0,7,255,255,255,252,0,0,0,0,0,188,0,0,0,0,0,188,0,0,0,0,0,188,0,0,0,0,0,188,0,0,0,0,0,188,0,0,0,0,0,20,0,
  // 0xcd9c  출
  156,205,22,25,150,24,1,253,0,0,31,0,0,0,0,0,31,0,0,0,11,255,255,255,253,0,11,255,255,255,253,0,0,0,63,192,0,0,0,0,191,208,0,0,0,2,251,248,0,0,1,127,224,255,212,0,31,255,64,31,255,64,15,144,0,0,175,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,31,0,0,0,0,0,31,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,0,0,188,0,3,255,255,255,252,0,3,255,255,255,252,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,0,0,0,0,
  // 0xcda4  춤
  164,205,22,24,144,24,1,254,0,0,31,0,0,0,0,0,31,0,0,0,11,255,255,255,253,0,11,255,255,255,253,0,0,0,63,128,0,0,0,0,63,192,0,0,0,0,255,240,0,0,0,7,246,253,0,0,1,191,224,191,228,0,31,254,0,31,255,0,15,144,0,0,111,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,64,0,0,3,255,255,255,252,0,3,255,255,255,252,0,3,208,0,0,188,0,3,208,0,0,188,0,3,224,0,0,188,0,3,255,255,255,252,0,3,255,255,255,252,0,
  // 0xcde8  취
  232,205,20,25,125,24,1,253,0,3,208,0,62,0,7,208,0,62,0,7,208,0,62,15,255,255,244,62,15,255,255,244,62,0,7,224,0,62,0,11,240,0,62,0,15,244,0,62,0,63,254,0,62,2,253,63,224,62,31,244,11,244,62,15,128,0,176,62,0,0,0,0,62,0,21,90,190,62,191,255,255,254,62,127,255,250,80,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,7,208,0,62,0,2,144,0,62,0,0,0,0,21,
  // 0xce58  치
  88,206,19,25,125,24,2,253,0,26,0,0,248,0,31,0,0,248,0,31,0,0,248,0,31,0,0,248,191,255,255,208,248,191,255,255,208,248,0,47,64,0,248,0,47,0,0,248,0,47,64,0,248,0,63,64,0,248,0,63,128,0,248,0,127,192,0,248,0,191,208,0,248,0,246,240,0,248,3,240,252,0,248,11,208,190,0,248,63,192,63,208,248,255,0,15,240,248,188,0,2,192,248,16,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,80,
  // 0xce68  침
  104,206,19,24,120,24,2,254,0,47,0,0,248,0,47,0,0,248,0,47,0,0,248,191,255,255,192,248,191,255,255,192,248,0,47,0,0,248,0,63,64,0,248,0,63,128,0,248,0,191,208,0,248,1,251,240,0,248,7,241,253,0,248,47,208,127,208,248,255,64,31,208,248,184,0,2,192,248,0,0,0,0,164,0,0,0,0,0,2,255,255,255,248,2,255,255,255,248,2,240,0,0,248,2,240,0,0,248,2,240,0,0,248,2,240,0,0,248,2,255,255,255,248,2,255,255,255,248,
  // 0xce74  카
  116,206,22,25,150,24,1,253,0,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,244,0,15,255,255,64,244,0,15,255,255,64,244,0,0,0,31,64,244,0,0,0,31,0,244,0,0,0,47,0,244,0,0,0,127,0,244,0,127,255,254,0,248,0,127,255,253,0,255,240,37,0,252,0,255,240,0,2,244,0,244,0,0,7,240,0,244,0,0,31,192,0,244,0,0,127,64,0,244,0,2,253,0,0,244,0,31,244,0,0,244,0,127,192,0,0,244,0,62,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,80,0,
  // 0xcf1c  켜
  28,207,20,25,125,24,1,253,0,0,0,0,62,0,0,0,0,63,0,0,0,0,63,31,255,255,0,63,31,255,255,0,63,0,0,47,0,63,0,0,47,0,63,0,0,63,255,255,0,1,127,255,255,127,255,253,0,63,127,255,252,0,63,16,1,244,0,63,0,3,240,0,63,0,15,211,255,255,0,47,131,255,255,0,191,0,0,63,3,252,0,0,63,47,240,0,0,63,191,128,0,0,63,61,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,20,
  // 0xd0d1  탑
  209,208,21,24,144,24,2,254,0,0,0,3,224,0,191,255,252,3,224,0,191,255,252,3,224,0,188,0,0,3,224,0,188,0,0,3,224,0,188,0,0,3,224,0,191,255,248,3,255,192,191,255,248,3,255,192,188,0,0,3,224,0,188,0,0,3,224,0,188,1,91,131,224,0,191,255,255,131,224,0,191,255,233,67,224,0,0,0,0,2,144,0,1,64,0,1,64,0,7,208,0,3,224,0,7,208,0,3,224,0,7,255,255,255,224,0,7,255,255,255,224,0,7,208,0,3,224,0,7,208,0,3,224,0,7,208,0,3,224,0,7,255,255,255,224,0,7,255,255,255,224,0,
  // 0xd130  터
  48,209,19,25,125,24,2,253,0,0,0,0,252,0,0,0,0,252,191,255,252,0,252,191,255,252,0,252,188,0,0,0,252,188,0,0,0,252,188,0,0,0,252,188,0,0,0,252,188,0,0,0,252,191,255,245,255,252,191,255,245,255,252,188,0,0,0,252,188,0,0,0,252,188,0,0,0,252,188,0,0,0,252,188,0,0,0,252,188,5,107,128,252,191,255,255,128,252,191,255,233,64,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,84,
  // 0xd14c  테
  76,209,20,25,125,24,2,253,0,0,0,84,61,0,0,0,248,61,0,0,0,248,61,255,255,192,248,61,255,255,192,248,61,248,0,0,248,61,248,0,0,248,61,248,0,0,248,61,248,0,0,248,61,255,255,63,248,61,255,255,63,248,61,248,0,0,248,61,248,0,0,248,61,248,0,0,248,61,248,0,0,248,61,248,0,0,248,61,248,21,160,248,61,255,255,240,248,61,255,255,160,248,61,0,0,0,248,61,0,0,0,248,61,0,0,0,248,61,0,0,0,248,61,0,0,0,80,61,0,0,0,0,20,
  // 0xd1a0  토
  160,209,22,20,120,24,1,0,3,255,255,255,252,0,3,255,255,255,252,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,244,0,3,255,255,255,244,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,47,64,0,0,0,0,31,64,0,0,0,0,31,64,0,0,0,0,31,64,0,0,0,0,31,64,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,
  // 0xd2b8  트
  184,210,22,20,120,24,1,0,3,255,255,255,252,0,3,255,255,255,252,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,248,0,3,255,255,255,248,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,
  // 0xd39c  펜
  156,211,21,24,144,24,1,254,0,0,0,26,31,64,0,0,0,47,31,64,127,255,253,47,31,64,127,255,253,47,31,64,11,195,224,47,31,64,11,131,224,47,31,64,11,131,224,47,31,64,11,131,231,255,31,64,11,131,231,255,31,64,11,131,224,47,31,64,11,131,224,47,31,64,11,131,229,47,31,64,255,255,255,47,31,64,191,255,234,47,31,64,0,0,0,47,31,64,0,0,0,47,31,64,0,61,0,47,31,64,0,62,0,26,31,64,0,62,0,0,0,0,0,62,0,0,0,0,0,62,0,0,0,0,0,62,0,0,0,0,0,63,255,255,255,192,0,63,255,255,255,192,
  // 0xd504  프
  4,213,22,20,120,24,1,0,15,255,255,255,254,0,15,255,255,255,254,0,0,47,64,31,64,0,0,31,0,31,0,0,0,31,0,31,0,0,0,31,0,31,0,0,0,31,0,31,0,0,0,31,0,31,0,0,0,31,0,31,0,0,0,31,0,31,0,0,0,47,64,31,64,0,15,255,255,255,254,0,15,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,
  // 0xd558  하
  88,213,22,25,150,24,1,253,0,5,0,0,248,0,0,15,64,0,248,0,0,15,64,0,248,0,0,31,128,0,248,0,255,255,255,240,248,0,255,255,255,240,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,191,224,0,248,0,3,255,253,0,248,0,15,208,127,0,255,240,31,64,15,128,255,240,47,0,11,192,248,0,47,0,11,192,248,0,31,0,15,192,248,0,31,128,31,128,248,0,11,229,191,0,248,0,3,255,253,0,248,0,0,111,224,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,80,0,
  // 0xd569  합
  105,213,22,25,150,24,1,254,0,5,0,0,0,0,0,15,128,0,248,0,0,15,128,0,248,0,191,255,255,240,248,0,191,255,255,240,248,0,0,0,0,0,248,0,0,127,224,0,248,0,3,255,254,0,255,240,15,208,47,64,255,240,15,64,15,128,248,0,31,0,11,192,248,0,15,64,15,128,248,0,15,208,47,64,248,0,3,255,254,0,248,0,0,127,228,0,248,0,0,0,0,0,0,0,0,80,0,0,84,0,1,244,0,0,248,0,1,244,0,0,248,0,1,255,255,255,248,0,1,255,255,255,248,0,1,244,0,0,248,0,1,244,0,0,248,0,1,255,255,255,248,0,1,255,255,255,248,0,
  // 0xd648  홈
  72,214,22,26,156,24,1,253,0,0,5,0,0,0,0,0,31,64,0,0,0,0,31,64,0,0,47,255,255,255,255,64,47,255,255,255,255,64,0,0,0,0,0,0,0,6,255,249,0,0,0,191,255,255,224,0,2,248,0,7,244,0,2,240,0,1,248,0,1,253,0,7,244,0,0,191,255,255,208,0,0,6,191,233,0,0,0,0,31,64,0,0,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,252,0,3,255,255,255,252,0,3,224,0,0,188,0,3,208,0,0,188,0,3,208,0,0,188,0,3,255,255,255,252,0,3,255,255,255,252,0,0,0,0,0,0,0,
  // 0xd654  화
  84,214,22,25,150,24,1,253,0,11,128,0,248,0,0,15,192,0,248,0,0,15,192,0,248,0,191,255,255,244,248,0,191,255,255,244,248,0,0,0,0,0,248,0,0,111,228,0,248,0,3,255,254,0,248,0,11,224,47,64,248,0,15,128,15,192,248,0,15,64,7,192,255,240,15,128,11,192,255,240,11,208,47,128,248,0,3,255,255,0,248,0,0,127,244,0,248,0,0,15,192,0,248,0,0,15,192,0,248,0,0,95,218,248,248,0,255,255,255,252,248,0,191,255,234,80,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,80,0,
  // 0xd788  히
  136,215,19,25,125,24,2,253,0,21,0,0,248,0,47,0,0,248,0,47,0,0,248,0,47,64,0,248,255,255,255,240,248,255,255,255,240,248,0,0,0,0,248,0,0,0,0,248,0,191,224,0,248,7,255,252,0,248,15,208,127,0,248,47,0,31,64,248,62,0,15,128,248,62,0,15,128,248,62,0,15,128,248,47,0,47,64,248,15,229,190,0,248,7,255,252,0,248,0,191,144,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,80,
};

#endif // HAS_GRAPHICAL_TFT
