/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Katakana 26pt, capital 'A' height: 19px, width: 100%, range: 0x30a0-0x8868, glyphs: 103
extern const uint8_t NotoSans_Medium_Katakana_19[13182] = {
  162,19,160,48,104,136,25,249, // unifont_t
  // 0x30a0  ゠
  160,48,12,6,18,26,7,7,191,255,254,0,0,0,0,0,0,0,0,0,0,0,0,191,255,254,
  // 0x30a1  ァ
  161,48,19,18,90,26,4,253,101,85,85,85,80,191,255,255,255,244,191,255,255,255,244,0,0,0,7,224,0,1,80,15,192,0,3,240,63,0,0,2,240,253,0,0,3,243,248,0,0,3,224,144,0,0,3,224,0,0,0,7,208,0,0,0,11,192,0,0,0,31,128,0,0,0,63,0,0,0,1,254,0,0,0,11,248,0,0,0,11,208,0,0,0,1,0,0,0,0,
  // 0x30a2  ア
  162,48,21,22,132,26,3,254,169,85,85,85,90,0,255,255,255,255,255,192,255,255,255,255,255,192,0,0,0,0,63,64,0,0,0,0,190,0,0,0,168,1,252,0,0,0,252,7,240,0,0,0,252,31,208,0,0,0,252,191,64,0,0,0,252,61,0,0,0,0,252,0,0,0,0,0,248,0,0,0,0,1,248,0,0,0,0,2,244,0,0,0,0,3,240,0,0,0,0,11,224,0,0,0,0,31,192,0,0,0,0,127,64,0,0,0,2,254,0,0,0,0,31,248,0,0,0,0,7,208,0,0,0,0,0,0,0,0,0,0,
  // 0x30a3  ィ
  163,48,18,18,90,26,3,254,0,0,0,3,128,0,0,0,15,208,0,0,0,127,128,0,0,2,254,0,0,0,15,244,0,0,0,191,192,0,0,7,255,0,0,0,191,255,0,0,111,254,127,0,0,191,224,63,0,0,61,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,
  // 0x30a4  イ
  164,48,21,22,132,26,2,255,0,0,0,0,4,0,0,0,0,0,46,0,0,0,0,0,127,64,0,0,0,2,254,0,0,0,0,15,244,0,0,0,0,127,208,0,0,0,2,255,0,0,0,0,31,248,0,0,0,1,255,224,0,0,0,47,255,224,0,0,7,255,227,224,0,0,191,253,3,224,0,0,127,144,3,224,0,0,52,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,240,0,0,0,0,7,240,0,0,
  // 0x30a5  ゥ
  165,48,18,20,100,26,4,253,0,1,160,0,0,0,1,240,0,0,0,1,240,0,0,21,86,245,85,64,127,255,255,255,224,127,255,255,255,224,60,0,0,7,208,60,0,0,11,208,60,0,0,15,192,124,0,0,15,128,125,0,0,47,64,0,0,0,63,0,0,0,0,190,0,0,0,2,252,0,0,0,11,244,0,0,0,127,208,0,0,11,255,64,0,0,127,248,0,0,0,31,144,0,0,0,4,0,0,0,
  // 0x30a6  ウ
  166,48,20,24,120,26,3,254,0,0,104,0,0,0,0,189,0,0,0,0,188,0,0,0,0,188,0,0,0,0,188,0,0,191,255,255,255,254,191,255,255,255,255,189,85,85,85,191,188,0,0,0,126,188,0,0,0,189,188,0,0,0,252,188,0,0,0,252,188,0,0,2,248,104,0,0,3,240,0,0,0,7,224,0,0,0,15,208,0,0,0,63,128,0,0,0,255,0,0,0,7,252,0,0,0,111,240,0,0,27,255,192,0,0,63,253,0,0,0,15,224,0,0,0,1,0,0,0,
  // 0x30a7  ェ
  167,48,18,15,75,26,4,255,63,255,255,255,192,63,255,255,255,192,21,86,249,85,64,0,1,244,0,0,0,1,244,0,0,0,1,244,0,0,0,1,244,0,0,0,1,244,0,0,0,1,244,0,0,0,1,244,0,0,0,1,244,0,0,0,1,244,0,0,255,255,255,255,240,255,255,255,255,240,165,85,85,85,160,
  // 0x30a8  エ
  168,48,22,18,108,26,2,0,31,255,255,255,255,128,31,255,255,255,255,128,10,170,191,170,170,64,0,0,47,64,0,0,0,0,47,64,0,0,0,0,47,64,0,0,0,0,47,64,0,0,0,0,47,64,0,0,0,0,47,64,0,0,0,0,47,64,0,0,0,0,47,64,0,0,0,0,47,64,0,0,0,0,47,64,0,0,0,0,47,64,0,0,234,170,191,234,170,160,255,255,255,255,255,240,255,255,255,255,255,240,0,0,0,0,0,0,
  // 0x30a9  ォ
  169,48,19,19,95,26,4,254,0,0,1,64,0,0,0,7,192,0,0,0,7,192,0,0,0,7,192,0,21,85,91,213,80,63,255,255,255,244,63,255,255,255,244,0,0,63,192,0,0,0,191,192,0,0,2,255,192,0,0,11,243,192,0,0,47,195,192,0,0,255,3,208,0,11,248,3,208,0,127,224,3,208,0,63,64,3,208,0,24,1,87,208,0,0,3,255,192,0,0,2,255,128,0,
  // 0x30aa  オ
  170,48,22,22,132,26,2,255,0,0,0,125,0,0,0,0,0,125,0,0,0,0,0,125,0,0,0,0,0,125,0,0,0,0,0,125,0,0,63,255,255,255,255,208,63,255,255,255,255,208,42,85,87,254,86,128,0,0,3,253,0,0,0,0,15,253,0,0,0,0,63,189,0,0,0,0,254,61,0,0,0,3,248,61,0,0,0,31,224,61,0,0,0,191,128,61,0,0,7,253,0,62,0,0,47,240,0,62,0,0,191,128,0,62,0,0,61,0,0,62,0,0,0,0,106,254,0,0,0,0,127,253,0,0,0,0,127,248,0,0,
  // 0x30ab  カ
  171,48,20,23,115,26,3,254,0,2,244,0,0,0,1,244,0,0,0,1,244,0,0,0,1,244,0,0,0,1,240,0,0,255,255,255,255,248,255,255,255,255,253,101,87,245,85,188,0,3,240,0,124,0,3,224,0,124,0,7,208,0,188,0,11,192,0,188,0,15,192,0,188,0,31,64,0,188,0,63,0,0,248,0,190,0,0,248,1,252,0,0,244,3,244,0,1,244,31,224,0,3,240,191,192,15,255,240,254,0,11,255,192,40,0,5,169,0,0,0,0,0,0,
  // 0x30ac  ガ
  172,48,23,24,144,26,2,254,0,0,0,0,2,192,0,0,252,0,177,240,0,0,252,0,120,180,0,0,252,0,61,52,0,0,252,0,30,0,0,0,248,0,0,0,127,255,255,255,253,0,127,255,255,255,255,0,41,86,249,85,126,0,0,1,240,0,62,0,0,2,240,0,62,0,0,3,240,0,62,0,0,3,224,0,62,0,0,7,208,0,61,0,0,15,192,0,61,0,0,31,128,0,124,0,0,63,0,0,124,0,0,190,0,0,188,0,1,252,0,0,252,0,7,244,0,0,248,0,47,224,7,171,244,0,191,128,3,255,240,0,45,0,3,255,128,0,0,0,0,0,0,0,
  // 0x30ad  キ
  173,48,21,23,138,26,3,254,0,6,208,0,0,0,0,7,208,0,0,0,0,3,224,0,0,0,0,3,240,1,160,0,0,2,250,255,240,0,5,191,255,255,240,0,255,255,255,164,0,0,255,249,248,0,0,0,148,0,252,0,0,0,0,0,188,0,0,0,0,0,188,0,27,0,0,0,126,111,255,0,0,22,255,255,255,64,175,255,255,254,80,0,255,255,255,0,0,0,254,80,47,0,0,0,0,0,31,64,0,0,0,0,15,128,0,0,0,0,15,192,0,0,0,0,15,192,0,0,0,0,11,208,0,0,0,0,11,208,0,0,0,0,0,0,0,0,
  // 0x30ae  ギ
  174,48,23,24,144,26,2,254,0,0,0,0,2,192,0,0,0,0,177,224,0,3,240,0,184,240,0,3,240,0,60,116,0,2,240,0,29,0,0,1,244,5,180,0,0,1,255,255,248,0,22,191,255,255,248,0,191,255,255,148,0,0,127,233,188,0,0,0,16,0,125,0,0,0,0,0,62,0,0,0,0,0,63,0,27,128,0,0,47,175,255,192,0,26,255,255,255,192,191,255,255,250,64,0,191,255,175,128,0,0,122,64,15,192,0,0,0,0,15,192,0,0,0,0,11,192,0,0,0,0,7,208,0,0,0,0,3,224,0,0,0,0,3,240,0,0,0,0,3,224,0,0,
  // 0x30af  ク
  175,48,21,24,144,26,2,254,0,0,20,0,0,0,0,0,63,0,0,0,0,0,127,0,0,0,0,0,252,0,0,0,0,2,253,85,88,0,0,3,255,255,255,128,0,15,255,255,255,128,0,47,128,0,63,0,0,191,0,0,63,0,2,252,0,0,190,0,15,240,0,0,252,0,127,192,0,2,248,0,46,0,0,3,240,0,4,0,0,11,224,0,0,0,0,31,192,0,0,0,0,127,64,0,0,0,1,254,0,0,0,0,7,248,0,0,0,0,47,224,0,0,0,1,255,128,0,0,0,31,253,0,0,0,2,255,224,0,0,0,0,254,64,0,0,0,0,32,0,0,0,0,
  // 0x30b0  グ
  176,48,24,26,156,26,1,253,0,0,0,0,0,16,0,0,0,0,4,120,0,0,57,0,30,61,0,0,63,0,15,15,0,0,190,0,7,201,0,0,252,0,2,64,0,3,255,255,255,64,0,11,255,255,255,192,0,31,213,85,127,64,0,127,0,0,63,0,1,253,0,0,126,0,7,248,0,0,253,0,47,208,0,0,252,0,127,64,0,3,244,0,12,0,0,7,240,0,0,0,0,15,208,0,0,0,0,63,128,0,0,0,0,191,0,0,0,0,2,252,0,0,0,0,15,244,0,0,0,0,127,208,0,0,0,7,255,0,0,0,0,191,248,0,0,0,2,255,208,0,0,0,0,189,0,0,0,0,0,0,0,0,0,0,
  // 0x30b1  ケ
  177,48,22,23,138,26,2,254,0,15,128,0,0,0,0,31,128,0,0,0,0,47,64,0,0,0,0,63,0,0,0,0,0,126,0,0,0,0,0,191,255,255,255,240,0,255,255,255,255,240,3,250,170,254,170,160,11,224,0,188,0,0,31,192,0,252,0,0,127,64,0,252,0,0,254,0,0,248,0,0,120,0,2,244,0,0,0,0,3,240,0,0,0,0,7,224,0,0,0,0,15,208,0,0,0,0,47,192,0,0,0,0,127,64,0,0,0,1,254,0,0,0,0,7,252,0,0,0,0,63,240,0,0,0,0,15,128,0,0,0,0,1,0,0,0,0,
  // 0x30b2  ゲ
  178,48,24,25,150,26,1,253,0,0,0,0,0,180,0,6,64,0,29,60,0,11,224,0,15,46,0,15,192,0,11,78,0,15,192,0,3,128,0,31,128,0,0,0,0,63,170,170,170,164,0,127,255,255,255,248,0,255,255,255,255,248,2,248,0,63,0,0,7,240,0,63,0,0,15,208,0,62,0,0,127,128,0,125,0,0,127,0,0,189,0,0,8,0,0,252,0,0,0,0,1,248,0,0,0,0,3,240,0,0,0,0,7,240,0,0,0,0,15,208,0,0,0,0,63,128,0,0,0,0,255,0,0,0,0,7,252,0,0,0,0,15,240,0,0,0,0,2,128,0,0,0,0,0,0,0,0,0,
  // 0x30b3  コ
  179,48,19,20,100,26,4,255,170,170,170,170,160,191,255,255,255,244,191,255,255,255,244,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,234,170,170,171,240,255,255,255,255,244,255,255,255,255,244,0,0,0,2,244,0,0,0,1,160,
  // 0x30b4  ゴ
  180,48,22,25,150,26,3,254,0,0,0,0,7,0,0,0,0,3,139,128,0,0,0,3,195,192,0,0,0,1,241,208,0,0,0,0,240,0,42,170,170,170,164,0,127,255,255,255,248,0,127,255,255,255,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,106,170,170,170,248,0,191,255,255,255,248,0,191,255,255,255,248,0,0,0,0,0,248,0,0,0,0,0,84,0,
  // 0x30b5  サ
  181,48,23,23,138,26,1,254,0,10,64,2,240,0,0,15,128,2,240,0,0,15,128,2,240,0,0,15,128,2,240,0,0,15,128,2,240,0,106,175,234,171,250,168,127,255,255,255,255,252,127,255,255,255,255,252,0,15,128,2,240,0,0,15,128,2,240,0,0,15,128,2,240,0,0,15,128,2,240,0,0,15,128,3,240,0,0,15,128,3,224,0,0,10,64,7,208,0,0,0,0,11,192,0,0,0,0,15,192,0,0,0,0,63,64,0,0,0,0,255,0,0,0,0,11,252,0,0,0,0,127,240,0,0,0,0,63,128,0,0,0,0,8,0,0,0,
  // 0x30b6  ザ
  182,48,24,24,144,26,1,253,0,5,0,1,81,44,0,47,0,3,231,93,0,47,0,3,227,206,0,47,0,3,226,202,0,47,0,3,224,128,0,47,0,3,224,0,255,255,255,255,255,248,255,255,255,255,255,248,106,191,170,171,250,164,0,47,0,3,224,0,0,47,0,3,224,0,0,47,0,3,224,0,0,47,0,7,208,0,0,47,0,7,208,0,0,47,0,11,192,0,0,0,0,15,192,0,0,0,0,31,128,0,0,0,0,63,0,0,0,0,0,254,0,0,0,0,7,252,0,0,0,0,127,240,0,0,0,0,191,128,0,0,0,0,45,0,0,0,0,0,0,0,0,0,
  // 0x30b7  シ
  183,48,22,21,126,26,2,255,0,44,0,0,0,0,0,63,128,0,0,0,0,47,244,0,0,0,0,7,253,0,0,0,0,0,188,0,0,0,0,0,20,0,0,0,45,0,0,0,0,192,127,192,0,0,3,208,47,248,0,0,11,240,2,254,0,0,31,192,0,124,0,0,127,64,0,0,0,1,254,0,0,0,0,11,248,0,0,0,0,47,224,0,0,0,1,255,64,0,0,0,27,252,0,0,0,1,255,224,0,0,0,111,255,64,0,0,15,255,244,0,0,0,11,254,64,0,0,0,3,144,0,0,0,0,
  // 0x30b8  ジ
  184,48,23,22,132,26,2,255,0,0,0,0,2,128,0,56,0,0,131,208,0,191,64,2,225,240,0,127,224,0,240,244,0,11,252,0,184,16,0,0,248,0,56,0,0,0,32,0,0,0,60,0,0,0,2,64,191,128,0,0,3,192,47,244,0,0,15,208,7,252,0,0,47,192,0,184,0,0,191,0,0,16,0,2,252,0,0,0,0,15,244,0,0,0,0,63,208,0,0,0,2,255,0,0,0,0,31,252,0,0,0,2,255,208,0,0,0,111,255,0,0,0,31,255,224,0,0,0,15,254,0,0,0,0,7,144,0,0,0,0,
  // 0x30b9  ス
  185,48,21,21,126,26,2,254,3,255,255,255,248,0,3,255,255,255,252,0,2,170,170,171,244,0,0,0,0,3,240,0,0,0,0,11,208,0,0,0,0,15,192,0,0,0,0,47,64,0,0,0,0,127,0,0,0,0,0,252,0,0,0,0,3,248,0,0,0,0,11,248,0,0,0,0,47,254,0,0,0,0,191,191,128,0,0,3,252,31,224,0,0,15,240,7,248,0,0,191,192,2,253,0,7,255,0,0,191,64,127,248,0,0,63,192,63,208,0,0,15,192,13,0,0,0,3,0,0,0,0,0,0,0,
  // 0x30ba  ズ
  186,48,23,25,150,26,2,254,0,0,0,0,1,128,0,0,0,0,113,240,0,0,0,0,120,180,0,0,0,0,61,60,10,170,170,170,238,0,15,255,255,255,248,0,15,255,255,255,240,0,0,0,0,11,224,0,0,0,0,15,192,0,0,0,0,31,128,0,0,0,0,63,0,0,0,0,0,190,0,0,0,0,1,252,0,0,0,0,3,244,0,0,0,0,11,240,0,0,0,0,47,248,0,0,0,0,191,254,0,0,0,2,252,127,128,0,0,15,240,31,224,0,0,127,192,11,244,0,2,255,0,2,253,0,47,248,0,0,191,0,255,208,0,0,63,192,62,0,0,0,15,0,4,0,0,0,4,0,
  // 0x30bb  セ
  187,48,22,22,132,26,1,255,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,1,128,0,7,208,6,191,240,0,7,230,255,255,240,0,111,255,255,239,208,127,255,255,164,15,192,127,255,224,0,63,0,62,71,208,0,126,0,0,7,208,1,252,0,0,7,208,3,240,0,0,7,208,11,208,0,0,7,208,1,128,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,224,0,0,64,0,3,254,170,191,192,0,2,255,255,255,192,0,0,111,255,250,128,
  // 0x30bc  ゼ
  188,48,24,25,150,26,1,254,0,0,0,0,0,16,0,0,0,0,4,184,0,1,64,0,30,60,0,15,192,0,15,30,0,15,192,0,7,137,0,11,192,0,3,128,0,11,192,0,0,0,0,11,192,0,107,192,0,11,192,111,255,240,0,11,255,255,255,208,22,255,255,254,95,128,255,255,249,0,63,0,191,239,192,0,126,0,100,11,192,0,252,0,0,11,192,3,240,0,0,11,192,15,224,0,0,11,192,11,128,0,0,11,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,0,0,11,224,0,22,128,0,7,255,255,255,128,0,2,255,255,255,128,0,0,22,165,80,0,
  // 0x30bd  ソ
  189,48,19,20,100,26,3,255,24,0,0,0,252,253,0,0,0,252,127,0,0,0,252,63,128,0,1,248,15,192,0,2,244,11,240,0,3,240,3,244,0,3,224,2,248,0,11,208,0,208,0,15,192,0,0,0,47,128,0,0,0,63,0,0,0,0,253,0,0,0,3,252,0,0,0,11,240,0,0,0,47,208,0,0,0,255,64,0,0,11,253,0,0,0,191,240,0,0,0,191,128,0,0,0,40,0,0,0,
  // 0x30be  ゾ
  190,48,23,24,144,26,2,255,0,0,0,0,1,128,0,0,0,0,178,224,0,0,0,0,244,244,0,0,0,0,60,120,9,0,0,0,44,0,127,0,0,0,185,0,63,128,0,0,189,0,15,192,0,0,252,0,11,240,0,0,252,0,3,244,0,1,248,0,2,252,0,2,244,0,0,252,0,3,240,0,0,96,0,11,224,0,0,0,0,15,192,0,0,0,0,47,128,0,0,0,0,127,0,0,0,0,0,253,0,0,0,0,3,248,0,0,0,0,31,240,0,0,0,0,191,192,0,0,0,7,255,0,0,0,0,63,248,0,0,0,0,63,208,0,0,0,0,14,0,0,0,0,
  // 0x30bf  タ
  191,48,21,24,144,26,2,254,0,0,40,0,0,0,0,0,63,0,0,0,0,0,189,0,0,0,0,0,252,0,0,0,0,3,255,255,255,64,0,11,255,255,255,192,0,31,213,85,127,64,0,63,0,0,63,0,0,253,0,0,126,0,7,248,0,0,252,0,31,224,180,1,248,0,191,66,254,3,240,0,61,0,191,203,224,0,0,0,31,255,192,0,0,0,2,255,128,0,0,0,0,255,208,0,0,0,3,255,244,0,0,0,15,247,252,0,0,0,127,192,176,0,0,2,255,0,0,0,0,47,248,0,0,0,3,255,208,0,0,0,1,253,0,0,0,0,0,80,0,0,0,0,
  // 0x30c0  ダ
  192,48,24,26,156,26,1,253,0,0,0,0,0,32,0,0,0,0,4,124,0,0,46,0,30,45,0,0,63,0,15,79,0,0,190,0,7,196,0,0,253,85,91,64,0,3,255,255,255,192,0,11,255,255,255,192,0,31,192,0,47,64,0,127,0,0,63,0,0,253,0,0,126,0,7,244,16,0,253,0,47,208,248,1,252,0,127,65,255,67,244,0,28,0,63,235,224,0,0,0,7,255,192,0,0,0,0,255,192,0,0,0,0,255,240,0,0,0,3,255,252,0,0,0,31,241,252,0,0,0,191,192,48,0,0,7,254,0,0,0,0,127,244,0,0,0,3,255,128,0,0,0,0,248,0,0,0,0,0,0,0,0,0,0,
  // 0x30c1  チ
  193,48,22,23,138,26,2,254,0,0,0,0,16,0,0,0,0,91,244,0,6,170,255,255,252,0,11,255,255,254,64,0,7,250,175,192,0,0,0,0,15,192,0,0,0,0,15,192,0,0,0,0,15,192,0,0,0,0,15,192,0,0,255,255,255,255,255,240,255,255,255,255,255,240,101,85,95,213,85,144,0,0,15,128,0,0,0,0,31,64,0,0,0,0,47,0,0,0,0,0,63,0,0,0,0,0,189,0,0,0,0,1,252,0,0,0,0,7,244,0,0,0,0,31,224,0,0,0,0,255,128,0,0,0,0,125,0,0,0,0,0,0,0,0,0,0,
  // 0x30c2  ヂ
  194,48,24,23,138,26,1,254,0,0,0,0,16,0,0,0,0,27,248,0,6,170,255,255,253,0,3,255,255,254,80,116,3,250,175,192,13,60,0,0,11,192,15,45,0,0,11,192,7,141,0,0,11,192,3,128,0,0,11,192,0,0,127,255,255,255,255,240,127,255,255,255,255,240,101,85,95,213,85,96,0,0,15,192,0,0,0,0,15,128,0,0,0,0,31,128,0,0,0,0,47,64,0,0,0,0,63,0,0,0,0,0,253,0,0,0,0,3,252,0,0,0,0,11,240,0,0,0,0,127,208,0,0,0,0,127,0,0,0,0,0,8,0,0,0,0,
  // 0x30c3  ッ
  195,48,18,17,85,26,4,254,0,7,192,1,0,44,3,224,3,240,125,3,240,3,240,63,1,244,3,224,47,0,248,11,192,15,128,244,15,192,15,192,0,31,128,6,0,0,63,0,0,0,0,125,0,0,0,0,252,0,0,0,3,244,0,0,0,31,208,0,0,0,191,128,0,0,7,253,0,0,0,191,244,0,0,0,255,128,0,0,0,56,0,0,0,
  // 0x30c4  ツ
  196,48,22,21,126,26,2,255,0,0,112,0,0,0,0,0,248,0,7,64,124,0,252,0,11,224,126,0,125,0,15,192,63,0,63,0,15,192,31,64,47,0,31,128,15,192,31,128,47,0,11,208,9,0,63,0,7,224,0,0,190,0,2,64,0,0,252,0,0,0,0,2,248,0,0,0,0,7,240,0,0,0,0,15,208,0,0,0,0,63,128,0,0,0,0,255,0,0,0,0,7,252,0,0,0,0,63,240,0,0,0,2,255,128,0,0,0,127,253,0,0,0,0,47,224,0,0,0,0,10,0,0,0,0,
  // 0x30c5  ヅ
  197,48,23,24,144,26,2,254,0,0,0,0,1,208,0,0,0,0,240,240,0,0,0,0,120,184,0,0,160,0,61,56,0,2,240,0,24,0,184,1,248,0,4,0,252,0,252,0,15,128,126,0,189,0,31,128,63,0,62,0,47,0,47,64,63,0,63,0,15,192,25,0,126,0,15,192,0,0,252,0,6,0,0,1,248,0,0,0,0,3,240,0,0,0,0,11,224,0,0,0,0,31,192,0,0,0,0,127,64,0,0,0,1,253,0,0,0,0,11,248,0,0,0,0,127,224,0,0,0,7,255,64,0,0,0,127,252,0,0,0,0,127,208,0,0,0,0,29,0,0,0,0,
  // 0x30c6  テ
  198,48,22,22,132,26,2,254,2,255,255,255,252,0,2,255,255,255,252,0,1,85,85,85,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,240,191,255,255,255,255,240,101,85,95,213,85,144,0,0,15,192,0,0,0,0,15,192,0,0,0,0,15,128,0,0,0,0,31,128,0,0,0,0,47,0,0,0,0,0,63,0,0,0,0,0,253,0,0,0,0,2,252,0,0,0,0,11,240,0,0,0,0,127,208,0,0,0,0,127,0,0,0,0,0,8,0,0,0,0,
  // 0x30c7  デ
  199,48,24,26,156,26,2,253,0,0,0,0,0,160,0,0,0,0,20,240,0,0,0,0,60,124,1,85,85,85,158,45,3,255,255,255,207,68,3,255,255,255,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,85,85,85,85,144,255,255,255,255,255,224,255,255,255,255,255,224,0,0,15,128,0,0,0,0,31,128,0,0,0,0,31,64,0,0,0,0,47,64,0,0,0,0,63,0,0,0,0,0,62,0,0,0,0,0,253,0,0,0,0,2,252,0,0,0,0,11,240,0,0,0,0,127,208,0,0,0,0,255,0,0,0,0,0,40,0,0,0,0,0,0,0,0,0,0,
  // 0x30c8  ト
  200,48,14,22,88,26,8,255,20,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,125,0,0,0,125,0,0,0,125,0,0,0,125,0,0,0,127,224,0,0,127,255,128,0,127,255,249,0,125,31,255,208,125,0,191,240,125,0,7,224,125,0,0,64,125,0,0,0,125,0,0,0,125,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,
  // 0x30c9  ド
  201,48,16,22,88,26,7,255,20,0,0,16,126,0,0,244,126,0,60,60,125,0,61,46,125,0,15,13,125,0,11,64,125,0,0,0,126,0,0,0,127,228,0,0,127,255,128,0,127,255,253,0,125,27,255,224,125,0,191,240,125,0,7,240,125,0,0,80,125,0,0,0,125,0,0,0,125,0,0,0,125,0,0,0,125,0,0,0,126,0,0,0,126,0,0,0,
  // 0x30ca  ナ
  202,48,22,23,138,26,2,254,0,0,15,192,0,0,0,0,15,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,106,170,175,234,170,160,191,255,255,255,255,240,191,255,255,255,255,240,0,0,15,192,0,0,0,0,15,192,0,0,0,0,15,192,0,0,0,0,15,128,0,0,0,0,47,128,0,0,0,0,63,0,0,0,0,0,127,0,0,0,0,0,253,0,0,0,0,3,252,0,0,0,0,11,244,0,0,0,0,63,208,0,0,0,1,255,64,0,0,0,0,125,0,0,0,0,0,0,0,0,0,0,
  // 0x30cb  ニ
  203,48,21,17,102,26,2,1,7,250,170,170,252,0,7,255,255,255,252,0,7,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,192,191,255,255,255,255,192,191,255,255,255,255,192,
  // 0x30cc  ヌ
  204,48,19,21,105,26,3,254,31,255,255,255,224,31,255,255,255,244,10,170,170,171,240,0,0,0,7,224,0,0,0,15,192,0,0,0,15,192,0,224,0,47,64,3,254,0,63,0,0,255,192,190,0,0,31,244,252,0,0,3,255,244,0,0,0,191,240,0,0,0,47,248,0,0,0,191,254,0,0,2,254,191,192,0,31,244,31,240,0,191,208,7,244,11,255,0,0,224,191,248,0,0,0,63,128,0,0,0,8,0,0,0,0,
  // 0x30cd  ネ
  205,48,22,24,144,26,2,254,0,0,10,64,0,0,0,0,15,128,0,0,0,0,15,64,0,0,0,0,15,64,0,0,9,85,111,149,100,0,15,255,255,255,253,0,15,255,255,255,253,0,0,0,0,3,244,0,0,0,0,15,224,0,0,0,0,63,128,0,0,0,1,254,0,0,0,0,11,248,0,0,0,0,127,208,0,0,0,7,255,66,224,0,0,127,255,71,253,0,27,255,159,65,255,128,255,248,15,64,47,240,127,64,15,64,7,224,16,0,15,64,0,128,0,0,15,64,0,0,0,0,15,64,0,0,0,0,31,64,0,0,0,0,31,64,0,0,0,0,10,64,0,0,
  // 0x30ce  ノ
  206,48,18,21,105,26,3,255,0,0,0,3,144,0,0,0,7,240,0,0,0,11,224,0,0,0,15,192,0,0,0,31,192,0,0,0,47,64,0,0,0,63,0,0,0,0,190,0,0,0,0,252,0,0,0,2,248,0,0,0,7,240,0,0,0,15,208,0,0,0,63,128,0,0,1,255,0,0,0,7,252,0,0,0,47,240,0,0,1,255,128,0,0,47,254,0,0,0,127,240,0,0,0,31,64,0,0,0,0,0,0,0,0,
  // 0x30cf  ハ
  207,48,22,18,108,26,2,0,0,15,128,47,0,0,0,15,192,63,64,0,0,31,128,15,192,0,0,31,64,15,208,0,0,47,0,7,224,0,0,63,0,3,240,0,0,62,0,1,248,0,0,189,0,0,252,0,0,252,0,0,189,0,1,248,0,0,127,0,2,244,0,0,63,0,3,240,0,0,47,128,11,224,0,0,15,192,15,192,0,0,15,192,63,128,0,0,11,224,127,0,0,0,7,240,253,0,0,0,3,240,40,0,0,0,2,128,
  // 0x30d0  バ
  208,48,24,22,132,26,1,0,0,0,0,0,0,52,0,0,0,0,9,60,0,0,0,0,15,46,0,0,0,0,11,79,0,3,144,31,131,192,0,7,224,15,192,0,0,11,208,11,224,0,0,15,192,3,240,0,0,15,192,2,244,0,0,15,128,0,252,0,0,47,64,0,253,0,0,63,0,0,126,0,0,62,0,0,63,0,0,189,0,0,47,64,0,252,0,0,31,192,2,248,0,0,15,192,3,240,0,0,11,224,11,224,0,0,3,240,15,208,0,0,3,240,63,128,0,0,2,248,127,0,0,0,1,252,25,0,0,0,0,208,
  // 0x30d1  パ
  209,48,24,23,138,26,1,255,0,0,0,0,1,248,0,0,0,0,7,158,0,0,0,0,11,7,0,0,0,0,14,7,0,3,144,15,139,15,0,7,224,15,195,253,0,11,208,11,208,80,0,15,192,3,240,0,0,15,192,2,244,0,0,15,128,1,248,0,0,31,64,0,252,0,0,47,0,0,190,0,0,63,0,0,63,0,0,126,0,0,47,64,0,252,0,0,31,128,1,252,0,0,15,192,3,244,0,0,11,208,3,240,0,0,7,224,15,224,0,0,3,240,31,192,0,0,3,244,63,64,0,0,2,248,127,0,0,0,1,248,4,0,0,0,0,64,
  // 0x30d2  ヒ
  210,48,18,22,110,26,5,255,105,0,0,0,0,126,0,0,0,0,125,0,0,0,0,125,0,0,0,0,125,0,0,7,0,125,0,0,127,64,125,0,27,255,128,125,6,255,248,0,126,255,255,64,0,127,255,224,0,0,127,244,0,0,0,126,0,0,0,0,125,0,0,0,0,125,0,0,0,0,125,0,0,0,0,125,0,0,0,0,125,0,0,0,0,126,0,0,0,0,63,64,0,22,144,63,255,255,255,208,15,255,255,255,208,0,106,170,165,0,
  // 0x30d3  ビ
  211,48,20,23,115,26,4,255,0,0,0,0,120,0,0,0,29,60,126,0,0,15,30,125,0,0,7,142,125,0,0,3,192,125,0,0,1,0,125,0,0,47,0,125,0,6,255,64,125,1,191,254,0,125,111,255,208,0,127,255,248,0,0,127,254,0,0,0,127,64,0,0,0,125,0,0,0,0,125,0,0,0,0,125,0,0,0,0,125,0,0,0,0,125,0,0,0,0,125,0,0,0,0,63,0,0,0,64,63,250,170,255,208,31,255,255,255,208,2,255,255,254,128,
  // 0x30d4  ピ
  212,48,21,23,138,26,4,255,0,0,0,0,252,0,20,0,0,3,223,0,126,0,0,7,3,64,125,0,0,7,3,64,125,0,0,3,135,0,125,0,0,3,254,0,125,0,0,47,16,0,125,0,6,255,64,0,125,1,191,254,0,0,125,111,255,208,0,0,127,255,248,0,0,0,127,254,0,0,0,0,127,64,0,0,0,0,125,0,0,0,0,0,125,0,0,0,0,0,125,0,0,0,0,0,125,0,0,0,0,0,125,0,0,0,0,0,125,0,0,0,0,0,63,0,0,0,64,0,63,250,170,255,208,0,31,255,255,255,208,0,2,255,255,254,128,0,
  // 0x30d5  フ
  213,48,20,21,105,26,3,254,127,255,255,255,248,127,255,255,255,254,106,170,170,170,253,0,0,0,0,252,0,0,0,0,252,0,0,0,1,248,0,0,0,3,240,0,0,0,3,240,0,0,0,11,208,0,0,0,15,192,0,0,0,47,128,0,0,0,127,0,0,0,1,253,0,0,0,7,248,0,0,0,47,240,0,0,1,255,128,0,0,31,254,0,0,2,255,244,0,0,1,255,128,0,0,0,180,0,0,0,0,0,0,0,0,
  // 0x30d6  ブ
  214,48,22,25,150,26,3,254,0,0,0,0,2,64,0,0,0,3,195,192,0,0,0,1,241,224,0,0,0,0,244,240,170,170,170,170,244,0,255,255,255,255,252,0,255,255,255,255,252,0,0,0,0,1,248,0,0,0,0,2,244,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,11,208,0,0,0,0,15,192,0,0,0,0,31,128,0,0,0,0,63,64,0,0,0,0,190,0,0,0,0,2,252,0,0,0,0,11,244,0,0,0,0,47,224,0,0,0,1,255,128,0,0,0,11,254,0,0,0,2,255,244,0,0,0,3,255,128,0,0,0,1,248,0,0,0,0,0,64,0,0,0,0,
  // 0x30d7  プ
  215,48,23,25,150,26,3,254,0,0,0,0,1,0,0,0,0,0,31,224,0,0,0,0,56,112,0,0,0,0,112,52,170,170,170,170,240,52,255,255,255,255,253,240,255,255,255,255,255,192,0,0,0,1,248,0,0,0,0,2,244,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,11,224,0,0,0,0,15,192,0,0,0,0,31,192,0,0,0,0,63,64,0,0,0,0,191,0,0,0,0,2,252,0,0,0,0,7,244,0,0,0,0,47,224,0,0,0,1,255,128,0,0,0,11,254,0,0,0,2,255,244,0,0,0,3,255,128,0,0,0,1,248,0,0,0,0,0,64,0,0,0,0,
  // 0x30d8  ヘ
  216,48,24,17,102,26,1,0,0,0,189,0,0,0,0,3,255,128,0,0,0,11,255,224,0,0,0,31,199,248,0,0,0,63,1,254,0,0,0,253,0,127,64,0,3,248,0,31,208,0,11,240,0,11,244,0,47,208,0,2,252,0,127,128,0,0,255,0,47,0,0,0,63,192,8,0,0,0,31,240,0,0,0,0,7,248,0,0,0,0,2,254,0,0,0,0,0,252,0,0,0,0,0,52,0,0,0,0,0,0,
  // 0x30d9  ベ
  217,48,24,20,120,26,1,0,0,0,0,0,1,128,0,0,0,0,3,208,0,0,0,1,241,240,0,0,184,0,244,184,0,3,255,0,124,56,0,11,255,192,61,0,0,31,219,240,0,0,0,63,2,252,0,0,0,253,0,191,0,0,3,248,0,63,192,0,11,240,0,15,240,0,47,208,0,3,248,0,191,128,0,1,254,0,63,0,0,0,191,64,12,0,0,0,47,208,0,0,0,0,15,240,0,0,0,0,3,252,0,0,0,0,1,253,0,0,0,0,0,180,0,0,0,0,0,16,
  // 0x30da  ペ
  218,48,24,20,120,26,1,0,0,0,0,0,5,0,0,0,0,0,63,224,0,0,0,0,180,176,0,0,184,0,224,52,0,3,255,0,224,52,0,11,255,192,180,176,0,31,219,240,63,208,0,63,2,252,5,0,0,253,0,191,0,0,3,252,0,63,192,0,11,240,0,15,240,0,31,208,0,3,248,0,127,128,0,1,254,0,127,0,0,0,191,64,29,0,0,0,47,208,4,0,0,0,15,240,0,0,0,0,3,252,0,0,0,0,1,253,0,0,0,0,0,180,0,0,0,0,0,16,
  // 0x30db  ホ
  219,48,23,22,132,26,2,255,0,0,15,192,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,41,85,95,213,86,144,63,255,255,255,255,224,63,255,255,255,255,224,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,160,15,128,116,0,0,248,15,128,252,0,3,240,15,128,63,0,7,224,15,128,47,128,15,192,15,128,15,192,63,64,15,128,7,224,254,0,15,128,3,244,120,0,15,128,1,208,0,0,15,128,0,0,0,10,175,128,0,0,0,15,255,128,0,0,0,11,254,0,0,0,
  // 0x30dc  ボ
  220,48,24,24,144,26,1,254,0,0,0,0,0,112,0,0,6,144,44,124,0,0,7,208,30,45,0,0,7,208,15,78,0,0,7,208,7,64,0,0,7,208,0,0,47,255,255,255,255,240,47,255,255,255,255,240,26,85,91,229,86,160,0,0,7,208,0,0,0,0,7,208,0,0,0,16,7,208,4,0,0,125,7,208,125,0,0,252,7,208,63,0,2,244,7,208,31,192,7,240,7,208,11,208,15,192,7,208,3,240,63,64,7,208,2,248,126,0,7,208,0,248,8,0,7,208,0,80,0,0,11,208,0,0,0,7,255,192,0,0,0,3,255,192,0,0,0,1,85,0,0,0,
  // 0x30dd  ポ
  221,48,23,25,150,26,1,254,0,0,0,0,3,224,0,0,0,0,15,124,0,0,11,208,28,12,0,0,7,208,28,12,0,0,7,208,15,124,0,0,7,208,7,224,0,0,7,208,0,0,47,255,255,255,255,240,47,255,255,255,255,240,26,85,91,229,86,160,0,0,7,208,0,0,0,0,7,208,0,0,0,16,7,208,4,0,0,125,7,208,125,0,0,252,7,208,63,0,2,244,7,208,31,192,7,240,7,208,11,208,15,192,7,208,3,240,63,64,7,208,2,248,126,0,7,208,0,248,8,0,7,208,0,80,0,0,11,208,0,0,0,7,255,192,0,0,0,3,255,192,0,0,0,1,85,0,0,0,
  // 0x30de  マ
  222,48,22,20,120,26,2,254,127,255,255,255,255,208,127,255,255,255,255,240,106,170,170,170,175,224,0,0,0,0,47,192,0,0,0,0,127,64,0,0,0,0,254,0,0,0,0,3,252,0,0,36,0,11,240,0,0,189,0,47,192,0,0,191,128,191,0,0,0,31,226,253,0,0,0,7,255,240,0,0,0,0,255,192,0,0,0,0,63,192,0,0,0,0,15,240,0,0,0,0,7,248,0,0,0,0,1,254,0,0,0,0,0,127,64,0,0,0,0,47,0,0,0,0,0,4,0,0,
  // 0x30df  ミ
  223,48,17,21,105,26,4,255,2,229,0,0,0,3,255,249,0,0,2,255,255,249,0,0,1,191,255,192,0,0,1,191,128,0,0,0,1,0,0,0,0,0,0,15,144,0,0,0,31,255,228,0,0,27,255,255,228,0,0,6,255,253,0,0,0,6,252,0,0,0,0,20,0,0,0,0,0,0,20,0,0,0,0,191,228,0,0,0,255,255,228,0,0,22,255,255,228,0,0,6,255,255,64,0,0,6,255,0,0,0,0,10,0,
  // 0x30e0  ム
  224,48,23,23,138,26,2,254,0,0,20,0,0,0,0,0,190,0,0,0,0,0,189,0,0,0,0,0,252,0,0,0,0,1,248,0,0,0,0,2,244,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,7,208,0,0,0,0,15,192,0,0,0,0,15,192,1,192,0,0,31,128,7,224,0,0,47,0,3,244,0,0,63,0,1,252,0,0,126,0,0,253,0,0,188,0,0,127,0,0,252,0,5,191,64,1,253,175,255,255,192,255,255,255,255,255,208,255,255,255,165,7,240,250,148,0,0,3,244,0,0,0,0,2,208,0,0,0,0,0,0,
  // 0x30e1  メ
  225,48,20,21,105,26,3,255,0,0,0,2,144,0,0,0,3,240,0,0,0,7,224,0,0,0,15,208,0,208,0,15,192,3,252,0,47,64,1,255,64,63,0,0,47,224,189,0,0,7,254,252,0,0,0,255,244,0,0,0,47,240,0,0,0,47,252,0,0,0,127,255,0,0,1,253,63,192,0,11,244,15,240,0,47,208,3,253,0,255,64,0,255,11,253,0,0,60,127,240,0,0,0,191,128,0,0,0,24,0,0,0,0,
  // 0x30e2  モ
  226,48,21,20,120,26,3,255,31,255,255,255,248,0,31,255,255,255,248,0,5,87,245,85,84,0,0,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,165,87,245,85,86,64,255,255,255,255,255,128,255,255,255,255,255,128,0,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,2,244,0,0,0,0,2,255,171,255,0,0,0,255,255,255,0,0,0,31,255,254,0,
  // 0x30e3  ャ
  227,48,19,19,95,26,4,253,0,180,0,0,0,1,248,0,0,0,0,252,0,0,0,0,188,0,107,244,0,126,191,255,244,22,255,255,235,224,255,255,164,11,192,254,175,0,31,64,0,15,64,126,0,0,15,128,252,0,0,11,194,240,0,0,7,192,64,0,0,3,224,0,0,0,3,240,0,0,0,2,240,0,0,0,1,244,0,0,0,0,248,0,0,0,0,252,0,0,0,0,80,0,0,
  // 0x30e4  ヤ
  228,48,23,23,138,26,1,254,0,27,0,0,0,0,0,47,64,0,0,0,0,31,128,0,0,0,0,15,192,0,1,160,0,11,192,6,255,252,0,7,235,255,255,244,1,175,255,255,151,240,127,255,254,80,11,208,63,251,240,0,31,128,41,1,248,0,127,0,0,0,252,0,252,0,0,0,252,3,244,0,0,0,189,11,224,0,0,0,126,0,64,0,0,0,63,0,0,0,0,0,63,0,0,0,0,0,47,64,0,0,0,0,15,128,0,0,0,0,15,192,0,0,0,0,11,208,0,0,0,0,7,224,0,0,0,0,3,224,0,0,0,0,0,0,0,0,
  // 0x30e5  ュ
  229,48,19,15,75,26,4,255,6,85,85,160,0,15,255,255,253,0,15,255,255,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,248,0,0,0,0,248,0,0,0,1,244,0,0,0,1,244,0,0,0,2,240,0,0,0,3,240,0,165,85,87,245,160,255,255,255,255,244,255,255,255,255,244,0,0,0,0,0,
  // 0x30e6  ユ
  230,48,22,17,102,26,2,1,3,255,255,255,240,0,3,255,255,255,244,0,2,170,170,171,244,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,3,224,0,0,0,0,7,224,0,0,0,0,7,208,0,0,0,0,11,208,0,0,0,0,15,192,0,0,0,0,15,192,0,0,0,0,15,192,0,0,0,0,15,128,0,255,255,255,255,255,240,255,255,255,255,255,240,250,170,170,170,170,176,
  // 0x30e7  ョ
  231,48,16,18,72,26,5,253,21,85,85,84,127,255,255,253,127,255,255,253,0,0,0,61,0,0,0,61,0,0,0,61,21,85,85,125,47,255,255,253,47,255,255,253,0,0,0,61,0,0,0,61,0,0,0,61,0,0,0,61,85,85,85,189,191,255,255,253,191,255,255,253,0,0,0,125,0,0,0,0,
  // 0x30e8  ヨ
  232,48,18,20,100,26,4,255,255,255,255,255,240,255,255,255,255,240,105,85,85,87,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,63,255,255,255,240,63,255,255,255,240,37,85,85,87,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,255,255,255,255,240,255,255,255,255,240,170,170,170,171,240,0,0,0,3,240,
  // 0x30e9  ラ
  233,48,20,22,110,26,3,254,3,255,255,255,240,3,255,255,255,240,2,149,85,85,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,85,85,85,84,127,255,255,255,255,127,255,255,255,254,0,0,0,0,189,0,0,0,0,252,0,0,0,1,248,0,0,0,3,240,0,0,0,11,224,0,0,0,47,192,0,0,0,191,0,0,0,3,253,0,0,0,47,244,0,0,6,255,192,0,0,63,254,0,0,0,31,224,0,0,0,5,0,0,0,
  // 0x30ea  リ
  234,48,16,22,88,26,5,254,125,0,0,189,125,0,0,189,125,0,0,125,125,0,0,125,125,0,0,125,125,0,0,125,125,0,0,125,125,0,0,125,125,0,0,125,125,0,0,189,125,0,0,188,125,0,0,252,189,0,0,252,0,0,1,248,0,0,3,244,0,0,11,240,0,0,47,192,0,1,255,64,0,47,253,0,0,127,240,0,0,30,0,0,0,0,0,0,
  // 0x30eb  ル
  235,48,23,21,126,26,2,255,0,125,2,244,0,0,0,125,1,244,0,0,0,125,1,244,0,0,0,125,1,244,0,0,0,125,1,244,0,0,0,125,1,244,0,0,0,124,1,244,0,0,0,124,1,244,0,0,0,188,1,244,0,0,0,188,1,244,0,0,0,188,1,244,0,0,0,252,1,244,0,112,0,248,1,244,1,248,1,244,1,244,7,244,3,240,1,244,47,208,7,224,1,244,255,64,15,192,1,255,253,0,63,128,1,255,240,0,255,0,2,255,64,0,188,0,0,248,0,0,16,0,0,16,0,0,
  // 0x30ec  レ
  236,48,19,20,100,26,5,255,126,0,0,0,0,126,0,0,0,0,126,0,0,0,0,126,0,0,0,0,126,0,0,0,0,126,0,0,0,0,126,0,0,0,0,126,0,0,0,0,126,0,0,0,112,126,0,0,1,244,126,0,0,7,244,126,0,0,47,208,126,0,0,255,64,126,0,7,253,0,126,0,127,240,0,126,7,255,128,0,127,255,248,0,0,127,255,128,0,0,127,244,0,0,0,30,0,0,0,0,
  // 0x30ed  ロ
  237,48,20,20,100,26,3,255,106,170,170,170,169,127,255,255,255,254,127,255,255,255,254,125,0,0,0,62,125,0,0,0,62,125,0,0,0,62,125,0,0,0,62,125,0,0,0,62,125,0,0,0,62,125,0,0,0,62,125,0,0,0,62,125,0,0,0,62,125,0,0,0,62,125,0,0,0,62,125,0,0,0,62,126,170,170,170,190,127,255,255,255,254,127,255,255,255,254,125,0,0,0,62,40,0,0,0,41,
  // 0x30ee  ヮ
  238,48,18,18,90,26,4,253,21,85,85,86,0,127,255,255,255,208,63,255,255,255,224,61,0,0,11,208,61,0,0,11,192,61,0,0,15,192,61,0,0,15,128,125,0,0,31,64,41,0,0,63,0,0,0,0,126,0,0,0,0,252,0,0,0,3,248,0,0,0,15,240,0,0,0,127,192,0,0,7,255,0,0,0,127,248,0,0,0,47,192,0,0,0,4,0,0,0,
  // 0x30ef  ワ
  239,48,20,21,105,26,3,254,255,255,255,255,252,191,255,255,255,255,190,170,170,170,190,188,0,0,0,189,188,0,0,0,189,188,0,0,0,252,188,0,0,0,252,188,0,0,1,248,252,0,0,2,244,104,0,0,3,240,0,0,0,7,240,0,0,0,15,208,0,0,0,63,192,0,0,0,191,0,0,0,2,253,0,0,0,15,248,0,0,0,191,208,0,0,27,255,64,0,0,63,248,0,0,0,15,144,0,0,0,0,0,0,0,
  // 0x30f0  ヰ
  240,48,22,23,138,26,2,254,0,0,0,10,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,21,85,85,111,149,128,63,255,255,255,255,208,63,255,255,255,255,208,0,31,0,15,64,0,0,31,0,15,64,0,0,31,0,15,64,0,0,31,0,15,64,0,0,31,0,15,64,0,0,31,0,15,64,0,0,31,0,15,64,0,255,255,255,255,255,240,255,255,255,255,255,240,105,85,85,111,150,160,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,31,64,0,0,0,0,5,0,0,
  // 0x30f1  ヱ
  241,48,22,19,114,26,2,0,26,170,170,170,170,64,47,255,255,255,255,224,47,255,255,255,255,192,0,0,0,0,47,128,0,0,0,0,63,0,0,0,63,0,253,0,0,0,63,3,248,0,0,0,63,15,240,0,0,0,63,15,192,0,0,0,63,1,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,0,63,0,0,0,255,255,255,255,255,240,255,255,255,255,255,240,250,170,170,170,170,176,
  // 0x30f2  ヲ
  242,48,19,21,105,26,4,254,255,255,255,255,244,255,255,255,255,252,170,170,170,170,248,0,0,0,1,244,0,0,0,2,240,0,0,0,3,240,0,0,0,3,240,127,255,255,255,224,127,255,255,255,192,21,85,85,95,192,0,0,0,47,64,0,0,0,63,0,0,0,0,253,0,0,0,3,248,0,0,0,15,240,0,0,0,127,192,0,0,2,255,0,0,0,111,248,0,0,3,255,208,0,0,1,253,0,0,0,0,80,0,0,0,
  // 0x30f3  ン
  243,48,21,20,120,26,3,255,6,0,0,0,0,0,31,208,0,0,0,0,15,244,0,0,0,0,3,254,0,0,0,0,0,191,128,0,2,0,0,31,208,0,7,128,0,7,128,0,15,192,0,0,0,0,47,128,0,0,0,0,127,0,0,0,0,1,253,0,0,0,0,7,248,0,0,0,0,31,224,0,0,0,0,191,128,0,0,0,7,254,0,0,0,0,47,244,0,0,0,6,255,192,0,0,1,191,253,0,0,0,127,255,224,0,0,0,63,253,0,0,0,0,14,64,0,0,0,0,
  // 0x30f4  ヴ
  244,48,23,25,150,26,2,254,0,0,0,0,1,128,0,0,0,0,98,208,0,0,127,0,244,240,0,0,62,0,60,184,0,0,62,0,45,32,0,0,62,0,8,0,21,85,127,85,89,0,127,255,255,255,255,64,63,255,255,255,255,64,61,0,0,0,63,0,61,0,0,0,63,0,61,0,0,0,126,0,61,0,0,0,189,0,61,0,0,0,252,0,125,0,0,1,252,0,0,0,0,3,244,0,0,0,0,7,240,0,0,0,0,15,208,0,0,0,0,63,128,0,0,0,1,255,0,0,0,0,11,252,0,0,0,1,191,240,0,0,0,31,255,64,0,0,0,15,248,0,0,0,0,2,64,0,0,0,
  // 0x30f5  ヵ
  245,48,17,20,100,26,4,253,0,1,64,0,0,0,7,208,0,0,0,7,192,0,0,0,7,192,0,0,21,91,213,85,0,127,255,255,255,192,127,255,255,255,192,0,11,192,11,192,0,15,128,11,128,0,15,64,11,128,0,31,0,15,128,0,47,0,15,128,0,62,0,15,64,0,188,0,15,64,1,248,0,31,0,7,240,0,47,0,31,192,37,127,0,191,64,63,253,0,44,0,47,248,0,0,0,0,0,0,
  // 0x30f6  ヶ
  246,48,20,20,100,26,3,253,0,4,0,0,0,0,47,64,0,0,0,63,0,0,0,0,62,0,0,0,0,190,85,85,84,0,255,255,255,253,2,255,255,255,253,7,224,3,224,0,31,192,3,208,0,127,64,7,192,0,189,0,11,192,0,20,0,15,192,0,0,0,31,64,0,0,0,63,0,0,0,0,190,0,0,0,1,252,0,0,0,7,244,0,0,0,47,224,0,0,0,47,64,0,0,0,5,0,0,0,
  // 0x30f7  ヷ
  247,48,22,26,156,26,2,253,0,0,0,0,2,192,0,0,0,1,226,224,0,0,0,0,240,240,0,0,0,0,184,160,0,0,0,0,32,0,127,255,255,255,254,0,127,255,255,255,255,64,127,170,170,170,191,0,126,0,0,0,63,0,126,0,0,0,127,0,126,0,0,0,126,0,126,0,0,0,189,0,126,0,0,0,252,0,126,0,0,0,252,0,21,0,0,2,248,0,0,0,0,3,240,0,0,0,0,11,224,0,0,0,0,31,192,0,0,0,0,127,64,0,0,0,1,254,0,0,0,0,11,248,0,0,0,0,191,224,0,0,0,27,255,64,0,0,0,31,252,0,0,0,0,7,144,0,0,0,0,0,0,0,0,0,
  // 0x30f8  ヸ
  248,48,23,24,144,26,2,254,0,0,0,0,4,240,0,0,0,26,29,116,0,0,0,31,14,56,0,0,0,31,11,36,0,0,0,31,1,0,37,85,85,111,149,128,63,255,255,255,255,192,63,255,255,255,255,192,0,47,0,31,0,0,0,47,0,31,0,0,0,47,0,31,0,0,0,47,0,31,0,0,0,47,0,31,0,0,0,47,0,31,0,0,0,47,0,31,0,0,165,127,85,111,149,144,255,255,255,255,255,224,255,255,255,255,255,224,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,47,0,0,0,0,0,26,0,0,
  // 0x30f9  ヹ
  249,48,23,24,144,26,1,255,0,0,0,0,0,96,0,0,0,0,40,180,0,0,0,0,60,60,0,0,0,0,46,44,0,0,0,0,14,0,10,170,170,170,170,144,15,255,255,255,255,240,15,255,255,255,255,240,0,0,0,0,15,192,0,0,0,0,47,128,0,0,15,192,127,0,0,0,15,129,252,0,0,0,15,135,244,0,0,0,15,130,208,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,62,170,191,234,170,184,127,255,255,255,255,252,127,255,255,255,255,252,0,0,0,0,0,0,
  // 0x30fa  ヺ
  250,48,21,26,156,26,3,253,0,0,0,0,11,0,0,0,0,7,139,128,0,0,0,3,211,192,0,0,0,1,225,64,170,170,170,170,208,0,255,255,255,255,252,0,255,255,255,255,252,0,0,0,0,1,248,0,0,0,0,2,244,0,0,0,0,2,240,0,0,0,0,3,240,0,21,85,85,87,224,0,127,255,255,255,208,0,127,255,255,255,192,0,0,0,0,15,192,0,0,0,0,47,64,0,0,0,0,127,0,0,0,0,0,252,0,0,0,0,3,244,0,0,0,0,31,224,0,0,0,0,191,128,0,0,0,7,254,0,0,0,1,191,244,0,0,0,3,255,128,0,0,0,0,248,0,0,0,0,0,0,0,0,0,0,
  // 0x30fb  ・
  251,48,6,7,14,26,10,6,47,128,191,224,255,240,255,240,191,224,47,128,0,0,
  // 0x30fc  ー
  252,48,22,4,24,26,2,8,127,255,255,255,255,208,127,255,255,255,255,208,127,255,255,255,255,208,0,0,0,0,0,0,
  // 0x30fd  ヽ
  253,48,13,13,52,26,7,3,8,0,0,0,127,0,0,0,63,192,0,0,15,240,0,0,3,252,0,0,0,255,0,0,0,63,192,0,0,15,240,0,0,7,248,0,0,1,253,0,0,0,191,64,0,0,63,64,0,0,8,0,
  // 0x30fe  ヾ
  254,48,14,17,68,26,7,2,0,0,7,0,0,2,139,128,0,3,195,208,0,1,241,240,56,0,244,128,255,0,96,0,127,192,0,0,31,240,0,0,7,248,0,0,1,254,0,0,0,127,128,0,0,31,208,0,0,11,244,0,0,3,252,0,0,0,255,0,0,0,124,0,0,0,16,0,
  // 0x30ff  ヿ
  255,48,16,23,92,26,5,254,85,85,85,85,255,255,255,254,255,255,255,254,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,41,
  // 0x4eee  仮
  238,78,24,25,150,26,1,253,0,31,0,0,0,0,0,63,47,255,255,253,0,61,47,255,255,253,0,252,47,85,85,84,1,244,47,0,0,0,3,240,47,0,0,0,11,224,47,0,0,0,31,224,47,0,0,0,127,224,47,255,255,248,255,224,47,255,255,252,246,224,47,244,0,248,162,224,47,244,0,244,2,224,46,188,1,240,2,224,62,60,3,224,2,224,62,62,7,208,2,224,61,31,79,192,2,224,60,11,239,64,2,224,124,3,254,0,2,224,188,2,252,0,2,224,248,3,254,0,2,225,240,31,255,192,2,227,240,191,75,248,2,231,215,253,2,255,2,226,194,224,0,45,0,64,0,0,0,0,
  // 0x540d  名
  13,84,22,26,156,26,1,253,0,0,80,0,0,0,0,0,252,0,0,0,0,2,244,0,0,0,0,11,255,255,244,0,0,31,255,255,244,0,0,127,0,3,240,0,2,252,0,7,208,0,11,253,0,15,192,0,127,255,64,47,64,0,190,31,224,126,0,0,36,3,249,252,0,0,0,0,255,240,0,0,0,0,127,192,0,0,0,0,191,128,0,0,0,7,255,255,255,240,0,47,255,255,255,240,2,255,224,0,1,240,127,251,224,0,1,240,191,194,224,0,1,240,56,2,224,0,1,240,0,2,224,0,1,240,0,2,224,0,1,240,0,2,255,255,255,240,0,2,255,255,255,240,0,2,240,0,2,240,0,0,64,0,0,80,
  // 0x5b9a  定
  154,91,24,25,150,26,1,253,0,0,7,192,0,0,0,0,7,192,0,0,5,85,91,213,85,80,63,255,255,255,255,252,63,255,255,255,255,252,62,0,0,0,0,188,62,0,0,0,0,188,62,21,85,85,84,188,61,127,255,255,253,188,0,127,255,255,253,0,0,0,7,192,0,0,0,0,7,192,0,0,0,124,7,192,0,0,0,188,7,192,0,0,0,248,7,255,255,128,0,248,7,255,255,128,1,252,7,213,85,0,2,253,7,192,0,0,3,255,7,192,0,0,11,223,199,192,0,0,15,135,251,192,0,0,63,65,255,233,85,85,254,0,47,255,255,253,120,0,1,191,255,252,0,0,0,0,0,0,
  // 0x7247  片
  71,114,23,26,156,26,1,253,0,0,0,20,0,0,1,160,0,62,0,0,1,240,0,62,0,0,1,240,0,62,0,0,1,240,0,62,0,0,1,240,0,62,0,0,1,240,0,62,0,0,1,249,85,127,85,80,1,255,255,255,255,244,1,255,255,255,255,244,1,240,0,0,0,0,1,240,0,0,0,0,2,240,0,0,0,0,2,240,0,0,0,0,2,255,255,255,248,0,3,255,255,255,248,0,3,250,170,170,248,0,3,224,0,0,248,0,7,208,0,0,248,0,15,192,0,0,248,0,15,128,0,0,248,0,47,64,0,0,248,0,127,0,0,0,248,0,253,0,0,0,248,0,56,0,0,0,248,0,0,0,0,0,84,0,
  // 0x793a  示
  58,121,24,24,144,26,1,253,1,85,85,85,85,64,3,255,255,255,255,192,3,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,253,127,255,255,255,255,253,21,85,91,229,85,84,0,0,3,208,0,0,0,0,3,208,0,0,0,184,3,208,45,0,0,252,3,208,63,0,1,244,3,208,31,128,3,240,3,208,15,192,11,208,3,208,3,224,15,192,3,208,2,240,63,0,3,208,0,248,254,0,3,208,0,252,40,0,7,208,0,120,0,11,255,192,0,0,0,3,255,128,0,0,0,2,148,0,0,0,
  // 0x7fa9  義
  169,127,24,26,156,26,1,253,0,0,0,0,64,0,0,31,64,1,248,0,0,15,192,3,240,0,31,255,255,255,255,244,31,255,255,255,255,244,0,0,7,192,0,0,2,170,175,250,170,128,3,255,255,255,255,192,0,0,7,192,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,86,188,0,4,0,63,255,254,60,63,64,42,111,144,61,31,224,0,15,0,61,1,208,127,255,255,255,255,254,127,255,255,255,255,254,0,15,0,15,131,144,111,255,255,75,223,192,127,255,255,67,255,0,0,15,0,7,252,13,0,15,1,191,253,15,7,255,15,253,63,254,3,253,11,144,11,252,0,0,0,0,0,0,
  // 0x8868  表
  104,136,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,31,255,255,255,255,244,31,255,255,255,255,244,0,0,7,192,0,0,0,0,7,192,0,0,3,255,255,255,255,208,3,255,255,255,255,208,0,0,7,192,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,191,248,0,0,0,3,248,124,0,240,0,47,208,62,7,244,6,255,128,47,47,192,191,255,128,15,254,0,191,79,128,7,240,0,36,15,128,3,244,0,0,15,128,20,253,0,0,15,171,252,127,128,0,111,255,248,15,248,7,255,249,0,3,255,3,249,0,0,0,124,0,0,0,0,0,0,
};

#endif // HAS_GRAPHICAL_TFT
