/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Greek 26pt, capital 'A' height: 19px, width: 100%, range: 0x0386-0x03ce, glyphs: 63
extern const uint8_t NotoSans_Medium_Greek_19[5416] = {
  130,19,134,3,206,3,25,249, // unifont_t
  // 0x0386  Ά
  19,19,95,19,0,0,0,0,42,0,0,47,64,127,64,0,63,0,191,192,0,124,0,251,192,0,184,1,243,224,0,16,3,242,240,0,0,3,225,244,0,0,11,192,252,0,0,15,192,188,0,0,31,64,62,0,0,47,0,63,0,0,63,255,255,64,0,127,255,255,128,0,254,170,175,192,0,248,0,11,208,2,244,0,3,240,3,240,0,3,240,7,224,0,1,248,11,192,0,0,252,
  // 0x0387  ·
  255,
  // 0x0388  Έ
  18,19,95,19,0,0,0,1,170,170,144,47,67,255,255,224,63,3,255,255,224,124,3,240,0,0,184,3,240,0,0,16,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,255,255,192,0,3,255,255,192,0,3,250,170,128,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,245,85,80,0,3,255,255,224,0,3,255,255,224,
  // 0x0389  Ή
  22,19,114,24,0,0,0,1,160,0,2,144,47,67,240,0,3,224,63,3,240,0,3,224,124,3,240,0,3,224,184,3,240,0,3,224,16,3,240,0,3,224,0,3,240,0,3,224,0,3,240,0,3,224,0,3,255,255,255,224,0,3,255,255,255,224,0,3,250,170,171,224,0,3,240,0,3,224,0,3,240,0,3,224,0,3,240,0,3,224,0,3,240,0,3,224,0,3,240,0,3,224,0,3,240,0,3,224,0,3,240,0,3,224,0,3,240,0,3,224,
  // 0x038a  Ί
  14,19,76,14,0,0,0,6,170,128,47,79,255,208,63,1,254,64,124,0,189,0,184,0,189,0,16,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,11,255,208,0,15,255,208,
  // 0x038b  ΋
  255,
  // 0x038c  Ό
  23,20,120,24,0,255,0,0,6,254,64,0,47,64,127,255,248,0,63,2,255,171,254,0,124,7,244,0,63,128,184,15,208,0,15,192,16,31,192,0,7,224,0,47,64,0,3,240,0,63,0,0,3,240,0,63,0,0,2,240,0,63,0,0,2,244,0,63,0,0,2,240,0,63,0,0,3,240,0,47,64,0,3,240,0,31,128,0,7,224,0,15,192,0,15,208,0,11,240,0,47,192,0,3,253,1,255,0,0,0,255,255,252,0,0,0,31,255,224,0,0,0,0,16,0,0,
  // 0x038d  ΍
  255,
  // 0x038e  Ύ
  21,19,114,21,0,0,0,6,128,0,10,128,47,71,224,0,31,128,63,3,240,0,63,0,124,1,248,0,126,0,184,0,252,0,252,0,16,0,62,1,244,0,0,0,47,3,240,0,0,0,15,203,208,0,0,0,11,223,192,0,0,0,3,255,64,0,0,0,2,254,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,252,0,0,
  // 0x038f  Ώ
  22,19,114,23,0,0,0,0,10,254,64,0,47,64,191,255,240,0,63,3,255,171,253,0,124,15,240,0,191,0,184,31,192,0,47,192,16,63,64,0,15,192,0,63,0,0,11,224,0,126,0,0,7,224,0,126,0,0,3,240,0,126,0,0,3,224,0,126,0,0,7,224,0,63,0,0,7,208,0,47,0,0,15,192,0,31,128,0,15,128,0,11,192,0,63,0,0,2,240,0,188,0,0,21,253,3,249,80,0,191,254,3,255,240,0,191,254,3,255,240,
  // 0x0390  ΐ
  255,
  // 0x0391  Α
  17,19,95,17,0,0,0,2,160,0,0,0,7,244,0,0,0,15,252,0,0,0,15,188,0,0,0,47,62,0,0,0,62,47,0,0,0,125,31,64,0,0,188,15,128,0,0,248,11,192,0,1,244,7,208,0,3,240,3,240,0,3,255,255,240,0,11,255,255,248,0,15,234,170,252,0,31,128,0,189,0,47,0,0,126,0,63,0,0,63,0,125,0,0,47,64,252,0,0,15,192,
  // 0x0392  Β
  14,19,76,17,2,0,106,169,64,0,191,255,253,0,191,255,255,64,189,0,47,192,189,0,15,192,189,0,15,192,189,0,15,192,189,0,47,64,191,255,253,0,191,255,248,0,190,86,191,64,189,0,15,192,189,0,7,224,189,0,7,224,189,0,7,224,189,0,15,208,190,85,191,192,191,255,255,0,191,255,228,0,
  // 0x0393  Γ
  11,19,57,13,2,0,106,170,160,191,255,244,191,255,244,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,
  // 0x0394  Δ
  17,19,95,17,0,0,0,2,160,0,0,0,7,244,0,0,0,15,248,0,0,0,31,188,0,0,0,47,61,0,0,0,62,47,0,0,0,124,31,64,0,0,252,15,128,0,0,244,11,192,0,2,240,7,208,0,3,224,3,240,0,7,208,2,240,0,15,192,0,248,0,15,128,0,252,0,47,0,0,125,0,63,0,0,63,0,127,85,85,127,0,191,255,255,255,128,191,255,255,255,128,
  // 0x0395  Ε
  11,19,57,14,2,0,106,170,168,191,255,252,191,255,252,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,191,255,244,191,255,244,190,170,160,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,190,85,84,191,255,252,191,255,252,
  // 0x0396  Ζ
  13,19,76,15,1,0,106,170,170,64,255,255,255,192,191,255,255,128,0,0,63,0,0,0,189,0,0,1,248,0,0,3,240,0,0,11,208,0,0,31,128,0,0,63,0,0,0,189,0,0,1,248,0,0,3,240,0,0,11,208,0,0,31,128,0,0,63,0,0,0,254,85,85,64,255,255,255,192,255,255,255,192,
  // 0x0397  Η
  15,19,76,19,2,0,104,0,0,104,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,191,255,255,252,191,255,255,252,190,170,170,252,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,
  // 0x0398  Θ
  18,20,100,20,1,255,0,10,254,64,0,0,191,255,244,0,3,255,171,253,0,15,240,0,127,0,31,192,0,31,128,63,64,0,15,192,63,0,0,11,208,126,0,0,7,224,126,26,170,131,224,126,47,255,195,240,126,31,255,131,240,126,0,0,3,224,63,0,0,7,224,63,0,0,11,208,47,128,0,15,192,15,208,0,63,64,7,249,2,254,0,1,255,255,248,0,0,47,255,208,0,0,0,0,0,0,
  // 0x0399  Ι
  7,19,38,9,1,0,170,168,255,252,47,228,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,255,252,255,252,
  // 0x039a  Κ
  14,19,76,16,2,0,104,0,2,160,189,0,15,208,189,0,63,64,189,0,190,0,189,1,248,0,189,7,240,0,189,15,192,0,189,63,0,0,189,253,0,0,191,255,0,0,191,255,64,0,191,15,192,0,189,7,240,0,189,2,248,0,189,0,253,0,189,0,127,0,189,0,47,128,189,0,15,208,189,0,3,240,
  // 0x039b  Λ
  16,19,76,16,0,0,0,6,144,0,0,11,240,0,0,15,244,0,0,31,184,0,0,62,124,0,0,61,61,0,0,188,63,0,0,252,31,0,0,244,15,128,2,240,15,192,3,240,7,192,7,208,3,224,11,192,3,240,15,192,1,244,31,64,0,248,47,0,0,252,62,0,0,125,125,0,0,62,252,0,0,63,
  // 0x039c  Μ
  20,19,95,24,2,0,106,64,0,1,168,191,192,0,3,253,191,192,0,7,253,191,224,0,11,253,190,240,0,15,125,189,244,0,31,125,188,248,0,62,125,188,188,0,60,125,188,61,0,188,125,188,62,0,244,125,188,31,1,240,125,188,15,66,224,125,188,15,195,208,125,188,7,199,192,125,188,3,223,128,125,188,2,255,64,125,188,1,255,0,125,188,0,254,0,125,188,0,188,0,125,
  // 0x039d  Ν
  16,19,76,20,2,0,106,0,0,41,191,128,0,62,191,192,0,62,191,240,0,62,191,244,0,62,188,252,0,62,188,190,0,62,188,63,64,62,188,31,192,62,188,11,224,62,188,3,240,62,188,1,252,62,188,0,253,62,188,0,63,62,188,0,47,190,188,0,15,254,188,0,7,254,188,0,2,254,188,0,0,254,
  // 0x039e  Ξ
  14,19,76,16,1,0,42,170,170,128,63,255,255,192,63,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,0,15,255,255,0,6,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,85,85,80,127,255,255,224,127,255,255,224,
  // 0x039f  Ο
  18,20,100,20,1,255,0,10,254,64,0,0,191,255,244,0,3,255,171,253,0,15,240,0,127,0,31,192,0,31,128,63,64,0,15,192,63,0,0,11,208,126,0,0,7,224,126,0,0,3,224,126,0,0,3,240,126,0,0,3,240,126,0,0,3,224,63,0,0,7,224,63,0,0,11,208,47,128,0,15,192,15,208,0,63,64,7,249,2,254,0,1,255,255,248,0,0,47,255,208,0,0,0,0,0,0,
  // 0x03a0  Π
  15,19,76,19,2,0,106,170,170,164,191,255,255,248,191,255,255,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,
  // 0x03a1  Ρ
  13,19,76,16,2,0,106,169,64,0,191,255,244,0,191,255,253,0,189,0,191,0,189,0,47,64,189,0,31,128,189,0,31,128,189,0,47,64,189,0,63,0,190,91,254,0,191,255,248,0,191,255,128,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,
  // 0x03a2  ΢
  255,
  // 0x03a3  Σ
  13,19,76,15,1,0,106,170,170,64,255,255,255,128,255,255,255,128,63,0,0,0,31,192,0,0,7,240,0,0,2,252,0,0,0,190,0,0,0,63,64,0,0,31,128,0,0,63,0,0,0,252,0,0,2,244,0,0,7,224,0,0,31,128,0,0,63,0,0,0,254,85,85,64,255,255,255,192,255,255,255,192,
  // 0x03a4  Τ
  15,19,76,15,0,0,106,170,170,160,191,255,255,244,191,255,255,240,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,
  // 0x03a5  Υ
  15,19,76,15,0,0,104,0,0,168,126,0,1,248,63,0,3,240,31,128,7,208,15,192,15,192,7,224,47,64,2,240,63,0,0,248,189,0,0,189,252,0,0,63,240,0,0,47,224,0,0,15,192,0,0,15,192,0,0,15,192,0,0,15,192,0,0,15,192,0,0,15,192,0,0,15,192,0,0,15,192,0,
  // 0x03a6  Φ
  20,20,100,22,1,255,0,0,41,0,0,0,0,62,0,0,0,26,255,164,0,2,255,255,255,192,15,254,191,175,244,47,192,62,2,252,63,0,62,0,126,125,0,62,0,63,188,0,62,0,63,188,0,62,0,47,188,0,62,0,63,125,0,62,0,63,63,0,62,0,189,31,208,62,2,252,11,254,191,191,240,1,255,255,255,128,0,6,191,148,0,0,0,62,0,0,0,0,62,0,0,0,0,0,0,0,
  // 0x03a7  Χ
  16,19,76,16,0,0,41,0,0,104,63,0,1,248,15,192,3,240,11,208,11,208,3,240,15,128,1,248,63,0,0,189,125,0,0,63,252,0,0,31,240,0,0,15,224,0,0,31,244,0,0,62,252,0,0,252,126,0,1,244,63,0,3,240,15,192,11,192,11,224,31,128,3,240,63,0,1,252,189,0,0,189,
  // 0x03a8  Ψ
  18,19,95,22,2,0,104,0,160,2,144,188,1,240,7,208,188,1,240,7,208,188,1,240,7,208,188,1,240,7,208,188,1,240,7,208,188,1,240,7,208,188,1,240,7,208,189,1,240,11,208,126,1,240,15,192,63,1,240,31,128,31,230,245,191,0,7,255,255,252,0,0,191,255,208,0,0,2,244,0,0,0,1,240,0,0,0,1,240,0,0,0,1,240,0,0,0,1,240,0,0,
  // 0x03a9  Ω
  19,19,95,19,0,0,0,6,254,64,0,0,127,255,244,0,2,255,171,254,0,7,244,0,127,64,15,192,0,15,192,47,128,0,11,224,63,0,0,3,240,63,0,0,3,240,63,0,0,3,240,63,0,0,3,240,63,0,0,3,240,63,0,0,3,224,31,64,0,7,208,15,192,0,15,192,7,224,0,47,64,1,244,0,125,0,21,254,2,249,80,127,255,3,255,244,127,255,3,255,244,
  // 0x03aa  Ϊ
  255,
  // 0x03ab  Ϋ
  255,
  // 0x03ac  ά
  15,21,84,16,1,255,0,3,240,0,0,7,224,0,0,11,192,0,0,15,64,0,0,4,0,0,0,0,0,0,2,255,135,192,15,255,251,192,47,128,127,192,63,0,31,192,126,0,15,192,189,0,15,192,188,0,11,192,188,0,11,192,189,0,15,192,125,0,15,192,63,0,31,192,47,128,127,208,15,255,247,252,2,255,130,252,0,0,0,0,
  // 0x03ad  έ
  11,21,63,12,1,255,0,15,208,0,15,192,0,31,0,0,46,0,0,4,0,0,16,0,11,255,224,47,255,244,63,0,96,125,0,0,62,0,0,47,149,0,7,255,0,47,255,0,126,0,0,252,0,0,252,0,0,190,0,36,63,255,244,11,255,240,0,0,0,
  // 0x03ae  ή
  12,27,81,16,2,249,0,63,0,0,126,0,0,188,0,0,244,0,0,64,0,0,1,0,244,191,244,251,255,252,255,128,190,254,0,63,252,0,63,252,0,47,252,0,47,252,0,47,252,0,47,252,0,47,252,0,47,252,0,47,252,0,47,252,0,47,0,0,47,0,0,47,0,0,47,0,0,47,0,0,47,0,0,47,0,0,0,
  // 0x03af  ί
  7,21,42,9,2,255,15,192,31,128,47,0,61,0,16,0,0,0,252,0,252,0,252,0,252,0,252,0,252,0,252,0,252,0,252,0,252,0,252,0,189,0,63,248,31,244,0,0,
  // 0x03b0  ΰ
  255,
  // 0x03b1  α
  15,15,60,16,1,255,2,255,135,192,15,255,251,192,47,128,127,192,63,0,31,192,126,0,15,192,189,0,15,192,188,0,11,192,188,0,11,192,189,0,15,192,125,0,15,192,63,0,31,192,47,128,127,208,15,255,247,252,2,255,130,252,0,0,0,0,
  // 0x03b2  β
  13,27,108,16,2,249,1,191,128,0,15,255,244,0,63,214,252,0,126,0,190,0,188,0,63,0,252,0,63,0,252,0,62,0,252,0,188,0,252,23,244,0,252,127,128,0,252,107,248,0,252,0,127,0,252,0,47,64,252,0,15,128,252,0,15,128,252,0,15,128,252,0,47,64,254,64,191,0,255,255,253,0,254,255,224,0,252,4,0,0,252,0,0,0,252,0,0,0,252,0,0,0,252,0,0,0,252,0,0,0,0,0,0,0,
  // 0x03b3  γ
  13,20,80,14,0,250,252,0,15,192,125,0,15,192,62,0,15,192,63,0,15,192,31,64,15,128,15,128,31,64,11,192,47,0,7,208,63,0,3,224,125,0,2,240,252,0,1,245,244,0,0,255,224,0,0,191,192,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,21,0,0,
  // 0x03b4  δ
  13,21,84,15,1,255,0,47,228,0,2,255,255,0,7,245,111,0,11,192,2,0,11,192,0,0,7,224,0,0,3,253,0,0,0,191,128,0,2,255,244,0,15,225,253,0,63,64,63,0,125,0,31,128,188,0,15,192,252,0,11,192,252,0,11,192,188,0,15,192,126,0,31,128,63,128,127,0,15,255,253,0,2,255,224,0,0,0,0,0,
  // 0x03b5  ε
  11,16,48,12,1,255,0,16,0,11,255,224,47,255,244,63,0,96,125,0,0,62,0,0,47,149,0,7,255,0,47,255,0,126,0,0,252,0,0,252,0,0,190,0,36,63,255,244,11,255,240,0,0,0,
  // 0x03b6  ζ
  11,26,78,12,1,250,47,255,252,63,255,252,21,85,248,0,3,240,0,15,192,0,47,64,0,126,0,0,252,0,3,240,0,11,208,0,15,128,0,63,0,0,62,0,0,125,0,0,188,0,0,189,0,0,127,0,0,63,224,0,15,255,144,1,255,244,0,7,252,0,0,252,0,0,252,0,0,248,0,1,240,0,0,64,
  // 0x03b7  η
  12,22,66,16,2,249,0,1,0,244,191,244,251,255,252,255,128,190,254,0,63,252,0,63,252,0,47,252,0,47,252,0,47,252,0,47,252,0,47,252,0,47,252,0,47,252,0,47,252,0,47,0,0,47,0,0,47,0,0,47,0,0,47,0,0,47,0,0,47,0,0,0,
  // 0x03b8  θ
  13,21,84,16,1,255,0,191,128,0,3,255,248,0,15,229,253,0,47,64,63,0,63,0,31,64,62,0,15,128,125,0,15,192,124,0,11,192,188,0,11,192,191,255,255,192,191,255,255,192,188,0,11,192,188,0,11,192,125,0,11,192,61,0,15,192,62,0,15,128,47,0,47,0,15,192,127,0,7,255,252,0,1,255,224,0,0,0,0,0,
  // 0x03b9  ι
  7,15,30,9,2,255,252,0,252,0,252,0,252,0,252,0,252,0,252,0,252,0,252,0,252,0,252,0,189,0,63,248,31,244,0,0,
  // 0x03ba  κ
  12,14,42,15,2,0,252,0,190,252,1,248,252,7,240,252,15,192,252,63,0,252,253,0,254,252,0,255,254,0,255,63,64,252,15,192,252,7,240,252,2,248,252,0,253,252,0,63,
  // 0x03bb  λ
  14,21,84,14,0,255,190,64,0,0,255,224,0,0,87,248,0,0,0,252,0,0,0,125,0,0,0,63,0,0,0,63,0,0,0,127,128,0,0,191,192,0,0,247,208,0,1,243,224,0,2,242,240,0,3,209,244,0,7,192,252,0,15,192,188,0,15,128,62,0,47,0,63,0,63,0,47,128,126,0,15,240,189,0,11,240,0,0,0,0,
  // 0x03bc  μ
  14,21,84,17,2,249,252,0,47,0,252,0,47,0,252,0,47,0,252,0,47,0,252,0,47,0,252,0,47,0,252,0,47,0,252,0,47,0,252,0,47,0,252,0,63,0,253,0,127,0,255,65,255,64,255,255,223,240,254,255,75,240,252,0,0,0,252,0,0,0,252,0,0,0,252,0,0,0,252,0,0,0,252,0,0,0,0,0,0,0,
  // 0x03bd  ν
  13,14,56,14,0,0,252,0,15,192,125,0,15,192,62,0,15,192,63,0,15,192,31,64,15,128,15,128,31,64,11,192,47,0,7,208,63,0,3,224,125,0,2,240,252,0,1,245,244,0,0,255,240,0,0,191,192,0,0,63,0,0,
  // 0x03be  ξ
  11,26,78,13,1,250,47,255,252,63,255,252,22,249,64,11,192,0,31,0,0,47,0,0,47,0,0,31,128,0,15,249,84,1,255,252,7,254,168,47,128,0,62,0,0,125,0,0,188,0,0,189,0,0,127,0,0,63,224,0,15,255,144,1,255,248,0,6,252,0,0,252,0,0,188,0,0,248,0,1,244,0,0,64,
  // 0x03bf  ο
  14,15,60,16,1,255,1,255,244,0,11,255,253,0,47,208,127,64,63,0,15,192,126,0,11,192,189,0,7,208,188,0,7,208,188,0,7,208,125,0,7,208,126,0,11,192,63,0,15,192,31,208,127,64,11,255,254,0,1,255,244,0,0,0,0,0,
  // 0x03c0  π
  17,15,75,18,0,255,191,255,255,255,192,191,255,255,255,192,2,240,2,244,0,2,240,1,244,0,2,240,1,244,0,2,240,1,244,0,2,240,1,244,0,2,240,1,244,0,2,240,1,244,0,2,240,1,244,0,2,240,1,244,0,2,240,1,248,0,2,240,0,255,128,2,240,0,127,128,0,0,0,0,0,
  // 0x03c1  ρ
  13,21,84,16,2,249,7,255,208,0,31,255,244,0,127,65,252,0,188,0,126,0,252,0,63,0,248,0,47,0,248,0,31,64,248,0,31,64,248,0,47,0,248,0,63,0,248,0,62,0,254,1,252,0,255,255,244,0,250,255,208,0,244,0,0,0,248,0,0,0,248,0,0,0,248,0,0,0,248,0,0,0,248,0,0,0,0,0,0,0,
  // 0x03c2  ς
  11,20,60,13,1,250,1,255,244,11,255,248,47,208,96,63,0,0,126,0,0,189,0,0,188,0,0,188,0,0,189,0,0,126,0,0,63,64,0,31,228,0,11,255,128,1,255,244,0,7,252,0,0,252,0,0,252,0,0,248,0,1,240,0,0,64,
  // 0x03c3  σ
  15,15,60,16,1,255,0,127,255,244,7,255,255,244,31,224,62,0,63,0,31,64,126,0,15,128,125,0,11,192,188,0,11,192,188,0,11,192,189,0,11,192,126,0,15,192,63,0,31,128,47,192,127,0,11,255,253,0,1,255,224,0,0,0,0,0,
  // 0x03c4  τ
  13,15,60,13,0,255,191,255,255,64,191,255,255,64,0,252,0,0,0,252,0,0,0,252,0,0,0,252,0,0,0,252,0,0,0,252,0,0,0,252,0,0,0,252,0,0,0,252,0,0,0,190,0,0,0,63,253,0,0,31,253,0,0,0,64,0,
  // 0x03c5  υ
  12,15,45,16,2,255,252,0,125,252,0,62,252,0,63,252,0,63,252,0,47,252,0,47,252,0,47,252,0,47,252,0,63,252,0,63,188,0,189,127,1,252,63,255,244,11,255,128,0,0,0,
  // 0x03c6  φ
  17,27,135,20,1,249,0,1,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,191,255,128,0,7,255,255,248,0,31,210,241,254,0,63,66,240,47,64,126,2,240,15,192,189,2,240,15,192,188,2,240,11,192,188,2,240,11,192,125,2,240,15,192,62,2,240,15,192,63,66,240,47,64,15,210,241,254,0,3,255,255,248,0,0,127,255,144,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,0,0,0,0,
  // 0x03c7  χ
  16,21,84,16,0,249,127,0,0,188,127,192,0,248,11,224,2,240,3,240,3,208,1,248,15,192,0,252,31,64,0,125,63,0,0,63,124,0,0,31,248,0,0,15,240,0,0,11,224,0,0,15,240,0,0,47,244,0,0,125,252,0,0,248,125,0,2,240,63,0,3,224,31,64,15,192,15,208,31,64,7,254,62,0,2,254,0,0,0,0,
  // 0x03c8  ψ
  17,27,135,20,2,249,0,3,208,0,0,0,7,208,0,0,0,7,208,0,0,0,7,208,0,0,0,7,208,0,0,0,7,208,0,0,248,7,208,62,0,248,7,208,63,0,248,7,208,47,0,248,7,208,31,0,248,7,208,31,0,248,7,208,31,64,248,7,208,31,64,248,7,208,31,64,252,7,208,31,0,252,7,208,47,0,125,7,208,126,0,63,135,210,252,0,15,255,255,240,0,2,255,255,128,0,0,7,208,0,0,0,7,208,0,0,0,7,208,0,0,0,7,208,0,0,0,7,208,0,0,0,7,208,0,0,0,0,0,0,0,
  // 0x03c9  ω
  19,15,75,21,1,255,7,208,0,15,128,15,128,0,7,208,47,0,0,3,240,63,0,0,1,240,62,0,20,0,244,125,0,188,0,248,125,0,188,0,248,125,0,188,0,248,125,0,188,0,248,62,0,188,0,244,63,0,253,2,240,31,130,239,7,240,15,255,207,255,192,2,255,67,255,0,0,0,0,0,0,
  // 0x03ca  ϊ
  255,
  // 0x03cb  ϋ
  255,
  // 0x03cc  ό
  14,21,84,16,1,255,0,2,244,0,0,3,240,0,0,7,192,0,0,11,128,0,0,1,0,0,0,0,0,0,1,255,244,0,11,255,253,0,47,208,127,64,63,0,15,192,126,0,11,192,189,0,7,208,188,0,7,208,188,0,7,208,125,0,7,208,126,0,11,192,63,0,15,192,31,208,127,64,11,255,254,0,1,255,244,0,0,0,0,0,
  // 0x03cd  ύ
  12,21,63,16,2,255,0,15,192,0,31,64,0,47,0,0,60,0,0,16,0,0,0,0,252,0,125,252,0,62,252,0,63,252,0,63,252,0,47,252,0,47,252,0,47,252,0,47,252,0,63,252,0,63,188,0,189,127,1,252,63,255,244,11,255,128,0,0,0,
  // 0x03ce  ώ
  19,21,105,21,1,255,0,0,15,192,0,0,0,31,128,0,0,0,47,0,0,0,0,61,0,0,0,0,16,0,0,0,0,0,0,0,7,208,0,15,128,15,128,0,7,208,47,0,0,3,240,63,0,0,1,240,62,0,20,0,244,125,0,188,0,248,125,0,188,0,248,125,0,188,0,248,125,0,188,0,248,62,0,188,0,244,63,0,253,2,240,31,130,239,7,240,15,255,207,255,192,2,255,67,255,0,0,0,0,0,0,
};

#endif // HAS_GRAPHICAL_TFT
