/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Cyrillic 26pt, capital 'A' height: 19px, width: 100%, range: 0x0401-0x0491, glyphs: 74
extern const uint8_t NotoSans_Medium_Cyrillic_19[6037] = {
  130,19,1,4,145,4,25,249, // unifont_t
  // 0x0401  Ё
  11,24,72,14,2,0,11,131,208,15,195,224,6,1,128,0,0,0,0,0,0,106,170,168,191,255,252,191,255,252,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,191,255,244,191,255,244,190,170,160,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,190,85,84,191,255,252,191,255,252,
  // 0x0402  Ђ
  255,
  // 0x0403  Ѓ
  255,
  // 0x0404  Є
  15,20,80,17,1,255,0,6,254,128,0,127,255,252,2,255,171,248,11,244,0,16,15,192,0,0,47,64,0,0,63,0,0,0,62,0,0,0,127,255,255,0,127,255,255,64,127,170,170,0,126,0,0,0,63,0,0,0,63,0,0,0,47,128,0,0,15,224,0,0,7,253,1,100,1,255,255,244,0,47,255,224,0,0,0,0,
  // 0x0405  Ѕ
  255,
  // 0x0406  І
  7,19,38,9,1,0,170,168,255,252,47,228,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,255,252,255,252,
  // 0x0407  Ї
  8,24,48,9,1,0,244,60,244,61,96,40,0,0,0,0,170,168,255,252,47,228,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,15,192,255,252,255,252,
  // 0x0408  Ј
  255,
  // 0x0409  Љ
  255,
  // 0x040a  Њ
  255,
  // 0x040b  Ћ
  255,
  // 0x040c  Ќ
  255,
  // 0x040d  Ѝ
  255,
  // 0x040e  Ў
  255,
  // 0x040f  Џ
  255,
  // 0x0410  А
  17,19,95,17,0,0,0,2,160,0,0,0,7,244,0,0,0,15,252,0,0,0,15,188,0,0,0,47,62,0,0,0,62,47,0,0,0,125,31,64,0,0,188,15,128,0,0,248,11,192,0,1,244,7,208,0,3,240,3,240,0,3,255,255,240,0,11,255,255,248,0,15,234,170,252,0,31,128,0,189,0,47,0,0,126,0,63,0,0,63,0,125,0,0,47,64,252,0,0,15,192,
  // 0x0411  Б
  13,19,76,16,2,0,106,170,169,0,191,255,254,0,191,255,254,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,191,255,144,0,191,255,252,0,190,90,255,0,189,0,47,128,189,0,15,192,189,0,15,192,189,0,15,192,189,0,47,128,190,86,255,0,191,255,253,0,191,255,144,0,
  // 0x0412  В
  14,19,76,17,2,0,106,169,64,0,191,255,253,0,191,255,255,64,189,0,47,192,189,0,15,192,189,0,15,192,189,0,15,192,189,0,47,64,191,255,253,0,191,255,248,0,190,86,191,64,189,0,15,192,189,0,7,224,189,0,7,224,189,0,7,224,189,0,15,208,190,85,191,192,191,255,255,0,191,255,228,0,
  // 0x0413  Г
  12,19,57,14,2,0,106,170,168,191,255,253,191,255,253,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,
  // 0x0414  Д
  18,25,125,19,0,250,0,6,170,169,0,0,15,255,254,0,0,15,255,254,0,0,15,128,62,0,0,15,64,62,0,0,31,64,62,0,0,47,0,62,0,0,63,0,62,0,0,62,0,62,0,0,125,0,62,0,0,252,0,62,0,0,248,0,62,0,2,244,0,62,0,3,240,0,62,0,7,224,0,62,0,15,192,0,62,0,111,213,85,191,80,255,255,255,255,240,255,255,255,255,240,252,0,0,2,240,252,0,0,2,240,252,0,0,2,240,252,0,0,2,240,252,0,0,2,240,0,0,0,0,0,
  // 0x0415  Е
  11,19,57,14,2,0,106,170,168,191,255,252,191,255,252,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,191,255,244,191,255,244,190,170,160,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,190,85,84,191,255,252,191,255,252,
  // 0x0416  Ж
  23,19,114,23,0,0,105,0,10,64,1,160,63,0,15,192,7,224,15,192,15,192,15,192,7,224,15,192,47,0,2,244,15,192,189,0,0,252,15,193,248,0,0,63,15,195,240,0,0,31,143,207,192,0,0,7,223,239,64,0,0,3,255,255,0,0,0,11,223,239,64,0,0,31,143,207,192,0,0,63,15,195,240,0,0,252,15,193,248,0,2,244,15,192,189,0,7,224,15,192,63,0,15,192,15,192,15,192,63,64,15,192,7,224,190,0,15,192,2,244,
  // 0x0417  З
  14,20,80,16,1,255,1,175,144,0,47,255,253,0,191,166,255,64,52,0,47,192,0,0,15,192,0,0,15,192,0,0,31,128,0,0,127,0,7,255,248,0,11,255,224,0,6,171,254,0,0,0,47,192,0,0,11,192,0,0,7,208,0,0,11,208,0,0,15,192,228,0,127,128,255,255,254,0,111,255,244,0,0,0,0,0,
  // 0x0418  И
  16,19,76,20,2,0,104,0,0,106,188,0,0,255,188,0,2,255,188,0,7,255,188,0,15,239,188,0,47,111,188,0,63,47,188,0,252,47,188,2,248,47,188,3,240,47,188,15,192,47,188,31,128,47,188,63,0,47,188,253,0,47,189,248,0,47,191,240,0,47,191,208,0,47,191,128,0,47,191,0,0,47,
  // 0x0419  Й
  16,25,100,20,2,0,1,80,1,80,2,240,3,224,0,248,11,192,0,191,255,64,0,6,164,0,0,0,0,0,104,0,0,106,188,0,0,255,188,0,2,255,188,0,7,255,188,0,15,239,188,0,47,111,188,0,63,47,188,0,252,47,188,2,248,47,188,3,240,47,188,15,192,47,188,31,128,47,188,63,0,47,188,253,0,47,189,248,0,47,191,240,0,47,191,208,0,47,191,128,0,47,191,0,0,47,
  // 0x041a  К
  14,19,76,16,2,0,104,0,2,144,189,0,15,192,189,0,47,64,189,0,190,0,189,1,248,0,189,7,240,0,189,15,192,0,189,63,0,0,189,253,0,0,191,248,0,0,189,253,0,0,189,63,0,0,189,31,192,0,189,7,240,0,189,2,248,0,189,0,190,0,189,0,63,64,189,0,15,192,189,0,7,240,
  // 0x041b  Л
  16,20,80,19,0,255,0,10,170,170,0,47,255,255,0,47,255,255,0,63,0,47,0,62,0,47,0,62,0,47,0,61,0,47,0,125,0,47,0,188,0,47,0,188,0,47,0,252,0,47,0,248,0,47,0,248,0,47,1,244,0,47,2,240,0,47,3,240,0,47,11,224,0,47,255,192,0,47,255,64,0,47,16,0,0,0,
  // 0x041c  М
  20,19,95,24,2,0,106,64,0,1,168,191,192,0,3,253,191,192,0,7,253,191,224,0,11,253,190,240,0,15,125,189,244,0,31,125,188,248,0,62,125,188,188,0,60,125,188,61,0,188,125,188,62,0,244,125,188,31,1,240,125,188,15,66,224,125,188,15,195,208,125,188,7,199,192,125,188,3,223,128,125,188,2,255,64,125,188,1,255,0,125,188,0,254,0,125,188,0,188,0,125,
  // 0x041d  Н
  15,19,76,19,2,0,104,0,0,104,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,191,255,255,252,191,255,255,252,190,170,170,252,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,189,0,0,252,
  // 0x041e  О
  18,20,100,20,1,255,0,10,254,64,0,0,191,255,244,0,3,255,171,253,0,15,240,0,127,0,31,192,0,31,128,63,64,0,15,192,63,0,0,11,208,126,0,0,7,224,126,0,0,3,224,126,0,0,3,240,126,0,0,3,240,126,0,0,3,224,63,0,0,7,224,63,0,0,11,208,47,128,0,15,192,15,208,0,63,64,7,249,2,254,0,1,255,255,248,0,0,47,255,208,0,0,0,0,0,0,
  // 0x041f  П
  15,19,76,19,2,0,106,170,170,164,191,255,255,248,191,255,255,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,189,0,0,248,
  // 0x0420  Р
  13,19,76,16,2,0,106,169,64,0,191,255,244,0,191,255,253,0,189,0,191,0,189,0,47,64,189,0,31,128,189,0,31,128,189,0,47,64,189,0,63,0,190,91,254,0,191,255,248,0,191,255,128,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,
  // 0x0421  С
  15,20,80,16,1,255,0,6,254,64,0,191,255,244,2,255,171,240,11,244,0,80,31,192,0,0,47,64,0,0,63,0,0,0,62,0,0,0,126,0,0,0,126,0,0,0,126,0,0,0,126,0,0,0,63,0,0,0,63,0,0,0,47,128,0,0,15,224,0,0,7,253,5,176,1,255,255,240,0,47,255,224,0,0,16,0,
  // 0x0422  Т
  15,19,76,15,0,0,106,170,170,160,191,255,255,244,191,255,255,240,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,0,15,128,0,
  // 0x0423  У
  16,20,80,17,0,255,105,0,0,26,63,0,0,63,47,64,0,126,15,192,0,188,11,208,0,248,3,240,2,244,2,244,3,240,0,252,7,208,0,189,15,192,0,62,31,128,0,47,47,0,0,15,190,0,0,11,252,0,0,3,248,0,0,3,240,0,0,11,224,0,37,111,192,0,63,255,64,0,63,252,0,0,0,0,0,0,
  // 0x0424  Ф
  19,20,100,21,1,255,0,0,188,0,0,0,0,188,0,0,0,5,254,80,0,1,255,255,254,0,11,255,255,255,192,47,208,188,11,240,63,0,188,2,244,125,0,188,0,252,188,0,188,0,252,188,0,188,0,188,188,0,188,0,252,125,0,188,0,248,63,0,188,2,244,31,208,188,31,240,11,255,255,255,192,0,191,255,253,0,0,1,253,64,0,0,0,188,0,0,0,0,188,0,0,0,0,20,0,0,
  // 0x0425  Х
  16,19,76,16,0,0,41,0,0,104,63,0,1,248,15,192,3,240,11,208,11,208,3,240,15,128,1,248,63,0,0,189,125,0,0,63,252,0,0,31,240,0,0,15,224,0,0,31,244,0,0,62,252,0,0,252,126,0,1,244,63,0,3,240,15,192,11,192,11,224,31,128,3,240,63,0,1,252,189,0,0,189,
  // 0x0426  Ц
  17,25,125,20,2,250,104,0,0,164,0,189,0,0,248,0,189,0,0,248,0,189,0,0,248,0,189,0,0,248,0,189,0,0,248,0,189,0,0,248,0,189,0,0,248,0,189,0,0,248,0,189,0,0,248,0,189,0,0,248,0,189,0,0,248,0,189,0,0,248,0,189,0,0,248,0,189,0,0,248,0,189,0,0,248,0,190,85,86,249,64,191,255,255,255,192,191,255,255,255,192,0,0,0,11,192,0,0,0,11,192,0,0,0,11,192,0,0,0,11,192,0,0,0,11,192,0,0,0,0,0,
  // 0x0427  Ч
  14,19,76,18,2,0,164,0,2,160,248,0,3,240,248,0,3,240,248,0,3,240,248,0,3,240,248,0,3,240,248,0,3,240,248,0,3,240,252,0,3,240,254,0,27,240,127,255,255,240,47,255,251,240,1,170,67,240,0,0,3,240,0,0,3,240,0,0,3,240,0,0,3,240,0,0,3,240,0,0,3,240,
  // 0x0428  Ш
  23,19,114,27,2,0,104,0,6,128,0,164,189,0,15,192,0,252,189,0,15,192,0,252,189,0,15,192,0,252,189,0,15,192,0,252,189,0,15,192,0,252,189,0,15,192,0,252,189,0,15,192,0,252,189,0,15,192,0,252,189,0,15,192,0,252,189,0,15,192,0,252,189,0,15,192,0,252,189,0,15,192,0,252,189,0,15,192,0,252,189,0,15,192,0,252,189,0,15,192,0,252,190,85,95,213,85,252,191,255,255,255,255,252,191,255,255,255,255,252,
  // 0x0429  Щ
  25,25,175,28,2,250,104,0,10,128,0,164,0,189,0,15,192,1,248,0,189,0,15,192,1,248,0,189,0,15,192,1,248,0,189,0,15,192,1,248,0,189,0,15,192,1,248,0,189,0,15,192,1,248,0,189,0,15,192,1,248,0,189,0,15,192,1,248,0,189,0,15,192,1,248,0,189,0,15,192,1,248,0,189,0,15,192,1,248,0,189,0,15,192,1,248,0,189,0,15,192,1,248,0,189,0,15,192,1,248,0,189,0,15,192,1,248,0,190,85,95,213,86,249,64,191,255,255,255,255,255,192,191,255,255,255,255,255,192,0,0,0,0,0,15,192,0,0,0,0,0,15,192,0,0,0,0,0,15,192,0,0,0,0,0,15,192,0,0,0,0,0,15,192,0,0,0,0,0,0,0,
  // 0x042a  Ъ
  17,19,95,18,0,0,106,168,0,0,0,255,253,0,0,0,191,253,0,0,0,0,125,0,0,0,0,125,0,0,0,0,125,0,0,0,0,125,0,0,0,0,125,0,0,0,0,127,255,144,0,0,127,255,252,0,0,126,90,255,0,0,125,0,47,128,0,125,0,15,192,0,125,0,15,192,0,125,0,15,192,0,125,0,47,128,0,126,86,255,0,0,127,255,253,0,0,127,255,224,0,
  // 0x042b  Ы
  18,19,95,23,2,0,104,0,0,1,160,189,0,0,2,240,189,0,0,2,240,189,0,0,2,240,189,0,0,2,240,189,0,0,2,240,189,0,0,2,240,189,0,0,2,240,191,255,144,2,240,191,255,252,2,240,190,90,255,2,240,189,0,63,66,240,189,0,31,130,240,189,0,15,130,240,189,0,31,130,240,189,0,63,66,240,190,86,255,2,240,191,255,252,2,240,191,255,144,2,240,
  // 0x042c  Ь
  14,19,76,17,2,0,104,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,189,0,0,0,191,255,160,0,191,255,253,0,190,86,255,64,189,0,31,192,189,0,11,208,189,0,11,208,189,0,11,208,189,0,31,192,190,85,191,128,191,255,254,0,191,255,224,0,
  // 0x042d  Э
  14,20,80,17,1,255,26,254,64,0,255,255,244,0,191,171,254,0,16,0,127,64,0,0,31,192,0,0,11,208,0,0,3,224,0,0,3,240,7,255,255,240,11,255,255,240,6,170,171,240,0,0,3,240,0,0,3,240,0,0,7,208,0,0,15,192,0,0,63,128,229,6,255,0,255,255,252,0,191,255,208,0,0,0,0,0,
  // 0x042e  Ю
  24,20,120,27,2,255,104,0,0,111,228,0,189,0,7,255,255,64,189,0,31,250,191,224,189,0,63,128,7,244,189,0,190,0,1,252,189,0,252,0,0,252,189,1,248,0,0,126,189,1,248,0,0,62,191,255,244,0,0,63,191,255,244,0,0,63,190,171,244,0,0,63,189,1,244,0,0,62,189,1,248,0,0,126,189,0,252,0,0,189,189,0,189,0,0,252,189,0,127,0,2,248,189,0,47,224,31,240,189,0,11,255,255,192,189,0,1,255,253,0,0,0,0,1,0,0,
  // 0x042f  Я
  15,19,76,17,0,0,0,5,170,160,0,191,255,244,3,255,255,244,11,244,1,244,15,192,1,244,15,192,1,244,15,192,1,244,15,192,1,244,7,244,1,244,2,255,255,244,0,127,255,244,0,63,86,244,0,126,1,244,0,252,1,244,2,244,1,244,7,224,1,244,15,192,1,244,47,128,1,244,127,0,1,244,
  // 0x0430  а
  12,16,48,15,1,255,0,4,0,7,255,224,15,255,252,10,0,190,0,0,63,0,0,63,0,21,191,11,255,255,63,229,127,190,0,63,252,0,63,252,0,127,190,1,255,63,255,239,31,254,31,0,0,0,
  // 0x0431  б
  14,21,84,16,1,255,0,0,26,192,0,31,255,192,1,255,255,128,7,249,64,0,15,192,0,0,47,0,0,0,63,0,0,0,62,31,244,0,125,255,255,0,191,228,127,128,191,64,15,192,189,0,11,192,189,0,11,208,189,0,7,208,126,0,11,208,63,0,11,192,47,64,15,192,15,208,127,64,7,255,254,0,1,255,244,0,0,0,0,0,
  // 0x0432  в
  12,14,42,15,2,0,255,255,224,255,255,252,252,1,254,252,0,62,252,0,62,253,86,252,255,255,224,255,255,252,252,0,127,252,0,47,252,0,63,252,0,191,255,255,252,255,255,224,
  // 0x0433  г
  9,14,42,12,2,0,255,255,192,255,255,192,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,
  // 0x0434  д
  16,19,76,16,0,251,0,63,255,192,0,63,255,192,0,61,11,192,0,125,11,192,0,124,11,192,0,188,11,192,0,248,11,192,1,244,11,192,2,240,11,192,3,224,11,192,11,192,11,192,31,192,11,208,191,255,255,253,191,255,255,253,188,0,0,125,188,0,0,125,188,0,0,125,188,0,0,125,124,0,0,124,
  // 0x0435  е
  13,15,60,15,1,255,1,255,224,0,11,255,252,0,31,128,126,0,63,0,47,0,125,0,31,64,126,85,111,128,191,255,255,128,190,170,170,64,189,0,0,0,126,0,0,0,63,0,0,0,31,208,6,0,11,255,255,0,1,255,253,0,0,1,0,0,
  // 0x0436  ж
  20,14,70,20,0,0,63,0,61,0,125,31,128,61,1,248,7,208,61,3,240,2,244,61,15,192,0,188,61,47,0,0,63,61,125,0,0,15,190,248,0,0,47,190,252,0,0,126,61,62,0,0,252,61,31,128,3,240,61,11,208,15,192,61,2,244,47,64,61,0,252,189,0,61,0,63,
  // 0x0437  з
  11,15,45,13,1,255,111,255,128,191,255,240,36,2,248,0,0,248,0,0,244,1,91,240,7,255,64,7,255,224,0,1,248,0,0,188,0,0,188,208,2,252,255,255,240,191,255,128,0,64,0,
  // 0x0438  и
  13,14,56,17,2,0,252,0,47,192,252,0,63,192,252,0,255,192,252,1,251,192,252,3,231,192,252,15,199,192,252,31,71,192,252,62,7,192,248,188,7,192,249,244,7,192,251,240,7,192,255,192,7,192,255,64,7,192,255,0,7,192,
  // 0x0439  й
  13,20,80,17,2,0,31,0,31,0,15,128,63,0,11,234,253,0,2,255,244,0,0,0,0,0,0,0,0,0,252,0,47,192,252,0,63,192,252,0,255,192,252,1,251,192,252,3,231,192,252,15,199,192,252,31,71,192,252,62,7,192,248,188,7,192,249,244,7,192,251,240,7,192,255,192,7,192,255,64,7,192,255,0,7,192,
  // 0x043a  к
  12,14,42,14,2,0,252,0,189,252,2,244,252,7,224,252,31,128,252,63,0,252,252,0,255,240,0,254,248,0,252,189,0,252,63,64,252,15,192,252,3,240,252,1,252,252,0,127,
  // 0x043b  л
  14,15,60,16,0,255,0,191,255,208,0,255,255,208,0,248,11,208,0,248,7,208,0,244,7,208,0,244,7,208,1,240,7,208,2,240,7,208,3,240,7,208,3,224,7,208,7,208,7,208,15,192,7,208,255,64,7,208,254,0,7,208,0,0,0,0,
  // 0x043c  м
  16,14,56,20,2,0,255,0,0,255,255,128,1,255,255,192,2,255,251,208,3,239,250,224,7,239,249,240,15,111,248,244,31,47,248,188,46,47,248,60,61,47,248,62,124,47,248,31,248,47,248,15,240,47,248,11,224,47,248,7,208,47,
  // 0x043d  н
  13,14,56,17,2,0,252,0,15,128,252,0,15,128,252,0,15,128,252,0,15,128,252,0,15,128,253,85,95,128,255,255,255,128,255,255,255,128,252,0,15,128,252,0,15,128,252,0,15,128,252,0,15,128,252,0,15,128,252,0,15,128,
  // 0x043e  о
  14,15,60,16,1,255,1,255,244,0,11,255,253,0,47,208,127,64,63,0,15,192,126,0,11,192,189,0,7,208,188,0,7,208,188,0,7,208,125,0,7,208,126,0,11,192,63,0,15,192,31,208,127,64,11,255,254,0,1,255,244,0,0,0,0,0,
  // 0x043f  п
  13,14,56,16,2,0,255,255,255,64,255,255,255,64,252,0,47,64,252,0,31,64,252,0,31,64,252,0,31,64,252,0,31,64,252,0,31,64,252,0,31,64,252,0,31,64,252,0,31,64,252,0,31,64,252,0,31,64,252,0,31,64,
  // 0x0440  р
  13,21,84,16,2,249,244,191,240,0,251,255,252,0,255,64,191,0,254,0,63,64,252,0,31,128,252,0,15,128,252,0,15,128,252,0,15,128,252,0,15,128,252,0,31,64,254,0,63,0,255,128,191,0,255,255,252,0,252,191,224,0,252,0,0,0,252,0,0,0,252,0,0,0,252,0,0,0,252,0,0,0,252,0,0,0,0,0,0,0,
  // 0x0441  с
  11,15,45,13,1,255,1,255,248,11,255,248,47,208,96,63,0,0,126,0,0,189,0,0,188,0,0,188,0,0,189,0,0,126,0,0,63,0,0,47,208,40,15,255,248,1,255,244,0,0,0,
  // 0x0442  т
  13,14,56,13,0,0,127,255,255,64,127,255,255,64,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,
  // 0x0443  у
  14,21,84,14,0,249,252,0,7,224,126,0,15,192,63,0,15,192,47,64,31,64,15,128,63,0,15,192,62,0,7,208,188,0,3,224,252,0,2,240,244,0,0,246,240,0,0,251,224,0,0,127,208,0,0,63,192,0,0,47,128,0,0,47,0,0,0,63,0,0,0,125,0,0,1,252,0,0,191,240,0,0,191,192,0,0,0,0,0,0,
  // 0x0444  ф
  17,27,135,20,1,249,0,1,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,191,255,128,0,7,255,255,248,0,31,226,241,254,0,63,66,240,63,64,126,2,240,15,192,189,2,240,15,192,188,2,240,11,192,188,2,240,11,192,189,2,240,15,192,62,2,240,15,192,63,66,240,63,64,15,226,241,254,0,3,255,255,248,0,0,127,255,144,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,0,0,0,0,
  // 0x0445  х
  14,14,56,14,0,0,63,0,15,192,31,128,47,64,11,208,127,0,3,240,252,0,1,250,244,0,0,191,224,0,0,63,192,0,0,63,192,0,0,255,240,0,1,249,248,0,3,240,189,0,15,192,63,0,47,64,31,128,127,0,11,208,
  // 0x0446  ц
  15,19,76,17,2,251,252,0,31,64,252,0,31,64,252,0,31,64,252,0,31,64,252,0,31,64,252,0,31,64,252,0,31,64,252,0,31,64,252,0,31,64,252,0,31,64,252,0,31,64,252,0,31,128,255,255,255,244,255,255,255,244,0,0,0,244,0,0,0,244,0,0,0,244,0,0,0,244,0,0,0,244,
  // 0x0447  ч
  12,14,42,16,2,0,248,0,47,248,0,47,248,0,47,248,0,47,248,0,47,248,0,47,252,0,191,191,175,255,47,255,111,1,80,47,0,0,47,0,0,47,0,0,47,0,0,47,
  // 0x0448  ш
  20,14,70,24,2,0,252,0,125,0,62,252,0,125,0,62,252,0,125,0,62,252,0,125,0,62,252,0,125,0,62,252,0,125,0,62,252,0,125,0,62,252,0,125,0,62,252,0,125,0,62,252,0,125,0,62,252,0,125,0,62,252,0,189,0,62,255,255,255,255,254,255,255,255,255,254,
  // 0x0449  щ
  22,19,114,24,2,251,252,0,125,0,62,0,252,0,125,0,62,0,252,0,125,0,62,0,252,0,125,0,62,0,252,0,125,0,62,0,252,0,125,0,62,0,252,0,125,0,62,0,252,0,125,0,62,0,252,0,125,0,62,0,252,0,125,0,62,0,252,0,125,0,62,0,252,0,189,0,63,0,255,255,255,255,255,224,255,255,255,255,255,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,0,0,0,0,3,224,
  // 0x044a  ъ
  17,14,70,18,0,0,191,254,0,0,0,191,254,0,0,0,0,126,0,0,0,0,62,0,0,0,0,62,0,0,0,0,62,85,64,0,0,63,255,253,0,0,63,255,255,64,0,62,0,31,192,0,62,0,15,192,0,62,0,15,192,0,62,0,111,128,0,63,255,255,0,0,63,255,244,0,
  // 0x044b  ы
  17,14,70,21,2,0,252,0,0,15,128,252,0,0,15,128,252,0,0,15,128,252,0,0,15,128,252,0,0,15,128,253,85,0,15,128,255,255,240,15,128,255,255,252,15,128,252,0,189,15,128,252,0,62,15,128,252,0,126,15,128,252,1,252,15,128,255,255,248,15,128,255,255,144,15,128,
  // 0x044c  ь
  13,14,56,16,2,0,252,0,0,0,252,0,0,0,252,0,0,0,252,0,0,0,252,0,0,0,253,85,0,0,255,255,248,0,255,255,254,0,252,0,63,0,252,0,31,64,252,0,47,64,252,0,191,0,255,255,253,0,255,255,224,0,
  // 0x044d  э
  11,15,45,13,1,255,191,253,0,191,255,192,80,15,224,0,3,240,0,1,244,0,1,248,47,255,248,47,255,248,0,1,244,0,2,244,0,3,240,144,31,208,255,255,128,191,253,0,1,0,0,
  // 0x044e  ю
  19,16,80,22,2,255,0,0,0,64,0,252,0,47,253,0,252,0,255,255,128,252,3,248,11,224,252,7,224,3,240,252,11,208,1,244,253,95,192,0,248,255,255,192,0,248,255,255,192,0,248,252,15,192,0,248,252,11,208,1,244,252,7,224,3,240,252,3,248,11,224,252,0,255,255,192,252,0,47,254,0,0,0,0,0,0,
  // 0x044f  я
  13,14,56,15,0,0,1,255,255,128,15,255,255,128,47,144,15,128,63,0,15,128,63,0,15,128,47,64,15,128,15,250,175,128,7,255,255,128,0,254,175,128,2,244,15,128,7,224,15,128,15,192,15,128,47,64,15,128,126,0,15,128,
  // 0x0450  ѐ
  255,
  // 0x0451  ё
  13,20,80,15,1,255,3,192,240,0,7,209,244,0,2,128,160,0,0,0,0,0,0,0,0,0,1,255,224,0,11,255,252,0,31,128,126,0,63,0,47,0,125,0,31,64,126,85,111,128,191,255,255,128,190,170,170,64,189,0,0,0,126,0,0,0,63,0,0,0,31,208,6,0,11,255,255,0,1,255,253,0,0,1,0,0,
  // 0x0452  ђ
  255,
  // 0x0453  ѓ
  255,
  // 0x0454  є
  11,15,45,13,1,255,1,255,248,11,255,252,47,208,20,63,0,0,126,0,0,189,0,0,191,255,224,191,255,224,189,0,0,125,0,0,63,0,0,47,192,24,11,255,252,1,255,248,0,0,0,
  // 0x0455  ѕ
  255,
  // 0x0456  і
  3,20,20,7,2,0,16,252,252,116,0,0,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
  // 0x0457  ї
  9,19,57,7,255,0,60,15,0,125,31,64,40,10,0,0,0,0,0,0,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,
  // 0x0458  ј
  255,
  // 0x0459  љ
  255,
  // 0x045a  њ
  255,
  // 0x045b  ћ
  255,
  // 0x045c  ќ
  255,
  // 0x045d  ѝ
  255,
  // 0x045e  ў
  255,
  // 0x045f  џ
  255,
  // 0x0460  Ѡ
  255,
  // 0x0461  ѡ
  255,
  // 0x0462  Ѣ
  255,
  // 0x0463  ѣ
  255,
  // 0x0464  Ѥ
  255,
  // 0x0465  ѥ
  255,
  // 0x0466  Ѧ
  255,
  // 0x0467  ѧ
  255,
  // 0x0468  Ѩ
  255,
  // 0x0469  ѩ
  255,
  // 0x046a  Ѫ
  255,
  // 0x046b  ѫ
  255,
  // 0x046c  Ѭ
  255,
  // 0x046d  ѭ
  255,
  // 0x046e  Ѯ
  255,
  // 0x046f  ѯ
  255,
  // 0x0470  Ѱ
  255,
  // 0x0471  ѱ
  255,
  // 0x0472  Ѳ
  255,
  // 0x0473  ѳ
  255,
  // 0x0474  Ѵ
  255,
  // 0x0475  ѵ
  255,
  // 0x0476  Ѷ
  255,
  // 0x0477  ѷ
  255,
  // 0x0478  Ѹ
  255,
  // 0x0479  ѹ
  255,
  // 0x047a  Ѻ
  255,
  // 0x047b  ѻ
  255,
  // 0x047c  Ѽ
  255,
  // 0x047d  ѽ
  255,
  // 0x047e  Ѿ
  255,
  // 0x047f  ѿ
  255,
  // 0x0480  Ҁ
  255,
  // 0x0481  ҁ
  255,
  // 0x0482  ҂
  255,
  // 0x0483  ҃
  255,
  // 0x0484  ҄
  255,
  // 0x0485  ҅
  255,
  // 0x0486  ҆
  255,
  // 0x0487  ҇
  255,
  // 0x0488  ҈
  255,
  // 0x0489  ҉
  255,
  // 0x048a  Ҋ
  255,
  // 0x048b  ҋ
  255,
  // 0x048c  Ҍ
  255,
  // 0x048d  ҍ
  255,
  // 0x048e  Ҏ
  255,
  // 0x048f  ҏ
  255,
  // 0x0490  Ґ
  12,23,69,14,2,0,0,0,21,0,0,62,0,0,62,0,0,62,106,170,190,191,255,254,191,255,254,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,189,0,0,
  // 0x0491  ґ
  9,18,54,12,2,0,0,7,192,0,7,192,0,7,192,0,7,192,255,255,192,255,255,192,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,
};

#endif // HAS_GRAPHICAL_TFT
