/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Vietnamese 22pt, capital 'A' height: 16px, width: 100%, range: 0x0102-0x1ef9, glyphs: 107
extern const uint8_t NotoSans_Medium_Vietnamese_16[8448] = {
  162,16,2,1,249,30,21,250, // unifont_t
  // 0x0102  Ă
  2,1,14,21,84,14,0,0,0,64,20,0,1,208,120,0,0,191,240,0,0,26,64,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x0103  ă
  3,1,10,18,54,13,1,255,4,0,64,14,7,128,11,255,0,1,164,0,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x0110  Đ
  16,1,15,16,64,16,0,0,10,170,144,0,15,255,254,0,15,149,127,192,15,128,7,224,15,128,2,240,15,128,0,244,15,128,0,248,127,255,0,188,127,255,0,188,31,149,0,248,15,128,0,248,15,128,1,240,15,128,7,224,15,128,111,192,15,255,255,0,15,255,228,0,
  // 0x0111  đ
  17,1,13,18,72,14,1,255,0,0,104,0,0,0,188,0,0,191,255,64,0,191,255,64,0,0,188,0,2,248,124,0,31,255,188,0,63,66,252,0,124,0,252,0,188,0,188,0,248,0,188,0,248,0,124,0,248,0,188,0,188,0,188,0,126,1,252,0,47,239,252,0,11,253,60,0,0,0,0,0,
  // 0x0128  Ĩ
  40,1,8,21,42,8,0,0,0,1,127,75,235,253,128,100,0,0,42,168,63,252,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,47,244,63,252,
  // 0x0129  ĩ
  41,1,8,17,34,6,255,0,0,1,127,75,247,254,128,100,0,0,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,
  // 0x0168  Ũ
  104,1,13,22,88,16,2,255,0,0,16,0,3,248,112,0,11,127,224,0,8,6,64,0,0,0,0,0,160,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,0,188,0,47,0,126,0,125,0,47,255,248,0,7,255,208,0,0,0,0,0,
  // 0x0169  ũ
  105,1,11,18,54,14,1,255,0,0,16,7,244,176,15,191,208,8,6,64,0,0,0,60,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,60,0,188,62,1,252,47,239,252,11,254,60,0,0,0,
  // 0x01a0  Ơ
  160,1,17,18,90,18,1,255,0,0,0,6,128,0,111,244,11,192,3,255,255,79,64,15,224,31,254,0,47,0,3,244,0,62,0,1,244,0,124,0,0,248,0,188,0,0,188,0,188,0,0,188,0,188,0,0,188,0,188,0,0,188,0,124,0,0,248,0,61,0,0,244,0,63,0,2,240,0,15,192,11,208,0,7,255,255,128,0,0,191,249,0,0,0,0,0,0,0,
  // 0x01a1  ơ
  161,1,14,15,60,14,1,255,0,0,2,144,0,0,3,208,2,255,71,192,31,255,255,64,62,1,253,0,124,0,188,0,184,0,124,0,248,0,60,0,248,0,60,0,184,0,60,0,124,0,188,0,62,0,248,0,31,239,240,0,7,255,128,0,0,0,0,0,
  // 0x01af  Ư
  175,1,17,18,90,18,2,255,0,0,0,10,64,160,0,10,15,0,244,0,15,111,0,244,0,15,252,0,244,0,15,224,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,0,0,188,0,47,0,0,126,0,126,0,0,47,255,252,0,0,7,255,208,0,0,0,0,0,0,0,
  // 0x01b0  ư
  176,1,15,15,60,15,1,255,0,0,0,104,0,0,0,124,60,0,124,248,124,0,127,240,124,0,127,128,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,60,0,188,0,62,1,252,0,47,239,252,0,11,254,60,0,0,0,0,0,
  // 0x0303  ̃
  3,3,8,4,8,0,245,13,0,1,63,135,183,254,144,100,
  // 0x0309  ̉
  9,3,5,5,10,0,247,13,127,64,23,192,3,192,31,0,28,0,
  // 0x0323  ̣
  35,3,3,4,4,0,248,251,96,248,244,0,
  // 0x0340  ̀
  64,3,5,4,8,0,252,13,188,0,62,0,15,64,2,128,
  // 0x0341  ́
  65,3,5,4,8,0,255,13,15,128,47,0,124,0,160,0,
  // 0x1ea0  Ạ
  160,30,14,21,84,14,0,251,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,0,0,0,0,0,6,0,0,0,15,128,0,0,15,64,0,0,0,0,0,
  // 0x1ea1  ạ
  161,30,10,17,51,13,1,251,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,0,96,0,0,248,0,0,244,0,0,0,0,
  // 0x1ea2  Ả
  162,30,14,22,88,14,0,0,0,47,128,0,0,6,208,0,0,2,208,0,0,15,128,0,0,14,0,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x1ea3  ả
  163,30,10,19,57,13,1,255,2,252,0,0,110,0,0,30,0,0,184,0,0,176,0,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x1ea4  Ấ
  164,30,14,22,88,14,0,0,0,0,1,128,0,0,7,128,0,47,206,0,0,126,224,0,0,224,116,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x1ea5  ấ
  165,30,11,19,57,13,1,255,0,0,60,0,84,116,2,253,144,11,143,0,9,2,64,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x1ea6  Ầ
  166,30,14,22,88,14,0,0,24,0,0,0,30,0,0,0,7,111,192,0,0,126,224,0,0,224,116,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x1ea7  ầ
  167,30,11,19,57,13,0,255,180,0,0,60,21,0,9,191,64,1,227,192,2,64,160,0,0,0,2,255,208,11,255,240,1,0,248,0,0,188,0,0,188,2,255,252,31,229,188,63,0,124,61,0,188,62,1,252,47,239,188,11,253,60,0,0,0,
  // 0x1ea8  Ẩ
  168,30,14,23,92,14,0,0,0,0,30,0,0,0,7,64,0,0,7,64,0,47,204,0,0,122,224,0,0,224,116,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x1ea9  ẩ
  169,30,11,20,60,13,1,255,0,0,244,0,0,44,0,84,176,2,253,80,7,143,0,9,2,128,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x1eaa  Ẫ
  170,30,14,23,92,14,0,0,0,190,40,0,0,219,240,0,0,64,64,0,0,31,128,0,0,62,224,0,0,224,116,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x1eab  ẫ
  171,30,10,21,63,13,1,255,1,64,64,15,251,128,12,47,0,0,80,0,2,252,0,7,143,0,9,2,64,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x1eac  Ậ
  172,30,14,26,104,14,0,251,0,31,128,0,0,63,208,0,0,244,244,0,1,128,40,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,0,0,0,0,0,6,0,0,0,15,128,0,0,15,64,0,0,0,0,0,
  // 0x1ead  ậ
  173,30,10,22,66,13,1,251,0,248,0,3,254,0,15,75,64,25,1,128,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,0,96,0,0,244,0,0,240,0,0,0,0,
  // 0x1eae  Ắ
  174,30,14,22,88,14,0,0,0,2,208,0,0,7,64,0,0,208,56,0,0,250,240,0,0,47,208,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x1eaf  ắ
  175,30,10,20,60,13,1,255,0,9,0,0,60,0,4,113,64,14,3,64,7,255,0,1,164,0,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x1eb0  Ằ
  176,30,14,22,88,14,0,0,0,60,0,0,0,14,0,0,0,192,52,0,0,250,240,0,0,47,208,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x1eb1  ằ
  177,30,10,20,60,13,1,255,2,64,0,2,208,0,4,161,64,14,3,64,7,255,0,1,164,0,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x1eb2  Ẳ
  178,30,14,23,92,14,0,0,0,15,64,0,0,2,128,0,0,7,64,0,0,192,52,0,0,250,240,0,0,47,208,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x1eb3  ẳ
  179,30,10,21,63,13,1,255,0,64,0,0,184,0,0,44,0,4,113,64,14,3,128,7,255,0,1,164,0,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x1eb4  Ẵ
  180,30,14,23,92,14,0,0,0,125,40,0,0,219,244,0,0,64,64,0,0,192,52,0,0,250,240,0,0,47,208,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x1eb5  ẵ
  181,30,10,21,63,13,1,255,1,64,64,11,250,128,12,47,0,4,0,0,14,3,128,7,255,0,1,164,0,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x1eb6  Ặ
  182,30,14,26,104,14,0,251,0,64,20,0,0,224,120,0,0,191,240,0,0,26,64,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,0,0,0,0,0,6,0,0,0,15,128,0,0,15,64,0,0,0,0,0,
  // 0x1eb7  ặ
  183,30,10,22,66,13,1,251,4,0,64,14,7,192,7,255,0,1,168,0,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,0,80,0,1,240,0,0,240,0,0,0,0,
  // 0x1eb8  Ẹ
  184,30,9,21,63,12,2,251,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,0,0,0,0,128,0,2,240,0,1,224,0,0,0,0,
  // 0x1eb9  ẹ
  185,30,11,17,51,13,1,251,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,0,32,0,0,188,0,0,184,0,0,0,0,
  // 0x1eba  Ẻ
  186,30,9,22,66,12,2,0,3,244,0,1,124,0,0,60,0,1,244,0,1,192,0,0,0,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x1ebb  ẻ
  187,30,11,19,57,13,1,255,0,253,0,0,95,0,0,15,0,0,61,0,0,52,0,0,0,0,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,
  // 0x1ebc  Ẽ
  188,30,9,20,60,12,2,0,47,211,128,58,255,0,96,24,0,0,0,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x1ebd  ẽ
  189,30,11,17,51,13,1,255,15,224,208,45,191,192,36,10,0,0,0,0,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,
  // 0x1ebe  Ế
  190,30,11,22,66,12,2,0,0,0,100,0,0,240,3,242,192,15,124,0,60,15,0,0,0,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x1ebf  ế
  191,30,12,19,57,13,1,255,0,0,45,0,84,120,2,253,80,7,139,64,9,1,128,0,0,0,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,
  // 0x1ec0  Ề
  192,30,11,22,66,12,0,0,100,0,0,60,0,0,10,63,64,0,247,192,2,192,240,0,0,0,10,170,168,15,255,252,15,149,84,15,64,0,15,64,0,15,64,0,15,128,0,15,255,248,15,255,244,15,64,0,15,64,0,15,64,0,15,64,0,15,64,0,15,255,252,15,255,252,
  // 0x1ec1  ề
  193,30,12,19,57,13,0,255,120,0,0,45,21,0,5,127,64,0,226,208,2,64,96,0,0,0,0,191,128,7,255,244,15,128,188,31,0,61,46,0,61,63,255,253,63,170,169,46,0,0,31,0,0,15,128,4,7,254,252,0,255,248,0,0,0,
  // 0x1ec2  Ể
  194,30,10,23,69,12,2,0,0,3,144,0,1,176,0,0,224,3,242,128,15,124,0,60,15,0,0,0,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x1ec3  ể
  195,30,11,20,60,13,1,255,0,0,244,0,0,44,0,84,180,2,253,80,7,143,0,9,2,128,0,0,0,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,
  // 0x1ec4  Ễ
  196,30,9,23,69,12,2,0,31,151,0,57,254,0,16,0,0,3,240,0,15,188,0,44,15,0,0,0,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x1ec5  ễ
  197,30,11,21,63,13,1,255,1,64,64,11,250,192,12,47,0,0,84,0,1,253,0,7,143,0,9,1,128,0,0,0,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,
  // 0x1ec6  Ệ
  198,30,9,26,78,12,2,251,2,240,0,11,252,0,31,31,0,40,2,64,0,0,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,0,0,0,0,128,0,2,240,0,1,224,0,0,0,0,
  // 0x1ec7  ệ
  199,30,11,22,66,13,1,251,0,252,0,3,254,0,11,75,64,25,1,128,0,0,0,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,0,32,0,0,188,0,0,184,0,0,0,0,
  // 0x1ec8  Ỉ
  200,30,6,22,44,8,1,0,42,64,43,192,1,208,11,192,14,0,4,0,170,160,255,240,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,191,208,255,240,
  // 0x1ec9  ỉ
  201,30,5,18,36,6,1,0,190,0,27,64,7,64,62,0,56,0,0,0,60,0,60,0,60,0,60,0,60,0,60,0,60,0,60,0,60,0,60,0,60,0,60,0,
  // 0x1eca  Ị
  202,30,6,21,42,8,1,251,170,160,255,240,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,191,208,255,240,0,0,9,0,31,0,31,0,0,0,
  // 0x1ecb  ị
  203,30,4,22,22,6,1,251,20,60,60,0,0,60,60,60,60,60,60,60,60,60,60,60,60,0,20,125,60,0,
  // 0x1ecc  Ọ
  204,30,15,21,84,17,1,251,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,0,2,64,0,0,11,192,0,0,7,128,0,0,0,0,0,
  // 0x1ecd  ọ
  205,30,11,17,51,13,1,251,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,0,36,0,0,188,0,0,120,0,0,0,0,
  // 0x1ece  Ỏ
  206,30,15,23,92,17,1,255,0,10,128,0,0,10,240,0,0,0,176,0,0,2,224,0,0,3,128,0,0,1,0,0,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x1ecf  ỏ
  207,30,11,19,57,13,1,255,0,254,0,0,95,0,0,11,0,0,61,0,0,52,0,0,0,0,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x1ed0  Ố
  208,30,15,23,92,17,1,255,0,0,0,144,0,0,3,192,0,15,219,0,0,61,240,0,0,176,60,0,0,0,0,0,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x1ed1  ố
  209,30,12,19,57,13,1,255,0,0,30,0,84,56,1,254,80,3,203,64,10,1,128,0,0,0,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x1ed2  Ồ
  210,30,15,23,92,17,1,255,9,0,0,0,15,0,0,0,2,207,208,0,0,61,240,0,0,176,44,0,0,0,0,0,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x1ed3  ồ
  211,30,11,19,57,13,1,255,224,0,0,116,84,0,25,254,0,3,203,64,6,1,128,0,0,0,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x1ed4  Ổ
  212,30,15,24,96,17,1,255,0,0,14,64,0,0,6,192,0,0,2,192,0,15,214,0,0,61,240,0,0,176,60,0,0,0,0,0,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x1ed5  ổ
  213,30,11,20,60,13,1,255,0,0,248,0,0,12,0,84,116,1,254,16,3,203,64,10,1,128,0,0,0,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x1ed6  Ỗ
  214,30,15,24,96,17,1,255,0,62,92,0,0,167,248,0,0,64,0,0,0,15,192,0,0,46,240,0,0,176,44,0,0,0,0,0,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x1ed7  ỗ
  215,30,11,21,63,13,1,255,0,64,64,7,250,192,9,31,64,0,20,0,0,254,0,3,203,64,6,1,128,0,0,0,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x1ed8  Ộ
  216,30,15,26,104,17,1,251,0,11,192,0,0,47,240,0,0,120,124,0,0,144,25,0,0,0,0,0,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,0,2,64,0,0,11,192,0,0,7,128,0,0,0,0,0,
  // 0x1ed9  ộ
  217,30,11,22,66,13,1,251,0,188,0,2,255,0,7,199,192,10,0,144,0,0,0,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,0,36,0,0,188,0,0,120,0,0,0,0,
  // 0x1eda  Ớ
  218,30,17,22,110,18,1,255,0,0,248,0,0,0,1,240,0,0,0,3,192,0,0,0,10,0,0,0,0,0,0,6,128,0,111,244,11,192,3,255,255,79,64,15,224,31,254,0,47,0,3,244,0,62,0,1,244,0,124,0,0,248,0,188,0,0,188,0,188,0,0,188,0,188,0,0,188,0,188,0,0,188,0,124,0,0,248,0,61,0,0,244,0,63,0,2,240,0,15,192,11,208,0,7,255,255,128,0,0,191,249,0,0,0,0,0,0,0,
  // 0x1edb  ớ
  219,30,14,18,72,14,1,255,0,11,192,0,0,31,0,0,0,60,0,0,0,96,2,144,0,0,3,208,2,255,71,192,31,255,255,64,62,1,253,0,124,0,188,0,184,0,124,0,248,0,60,0,248,0,60,0,184,0,60,0,124,0,188,0,62,0,248,0,31,239,240,0,7,255,128,0,0,0,0,0,
  // 0x1edc  Ờ
  220,30,17,22,110,18,1,255,0,125,0,0,0,0,47,0,0,0,0,11,128,0,0,0,1,128,0,0,0,0,0,6,128,0,111,244,11,192,3,255,255,79,64,15,224,31,254,0,47,0,3,244,0,62,0,1,244,0,124,0,0,248,0,188,0,0,188,0,188,0,0,188,0,188,0,0,188,0,188,0,0,188,0,124,0,0,248,0,61,0,0,244,0,63,0,2,240,0,15,192,11,208,0,7,255,255,128,0,0,191,249,0,0,0,0,0,0,0,
  // 0x1edd  ờ
  221,30,14,18,72,14,1,255,7,208,0,0,2,240,0,0,0,184,0,0,0,24,2,144,0,0,3,208,2,255,71,192,31,255,255,64,62,1,253,0,124,0,188,0,184,0,124,0,248,0,60,0,248,0,60,0,184,0,60,0,124,0,188,0,62,0,248,0,31,239,240,0,7,255,128,0,0,0,0,0,
  // 0x1ede  Ở
  222,30,17,23,115,18,1,255,0,15,208,0,0,0,5,240,0,0,0,0,240,0,0,0,7,208,0,0,0,7,0,0,0,0,0,0,6,128,0,111,244,11,192,3,255,255,79,64,15,224,31,254,0,47,0,3,244,0,62,0,1,244,0,124,0,0,248,0,188,0,0,188,0,188,0,0,188,0,188,0,0,188,0,188,0,0,188,0,124,0,0,248,0,61,0,0,244,0,63,0,2,240,0,15,192,11,208,0,7,255,255,128,0,0,191,249,0,0,0,0,0,0,0,
  // 0x1edf  ở
  223,30,14,19,76,14,1,255,0,253,0,0,0,95,0,0,0,15,0,0,0,125,0,0,0,112,2,144,0,0,3,208,2,255,71,192,31,255,255,64,62,1,253,0,124,0,188,0,184,0,124,0,248,0,60,0,248,0,60,0,184,0,60,0,124,0,188,0,62,0,248,0,31,239,240,0,7,255,128,0,0,0,0,0,
  // 0x1ee0  Ỡ
  224,30,17,21,105,18,1,255,0,191,78,0,0,0,235,252,0,0,1,128,96,0,0,0,0,0,6,128,0,111,244,11,192,3,255,255,79,64,15,224,31,254,0,47,0,3,244,0,62,0,1,244,0,124,0,0,248,0,188,0,0,188,0,188,0,0,188,0,188,0,0,188,0,188,0,0,188,0,124,0,0,248,0,61,0,0,244,0,63,0,2,240,0,15,192,11,208,0,7,255,255,128,0,0,191,249,0,0,0,0,0,0,0,
  // 0x1ee1  ỡ
  225,30,14,17,68,14,1,255,11,244,224,0,14,191,208,0,24,6,66,144,0,0,3,208,2,255,71,192,31,255,255,64,62,1,253,0,124,0,188,0,184,0,124,0,248,0,60,0,248,0,60,0,184,0,60,0,124,0,188,0,62,0,248,0,31,239,240,0,7,255,128,0,0,0,0,0,
  // 0x1ee2  Ợ
  226,30,17,22,110,18,1,251,0,0,0,6,128,0,111,244,11,192,3,255,255,79,64,15,224,31,254,0,47,0,3,244,0,62,0,1,244,0,124,0,0,248,0,188,0,0,188,0,188,0,0,188,0,188,0,0,188,0,188,0,0,188,0,124,0,0,248,0,61,0,0,244,0,63,0,2,240,0,15,192,11,208,0,7,255,255,128,0,0,191,249,0,0,0,0,0,0,0,0,2,0,0,0,0,11,192,0,0,0,7,128,0,0,0,0,0,0,0,
  // 0x1ee3  ợ
  227,30,14,19,76,14,1,251,0,0,2,144,0,0,3,208,2,255,71,192,31,255,255,64,62,1,253,0,124,0,188,0,184,0,124,0,248,0,60,0,248,0,60,0,184,0,60,0,124,0,188,0,62,0,248,0,31,239,240,0,7,255,128,0,0,0,0,0,0,36,0,0,0,188,0,0,0,124,0,0,0,0,0,0,
  // 0x1ee4  Ụ
  228,30,13,21,84,16,2,251,160,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,0,188,0,47,0,126,0,125,0,47,255,248,0,7,255,208,0,0,0,0,0,0,20,0,0,0,61,0,0,0,60,0,0,0,0,0,0,
  // 0x1ee5  ụ
  229,30,11,17,51,14,1,251,60,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,60,0,188,62,1,252,47,239,252,11,254,60,0,0,0,0,32,0,0,188,0,0,120,0,0,0,0,
  // 0x1ee6  Ủ
  230,30,13,23,92,16,2,255,0,105,0,0,0,111,64,0,0,7,128,0,0,31,0,0,0,60,0,0,0,20,0,0,160,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,0,188,0,47,0,126,0,125,0,47,255,248,0,7,255,208,0,0,0,0,0,
  // 0x1ee7  ủ
  231,30,11,19,57,14,1,255,0,254,0,0,95,0,0,11,0,0,61,0,0,52,0,0,0,0,60,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,60,0,188,62,1,252,47,239,252,11,254,60,0,0,0,
  // 0x1ee8  Ứ
  232,30,17,22,110,18,2,255,0,7,208,0,0,0,15,128,0,0,0,46,0,0,0,0,36,0,0,0,0,0,0,10,64,160,0,10,15,0,244,0,15,111,0,244,0,15,252,0,244,0,15,224,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,0,0,188,0,47,0,0,126,0,126,0,0,47,255,252,0,0,7,255,208,0,0,0,0,0,0,0,
  // 0x1ee9  ứ
  233,30,15,18,72,15,1,255,0,11,192,0,0,15,64,0,0,61,0,0,0,96,0,104,0,0,0,124,60,0,124,248,124,0,127,240,124,0,127,128,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,60,0,188,0,62,1,252,0,47,239,252,0,11,254,60,0,0,0,0,0,
  // 0x1eea  Ừ
  234,30,17,22,110,18,2,255,3,224,0,0,0,0,244,0,0,0,0,60,0,0,0,0,9,0,0,0,0,0,0,10,64,160,0,10,15,0,244,0,15,111,0,244,0,15,252,0,244,0,15,224,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,0,0,188,0,47,0,0,126,0,126,0,0,47,255,252,0,0,7,255,208,0,0,0,0,0,0,0,
  // 0x1eeb  ừ
  235,30,15,18,72,15,1,255,3,224,0,0,1,240,0,0,0,124,0,0,0,9,0,104,0,0,0,124,60,0,124,248,124,0,127,240,124,0,127,128,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,60,0,188,0,62,1,252,0,47,239,252,0,11,254,60,0,0,0,0,0,
  // 0x1eec  Ử
  236,30,17,23,115,18,2,255,0,105,0,0,0,0,111,64,0,0,0,3,128,0,0,0,31,64,0,0,0,44,0,0,0,0,4,0,10,64,160,0,10,15,0,244,0,15,111,0,244,0,15,252,0,244,0,15,224,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,0,0,188,0,47,0,0,126,0,126,0,0,47,255,252,0,0,7,255,208,0,0,0,0,0,0,0,
  // 0x1eed  ử
  237,30,15,19,76,15,1,255,0,254,0,0,0,95,64,0,0,11,64,0,0,62,0,0,0,56,0,104,0,0,0,124,60,0,124,248,124,0,127,240,124,0,127,128,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,60,0,188,0,62,1,252,0,47,239,252,0,11,254,60,0,0,0,0,0,
  // 0x1eee  Ữ
  238,30,17,22,110,18,2,255,0,0,16,0,0,3,248,112,0,0,15,127,224,0,0,8,6,64,0,0,0,0,0,10,64,160,0,10,15,0,244,0,15,111,0,244,0,15,252,0,244,0,15,224,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,0,0,188,0,47,0,0,126,0,126,0,0,47,255,252,0,0,7,255,208,0,0,0,0,0,0,0,
  // 0x1eef  ữ
  239,30,15,18,72,15,1,255,0,0,16,0,7,244,176,0,14,191,208,0,8,6,64,104,0,0,0,124,60,0,124,248,124,0,127,240,124,0,127,128,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,60,0,188,0,62,1,252,0,47,239,252,0,11,254,60,0,0,0,0,0,
  // 0x1ef0  Ự
  240,30,17,22,110,18,2,251,0,0,0,10,64,160,0,10,15,0,244,0,15,111,0,244,0,15,252,0,244,0,15,224,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,0,0,188,0,47,0,0,126,0,126,0,0,47,255,252,0,0,7,255,208,0,0,0,0,0,0,0,0,24,0,0,0,0,61,0,0,0,0,60,0,0,0,0,0,0,0,0,
  // 0x1ef1  ự
  241,30,15,19,76,15,1,251,0,0,0,104,0,0,0,124,60,0,124,248,124,0,127,240,124,0,127,128,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,60,0,188,0,62,1,252,0,47,239,252,0,11,254,60,0,0,0,0,0,0,32,0,0,0,188,0,0,0,120,0,0,0,0,0,0,
  // 0x1ef2  Ỳ
  242,30,13,21,84,13,0,0,1,240,0,0,0,188,0,0,0,45,0,0,0,10,0,0,0,0,0,0,168,0,10,64,124,0,31,0,62,0,62,0,31,64,124,0,11,192,248,0,3,209,240,0,2,243,208,0,0,255,192,0,0,191,64,0,0,63,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,
  // 0x1ef3  ỳ
  243,30,12,23,69,12,0,250,3,208,0,1,240,0,0,124,0,0,25,0,0,0,0,184,0,61,124,0,124,61,0,184,47,0,244,15,1,240,15,67,224,7,195,192,3,199,192,2,239,64,0,255,0,0,254,0,0,125,0,0,124,0,0,248,0,1,240,0,111,208,0,191,64,0,16,0,0,
  // 0x1ef4  Ỵ
  244,30,13,21,84,13,0,251,168,0,10,64,124,0,31,0,62,0,62,0,31,64,124,0,11,192,248,0,3,209,240,0,2,243,208,0,0,255,192,0,0,191,64,0,0,63,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,0,0,0,0,24,0,0,0,62,0,0,0,45,0,0,0,0,0,0,
  // 0x1ef5  ỵ
  245,30,12,18,54,12,0,250,184,0,61,124,0,124,61,0,184,47,0,244,15,1,240,15,67,224,7,195,192,3,199,192,2,239,64,0,255,0,0,254,0,0,125,0,0,124,0,0,248,80,1,241,240,111,208,240,191,64,0,16,0,0,
  // 0x1ef6  Ỷ
  246,30,13,22,88,13,0,0,0,42,0,0,0,111,128,0,0,3,192,0,0,31,64,0,0,29,0,0,0,4,0,0,168,0,10,64,124,0,31,0,62,0,62,0,31,64,124,0,11,192,248,0,3,209,240,0,2,243,208,0,0,255,192,0,0,191,64,0,0,63,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,
  // 0x1ef7  ỷ
  247,30,12,24,72,12,0,250,0,254,0,0,95,0,0,11,0,0,61,0,0,52,0,0,0,0,184,0,61,124,0,124,61,0,184,47,0,244,15,1,240,15,67,224,7,195,192,3,199,192,2,239,64,0,255,0,0,254,0,0,125,0,0,124,0,0,248,0,1,240,0,111,208,0,191,64,0,16,0,0,
  // 0x1ef8  Ỹ
  248,30,13,20,80,13,0,0,3,248,52,0,7,175,240,0,5,2,128,0,0,0,0,0,168,0,10,64,124,0,31,0,62,0,62,0,31,64,124,0,11,192,248,0,3,209,240,0,2,243,208,0,0,255,192,0,0,191,64,0,0,63,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,
  // 0x1ef9  ỹ
  249,30,12,23,69,12,0,250,0,0,16,7,244,176,14,191,208,8,6,64,0,0,0,184,0,61,124,0,124,61,0,184,47,0,244,15,1,240,15,67,224,7,195,192,3,199,192,2,239,64,0,255,0,0,254,0,0,125,0,0,124,0,0,248,0,1,240,0,111,208,0,191,64,0,16,0,0,
};

#endif // HAS_GRAPHICAL_TFT
