/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Katakana 22pt, capital 'A' height: 16px, width: 100%, range: 0x30a0-0x8868, glyphs: 103
extern const uint8_t NotoSans_Medium_Katakana_16[9720] = {
  162,16,160,48,104,136,21,250, // unifont_t
  // 0x30a0  ゠
  160,48,10,4,12,22,6,6,191,255,224,0,0,0,0,0,0,191,255,224,
  // 0x30a1  ァ
  161,48,15,15,60,22,4,253,255,255,255,248,255,255,255,252,0,0,1,244,0,25,3,224,0,31,15,192,0,30,63,0,0,46,44,0,0,45,0,0,0,61,0,0,0,124,0,0,0,248,0,0,3,240,0,0,31,208,0,0,63,64,0,0,8,0,0,0,
  // 0x30a2  ア
  162,48,19,18,90,22,2,254,127,255,255,255,240,127,255,255,255,244,0,0,0,3,224,0,0,0,11,192,0,2,224,31,64,0,2,240,126,0,0,2,226,248,0,0,2,226,224,0,0,2,224,0,0,0,3,208,0,0,0,3,208,0,0,0,7,192,0,0,0,15,128,0,0,0,47,64,0,0,0,190,0,0,0,7,248,0,0,0,11,224,0,0,0,2,64,0,0,0,
  // 0x30a3  ィ
  163,48,15,15,60,22,2,254,0,0,0,60,0,0,1,252,0,0,7,240,0,0,47,128,0,1,253,0,0,31,248,0,6,255,248,0,127,244,248,0,62,0,248,0,0,0,248,0,0,0,248,0,0,0,248,0,0,0,248,0,0,0,248,0,0,0,248,0,
  // 0x30a4  イ
  164,48,17,19,95,22,2,254,0,0,0,2,0,0,0,0,15,192,0,0,0,63,64,0,0,1,253,0,0,0,11,240,0,0,0,127,128,0,0,7,254,0,0,0,127,253,0,0,27,254,125,0,0,255,224,61,0,0,189,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,20,0,0,
  // 0x30a5  ゥ
  165,48,15,17,68,22,4,253,0,15,0,0,0,15,0,0,0,15,0,0,255,255,255,240,255,255,255,244,240,0,1,240,240,0,2,240,240,0,3,224,240,0,3,208,80,0,11,192,0,0,15,128,0,0,63,0,0,1,253,0,0,11,244,0,1,255,208,0,0,254,0,0,0,80,0,0,
  // 0x30a6  ウ
  166,48,17,20,100,22,3,254,0,7,192,0,0,0,7,192,0,0,0,7,192,0,0,0,7,192,0,0,255,255,255,255,64,255,255,255,255,64,240,0,0,31,0,240,0,0,47,0,240,0,0,47,0,240,0,0,62,0,240,0,0,124,0,80,0,0,252,0,0,0,1,244,0,0,0,3,240,0,0,0,15,192,0,0,0,127,64,0,0,7,253,0,0,0,191,244,0,0,0,191,128,0,0,0,36,0,0,0,
  // 0x30a7  ェ
  167,48,16,13,52,22,3,254,47,255,255,248,47,255,255,248,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,7,192,0,191,255,255,254,191,255,255,254,0,0,0,0,
  // 0x30a8  エ
  168,48,18,16,80,22,2,255,63,255,255,255,192,63,255,255,255,192,0,1,244,0,64,0,1,240,0,0,0,1,240,0,0,0,1,240,0,0,0,1,240,0,0,0,1,240,0,0,0,1,240,0,0,0,1,240,0,0,0,1,240,0,0,0,1,240,0,0,85,85,245,85,80,255,255,255,255,240,255,255,255,255,240,0,0,0,0,0,
  // 0x30a9  ォ
  169,48,15,16,64,22,4,254,0,0,80,0,0,0,180,0,0,0,180,0,0,0,180,0,191,255,255,252,191,255,255,252,0,3,248,0,0,11,248,0,0,47,184,0,0,252,120,0,7,240,120,0,47,192,120,0,254,0,120,0,180,0,120,0,0,47,248,0,0,31,240,0,
  // 0x30aa  オ
  170,48,18,20,100,22,2,254,0,0,5,64,0,0,0,11,128,0,0,0,11,128,0,0,0,11,128,0,0,0,11,128,0,127,255,255,255,240,127,255,255,255,240,0,0,63,128,0,0,0,191,128,0,0,2,251,128,0,0,11,215,192,0,0,47,71,192,0,0,253,7,192,0,11,244,7,192,0,127,192,7,192,0,254,0,7,192,0,32,0,11,192,0,0,3,255,192,0,0,3,255,64,0,0,0,0,0,0,
  // 0x30ab  カ
  171,48,17,20,100,22,2,254,0,1,64,0,0,0,3,208,0,0,0,3,208,0,0,0,3,192,0,0,0,3,192,0,0,127,255,255,255,128,127,255,255,255,192,0,7,192,7,192,0,11,128,7,192,0,15,128,7,128,0,15,64,11,128,0,31,0,11,128,0,62,0,11,64,0,124,0,15,64,0,248,0,15,0,3,240,0,15,0,15,208,0,47,0,127,64,63,254,0,61,0,47,252,0,0,0,0,0,0,
  // 0x30ac  ガ
  172,48,19,20,100,22,2,254,0,0,0,0,240,0,11,192,29,116,0,7,192,15,60,0,7,192,7,64,0,11,192,0,0,255,255,255,255,64,255,255,255,255,64,0,15,64,15,64,0,15,0,15,64,0,15,0,15,64,0,47,0,15,0,0,62,0,15,0,0,124,0,15,0,0,248,0,31,0,1,244,0,31,0,7,224,0,46,0,31,192,0,61,0,191,0,127,252,0,188,0,63,244,0,16,0,0,0,0,
  // 0x30ad  キ
  173,48,18,19,95,22,2,254,0,11,64,0,0,0,15,128,0,0,0,11,192,0,0,0,7,198,190,0,1,111,255,255,0,191,255,250,80,0,127,167,224,0,0,16,2,224,0,0,0,1,240,0,0,0,0,241,111,224,0,22,255,255,240,111,255,255,164,0,191,250,184,0,0,100,0,124,0,0,0,0,60,0,0,0,0,61,0,0,0,0,62,0,0,0,0,47,0,0,0,0,25,0,0,
  // 0x30ae  ギ
  174,48,19,20,100,22,2,254,0,0,0,4,224,0,10,0,45,116,0,15,0,15,56,0,15,64,7,0,0,15,129,173,0,0,95,255,253,0,255,255,255,148,0,255,235,192,0,0,80,3,208,0,0,0,3,224,0,0,0,2,224,91,192,0,6,255,255,208,107,255,255,233,64,255,254,244,0,0,185,0,244,0,0,0,0,184,0,0,0,0,124,0,0,0,0,124,0,0,0,0,61,0,0,0,0,61,0,0,
  // 0x30af  ク
  175,48,17,21,105,22,2,253,0,1,128,0,0,0,3,240,0,0,0,7,208,0,0,0,15,192,0,0,0,31,255,255,128,0,63,255,255,192,0,252,0,15,128,3,240,0,15,64,15,208,0,47,0,127,64,0,62,0,124,0,0,188,0,0,0,1,248,0,0,0,3,240,0,0,0,15,192,0,0,0,63,64,0,0,1,253,0,0,0,15,244,0,0,1,191,192,0,0,7,253,0,0,0,1,208,0,0,0,0,0,0,0,0,
  // 0x30b0  グ
  176,48,20,22,110,22,1,253,0,0,0,0,24,0,0,0,2,45,0,2,240,3,143,0,3,224,1,214,0,11,192,0,208,0,15,255,255,192,0,63,255,255,208,0,188,0,11,192,2,244,0,15,128,11,224,0,31,64,63,128,0,63,0,125,0,0,125,0,20,0,0,252,0,0,0,2,244,0,0,0,7,224,0,0,0,31,192,0,0,0,191,0,0,0,7,252,0,0,0,47,224,0,0,7,255,64,0,0,2,248,0,0,0,0,64,0,0,0,
  // 0x30b1  ケ
  177,48,19,20,100,22,1,254,0,4,0,0,0,0,31,0,0,0,0,47,0,0,0,0,61,0,0,0,0,125,0,0,0,0,255,255,255,252,1,255,255,255,252,3,224,3,224,0,15,192,3,208,0,47,64,3,192,0,126,0,7,192,0,24,0,11,192,0,0,0,15,64,0,0,0,47,0,0,0,0,62,0,0,0,0,252,0,0,0,3,244,0,0,0,31,224,0,0,0,63,128,0,0,0,5,0,0,0,
  // 0x30b2  ゲ
  178,48,20,22,110,22,1,253,0,0,0,0,4,0,0,0,1,60,0,47,0,7,142,0,62,0,2,202,0,61,0,0,208,0,188,0,0,0,0,255,255,255,252,2,255,255,255,252,7,224,7,208,0,15,192,3,192,0,47,64,7,192,0,190,0,11,192,0,40,0,15,128,0,0,0,15,64,0,0,0,47,0,0,0,0,62,0,0,0,0,252,0,0,0,2,244,0,0,0,15,224,0,0,0,127,128,0,0,0,30,0,0,0,0,0,0,0,0,
  // 0x30b3  コ
  179,48,16,17,68,22,3,254,127,255,255,255,127,255,255,255,16,0,0,47,0,0,0,47,0,0,0,47,0,0,0,47,0,0,0,47,0,0,0,47,0,0,0,47,0,0,0,47,0,0,0,47,0,0,0,47,21,85,85,111,191,255,255,255,191,255,255,255,0,0,0,47,0,0,0,0,
  // 0x30b4  ゴ
  180,48,18,21,105,22,3,254,0,0,0,2,64,0,0,0,227,192,0,0,0,181,224,0,0,0,60,144,80,0,0,36,0,255,255,255,253,0,255,255,255,253,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,255,255,255,253,0,255,255,255,253,0,85,85,85,125,0,0,0,0,41,0,
  // 0x30b5  サ
  181,48,20,20,100,22,1,254,0,20,0,20,0,0,124,0,60,0,0,60,0,60,0,0,60,0,60,0,0,60,0,60,0,191,255,255,255,253,191,255,255,255,253,0,124,0,124,0,0,60,0,60,0,0,60,0,60,0,0,60,0,124,0,0,60,0,124,0,0,60,0,184,0,0,0,0,244,0,0,0,1,240,0,0,0,7,224,0,0,0,31,192,0,0,1,255,0,0,0,2,252,0,0,0,0,144,0,0,
  // 0x30b6  ザ
  182,48,20,21,105,22,1,253,0,0,0,0,8,0,184,0,189,205,0,184,0,184,219,0,184,0,184,163,0,184,0,184,80,0,184,0,188,0,255,255,255,255,252,255,255,255,255,252,0,184,0,184,0,0,184,0,184,0,0,184,0,184,0,0,184,0,184,0,0,184,0,244,0,0,100,0,240,0,0,0,2,240,0,0,0,3,224,0,0,0,15,192,0,0,0,127,64,0,0,3,253,0,0,0,2,224,0,0,0,0,0,0,0,
  // 0x30b7  シ
  183,48,18,18,90,22,2,255,0,144,0,0,0,1,252,0,0,0,0,191,128,0,0,0,15,208,0,0,0,2,128,0,0,36,0,0,0,64,190,0,0,0,224,63,208,0,3,240,7,240,0,11,208,0,144,0,47,128,0,0,0,190,0,0,0,3,248,0,0,0,31,224,0,0,1,255,64,0,0,31,248,0,0,27,255,208,0,0,47,249,0,0,0,14,64,0,0,0,
  // 0x30b8  ジ
  184,48,19,19,95,22,2,255,0,0,0,0,64,0,144,0,17,224,2,248,0,120,240,0,255,64,60,56,0,31,192,14,0,0,3,64,4,0,96,0,0,0,128,254,0,0,1,208,127,208,0,3,240,11,224,0,15,192,0,192,0,63,64,0,0,0,253,0,0,0,7,244,0,0,0,47,208,0,0,1,255,0,0,0,47,248,0,0,27,255,128,0,0,63,248,0,0,0,14,64,0,0,0,
  // 0x30b9  ス
  185,48,18,18,90,22,2,254,4,0,0,20,0,15,255,255,254,0,15,255,255,253,0,0,0,0,188,0,0,0,0,244,0,0,0,2,240,0,0,0,7,208,0,0,0,15,192,0,0,0,47,0,0,0,0,191,0,0,0,1,255,192,0,0,11,231,240,0,0,47,129,252,0,1,254,0,127,0,11,244,0,31,192,191,192,0,11,224,62,0,0,3,208,0,0,0,0,0,
  // 0x30ba  ズ
  186,48,19,22,110,22,2,253,0,0,0,0,160,0,0,0,28,176,0,0,0,14,60,0,0,0,11,24,31,255,255,254,0,31,255,255,252,0,5,0,1,248,0,0,0,1,240,0,0,0,3,224,0,0,0,11,192,0,0,0,15,128,0,0,0,63,0,0,0,0,189,0,0,0,2,255,0,0,0,11,239,208,0,0,47,131,244,0,0,253,0,252,0,11,244,0,127,0,127,208,0,31,192,254,0,0,11,192,32,0,0,2,0,0,0,0,0,0,
  // 0x30bb  セ
  187,48,19,19,95,22,1,254,0,47,0,0,0,0,47,0,0,0,0,47,0,0,0,0,47,0,1,160,0,47,5,191,248,0,47,255,255,240,107,255,255,147,224,191,255,64,11,192,121,47,0,15,64,0,47,0,62,0,0,47,0,252,0,0,47,0,176,0,0,47,0,0,0,0,47,0,0,0,0,47,0,0,0,0,31,64,1,144,0,15,255,255,224,0,7,255,255,208,0,0,0,0,0,
  // 0x30bc  ゼ
  188,48,20,21,105,22,1,254,0,0,0,0,20,0,0,0,2,44,0,41,0,3,142,0,62,0,2,203,0,61,0,0,208,0,61,0,0,0,0,61,0,27,224,0,62,107,255,240,1,191,255,251,224,255,255,233,7,192,255,254,0,15,64,148,61,0,47,0,0,61,0,188,0,0,61,1,244,0,0,61,0,96,0,0,61,0,0,0,0,61,0,0,0,0,62,0,0,0,0,47,64,86,144,0,31,255,255,208,0,6,255,254,128,
  // 0x30bd  ソ
  189,48,17,18,90,22,2,254,8,0,0,15,128,125,0,0,15,128,63,0,0,15,64,15,128,0,31,0,11,208,0,47,0,3,240,0,62,0,2,240,0,125,0,0,128,0,252,0,0,0,1,244,0,0,0,3,240,0,0,0,15,208,0,0,0,47,128,0,0,0,190,0,0,0,7,248,0,0,0,47,224,0,0,0,255,64,0,0,0,56,0,0,0,0,0,0,0,0,
  // 0x30be  ゾ
  190,48,19,20,100,22,2,254,0,0,0,4,224,0,0,0,60,180,0,0,0,14,60,20,0,0,10,0,188,0,0,30,0,63,0,0,47,0,47,64,0,47,0,15,192,0,62,0,7,208,0,124,0,3,224,0,188,0,1,64,0,244,0,0,0,2,240,0,0,0,7,208,0,0,0,15,192,0,0,0,63,0,0,0,1,253,0,0,0,11,244,0,0,0,127,208,0,0,1,254,0,0,0,0,116,0,0,0,
  // 0x30bf  タ
  191,48,17,20,100,22,2,254,0,2,224,0,0,0,3,224,0,0,0,11,192,0,0,0,31,255,255,128,0,63,255,255,192,0,188,0,15,192,2,240,0,15,64,11,208,0,47,0,63,71,0,62,0,253,15,224,188,0,116,3,253,244,0,0,0,191,240,0,0,0,31,240,0,0,0,47,252,0,0,0,190,190,0,0,3,248,44,0,0,47,224,0,0,2,255,64,0,0,11,248,0,0,0,2,128,0,0,0,
  // 0x30c0  ダ
  192,48,20,22,110,22,1,253,0,0,0,0,24,0,0,64,2,44,0,1,240,3,143,0,3,240,2,199,0,7,208,0,208,0,15,255,255,208,0,47,255,255,224,0,125,0,7,192,1,248,0,15,128,7,224,0,15,64,47,131,128,47,0,190,11,244,125,0,36,1,254,252,0,0,0,63,240,0,0,0,15,244,0,0,0,47,254,0,0,0,191,63,0,0,3,248,8,0,0,47,224,0,0,7,255,64,0,0,3,244,0,0,0,0,64,0,0,0,
  // 0x30c1  チ
  193,48,18,19,95,22,2,254,0,0,5,188,0,26,175,255,254,0,15,255,254,64,0,5,80,248,0,0,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,255,255,255,255,240,255,255,255,255,240,0,0,244,0,0,0,0,240,0,0,0,1,240,0,0,0,2,240,0,0,0,3,208,0,0,0,15,192,0,0,0,63,64,0,0,1,254,0,0,0,3,244,0,0,0,0,144,0,0,0,
  // 0x30c2  ヂ
  194,48,20,20,100,22,1,253,0,0,0,4,0,0,0,6,190,0,10,191,255,255,0,11,255,254,81,44,0,0,124,3,142,0,0,124,1,213,0,0,124,0,64,191,255,255,255,248,191,255,255,255,248,0,0,188,0,0,0,0,184,0,0,0,0,248,0,0,0,1,244,0,0,0,2,240,0,0,0,7,208,0,0,0,31,192,0,0,0,191,0,0,0,2,253,0,0,0,0,176,0,0,0,0,0,0,0,0,
  // 0x30c3  ッ
  195,48,15,15,60,22,4,254,0,8,0,0,16,61,0,164,240,46,0,248,248,15,0,244,124,15,65,240,61,6,3,224,45,0,3,192,0,0,15,128,0,0,47,0,0,0,125,0,0,2,248,0,0,15,224,0,1,191,64,0,7,252,0,0,1,208,0,0,
  // 0x30c4  ツ
  196,48,18,18,90,22,2,255,0,1,0,0,0,0,15,128,1,144,180,7,192,2,240,188,3,208,3,224,61,2,240,3,192,62,0,240,11,192,31,0,144,15,128,15,64,0,31,0,4,0,0,62,0,0,0,0,124,0,0,0,0,248,0,0,0,3,240,0,0,0,15,192,0,0,0,127,64,0,0,3,252,0,0,0,111,240,0,0,0,255,64,0,0,0,52,0,0,0,
  // 0x30c5  ヅ
  197,48,20,20,100,22,1,254,0,0,0,1,60,0,0,0,11,78,0,0,128,3,203,0,3,208,1,128,124,2,224,0,64,61,1,240,1,244,47,0,244,2,240,15,64,188,3,224,15,128,100,3,192,7,192,0,11,192,1,0,0,15,64,0,0,0,63,0,0,0,0,189,0,0,0,1,248,0,0,0,11,224,0,0,0,47,192,0,0,1,254,0,0,0,31,248,0,0,0,191,192,0,0,0,41,0,0,0,
  // 0x30c6  テ
  198,48,18,18,90,22,2,254,7,255,255,255,0,7,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,240,255,255,255,255,240,0,0,184,0,0,0,0,248,0,0,0,0,244,0,0,0,0,244,0,0,0,1,240,0,0,0,3,224,0,0,0,11,208,0,0,0,31,192,0,0,0,191,0,0,0,2,252,0,0,0,0,160,0,0,0,
  // 0x30c7  デ
  199,48,20,22,110,22,1,253,0,0,0,0,28,0,0,0,2,142,0,0,0,2,203,2,255,255,252,226,2,255,255,252,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,252,127,255,255,255,252,0,0,61,0,0,0,0,61,0,0,0,0,60,0,0,0,0,124,0,0,0,0,248,0,0,0,1,244,0,0,0,7,240,0,0,0,31,192,0,0,0,191,0,0,0,0,120,0,0,0,0,0,0,0,0,
  // 0x30c8  ト
  200,48,12,18,54,22,7,255,248,0,0,248,0,0,248,0,0,248,0,0,248,0,0,248,0,0,255,64,0,255,253,0,254,255,224,248,31,254,248,1,189,248,0,8,248,0,0,248,0,0,248,0,0,248,0,0,248,0,0,248,0,0,
  // 0x30c9  ド
  201,48,13,19,76,22,6,254,104,0,10,0,188,1,139,64,188,1,227,192,124,0,241,128,124,0,116,0,124,0,0,0,126,0,0,0,127,248,0,0,127,255,208,0,124,111,254,0,124,1,255,0,124,0,29,0,124,0,0,0,124,0,0,0,124,0,0,0,188,0,0,0,188,0,0,0,188,0,0,0,20,0,0,0,
  // 0x30ca  ナ
  202,48,19,20,100,22,2,254,0,0,16,0,0,0,0,188,0,0,0,0,188,0,0,0,0,188,0,0,0,0,188,0,0,0,0,188,0,0,255,255,255,255,244,255,255,255,255,244,64,0,188,0,0,0,0,248,0,0,0,0,248,0,0,0,0,244,0,0,0,1,240,0,0,0,3,240,0,0,0,7,208,0,0,0,31,192,0,0,0,127,0,0,0,2,253,0,0,0,3,244,0,0,0,0,128,0,0,0,
  // 0x30cb  ニ
  203,48,18,15,75,22,2,0,5,85,85,85,0,15,255,255,254,0,15,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,224,255,255,255,255,224,149,85,85,85,80,
  // 0x30cc  ヌ
  204,48,15,19,76,22,3,253,0,0,0,16,63,255,255,252,63,255,255,252,0,0,0,248,0,0,1,240,0,0,3,240,7,128,3,208,11,248,15,192,1,255,31,64,0,47,255,0,0,7,253,0,0,2,255,64,0,15,255,208,0,127,135,248,2,253,0,252,111,244,0,52,255,128,0,0,56,0,0,0,0,0,0,0,
  // 0x30cd  ネ
  205,48,19,20,100,22,2,254,0,0,160,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,63,255,255,254,0,63,255,255,255,0,0,0,0,253,0,0,0,2,244,0,0,0,15,208,0,0,0,127,64,0,0,2,252,0,0,0,47,244,120,0,2,255,240,255,64,191,244,240,31,224,255,64,240,3,244,80,0,240,0,160,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,244,0,0,
  // 0x30ce  ノ
  206,48,15,17,68,22,3,255,0,0,0,248,0,0,0,248,0,0,1,240,0,0,3,240,0,0,3,208,0,0,11,192,0,0,15,128,0,0,47,0,0,0,125,0,0,0,252,0,0,3,240,0,0,31,208,0,0,127,64,0,7,253,0,0,127,240,0,0,191,128,0,0,40,0,0,0,
  // 0x30cf  ハ
  207,48,20,16,80,22,1,255,0,9,0,176,0,0,31,64,244,0,0,31,0,188,0,0,47,0,61,0,0,62,0,47,0,0,61,0,31,64,0,188,0,15,128,0,248,0,7,192,0,244,0,3,224,2,240,0,3,240,3,224,0,1,240,11,192,0,0,248,31,128,0,0,252,63,0,0,0,124,125,0,0,0,61,4,0,0,0,16,
  // 0x30d0  バ
  208,48,20,19,95,22,1,255,0,0,0,0,40,0,0,0,3,93,0,0,0,3,207,0,25,1,161,209,0,47,1,240,64,0,46,0,248,0,0,62,0,124,0,0,61,0,62,0,0,124,0,47,0,0,248,0,15,64,0,244,0,15,192,1,240,0,7,192,3,224,0,3,224,7,208,0,2,240,15,192,0,1,244,47,64,0,0,248,63,0,0,0,252,188,0,0,0,124,4,0,0,0,16,
  // 0x30d1  パ
  209,48,21,20,120,22,1,254,0,0,0,0,189,0,0,0,0,2,199,0,0,0,0,2,67,64,0,25,1,242,199,0,0,47,1,244,253,0,0,46,0,248,0,0,0,62,0,124,0,0,0,61,0,62,0,0,0,124,0,47,0,0,0,188,0,15,64,0,0,244,0,15,192,0,1,240,0,7,192,0,3,240,0,3,224,0,7,208,0,3,240,0,11,192,0,1,240,0,31,128,0,0,244,0,63,0,0,0,252,0,189,0,0,0,188,0,44,0,0,0,116,0,0,0,0,0,0,0,
  // 0x30d2  ヒ
  210,48,14,18,72,22,5,255,240,0,0,0,240,0,0,0,240,0,0,0,240,0,2,128,240,0,47,192,240,7,255,128,246,255,248,0,255,254,64,0,255,128,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,253,85,86,176,191,255,255,240,27,255,255,160,
  // 0x30d3  ビ
  211,48,16,21,84,22,4,254,0,0,0,4,0,0,1,44,164,0,3,143,244,0,1,215,244,0,0,224,244,0,0,64,244,0,11,192,244,1,255,192,244,127,254,0,255,255,144,0,255,228,0,0,248,0,0,0,244,0,0,0,244,0,0,0,244,0,0,0,244,0,0,0,244,0,0,0,253,0,1,96,191,255,255,240,47,255,255,240,0,0,0,0,
  // 0x30d4  ピ
  212,48,17,20,100,22,4,254,0,0,0,126,0,160,0,0,231,64,244,0,1,194,128,244,0,0,211,128,244,0,0,191,0,244,0,11,192,0,244,1,255,192,0,244,127,253,0,0,255,255,144,0,0,255,228,0,0,0,248,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,253,0,1,96,0,191,255,255,240,0,47,255,255,240,0,0,0,0,0,0,
  // 0x30d5  フ
  213,48,16,18,72,22,3,254,80,0,0,4,255,255,255,254,255,255,255,255,0,0,0,62,0,0,0,61,0,0,0,124,0,0,0,188,0,0,0,248,0,0,2,240,0,0,7,224,0,0,15,192,0,0,63,64,0,0,254,0,0,11,248,0,0,191,208,0,11,255,0,0,3,244,0,0,0,0,0,0,
  // 0x30d6  ブ
  214,48,19,21,105,22,2,254,0,0,0,4,176,0,0,0,44,120,0,0,0,15,44,16,0,0,11,4,127,255,255,255,64,127,255,255,255,128,0,0,0,31,0,0,0,0,47,0,0,0,0,62,0,0,0,0,61,0,0,0,0,188,0,0,0,0,248,0,0,0,2,240,0,0,0,7,224,0,0,0,15,192,0,0,0,127,0,0,0,2,253,0,0,0,31,244,0,0,3,255,128,0,0,2,253,0,0,0,0,144,0,0,0,
  // 0x30d7  プ
  215,48,20,20,100,22,2,254,0,0,0,2,248,0,0,0,7,77,16,0,0,11,10,127,255,255,255,93,127,255,255,255,248,0,0,0,31,64,0,0,0,47,0,0,0,0,63,0,0,0,0,62,0,0,0,0,188,0,0,0,0,252,0,0,0,2,244,0,0,0,7,224,0,0,0,15,192,0,0,0,127,64,0,0,2,253,0,0,0,31,244,0,0,3,255,128,0,0,2,253,0,0,0,0,144,0,0,0,
  // 0x30d8  ヘ
  216,48,20,14,70,22,1,0,0,3,208,0,0,0,15,248,0,0,0,63,254,0,0,0,188,47,128,0,2,244,11,208,0,7,224,3,244,0,31,192,0,253,0,127,0,0,63,0,125,0,0,31,192,28,0,0,7,240,0,0,0,2,252,0,0,0,0,254,0,0,0,0,61,0,0,0,0,20,
  // 0x30d9  ベ
  217,48,20,17,85,22,1,255,0,0,0,0,224,0,0,0,40,180,0,2,128,45,60,0,15,240,15,44,0,63,252,11,0,0,189,63,0,0,1,244,15,192,0,7,224,7,240,0,15,192,1,252,0,63,64,0,190,0,254,0,0,47,128,60,0,0,15,208,0,0,0,3,244,0,0,0,1,253,0,0,0,0,190,0,0,0,0,40,0,0,0,0,0,
  // 0x30da  ペ
  218,48,20,17,85,22,1,255,0,0,0,7,224,0,0,0,14,120,0,2,128,28,28,0,15,240,28,28,0,63,252,13,120,0,189,63,7,224,1,244,15,192,0,7,224,7,240,0,15,192,1,252,0,63,64,0,190,0,190,0,0,47,128,124,0,0,15,208,20,0,0,3,244,0,0,0,1,253,0,0,0,0,190,0,0,0,0,40,0,0,0,0,0,
  // 0x30db  ホ
  219,48,19,20,100,22,2,254,0,0,80,0,0,0,0,248,0,0,0,0,244,0,0,0,0,244,0,0,0,0,248,0,0,191,255,255,255,240,191,255,255,255,240,0,0,244,0,0,0,0,244,0,0,1,64,244,4,0,3,208,244,47,0,11,192,244,15,128,31,0,244,7,192,62,0,244,3,240,248,0,244,0,244,176,0,244,0,160,0,0,244,0,0,0,63,244,0,0,0,63,240,0,0,0,0,0,0,0,
  // 0x30dc  ボ
  220,48,20,20,100,22,1,254,0,0,0,1,60,0,0,124,11,93,0,0,60,3,207,0,0,60,1,192,0,0,124,0,0,63,255,255,255,248,63,255,255,255,248,0,0,60,0,0,0,0,60,0,0,0,64,60,1,0,0,240,60,15,64,3,224,60,11,192,7,192,60,3,224,15,128,60,1,240,63,0,60,0,248,188,0,60,0,124,36,0,60,0,32,0,0,124,0,0,0,31,252,0,0,0,31,244,0,0,
  // 0x30dd  ポ
  221,48,20,21,105,22,1,254,0,0,0,1,244,0,0,0,3,93,0,0,124,7,10,0,0,60,3,77,0,0,60,1,248,0,0,124,0,0,63,255,255,255,248,63,255,255,255,248,0,0,60,0,0,0,0,60,0,0,0,64,60,1,0,0,240,60,15,64,3,224,60,11,192,7,192,60,3,224,15,128,60,1,240,63,0,60,0,248,188,0,60,0,124,36,0,60,0,32,0,0,124,0,0,0,31,252,0,0,0,31,244,0,0,
  // 0x30de  マ
  222,48,19,17,85,22,2,254,255,255,255,255,224,255,255,255,255,244,0,0,0,7,224,0,0,0,15,192,0,0,0,47,64,0,0,0,126,0,0,128,1,252,0,3,244,3,240,0,1,253,31,192,0,0,63,191,0,0,0,15,252,0,0,0,3,248,0,0,0,0,253,0,0,0,0,63,64,0,0,0,15,192,0,0,0,7,224,0,0,0,2,64,0,
  // 0x30df  ミ
  223,48,15,18,72,22,3,255,2,80,0,0,3,255,164,0,2,191,255,224,0,1,191,252,0,0,1,180,0,0,0,0,10,64,0,0,15,254,144,0,6,255,255,64,0,6,255,208,0,0,6,192,0,0,0,0,16,0,0,0,63,228,0,0,127,255,228,0,1,175,255,208,0,0,111,240,0,0,1,160,
  // 0x30e0  ム
  224,48,20,19,95,22,1,254,0,0,228,0,0,0,1,244,0,0,0,1,240,0,0,0,3,240,0,0,0,3,208,0,0,0,7,192,0,0,0,11,192,0,0,0,15,128,0,0,0,31,0,8,0,0,47,0,62,0,0,62,0,31,0,0,61,0,15,192,0,188,0,7,208,0,248,0,7,240,1,249,175,255,244,127,255,255,255,252,127,255,165,64,125,20,0,0,0,61,0,0,0,0,16,
  // 0x30e1  メ
  225,48,17,18,90,22,2,255,0,0,0,24,0,0,0,0,63,0,0,0,0,61,0,0,64,0,188,0,2,224,0,248,0,2,253,1,240,0,0,127,131,224,0,0,11,251,192,0,0,1,255,64,0,0,0,127,128,0,0,0,255,224,0,0,3,246,252,0,0,15,208,191,0,0,127,64,47,192,2,253,0,11,192,31,240,0,2,64,127,128,0,0,0,29,0,0,0,0,
  // 0x30e2  モ
  226,48,18,18,90,22,2,254,15,255,255,255,64,15,255,255,255,64,0,7,192,0,0,0,7,192,0,0,0,7,192,0,0,0,7,192,0,0,0,7,192,0,0,191,255,255,255,240,191,255,255,255,240,0,7,192,0,0,0,7,192,0,0,0,7,192,0,0,0,7,192,0,0,0,7,192,0,0,0,7,224,0,64,0,3,255,255,208,0,0,255,255,208,0,0,0,0,0,
  // 0x30e3  ャ
  227,48,16,16,64,22,3,253,1,160,0,0,1,240,0,0,0,240,0,25,0,184,111,255,5,255,255,189,191,254,80,188,122,125,1,240,0,46,3,208,0,31,15,128,0,15,6,0,0,15,64,0,0,11,128,0,0,7,192,0,0,3,208,0,0,3,224,0,0,1,144,0,
  // 0x30e4  ヤ
  228,48,19,19,95,22,1,254,0,104,0,0,0,0,188,0,0,0,0,60,0,0,16,0,61,0,27,252,0,47,111,255,252,5,191,255,233,244,191,255,228,3,224,127,159,128,11,192,0,11,192,31,64,0,7,192,126,0,0,3,208,248,0,0,3,224,16,0,0,2,240,0,0,0,0,244,0,0,0,0,248,0,0,0,0,188,0,0,0,0,124,0,0,0,0,61,0,0,0,0,40,0,0,
  // 0x30e5  ュ
  229,48,16,13,52,22,3,254,15,255,255,192,15,255,255,192,0,0,7,192,0,0,7,192,0,0,11,192,0,0,11,128,0,0,15,128,0,0,15,64,0,0,15,64,0,0,31,64,255,255,255,255,255,255,255,255,0,0,0,0,
  // 0x30e6  ユ
  230,48,20,15,75,22,1,0,3,255,255,255,0,3,255,255,255,64,0,0,0,47,0,0,0,0,47,0,0,0,0,47,0,0,0,0,62,0,0,0,0,62,0,0,0,0,61,0,0,0,0,61,0,0,0,0,124,0,0,0,0,188,0,0,0,0,188,0,127,255,255,255,253,127,255,255,255,253,21,85,85,85,84,
  // 0x30e7  ョ
  231,48,13,15,60,22,4,253,63,255,255,192,63,255,255,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,47,255,255,192,47,255,255,192,0,0,3,192,0,0,3,192,0,0,3,192,127,255,255,192,127,255,255,192,0,0,3,192,0,0,0,0,
  // 0x30e8  ヨ
  232,48,16,17,68,22,3,254,127,255,255,253,127,255,255,253,0,0,0,61,0,0,0,61,0,0,0,61,0,0,0,61,63,255,255,253,63,255,255,253,0,0,0,61,0,0,0,61,0,0,0,61,0,0,0,61,0,0,0,61,191,255,255,253,191,255,255,253,0,0,0,61,0,0,0,20,
  // 0x30e9  ラ
  233,48,16,18,72,22,3,254,15,255,255,252,15,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,47,0,0,0,61,0,0,0,124,0,0,0,248,0,0,3,240,0,0,15,208,0,0,127,64,0,2,253,0,0,191,240,0,0,255,64,0,0,36,0,0,
  // 0x30ea  リ
  234,48,14,18,72,22,4,255,104,0,3,208,124,0,3,208,124,0,3,208,124,0,3,192,124,0,3,192,124,0,3,192,124,0,3,192,124,0,3,192,124,0,3,192,124,0,7,192,124,0,11,192,0,0,15,128,0,0,31,64,0,0,127,0,0,2,252,0,0,47,240,0,0,255,128,0,0,56,0,0,
  // 0x30eb  ル
  235,48,20,18,90,22,1,255,0,20,1,64,0,0,124,11,192,0,0,124,11,192,0,0,124,11,192,0,0,124,11,192,0,0,124,11,192,0,0,124,11,192,0,0,120,11,192,0,0,184,11,192,0,0,184,11,192,0,0,244,11,192,13,0,244,11,192,63,2,240,11,192,252,3,224,11,199,240,11,192,11,255,192,47,64,11,254,0,190,0,11,244,0,24,0,2,128,0,
  // 0x30ec  レ
  236,48,16,17,68,22,4,255,125,0,0,0,60,0,0,0,60,0,0,0,60,0,0,0,60,0,0,0,60,0,0,0,60,0,0,0,60,0,0,13,60,0,0,63,60,0,0,253,60,0,7,244,60,0,47,208,60,2,254,0,60,111,244,0,63,255,64,0,127,228,0,0,29,0,0,0,
  // 0x30ed  ロ
  237,48,16,17,68,22,3,254,255,255,255,255,255,255,255,255,244,0,0,15,244,0,0,15,244,0,0,15,244,0,0,15,244,0,0,15,244,0,0,15,244,0,0,15,244,0,0,15,244,0,0,15,244,0,0,15,244,0,0,31,255,255,255,255,255,255,255,255,244,0,0,31,0,0,0,0,
  // 0x30ee  ヮ
  238,48,15,15,60,22,4,253,255,255,255,224,255,255,255,244,244,0,1,240,244,0,2,240,244,0,3,224,244,0,3,208,244,0,7,192,0,0,15,128,0,0,31,64,0,0,126,0,0,1,252,0,0,11,240,0,1,191,192,0,1,253,0,0,0,96,0,0,
  // 0x30ef  ワ
  239,48,18,18,90,22,2,254,0,0,0,1,0,127,255,255,255,192,63,255,255,255,208,60,0,0,7,192,60,0,0,11,192,60,0,0,15,128,60,0,0,15,128,60,0,0,31,64,60,0,0,47,0,0,0,0,62,0,0,0,0,188,0,0,0,1,248,0,0,0,7,240,0,0,0,47,192,0,0,1,255,0,0,0,47,248,0,0,0,63,208,0,0,0,9,0,0,0,
  // 0x30f0  ヰ
  240,48,18,20,100,22,2,254,0,0,0,64,0,0,0,2,224,0,0,0,2,224,0,0,0,2,224,0,127,255,255,255,224,127,255,255,255,224,0,184,2,224,0,0,184,2,224,0,0,184,2,224,0,0,184,2,224,0,0,184,2,224,0,0,184,2,224,0,0,184,2,224,0,255,255,255,255,240,255,255,255,255,240,0,0,2,224,0,0,0,2,224,0,0,0,2,224,0,0,0,2,224,0,0,0,2,144,0,
  // 0x30f1  ヱ
  241,48,20,17,85,22,1,255,0,0,0,0,16,15,255,255,255,252,15,255,255,255,248,0,0,0,2,240,0,0,16,7,208,0,0,188,15,128,0,0,188,63,0,0,0,188,124,0,0,0,188,0,0,0,0,188,0,0,0,0,188,0,0,0,0,188,0,0,0,0,188,0,0,21,85,189,85,84,127,255,255,255,253,127,255,255,255,253,0,0,0,0,0,
  // 0x30f2  ヲ
  242,48,17,18,90,22,3,254,191,255,255,254,0,191,255,255,255,64,0,0,0,31,0,0,0,0,47,0,0,0,0,46,0,0,0,0,61,0,63,255,255,252,0,63,255,255,252,0,0,0,0,248,0,0,0,2,240,0,0,0,7,224,0,0,0,15,192,0,0,0,63,0,0,0,1,253,0,0,0,31,244,0,0,2,255,128,0,0,3,253,0,0,0,0,144,0,0,0,
  // 0x30f3  ン
  243,48,18,17,85,22,3,255,24,0,0,0,0,63,0,0,0,0,31,208,0,0,0,7,248,0,0,0,0,253,0,2,192,0,60,0,3,208,0,0,0,15,192,0,0,0,47,64,0,0,0,190,0,0,0,2,248,0,0,0,15,224,0,0,0,127,128,0,0,7,253,0,0,0,127,240,0,0,111,255,64,0,0,191,244,0,0,0,57,0,0,0,0,
  // 0x30f4  ヴ
  244,48,19,22,110,22,2,253,0,0,0,0,144,0,2,144,44,176,0,3,224,14,56,0,3,224,11,16,0,3,224,0,0,191,255,255,255,128,191,255,255,255,192,184,0,0,15,192,184,0,0,15,128,184,0,0,15,64,184,0,0,31,0,184,0,0,62,0,84,0,0,125,0,0,0,0,188,0,0,0,1,244,0,0,0,7,240,0,0,0,47,192,0,0,1,255,0,0,0,111,252,0,0,0,127,208,0,0,0,45,0,0,0,0,0,0,0,0,
  // 0x30f5  ヵ
  245,48,14,17,68,22,4,253,0,20,0,0,0,60,0,0,0,60,0,0,0,60,0,0,255,255,255,208,255,255,255,224,0,60,1,224,0,120,2,224,0,180,2,208,0,240,2,208,1,240,2,208,3,208,3,192,15,192,3,192,47,0,7,192,253,3,255,128,176,3,254,0,0,0,0,0,
  // 0x30f6  ヶ
  246,48,16,17,68,22,3,253,0,80,0,0,0,248,0,0,0,240,0,0,2,240,0,0,3,255,255,255,11,255,255,255,31,0,60,0,126,0,124,0,252,0,184,0,112,0,248,0,0,0,240,0,0,2,240,0,0,7,208,0,0,31,128,0,0,191,0,0,1,252,0,0,0,32,0,0,
  // 0x30f7  ヷ
  247,48,19,22,110,22,2,253,0,0,0,16,224,0,0,0,60,176,0,0,0,29,52,0,0,0,9,0,255,255,255,255,64,191,255,255,255,192,184,0,0,15,128,184,0,0,15,64,184,0,0,31,64,184,0,0,31,0,184,0,0,47,0,248,0,0,62,0,0,0,0,125,0,0,0,0,252,0,0,0,2,244,0,0,0,7,224,0,0,0,47,192,0,0,0,255,0,0,0,11,252,0,0,0,191,224,0,0,0,62,0,0,0,0,0,0,0,0,
  // 0x30f8  ヸ
  248,48,20,21,105,22,1,254,0,0,0,0,4,0,0,0,0,76,0,0,0,245,206,0,0,0,244,215,0,0,0,244,160,0,0,0,244,0,47,255,255,255,248,47,255,255,255,248,0,61,0,244,0,0,61,0,244,0,0,61,0,244,0,0,61,0,244,0,0,61,0,244,0,0,61,0,244,0,127,255,255,255,252,127,255,255,255,252,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,180,0,
  // 0x30f9  ヹ
  249,48,20,20,100,22,1,255,0,0,0,0,36,0,0,0,15,44,0,0,0,7,77,0,0,0,2,64,31,255,255,255,244,31,255,255,255,244,0,0,0,3,240,0,0,0,7,208,0,0,248,15,128,0,0,248,127,0,0,0,248,252,0,0,0,248,32,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,191,255,255,255,252,191,255,255,255,252,21,85,85,85,84,
  // 0x30fa  ヺ
  250,48,19,22,110,22,2,253,0,0,0,16,224,0,0,0,60,176,0,0,0,45,52,0,0,0,13,0,127,255,255,255,64,127,255,255,255,128,0,0,0,15,64,0,0,0,31,0,0,0,0,47,0,0,0,0,62,0,63,255,255,253,0,63,255,255,252,0,0,0,0,248,0,0,0,1,240,0,0,0,3,224,0,0,0,15,192,0,0,0,63,0,0,0,1,253,0,0,0,31,240,0,0,2,255,128,0,0,1,248,0,0,0,0,64,0,0,0,
  // 0x30fb  ・
  251,48,6,5,10,22,8,5,47,128,127,208,191,208,127,208,31,64,
  // 0x30fc  ー
  252,48,18,4,20,22,2,6,169,85,85,85,144,255,255,255,255,240,255,255,255,255,240,0,0,0,0,0,
  // 0x30fd  ヽ
  253,48,11,11,33,22,6,2,24,0,0,190,0,0,63,128,0,15,224,0,3,248,0,0,253,0,0,63,64,0,15,192,0,7,240,0,2,244,0,0,144,
  // 0x30fe  ヾ
  254,48,12,15,45,22,6,1,0,0,112,0,29,60,0,15,29,32,7,141,252,2,64,191,0,0,31,192,0,7,240,0,2,252,0,0,190,0,0,47,128,0,15,208,0,3,240,0,1,128,0,0,0,
  // 0x30ff  ヿ
  255,48,14,19,76,22,4,254,255,255,255,208,255,255,255,208,0,0,3,208,0,0,3,208,0,0,3,208,0,0,3,208,0,0,3,208,0,0,3,208,0,0,3,208,0,0,3,208,0,0,3,208,0,0,3,208,0,0,3,208,0,0,3,208,0,0,3,208,0,0,3,208,0,0,3,208,0,0,3,208,0,0,2,208,
  // 0x4eee  仮
  238,78,21,21,126,22,0,253,0,30,0,0,0,0,0,61,63,255,255,128,0,124,63,255,255,128,0,244,60,0,0,0,1,240,60,0,0,0,3,224,60,0,0,0,11,224,60,0,0,0,47,224,63,255,255,0,126,224,63,255,255,0,57,224,63,192,15,0,16,224,123,208,46,0,0,224,121,224,60,0,0,224,120,240,124,0,0,224,180,124,240,0,0,224,244,63,224,0,0,224,240,15,192,0,0,225,240,47,224,0,0,227,208,190,248,0,0,231,199,244,127,128,0,231,143,192,15,192,0,144,1,0,1,0,
  // 0x540d  名
  13,84,19,22,110,22,1,253,0,1,64,0,0,0,7,192,0,0,0,15,128,0,0,0,63,255,253,0,0,191,255,253,0,2,240,0,188,0,15,240,0,244,0,127,252,3,224,0,188,127,11,192,0,16,15,239,0,0,0,3,253,0,0,0,2,244,0,0,0,31,255,255,248,0,191,255,255,248,27,255,0,0,184,255,223,0,0,184,185,15,0,0,184,0,15,0,0,184,0,15,0,0,184,0,15,255,255,248,0,15,255,255,248,0,10,0,0,100,
  // 0x5b9a  定
  154,91,20,22,110,22,1,253,0,0,20,0,0,0,0,60,0,0,0,0,60,0,0,63,255,255,255,252,63,255,255,255,252,60,0,0,0,60,60,0,0,0,60,60,255,255,255,60,0,255,255,255,0,0,0,60,0,0,0,0,60,0,0,1,224,60,0,0,2,224,60,0,0,2,224,63,255,208,3,208,63,255,208,3,240,60,0,0,11,248,60,0,0,15,126,60,0,0,62,15,252,0,0,188,2,255,255,255,180,0,43,255,253,16,0,0,0,0,
  // 0x7247  片
  71,114,19,22,110,22,1,253,0,0,2,128,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,255,255,255,248,3,255,255,255,248,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,7,255,255,254,0,7,255,255,254,0,11,128,0,46,0,15,64,0,46,0,31,0,0,46,0,47,0,0,46,0,125,0,0,46,0,252,0,0,46,0,180,0,0,46,0,16,0,0,25,0,
  // 0x793a  示
  58,121,20,20,100,22,1,253,11,255,255,255,224,11,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,254,191,255,255,255,254,0,0,60,0,0,0,0,60,0,0,1,224,60,11,0,3,208,60,11,192,7,192,60,3,224,15,64,60,1,240,63,0,60,0,188,188,0,60,0,60,116,0,60,0,60,0,47,252,0,0,0,31,244,0,0,0,0,0,0,0,
  // 0x7fa9  義
  169,127,20,22,110,22,1,253,0,0,0,20,0,0,124,0,62,0,0,61,0,124,0,47,255,255,255,252,26,170,190,170,164,5,85,189,85,80,11,255,255,255,224,0,0,60,0,0,106,170,190,170,169,191,255,255,255,254,0,90,192,1,0,63,255,231,139,128,0,61,3,194,244,106,190,171,234,185,191,255,255,255,255,0,56,1,224,160,90,191,244,247,224,191,255,160,191,128,0,56,0,254,6,0,120,27,255,75,15,248,191,75,254,6,144,36,1,184,
  // 0x8868  表
  104,136,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,42,170,254,170,168,63,255,255,255,252,0,0,60,0,0,10,170,190,170,160,15,255,255,255,240,0,0,60,0,0,0,0,60,0,0,191,255,255,255,254,127,255,255,255,253,0,7,235,64,16,0,63,71,192,188,6,253,3,211,240,191,252,1,255,128,254,60,0,253,0,16,60,0,125,0,0,60,6,47,128,0,63,255,75,244,11,255,249,2,255,11,249,0,0,46,1,0,0,0,0,
};

#endif // HAS_GRAPHICAL_TFT
