/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Greek 22pt, capital 'A' height: 16px, width: 100%, range: 0x0386-0x03ce, glyphs: 63
extern const uint8_t NotoSans_Medium_Greek_16[4013] = {
  130,16,134,3,206,3,21,250, // unifont_t
  // 0x0386  Ά
  16,16,64,16,0,0,63,1,244,0,60,2,248,0,184,3,252,0,160,7,173,0,0,15,95,0,0,15,15,0,0,46,11,128,0,61,7,192,0,124,3,208,0,254,171,224,0,255,255,240,2,245,85,244,3,224,0,188,7,192,0,124,11,192,0,62,15,64,0,47,
  // 0x0387  ·
  255,
  // 0x0388  Έ
  15,16,64,16,0,0,63,10,170,168,60,15,255,252,184,15,149,84,160,15,64,0,0,15,64,0,0,15,64,0,0,15,128,0,0,15,255,248,0,15,255,244,0,15,64,0,0,15,64,0,0,15,64,0,0,15,64,0,0,15,64,0,0,15,255,252,0,15,255,252,
  // 0x0389  Ή
  19,16,80,20,0,0,63,10,64,0,160,60,15,64,0,244,184,15,64,0,244,160,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,128,0,244,0,15,255,255,244,0,15,255,255,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,
  // 0x038a  Ί
  12,16,48,12,0,0,63,42,169,60,47,253,184,3,224,160,3,224,0,3,224,0,3,224,0,3,224,0,3,224,0,3,224,0,3,224,0,3,224,0,3,224,0,3,224,0,3,224,0,27,248,0,47,253,
  // 0x038b  ΋
  255,
  // 0x038c  Ό
  19,17,85,20,0,255,63,0,111,228,0,60,3,255,255,0,184,15,208,31,192,160,47,0,3,240,0,61,0,1,240,0,124,0,0,248,0,188,0,0,248,0,188,0,0,188,0,188,0,0,188,0,188,0,0,248,0,188,0,0,248,0,125,0,0,244,0,63,0,3,240,0,31,192,11,208,0,7,255,255,64,0,0,191,248,0,0,0,0,0,0,
  // 0x038d  ΍
  255,
  // 0x038e  Ύ
  18,16,80,18,0,0,63,26,0,2,160,60,15,64,3,208,184,11,192,15,128,160,3,208,31,0,0,2,240,62,0,0,0,244,124,0,0,0,188,248,0,0,0,63,240,0,0,0,31,208,0,0,0,15,192,0,0,0,11,128,0,0,0,11,128,0,0,0,11,128,0,0,0,11,128,0,0,0,11,128,0,0,0,11,128,0,
  // 0x038f  Ώ
  19,16,80,19,0,0,63,0,191,224,0,60,7,255,254,0,184,31,208,111,192,160,62,0,7,208,0,188,0,2,240,0,248,0,1,240,0,244,0,0,244,0,244,0,0,244,0,244,0,0,244,0,248,0,1,240,0,188,0,2,240,0,61,0,3,208,0,31,0,11,128,0,7,192,46,0,1,255,240,191,248,1,255,240,191,248,
  // 0x0390  ΐ
  255,
  // 0x0391  Α
  14,16,64,14,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x0392  Β
  11,16,48,14,2,0,170,169,0,255,255,224,249,87,244,244,0,248,244,0,184,244,0,248,248,6,240,255,255,128,255,255,224,244,0,252,244,0,124,244,0,124,244,0,188,244,1,252,255,255,240,255,255,128,
  // 0x0393  Γ
  9,16,48,11,2,0,170,170,64,255,255,128,249,85,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,
  // 0x0394  Δ
  14,16,64,14,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,244,240,0,0,240,244,0,2,224,124,0,3,208,60,0,7,192,46,0,11,128,31,0,15,0,15,64,47,0,11,192,61,0,3,192,124,0,3,224,191,255,255,240,255,255,255,240,
  // 0x0395  Ε
  9,16,48,12,2,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x0396  Ζ
  12,16,48,13,0,0,42,170,169,63,255,254,21,85,189,0,0,248,0,2,240,0,7,208,0,15,128,0,47,0,0,125,0,0,248,0,2,240,0,7,208,0,15,128,0,47,0,0,63,255,255,127,255,255,
  // 0x0397  Η
  13,16,64,16,2,0,164,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,248,0,15,64,255,255,255,64,255,255,255,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,
  // 0x0398  Θ
  15,17,68,17,1,255,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,191,252,188,188,191,252,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x0399  Ι
  6,16,32,8,1,0,170,160,255,240,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,191,208,255,240,
  // 0x039a  Κ
  12,16,48,14,2,0,164,0,41,244,0,248,244,3,240,244,11,192,244,47,0,244,124,0,245,244,0,251,240,0,255,248,0,252,125,0,244,63,0,244,15,128,244,7,208,244,2,240,244,0,252,244,0,62,
  // 0x039b  Λ
  14,16,64,14,0,0,0,31,0,0,0,63,128,0,0,63,192,0,0,187,208,0,0,246,224,0,0,240,240,0,2,224,244,0,3,208,184,0,7,192,60,0,11,128,61,0,15,64,47,0,31,0,15,0,46,0,15,128,61,0,11,192,124,0,3,192,248,0,3,224,
  // 0x039c  Μ
  16,16,64,20,2,0,169,0,0,106,255,0,0,191,255,64,0,255,251,128,1,239,247,192,3,223,243,208,3,207,241,224,11,79,240,240,15,15,244,180,30,15,244,124,45,15,244,60,60,15,244,45,120,15,244,31,244,15,244,15,240,15,244,11,224,15,244,3,192,15,
  // 0x039d  Ν
  13,16,64,17,2,0,168,0,2,128,254,0,3,192,255,64,3,192,255,192,3,192,247,224,3,192,241,240,3,192,240,252,3,192,240,61,3,192,244,47,3,192,244,15,131,192,244,7,211,192,244,2,243,192,244,0,251,192,244,0,127,192,244,0,63,192,244,0,15,192,
  // 0x039e  Ξ
  12,16,48,14,1,0,42,170,168,63,255,252,21,85,84,0,0,0,0,0,0,0,0,0,0,0,0,31,255,240,31,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,253,191,255,253,
  // 0x039f  Ο
  15,17,68,17,1,255,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x03a0  Π
  12,16,48,16,2,0,170,170,170,255,255,255,249,85,95,244,0,15,244,0,15,244,0,15,244,0,15,244,0,15,244,0,15,244,0,15,244,0,15,244,0,15,244,0,15,244,0,15,244,0,15,244,0,15,
  // 0x03a1  Ρ
  11,16,48,13,2,0,170,169,0,255,255,192,249,91,224,244,2,240,244,0,244,244,0,244,244,1,240,244,7,224,255,255,192,255,253,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,
  // 0x03a2  ΢
  255,
  // 0x03a3  Σ
  12,16,48,13,0,0,42,170,169,63,255,254,47,85,84,15,192,0,3,240,0,0,248,0,0,126,0,0,31,0,0,47,0,0,188,0,1,240,0,3,208,0,15,128,0,47,0,0,63,255,255,127,255,255,
  // 0x03a4  Τ
  12,16,48,12,0,0,170,170,170,191,255,255,21,126,85,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,
  // 0x03a5  Υ
  13,16,64,13,0,0,168,0,10,64,124,0,31,0,62,0,62,0,31,64,124,0,11,192,248,0,3,209,240,0,2,243,208,0,0,255,192,0,0,191,64,0,0,63,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,
  // 0x03a6  Φ
  17,17,85,19,1,255,0,2,208,0,0,0,2,224,0,0,1,255,255,208,0,15,255,255,252,0,63,66,224,127,0,124,2,224,15,64,248,2,224,11,128,244,2,224,11,192,248,2,224,11,192,184,2,224,15,128,125,2,224,31,64,47,130,224,190,0,11,255,255,248,0,1,191,255,128,0,0,2,224,0,0,0,2,224,0,0,0,0,0,0,0,
  // 0x03a7  Χ
  13,16,64,13,0,0,104,0,10,128,63,0,31,0,15,64,62,0,11,192,188,0,3,224,244,0,0,247,224,0,0,191,192,0,0,63,64,0,0,63,128,0,0,255,192,0,1,242,240,0,3,208,244,0,11,128,124,0,31,0,62,0,62,0,31,64,188,0,11,192,
  // 0x03a8  Ψ
  15,16,64,18,2,0,160,10,0,164,244,15,64,244,244,15,64,244,244,15,64,244,244,15,64,244,244,15,64,244,244,15,64,244,248,15,64,240,188,15,66,240,63,79,75,208,15,255,255,128,1,191,248,0,0,15,64,0,0,15,64,0,0,15,64,0,0,15,64,0,
  // 0x03a9  Ω
  16,16,64,16,0,0,0,47,248,0,2,255,255,128,11,244,27,224,31,128,2,244,47,0,0,252,62,0,0,124,61,0,0,124,61,0,0,61,61,0,0,60,61,0,0,124,47,0,0,184,15,0,0,240,11,192,3,224,2,240,15,128,127,248,47,253,127,248,47,253,
  // 0x03aa  Ϊ
  255,
  // 0x03ab  Ϋ
  255,
  // 0x03ac  ά
  13,18,72,14,1,255,0,15,64,0,0,47,0,0,0,60,0,0,0,36,0,0,0,0,0,0,7,253,56,0,47,255,188,0,62,2,252,0,188,0,252,0,184,0,188,0,248,0,124,0,248,0,124,0,248,0,188,0,188,0,252,0,62,1,252,0,47,239,191,64,11,253,47,64,0,0,0,0,
  // 0x03ad  έ
  9,18,54,11,1,255,0,63,0,0,60,0,0,120,0,0,96,0,0,0,0,11,254,64,63,255,128,188,1,0,184,0,0,125,0,0,31,248,0,47,228,0,248,0,0,244,0,0,248,0,0,191,175,128,31,255,64,0,0,0,
  // 0x03ae  ή
  10,23,69,14,2,250,0,248,0,1,240,0,2,208,0,2,128,0,0,0,0,226,255,64,251,255,192,253,3,224,248,2,240,244,1,240,240,1,240,240,1,240,240,1,240,240,1,240,240,1,240,240,1,240,240,1,240,0,1,240,0,1,240,0,1,240,0,1,240,0,1,240,0,0,64,
  // 0x03af  ί
  5,18,36,8,2,255,47,0,61,0,60,0,96,0,0,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,244,0,254,192,63,192,0,0,
  // 0x03b0  ΰ
  255,
  // 0x03b1  α
  13,13,52,14,1,255,7,253,56,0,47,255,188,0,62,2,252,0,188,0,252,0,184,0,188,0,248,0,124,0,248,0,124,0,248,0,188,0,188,0,252,0,62,1,252,0,47,239,191,64,11,253,47,64,0,0,0,0,
  // 0x03b2  β
  11,23,69,14,2,250,6,249,0,47,255,128,189,11,208,248,3,224,240,2,224,240,3,224,240,7,192,241,191,0,241,254,0,240,7,208,240,1,240,240,0,244,240,0,244,240,0,244,244,2,240,255,239,208,251,255,64,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,80,0,0,
  // 0x03b3  γ
  11,17,51,12,0,251,180,0,124,188,0,124,60,0,124,62,0,184,31,0,248,15,0,244,11,65,240,7,194,224,3,199,192,2,239,64,1,255,0,0,252,0,0,248,0,0,248,0,0,248,0,0,248,0,0,100,0,
  // 0x03b4  δ
  11,18,54,13,1,255,0,190,64,7,255,240,15,128,176,15,0,0,15,64,0,11,224,0,2,253,0,11,255,192,63,3,240,188,0,244,248,0,188,244,0,124,244,0,124,248,0,184,125,1,244,63,239,224,11,255,64,0,0,0,
  // 0x03b5  ε
  9,13,39,11,1,255,11,254,64,63,255,128,188,1,0,184,0,0,125,0,0,31,248,0,47,228,0,248,0,0,244,0,0,248,0,0,191,175,128,31,255,64,0,0,0,
  // 0x03b6  ζ
  9,22,66,10,1,251,42,170,128,63,255,192,0,15,128,0,47,0,0,124,0,0,244,0,3,224,0,11,192,0,31,0,0,62,0,0,124,0,0,184,0,0,248,0,0,252,0,0,126,0,0,63,248,0,7,255,128,0,31,192,0,3,192,0,7,192,0,11,128,0,5,0,
  // 0x03b7  η
  10,18,54,14,2,250,226,255,64,251,255,192,253,3,224,248,2,240,244,1,240,240,1,240,240,1,240,240,1,240,240,1,240,240,1,240,240,1,240,240,1,240,0,1,240,0,1,240,0,1,240,0,1,240,0,1,240,0,0,64,
  // 0x03b8  θ
  11,18,54,13,1,255,1,185,0,15,255,192,47,67,224,61,0,240,124,0,248,184,0,188,184,0,124,249,85,188,255,255,252,249,85,188,248,0,124,184,0,124,124,0,184,60,0,244,62,2,240,15,239,208,3,255,64,0,0,0,
  // 0x03b9  ι
  5,13,26,8,2,255,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,244,0,254,192,63,192,0,0,
  // 0x03ba  κ
  10,12,36,12,2,0,240,3,208,240,15,128,240,63,0,240,188,0,242,240,0,251,208,0,255,240,0,252,252,0,240,62,0,240,31,64,240,11,192,240,3,240,
  // 0x03bb  λ
  12,18,54,12,0,255,185,0,0,255,192,0,7,224,0,0,240,0,0,248,0,0,188,0,0,253,0,1,254,0,3,223,0,3,207,64,7,139,192,15,67,192,15,3,224,47,1,240,61,0,244,124,0,190,188,0,63,0,0,0,
  // 0x03bc  μ
  12,18,54,14,2,250,240,1,240,240,1,240,240,1,240,240,1,240,240,1,240,240,1,240,240,1,240,240,1,240,244,2,240,248,7,240,255,190,253,251,248,126,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,80,0,0,
  // 0x03bd  ν
  11,12,36,12,0,0,180,0,124,188,0,124,60,0,124,62,0,184,31,0,248,15,0,244,11,65,240,7,194,224,3,199,192,2,239,64,1,255,0,0,252,0,
  // 0x03be  ξ
  10,22,66,11,1,251,42,170,128,63,255,208,7,144,0,46,0,0,60,0,0,60,0,0,62,0,0,15,234,128,7,255,192,47,64,0,124,0,0,184,0,0,248,0,0,252,0,0,126,0,0,47,249,0,7,255,128,0,31,192,0,3,192,0,3,192,0,11,128,0,5,0,
  // 0x03bf  ο
  11,13,39,13,1,255,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x03c0  π
  15,13,52,15,0,255,191,255,255,244,191,255,255,244,3,192,31,0,3,192,31,0,3,192,31,0,3,192,31,0,3,192,31,0,3,192,31,0,3,192,31,0,3,192,15,0,3,192,15,224,3,192,7,240,0,0,0,0,
  // 0x03c1  ρ
  11,18,54,13,1,250,2,255,64,15,255,224,63,2,244,60,0,188,124,0,124,124,0,124,188,0,124,188,0,124,188,0,188,189,1,244,191,239,224,190,255,128,188,0,0,188,0,0,188,0,0,188,0,0,188,0,0,16,0,0,
  // 0x03c2  ς
  9,17,51,11,1,251,2,255,128,31,255,128,62,0,0,124,0,0,184,0,0,248,0,0,248,0,0,248,0,0,188,0,0,63,0,0,31,248,0,2,255,128,0,31,192,0,3,192,0,7,192,0,11,128,0,5,0,
  // 0x03c3  σ
  12,13,39,14,1,255,1,191,255,15,255,255,63,65,240,124,0,244,184,0,188,248,0,124,248,0,124,184,0,124,188,0,184,62,1,244,31,239,224,7,255,64,0,0,0,
  // 0x03c4  τ
  11,13,39,11,0,255,191,255,244,191,255,244,1,240,0,1,240,0,1,240,0,1,240,0,1,240,0,1,240,0,1,240,0,1,240,0,0,254,160,0,127,224,0,0,0,
  // 0x03c5  υ
  11,13,39,13,1,255,60,0,244,124,0,248,124,0,184,124,0,188,124,0,124,124,0,124,124,0,124,60,0,188,60,0,248,62,2,240,47,239,224,11,255,64,0,0,0,
  // 0x03c6  φ
  15,23,92,17,1,250,0,10,64,0,0,15,64,0,0,15,64,0,0,15,64,0,0,15,64,0,1,191,248,0,15,255,255,64,63,79,75,208,124,15,66,240,188,15,65,240,248,15,64,244,248,15,64,244,188,15,64,240,124,15,66,240,63,15,71,208,15,255,255,128,1,255,249,0,0,15,64,0,0,15,64,0,0,15,64,0,0,15,64,0,0,15,64,0,0,1,0,0,
  // 0x03c7  χ
  13,18,72,13,0,250,125,0,7,192,191,0,15,64,11,192,47,0,3,208,60,0,2,240,184,0,0,244,240,0,0,190,208,0,0,63,192,0,0,47,64,0,0,63,0,0,0,127,128,0,0,247,192,0,2,227,224,0,7,193,240,0,15,64,248,0,47,0,127,128,60,0,47,192,16,0,1,0,
  // 0x03c8  ψ
  15,23,92,17,1,250,0,6,64,0,0,11,128,0,0,11,128,0,0,11,128,0,0,11,128,0,60,11,129,240,124,11,128,240,124,11,128,244,124,11,128,244,124,11,128,244,124,11,128,184,124,11,128,180,60,11,128,244,61,11,128,240,47,11,135,224,15,255,255,192,2,255,253,0,0,11,128,0,0,11,128,0,0,11,128,0,0,11,128,0,0,11,128,0,0,1,0,0,
  // 0x03c9  ω
  16,13,52,18,1,255,15,64,1,240,46,0,0,184,61,0,0,60,124,0,0,61,188,3,192,46,184,3,192,46,184,3,192,46,184,3,192,46,124,3,192,61,61,11,224,124,47,254,190,248,11,252,63,224,0,0,0,0,
  // 0x03ca  ϊ
  255,
  // 0x03cb  ϋ
  255,
  // 0x03cc  ό
  11,18,54,13,1,255,0,15,128,0,31,0,0,45,0,0,40,0,0,0,0,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x03cd  ύ
  11,18,54,13,1,255,0,31,64,0,46,0,0,60,0,0,36,0,0,0,0,60,0,244,124,0,248,124,0,184,124,0,188,124,0,124,124,0,124,124,0,124,60,0,188,60,0,248,62,2,240,47,239,224,11,255,64,0,0,0,
  // 0x03ce  ώ
  16,18,72,18,1,255,0,0,188,0,0,0,244,0,0,1,224,0,0,1,128,0,0,0,0,0,15,64,1,240,46,0,0,184,61,0,0,60,124,0,0,61,188,3,192,46,184,3,192,46,184,3,192,46,184,3,192,46,124,3,192,61,61,11,224,124,47,254,190,248,11,252,63,224,0,0,0,0,
};

#endif // HAS_GRAPHICAL_TFT
