/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Vietnamese 19pt, capital 'A' height: 14px, width: 100%, range: 0x0102-0x1ef9, glyphs: 107
extern const uint8_t NotoSans_Medium_Vietnamese_14[6582] = {
  162,14,2,1,249,30,18,251, // unifont_t
  // 0x0102  Ă
  2,1,12,17,51,12,0,0,3,129,192,1,255,128,0,20,0,0,40,0,0,126,0,0,191,0,0,247,64,1,227,192,3,195,192,3,193,224,11,64,240,15,234,244,31,255,248,45,0,60,60,0,45,120,0,31,244,0,15,
  // 0x0103  ă
  3,1,9,15,45,11,1,255,44,13,0,15,252,0,1,80,0,1,80,0,47,253,0,41,31,0,0,11,64,0,11,64,47,255,64,189,11,64,240,11,64,240,15,64,249,191,64,63,227,64,0,0,0,
  // 0x0110  Đ
  16,1,13,14,56,14,0,0,10,169,0,0,15,255,240,0,15,1,252,0,15,0,47,0,15,0,15,64,15,0,11,128,111,168,7,128,127,252,7,128,15,0,7,128,15,0,15,64,15,0,31,0,15,0,126,0,15,175,248,0,15,255,128,0,
  // 0x0111  đ
  17,1,11,16,48,12,1,255,0,1,64,0,3,192,1,255,248,1,171,228,0,3,192,31,247,192,62,111,192,184,7,192,244,3,192,240,3,192,240,3,192,240,3,192,184,7,192,63,175,192,31,246,192,0,0,0,
  // 0x0128  Ĩ
  40,1,7,17,34,7,0,0,126,28,235,244,64,80,42,160,63,240,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,31,144,127,240,
  // 0x0129  ĩ
  41,1,7,14,28,5,255,0,62,12,235,248,64,80,0,0,7,128,7,128,7,128,7,128,7,128,7,128,7,128,7,128,7,128,7,128,
  // 0x0168  Ũ
  104,1,12,18,54,14,1,255,2,244,144,7,111,192,1,1,0,36,0,24,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,61,60,0,60,62,0,188,15,235,240,2,255,128,0,0,0,
  // 0x0169  ũ
  105,1,10,15,45,12,1,255,11,211,64,29,255,0,20,4,0,0,0,0,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,3,208,124,7,208,63,175,208,31,249,208,0,0,0,
  // 0x01a0  Ơ
  160,1,15,16,64,15,1,255,0,0,0,80,0,174,64,180,11,255,244,240,47,64,127,208,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,
  // 0x01a1  ơ
  161,1,12,13,39,12,1,255,0,0,30,1,80,45,31,254,124,62,95,240,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,
  // 0x01af  Ư
  175,1,15,16,64,15,1,255,0,0,0,20,36,0,24,120,124,0,45,180,124,0,47,224,124,0,46,64,124,0,45,0,124,0,45,0,124,0,45,0,124,0,45,0,124,0,45,0,124,0,61,0,60,0,60,0,62,0,188,0,15,235,244,0,2,255,128,0,0,0,0,0,
  // 0x01b0  ư
  176,1,13,13,52,13,1,255,0,0,3,128,0,0,7,128,184,2,239,64,184,2,253,0,184,2,208,0,184,2,208,0,184,2,208,0,184,2,208,0,184,3,208,0,124,7,208,0,63,175,208,0,31,249,208,0,0,0,0,0,
  // 0x0303  ̃
  3,3,7,3,6,0,247,11,189,40,219,240,64,64,
  // 0x0309  ̉
  9,3,4,5,5,0,249,11,164,173,29,120,96,
  // 0x0323  ̣
  35,3,3,3,3,0,249,252,96,244,80,
  // 0x0340  ̀
  64,3,4,4,4,0,253,11,160,184,45,5,
  // 0x0341  ́
  65,3,4,4,4,0,255,11,10,46,120,80,
  // 0x1ea0  Ạ
  160,30,12,18,54,12,0,252,0,40,0,0,126,0,0,191,0,0,247,64,1,227,192,3,195,192,3,193,224,11,64,240,15,234,244,31,255,248,45,0,60,60,0,45,120,0,31,244,0,15,0,0,0,0,24,0,0,61,0,0,20,0,
  // 0x1ea1  ạ
  161,30,9,15,45,11,1,252,1,80,0,47,253,0,41,31,0,0,11,64,0,11,64,47,255,64,189,11,64,240,11,64,240,15,64,249,191,64,63,227,64,0,0,0,1,128,0,2,224,0,0,64,0,
  // 0x1ea2  Ả
  162,30,12,19,57,12,0,0,0,40,0,0,111,0,0,7,0,0,45,0,0,20,0,0,40,0,0,126,0,0,191,0,0,247,64,1,227,192,3,195,192,3,193,224,11,64,240,15,234,244,31,255,248,45,0,60,60,0,45,120,0,31,244,0,15,
  // 0x1ea3  ả
  163,30,9,17,51,11,1,255,2,144,0,2,180,0,0,52,0,1,224,0,1,128,0,1,80,0,47,253,0,41,31,0,0,11,64,0,11,64,47,255,64,189,11,64,240,11,64,240,15,64,249,191,64,63,227,64,0,0,0,
  // 0x1ea4  Ấ
  164,30,12,19,57,12,0,0,0,0,24,0,20,56,0,191,80,1,211,128,1,0,64,0,40,0,0,126,0,0,191,0,0,247,64,1,227,192,3,195,192,3,193,224,11,64,240,15,234,244,31,255,248,45,0,60,60,0,45,120,0,31,244,0,15,
  // 0x1ea5  ấ
  165,30,10,17,51,11,1,255,0,0,80,0,2,192,3,242,0,14,60,0,20,4,0,1,80,0,47,253,0,41,31,0,0,11,64,0,11,64,47,255,64,189,11,64,240,11,64,240,15,64,249,191,64,63,227,64,0,0,0,
  // 0x1ea6  Ầ
  166,30,12,19,57,12,0,0,36,0,0,29,20,0,5,191,0,1,211,128,1,0,64,0,40,0,0,126,0,0,191,0,0,247,64,1,227,192,3,195,192,3,193,224,11,64,240,15,234,244,31,255,248,45,0,60,60,0,45,120,0,31,244,0,15,
  // 0x1ea7  ầ
  167,30,10,17,51,11,0,255,80,0,0,116,0,0,8,252,0,3,143,0,5,1,0,0,84,0,11,255,64,10,71,192,0,2,208,0,2,208,11,255,208,47,66,208,60,2,208,60,3,208,62,111,208,15,248,208,0,0,0,
  // 0x1ea8  Ẩ
  168,30,12,20,60,12,0,0,0,0,160,0,0,44,0,20,52,0,191,16,1,211,128,1,0,64,0,40,0,0,126,0,0,191,0,0,247,64,1,227,192,3,195,192,3,193,224,11,64,240,15,234,244,31,255,248,45,0,60,60,0,45,120,0,31,244,0,15,
  // 0x1ea9  ẩ
  169,30,9,18,54,11,1,255,0,2,64,0,1,192,0,2,192,3,242,0,14,60,0,20,4,0,1,80,0,47,253,0,41,31,0,0,11,64,0,11,64,47,255,64,189,11,64,240,11,64,240,15,64,249,191,64,63,227,64,0,0,0,
  // 0x1eaa  Ẫ
  170,30,12,20,60,12,0,0,0,244,192,2,159,128,0,20,0,0,127,0,1,211,128,1,0,64,0,40,0,0,126,0,0,191,0,0,247,64,1,227,192,3,195,192,3,193,224,11,64,240,15,234,244,31,255,248,45,0,60,60,0,45,120,0,31,244,0,15,
  // 0x1eab  ẫ
  171,30,9,18,54,11,1,255,10,69,0,30,252,0,0,16,0,3,240,0,14,60,0,20,4,0,1,80,0,47,253,0,41,31,0,0,11,64,0,11,64,47,255,64,189,11,64,240,11,64,240,15,64,249,191,64,63,227,64,0,0,0,
  // 0x1eac  Ậ
  172,30,12,22,66,12,0,252,0,41,0,0,191,0,2,211,192,1,0,80,0,40,0,0,126,0,0,191,0,0,247,64,1,227,192,3,195,192,3,193,224,11,64,240,15,234,244,31,255,248,45,0,60,60,0,45,120,0,31,244,0,15,0,0,0,0,24,0,0,61,0,0,4,0,
  // 0x1ead  ậ
  173,30,9,19,57,11,1,252,1,144,0,7,244,0,30,44,0,20,5,0,1,80,0,47,253,0,41,31,0,0,11,64,0,11,64,47,255,64,189,11,64,240,11,64,240,15,64,249,191,64,63,227,64,0,0,0,1,128,0,3,208,0,0,64,0,
  // 0x1eae  Ắ
  174,30,12,19,57,12,0,0,0,11,0,0,28,64,2,129,192,0,255,64,0,4,0,0,40,0,0,126,0,0,191,0,0,247,64,1,227,192,3,195,192,3,193,224,11,64,240,15,234,244,31,255,248,45,0,60,60,0,45,120,0,31,244,0,15,
  // 0x1eaf  ắ
  175,30,9,17,51,11,1,255,0,116,0,0,208,0,28,12,0,15,248,0,1,80,0,1,80,0,47,253,0,41,31,0,0,11,64,0,11,64,47,255,64,189,11,64,240,11,64,240,15,64,249,191,64,63,227,64,0,0,0,
  // 0x1eb0  Ằ
  176,30,12,19,57,12,0,0,0,176,0,0,40,64,2,129,192,0,255,64,0,4,0,0,40,0,0,126,0,0,191,0,0,247,64,1,227,192,3,195,192,3,193,224,11,64,240,15,234,244,31,255,248,45,0,60,60,0,45,120,0,31,244,0,15,
  // 0x1eb1  ằ
  177,30,9,17,51,11,1,255,11,0,0,2,192,0,28,12,0,15,248,0,1,80,0,1,80,0,47,253,0,41,31,0,0,11,64,0,11,64,47,255,64,189,11,64,240,11,64,240,15,64,249,191,64,63,227,64,0,0,0,
  // 0x1eb2  Ẳ
  178,30,12,20,60,12,0,0,0,56,0,0,10,0,0,28,64,2,129,192,0,255,64,0,4,0,0,40,0,0,126,0,0,191,0,0,247,64,1,227,192,3,195,192,3,193,224,11,64,240,15,234,244,31,255,248,45,0,60,60,0,45,120,0,31,244,0,15,
  // 0x1eb3  ẳ
  179,30,9,18,54,11,1,255,1,128,0,0,112,0,0,208,0,28,13,0,15,248,0,1,80,0,1,80,0,47,253,0,41,31,0,0,11,64,0,11,64,47,255,64,189,11,64,240,11,64,240,15,64,249,191,64,63,227,64,0,0,0,
  // 0x1eb4  Ẵ
  180,30,12,20,60,12,0,0,0,244,128,2,159,192,1,0,0,2,129,192,0,255,64,0,20,0,0,40,0,0,126,0,0,191,0,0,247,64,1,227,192,3,195,192,3,193,224,11,64,240,15,234,244,31,255,248,45,0,60,60,0,45,120,0,31,244,0,15,
  // 0x1eb5  ẵ
  181,30,9,18,54,11,1,255,10,69,0,30,252,0,0,0,0,28,12,0,15,252,0,1,80,0,1,80,0,47,253,0,41,31,0,0,11,64,0,11,64,47,255,64,189,11,64,240,11,64,240,15,64,249,191,64,63,227,64,0,0,0,
  // 0x1eb6  Ặ
  182,30,12,21,63,12,0,252,2,129,192,0,255,128,0,20,0,0,40,0,0,126,0,0,191,0,0,247,64,1,227,192,3,195,192,3,193,224,11,64,240,15,234,244,31,255,248,45,0,60,60,0,45,120,0,31,244,0,15,0,0,0,0,24,0,0,61,0,0,4,0,
  // 0x1eb7  ặ
  183,30,9,18,54,11,1,252,28,13,0,15,252,0,1,80,0,1,80,0,47,253,0,41,31,0,0,11,64,0,11,64,47,255,64,189,11,64,240,11,64,240,15,64,249,191,64,63,227,64,0,0,0,2,128,0,3,192,0,1,64,0,
  // 0x1eb8  Ẹ
  184,30,8,18,36,11,2,252,170,168,255,253,240,0,240,0,240,0,240,0,255,252,255,252,240,0,240,0,240,0,240,0,255,253,255,253,0,0,2,64,7,192,1,0,
  // 0x1eb9  ẹ
  185,30,9,15,45,11,1,252,1,80,0,15,253,0,61,31,64,180,7,128,244,7,192,255,255,192,245,85,64,244,0,0,120,0,0,63,155,64,11,255,64,0,0,0,0,144,0,1,240,0,0,64,0,
  // 0x1eba  Ẻ
  186,30,8,19,38,11,2,0,10,64,10,224,0,224,3,192,3,0,170,168,255,253,240,0,240,0,240,0,240,0,255,252,255,252,240,0,240,0,240,0,240,0,255,253,255,253,
  // 0x1ebb  ẻ
  187,30,9,17,51,11,1,255,1,144,0,1,184,0,0,60,0,0,240,0,0,192,0,1,80,0,15,253,0,61,31,64,180,7,128,244,7,192,255,255,192,245,85,64,244,0,0,120,0,0,63,155,64,11,255,64,0,0,0,
  // 0x1ebc  Ẽ
  188,30,8,17,34,11,2,0,62,12,183,252,64,80,170,168,255,253,240,0,240,0,240,0,240,0,255,252,255,252,240,0,240,0,240,0,240,0,255,253,255,253,
  // 0x1ebd  ẽ
  189,30,9,15,45,11,1,255,31,135,0,58,254,0,16,20,0,1,80,0,15,253,0,61,31,64,180,7,128,244,7,192,255,255,192,245,85,64,244,0,0,120,0,0,63,155,64,11,255,64,0,0,0,
  // 0x1ebe  Ế
  190,30,9,19,57,11,2,0,0,2,64,1,71,0,15,216,0,56,176,0,16,0,0,170,168,0,255,253,0,240,0,0,240,0,0,240,0,0,240,0,0,255,252,0,255,252,0,240,0,0,240,0,0,240,0,0,240,0,0,255,253,0,255,253,0,
  // 0x1ebf  ế
  191,30,10,17,51,11,1,255,0,0,80,0,1,208,3,242,0,15,44,0,4,5,0,1,80,0,15,253,0,61,31,64,180,7,128,244,7,192,255,255,192,245,85,64,244,0,0,120,0,0,63,155,64,11,255,64,0,0,0,
  // 0x1ec0  Ề
  192,30,10,19,57,11,0,0,96,0,0,60,20,0,5,253,0,3,199,0,1,0,64,10,170,128,15,255,208,15,0,0,15,0,0,15,0,0,15,0,0,15,255,192,15,255,192,15,0,0,15,0,0,15,0,0,15,0,0,15,255,208,15,255,208,
  // 0x1ec1  ề
  193,30,10,17,51,11,0,255,80,0,0,56,0,0,8,253,0,2,203,0,1,1,64,0,84,0,3,255,64,15,71,208,45,1,224,61,1,240,63,255,240,61,85,80,61,0,0,30,0,0,15,230,208,2,255,208,0,0,0,
  // 0x1ec2  Ể
  194,30,9,20,60,11,2,0,0,9,0,0,3,64,1,74,0,15,212,0,56,176,0,16,0,0,170,168,0,255,253,0,240,0,0,240,0,0,240,0,0,240,0,0,255,252,0,255,252,0,240,0,0,240,0,0,240,0,0,240,0,0,255,253,0,255,253,0,
  // 0x1ec3  ể
  195,30,9,18,54,11,1,255,0,2,64,0,1,192,0,2,192,3,242,0,15,60,0,4,4,0,1,80,0,15,253,0,61,31,64,180,7,128,244,7,192,255,255,192,245,85,64,244,0,0,120,0,0,63,155,64,11,255,64,0,0,0,
  // 0x1ec4  Ễ
  196,30,8,20,40,11,2,0,46,24,118,240,1,64,15,192,60,176,16,0,170,168,255,253,240,0,240,0,240,0,240,0,255,252,255,252,240,0,240,0,240,0,240,0,255,253,255,253,
  // 0x1ec5  ễ
  197,30,9,18,54,11,1,255,10,69,0,30,252,0,0,16,0,3,240,0,15,60,0,4,5,0,1,80,0,15,253,0,61,31,64,180,7,128,244,7,192,255,255,192,245,85,64,244,0,0,120,0,0,63,155,64,11,255,64,0,0,0,
  // 0x1ec6  Ệ
  198,30,8,22,44,11,2,252,6,128,15,224,60,120,80,4,170,168,255,253,240,0,240,0,240,0,240,0,255,252,255,252,240,0,240,0,240,0,240,0,255,253,255,253,0,0,2,64,7,192,1,0,
  // 0x1ec7  ệ
  199,30,9,19,57,11,1,252,1,144,0,7,244,0,30,45,0,20,5,0,1,80,0,15,253,0,61,31,64,180,7,128,244,7,192,255,255,192,245,85,64,244,0,0,120,0,0,63,155,64,11,255,64,0,0,0,0,144,0,1,240,0,0,64,0,
  // 0x1ec8  Ỉ
  200,30,6,19,38,7,0,0,11,128,6,208,1,208,7,64,2,0,42,160,63,240,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,31,144,127,240,
  // 0x1ec9  ỉ
  201,30,4,16,16,5,1,0,164,174,14,60,48,0,120,120,120,120,120,120,120,120,120,120,
  // 0x1eca  Ị
  202,30,6,18,36,7,0,252,42,160,63,240,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,31,144,127,240,0,0,6,0,15,64,1,0,
  // 0x1ecb  ị
  203,30,3,18,18,5,1,252,120,120,0,0,120,120,120,120,120,120,120,120,120,120,0,36,184,16,
  // 0x1ecc  Ọ
  204,30,13,18,72,15,1,252,0,174,64,0,11,255,244,0,47,64,125,0,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,0,24,0,0,0,46,0,0,0,4,0,0,
  // 0x1ecd  ọ
  205,30,10,15,45,12,1,252,1,80,0,31,254,0,62,95,128,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,0,144,0,1,240,0,0,80,0,
  // 0x1ece  Ỏ
  206,30,13,20,80,15,1,255,0,46,0,0,0,27,128,0,0,3,128,0,0,30,0,0,0,8,0,0,0,174,64,0,11,255,244,0,47,64,125,0,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,
  // 0x1ecf  ỏ
  207,30,10,17,51,12,1,255,1,160,0,1,188,0,0,44,0,0,244,0,0,144,0,1,80,0,31,254,0,62,95,128,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,
  // 0x1ed0  Ố
  208,30,13,20,80,15,1,255,0,0,9,0,0,20,44,0,0,127,96,0,0,226,192,0,0,0,64,0,0,174,64,0,11,255,244,0,47,64,125,0,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,
  // 0x1ed1  ố
  209,30,10,17,51,12,1,255,0,0,80,0,1,208,3,246,64,11,44,0,4,5,0,1,80,0,31,254,0,62,95,128,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,
  // 0x1ed2  Ồ
  210,30,13,20,80,15,1,255,24,0,0,0,14,4,0,0,2,127,0,0,0,226,192,0,0,64,64,0,0,174,64,0,11,255,244,0,47,64,125,0,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,
  // 0x1ed3  ồ
  211,30,10,17,51,12,1,255,64,0,0,240,0,0,39,244,0,11,44,0,4,5,0,1,80,0,31,254,0,62,95,128,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,
  // 0x1ed4  Ổ
  212,30,13,21,84,15,1,255,0,0,100,0,0,0,28,0,0,20,40,0,0,127,32,0,0,226,192,0,0,0,64,0,0,174,64,0,11,255,244,0,47,64,125,0,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,
  // 0x1ed5  ổ
  213,30,10,18,54,12,1,255,0,2,64,0,1,208,0,1,192,3,245,0,11,44,0,4,5,0,1,80,0,31,254,0,62,95,128,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,
  // 0x1ed6  Ỗ
  214,30,13,21,84,15,1,255,0,184,144,0,1,159,192,0,0,4,0,0,0,63,0,0,0,226,192,0,0,0,64,0,0,174,64,0,11,255,244,0,47,64,125,0,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,
  // 0x1ed7  ỗ
  215,30,10,18,54,12,1,255,6,130,0,14,253,0,0,16,0,2,244,0,11,108,0,4,5,0,1,80,0,31,254,0,62,95,128,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,
  // 0x1ed8  Ộ
  216,30,13,22,88,15,1,252,0,25,0,0,0,127,64,0,1,226,192,0,1,64,80,0,0,174,64,0,11,255,244,0,47,64,125,0,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,0,24,0,0,0,46,0,0,0,4,0,0,
  // 0x1ed9  ộ
  217,30,10,19,57,12,1,252,1,160,0,3,248,0,15,30,0,20,1,0,1,80,0,31,254,0,62,95,128,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,0,144,0,1,240,0,0,80,0,
  // 0x1eda  Ớ
  218,30,15,19,76,15,1,255,0,2,128,0,0,11,128,0,0,30,0,0,0,20,0,80,0,174,64,180,11,255,244,240,47,64,127,208,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,
  // 0x1edb  ớ
  219,30,12,16,48,12,1,255,0,25,0,0,124,0,0,240,0,0,64,30,1,80,45,31,254,124,62,95,240,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,
  // 0x1edc  Ờ
  220,30,15,19,76,15,1,255,0,160,0,0,0,184,0,0,0,45,0,0,0,5,0,80,0,174,64,180,11,255,244,240,47,64,127,208,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,
  // 0x1edd  ờ
  221,30,12,16,48,12,1,255,10,64,0,7,192,0,1,224,0,0,16,30,1,80,45,31,254,124,62,95,240,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,
  // 0x1ede  Ở
  222,30,15,20,80,15,1,255,0,41,0,0,0,43,64,0,0,3,64,0,0,30,0,0,0,24,0,80,0,174,64,180,11,255,244,240,47,64,127,208,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,
  // 0x1edf  ở
  223,30,12,17,51,12,1,255,1,144,0,2,184,0,0,60,0,0,240,0,0,192,30,1,80,45,31,254,124,62,95,240,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,
  // 0x1ee0  Ỡ
  224,30,15,18,72,15,1,255,1,248,112,0,3,175,208,0,1,1,64,80,0,174,64,180,11,255,244,240,47,64,127,208,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,
  // 0x1ee1  ỡ
  225,30,12,15,45,12,1,255,15,131,0,45,255,0,16,20,30,1,80,45,31,254,124,62,95,240,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,
  // 0x1ee2  Ợ
  226,30,15,19,76,15,1,252,0,0,0,80,0,174,64,180,11,255,244,240,47,64,127,208,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,0,24,0,0,0,46,0,0,0,4,0,0,
  // 0x1ee3  ợ
  227,30,12,16,48,12,1,252,0,0,30,1,80,45,31,254,124,62,95,240,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,0,144,0,1,240,0,0,80,0,
  // 0x1ee4  Ụ
  228,30,12,18,54,14,1,252,36,0,24,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,61,60,0,60,62,0,188,15,235,240,2,255,128,0,0,0,0,40,0,0,60,0,0,20,0,
  // 0x1ee5  ụ
  229,30,10,14,42,12,1,252,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,3,208,124,7,208,63,175,208,31,249,208,0,0,0,0,144,0,1,240,0,0,64,0,
  // 0x1ee6  Ủ
  230,30,12,20,60,14,1,255,0,121,0,0,95,0,0,11,0,0,60,0,0,20,0,36,0,24,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,61,60,0,60,62,0,188,15,235,240,2,255,128,0,0,0,
  // 0x1ee7  ủ
  231,30,10,17,51,12,1,255,1,160,0,1,188,0,0,44,0,0,244,0,0,144,0,0,0,0,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,3,208,124,7,208,63,175,208,31,249,208,0,0,0,
  // 0x1ee8  Ứ
  232,30,15,19,76,15,1,255,0,6,64,0,0,15,0,0,0,44,0,0,0,16,0,20,36,0,24,120,124,0,45,180,124,0,47,224,124,0,46,64,124,0,45,0,124,0,45,0,124,0,45,0,124,0,45,0,124,0,45,0,124,0,61,0,60,0,60,0,62,0,188,0,15,235,244,0,2,255,128,0,0,0,0,0,
  // 0x1ee9  ứ
  233,30,13,16,64,13,1,255,0,25,0,0,0,60,0,0,0,240,0,0,0,64,3,128,0,0,7,128,184,2,239,64,184,2,253,0,184,2,208,0,184,2,208,0,184,2,208,0,184,2,208,0,184,3,208,0,124,7,208,0,63,175,208,0,31,249,208,0,0,0,0,0,
  // 0x1eea  Ừ
  234,30,15,19,76,15,1,255,1,144,0,0,0,240,0,0,0,60,0,0,0,4,0,20,36,0,24,120,124,0,45,180,124,0,47,224,124,0,46,64,124,0,45,0,124,0,45,0,124,0,45,0,124,0,45,0,124,0,45,0,124,0,61,0,60,0,60,0,62,0,188,0,15,235,244,0,2,255,128,0,0,0,0,0,
  // 0x1eeb  ừ
  235,30,13,16,64,13,1,255,6,64,0,0,3,192,0,0,0,240,0,0,0,16,3,128,0,0,7,128,184,2,239,64,184,2,253,0,184,2,208,0,184,2,208,0,184,2,208,0,184,2,208,0,184,3,208,0,124,7,208,0,63,175,208,0,31,249,208,0,0,0,0,0,
  // 0x1eec  Ử
  236,30,15,20,80,15,1,255,0,121,0,0,0,27,0,0,0,11,0,0,0,45,0,0,0,20,0,20,36,0,24,120,124,0,45,180,124,0,47,224,124,0,46,64,124,0,45,0,124,0,45,0,124,0,45,0,124,0,45,0,124,0,45,0,124,0,61,0,60,0,60,0,62,0,188,0,15,235,244,0,2,255,128,0,0,0,0,0,
  // 0x1eed  ử
  237,30,13,17,68,13,1,255,1,160,0,0,1,188,0,0,0,44,0,0,0,244,0,0,0,144,3,128,0,0,7,128,184,2,239,64,184,2,253,0,184,2,208,0,184,2,208,0,184,2,208,0,184,2,208,0,184,3,208,0,124,7,208,0,63,175,208,0,31,249,208,0,0,0,0,0,
  // 0x1eee  Ữ
  238,30,15,18,72,15,1,255,2,244,208,0,7,111,192,0,5,1,0,20,36,0,24,120,124,0,45,180,124,0,47,224,124,0,46,64,124,0,45,0,124,0,45,0,124,0,45,0,124,0,45,0,124,0,45,0,124,0,61,0,60,0,60,0,62,0,188,0,15,235,244,0,2,255,128,0,0,0,0,0,
  // 0x1eef  ữ
  239,30,13,15,60,13,1,255,11,211,64,0,29,255,0,0,20,4,3,128,0,0,7,128,184,2,239,64,184,2,253,0,184,2,208,0,184,2,208,0,184,2,208,0,184,2,208,0,184,3,208,0,124,7,208,0,63,175,208,0,31,249,208,0,0,0,0,0,
  // 0x1ef0  Ự
  240,30,15,19,76,15,1,252,0,0,0,20,36,0,24,120,124,0,45,180,124,0,47,224,124,0,46,64,124,0,45,0,124,0,45,0,124,0,45,0,124,0,45,0,124,0,45,0,124,0,61,0,60,0,60,0,62,0,188,0,15,235,244,0,2,255,128,0,0,0,0,0,0,40,0,0,0,60,0,0,0,20,0,0,
  // 0x1ef1  ự
  241,30,13,16,64,13,1,252,0,0,3,128,0,0,7,128,184,2,239,64,184,2,253,0,184,2,208,0,184,2,208,0,184,2,208,0,184,2,208,0,184,3,208,0,124,7,208,0,63,175,208,0,31,249,208,0,0,0,0,0,0,144,0,0,1,240,0,0,0,64,0,0,
  // 0x1ef2  Ỳ
  242,30,11,18,54,11,0,0,2,128,0,1,240,0,0,116,0,0,20,0,96,0,40,124,0,180,61,0,240,31,2,208,15,71,192,7,207,64,2,239,0,0,252,0,0,184,0,0,120,0,0,120,0,0,120,0,0,120,0,0,120,0,
  // 0x1ef3  ỳ
  243,30,10,20,60,10,0,251,6,64,0,3,208,0,0,240,0,0,16,0,0,0,0,180,1,224,124,3,208,60,3,192,30,7,128,15,15,0,11,79,0,7,157,0,3,252,0,1,248,0,0,244,0,0,240,0,1,224,0,7,192,0,191,64,0,100,0,0,
  // 0x1ef4  Ỵ
  244,30,11,18,54,11,0,252,96,0,40,124,0,180,61,0,240,31,2,208,15,71,192,7,207,64,2,239,0,0,252,0,0,184,0,0,120,0,0,120,0,0,120,0,0,120,0,0,120,0,0,0,0,0,100,0,0,184,0,0,16,0,
  // 0x1ef5  ỵ
  245,30,10,15,45,10,0,251,180,1,224,124,3,208,60,3,192,30,7,128,15,15,0,11,79,0,7,157,0,3,252,0,1,248,0,0,244,0,0,240,0,1,226,64,7,199,192,191,65,0,100,0,0,
  // 0x1ef6  Ỷ
  246,30,11,19,57,11,0,0,0,184,0,0,110,0,0,14,0,0,56,0,0,32,0,96,0,40,124,0,180,61,0,240,31,2,208,15,71,192,7,207,64,2,239,0,0,252,0,0,184,0,0,120,0,0,120,0,0,120,0,0,120,0,0,120,0,
  // 0x1ef7  ỷ
  247,30,10,21,63,10,0,251,1,160,0,1,188,0,0,44,0,0,180,0,0,144,0,0,0,0,180,1,224,124,3,208,60,3,192,30,7,128,15,15,0,11,79,0,7,157,0,3,252,0,1,248,0,0,244,0,0,240,0,1,224,0,7,192,0,191,64,0,100,0,0,
  // 0x1ef8  Ỹ
  248,30,11,17,51,11,0,0,3,225,192,14,191,128,4,5,0,96,0,40,124,0,180,61,0,240,31,2,208,15,71,192,7,207,64,2,239,0,0,252,0,0,184,0,0,120,0,0,120,0,0,120,0,0,120,0,0,120,0,
  // 0x1ef9  ỹ
  249,30,10,19,57,10,0,251,11,211,64,29,255,0,20,4,0,0,0,0,180,1,224,124,3,208,60,3,192,30,7,128,15,15,0,11,79,0,7,157,0,3,252,0,1,248,0,0,244,0,0,240,0,1,224,0,7,192,0,191,64,0,100,0,0,
};

#endif // HAS_GRAPHICAL_TFT
