/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Simplified Chinese 19pt, capital 'A' height: 14px, width: 100%, range: 0x201c-0xff1a, glyphs: 373
extern const uint8_t NotoSans_Medium_Simplified_Chinese_14[37028] = {
  162,14,28,32,26,255,18,251, // unifont_t
  // 0x201c  “
  28,32,7,6,12,7,0,8,8,24,44,60,60,120,120,180,180,240,0,0,
  // 0x201d  ”
  29,32,7,6,12,7,0,8,24,40,60,124,56,116,116,176,176,224,0,0,
  // 0x22bf  ⊿
  191,34,15,15,60,19,2,0,0,0,0,36,0,0,0,180,0,0,2,244,0,0,11,244,0,0,30,52,0,0,124,52,0,1,240,52,0,7,192,52,0,31,0,52,0,60,0,52,0,240,0,52,3,192,0,52,15,0,0,52,63,170,170,180,255,255,255,244,
  // 0x4e00  一
  0,78,17,2,10,19,1,7,255,255,255,255,192,255,255,255,255,192,
  // 0x4e09  三
  9,78,17,15,75,19,1,0,31,255,255,254,0,47,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,255,255,240,0,7,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,128,191,255,255,255,128,
  // 0x4e0a  上
  10,78,17,18,90,19,1,255,0,1,64,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,255,254,0,0,3,255,254,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,255,255,255,255,192,255,255,255,255,192,
  // 0x4e0b  下
  11,78,17,17,85,19,1,254,255,255,255,255,192,191,255,255,255,128,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,248,0,0,0,3,255,64,0,0,3,203,244,0,0,3,192,254,0,0,3,192,45,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,2,128,0,0,
  // 0x4e0d  不
  13,78,17,17,85,19,1,254,191,255,255,255,128,191,255,255,255,128,0,0,244,0,0,0,3,224,0,0,0,11,208,0,0,0,31,238,0,0,0,127,239,192,0,1,245,210,244,0,11,209,208,126,0,127,65,208,31,128,248,1,208,3,128,16,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,144,0,0,
  // 0x4e13  专
  19,78,17,19,95,19,1,254,0,2,64,0,0,0,7,64,0,0,26,175,234,168,0,31,255,255,253,0,0,30,0,0,0,0,45,0,0,0,170,190,170,170,64,255,255,255,255,128,0,116,0,0,0,0,176,0,0,0,0,255,255,252,0,0,170,170,248,0,0,0,2,240,0,0,0,11,192,0,0,253,47,0,0,0,111,252,0,0,0,1,255,64,0,0,0,11,208,0,0,0,0,128,0,
  // 0x4e1d  丝
  29,78,17,18,90,19,1,255,0,64,0,64,0,0,240,0,224,0,2,208,2,208,0,3,192,3,192,0,7,71,75,3,64,15,15,14,15,64,44,30,60,30,0,127,252,191,252,0,58,240,58,244,0,1,208,2,208,0,3,128,7,128,0,15,0,31,0,0,63,255,127,255,64,63,169,63,170,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,192,170,170,170,170,128,
  // 0x4e2a  个
  42,78,19,18,90,19,0,254,0,0,248,0,0,0,2,253,0,0,0,7,207,64,0,0,31,3,208,0,0,124,1,244,0,2,240,0,62,0,15,192,100,15,208,126,0,180,2,244,36,0,180,0,32,0,0,180,0,0,0,0,180,0,0,0,0,180,0,0,0,0,180,0,0,0,0,180,0,0,0,0,180,0,0,0,0,180,0,0,0,0,180,0,0,0,0,16,0,0,
  // 0x4e2d  中
  45,78,15,19,76,19,2,254,0,6,0,0,0,7,64,0,0,7,64,0,0,7,64,0,255,255,255,252,250,175,234,188,224,7,64,44,224,7,64,44,224,7,64,44,224,7,64,44,250,175,234,188,255,255,255,252,224,7,64,44,0,7,64,0,0,7,64,0,0,7,64,0,0,7,64,0,0,7,64,0,0,6,0,0,
  // 0x4e3a  为
  58,78,16,19,76,19,1,254,0,2,0,0,11,7,64,0,7,135,64,0,3,199,64,0,0,7,64,0,127,255,255,255,127,255,255,255,0,15,0,15,0,15,0,15,0,30,32,15,0,45,124,15,0,60,45,15,0,184,15,15,0,240,5,14,3,208,0,14,15,192,0,30,63,0,0,61,188,0,15,252,16,0,11,224,
  // 0x4e3b  主
  59,78,17,18,90,19,1,255,0,1,0,0,0,0,15,128,0,0,0,3,240,0,0,0,0,248,0,0,42,170,254,170,0,63,255,255,255,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,15,255,255,252,0,10,171,250,168,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,170,171,250,170,128,255,255,255,255,192,
  // 0x4e49  义
  73,78,17,18,90,19,1,255,0,1,0,0,0,0,3,128,0,0,0,2,192,29,0,14,1,224,44,0,15,0,240,60,0,7,128,80,180,0,3,192,0,240,0,1,224,2,208,0,0,244,3,192,0,0,60,15,64,0,0,31,62,0,0,0,11,248,0,0,0,3,240,0,0,0,31,253,0,0,0,189,31,192,0,27,240,3,253,0,255,64,0,127,192,160,0,0,6,64,
  // 0x4e4b  之
  75,78,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,42,171,250,173,0,63,255,255,255,0,0,0,0,60,0,0,0,0,248,0,0,0,2,224,0,0,0,11,192,0,0,0,31,0,0,7,128,124,0,0,11,66,240,0,0,15,203,192,0,0,47,254,0,0,0,60,189,0,0,0,244,47,255,170,128,240,1,191,255,192,0,0,0,0,0,
  // 0x4e86  了
  134,78,15,17,68,19,2,254,255,255,255,244,255,255,255,244,0,0,3,208,0,0,15,128,0,0,125,0,0,7,244,0,0,7,192,0,0,7,64,0,0,7,64,0,0,7,64,0,0,7,64,0,0,7,64,0,0,7,64,0,0,7,64,0,0,7,64,0,3,255,64,0,2,233,0,0,
  // 0x4e8c  二
  140,78,17,14,70,19,1,0,15,255,255,253,0,31,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,192,255,255,255,255,192,
  // 0x4e8e  于
  142,78,17,17,85,19,1,254,47,255,255,254,0,26,171,250,169,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,170,171,250,170,128,255,255,255,255,192,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,1,224,0,0,0,255,208,0,0,0,190,64,0,0,
  // 0x4ea4  交
  164,78,17,19,95,19,1,254,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,255,255,255,255,192,170,170,170,170,128,0,96,2,128,0,1,240,3,240,0,7,208,0,188,0,47,64,1,47,64,188,116,7,139,128,32,60,15,1,0,0,46,46,0,0,0,15,188,0,0,0,3,240,0,0,0,11,248,0,0,0,191,127,128,0,47,244,7,254,64,255,128,0,191,192,32,0,0,2,0,
  // 0x4eae  亮
  174,78,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,255,255,255,255,192,85,85,85,85,64,0,0,0,0,0,7,255,255,244,0,7,64,0,180,0,7,128,0,180,0,7,255,255,244,0,85,85,85,85,0,191,255,255,255,128,176,0,0,3,128,176,56,29,3,128,96,56,30,2,64,0,180,30,0,0,1,240,30,2,128,11,208,30,3,192,255,64,15,255,128,80,0,6,169,0,
  // 0x4ece  从
  206,78,17,17,85,19,1,255,0,224,2,64,0,1,224,7,128,0,1,224,7,64,0,1,224,7,64,0,1,208,11,128,0,2,208,11,128,0,3,192,15,192,0,3,224,15,192,0,3,244,15,208,0,7,252,46,224,0,11,95,60,240,0,15,15,124,184,0,31,1,244,60,0,61,2,240,46,0,124,7,192,15,128,244,15,64,7,192,96,6,0,1,64,
  // 0x4ee4  令
  228,78,17,19,95,19,1,254,0,2,144,0,0,0,7,240,0,0,0,15,188,0,0,0,61,47,0,0,0,248,11,208,0,3,224,2,248,0,31,170,170,191,0,252,127,255,79,192,224,0,0,2,128,0,0,0,0,0,31,255,255,252,0,26,175,170,188,0,0,11,0,60,0,0,11,0,60,0,0,11,0,60,0,0,11,6,188,0,0,11,3,244,0,0,11,0,0,0,0,6,0,0,0,
  // 0x4ee5  以
  229,78,17,17,85,19,1,254,14,0,0,45,0,15,1,0,44,0,15,15,64,60,0,15,3,192,60,0,15,1,224,56,0,15,0,240,120,0,15,0,80,240,0,15,0,0,240,0,15,0,2,224,0,15,5,3,192,0,15,126,11,224,0,15,248,31,244,0,255,128,124,61,0,244,2,240,31,64,0,47,208,11,192,0,62,0,2,192,0,0,0,0,0,
  // 0x4ef6  件
  246,78,17,19,95,19,1,254,0,64,5,0,0,2,210,75,0,0,3,195,139,0,0,7,71,75,0,0,15,11,239,170,0,46,15,255,255,64,62,29,11,0,0,254,60,11,0,0,238,20,11,0,0,78,0,11,0,0,14,63,255,255,192,14,42,175,234,128,14,0,11,0,0,14,0,11,0,0,14,0,11,0,0,14,0,11,0,0,14,0,11,0,0,14,0,11,0,0,9,0,6,0,0,
  // 0x4efd  份
  253,78,18,19,95,19,0,254,0,16,0,0,0,0,180,47,252,0,0,240,26,188,0,2,208,240,30,0,3,193,208,15,0,11,131,192,11,128,31,135,64,3,208,63,143,0,1,240,123,174,170,170,160,35,134,255,255,0,3,128,29,11,0,3,128,44,11,0,3,128,44,15,0,3,128,56,15,0,3,128,116,15,0,3,128,240,15,0,3,131,208,30,0,3,143,65,253,0,3,69,0,164,0,
  // 0x4f11  休
  17,79,19,19,95,19,0,254,0,16,1,64,0,0,60,3,192,0,0,180,3,192,0,0,240,3,192,0,2,224,3,192,0,7,202,171,234,160,15,207,255,255,240,63,192,15,240,0,126,192,31,244,0,34,192,63,252,0,2,192,119,221,0,2,192,243,207,0,2,194,211,199,128,2,199,195,195,208,2,239,3,192,244,2,221,3,192,112,2,192,3,192,0,2,192,3,192,0,1,128,2,128,0,
  // 0x4f20  传
  32,79,18,19,95,19,0,254,0,16,1,0,0,0,180,11,0,0,0,242,175,170,128,2,215,255,255,192,3,192,29,0,0,11,128,44,0,0,31,154,190,170,160,63,159,255,255,240,123,128,116,0,0,35,128,176,0,0,3,128,255,255,192,3,128,170,175,128,3,128,0,46,0,3,128,4,124,0,3,128,62,240,0,3,128,15,208,0,3,128,2,240,0,3,128,0,124,0,2,64,0,16,0,
  // 0x4f4d  位
  77,79,19,19,95,19,0,254,0,16,1,64,0,0,116,3,192,0,0,240,3,192,0,1,224,3,192,0,3,203,255,255,240,11,198,170,170,160,31,192,0,0,0,127,192,224,11,64,55,192,240,15,0,19,192,176,15,0,3,192,112,30,0,3,192,116,29,0,3,192,56,44,0,3,192,56,60,0,3,192,60,56,0,3,192,0,112,0,3,207,255,255,244,3,202,170,170,160,1,64,0,0,0,
  // 0x4f4e  低
  78,79,19,19,95,19,0,254,0,16,0,0,0,0,176,0,27,128,0,242,111,255,128,2,211,254,240,0,3,195,128,240,0,11,131,128,240,0,31,131,128,240,0,127,131,255,255,240,119,131,234,250,160,19,131,128,116,0,3,131,128,116,0,3,131,128,56,0,3,131,129,124,0,3,135,255,172,16,3,143,249,29,52,3,132,0,15,52,3,134,170,171,240,3,139,255,242,224,3,128,0,0,0,
  // 0x4f53  体
  83,79,17,19,95,19,1,254,1,0,9,0,0,3,192,14,0,0,7,128,14,0,0,11,0,14,0,0,15,42,175,170,128,46,63,255,255,192,62,0,127,192,0,254,0,191,208,0,238,0,238,240,0,142,2,206,112,0,14,3,142,56,0,14,15,14,45,0,14,46,14,15,0,14,126,175,171,192,14,179,255,246,192,14,0,14,0,0,14,0,14,0,0,14,0,14,0,0,9,0,9,0,0,
  // 0x4f59  余
  89,79,17,19,95,19,1,254,0,2,144,0,0,0,7,244,0,0,0,15,125,0,0,0,60,31,128,0,1,244,7,240,0,11,192,0,254,0,127,170,170,175,192,250,255,255,210,128,64,1,208,0,0,0,1,208,0,0,42,171,250,170,0,63,255,255,255,0,0,1,208,0,0,2,129,209,208,0,7,193,208,244,0,31,1,208,62,0,188,2,208,15,64,96,63,192,3,0,0,42,64,0,0,
  // 0x4f5c  作
  92,79,17,19,95,19,1,254,0,128,16,0,0,1,224,180,0,0,3,192,240,0,0,7,129,250,170,128,15,3,255,255,192,31,7,78,0,0,63,15,14,0,0,255,45,14,0,0,255,60,15,255,192,143,0,15,170,64,15,0,14,0,0,15,0,14,0,0,15,0,15,170,128,15,0,15,255,192,15,0,14,0,0,15,0,14,0,0,15,0,14,0,0,15,0,14,0,0,10,0,9,0,0,
  // 0x4f7f  使
  127,79,18,19,95,19,0,254,0,32,1,128,0,0,116,3,192,0,0,250,171,234,160,1,239,255,255,240,3,192,3,192,0,11,192,3,192,0,15,199,255,255,224,63,199,151,213,224,123,199,67,192,224,35,199,67,192,224,3,199,255,255,224,3,194,151,213,80,3,195,131,128,0,3,193,231,64,0,3,192,191,0,0,3,192,63,128,0,3,194,251,254,64,3,207,208,111,240,2,133,0,1,80,
  // 0x4f9b  供
  155,79,18,19,95,19,0,254,0,16,16,8,0,0,180,116,29,0,0,240,116,29,0,2,208,116,29,0,3,198,254,191,160,11,139,255,255,240,31,128,116,29,0,63,128,116,29,0,123,128,116,29,0,35,128,116,29,0,3,128,116,29,0,3,143,255,255,240,3,138,170,170,160,3,128,0,0,0,3,128,120,29,0,3,128,240,15,64,3,131,192,3,192,3,143,64,1,240,2,65,0,0,64,
  // 0x4fb5  侵
  181,79,18,19,95,19,0,254,0,16,0,0,0,0,179,255,255,192,0,241,85,87,192,2,208,85,87,192,3,193,255,255,192,15,128,0,3,192,47,131,255,255,192,127,129,85,85,64,119,133,85,85,80,19,143,255,255,240,3,142,0,0,176,3,142,85,85,240,3,130,255,255,64,3,128,112,14,0,3,128,61,124,0,3,128,15,240,0,3,128,111,253,0,3,143,248,47,240,2,70,64,1,80,
  // 0x4fdd  保
  221,79,18,19,95,19,1,254,0,64,0,0,0,1,230,170,170,0,3,203,255,255,0,7,139,0,11,0,15,11,0,11,0,47,11,0,11,0,127,11,255,255,0,255,6,175,170,0,239,0,15,0,0,143,0,15,0,0,15,63,255,255,192,15,42,191,234,128,15,0,127,224,0,15,1,255,180,0,15,3,207,61,0,15,31,79,15,64,15,125,15,3,208,15,32,15,0,128,6,0,10,0,0,
  // 0x4fe1  信
  225,79,18,19,95,19,0,254,0,36,0,0,0,0,116,255,255,128,0,240,85,85,0,1,224,0,0,0,3,207,255,255,240,11,197,85,85,80,15,192,0,0,0,63,193,255,255,192,123,192,85,85,64,35,192,85,85,64,3,193,255,255,192,3,192,0,0,0,3,192,85,85,64,3,194,255,255,192,3,194,192,2,192,3,194,192,2,192,3,194,213,87,192,3,194,255,255,192,2,129,192,2,128,
  // 0x503c  值
  60,80,17,19,95,19,1,254,0,64,6,0,0,2,208,15,0,0,3,218,175,170,64,7,111,255,255,128,15,0,29,0,0,30,1,109,84,0,62,11,255,254,0,190,11,0,14,0,254,11,85,94,0,142,11,255,254,0,14,11,0,14,0,14,11,255,254,0,14,11,0,30,0,14,11,0,14,0,14,11,255,254,0,14,11,85,94,0,14,31,85,111,64,14,127,255,255,192,9,0,0,0,0,
  // 0x503e  倾
  62,80,18,19,95,19,0,254,0,64,0,0,0,1,208,21,85,80,3,196,47,255,240,3,141,0,56,0,11,77,0,112,0,15,13,15,255,208,47,15,239,170,208,63,14,158,33,208,123,13,14,53,208,39,13,14,53,208,7,13,14,53,208,7,13,14,53,208,7,14,158,53,208,7,31,206,113,208,7,46,0,176,0,7,0,1,239,0,7,0,7,195,208,7,0,47,0,240,2,0,20,0,16,
  // 0x504f  偏
  79,80,18,19,95,19,0,254,0,64,0,0,0,0,229,85,85,80,1,223,255,255,240,3,192,0,0,0,7,131,255,255,208,11,67,149,86,208,31,67,64,1,208,63,67,149,86,208,127,67,255,255,208,55,67,64,0,0,3,71,255,255,240,3,71,235,109,240,3,75,211,40,240,3,79,231,109,240,3,78,255,255,240,3,109,211,40,240,3,188,211,40,240,3,100,211,43,224,1,0,129,5,64,
  // 0x505c  停
  92,80,19,19,95,19,0,254,0,16,2,128,0,0,180,3,192,0,0,255,255,255,240,2,214,170,170,160,3,192,0,0,0,11,130,255,255,128,15,130,192,3,128,63,130,208,3,128,123,130,255,255,128,51,133,85,85,80,3,159,255,255,244,3,157,0,0,116,3,157,85,85,116,3,128,255,255,0,3,128,3,192,0,3,128,3,192,0,3,128,3,192,0,3,128,127,128,0,2,64,41,0,0,
  // 0x50a8  储
  168,80,18,19,95,19,0,254,0,128,0,128,0,1,196,1,208,240,3,222,6,229,208,3,75,111,255,192,7,3,65,215,128,15,0,1,223,0,31,106,42,255,160,63,127,63,255,240,127,11,1,240,0,39,11,7,192,0,7,11,47,255,208,7,11,127,150,208,7,11,23,0,208,7,11,7,255,208,7,11,103,85,208,7,15,231,0,208,7,15,71,255,208,7,4,7,150,208,1,0,1,0,64,
  // 0x50cf  像
  207,80,18,19,95,19,0,254,0,64,16,0,0,0,224,245,80,0,2,210,255,244,0,3,203,128,240,0,7,175,255,255,208,15,95,67,129,208,31,75,3,128,208,63,75,3,129,208,127,75,255,255,208,55,64,125,176,0,3,75,237,52,240,3,78,31,63,192,3,64,183,174,0,3,79,131,206,0,3,72,31,219,64,3,65,245,211,208,3,95,194,192,240,3,72,63,128,16,1,0,21,0,0,
  // 0x5145  充
  69,81,17,19,95,19,1,254,0,1,208,0,0,0,1,208,0,0,106,171,250,170,64,191,255,255,255,128,0,61,2,0,0,0,60,7,192,0,0,180,2,240,0,0,245,90,252,0,63,255,255,255,0,62,165,80,15,64,0,60,15,1,0,0,60,15,0,0,0,56,15,0,0,0,180,15,0,0,0,240,15,1,192,3,224,15,1,192,31,192,15,2,192,254,0,15,255,128,96,0,2,170,0,
  // 0x5148  先
  72,81,17,19,95,19,1,254,0,1,144,0,0,2,193,208,0,0,3,193,208,0,0,7,235,250,169,0,11,255,255,253,0,15,1,208,0,0,61,1,208,0,0,44,1,208,0,0,0,1,208,0,0,255,255,255,255,192,170,190,175,170,128,0,56,15,0,0,0,116,15,0,0,0,240,15,0,0,1,224,15,2,192,7,192,15,2,192,127,64,15,171,128,188,0,7,255,0,16,0,0,0,0,
  // 0x5149  光
  73,81,17,19,95,19,1,254,0,1,128,0,0,4,1,208,24,0,15,1,208,45,0,11,65,208,60,0,3,129,208,180,0,3,193,208,240,0,1,129,208,144,0,0,1,208,0,0,255,255,255,255,192,170,190,175,170,128,0,56,14,0,0,0,120,14,0,0,0,180,14,0,0,0,240,14,0,0,1,224,14,1,192,7,192,14,2,192,47,64,15,2,192,253,0,15,255,128,80,0,2,170,0,
  // 0x5165  入
  101,81,17,18,90,19,1,254,1,255,224,0,0,2,255,224,0,0,0,0,224,0,0,0,0,240,0,0,0,2,240,0,0,0,3,240,0,0,0,7,244,0,0,0,11,184,0,0,0,15,60,0,0,0,46,46,0,0,0,61,15,0,0,0,184,11,128,0,1,240,3,208,0,3,224,1,244,0,31,128,0,189,0,191,0,0,47,128,248,0,0,7,192,16,0,0,1,0,
  // 0x5168  全
  104,81,17,18,90,19,1,255,0,2,144,0,0,0,7,240,0,0,0,15,124,0,0,0,61,31,0,0,0,244,11,192,0,3,208,1,240,0,31,64,0,125,0,190,170,170,175,192,247,255,255,247,192,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,15,255,255,252,0,10,171,234,164,0,0,1,208,0,0,0,1,208,0,0,106,171,234,170,64,127,255,255,255,128,
  // 0x5171  共
  113,81,17,19,95,19,1,254,0,96,2,64,0,0,240,3,192,0,0,240,3,192,0,0,240,3,192,0,42,250,171,234,64,127,255,255,255,64,0,240,3,192,0,0,240,3,192,0,0,240,3,192,0,0,240,3,192,0,170,250,171,234,128,255,255,255,255,192,0,0,0,0,0,0,116,7,64,0,1,244,7,208,0,7,208,1,248,0,47,64,0,62,0,188,0,0,15,64,16,0,0,1,0,
  // 0x5173  关
  115,81,13,19,76,19,3,254,0,0,4,0,14,0,45,0,15,0,60,0,3,128,180,0,2,64,96,0,63,255,255,0,42,191,170,0,0,45,0,0,0,45,0,0,106,191,170,128,191,255,255,192,0,63,0,0,0,63,64,0,0,183,192,0,1,242,224,0,7,192,248,0,47,64,63,64,252,0,15,192,80,0,1,0,
  // 0x5177  具
  119,81,17,18,90,19,1,254,3,255,255,244,0,3,149,85,180,0,3,128,0,116,0,3,255,255,244,0,3,149,85,180,0,3,128,0,116,0,3,255,255,244,0,3,149,85,180,0,3,128,0,116,0,3,255,255,244,0,1,85,85,80,0,170,170,170,170,128,255,255,255,255,192,0,16,1,0,0,1,252,15,224,0,47,224,2,254,0,190,0,0,47,128,16,0,0,1,0,
  // 0x5197  冗
  151,81,17,17,85,19,1,254,127,255,255,255,128,126,170,170,175,128,116,0,0,7,128,116,0,0,7,128,116,0,0,7,128,0,191,255,128,0,0,186,171,128,0,0,176,3,128,0,0,176,3,128,0,0,240,3,128,0,0,240,3,128,0,0,240,3,128,0,2,208,3,129,192,7,192,3,130,192,47,64,3,130,192,253,0,3,255,192,96,0,1,170,0,
  // 0x51b7  冷
  183,81,17,19,95,19,1,254,0,0,24,0,0,16,0,127,0,0,184,0,251,128,0,62,2,226,224,0,15,11,192,248,0,1,47,0,62,0,0,250,170,175,192,1,227,255,226,192,0,64,0,0,0,0,0,0,0,0,3,47,255,255,0,11,90,254,175,0,15,0,116,15,0,61,0,116,15,0,124,0,116,15,0,240,0,116,254,0,96,0,116,168,0,0,0,116,0,0,0,0,96,0,0,
  // 0x51c6  准
  198,81,17,19,95,19,1,254,0,0,128,80,0,16,2,208,240,0,184,3,192,240,0,47,7,129,208,0,11,79,255,255,192,1,47,171,234,64,0,63,3,192,0,0,255,3,192,0,0,171,255,255,64,0,11,171,234,0,2,11,3,192,0,11,75,3,192,0,15,11,255,255,64,45,11,171,234,0,124,11,3,192,0,240,11,3,192,0,160,11,255,255,192,0,11,170,170,128,0,6,0,0,0,
  // 0x51fa  出
  250,81,15,19,76,19,2,254,0,6,0,0,0,11,64,0,56,11,64,176,56,11,64,176,56,11,64,176,56,11,64,176,56,11,64,176,62,175,234,240,63,255,255,240,0,11,64,0,160,11,64,40,240,11,64,60,240,11,64,60,240,11,64,60,240,11,64,60,240,11,64,60,255,255,255,252,250,170,170,188,160,0,0,40,
  // 0x51fb  击
  251,81,17,19,95,19,1,254,0,0,144,0,0,0,1,208,0,0,0,1,208,0,0,26,171,250,169,0,31,255,255,254,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,255,255,255,255,192,170,171,250,170,128,0,1,208,0,0,14,1,208,28,0,14,1,208,44,0,14,1,208,44,0,14,1,208,44,0,14,1,208,44,0,15,255,255,252,0,10,170,170,188,0,0,0,0,24,0,
  // 0x5206  分
  6,82,17,18,90,19,1,254,0,120,11,64,0,0,244,7,192,0,1,240,2,208,0,3,208,0,240,0,15,128,0,124,0,47,0,0,47,0,189,0,0,15,192,251,255,255,251,192,2,175,234,244,0,0,15,0,180,0,0,15,0,180,0,0,30,0,176,0,0,60,0,176,0,0,188,0,240,0,1,240,0,240,0,11,208,1,240,0,63,64,191,208,0,36,0,42,64,0,
  // 0x5207  切
  7,82,18,18,90,19,0,254,3,128,0,0,0,3,129,255,255,240,3,129,175,234,240,3,128,7,64,240,3,171,135,64,240,47,255,71,64,224,127,128,7,64,224,3,128,11,0,224,3,128,11,0,224,3,129,15,0,224,3,131,78,1,224,3,131,94,1,224,3,255,60,1,208,1,169,124,2,208,0,0,244,2,208,0,3,224,3,192,0,15,192,255,192,0,6,0,190,0,
  // 0x521b  创
  27,82,17,19,95,19,1,254,0,16,0,1,0,0,176,0,7,64,0,252,1,7,64,3,238,3,135,64,11,75,131,135,64,30,3,211,135,64,124,0,243,135,64,250,170,243,135,64,111,255,195,135,64,29,3,131,135,64,29,3,131,135,64,29,3,131,135,64,29,27,67,135,64,29,126,2,71,64,29,0,80,7,64,29,0,176,7,64,30,0,240,7,64,15,255,226,255,0,1,170,64,169,0,
  // 0x521d  初
  29,82,17,19,95,19,1,254,2,64,0,0,0,7,64,0,0,0,7,67,255,255,192,7,66,175,171,192,255,248,14,3,192,170,248,14,3,192,0,176,30,3,128,1,224,29,3,128,3,205,29,3,128,11,236,44,3,128,47,240,44,3,128,191,188,60,3,128,247,92,120,7,128,71,64,180,7,64,7,64,240,7,64,7,66,208,11,64,7,71,192,15,0,7,95,3,255,0,2,72,1,232,0,
  // 0x522b  别
  43,82,17,18,90,19,1,254,42,170,0,7,64,127,255,64,7,64,116,7,71,71,64,116,7,71,71,64,116,7,71,71,64,122,171,71,71,64,127,255,71,71,64,1,64,7,71,64,3,192,7,71,64,255,255,135,71,64,171,235,135,71,64,3,131,135,71,64,7,67,135,71,64,11,3,128,7,64,14,7,64,7,64,60,11,64,7,64,244,191,1,255,0,128,104,0,169,0,
  // 0x5230  到
  48,82,17,18,90,19,1,254,170,170,144,7,64,255,255,229,7,64,7,128,11,7,64,11,14,11,7,64,15,11,75,7,64,14,87,203,7,64,255,255,235,7,64,165,144,171,7,64,0,224,11,7,64,0,224,11,7,64,127,255,203,7,64,106,250,139,7,64,0,224,6,7,64,0,224,0,7,64,0,246,160,7,64,191,255,224,7,64,255,164,1,255,64,0,0,0,249,0,
  // 0x5236  制
  54,82,17,19,95,19,1,254,0,96,0,1,64,44,176,0,3,128,60,176,1,195,128,63,255,225,195,128,186,250,145,195,128,224,176,1,195,128,186,250,161,195,128,255,255,245,195,128,0,176,1,195,128,0,176,1,195,128,127,255,241,195,128,122,250,241,195,128,116,176,241,195,128,116,176,240,3,128,116,176,240,3,128,116,177,240,3,128,116,179,208,3,128,16,176,0,255,64,0,176,0,121,0,
  // 0x5237  刷
  55,82,17,19,95,19,1,254,0,0,0,1,0,42,170,144,3,64,63,255,242,131,64,56,0,243,131,64,56,0,243,131,64,62,170,243,131,64,63,255,243,131,64,56,44,3,131,64,56,44,3,131,64,63,255,243,131,64,63,125,179,131,64,59,44,115,131,64,59,44,115,131,64,123,44,114,131,64,183,44,112,3,64,183,46,240,3,64,226,44,64,3,64,192,44,0,255,64,0,28,0,121,0,
  // 0x5272  割
  114,82,17,19,95,19,1,254,0,160,0,1,0,0,240,0,3,64,255,255,243,67,64,229,149,243,131,64,224,224,179,131,64,63,255,195,131,64,21,245,67,131,64,0,240,3,131,64,63,255,131,131,64,0,224,3,131,64,255,255,227,131,64,85,85,83,131,64,21,85,67,131,64,63,255,192,3,64,56,3,192,3,64,56,3,192,3,64,63,255,192,3,64,61,87,192,255,64,20,0,0,185,0,
  // 0x529b  力
  155,82,16,19,76,19,1,254,0,2,0,0,0,7,64,0,0,7,64,0,0,7,64,0,0,7,64,0,127,255,255,255,127,255,255,255,0,11,64,11,0,15,0,15,0,15,0,15,0,30,0,15,0,45,0,15,0,60,0,14,0,184,0,14,1,240,0,30,7,208,0,45,31,64,0,60,189,0,47,248,32,0,11,160,
  // 0x529f  功
  159,82,17,19,95,19,1,254,0,0,5,0,0,0,0,15,0,0,170,168,15,0,0,255,252,15,0,0,7,64,15,0,0,7,67,255,255,192,7,66,175,171,192,7,64,14,3,128,7,64,14,3,128,7,64,29,3,128,7,64,45,3,128,7,88,60,3,128,11,253,60,7,64,255,228,120,7,64,249,0,240,7,64,0,2,208,11,0,0,11,192,15,0,0,63,3,254,0,0,8,2,164,0,
  // 0x52a0  加
  160,82,17,19,95,19,1,254,1,0,0,0,0,7,64,0,0,0,7,64,0,0,0,7,64,15,255,64,255,255,79,175,64,175,239,77,7,64,11,7,77,7,64,11,7,77,7,64,11,7,77,7,64,15,7,77,7,64,15,7,77,7,64,14,7,13,7,64,30,11,13,7,64,45,11,13,7,64,60,11,13,7,64,120,15,15,175,64,241,190,15,255,64,224,252,13,7,64,0,0,4,0,0,
  // 0x52a8  动
  168,82,17,18,90,19,1,254,0,0,3,192,0,127,255,3,192,0,42,170,3,192,0,0,0,3,192,0,0,0,127,255,192,170,170,107,235,192,255,255,67,131,192,11,0,3,131,192,15,0,7,67,192,14,29,7,67,128,29,14,11,3,128,44,11,15,3,128,60,111,79,3,128,127,255,157,7,128,190,66,124,7,64,16,0,184,11,0,0,0,242,255,0,0,0,64,168,0,
  // 0x5316  化
  22,83,19,18,90,19,0,254,0,45,60,0,0,0,60,60,0,0,0,180,60,0,0,0,240,60,0,64,3,208,60,7,192,11,208,60,47,128,31,208,60,253,0,126,208,63,224,0,53,208,62,0,0,17,208,60,0,0,1,208,60,0,0,1,208,60,0,0,1,208,60,0,0,1,208,60,0,116,1,208,60,0,176,1,208,60,0,240,1,208,47,255,224,1,208,6,170,64,
  // 0x5347  升
  71,83,17,19,95,19,1,254,0,0,0,64,0,0,11,194,192,0,1,191,130,192,0,127,244,2,192,0,185,240,2,192,0,0,240,2,192,0,0,240,2,192,0,0,240,2,192,0,170,250,171,234,128,255,255,255,255,192,0,240,2,192,0,0,224,2,192,0,1,224,2,192,0,2,192,2,192,0,7,192,2,192,0,15,64,2,192,0,126,0,2,192,0,248,0,2,192,0,16,0,1,128,0,
  // 0x534a  半
  74,83,17,19,95,19,1,254,0,1,128,0,0,14,1,208,60,0,15,1,208,60,0,7,129,208,180,0,3,193,208,240,0,2,193,209,208,0,0,1,208,0,0,63,255,255,255,0,42,171,250,170,0,0,1,208,0,0,0,1,208,0,0,191,255,255,255,128,255,255,255,255,192,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,128,0,0,
  // 0x534f  协
  79,83,18,19,95,19,1,254,9,0,20,0,0,14,0,60,0,0,14,0,60,0,0,14,0,60,0,0,14,15,255,252,0,255,234,190,188,0,175,144,60,60,0,14,4,56,60,0,14,14,56,63,64,14,29,116,59,128,14,44,116,58,192,14,56,176,58,192,14,112,240,57,208,14,18,208,56,128,14,3,192,52,0,14,11,64,116,0,14,47,0,176,0,14,124,47,240,0,13,32,10,128,0,
  // 0x5355  单
  85,83,17,19,95,19,1,254,0,64,0,64,0,1,240,1,240,0,0,180,3,192,0,5,185,91,212,0,15,255,255,253,0,14,1,208,29,0,14,1,208,29,0,15,255,255,253,0,14,86,229,109,0,14,1,208,29,0,14,86,229,109,0,15,255,255,253,0,0,1,208,0,0,170,171,250,170,128,255,255,255,255,192,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,128,0,0,
  // 0x5361  卡
  97,83,17,19,95,19,1,254,0,2,128,0,0,0,3,192,0,0,0,3,192,0,0,0,3,255,252,0,0,3,234,168,0,0,3,192,0,0,0,3,192,0,0,170,171,234,170,128,255,255,255,255,192,0,3,192,0,0,0,3,208,0,0,0,3,255,128,0,0,3,219,248,0,0,3,192,125,0,0,3,192,4,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,2,128,0,0,
  // 0x5370  印
  112,83,16,19,76,19,2,254,0,16,0,0,1,248,0,0,111,228,255,253,253,0,250,189,224,0,224,29,224,0,224,29,224,0,224,29,250,164,224,29,255,248,224,29,224,0,224,29,224,0,224,29,224,0,224,29,224,0,224,29,250,168,224,29,255,252,227,253,224,0,225,248,160,0,224,0,0,0,224,0,0,0,144,0,
  // 0x5371  危
  113,83,17,19,95,19,1,254,0,100,0,0,0,0,249,84,0,0,1,255,255,0,0,3,192,46,0,0,15,64,60,0,0,63,255,255,255,192,255,170,170,170,64,175,0,0,0,0,15,10,170,160,0,15,31,255,244,0,15,29,0,116,0,15,29,0,176,0,14,29,0,176,0,29,29,15,240,0,44,29,5,65,128,60,29,0,2,192,180,30,0,3,192,240,15,255,255,128,64,1,170,169,0,
  // 0x5374  却
  116,83,17,19,95,19,1,254,0,128,0,0,0,1,208,10,170,64,1,208,15,255,64,106,250,77,7,64,191,255,77,7,64,1,208,13,7,64,1,208,13,7,64,1,208,13,7,64,255,255,221,7,64,175,234,157,7,64,11,64,13,7,64,15,8,13,7,64,14,14,13,7,64,44,11,13,127,64,126,255,141,62,0,255,251,221,0,0,148,1,221,0,0,0,0,13,0,0,0,0,9,0,0,
  // 0x5378  卸
  120,83,18,19,95,19,0,254,2,64,0,0,0,3,128,2,170,144,7,234,147,255,224,15,255,243,128,224,45,56,3,128,224,40,56,3,128,224,42,190,167,128,224,63,255,247,128,224,0,56,3,128,224,4,56,3,128,224,13,61,83,128,224,13,63,227,128,224,13,56,3,128,224,13,56,3,128,224,13,56,23,143,208,14,191,247,139,128,127,254,87,128,0,41,0,3,128,0,0,0,2,64,0,
  // 0x538b  压
  139,83,17,18,90,19,1,254,42,170,170,170,128,63,255,255,255,192,60,0,0,0,0,60,0,56,0,0,60,0,56,0,0,60,0,56,0,0,60,0,56,0,0,60,255,255,255,0,60,170,190,170,0,60,0,56,0,0,56,0,56,176,0,56,0,56,124,0,52,0,56,30,0,116,0,56,4,0,176,0,56,0,0,243,255,255,255,192,210,170,170,170,128,0,0,0,0,0,
  // 0x539f  原
  159,83,17,18,90,19,1,254,26,170,170,170,128,47,255,255,255,192,44,0,60,0,0,44,21,185,84,0,44,127,255,253,0,44,116,0,29,0,44,121,85,109,0,44,127,255,253,0,44,116,0,29,0,44,121,85,109,0,60,127,255,253,0,60,0,60,0,0,56,45,60,116,0,116,124,60,61,0,181,240,60,15,64,247,192,60,3,192,225,7,248,1,0,0,2,144,0,0,
  // 0x53cc  双
  204,83,17,17,85,19,1,254,191,254,191,255,64,170,189,190,175,64,0,29,52,11,0,0,44,56,15,0,116,44,60,15,0,60,60,44,30,0,31,120,29,45,0,11,244,14,60,0,3,240,11,184,0,1,240,7,240,0,3,248,3,224,0,7,253,7,224,0,15,31,15,244,0,46,9,62,124,0,188,2,248,47,64,240,3,208,11,192,0,1,0,1,0,
  // 0x53cd  反
  205,83,17,18,90,19,1,254,10,170,170,170,0,15,255,255,255,0,15,0,0,0,0,15,0,0,0,0,15,0,0,0,0,15,170,170,168,0,15,255,255,252,0,15,60,0,120,0,15,29,0,240,0,15,15,1,240,0,14,11,131,208,0,30,3,223,128,0,45,0,255,0,0,60,0,254,0,0,60,7,255,208,0,180,191,131,254,0,241,248,0,127,128,16,64,0,2,0,
  // 0x53d6  取
  214,83,18,18,90,19,0,254,42,170,160,0,0,63,255,244,0,0,11,2,207,255,224,11,2,207,171,224,11,171,207,1,208,11,255,203,2,192,11,2,199,67,192,11,2,195,131,128,11,171,195,203,64,11,255,193,223,0,11,2,192,254,0,11,2,192,188,0,11,91,192,188,0,127,255,193,255,0,62,146,199,223,128,0,2,239,67,240,0,2,237,0,240,0,1,128,0,0,
  // 0x53d8  变
  216,83,17,19,95,19,1,254,0,1,128,0,0,0,2,208,0,0,106,170,250,170,64,191,255,255,255,128,0,44,14,0,0,7,108,14,176,0,15,44,14,124,0,45,44,14,31,0,56,44,14,11,0,0,44,14,0,0,26,170,170,160,0,31,255,255,244,0,2,208,1,224,0,0,184,7,192,0,0,47,126,0,0,0,11,248,0,0,5,255,191,148,0,255,228,6,255,192,100,0,0,6,0,
  // 0x53f0  台
  240,83,17,19,95,19,1,254,0,8,0,0,0,0,31,0,0,0,0,61,0,0,0,0,120,3,192,0,0,240,2,240,0,2,224,0,188,0,191,251,255,255,0,191,255,255,175,128,0,0,0,3,128,0,0,0,0,0,11,255,255,248,0,11,234,170,248,0,11,0,0,120,0,11,0,0,120,0,11,0,0,120,0,11,0,0,120,0,11,255,255,248,0,11,234,170,248,0,6,0,0,36,0,
  // 0x5403  吃
  3,84,18,18,90,19,1,255,0,0,32,0,0,0,0,120,0,0,191,224,240,0,0,186,224,250,170,128,176,226,255,255,192,176,231,192,0,0,176,255,0,0,0,176,230,170,169,0,176,224,255,254,0,176,224,1,244,0,176,224,7,208,0,176,224,31,0,0,191,224,124,0,0,186,144,240,0,0,176,3,192,1,208,0,7,128,1,192,0,3,250,171,192,0,1,255,255,64,
  // 0x5408  合
  8,84,17,19,95,19,1,254,0,1,144,0,0,0,7,240,0,0,0,15,188,0,0,0,61,47,0,0,0,248,11,192,0,3,224,2,244,0,31,128,0,190,0,189,255,255,223,192,224,170,170,129,128,0,0,0,0,0,2,170,170,160,0,7,255,255,244,0,7,64,0,116,0,7,64,0,116,0,7,64,0,116,0,7,64,0,116,0,7,170,170,180,0,7,255,255,244,0,2,64,0,100,0,
  // 0x540d  名
  13,84,16,19,76,19,1,254,0,9,0,0,0,46,0,0,0,126,170,64,1,255,255,192,7,208,7,128,47,192,15,0,254,240,46,0,160,188,184,0,0,31,240,0,0,15,192,0,0,127,255,255,2,254,170,175,111,252,0,15,254,60,0,15,160,60,0,15,0,60,0,15,0,62,170,175,0,63,255,255,0,40,0,10,
  // 0x540e  后
  14,84,17,19,95,19,1,254,0,0,0,20,0,0,1,107,253,0,15,255,255,164,0,15,233,64,0,0,14,0,0,0,0,14,0,0,0,0,15,255,255,255,192,15,170,170,170,128,14,0,0,0,0,30,0,0,0,0,29,63,255,254,0,29,62,170,174,0,44,56,0,14,0,60,56,0,14,0,60,56,0,14,0,116,56,0,14,0,240,63,255,254,0,224,62,170,174,0,0,36,0,9,0,
  // 0x5411  向
  17,84,15,19,76,19,2,254,0,9,0,0,0,15,0,0,0,46,0,0,0,60,0,0,255,255,255,252,250,170,170,188,224,0,0,44,224,0,0,44,224,255,252,44,224,234,188,44,224,208,28,44,224,208,28,44,224,208,28,44,224,255,252,44,224,250,168,44,224,208,0,44,224,0,0,44,224,0,15,252,208,0,7,228,
  // 0x5426  否
  38,84,17,18,90,19,1,254,106,170,170,170,64,191,255,255,255,128,0,1,244,0,0,0,7,208,0,0,0,47,219,128,0,2,254,215,248,0,47,209,208,127,64,254,1,208,11,192,96,1,208,1,0,0,0,64,0,0,11,255,255,252,0,11,170,170,188,0,11,0,0,60,0,11,0,0,60,0,11,0,0,60,0,11,255,255,252,0,11,170,170,188,0,6,0,0,36,0,
  // 0x542f  启
  47,84,16,19,76,19,1,254,0,0,0,96,0,21,191,248,31,255,250,64,30,80,0,0,30,85,85,85,31,255,255,254,29,0,0,14,29,0,0,14,30,85,85,110,31,255,255,254,29,0,0,0,44,0,0,0,44,255,255,255,60,250,170,175,60,240,0,15,120,240,0,15,240,245,85,95,240,255,255,255,0,160,0,10,
  // 0x544a  告
  74,84,17,19,95,19,1,254,1,64,160,0,0,3,192,240,0,0,7,128,240,0,0,15,255,255,253,0,47,170,250,169,0,124,0,240,0,0,52,0,240,0,0,106,170,250,170,128,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,11,255,255,252,0,11,170,170,188,0,11,64,0,60,0,11,64,0,60,0,11,64,0,60,0,11,255,255,252,0,11,170,170,188,0,7,0,0,40,0,
  // 0x5468  周
  104,84,16,18,72,19,1,254,10,170,170,170,31,255,255,255,29,0,144,15,29,1,208,15,29,127,255,143,29,22,229,79,29,1,208,15,29,255,255,207,29,85,85,79,29,0,0,15,29,63,255,79,44,57,91,79,60,56,7,79,56,57,91,79,116,63,255,79,240,56,0,15,224,16,3,254,64,0,1,164,
  // 0x547d  命
  125,84,17,19,95,19,1,254,0,2,144,0,0,0,11,244,0,0,0,47,124,0,0,0,188,31,64,0,3,240,3,224,0,31,234,170,253,0,254,127,255,111,192,224,0,0,2,192,26,169,42,169,0,31,254,63,254,0,28,14,56,14,0,28,14,56,14,0,28,14,56,14,0,28,14,56,14,0,31,254,56,14,0,30,169,56,254,0,28,0,56,164,0,0,0,56,0,0,0,0,36,0,0,
  // 0x548c  和
  140,84,17,18,90,19,0,254,0,111,192,0,0,47,254,74,170,128,25,180,15,255,192,0,116,14,2,192,0,116,14,2,192,42,250,158,2,192,63,255,222,2,192,0,244,14,2,192,2,253,14,2,192,3,255,14,2,192,11,183,206,2,192,14,117,206,2,192,60,116,14,2,192,120,116,15,171,192,32,116,15,255,192,0,116,14,2,192,0,116,9,1,128,0,96,0,0,0,
  // 0x54cd  响
  205,84,17,19,95,19,1,254,0,0,6,0,0,0,0,15,64,0,191,208,15,0,0,186,210,175,170,64,176,215,255,255,128,176,215,0,3,128,176,215,0,3,128,176,215,31,227,128,176,215,29,163,128,176,215,24,99,128,176,215,24,99,128,176,215,24,99,128,191,215,29,163,128,186,135,31,227,128,176,7,24,3,128,16,7,0,3,128,0,7,0,3,128,0,7,0,63,128,0,1,0,25,0,
  // 0x55b7  喷
  183,85,17,19,95,19,1,254,0,0,6,0,0,0,0,11,0,0,191,207,255,255,64,187,197,95,85,0,162,192,75,20,0,162,198,229,125,64,162,239,255,255,192,162,193,192,44,0,162,194,149,105,0,162,195,255,255,0,162,195,64,15,0,162,195,69,15,0,191,195,75,15,0,186,131,75,15,0,160,3,79,15,0,80,1,30,164,0,0,1,248,126,0,0,63,208,7,192,0,20,0,0,64,
  // 0x5634  嘴
  52,86,17,19,95,19,1,254,0,0,144,128,0,0,0,209,193,0,191,204,229,223,64,187,204,254,248,0,162,204,209,192,64,162,204,229,192,192,162,239,253,255,192,162,234,240,85,0,162,194,255,208,0,162,203,131,192,0,162,255,255,255,0,191,219,71,7,0,186,71,255,255,0,160,7,71,7,0,96,11,75,11,0,0,15,255,255,0,0,45,0,11,0,0,120,0,191,0,0,0,0,16,0,
  // 0x5668  器
  104,86,18,18,90,19,1,254,47,254,47,254,0,45,110,45,94,0,44,14,44,14,0,44,14,44,14,0,47,254,47,254,0,21,87,197,85,0,0,7,128,0,0,255,255,255,255,192,170,254,175,170,128,2,240,7,208,0,31,192,0,253,0,255,254,47,255,208,254,94,45,111,192,28,14,44,13,0,28,14,44,13,0,30,94,45,109,0,31,254,47,253,0,24,14,44,9,0,
  // 0x5674  噴
  116,86,17,19,95,19,1,254,0,0,6,0,0,0,0,11,64,0,106,139,255,255,64,191,208,7,0,0,177,209,199,44,0,177,239,255,255,192,177,209,208,44,0,177,208,64,4,0,177,215,255,255,0,177,215,64,11,0,177,215,255,255,0,186,215,64,11,0,191,215,255,255,0,176,7,64,11,0,96,7,255,255,0,0,1,224,116,0,0,27,208,63,0,0,126,0,7,192,0,16,0,1,0,
  // 0x56de  回
  222,86,17,18,90,19,1,254,127,255,255,255,64,127,255,255,255,64,116,0,0,7,64,116,0,0,7,64,116,0,0,7,64,116,127,255,7,64,116,122,175,7,64,116,116,11,7,64,116,116,11,7,64,116,116,11,7,64,116,122,175,7,64,116,127,255,7,64,116,0,0,7,64,116,0,0,7,64,116,0,0,7,64,127,255,255,255,64,126,170,170,175,64,100,0,0,6,64,
  // 0x56e0  因
  224,86,17,18,90,19,1,254,106,170,170,170,64,127,255,255,255,64,116,0,64,7,64,116,1,192,7,64,116,1,192,7,64,117,171,234,151,64,119,255,255,231,64,116,3,224,7,64,116,3,240,7,64,116,11,180,7,64,116,15,60,7,64,116,61,15,7,64,118,244,7,231,64,118,208,1,215,64,116,0,0,7,64,127,255,255,255,64,126,170,170,175,64,96,0,0,2,64,
  // 0x56fa  固
  250,86,17,18,90,19,1,254,42,170,170,170,0,127,255,255,255,64,116,0,64,7,64,116,1,208,7,64,116,1,208,7,64,118,255,255,231,64,116,86,229,87,64,116,1,208,7,64,116,22,229,7,64,116,127,255,135,64,116,112,3,135,64,116,112,3,135,64,116,127,255,135,64,116,21,85,7,64,116,0,0,7,64,127,255,255,255,64,126,170,170,175,64,36,0,0,6,64,
  // 0x56fe  图
  254,86,17,18,90,19,1,254,127,255,255,255,64,122,170,170,171,64,116,11,0,7,64,116,31,85,71,64,116,127,255,199,64,118,252,11,71,64,119,143,125,7,64,116,7,248,7,64,116,127,191,151,64,123,249,6,251,64,118,11,224,7,64,116,0,124,7,64,116,122,64,7,64,116,107,254,7,64,116,0,27,7,64,122,170,170,171,64,127,255,255,255,64,96,0,0,6,64,
  // 0x5728  在
  40,87,17,19,95,19,1,254,0,5,0,0,0,0,15,0,0,0,0,30,0,0,0,170,191,170,170,128,255,255,255,255,192,0,180,0,0,0,1,224,15,0,0,3,192,15,0,0,11,128,15,0,0,63,74,175,170,0,255,79,255,255,0,251,64,15,0,0,71,64,15,0,0,7,64,15,0,0,7,64,15,0,0,7,64,15,0,0,7,90,175,170,128,7,111,255,255,192,7,64,0,0,0,
  // 0x574f  坏
  79,87,17,19,95,19,1,254,5,0,0,0,0,15,10,170,170,128,15,31,255,255,192,15,0,3,192,0,15,0,11,128,0,255,240,15,0,0,175,160,63,96,0,15,0,255,248,0,15,3,235,47,0,15,31,139,11,192,15,45,11,2,192,15,16,11,0,0,15,240,11,0,0,191,224,11,0,0,253,0,11,0,0,128,0,11,0,0,0,0,11,0,0,0,0,11,0,0,0,0,6,0,0,
  // 0x5757  块
  87,87,17,19,95,19,1,254,5,0,9,0,0,15,0,13,0,0,15,0,13,0,0,15,2,175,169,0,15,7,255,254,0,255,240,13,14,0,175,160,13,14,0,15,0,13,14,0,15,0,29,14,0,15,10,191,175,128,15,15,255,255,192,15,176,47,128,0,15,240,62,192,0,255,64,185,224,0,244,0,240,240,0,0,3,208,124,0,0,31,128,47,64,0,125,0,11,192,0,16,0,1,0,
  // 0x578b  型
  139,87,17,18,90,19,1,255,0,0,0,6,0,63,255,208,11,0,47,175,131,75,0,7,15,3,75,0,7,15,3,75,0,111,175,147,75,0,191,255,243,75,0,15,15,3,75,0,14,15,0,11,0,60,15,0,175,0,180,15,64,253,0,0,1,208,0,0,10,170,250,168,0,15,255,255,252,0,0,1,208,0,0,0,1,208,0,0,170,171,250,170,128,255,255,255,255,192,
  // 0x57ab  垫
  171,87,18,18,90,19,1,255,2,64,8,0,0,3,128,29,0,0,171,229,174,168,0,255,250,255,252,0,3,128,28,28,0,3,153,236,28,0,111,253,252,28,0,255,128,127,28,0,3,128,247,220,128,3,131,224,77,208,63,71,128,15,192,25,2,208,1,64,0,1,208,0,0,15,255,255,252,0,5,86,229,84,0,0,1,208,0,0,106,170,234,170,128,255,255,255,255,192,
  // 0x586b  填
  107,88,17,19,95,19,1,254,5,0,6,0,0,14,0,11,0,0,14,31,255,255,192,14,5,95,149,64,14,0,11,0,0,255,227,255,254,0,175,147,128,14,0,14,3,255,254,0,14,3,128,14,0,14,3,255,254,0,14,3,128,14,0,15,179,255,254,0,15,240,0,0,0,191,165,85,85,64,248,63,255,255,192,64,0,160,116,0,0,11,208,62,0,0,63,0,11,192,0,20,0,1,64,
  // 0x58f3  壳
  243,88,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,255,255,255,255,192,85,86,229,85,64,5,86,229,84,0,15,255,255,253,0,21,85,85,85,0,127,255,255,255,64,112,0,0,7,64,115,255,255,247,64,0,85,85,64,0,0,85,85,64,0,0,255,255,128,0,0,224,3,128,0,1,208,3,128,0,3,192,3,130,128,15,128,3,131,192,190,0,3,255,128,32,0,0,169,0,
  // 0x5907  备
  7,89,17,19,95,19,1,254,0,9,0,0,0,0,61,0,0,0,0,255,255,240,0,3,250,171,240,0,47,244,11,192,0,60,62,127,0,0,0,15,252,0,0,0,191,255,144,0,191,248,11,255,192,254,64,0,91,128,15,255,255,248,0,15,171,234,184,0,15,1,208,56,0,15,255,255,248,0,15,86,229,184,0,15,1,208,56,0,15,171,234,184,0,15,255,255,248,0,10,0,0,36,0,
  // 0x590d  复
  13,89,13,19,76,19,3,254,1,64,0,0,3,192,0,0,11,213,85,0,15,255,254,0,61,0,0,0,255,255,252,0,27,0,60,0,11,255,252,0,11,0,60,0,11,0,60,0,11,255,252,0,0,245,80,0,7,255,252,0,47,192,240,0,184,247,208,0,16,63,128,0,2,255,228,0,127,208,191,64,36,0,6,0,
  // 0x5916  外
  22,89,18,19,95,19,1,254,0,144,0,144,0,1,224,1,208,0,2,192,1,208,0,3,234,145,208,0,7,255,209,208,0,15,2,245,208,0,30,2,253,208,0,60,3,223,208,0,255,71,75,208,0,231,235,3,224,0,0,255,1,248,0,0,61,1,255,0,0,60,1,235,208,0,244,1,209,192,2,224,1,208,0,11,192,1,208,0,63,0,1,208,0,184,0,1,208,0,16,0,0,144,0,
  // 0x591a  多
  26,89,17,19,95,19,1,254,0,2,64,0,0,0,11,128,0,0,0,63,255,224,0,1,249,87,224,0,47,240,7,192,0,61,126,47,0,0,0,15,248,0,0,0,11,234,0,0,1,190,126,0,0,127,225,255,255,64,57,11,234,175,64,1,191,64,30,0,7,235,224,124,0,1,0,249,240,0,0,0,63,192,0,0,1,254,0,0,1,175,224,0,0,15,253,0,0,0,5,64,0,0,0,
  // 0x5927  大
  39,89,17,19,95,19,1,254,0,1,144,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,192,0,0,255,255,255,255,192,191,255,255,255,128,0,3,240,0,0,0,11,248,0,0,0,15,60,0,0,0,31,46,0,0,0,61,15,0,0,0,188,11,192,0,2,240,3,240,0,11,208,0,252,0,127,64,0,63,64,252,0,0,15,128,16,0,0,1,0,
  // 0x5929  天
  41,89,17,17,85,19,1,254,255,255,255,255,192,191,255,255,255,128,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,63,255,255,255,64,63,255,255,255,0,0,3,240,0,0,0,7,248,0,0,0,15,124,0,0,0,47,47,0,0,0,188,15,128,0,3,244,3,240,0,47,192,0,254,64,254,0,0,47,192,80,0,0,1,0,
  // 0x592a  太
  42,89,17,19,95,19,1,254,0,1,128,0,0,0,2,192,0,0,0,2,192,0,0,0,3,192,0,0,0,3,192,0,0,191,255,255,255,128,255,255,255,255,192,0,3,240,0,0,0,7,248,0,0,0,15,60,0,0,0,15,45,0,0,0,46,15,0,0,0,60,11,128,0,0,250,3,208,0,3,251,209,240,0,11,194,240,189,0,127,0,188,63,128,248,0,56,11,192,16,0,0,1,0,
  // 0x5931  失
  49,89,17,19,95,19,1,254,0,1,128,0,0,3,194,208,0,0,7,130,208,0,0,11,66,208,0,0,15,255,255,253,0,47,255,255,253,0,60,2,208,0,0,184,2,208,0,0,16,2,192,0,0,191,255,255,255,128,255,255,255,255,192,0,7,244,0,0,0,15,124,0,0,0,47,46,0,0,0,188,15,128,0,3,244,3,240,0,111,192,0,254,64,254,0,0,47,192,16,0,0,1,64,
  // 0x5934  头
  52,89,17,19,95,19,1,254,0,0,36,0,0,2,64,56,0,0,3,244,56,0,0,0,126,56,0,0,0,8,56,0,0,45,0,56,0,0,31,208,120,0,0,2,240,116,0,0,0,16,116,0,0,170,170,250,170,128,255,255,255,255,192,0,1,224,0,0,0,3,192,0,0,0,11,158,0,0,0,47,15,208,0,0,252,1,252,0,31,224,0,47,64,191,64,0,7,128,16,0,0,0,0,
  // 0x597d  好
  125,89,18,19,95,19,1,254,6,0,0,0,0,11,1,170,170,0,15,1,255,255,128,14,0,0,31,0,175,168,0,60,0,255,252,1,240,0,44,60,3,192,0,60,60,3,192,0,56,58,171,234,128,52,123,255,255,208,112,176,3,192,0,188,240,3,192,0,191,224,3,192,0,7,224,3,192,0,3,248,3,192,0,15,125,3,192,0,62,8,3,192,0,248,0,191,128,0,16,0,42,0,0,
  // 0x59cb  始
  203,89,18,19,95,19,1,254,6,0,5,0,0,11,0,15,0,0,15,0,15,0,0,14,0,30,4,0,175,168,44,45,0,255,252,60,15,0,44,60,120,91,128,60,59,255,255,192,56,58,169,81,208,116,116,0,0,0,176,176,106,170,64,253,240,191,255,64,175,224,176,7,64,3,240,176,7,64,7,252,176,7,64,15,44,176,7,64,125,4,191,255,64,180,0,186,171,64,16,0,96,1,0,
  // 0x5b50  子
  80,91,17,17,85,19,1,254,15,255,255,252,0,10,170,171,252,0,0,0,3,224,0,0,0,31,128,0,0,1,252,0,0,0,1,224,0,0,0,1,208,0,0,255,255,255,255,192,255,255,255,255,192,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,255,192,0,0,0,126,64,0,0,
  // 0x5b58  存
  88,91,17,19,95,19,1,254,0,9,0,0,0,0,15,0,0,0,0,30,0,0,0,255,255,255,255,192,170,254,170,170,128,0,240,0,0,0,1,226,170,168,0,3,195,255,254,0,11,128,0,124,0,47,64,1,240,0,127,64,7,192,0,255,64,7,64,0,219,111,255,255,192,11,90,175,234,128,11,64,7,64,0,11,64,7,64,0,11,64,7,64,0,11,64,255,0,0,6,0,169,0,0,
  // 0x5b89  安
  137,91,17,19,95,19,1,254,0,1,144,0,0,0,1,208,0,0,42,171,250,170,64,127,255,255,255,64,116,2,0,7,64,116,11,64,7,64,0,15,0,0,0,0,30,0,0,0,255,255,255,255,192,170,254,171,250,128,0,240,3,192,0,1,224,3,192,0,3,224,11,64,0,11,254,110,0,0,6,27,253,0,0,0,7,255,128,0,5,191,71,248,0,63,244,0,126,0,25,0,0,8,0,
  // 0x5b8c  完
  140,91,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,106,171,250,170,64,127,255,255,255,64,116,0,0,7,64,116,0,0,7,64,98,255,255,214,64,1,170,170,144,0,0,0,0,0,0,170,170,170,170,128,255,255,255,255,192,0,120,29,0,0,0,116,29,0,0,0,240,29,0,0,1,240,29,2,128,7,208,29,2,192,127,64,15,171,192,252,0,11,255,64,0,0,0,0,0,
  // 0x5b9a  定
  154,91,17,19,95,19,1,254,0,1,144,0,0,0,1,208,0,0,106,171,250,170,64,127,255,255,255,64,116,0,0,7,64,116,0,0,7,64,118,170,170,167,64,3,255,255,240,0,0,1,208,0,0,1,65,208,0,0,3,193,208,0,0,3,129,255,252,0,11,129,250,168,0,15,193,208,0,0,31,241,208,0,0,60,127,208,0,0,184,31,255,170,128,240,1,191,255,128,0,0,0,0,0,
  // 0x5ba2  客
  162,91,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,127,255,255,255,64,122,170,170,171,64,112,30,0,7,64,112,62,85,71,64,0,255,255,208,0,7,244,7,128,0,63,126,47,0,0,20,11,248,0,0,0,47,254,64,0,6,253,27,254,64,255,229,86,255,128,103,255,255,240,0,2,192,0,240,0,2,192,0,240,0,2,213,85,240,0,2,255,255,240,0,1,128,0,160,0,
  // 0x5bab  宫
  171,91,17,19,95,19,1,254,0,2,128,0,0,0,3,208,0,0,106,171,250,170,64,127,255,255,255,64,116,0,0,7,64,116,0,0,7,64,119,255,255,247,64,3,213,85,240,0,3,128,0,240,0,3,255,255,240,0,1,85,85,80,0,0,0,0,0,0,10,170,170,168,0,15,255,255,252,0,14,0,0,44,0,14,0,0,44,0,15,170,170,188,0,15,255,255,252,0,9,0,0,24,0,
  // 0x5bf9  对
  249,91,17,19,95,19,1,254,0,0,0,24,0,0,0,0,44,0,0,0,0,44,0,191,254,0,44,0,106,174,0,44,0,0,29,255,255,192,0,45,170,190,128,36,44,0,44,0,61,60,0,44,0,31,120,112,44,0,7,244,60,44,0,1,240,44,44,0,1,252,14,44,0,3,254,9,44,0,7,143,0,44,0,15,7,0,44,0,61,0,0,60,0,244,0,11,252,0,16,0,3,224,0,
  // 0x5c06  将
  6,92,18,19,95,19,0,254,0,160,0,6,0,0,240,22,255,192,0,247,255,233,0,52,242,81,0,128,60,241,67,65,224,29,242,195,195,192,15,241,210,203,64,9,240,225,94,0,0,240,64,29,0,0,240,0,14,0,0,247,255,255,240,1,246,170,175,160,15,240,96,14,0,126,240,180,14,0,52,240,60,14,0,0,240,30,14,0,0,240,4,14,0,0,240,3,254,0,0,160,1,168,0,
  // 0x5c0f  小
  15,92,18,19,95,19,1,254,0,0,64,0,0,0,1,224,0,0,0,1,224,0,0,0,1,224,0,0,0,1,224,0,0,6,1,224,96,0,11,65,224,184,0,15,1,224,60,0,15,1,224,45,0,30,1,224,15,0,61,1,224,15,64,60,1,224,7,128,184,1,224,3,192,240,1,224,3,208,0,1,224,1,128,0,1,224,0,0,0,1,208,0,0,0,255,208,0,0,0,126,64,0,0,
  // 0x5c31  就
  49,92,18,19,95,19,1,254,1,208,1,128,0,1,208,2,221,0,1,208,2,207,0,255,255,194,195,128,170,170,130,194,128,0,0,43,234,128,63,255,127,255,192,61,91,2,192,0,56,7,3,240,0,61,91,3,240,0,63,255,3,240,0,0,208,7,240,0,56,219,11,176,0,52,215,79,112,0,176,211,174,112,128,240,210,188,112,208,209,208,248,112,208,15,209,240,127,192,6,64,64,26,64,
  // 0x5c4f  屏
  79,92,17,18,90,19,1,254,10,170,170,169,0,31,255,255,255,0,29,0,0,15,0,30,85,85,95,0,31,255,255,255,0,29,14,0,116,0,29,15,0,240,0,29,91,150,229,0,29,255,255,255,64,29,7,65,208,0,44,7,65,208,0,45,171,170,234,64,62,255,255,255,192,56,15,1,208,0,116,30,1,208,0,240,124,1,208,0,225,244,1,208,0,0,64,0,128,0,
  // 0x5de5  工
  229,93,17,15,75,19,1,0,63,255,255,255,0,63,255,255,255,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,255,255,255,255,192,255,255,255,255,192,
  // 0x5dee  差
  238,93,17,19,95,19,1,254,0,64,0,64,0,1,224,2,208,0,0,176,3,128,0,63,255,255,255,0,42,170,234,170,0,0,1,208,0,0,15,255,255,252,0,5,86,229,84,0,0,1,208,0,0,255,255,255,255,192,106,250,170,170,64,2,208,0,0,0,3,239,255,252,0,7,154,190,168,0,15,64,60,0,0,46,0,60,0,0,125,170,190,170,64,245,255,255,255,64,0,0,0,0,0,
  // 0x5df2  已
  242,93,16,17,68,19,2,255,170,170,170,144,255,255,255,224,0,0,0,224,0,0,0,224,120,0,0,224,120,0,0,224,120,0,0,224,126,170,171,224,127,255,255,224,120,0,0,224,120,0,0,0,120,0,0,0,120,0,0,15,120,0,0,15,56,0,0,30,63,234,170,253,11,255,255,244,
  // 0x5e73  平
  115,94,17,17,85,19,1,254,63,255,255,255,0,42,171,250,170,0,1,1,208,16,0,11,65,208,120,0,3,193,208,176,0,2,193,208,224,0,1,209,210,192,0,0,1,208,0,0,255,255,255,255,192,255,255,255,255,192,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,144,0,0,
  // 0x5e76  并
  118,94,17,19,95,19,1,254,0,128,0,144,0,2,208,1,240,0,0,240,3,192,0,0,116,7,128,0,42,186,171,170,64,127,255,255,255,64,0,176,3,128,0,0,176,3,128,0,0,176,3,128,0,0,176,3,128,0,255,255,255,255,192,170,250,171,234,128,0,240,3,128,0,1,224,3,128,0,3,192,3,128,0,11,128,3,128,0,47,0,3,128,0,188,0,3,128,0,32,0,2,64,0,
  // 0x5e8a  床
  138,94,17,19,95,19,1,254,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,47,255,255,255,192,46,170,170,170,128,44,0,40,0,0,44,0,44,0,0,44,0,44,0,0,44,255,255,255,192,44,170,255,170,128,60,0,255,0,0,60,2,255,192,0,60,7,189,224,0,56,31,44,184,0,116,125,44,62,0,178,244,44,15,192,241,208,44,2,128,224,0,44,0,0,0,0,40,0,0,
  // 0x5e94  应
  148,94,17,19,95,19,1,254,0,0,160,0,0,0,0,240,0,0,0,0,180,0,0,47,255,255,255,192,46,170,170,170,128,44,0,0,0,0,44,0,224,15,0,44,176,176,15,0,44,176,116,45,0,60,120,56,60,0,60,60,60,60,0,60,44,60,116,0,60,29,40,240,0,56,13,1,208,0,120,0,3,192,0,116,0,7,64,0,243,255,255,255,192,226,170,170,170,128,16,0,0,0,0,
  // 0x5e9f  废
  159,94,17,19,95,19,1,254,0,0,96,0,0,0,0,240,0,0,42,170,254,170,128,63,255,255,255,192,60,20,36,0,0,60,60,120,180,0,60,120,116,60,0,60,250,250,174,64,60,255,255,255,128,60,1,208,0,0,60,3,192,0,0,60,7,255,252,0,56,15,234,252,0,56,47,208,240,0,116,184,251,208,0,183,240,63,128,0,243,130,255,244,0,224,47,208,191,128,16,9,0,6,0,
  // 0x5ea6  度
  166,94,17,19,95,19,1,254,0,0,160,0,0,0,0,240,0,0,26,170,250,170,128,47,255,255,255,192,44,6,0,80,0,44,11,0,240,0,45,255,255,255,128,44,95,85,245,64,44,11,0,240,0,44,11,255,240,0,60,1,85,80,0,60,85,85,84,0,57,255,255,253,0,56,15,0,120,0,116,7,210,240,0,176,0,255,128,0,240,23,255,228,0,227,255,146,255,192,65,144,0,6,64,
  // 0x5f00  开
  0,95,17,18,90,19,1,254,42,170,170,170,64,127,255,255,255,64,0,176,3,192,0,0,176,3,192,0,0,176,3,192,0,0,176,3,192,0,0,176,3,192,0,0,176,3,192,0,255,255,255,255,192,170,250,171,234,128,0,240,3,192,0,0,240,3,192,0,2,224,3,192,0,3,192,3,192,0,11,128,3,192,0,47,0,3,192,0,188,0,3,192,0,32,0,2,128,0,
  // 0x5f03  弃
  3,95,17,19,95,19,1,254,0,0,64,0,0,0,1,208,0,0,106,170,234,170,64,255,255,255,255,192,0,45,1,0,0,0,56,3,208,0,0,181,86,248,0,127,255,255,255,0,42,85,0,7,64,0,176,3,128,0,0,176,3,128,0,170,250,171,234,128,255,255,255,255,192,0,224,3,128,0,2,208,3,128,0,7,192,3,128,0,47,0,3,128,0,252,0,3,128,0,80,0,2,64,0,
  // 0x5f0f  式
  15,95,18,19,95,19,1,254,0,0,24,16,0,0,0,29,124,0,0,0,29,31,0,0,0,29,6,0,255,255,255,255,192,170,170,191,170,128,0,0,14,0,0,0,0,15,0,0,42,170,143,0,0,63,255,207,0,0,0,224,15,0,0,0,224,11,64,0,0,224,7,128,0,0,224,3,192,64,0,224,83,193,208,1,255,226,225,192,127,254,64,242,192,190,64,0,127,128,0,0,0,30,0,
  // 0x5f15  引
  21,95,15,19,76,19,1,254,0,0,0,24,63,255,128,44,42,171,128,44,0,3,128,44,0,3,128,44,0,3,128,44,47,255,128,44,62,170,64,44,60,0,0,44,56,0,0,44,127,255,128,44,186,171,128,44,32,7,64,44,0,7,64,44,0,11,64,44,0,11,0,44,0,15,0,44,11,254,0,44,6,232,0,44,
  // 0x5f39  弹
  57,95,17,19,95,19,1,254,0,0,0,4,0,106,144,224,29,0,255,224,176,60,0,0,224,56,116,0,0,225,101,245,0,106,227,255,255,64,191,227,71,67,64,176,3,155,151,64,176,3,255,255,64,176,3,71,67,64,191,227,155,155,64,106,211,255,255,64,0,208,7,64,0,1,234,171,234,128,1,239,255,255,192,1,192,7,64,0,2,192,7,64,0,127,192,7,64,0,42,0,2,64,0,
  // 0x5f52  归
  82,95,17,19,95,19,1,254,0,96,0,0,0,0,176,0,0,0,16,178,255,255,64,116,177,170,175,64,116,176,0,7,64,116,176,0,7,64,116,176,0,7,64,116,176,0,7,64,116,176,170,175,64,116,176,255,255,64,116,176,0,7,64,116,240,0,7,64,16,240,0,7,64,1,224,0,7,64,2,208,0,7,64,3,194,170,175,64,15,67,255,255,64,46,0,0,7,64,8,0,0,1,0,
  // 0x5f84  径
  132,95,17,18,90,19,1,254,3,197,85,85,0,15,75,255,255,0,62,1,208,29,0,244,64,240,60,0,145,224,124,240,0,3,192,31,192,0,15,64,127,224,0,63,7,248,191,128,255,31,129,11,192,235,0,7,0,0,11,0,7,0,0,11,11,255,255,0,11,6,175,170,0,11,0,7,0,0,11,0,7,0,0,11,26,175,170,128,11,47,255,255,192,11,0,0,0,0,
  // 0x5f85  待
  133,95,17,19,95,19,1,254,0,0,6,0,0,3,192,11,0,0,15,64,11,0,0,62,11,255,255,64,248,6,175,170,0,81,208,11,0,0,3,218,175,170,128,15,47,255,255,192,63,0,0,56,0,255,0,0,56,0,251,26,170,190,128,139,47,255,255,192,11,0,0,56,0,11,3,192,56,0,11,1,224,56,0,11,0,240,56,0,11,0,16,56,0,11,0,11,248,0,6,0,6,144,0,
  // 0x5faa  循
  170,95,18,19,95,19,0,254,0,64,0,0,0,1,224,1,175,192,3,195,255,249,0,31,3,208,176,0,60,3,128,112,0,32,243,255,255,240,2,227,234,250,160,7,195,128,176,0,31,195,175,255,208,127,195,173,86,208,50,195,172,1,208,2,195,111,255,208,2,199,109,1,208,2,199,44,1,208,2,203,47,255,208,2,207,45,1,208,2,206,45,1,208,2,220,47,255,208,2,132,24,0,128,
  // 0x5fae  微
  174,95,18,19,95,19,0,254,1,64,128,20,0,3,192,192,60,0,15,28,202,56,0,61,28,202,52,0,52,172,202,191,240,2,238,238,250,224,3,159,255,240,208,15,64,2,241,192,47,64,3,241,192,127,111,255,54,192,55,95,189,43,128,3,75,44,31,64,3,75,44,15,0,3,75,44,15,0,3,78,63,111,0,3,93,125,127,192,3,124,17,241,240,3,96,3,192,176,2,0,1,0,16,
  // 0x5fc3  心
  195,95,19,19,95,19,0,254,0,1,0,0,0,0,15,208,0,0,0,2,253,0,0,0,0,47,192,0,0,0,7,192,0,0,0,0,0,0,0,14,0,0,0,0,14,0,13,0,11,14,0,15,0,15,14,0,11,128,15,14,0,3,192,14,14,0,1,224,29,14,0,0,240,60,14,0,36,180,124,14,0,60,96,16,14,0,56,0,0,14,0,116,0,0,15,255,240,0,0,2,170,128,0,
  // 0x5ffd  忽
  253,95,17,19,95,19,1,254,0,80,0,0,0,0,240,0,0,0,2,250,170,169,0,7,255,255,254,0,31,15,15,14,0,124,45,29,29,0,176,184,60,29,0,2,240,180,29,0,11,193,224,44,0,63,7,192,60,0,4,47,11,248,0,0,57,66,144,0,0,3,224,0,0,14,52,184,120,0,30,52,32,61,0,60,52,1,207,0,184,56,2,199,192,240,63,255,194,128,0,10,170,0,0,
  // 0x6027  性
  39,96,18,19,95,19,0,254,2,128,0,144,0,3,192,97,208,0,3,192,177,208,0,3,208,241,208,0,43,248,251,250,144,43,237,255,255,224,59,207,193,208,0,55,199,129,208,0,115,195,65,208,0,35,192,1,208,0,3,192,255,255,192,3,192,171,250,128,3,192,1,208,0,3,192,1,208,0,3,192,1,208,0,3,192,1,208,0,3,198,171,250,160,3,203,255,255,240,2,128,0,0,0,
  // 0x603b  总
  59,96,17,19,95,19,1,254,0,16,1,64,0,0,240,3,208,0,0,120,3,192,0,0,60,11,64,0,6,190,175,164,0,11,255,255,248,0,11,64,0,120,0,11,64,0,120,0,11,64,0,120,0,11,255,255,248,0,6,170,234,164,0,0,3,192,0,0,20,97,240,8,0,60,176,124,30,0,56,176,24,11,0,116,176,0,147,128,240,180,0,242,192,80,191,255,224,0,0,26,170,64,0,
  // 0x6062  恢
  98,96,17,19,95,19,1,254,5,2,0,0,0,15,7,0,0,0,15,31,170,170,128,15,127,255,255,192,95,199,0,64,0,175,167,1,208,0,159,119,1,208,0,223,39,53,210,192,207,7,49,211,128,143,7,113,215,0,15,11,177,219,0,15,11,82,228,0,15,15,3,240,0,15,14,7,176,0,15,29,15,60,0,15,44,45,30,0,15,56,184,15,128,15,178,224,3,192,10,16,64,0,64,
  // 0x606f  息
  111,96,17,19,95,19,1,254,0,1,144,0,0,0,3,192,0,0,7,255,255,248,0,7,149,85,184,0,7,149,85,120,0,7,255,255,248,0,7,64,0,120,0,7,149,85,120,0,7,255,255,248,0,7,64,0,120,0,7,255,255,248,0,1,86,149,80,0,0,3,192,0,0,29,97,240,56,0,44,116,116,46,0,60,116,17,79,64,240,116,2,195,192,160,63,255,129,128,0,26,169,0,0,
  // 0x611f  感
  31,97,17,19,95,19,1,254,0,0,24,80,0,0,0,44,252,0,21,85,125,125,64,47,255,255,255,128,44,0,29,0,0,45,255,222,44,0,44,0,15,56,0,60,255,199,244,0,56,210,195,224,0,56,193,199,208,192,176,255,239,245,192,240,6,40,63,192,144,7,192,6,0,8,17,240,16,0,30,116,96,60,0,44,116,1,159,0,124,116,2,199,128,240,63,255,131,192,0,26,169,0,0,
  // 0x620f  戏
  15,98,17,20,100,19,1,253,0,0,24,16,0,0,0,44,120,0,170,164,44,46,0,255,252,44,10,0,0,60,45,0,64,32,56,111,255,192,180,123,255,233,64,60,181,110,0,0,30,240,14,11,0,11,224,15,14,0,3,208,15,60,0,3,224,15,188,0,15,244,11,240,0,31,60,7,208,0,124,45,11,193,192,244,4,47,210,192,224,0,253,247,192,0,2,224,191,128,0,0,64,47,0,0,0,0,0,0,
  // 0x6210  成
  16,98,17,20,100,19,1,253,0,0,40,80,0,0,0,60,248,0,0,0,60,30,0,26,170,190,175,128,47,255,255,255,192,44,0,44,0,0,44,0,44,0,0,44,0,45,14,0,47,255,29,29,0,46,175,30,60,0,44,15,15,120,0,60,15,15,240,0,60,15,11,208,0,60,14,11,193,64,61,254,31,193,192,120,164,127,210,192,180,1,248,243,192,240,7,224,191,128,144,2,64,30,0,0,0,0,0,0,
  // 0x6237  户
  55,98,15,19,76,19,1,254,0,1,128,0,0,1,208,0,0,0,240,0,10,170,250,168,15,255,255,252,15,0,0,44,15,0,0,44,15,0,0,44,15,0,0,44,15,255,255,252,15,170,170,188,14,0,0,44,13,0,0,0,29,0,0,0,60,0,0,0,60,0,0,0,184,0,0,0,240,0,0,0,80,0,0,0,
  // 0x6240  所
  64,98,19,19,95,19,0,254,0,0,0,0,64,26,170,128,11,224,63,255,218,255,128,0,0,15,228,0,10,170,143,0,0,15,255,207,0,0,13,3,207,0,0,13,3,207,255,244,13,3,207,175,224,15,171,207,7,64,15,255,206,7,64,29,0,14,7,64,29,0,29,7,64,28,0,44,7,64,44,0,60,7,64,60,0,180,7,64,56,0,240,7,64,116,1,208,7,64,16,0,64,2,64,
  // 0x6247  扇
  71,98,17,18,90,19,1,254,85,85,85,85,0,191,255,255,255,64,0,0,0,0,0,31,255,255,253,0,30,85,85,109,0,29,0,0,13,0,31,255,255,253,0,30,85,85,84,0,29,85,69,85,0,30,255,207,255,0,44,82,198,15,0,44,178,199,143,0,60,38,193,79,0,56,30,193,175,0,182,250,223,143,0,242,66,200,15,0,208,31,192,190,0,0,5,0,20,0,
  // 0x624b  手
  75,98,17,19,95,19,1,254,0,0,0,96,0,0,86,191,252,0,47,255,254,144,0,21,82,208,0,0,0,1,208,0,0,0,1,208,0,0,47,255,255,255,0,42,171,250,170,0,0,1,208,0,0,0,1,208,0,0,170,171,250,170,128,255,255,255,255,192,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,255,192,0,0,0,170,0,0,0,
  // 0x6253  打
  83,98,17,19,95,19,1,254,2,64,0,0,0,7,64,0,0,0,7,67,255,255,192,7,67,255,255,192,175,232,0,240,0,255,252,0,240,0,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,7,252,0,240,0,111,248,0,240,0,255,128,0,240,0,87,64,0,240,0,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,127,0,127,240,0,41,0,63,128,0,
  // 0x6267  执
  103,98,17,19,95,19,1,254,10,0,36,0,0,15,0,52,0,0,15,0,52,0,0,15,0,52,0,0,175,154,190,164,0,255,239,255,248,0,15,0,116,56,0,15,0,116,56,0,15,1,112,56,0,15,255,240,56,0,191,226,244,56,0,255,0,254,56,0,79,0,235,248,0,15,2,209,56,0,15,3,192,56,64,15,15,64,56,192,15,47,0,45,192,190,124,0,31,192,104,32,0,6,0,
  // 0x6279  批
  121,98,18,19,95,19,0,254,2,64,64,16,0,3,130,192,112,0,3,130,192,112,0,3,130,192,112,0,43,230,192,112,0,63,250,192,112,128,3,130,192,114,240,3,130,255,127,192,3,130,234,126,0,3,230,192,116,0,31,246,192,112,0,127,194,192,112,0,19,130,192,112,0,3,130,192,112,0,3,130,192,112,32,3,130,193,112,112,3,135,255,116,112,63,143,233,127,240,25,4,0,26,128,
  // 0x6296  抖
  150,98,17,19,95,19,1,254,6,0,0,36,0,11,0,0,56,0,11,0,240,56,0,11,0,125,56,0,175,160,15,56,0,255,244,0,56,0,11,0,0,56,0,11,3,208,56,0,11,1,252,56,0,11,180,44,56,0,191,244,0,56,0,255,64,0,62,192,75,1,111,255,192,11,11,255,188,0,11,6,64,56,0,11,0,0,56,0,11,0,0,56,0,191,0,0,56,0,100,0,0,36,0,
  // 0x62a5  报
  165,98,17,19,95,19,1,254,6,0,0,0,0,11,3,255,255,0,11,3,234,175,0,11,3,128,15,0,175,227,128,15,0,255,247,129,95,0,11,3,135,253,0,11,3,128,0,0,11,3,255,255,64,11,183,254,175,64,191,247,172,11,0,255,67,142,14,0,75,3,139,108,0,11,3,131,248,0,11,3,130,244,0,11,3,131,252,0,11,3,175,111,128,255,3,252,7,128,104,1,0,0,0,
  // 0x62ac  抬
  172,98,17,19,95,19,1,254,6,0,24,0,0,11,0,45,0,0,11,0,60,0,0,11,0,120,32,0,255,240,176,60,0,175,160,240,30,0,11,1,229,111,64,11,15,255,255,192,11,10,149,2,192,11,244,0,0,0,255,226,170,170,0,239,3,255,255,0,11,3,192,15,0,11,3,192,15,0,11,3,192,15,0,11,3,192,15,0,11,3,255,255,0,191,3,234,175,0,40,2,64,5,0,
  // 0x62bd  抽
  189,98,17,19,95,19,1,254,6,0,2,64,0,11,0,3,64,0,11,0,3,64,0,11,0,3,64,0,175,160,3,64,0,255,247,255,255,192,11,7,239,235,192,11,7,3,67,192,11,7,3,67,192,11,187,3,67,192,191,251,255,255,192,255,7,171,235,192,75,7,3,67,192,11,7,3,67,192,11,7,3,67,192,11,7,239,235,192,11,7,255,255,192,191,7,0,3,192,100,6,0,1,64,
  // 0x62d4  拔
  212,98,17,19,95,19,1,254,6,0,36,0,0,11,0,56,184,0,11,0,56,47,0,11,0,56,7,0,175,165,121,85,64,255,251,255,255,192,11,0,116,0,0,11,0,120,4,0,11,0,188,14,0,11,176,188,29,0,191,240,254,44,0,255,0,235,60,0,75,1,215,180,0,11,3,195,240,0,11,7,130,240,0,11,15,7,252,0,11,46,31,47,64,191,60,124,7,192,100,16,16,0,64,
  // 0x62e9  择
  233,98,17,19,95,19,1,254,6,0,0,0,0,15,2,170,169,0,15,7,255,255,0,15,0,240,45,0,175,160,120,184,0,255,240,31,224,0,15,0,31,208,0,15,1,253,253,0,15,15,208,31,192,15,244,7,65,64,191,226,171,169,0,255,3,255,255,0,15,0,7,64,0,15,0,7,64,0,15,15,255,255,192,15,10,175,170,128,15,0,7,64,0,191,0,7,64,0,40,0,6,0,0,
  // 0x6309  按
  9,99,17,19,95,19,1,254,6,0,7,64,0,11,0,7,64,0,11,0,7,64,0,11,11,255,255,192,175,171,170,171,192,255,251,9,2,192,11,11,29,2,192,11,0,44,0,0,11,10,190,170,128,11,191,255,255,192,111,240,176,45,0,255,0,240,60,0,75,1,224,60,0,11,2,253,180,0,11,1,95,240,0,11,0,11,253,0,15,1,190,47,64,191,31,224,7,192,100,5,0,0,0,
  // 0x6321  挡
  33,99,17,19,95,19,1,254,6,0,2,0,0,15,0,7,64,0,15,7,71,71,128,15,3,135,75,0,175,162,199,79,0,255,241,215,77,0,15,0,135,92,0,15,0,7,64,0,15,11,255,255,64,15,102,170,175,64,191,224,0,7,64,255,2,170,171,64,15,7,255,255,64,15,0,0,7,64,15,0,0,7,64,15,0,0,7,64,15,15,255,255,64,191,10,170,175,64,100,0,0,2,0,
  // 0x6324  挤
  36,99,17,19,95,19,1,254,9,0,9,0,0,14,0,15,0,0,14,10,175,170,64,14,31,255,255,192,175,129,208,60,0,255,208,240,120,0,14,0,125,240,0,14,0,31,192,0,14,1,191,248,0,15,239,244,191,192,127,222,128,22,64,254,0,224,56,0,78,0,224,56,0,14,0,224,56,0,14,1,208,56,0,14,3,192,56,0,14,11,128,56,0,253,62,0,56,0,100,4,0,36,0,
  // 0x635f  损
  95,99,18,19,95,19,0,254,2,64,0,0,0,3,192,255,255,64,3,192,245,91,64,3,192,240,7,64,43,232,245,91,64,63,252,255,255,64,3,192,0,0,0,3,192,85,85,64,3,193,255,255,192,3,217,208,2,192,7,253,209,130,192,127,209,210,194,192,55,193,210,194,192,3,193,210,194,192,3,193,211,130,192,3,192,15,45,0,3,192,189,31,128,63,139,240,2,240,26,2,0,0,96,
  // 0x6362  换
  98,99,17,19,95,19,1,254,9,0,36,0,0,14,0,180,0,0,14,0,255,252,0,14,3,229,188,0,175,159,128,180,0,255,239,85,245,0,14,11,255,255,0,14,7,75,15,0,14,7,75,15,0,15,231,75,15,0,255,215,75,15,0,238,47,255,255,192,14,26,175,170,128,14,0,63,192,0,14,0,185,224,0,14,1,240,180,0,14,11,192,62,0,190,126,0,11,192,104,36,0,1,64,
  // 0x6389  掉
  137,99,17,19,95,19,1,254,9,0,6,0,0,15,0,11,0,0,15,0,11,255,192,15,0,11,170,64,175,144,11,0,0,255,235,255,255,0,15,11,85,95,0,15,11,0,11,0,15,11,255,255,0,15,235,85,95,0,191,235,0,11,0,255,11,255,255,0,79,5,95,85,0,15,0,11,0,0,15,63,255,255,192,15,26,175,170,128,15,0,11,0,0,254,0,11,0,0,100,0,10,0,0,
  // 0x63a2  探
  162,99,18,19,95,19,1,254,9,0,0,0,0,14,5,85,85,64,14,15,255,255,192,14,14,20,82,192,175,158,52,226,192,255,224,116,224,0,14,0,240,225,192,14,11,192,255,192,14,74,0,21,0,15,224,11,0,0,255,154,175,170,128,238,15,255,255,192,14,0,63,224,0,14,0,191,244,0,14,2,235,60,0,14,11,203,15,64,14,63,11,7,208,254,24,11,0,64,100,0,6,0,0,
  // 0x63a5  接
  165,99,17,19,95,19,1,254,6,0,1,0,0,11,0,11,0,0,11,5,95,149,64,11,15,255,255,128,175,144,224,60,0,255,224,240,56,0,11,0,176,176,0,11,47,255,255,192,11,26,190,170,128,15,160,60,0,0,255,229,189,85,64,255,31,255,255,192,11,0,224,60,0,11,2,208,116,0,11,3,249,240,0,11,1,111,224,0,15,0,111,253,0,191,47,244,31,128,104,25,0,2,0,
  // 0x63a7  控
  167,99,17,19,95,19,1,254,9,0,6,0,0,14,0,11,0,0,14,5,95,149,64,14,31,255,255,192,175,173,52,226,192,255,237,52,225,192,14,0,176,224,0,14,0,240,225,192,14,91,192,255,192,15,238,0,21,0,255,128,0,0,0,238,11,255,255,64,14,6,175,170,0,14,0,11,0,0,14,0,11,0,0,14,0,11,0,0,14,26,175,170,128,254,47,255,255,192,100,0,0,0,0,
  // 0x63d0  提
  208,99,17,19,95,19,1,254,9,0,0,0,0,14,3,255,255,0,14,3,149,95,0,14,3,128,15,0,255,227,255,255,0,175,147,64,15,0,14,3,255,255,0,14,1,85,85,0,14,0,0,0,0,15,175,255,255,192,127,229,95,149,64,254,2,75,0,0,78,3,75,85,0,14,7,75,255,0,14,11,203,0,0,14,15,219,0,0,14,45,191,0,0,253,120,31,255,192,100,32,1,106,128,
  // 0x63d2  插
  210,99,17,19,95,19,1,254,9,0,0,0,0,14,0,21,191,0,14,15,255,249,0,14,1,75,0,0,175,144,7,0,0,255,255,255,255,192,14,10,175,170,128,14,0,7,0,0,14,5,187,21,64,15,223,235,127,128,191,222,7,3,128,254,14,7,3,128,14,15,247,63,128,14,15,151,43,128,14,14,7,3,128,14,14,7,3,128,14,15,255,255,128,254,15,170,171,128,100,9,0,2,64,
  // 0x6536  收
  54,101,18,19,95,19,1,254,0,32,20,0,0,0,116,44,0,0,16,116,60,0,0,56,116,120,0,0,56,116,191,255,208,56,116,250,175,128,56,117,244,15,0,56,119,248,14,0,56,127,124,29,0,56,118,44,44,0,56,116,14,56,0,56,180,15,180,0,127,244,7,240,0,255,180,3,208,0,144,116,15,240,0,0,116,62,188,0,0,118,248,47,128,0,123,208,11,192,0,37,0,0,64,
  // 0x653e  放
  62,101,18,19,95,19,0,254,0,160,1,64,0,0,240,3,192,0,0,240,3,192,0,42,250,135,128,0,63,255,203,255,240,3,128,15,171,224,3,128,31,3,128,3,234,127,71,64,3,255,255,139,0,3,131,179,207,0,3,135,65,222,0,3,71,64,252,0,7,71,64,252,0,11,7,64,184,0,15,7,66,253,0,30,7,7,223,64,60,11,127,7,224,120,255,184,1,240,16,100,16,0,0,
  // 0x6570  数
  112,101,17,19,95,19,1,254,0,128,2,0,0,49,211,71,64,0,57,219,11,0,0,41,217,15,0,0,255,255,207,255,192,91,245,95,175,128,15,252,62,15,0,62,223,127,14,0,245,210,191,14,0,66,192,247,93,0,7,128,19,188,0,255,255,195,248,0,110,110,66,244,0,60,44,1,240,0,127,124,3,248,0,23,248,15,189,0,11,254,126,31,128,254,11,244,7,192,80,0,64,0,64,
  // 0x6572  敲
  114,101,17,19,95,19,1,254,0,128,1,128,0,1,192,2,192,0,86,229,66,192,0,255,255,194,255,192,0,0,2,234,128,47,253,2,192,0,44,29,2,192,0,44,29,127,255,64,47,253,110,175,64,0,0,28,11,0,191,255,77,15,0,181,87,79,29,0,183,243,71,188,0,182,51,67,244,0,182,51,66,240,0,183,243,75,252,0,182,3,191,47,128,176,47,184,7,192,16,0,0,0,0,
  // 0x6574  整
  116,101,17,19,95,19,1,254,0,128,1,0,0,1,208,7,64,0,255,255,207,85,64,1,208,31,255,192,127,255,190,14,0,113,195,251,44,0,127,255,67,248,0,11,248,2,244,0,46,239,31,254,0,245,194,189,11,192,0,64,16,1,64,63,255,255,255,0,21,86,229,85,0,2,65,208,0,0,3,129,255,248,0,3,129,229,80,0,3,129,208,0,0,255,255,255,255,192,85,85,85,85,64,
  // 0x6599  料
  153,101,18,19,95,19,0,254,0,144,0,6,0,0,209,0,11,0,52,211,78,11,0,44,215,11,203,0,28,219,1,219,0,13,237,0,11,0,4,228,0,11,0,63,255,188,11,0,43,250,95,75,0,3,240,3,75,0,7,252,0,11,0,15,238,0,15,176,29,219,91,255,240,60,210,127,239,0,116,208,16,11,0,48,208,0,11,0,0,208,0,11,0,0,208,0,11,0,0,144,0,6,0,
  // 0x659c  斜
  156,101,18,19,95,19,0,254,0,100,0,2,64,0,253,0,3,64,2,239,131,131,64,3,195,210,231,64,15,0,224,187,64,47,170,128,19,64,127,255,193,3,64,32,52,15,67,64,0,52,3,211,64,63,255,240,247,64,42,190,144,3,64,4,52,64,11,240,14,54,198,255,240,29,53,223,235,64,44,52,228,3,64,56,52,176,3,64,32,52,0,3,64,3,244,0,3,64,2,144,0,2,64,
  // 0x65ad  断
  173,101,18,19,95,19,1,254,0,32,0,0,0,112,52,0,31,128,119,54,223,254,0,115,119,159,64,0,115,123,29,0,0,113,57,29,0,0,123,255,221,0,0,117,185,95,255,208,112,188,31,175,128,112,255,29,29,0,115,251,157,29,0,123,117,92,29,0,122,52,44,29,0,112,52,60,29,0,112,32,56,29,0,127,255,244,29,0,122,170,240,29,0,112,2,208,29,0,0,0,64,9,0,
  // 0x65b0  新
  176,101,17,19,95,19,1,254,0,64,0,0,0,1,192,0,31,64,86,229,43,254,0,255,255,174,144,0,40,13,44,0,0,28,28,44,0,0,12,40,44,0,0,255,255,175,255,192,171,234,110,190,128,1,192,44,28,0,255,255,172,28,0,171,234,124,28,0,7,240,56,28,0,15,252,56,28,0,62,223,180,28,0,245,193,240,28,0,209,194,224,28,0,1,195,192,28,0,1,128,0,24,0,
  // 0x65b9  方
  185,101,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,255,255,255,255,192,170,191,170,170,128,0,30,0,0,0,0,45,0,0,0,0,47,170,164,0,0,63,255,248,0,0,60,0,56,0,0,120,0,120,0,0,180,0,116,0,0,240,0,116,0,3,208,0,180,0,11,192,0,240,0,63,0,1,240,0,252,0,255,208,0,16,0,170,64,0,
  // 0x65e0  无
  224,101,17,18,90,19,1,254,42,170,170,170,0,63,255,255,255,0,0,2,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,170,171,234,170,128,255,255,255,255,192,0,3,128,0,0,0,7,180,0,0,0,15,116,0,0,0,15,116,0,0,0,61,116,0,0,0,188,116,1,192,2,240,116,2,192,31,208,120,3,192,255,0,63,255,128,100,0,26,170,0,
  // 0x65f6  时
  246,101,17,19,95,19,1,254,0,0,0,24,0,0,0,0,44,0,127,248,0,44,0,122,184,0,44,0,112,57,170,191,128,112,58,255,255,192,112,56,0,44,0,122,184,16,44,0,127,248,240,44,0,112,56,120,44,0,112,56,45,44,0,112,56,15,44,0,112,56,10,44,0,122,184,0,44,0,127,248,0,44,0,112,0,0,44,0,112,0,0,60,0,0,0,15,252,0,0,0,10,160,0,
  // 0x660e  明
  14,102,17,18,90,19,1,254,106,168,191,255,128,127,252,186,171,128,112,60,176,3,128,112,60,176,3,128,112,60,176,3,128,122,188,191,255,128,127,252,186,171,128,112,60,176,3,128,112,60,176,3,128,112,60,176,3,128,112,60,255,255,128,127,252,250,171,128,122,168,224,3,128,112,2,208,3,128,16,3,192,3,128,0,15,64,3,128,0,62,0,255,64,0,8,0,105,0,
  // 0x662f  是
  47,102,17,18,90,19,1,254,15,255,255,252,0,15,85,85,124,0,15,0,0,60,0,15,255,255,252,0,15,0,0,60,0,15,85,85,124,0,15,255,255,252,0,0,0,0,0,0,255,255,255,255,192,106,170,250,170,64,2,128,224,0,0,3,128,250,169,0,7,128,255,254,0,15,208,224,0,0,46,249,224,0,0,188,47,250,170,128,240,6,255,255,192,0,0,0,0,0,
  // 0x6682  暂
  130,102,17,19,95,19,1,254,1,64,0,1,0,87,213,70,191,64,255,255,223,229,0,29,16,28,0,0,56,176,30,85,64,191,255,223,255,192,85,181,92,44,0,0,176,44,44,0,107,255,188,44,0,250,244,116,44,0,0,176,112,44,0,5,85,85,84,0,11,255,255,252,0,11,0,0,60,0,11,255,255,252,0,11,0,0,60,0,11,85,85,124,0,11,255,255,252,0,6,0,0,40,0,
  // 0x66ab  暫
  171,102,17,19,95,19,1,254,1,192,0,5,0,255,255,154,255,0,1,208,47,144,0,127,255,44,0,0,113,195,109,85,64,127,255,111,255,192,113,195,124,60,0,127,255,116,60,0,255,255,240,60,0,1,209,224,60,0,0,64,0,20,0,7,255,255,244,0,7,149,85,180,0,7,64,0,116,0,7,255,255,244,0,7,128,0,180,0,7,149,85,180,0,7,255,255,244,0,6,0,0,100,0,
  // 0x66f4  更
  244,102,17,18,90,19,1,254,106,170,170,170,64,191,255,255,255,128,0,1,224,0,0,5,86,229,84,0,15,255,255,254,0,14,1,224,14,0,15,86,229,110,0,15,255,255,254,0,14,1,224,14,0,14,1,224,14,0,15,255,255,254,0,6,151,229,84,0,7,131,192,0,0,2,235,128,0,0,0,191,0,0,0,6,255,233,0,0,191,209,255,255,192,100,0,1,106,128,
  // 0x6700  最
  0,103,17,18,90,19,1,254,11,255,255,248,0,11,64,0,120,0,11,255,255,248,0,11,0,0,56,0,11,0,0,120,0,11,255,255,248,0,0,0,0,0,0,255,255,255,255,192,110,95,85,85,64,30,15,21,85,0,31,255,127,255,0,29,11,28,30,0,31,255,14,60,0,30,95,7,248,0,29,11,3,240,0,255,255,31,244,0,165,11,254,63,128,0,11,96,6,128,
  // 0x6709  有
  9,103,17,19,95,19,1,254,0,5,0,0,0,0,15,0,0,0,0,30,0,0,0,255,255,255,255,192,170,254,170,170,128,0,240,0,0,0,1,250,170,164,0,3,255,255,248,0,15,208,0,56,0,47,208,0,56,0,253,255,255,248,0,161,229,85,184,0,1,208,0,56,0,1,255,255,248,0,1,229,85,184,0,1,208,0,56,0,1,208,0,56,0,1,208,15,244,0,0,144,6,144,0,
  // 0x671f  期
  31,103,17,19,95,19,1,254,24,10,0,0,0,28,14,10,170,64,28,14,15,255,128,255,255,206,3,128,190,175,142,3,128,28,14,14,3,128,31,254,15,255,128,29,94,15,171,128,28,14,14,3,128,31,254,14,3,128,29,94,15,171,128,28,14,31,255,128,190,175,157,3,128,255,255,220,3,128,9,20,44,3,128,30,45,60,3,128,60,15,120,3,128,240,6,180,127,64,80,0,16,41,0,
  // 0x673a  机
  58,103,19,19,95,19,0,254,0,160,0,0,0,0,224,26,170,0,0,224,47,255,0,0,224,44,15,0,42,250,44,15,0,63,255,108,15,0,1,224,44,15,0,2,240,44,15,0,3,244,44,15,0,7,253,44,15,0,14,239,60,15,0,13,227,60,15,0,60,225,56,15,0,116,224,120,15,16,48,224,176,15,56,0,224,240,15,56,0,226,208,15,52,0,227,192,11,244,0,225,0,2,144,
  // 0x6740  杀
  64,103,17,19,95,19,1,254,0,0,0,16,0,15,64,1,244,0,11,244,11,208,0,0,127,191,0,0,0,11,252,0,0,0,127,191,128,0,27,248,7,244,0,191,128,0,189,0,36,1,208,4,0,0,1,208,0,0,255,255,255,255,192,170,171,250,170,64,0,65,208,64,0,3,193,209,224,0,15,65,208,188,0,62,1,208,47,0,248,1,208,11,128,96,47,208,1,0,0,26,64,0,0,
  // 0x675f  束
  95,103,17,19,95,19,1,254,0,1,144,0,0,0,1,208,0,0,106,171,250,170,64,191,255,255,255,128,0,1,208,0,0,0,1,208,0,0,15,255,255,253,0,15,171,234,189,0,13,1,208,29,0,13,1,208,29,0,15,171,234,189,0,15,255,255,253,0,0,15,252,0,0,0,63,239,0,0,1,245,215,208,0,15,193,208,253,0,254,1,208,63,192,180,1,208,7,128,0,1,144,0,0,
  // 0x6761  条
  97,103,17,19,95,19,1,254,0,9,0,0,0,0,61,0,0,0,0,191,255,224,0,2,250,171,208,0,31,248,11,128,0,125,46,47,0,0,16,11,248,0,0,0,31,254,0,0,6,254,47,249,64,191,224,129,191,192,120,1,208,1,0,106,170,234,170,64,255,255,255,255,192,0,31,253,0,0,0,185,219,128,0,7,225,210,244,0,127,65,208,127,128,248,1,208,11,128,0,1,128,0,0,
  // 0x6765  来
  101,103,17,19,95,19,1,254,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,63,255,255,255,0,42,171,250,170,0,7,65,208,56,0,3,193,208,180,0,2,209,208,240,0,0,209,209,192,0,255,255,255,255,192,170,175,254,170,128,0,15,252,0,0,0,62,239,0,0,0,241,211,192,0,7,193,209,244,0,47,65,208,126,0,252,1,208,15,192,96,1,208,2,64,0,1,144,0,0,
  // 0x677f  板
  127,103,18,19,95,19,0,254,0,144,0,0,0,1,208,106,170,160,1,208,127,255,240,1,208,116,0,0,42,249,116,0,0,63,254,116,0,0,2,208,122,170,144,3,208,127,255,224,7,240,127,1,192,11,252,187,2,192,14,238,179,131,128,29,218,179,203,64,57,208,241,239,0,113,208,224,253,0,17,209,208,188,0,1,211,193,255,0,1,215,203,203,208,1,219,47,2,240,0,129,4,0,16,
  // 0x6797  林
  151,103,18,19,95,19,0,254,0,160,0,100,0,0,176,0,116,0,0,176,0,116,0,0,176,0,116,0,42,250,90,254,160,63,255,175,255,240,0,240,0,252,0,2,252,1,253,0,3,255,2,254,0,7,247,131,255,0,11,179,139,187,64,29,176,14,119,192,60,176,60,117,208,116,176,184,116,240,32,176,240,116,96,0,176,0,116,0,0,176,0,116,0,0,176,0,116,0,0,96,0,96,0,
  // 0x67f1  柱
  241,103,19,19,95,19,0,254,0,144,1,0,0,0,224,7,208,0,0,224,1,244,0,0,224,0,124,0,42,250,106,190,160,63,255,191,255,240,1,224,0,176,0,3,224,0,176,0,3,244,0,176,0,7,252,0,176,0,14,239,63,255,224,29,231,42,250,144,60,224,0,176,0,116,224,0,176,0,32,224,0,176,0,0,224,0,176,0,0,225,170,250,160,0,226,255,255,244,0,144,0,0,0,
  // 0x6821  校
  33,104,17,19,95,19,1,254,1,0,1,0,0,7,64,3,128,0,7,64,3,128,0,7,66,171,234,128,175,155,255,255,192,255,244,16,4,0,11,64,180,61,0,15,64,240,15,0,31,195,208,7,128,47,235,180,62,192,63,181,60,120,0,119,116,45,240,0,231,64,15,224,0,199,64,11,192,0,135,64,15,224,0,7,64,62,248,0,7,66,244,63,64,7,79,192,11,192,2,5,0,1,64,
  // 0x683c  格
  60,104,18,19,95,19,0,254,0,128,2,0,0,1,208,11,64,0,1,208,15,170,64,1,208,47,255,128,1,208,124,11,64,63,254,254,15,0,43,251,239,125,0,3,225,131,248,0,3,244,2,244,0,7,253,15,190,0,15,221,189,11,224,30,215,249,91,240,61,209,191,255,192,117,208,52,3,192,33,208,52,3,192,1,208,52,3,192,1,208,58,171,192,1,208,63,255,192,0,128,36,2,128,
  // 0x68af  梯
  175,104,17,19,95,19,1,254,6,0,80,8,0,7,64,240,29,0,7,64,116,60,0,7,66,186,190,0,175,167,255,255,64,255,244,3,67,64,11,64,3,67,64,15,65,171,171,64,15,195,255,255,64,47,227,131,64,0,63,183,67,64,0,123,123,255,255,192,247,75,175,171,192,215,64,47,67,192,135,64,191,67,128,7,67,227,107,128,7,95,131,111,0,7,73,3,64,0,6,0,2,64,0,
  // 0x68c0  检
  192,104,17,19,95,19,1,254,6,0,6,0,0,11,0,15,0,0,11,0,47,128,0,11,0,121,224,0,255,224,224,188,0,175,147,192,47,0,15,31,149,111,192,31,189,255,245,192,47,208,0,0,0,63,177,0,6,0,127,87,10,11,0,235,3,75,14,0,219,3,135,28,0,139,2,195,56,0,11,1,65,112,0,11,0,0,176,0,11,31,255,255,128,11,10,170,170,64,6,0,0,0,0,
  // 0x69fd  槽
  253,105,18,19,95,19,0,254,2,192,6,24,0,2,192,11,44,0,2,195,255,255,240,2,193,95,125,80,43,232,15,60,0,63,253,255,255,224,3,193,203,40,224,3,193,255,255,224,7,225,203,56,224,11,241,203,56,224,15,237,255,255,224,30,204,21,85,64,58,192,191,255,192,114,192,176,3,192,18,192,191,255,192,2,192,176,3,192,2,192,181,87,192,2,192,191,255,192,1,128,160,1,128,
  // 0x6a21  模
  33,106,17,19,95,19,1,254,6,0,96,36,0,15,0,176,52,0,15,15,255,255,192,15,5,185,185,64,255,224,96,36,0,175,151,255,255,0,15,7,85,95,0,15,71,64,15,0,47,199,255,255,0,63,231,64,11,0,63,119,255,255,0,191,1,95,85,0,239,0,15,0,0,207,31,255,255,192,79,5,127,229,64,15,0,124,240,0,15,2,240,126,0,15,47,128,31,192,10,8,0,1,64,
  // 0x6a59  橙
  89,106,19,19,95,19,0,254,1,128,0,16,0,1,193,255,54,64,1,192,95,63,64,1,193,77,29,96,43,234,252,15,208,63,252,189,95,128,2,192,239,254,224,3,199,192,0,244,7,242,85,85,96,11,244,191,255,128,15,236,176,3,128,30,204,176,3,128,61,192,191,255,128,117,192,41,94,0,33,192,60,14,0,1,192,29,28,0,1,194,174,174,160,1,195,255,255,240,1,128,0,0,0,
  // 0x6b62  止
  98,107,17,18,90,19,1,255,0,0,96,0,0,0,0,176,0,0,0,0,176,0,0,0,0,176,0,0,1,0,176,0,0,11,64,176,0,0,11,64,176,0,0,11,64,191,255,0,11,64,191,255,0,11,64,176,0,0,11,64,176,0,0,11,64,176,0,0,11,64,176,0,0,11,64,176,0,0,11,64,176,0,0,11,64,176,0,0,255,255,255,255,192,255,255,255,255,192,
  // 0x6b63  正
  99,107,17,16,80,19,1,255,127,255,255,255,64,42,170,250,170,64,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,11,64,240,0,0,11,64,250,169,0,11,64,255,254,0,11,64,240,0,0,11,64,240,0,0,11,64,240,0,0,11,64,240,0,0,11,64,240,0,0,11,64,240,0,0,255,255,255,255,192,170,170,170,170,128,
  // 0x6b65  步
  101,107,17,19,95,19,1,254,0,1,144,0,0,1,1,208,0,0,3,129,250,168,0,3,129,255,252,0,3,129,208,0,0,3,129,208,0,0,171,235,250,170,128,255,255,255,255,192,0,1,208,0,0,3,209,208,56,0,15,129,208,120,0,62,1,208,244,0,184,27,210,224,0,16,31,139,192,0,0,0,47,0,0,0,6,252,0,0,1,191,208,0,0,31,249,0,0,0,9,64,0,0,0,
  // 0x6bd4  比
  212,107,18,18,90,19,1,255,6,0,24,0,0,15,0,44,0,0,15,0,44,0,0,15,0,44,0,0,15,0,44,0,0,15,0,44,11,0,15,170,44,191,64,15,255,47,244,0,15,0,47,64,0,15,0,44,0,0,15,0,44,0,0,15,0,44,0,0,15,0,44,0,0,15,0,44,1,192,15,6,108,1,208,15,255,172,2,192,255,249,31,171,192,164,0,11,255,64,
  // 0x6ca1  没
  161,108,17,18,90,19,1,254,62,3,255,240,0,11,195,234,240,0,1,131,192,176,0,0,3,128,176,128,0,7,64,176,192,244,15,0,186,192,190,61,0,127,128,15,20,0,0,0,0,31,255,254,0,0,27,234,189,0,2,67,192,60,0,3,193,224,244,0,11,64,186,224,0,15,0,63,192,0,45,0,191,208,0,60,27,246,254,64,116,191,64,47,192,0,32,0,1,64,
  // 0x6ce2  波
  226,108,17,19,95,19,1,254,0,0,10,0,0,62,0,15,0,0,15,192,15,0,0,2,95,255,255,192,0,31,175,171,128,0,29,15,7,64,244,29,15,11,0,190,29,15,0,0,14,31,255,254,0,0,31,234,174,0,0,29,224,44,0,3,28,176,60,0,7,108,60,180,0,15,60,31,224,0,30,60,15,192,0,60,116,47,240,0,120,241,252,190,64,113,231,224,31,192,0,66,0,1,64,
  // 0x6ce8  注
  232,108,17,19,95,19,1,254,4,0,80,0,0,63,64,253,0,0,11,192,47,128,0,0,64,7,192,0,0,26,171,234,128,64,31,255,255,192,248,0,15,0,0,127,0,15,0,0,10,0,15,0,0,0,0,15,0,0,0,6,175,170,0,1,139,255,255,0,3,192,15,0,0,7,128,15,0,0,15,0,15,0,0,30,0,15,0,0,60,42,175,170,128,52,63,255,255,192,0,0,0,0,0,
  // 0x6d17  洗
  23,109,18,19,95,19,1,254,0,1,10,0,0,61,3,203,0,0,31,135,139,0,0,3,75,239,170,64,0,15,255,255,64,0,30,11,0,0,244,60,11,0,0,126,24,11,0,0,14,42,175,170,128,0,63,255,255,192,0,0,240,224,0,3,0,224,224,0,7,64,224,224,0,15,1,208,224,0,30,3,192,224,192,44,7,128,224,208,60,31,0,224,208,116,188,0,255,192,16,32,0,42,64,
  // 0x6d3b  活
  59,109,17,19,95,19,1,254,0,0,0,4,0,61,0,22,255,0,31,203,255,248,0,3,139,171,0,0,0,0,11,0,0,0,0,11,0,0,80,42,175,170,128,253,63,255,255,192,31,0,11,0,0,1,0,11,0,0,0,0,11,0,0,1,75,255,255,0,3,203,170,175,0,11,75,0,11,0,15,11,0,11,0,60,11,0,11,0,120,11,255,255,0,112,11,170,175,0,0,6,0,5,0,
  // 0x6d41  流
  65,109,18,19,95,19,1,254,0,0,9,0,0,61,0,14,0,0,31,192,14,0,0,2,191,255,255,192,0,42,254,170,128,0,0,176,52,0,244,0,224,45,0,191,27,255,255,0,10,47,250,167,192,0,1,0,1,64,0,7,77,60,0,3,135,77,60,0,3,135,77,60,0,11,7,13,60,0,15,11,13,60,64,61,14,13,60,208,124,60,13,60,208,116,184,13,47,192,0,16,0,5,0,
  // 0x6d4b  测
  75,109,17,19,95,19,1,254,16,0,0,0,0,62,21,84,3,128,11,127,253,35,128,1,52,13,115,128,0,53,141,115,128,0,54,141,115,128,248,54,141,115,128,126,54,141,115,128,8,54,141,115,128,0,54,141,115,128,0,54,141,115,128,9,54,141,115,128,15,54,141,115,128,29,55,141,115,128,44,3,64,3,128,60,11,176,3,128,180,44,44,3,128,176,244,14,63,64,0,0,0,20,0,
  // 0x6d88  消
  136,109,17,19,95,19,1,254,0,0,6,0,0,61,9,11,3,64,31,143,11,11,64,3,71,139,15,0,0,3,203,29,0,0,0,11,0,0,160,15,255,255,0,189,15,170,175,0,15,15,0,11,0,0,15,85,95,0,0,15,255,255,0,2,79,0,11,0,3,143,0,11,0,11,15,255,255,0,15,15,170,175,0,45,15,0,11,0,60,15,0,11,0,116,15,0,255,0,16,10,0,168,0,
  // 0x6de1  淡
  225,109,17,18,90,19,1,255,0,0,5,0,0,56,0,15,0,0,47,71,79,15,0,3,143,14,30,0,0,29,30,60,0,0,4,47,144,0,160,0,126,244,0,189,6,240,127,0,30,47,137,11,64,0,4,15,1,0,0,7,14,11,64,3,79,15,15,0,11,94,31,45,0,15,44,63,168,0,45,0,122,224,0,124,2,240,248,0,180,127,128,47,192,16,57,0,6,128,
  // 0x6df7  混
  247,109,18,19,95,19,1,254,16,0,0,0,0,62,31,255,255,0,11,158,85,95,0,2,29,0,15,0,0,31,255,255,0,0,30,85,95,0,244,29,0,15,0,126,31,255,255,0,9,5,85,85,0,0,13,2,128,0,0,14,3,193,0,3,15,167,207,128,7,79,251,254,0,15,14,3,224,0,30,14,3,192,0,60,14,7,192,208,120,47,251,193,192,112,191,230,255,192,0,80,0,106,0,
  // 0x6e05  清
  5,110,17,19,95,19,1,254,0,0,9,0,0,60,5,95,85,0,47,95,255,255,128,3,128,15,0,0,0,15,255,255,0,0,0,15,0,0,248,63,255,255,192,127,21,85,85,64,10,1,85,85,0,0,7,255,255,0,0,7,64,15,0,3,135,255,255,0,7,135,64,15,0,11,7,64,15,0,15,7,255,255,0,61,7,64,15,0,124,7,64,15,0,112,7,64,254,0,0,2,0,84,0,
  // 0x6e29  温
  41,110,17,18,90,19,1,254,63,15,255,253,0,11,207,85,109,0,2,143,0,29,0,0,15,85,109,0,0,15,255,253,0,80,15,0,29,0,253,15,85,109,0,31,15,255,253,0,0,0,0,0,0,0,5,85,85,0,2,31,255,255,0,7,156,113,203,0,15,28,113,203,0,30,28,113,203,0,60,28,113,203,0,120,174,187,239,128,112,255,255,255,192,0,0,0,0,0,
  // 0x6e38  游
  56,110,17,19,95,19,1,254,0,6,0,64,0,60,7,1,208,0,47,7,2,192,0,6,175,167,255,192,0,255,255,234,128,0,28,15,0,0,244,44,15,170,64,189,44,2,255,192,12,47,240,11,0,0,46,240,45,0,0,60,112,60,0,13,56,187,255,192,14,56,182,190,128,45,116,176,56,0,60,176,176,56,0,56,224,240,56,0,182,208,224,56,0,179,143,211,248,0,0,6,65,144,0,
  // 0x6e90  源
  144,110,17,19,95,19,1,254,20,0,0,0,0,62,26,170,170,128,11,175,255,255,192,2,44,3,192,0,0,44,3,192,0,0,44,255,255,64,240,44,229,91,64,189,44,224,7,64,13,44,255,255,64,0,44,224,7,64,0,60,229,87,64,5,60,255,255,64,11,56,3,192,0,14,116,179,207,0,45,176,227,203,64,60,243,195,195,192,117,231,131,194,192,178,193,47,192,0,0,0,25,0,0,
  // 0x6ea2  溢
  162,110,17,18,90,19,1,254,61,1,63,240,0,31,71,154,180,0,3,15,0,62,0,0,46,85,107,192,0,122,255,242,64,160,16,0,0,0,189,0,63,240,0,13,3,154,184,0,0,11,0,61,0,0,29,0,15,64,4,61,85,95,192,15,255,255,254,0,14,29,114,141,0,45,13,114,141,0,60,13,114,141,0,116,174,187,239,128,176,255,255,255,192,0,0,0,0,0,
  // 0x6ed1  滑
  209,110,17,18,90,19,1,254,62,7,255,252,0,15,199,149,108,0,2,135,64,44,0,0,7,79,252,0,0,7,77,28,0,160,27,158,109,64,253,63,255,255,192,30,52,0,2,192,0,59,255,254,192,0,7,149,108,0,2,71,85,108,0,3,199,255,252,0,11,71,64,28,0,15,7,255,252,0,60,7,85,108,0,120,7,64,44,0,48,7,66,252,0,0,1,0,80,0,
  // 0x6f0f  漏
  15,111,17,19,95,19,1,254,16,0,0,0,0,125,63,255,255,64,31,125,85,91,64,2,56,0,7,64,0,63,255,255,64,0,61,85,85,0,240,56,0,0,0,190,63,255,255,192,30,61,87,149,64,0,57,87,149,0,0,63,255,255,128,9,59,3,67,128,14,123,183,183,128,29,187,43,91,128,44,183,3,67,128,60,231,179,183,128,181,215,59,87,128,242,199,3,67,128,16,71,3,95,64,
  // 0x6fc0  激
  192,111,18,19,95,19,1,254,16,2,64,144,0,61,7,64,224,0,15,191,249,208,0,1,117,121,208,0,0,112,58,255,208,0,127,251,235,192,244,116,63,199,0,125,117,127,199,0,8,127,255,203,0,0,3,69,223,0,0,255,252,238,0,9,110,84,189,0,15,13,0,60,0,30,15,244,60,0,44,30,180,188,0,60,60,52,255,0,116,180,119,199,128,177,227,255,66,192,0,129,64,0,0,
  // 0x706f  灯
  111,112,17,19,95,19,1,254,1,64,0,0,0,3,128,0,0,0,3,130,255,255,192,3,129,170,254,128,19,136,0,240,0,115,157,0,240,0,115,172,0,240,0,179,180,0,240,0,227,160,0,240,0,211,128,0,240,0,3,128,0,240,0,7,128,0,240,0,7,208,0,240,0,15,240,0,240,0,14,60,0,240,0,45,29,0,240,0,124,0,0,240,0,240,0,63,240,0,80,0,47,128,0,
  // 0x70b9  点
  185,112,17,19,95,19,1,254,0,1,128,0,0,0,2,208,0,0,0,2,234,170,0,0,2,255,255,0,0,2,208,0,0,0,2,208,0,0,10,171,234,168,0,15,255,255,252,0,15,0,0,60,0,15,0,0,60,0,15,0,0,60,0,15,255,255,252,0,10,170,170,168,0,0,0,0,4,0,14,28,44,44,0,45,44,29,15,0,124,29,15,11,64,240,29,11,3,192,16,4,0,1,0,
  // 0x70ed  热
  237,112,18,19,95,19,1,254,2,64,24,0,0,3,128,28,0,0,3,128,28,0,0,191,251,255,252,0,107,229,190,188,0,3,128,44,44,0,3,148,60,44,0,27,255,252,44,0,255,209,248,44,0,167,128,191,44,0,3,128,251,236,192,3,131,209,93,208,63,79,128,15,192,25,1,0,2,0,13,4,24,28,0,45,28,29,30,0,60,29,14,11,64,244,29,15,3,192,80,4,4,1,64,
  // 0x7247  片
  71,114,16,19,76,19,1,254,0,0,40,0,11,0,60,0,11,0,60,0,11,0,60,0,11,0,60,0,11,255,255,255,11,255,255,255,11,0,0,0,11,0,0,0,11,0,0,0,15,255,255,208,15,255,255,208,15,0,1,208,30,0,1,208,45,0,1,208,60,0,1,208,248,0,1,208,240,0,1,208,16,0,1,144,
  // 0x7269  物
  105,114,18,19,95,19,0,254,0,160,9,0,0,4,240,29,0,0,28,240,44,0,0,28,240,62,170,160,46,249,127,255,240,63,254,242,206,176,52,241,211,141,176,112,243,199,92,240,32,241,79,44,240,0,251,13,56,240,6,255,44,116,224,63,240,120,176,224,56,240,240,224,224,0,241,194,192,208,0,240,3,129,208,0,240,15,2,192,0,240,62,3,192,0,240,120,127,128,0,160,16,42,0,
  // 0x7279  特
  121,114,18,19,95,19,0,254,0,160,0,144,0,4,240,0,224,0,28,240,106,250,128,44,240,191,255,208,46,249,0,224,0,63,254,0,224,0,52,241,170,250,160,116,242,255,255,240,32,240,0,15,0,0,251,0,15,0,27,255,255,255,240,63,241,170,175,160,36,240,48,15,0,0,240,60,15,0,0,240,30,15,0,0,240,10,15,0,0,240,0,15,0,0,240,1,255,0,0,160,0,168,0,
  // 0x7387  率
  135,115,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,42,171,234,170,0,127,255,255,255,64,0,3,128,4,0,60,15,24,31,0,31,124,60,124,0,7,47,240,96,0,0,7,220,64,0,2,199,15,248,0,111,239,255,111,64,184,122,151,135,128,0,1,208,0,0,170,171,250,170,128,255,255,255,255,192,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,144,0,0,
  // 0x73af  环
  175,115,17,18,90,19,1,254,170,150,170,170,128,255,235,255,255,192,14,0,3,192,0,14,0,11,64,0,14,0,15,0,0,14,0,31,0,0,175,128,63,240,0,255,192,191,120,0,14,1,255,46,0,14,7,219,15,0,14,15,139,7,192,14,6,11,2,0,15,208,11,0,0,127,208,11,0,0,249,0,11,0,0,64,0,11,0,0,0,0,11,0,0,0,0,6,0,0,
  // 0x7528  用
  40,117,16,17,68,19,1,254,15,255,255,255,15,171,250,175,14,0,224,15,14,0,224,15,15,170,250,175,15,255,255,255,14,0,224,15,14,0,224,15,14,0,224,15,15,255,255,255,31,171,250,175,44,0,224,15,60,0,224,15,56,0,224,15,180,0,224,15,240,0,227,254,64,0,145,164,
  // 0x7535  电
  53,117,16,18,72,19,2,255,0,6,0,0,0,11,64,0,0,11,64,0,106,175,234,164,191,255,255,244,176,11,64,116,176,11,64,116,186,175,170,180,191,255,255,244,176,11,64,116,176,11,64,116,176,11,64,116,191,255,255,244,190,175,234,164,96,11,64,11,0,11,64,15,0,7,255,255,0,2,255,252,
  // 0x7565  略
  101,117,18,19,95,19,1,254,0,0,5,0,0,106,164,15,0,0,191,252,46,85,0,179,44,127,255,0,179,44,244,14,0,179,47,252,60,0,179,47,79,184,0,191,252,7,240,0,183,188,11,240,0,179,44,126,125,0,179,46,244,15,208,179,47,250,171,192,179,44,255,255,0,191,252,240,11,0,186,164,240,11,0,176,0,240,11,0,80,0,250,175,0,0,0,255,255,0,0,0,144,6,0,
  // 0x767d  白
  125,118,15,19,76,19,2,254,0,10,0,0,0,15,0,0,0,30,0,0,127,255,255,244,127,255,255,244,116,0,0,116,116,0,0,116,116,0,0,116,116,0,0,116,126,170,170,244,127,255,255,244,116,0,0,116,116,0,0,116,116,0,0,116,116,0,0,116,127,255,255,244,127,255,255,244,116,0,0,116,32,0,0,16,
  // 0x7684  的
  132,118,17,19,95,19,1,254,1,128,9,0,0,3,192,14,0,0,3,128,29,0,0,43,168,62,170,64,127,253,63,255,128,112,13,180,3,128,112,14,240,3,128,112,15,208,3,128,112,13,76,3,64,127,253,30,3,64,122,173,11,67,64,112,13,3,199,64,112,13,1,215,64,112,13,0,71,0,112,13,0,11,0,127,253,0,11,0,122,168,0,15,0,112,0,11,253,0,0,0,2,164,0,
  // 0x76d1  监
  209,118,17,18,90,19,1,255,0,36,5,0,0,44,56,15,0,0,44,56,14,0,0,44,56,47,255,192,44,56,62,170,128,44,56,116,0,0,44,56,242,208,0,44,58,208,248,0,44,56,128,61,0,4,56,0,13,0,0,0,0,0,0,15,255,255,252,0,15,110,110,124,0,14,13,28,44,0,14,13,28,44,0,14,13,28,44,0,175,175,190,190,128,255,255,255,255,192,
  // 0x76f4  直
  244,118,17,19,95,19,1,254,0,0,160,0,0,0,0,240,0,0,255,255,255,255,192,106,171,250,170,128,0,2,208,0,0,20,63,255,252,0,60,57,85,124,0,60,56,0,60,0,60,63,255,252,0,60,52,0,60,0,60,56,0,60,0,60,63,255,252,0,60,52,0,60,0,60,63,255,252,0,60,21,85,80,0,60,0,0,0,0,63,255,255,255,192,62,170,170,170,128,40,0,0,0,0,
  // 0x7701  省
  1,119,17,19,95,19,1,254,0,1,128,0,0,0,129,208,144,0,3,193,208,248,0,15,65,208,47,0,126,1,210,219,192,180,63,219,194,64,0,26,190,0,0,0,27,244,0,0,22,255,213,84,0,255,255,255,252,0,17,208,0,60,0,1,255,255,252,0,1,208,0,124,0,1,208,0,60,0,1,255,255,252,0,1,213,85,124,0,1,229,85,124,0,1,255,255,252,0,1,128,0,36,0,
  // 0x7720  眠
  32,119,18,18,90,19,1,254,106,161,170,170,64,191,242,255,255,128,176,178,192,3,128,176,178,192,3,128,185,242,234,171,128,191,242,255,255,128,176,178,193,208,0,176,178,192,208,0,185,242,234,250,128,191,242,255,255,192,176,178,192,224,0,176,178,192,240,0,176,178,192,176,0,191,242,192,116,128,186,162,193,120,224,176,7,255,172,208,0,15,249,15,192,0,4,0,2,64,
  // 0x786e  确
  110,120,18,19,95,19,0,254,0,0,5,0,0,42,170,15,0,0,63,255,15,253,0,3,192,46,125,0,3,128,120,60,0,3,64,249,185,80,7,1,255,255,224,11,169,116,176,224,15,253,52,176,224,31,13,63,255,224,63,13,121,245,224,127,13,116,176,224,43,13,127,255,224,11,13,122,170,224,11,173,176,0,224,11,254,224,0,224,11,2,208,0,224,6,3,192,31,208,0,0,0,10,64,
  // 0x79bb  离
  187,121,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,255,255,255,255,192,106,170,170,170,64,11,9,44,56,0,11,11,244,56,0,11,31,189,56,0,11,36,8,56,0,11,255,255,248,0,5,87,213,84,0,0,3,128,0,0,63,255,255,255,0,61,95,158,95,0,60,15,11,15,0,60,175,255,143,0,61,254,150,207,0,60,0,0,15,0,60,0,0,254,0,44,0,0,164,0,
  // 0x79fb  移
  251,121,18,19,95,19,0,254,0,4,0,144,0,1,190,3,192,0,63,244,11,255,192,21,224,62,91,192,0,225,253,11,0,0,224,219,158,0,63,255,1,248,0,43,250,7,224,0,2,224,191,244,0,3,248,165,245,80,11,254,7,255,240,13,235,47,1,208,60,225,255,131,192,116,224,147,239,64,32,224,0,190,0,0,224,1,248,0,0,224,111,208,0,0,225,254,0,0,0,144,128,0,0,
  // 0x7a7a  空
  122,122,17,18,90,19,1,255,0,1,128,0,0,0,1,208,0,0,106,171,234,170,64,127,255,255,255,64,116,44,29,7,64,116,60,29,7,64,0,120,29,0,0,1,240,29,3,64,47,208,15,255,0,126,0,5,165,0,16,0,0,0,0,6,170,170,168,0,15,255,255,252,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,106,171,234,170,64,255,255,255,255,128,
  // 0x7aef  端
  239,122,17,19,95,19,1,254,5,0,2,64,0,11,2,67,66,64,11,3,131,67,128,11,3,131,67,128,175,163,235,235,128,255,243,255,255,128,0,64,0,0,0,176,230,170,170,128,112,223,255,255,192,113,192,11,64,0,49,192,11,0,0,54,199,255,255,192,54,135,174,251,192,3,235,92,179,192,191,251,92,179,192,249,7,92,179,192,0,7,92,179,192,0,7,92,191,128,0,1,0,1,0,
  // 0x7b2c  第
  44,123,17,19,95,19,1,254,9,0,9,0,0,15,0,45,0,0,47,255,127,255,192,127,213,246,229,64,241,210,224,240,0,144,144,128,160,0,31,255,255,253,0,5,86,229,109,0,0,1,208,29,0,15,255,255,253,0,15,86,229,84,0,14,1,208,0,0,31,255,255,255,64,46,175,234,175,64,0,126,208,11,0,7,241,208,15,0,191,65,210,254,0,120,1,208,164,0,0,0,128,0,0,
  // 0x7b49  等
  73,123,17,19,95,19,1,254,5,0,9,0,0,15,0,45,0,0,47,255,127,255,192,126,230,250,229,64,240,225,224,240,0,64,65,208,64,0,15,255,255,253,0,5,86,229,84,0,0,1,208,0,0,255,255,255,255,192,170,170,171,234,128,0,0,2,192,0,42,170,171,234,64,127,255,255,255,128,1,208,2,192,0,0,248,2,192,0,0,61,2,192,0,0,8,127,192,0,0,0,42,0,0,
  // 0x7bb1  箱
  177,123,17,19,95,19,1,254,6,0,9,0,0,15,0,45,0,0,31,255,127,255,192,62,229,251,229,64,244,225,240,224,0,224,225,208,176,0,2,192,0,0,0,2,192,191,255,64,255,255,186,175,64,107,234,176,7,64,7,208,191,255,64,15,244,181,91,64,31,253,176,7,64,62,207,191,255,64,242,192,181,91,64,226,192,176,7,64,2,192,185,91,64,2,192,191,255,64,1,128,96,6,0,
  // 0x7c7b  类
  123,124,17,19,95,19,1,254,0,1,128,0,0,7,65,208,180,0,3,209,208,240,0,0,225,210,192,0,191,255,255,255,128,106,175,254,170,64,0,63,254,0,0,1,245,215,224,0,111,193,208,255,64,189,0,128,31,128,16,1,215,208,0,0,2,208,176,0,191,255,255,255,192,106,175,250,170,128,0,15,188,0,0,0,126,47,64,0,27,248,11,249,0,255,128,0,191,192,100,0,0,6,0,
  // 0x7d22  索
  34,125,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,127,255,255,255,64,106,171,234,170,0,0,1,208,0,0,191,255,255,255,128,186,175,170,171,128,176,31,1,3,128,178,188,15,67,128,7,240,125,0,0,0,249,241,128,0,0,47,130,240,0,85,127,85,253,0,191,255,255,255,64,0,129,208,66,0,3,225,210,224,0,47,65,208,126,0,248,1,208,11,128,16,1,128,1,0,
  // 0x7d2b  紫
  43,125,17,19,95,19,1,254,0,160,0,0,0,16,224,60,9,0,56,255,125,255,0,56,245,63,224,0,56,224,60,0,0,56,224,60,2,192,126,255,174,171,192,255,171,31,255,64,64,31,1,0,0,7,188,31,64,0,7,244,188,0,0,0,127,224,240,0,85,111,149,189,0,255,255,255,255,64,0,1,208,3,128,2,209,210,224,0,31,129,208,189,0,189,1,208,15,128,16,1,128,1,0,
  // 0x7ea2  红
  162,126,17,18,90,19,1,255,1,0,0,0,0,3,192,0,0,0,11,130,255,255,128,15,3,255,255,128,45,16,3,192,0,60,60,3,192,0,250,244,3,192,0,255,224,3,192,0,71,192,3,192,0,15,0,3,192,0,61,84,3,192,0,255,248,3,192,0,254,64,3,192,0,0,0,3,192,0,0,100,3,192,0,111,248,3,192,0,255,151,255,255,192,144,3,255,255,192,
  // 0x7ea7  级
  167,126,18,19,95,19,0,254,0,144,0,0,0,1,224,170,170,0,2,193,255,255,0,3,128,29,14,0,11,8,29,29,0,14,29,44,44,0,45,124,44,60,0,127,244,44,63,208,38,224,61,42,208,3,192,63,2,192,11,173,63,3,128,47,252,123,199,64,63,64,177,223,0,16,4,240,253,0,0,190,224,188,0,31,246,209,255,0,62,67,203,203,208,16,11,111,2,240,0,1,8,0,16,
  // 0x7ebf  线
  191,126,17,19,95,19,1,254,1,0,10,0,0,3,192,14,120,0,7,128,15,30,0,15,0,15,5,0,30,16,31,255,0,60,58,255,249,0,121,177,159,0,0,255,224,11,1,64,167,192,11,255,192,11,67,255,249,0,30,3,235,66,64,127,244,3,135,128,255,144,3,223,0,80,0,2,252,0,0,100,2,240,0,27,244,31,240,192,254,66,253,181,192,80,7,224,63,192,0,1,0,10,0,
  // 0x7ec6  细
  198,126,17,19,95,19,1,254,1,64,0,0,0,3,194,255,255,128,7,131,255,255,128,15,3,195,131,128,45,3,195,131,128,56,59,195,131,128,250,247,195,131,128,255,227,195,131,128,83,195,235,235,128,15,3,255,255,128,45,87,195,131,128,255,251,195,131,128,254,67,195,131,128,0,3,195,131,128,0,23,195,131,128,107,251,235,235,128,255,147,255,255,128,64,3,192,3,128,0,0,0,0,0,
  // 0x7ec8  终
  200,126,17,19,95,19,1,254,1,0,8,0,0,7,128,45,0,0,11,0,62,169,0,14,0,255,255,0,44,2,244,45,0,56,127,188,124,0,245,246,15,240,0,255,192,11,208,0,71,64,47,248,0,14,2,248,63,64,60,27,208,11,192,255,241,15,64,64,254,80,7,244,0,0,0,0,112,0,0,20,160,0,0,111,248,255,128,0,255,144,11,248,0,64,0,0,126,0,0,0,0,4,0,
  // 0x7ed3  结
  211,126,17,19,95,19,1,254,1,0,2,128,0,7,128,3,192,0,11,64,3,192,0,15,3,255,255,192,45,18,171,234,128,56,120,3,192,0,250,240,3,192,0,255,209,171,234,64,87,130,255,255,128,15,0,0,0,0,61,20,0,0,0,255,248,255,255,0,254,64,250,175,0,0,0,208,11,0,0,20,208,11,0,111,252,208,11,0,255,144,255,255,0,64,0,250,175,0,0,0,144,5,0,
  // 0x7ed9  给
  217,126,17,19,95,19,1,254,1,0,1,0,0,7,128,11,64,0,11,64,15,192,0,15,0,47,208,0,45,0,60,176,0,60,116,240,60,0,180,243,224,31,0,255,223,255,255,192,171,138,106,165,64,15,0,0,0,0,45,17,170,168,0,191,246,255,253,0,254,66,192,29,0,0,2,192,29,0,0,82,192,29,0,111,246,192,29,0,254,66,255,253,0,64,2,234,189,0,0,1,128,24,0,
  // 0x7edf  统
  223,126,17,19,95,19,1,254,2,0,6,0,0,7,192,11,64,0,11,64,3,128,0,15,7,255,255,192,45,18,175,170,128,120,180,61,20,0,250,240,120,60,0,255,208,240,31,0,155,135,255,255,64,15,7,250,151,192,45,96,112,225,0,191,240,176,240,0,254,64,176,240,0,64,0,240,240,0,0,112,224,241,128,31,242,208,241,192,254,71,192,241,192,144,47,0,255,192,0,8,0,25,0,
  // 0x7ee7  继
  231,126,17,18,90,19,1,255,2,0,0,80,0,7,67,64,224,0,15,3,116,227,128,14,3,92,227,0,44,19,76,234,0,56,183,72,232,0,245,227,85,245,64,255,195,191,255,192,71,67,66,240,0,14,3,67,252,0,60,87,74,238,0,191,243,92,231,64,249,67,120,226,128,0,3,96,224,0,0,103,64,224,0,191,247,64,64,0,249,3,255,255,192,0,2,170,170,128,
  // 0x7eea  绪
  234,126,17,19,95,19,1,254,2,0,9,0,0,7,128,14,2,64,11,1,175,167,64,14,3,255,255,0,44,16,14,45,0,56,116,14,120,0,181,246,175,250,128,255,223,255,255,192,151,128,15,64,0,15,0,125,0,0,29,2,255,255,0,127,255,245,95,0,254,69,176,11,0,0,0,191,255,0,0,100,181,91,0,31,244,176,11,0,255,144,181,95,0,144,0,191,255,0,0,0,96,6,0,
  // 0x7eed  续
  237,126,17,19,95,19,1,254,1,0,6,0,0,3,128,7,64,0,11,2,255,255,0,14,1,91,149,0,44,16,7,64,0,56,183,255,255,128,181,210,170,171,64,255,192,146,71,0,155,64,123,139,0,14,3,71,128,0,45,161,211,128,0,127,224,67,128,0,253,15,255,255,128,64,6,175,170,64,2,240,30,96,0,191,144,124,124,0,248,2,240,31,0,64,15,192,3,192,0,5,0,0,64,
  // 0x7eff  绿
  255,126,17,19,95,19,1,254,1,0,0,0,0,11,66,255,255,0,15,1,170,175,0,30,0,0,15,0,44,1,255,255,0,116,240,85,95,0,246,208,0,14,0,255,195,255,255,192,75,66,171,234,128,14,1,67,129,0,60,83,211,135,128,255,224,243,238,0,250,64,27,244,0,0,0,63,244,0,1,162,243,174,0,111,235,131,139,192,253,2,3,129,192,64,0,63,64,0,0,0,21,0,0,
  // 0x7f16  编
  22,127,17,19,95,19,1,254,1,0,2,0,0,7,64,7,128,0,15,1,87,213,0,14,3,255,255,64,44,3,64,3,64,56,243,64,3,64,177,211,255,255,64,255,195,149,85,0,235,71,64,0,0,14,7,255,255,128,44,7,251,123,128,127,215,227,50,128,254,75,227,50,128,64,15,255,255,128,2,238,231,123,128,127,173,227,50,128,248,60,227,50,128,64,56,227,59,128,0,0,80,0,0,
  // 0x7f3a  缺
  58,127,17,19,95,19,1,254,20,0,2,64,0,60,0,3,64,0,56,0,3,64,0,127,254,171,234,0,187,233,255,255,0,227,128,3,75,0,147,128,3,75,0,255,255,3,75,0,171,233,3,75,0,3,128,171,239,128,163,141,255,255,192,179,141,11,208,0,179,141,15,240,0,179,141,14,180,0,187,237,45,60,0,191,253,124,45,0,176,14,240,15,64,96,3,208,7,192,0,1,0,0,64,
  // 0x7f51  网
  81,127,17,18,90,19,1,254,42,170,170,170,64,127,255,255,255,64,116,29,7,7,64,116,28,7,7,64,116,28,11,7,64,118,92,235,7,64,119,252,191,7,64,116,252,47,7,64,116,60,15,71,64,116,63,15,199,64,116,127,94,247,64,116,178,44,167,64,116,240,56,7,64,117,208,180,7,64,119,192,240,7,64,117,64,144,7,64,116,0,0,255,0,36,0,0,169,0,
  // 0x7f6e  置
  110,127,17,18,90,19,1,254,63,255,255,255,0,60,45,30,15,0,60,44,13,15,0,63,255,255,255,0,0,1,224,0,0,191,255,255,255,128,21,86,213,85,0,0,2,192,0,0,44,63,255,252,0,44,57,85,108,0,44,58,170,188,0,44,63,255,252,0,44,52,0,28,0,44,63,255,252,0,44,0,0,0,0,45,85,85,85,64,47,255,255,255,192,24,0,0,0,0,
  // 0x7f72  署
  114,127,17,18,90,19,1,254,63,255,255,255,0,61,109,94,95,0,60,44,13,15,0,63,255,255,255,0,5,87,213,84,0,5,87,213,78,0,15,255,255,253,0,0,3,194,240,0,255,255,255,255,192,85,91,253,85,64,0,127,224,0,0,31,255,255,252,0,255,229,85,108,0,80,255,255,252,0,0,224,0,44,0,0,229,85,108,0,0,255,255,252,0,0,144,0,24,0,
  // 0x8005  者
  5,128,17,19,95,19,1,254,0,6,0,0,0,0,11,0,14,0,10,175,170,125,0,31,255,255,248,0,0,11,2,224,0,0,11,11,192,0,170,175,191,170,128,255,255,255,255,192,0,11,208,0,0,0,127,0,0,0,7,255,255,248,0,191,245,85,184,0,244,224,0,56,0,0,255,255,248,0,0,245,85,120,0,0,224,0,56,0,0,245,85,184,0,0,255,255,248,0,0,144,0,36,0,
  // 0x806a  聪
  106,128,17,19,95,19,1,254,0,0,16,4,0,255,252,116,29,0,186,248,60,60,0,52,176,44,56,0,52,176,105,185,0,57,177,255,255,64,63,241,208,7,64,52,177,208,7,64,52,177,208,7,64,57,177,255,255,64,63,240,170,170,0,52,176,3,64,0,52,180,106,194,0,58,254,168,227,0,255,247,168,3,128,228,179,104,14,192,0,183,44,28,192,0,177,47,252,0,0,96,5,80,0,
  // 0x80fd  能
  253,128,18,19,95,19,1,254,6,0,24,0,0,11,0,44,0,0,15,45,44,31,0,29,15,46,253,0,191,255,111,128,0,254,171,236,1,64,0,1,44,2,192,21,85,31,171,192,63,255,15,255,64,56,15,24,0,0,57,95,44,1,0,63,255,44,31,0,56,15,46,253,0,57,95,47,144,0,63,255,44,0,64,56,15,44,1,208,56,15,45,2,192,56,254,31,255,192,36,100,6,169,0,
  // 0x81ea  自
  234,129,13,19,76,19,3,254,0,24,0,0,0,60,0,0,0,60,0,0,255,255,255,192,250,170,171,192,240,0,2,192,240,0,2,192,250,170,171,192,255,255,255,192,240,0,2,192,240,0,2,192,250,170,171,192,255,255,255,192,240,0,2,192,240,0,2,192,240,0,2,192,255,255,255,192,250,170,171,192,160,0,1,128,
  // 0x81f3  至
  243,129,17,17,85,19,1,255,106,170,170,170,64,127,255,255,255,128,0,61,1,0,0,0,60,11,192,0,0,180,2,240,0,0,245,86,252,0,63,255,255,255,0,58,149,64,11,64,0,1,208,1,0,0,1,208,0,0,10,171,234,168,0,15,255,255,253,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,170,171,234,170,128,255,255,255,255,192,
  // 0x83dc  菜
  220,131,17,19,95,19,1,254,0,96,2,64,0,106,250,171,234,64,255,255,255,255,192,0,176,3,128,0,0,96,6,248,0,42,191,255,253,0,63,254,165,64,0,4,2,128,30,0,14,3,192,60,0,11,65,208,120,0,3,65,128,176,0,0,1,208,0,0,255,255,255,255,192,106,175,254,170,128,0,126,239,0,0,7,241,211,228,0,191,129,208,191,128,248,1,208,11,128,0,1,144,0,0,
  // 0x84dd  蓝
  221,132,17,18,90,19,1,255,0,96,2,64,0,85,249,91,213,64,255,255,255,255,192,0,176,3,128,0,0,0,9,0,0,4,56,45,0,0,44,56,63,255,0,44,56,57,149,0,44,56,241,208,0,44,57,224,240,0,44,56,64,120,0,0,20,0,32,0,15,255,255,252,0,15,94,109,108,0,14,13,28,44,0,14,13,28,44,0,175,174,174,190,128,255,255,255,255,192,
  // 0x86c7  蛇
  199,134,17,18,90,19,1,255,1,0,2,128,0,3,64,2,192,0,3,64,2,192,0,3,66,255,255,192,191,254,234,171,192,183,174,192,2,192,163,30,228,2,192,163,28,56,0,0,163,28,56,14,0,183,172,56,190,0,191,252,63,224,0,163,64,61,0,0,3,88,56,0,0,3,92,56,0,0,3,93,56,1,192,175,254,56,2,192,254,155,62,171,128,0,4,31,255,0,
  // 0x884c  行
  76,136,18,19,95,19,0,254,0,32,0,0,0,0,240,106,170,144,3,208,191,255,224,31,64,0,0,0,61,0,0,0,0,36,60,0,0,0,0,184,0,0,0,1,241,255,255,240,7,209,170,191,160,31,208,0,29,0,127,208,0,29,0,53,208,0,29,0,1,208,0,29,0,1,208,0,29,0,1,208,0,29,0,1,208,0,29,0,1,208,0,29,0,1,208,11,252,0,1,208,2,164,0,
  // 0x88ab  被
  171,136,18,19,95,19,0,254,1,128,0,96,0,2,192,0,176,0,2,192,0,176,0,2,192,106,250,160,63,253,191,255,240,42,188,176,176,224,0,56,176,176,208,0,240,176,176,64,2,235,191,255,208,7,252,191,171,192,31,252,255,3,192,127,221,231,71,64,50,200,227,207,0,2,192,209,253,0,2,193,208,252,0,2,195,194,254,0,2,199,159,223,208,2,203,62,3,240,1,129,20,0,80,
  // 0x88c5  装
  197,136,17,19,95,19,1,254,0,224,3,64,0,112,224,3,128,0,124,224,3,128,0,12,235,255,255,192,0,230,171,234,128,1,224,3,128,0,47,224,3,128,0,253,226,171,234,0,144,227,255,255,64,0,224,64,0,0,0,1,208,0,0,255,255,255,255,192,85,127,185,89,64,1,248,60,46,0,191,240,31,244,0,164,240,7,208,0,0,251,241,249,0,15,255,144,47,192,5,0,0,1,64,
  // 0x8981  要
  129,137,17,18,90,19,1,254,191,255,255,255,128,106,190,174,170,64,0,44,29,0,0,63,255,255,255,0,61,125,110,95,0,60,44,29,15,0,60,44,29,15,0,63,255,255,255,0,21,95,85,85,0,0,45,0,0,0,255,255,255,255,192,85,245,87,229,64,2,224,7,192,0,7,254,95,0,0,2,111,254,0,0,1,111,239,248,0,191,249,0,191,0,21,0,0,5,0,
  // 0x89d2  角
  210,137,16,19,76,19,1,254,0,36,0,0,0,125,85,0,0,255,255,0,3,208,30,0,11,128,60,0,47,255,255,254,191,170,250,174,39,64,240,14,7,64,240,14,7,255,255,254,7,170,250,174,7,0,240,14,11,0,240,14,11,255,255,254,15,170,170,174,45,0,0,14,124,0,0,14,240,0,15,253,64,0,6,164,
  // 0x8ba1  计
  161,139,17,19,95,19,1,254,0,0,2,64,0,14,0,7,128,0,15,128,7,128,0,3,208,7,128,0,0,192,7,128,0,0,0,7,128,0,170,64,7,128,0,255,143,255,255,192,3,143,255,255,192,3,128,7,128,0,3,128,7,128,0,3,128,7,128,0,3,128,7,128,0,3,140,7,128,0,3,252,7,128,0,7,240,7,128,0,15,192,7,128,0,10,0,7,128,0,0,0,2,64,0,
  // 0x8bae  议
  174,139,17,18,90,19,1,254,44,0,44,1,0,31,15,14,11,0,11,75,15,15,0,2,11,71,78,0,0,7,128,29,0,170,3,128,44,0,255,2,192,60,0,11,1,208,56,0,11,0,240,180,0,11,0,180,240,0,11,0,62,208,0,11,0,47,192,0,11,20,15,128,0,11,184,63,208,0,15,225,249,248,0,15,75,208,127,64,13,63,64,11,192,0,24,0,1,64,
  // 0x8bbe  设
  190,139,17,18,90,19,1,254,29,0,255,244,0,15,64,250,180,0,3,192,240,52,0,1,128,224,52,0,0,1,208,52,0,170,7,192,61,64,255,31,64,47,192,11,4,0,0,0,11,11,255,255,0,11,7,234,174,0,11,2,192,44,0,11,0,224,60,0,11,32,184,240,0,11,244,47,192,0,15,208,47,208,0,31,70,254,253,0,12,31,208,47,192,0,8,0,1,64,
  // 0x8bd5  试
  213,139,18,19,95,19,1,254,4,0,1,212,0,45,0,1,223,0,15,64,1,211,128,3,192,1,210,64,1,74,171,250,128,0,31,255,255,192,85,0,0,224,0,255,0,0,224,0,11,0,0,224,0,11,15,253,240,0,11,6,248,240,0,11,0,224,240,0,11,0,224,176,0,11,0,224,180,64,11,116,230,116,208,11,250,255,61,192,15,143,224,47,192,13,4,0,15,64,0,0,0,1,0,
  // 0x8bef  误
  239,139,17,18,90,19,1,254,24,2,170,170,0,46,3,255,255,0,11,131,128,11,0,2,67,128,11,0,0,3,255,255,0,170,2,170,170,0,255,0,0,0,0,11,6,170,170,64,11,7,255,255,64,11,0,7,0,0,11,0,11,0,0,11,15,255,255,192,11,10,175,234,128,11,112,31,192,0,11,240,124,240,0,15,130,240,62,0,13,31,192,15,192,0,9,0,1,64,
  // 0x8bf7  请
  247,139,17,19,95,19,1,254,0,0,6,0,0,60,1,91,85,0,31,11,255,255,128,7,128,11,0,0,1,7,255,255,0,0,0,11,64,0,170,5,91,85,64,255,31,255,255,192,11,0,0,0,0,11,3,255,255,0,11,3,213,95,0,11,3,128,15,0,11,3,255,255,0,11,19,128,15,0,11,119,128,15,0,11,243,255,255,0,15,131,128,15,0,13,3,128,254,0,0,2,64,84,0,
  // 0x8bfb  读
  251,139,17,19,95,19,1,254,0,0,6,0,0,44,0,11,0,0,31,7,255,255,0,7,193,95,149,0,1,0,11,0,0,0,15,255,255,128,170,10,170,171,64,255,1,131,71,0,11,0,247,139,0,11,14,43,128,0,11,7,195,128,0,11,0,199,64,0,11,31,255,255,192,11,42,175,170,64,11,240,45,160,0,11,208,188,188,0,15,71,240,31,0,28,31,128,3,192,0,8,0,0,64,
  // 0x8c03  调
  3,140,17,18,90,19,1,254,60,15,255,255,64,31,15,170,171,64,7,143,7,3,64,1,15,27,83,64,0,15,63,243,64,0,15,7,3,64,255,15,7,3,64,175,15,191,247,64,11,15,21,83,64,11,14,21,67,64,11,14,127,243,64,11,14,112,179,64,11,29,112,179,64,11,252,127,243,64,15,252,117,67,64,31,56,16,3,64,28,112,0,63,64,0,16,0,41,0,
  // 0x8d25  败
  37,141,17,18,90,19,1,254,42,169,11,0,0,127,254,15,0,0,112,14,14,0,0,113,142,31,255,192,114,206,46,175,128,114,206,56,14,0,114,206,184,13,0,114,206,252,29,0,114,206,172,28,0,114,206,14,60,0,114,206,11,52,0,115,142,3,240,0,19,68,2,224,0,11,112,2,240,0,14,60,11,252,0,60,14,46,31,64,244,10,184,7,192,64,0,16,0,64,
  // 0x8d2a  贪
  42,141,17,19,95,19,1,254,0,0,144,0,0,0,7,244,0,0,0,111,126,64,0,11,245,135,249,0,255,129,224,127,192,105,85,245,81,64,7,255,255,240,0,0,0,3,208,0,0,0,11,64,0,11,255,255,248,0,11,170,170,184,0,11,1,208,56,0,11,2,208,56,0,11,2,192,56,0,11,3,192,52,0,0,31,127,128,0,2,253,7,249,0,63,208,0,47,0,24,0,0,1,0,
  // 0x8d77  起
  119,141,18,19,95,19,0,254,0,96,0,0,0,0,176,15,255,192,26,250,134,171,192,47,255,192,2,192,0,176,0,2,192,0,176,0,2,192,42,250,145,86,192,63,255,235,255,192,0,52,11,1,128,8,52,11,0,0,29,62,139,0,0,29,63,219,0,112,30,52,11,0,112,31,52,11,170,240,47,244,3,255,208,61,248,0,0,0,56,191,234,170,160,116,11,255,255,240,16,0,0,0,0,
  // 0x8d85  超
  133,141,18,19,95,19,0,254,0,96,0,0,0,0,176,47,255,224,26,250,90,234,224,47,255,194,192,224,0,176,3,192,208,0,176,7,129,208,42,250,159,23,192,63,255,253,47,128,0,112,20,0,0,4,112,15,255,192,29,112,15,87,192,28,127,206,2,192,29,122,142,2,192,30,112,14,86,192,47,176,15,255,192,63,244,0,0,0,56,255,234,170,160,112,27,255,255,240,16,0,0,0,0,
  // 0x8ddd  距
  221,141,18,18,90,19,0,254,31,255,47,255,240,30,175,46,170,160,28,11,44,0,0,28,11,44,0,0,28,11,44,0,0,31,255,47,255,192,10,250,46,171,192,0,176,44,1,192,28,176,44,1,192,28,191,108,1,192,28,186,46,171,192,28,176,47,255,192,28,176,44,0,0,28,182,108,0,0,30,255,172,0,0,127,228,47,255,240,36,0,46,170,160,0,0,24,0,0,
  // 0x8f6c  转
  108,143,17,19,95,19,1,254,2,0,1,128,0,7,64,2,192,0,175,168,171,234,64,255,252,255,255,64,13,0,7,64,0,28,0,11,0,0,45,194,175,170,128,53,195,255,255,192,113,192,29,0,0,255,252,60,0,0,107,232,63,255,64,1,192,42,191,0,1,233,0,61,0,107,254,20,184,0,255,228,63,240,0,65,192,11,208,0,1,192,1,248,0,1,192,0,60,0,1,128,0,4,0,
  // 0x8f6f  软
  111,143,17,19,95,19,1,254,1,64,9,0,0,3,192,14,0,0,171,234,29,0,0,255,255,46,170,128,15,0,63,255,192,14,0,56,3,192,29,240,116,3,128,44,240,242,195,64,56,240,226,199,0,191,255,2,192,0,106,250,3,192,0,0,240,3,208,0,0,245,3,240,0,107,255,11,240,0,255,245,15,56,0,80,240,45,45,0,0,240,184,15,64,0,241,240,7,192,0,160,64,0,64,
  // 0x8f74  轴
  116,143,17,19,95,19,1,254,6,0,1,128,0,11,0,2,192,0,175,168,2,192,0,255,252,2,192,0,13,0,171,234,64,29,65,255,255,128,45,209,210,195,128,57,209,210,195,128,117,209,210,195,128,255,253,210,195,128,106,233,255,255,128,1,209,235,235,128,1,233,210,195,128,107,253,210,195,128,255,225,210,195,128,65,209,210,195,128,1,209,255,255,128,1,209,234,171,128,0,128,128,2,64,
  // 0x8f7d  载
  125,143,17,19,95,19,1,254,0,96,7,0,0,0,176,11,44,0,63,255,219,31,0,21,245,75,7,0,85,245,91,149,64,255,255,255,255,192,2,192,7,64,0,3,192,7,70,0,191,255,243,79,0,95,85,83,142,0,29,60,3,173,0,61,125,83,252,0,63,255,226,244,0,0,60,2,240,0,0,62,162,224,192,111,255,247,240,192,190,188,31,185,192,0,60,61,63,128,0,40,36,10,0,
  // 0x8f91  辑
  145,143,17,19,95,19,1,254,6,0,0,0,0,11,0,255,255,0,175,168,229,95,0,255,252,224,15,0,29,0,255,255,0,28,0,85,85,0,45,193,85,85,64,57,195,255,255,192,113,192,240,15,0,255,248,255,255,0,107,228,245,95,0,1,192,240,15,0,2,212,255,255,0,191,252,245,95,0,255,208,240,15,64,81,194,251,255,192,1,199,254,175,0,1,192,0,15,0,1,128,0,10,0,
  // 0x8f93  输
  147,143,17,19,95,19,1,254,9,0,2,64,0,13,0,11,128,0,174,160,47,224,0,255,240,184,124,0,44,7,224,31,128,56,15,255,255,192,55,128,85,84,0,115,129,85,2,64,179,131,255,51,128,255,243,11,51,128,171,227,91,51,128,3,131,255,51,128,3,227,11,51,128,255,227,255,51,128,231,131,91,51,128,3,131,11,19,128,3,131,11,3,128,3,131,63,63,64,2,65,4,4,0,
  // 0x8fb9  边
  185,143,18,19,95,19,0,254,0,0,1,0,0,14,0,11,0,0,11,128,11,0,0,3,208,15,0,0,0,215,255,255,208,0,6,175,171,208,0,0,15,1,208,63,192,14,1,208,43,192,29,1,208,3,192,44,2,208,3,192,60,2,192,3,192,244,3,192,3,194,224,3,192,3,203,192,175,128,3,199,0,255,0,15,240,0,0,0,62,190,64,0,96,120,31,255,255,240,32,1,170,170,160,
  // 0x8fc1  迁
  193,143,17,19,95,19,1,254,0,0,0,4,0,61,0,22,254,0,15,159,255,228,0,3,74,94,0,0,16,0,14,0,0,188,0,14,0,0,47,0,14,0,0,6,63,255,255,192,0,42,175,170,128,170,0,14,0,0,255,0,14,0,0,11,0,14,0,0,11,0,14,0,0,11,0,14,0,0,11,64,14,0,0,63,224,9,0,0,248,255,170,170,192,208,27,255,255,192,0,0,0,0,0,
  // 0x8fd0  运
  208,143,17,18,90,19,1,254,61,6,170,170,0,15,139,255,255,0,3,64,0,0,0,16,0,0,0,0,184,0,0,0,0,47,63,255,255,192,6,42,254,170,128,0,0,180,16,0,170,0,240,116,0,255,0,224,60,0,11,2,192,30,0,11,3,214,175,0,11,47,255,255,128,15,26,149,3,192,47,208,0,0,0,248,255,170,170,128,208,31,255,255,192,0,0,0,0,0,
  // 0x8fd1  近
  209,143,17,19,95,19,1,254,0,0,0,4,0,116,0,26,254,0,125,3,255,224,0,15,67,144,0,0,3,3,128,0,0,0,3,128,0,0,0,3,255,255,192,0,7,234,250,128,170,7,64,224,0,255,7,0,224,0,11,11,0,224,0,11,15,0,224,0,11,45,0,224,0,11,124,0,224,0,15,96,0,224,0,63,208,0,80,0,248,255,170,170,192,208,27,255,255,192,0,0,0,0,0,
  // 0x8fd4  返
  212,143,17,18,90,19,1,254,112,6,170,170,64,124,11,255,255,64,31,11,0,0,0,7,11,0,0,0,0,15,170,169,0,0,15,255,254,0,0,15,176,29,0,255,15,56,60,0,175,14,60,120,0,15,14,15,240,0,15,29,11,208,0,15,60,31,240,0,15,121,189,190,64,15,114,240,31,192,127,208,64,1,0,244,255,170,170,192,208,31,255,255,192,0,0,0,0,0,
  // 0x8fd8  还
  216,143,18,18,90,19,0,254,14,0,0,0,0,15,75,255,255,224,3,218,171,250,144,0,208,3,192,0,0,0,7,128,0,0,0,31,128,0,63,192,63,188,0,43,192,251,175,0,3,195,227,139,192,3,223,131,130,224,3,206,3,128,208,3,192,3,128,0,3,192,3,128,0,3,192,3,128,0,11,224,3,128,0,63,254,0,0,16,124,31,255,255,240,32,1,170,170,160,
  // 0x8fdb  进
  219,143,17,18,90,19,1,254,52,0,240,176,0,61,0,240,176,0,15,0,240,176,0,3,47,255,255,128,0,26,250,254,64,0,0,240,176,0,170,0,240,176,0,255,0,224,176,0,11,47,255,255,192,11,27,250,254,128,11,2,208,176,0,11,3,192,176,0,11,11,128,176,0,15,79,0,176,0,63,228,0,16,0,244,191,170,175,192,144,11,255,255,128,0,0,0,0,0,
  // 0x8fde  连
  222,143,17,19,95,19,1,254,0,0,16,0,0,56,0,180,0,0,45,26,250,170,64,15,63,255,255,128,7,2,192,0,0,0,3,135,128,0,0,11,7,128,0,255,31,255,255,0,175,14,175,234,0,15,0,7,128,0,15,0,7,128,0,15,63,255,255,192,15,42,175,234,128,15,0,7,128,0,15,0,7,128,0,63,128,7,128,0,250,244,1,65,64,240,127,255,255,192,128,6,170,170,128,
  // 0x8ff7  迷
  247,143,17,19,95,19,1,254,0,0,5,0,0,116,8,14,6,0,61,14,14,15,0,15,75,14,29,0,2,7,142,60,0,0,1,14,20,0,0,42,175,170,128,0,63,255,255,192,255,0,127,192,0,175,0,255,224,0,11,2,222,180,0,11,11,142,61,0,11,47,14,15,128,11,124,14,7,128,15,64,14,0,0,127,224,9,0,0,248,255,170,170,192,208,27,255,255,192,0,0,0,0,0,
  // 0x9000  退
  0,144,17,18,90,19,1,254,116,7,255,253,0,62,7,170,173,0,15,71,64,29,0,2,7,255,253,0,0,7,149,109,0,0,7,64,29,0,0,7,255,253,0,255,7,175,170,0,175,7,71,79,64,11,7,67,253,0,11,7,65,240,0,11,7,90,248,0,11,31,254,63,64,15,111,144,11,128,127,224,0,0,0,248,255,170,170,192,208,27,255,255,192,0,0,0,0,0,
  // 0x9009  选
  9,144,17,19,95,19,1,254,0,0,6,0,0,112,3,139,0,0,124,7,139,0,0,31,11,255,255,0,11,31,175,170,0,0,60,11,0,0,0,4,11,0,0,0,26,175,170,128,255,63,255,255,192,175,0,240,208,0,11,0,240,208,0,11,1,208,208,64,11,7,192,225,192,11,47,0,251,192,11,124,0,191,128,47,208,0,0,0,188,185,0,1,64,240,47,255,255,192,80,1,170,170,64,
  // 0x901f  速
  31,144,17,19,95,19,1,254,0,0,9,0,0,112,0,14,0,0,125,21,95,85,64,31,63,255,255,192,2,0,14,0,0,0,15,255,255,0,0,14,95,91,0,0,13,14,11,0,255,13,14,11,0,175,15,255,255,0,11,5,191,213,0,11,0,255,224,0,11,3,206,120,0,11,47,14,31,128,15,120,14,7,64,127,224,9,0,0,248,255,170,170,192,208,27,255,255,192,0,0,0,0,0,
  // 0x90e8  部
  232,144,17,19,95,19,1,254,0,144,0,0,0,0,224,10,170,64,106,250,143,255,192,191,255,223,3,128,8,6,15,11,64,29,11,15,15,0,14,14,15,29,0,9,13,15,44,0,255,255,239,44,0,170,170,159,15,0,0,0,15,7,64,63,255,143,3,192,62,171,143,3,192,56,3,143,3,192,56,3,143,47,128,56,3,143,62,0,63,255,143,0,0,62,171,143,0,0,36,2,70,0,0,
  // 0x914d  配
  77,145,17,18,90,19,1,254,255,255,154,170,64,171,186,111,255,128,7,48,0,3,128,91,185,0,3,128,191,255,0,3,128,179,103,0,3,128,179,103,26,171,128,179,103,47,255,128,182,103,44,3,128,189,63,44,1,0,180,7,44,0,0,181,87,44,0,0,191,255,44,0,0,176,7,44,1,192,176,7,44,1,192,191,255,45,2,192,181,91,31,255,192,96,1,6,170,0,
  // 0x91ca  释
  202,145,17,18,90,19,1,254,107,252,170,170,64,255,208,255,255,128,3,68,56,15,0,163,92,29,61,0,119,120,11,240,0,39,160,11,244,0,91,148,189,127,128,255,255,224,11,192,11,192,3,192,0,15,240,171,234,0,47,188,255,255,0,119,92,3,192,0,243,64,3,192,0,211,67,255,255,192,67,65,171,234,128,3,64,3,192,0,3,64,3,192,0,2,64,2,128,0,
  // 0x91cd  重
  205,145,17,18,90,19,1,255,0,0,0,80,0,5,170,255,252,0,15,255,233,64,0,0,1,208,0,0,255,255,255,255,192,85,86,229,85,64,15,255,255,252,0,15,2,208,60,0,15,2,208,44,0,15,255,255,252,0,15,1,208,44,0,15,255,255,252,0,0,2,208,0,0,5,86,229,85,0,47,255,255,255,0,0,1,208,0,0,85,86,229,85,64,255,255,255,255,192,
  // 0x91cf  量
  207,145,17,17,85,19,1,255,11,255,255,248,0,11,0,0,56,0,11,255,255,248,0,11,0,0,56,0,11,255,255,248,0,85,85,85,85,64,255,255,255,255,192,0,0,0,0,0,15,255,255,252,0,14,1,208,44,0,15,255,255,252,0,14,1,208,44,0,15,255,255,252,0,0,2,208,0,0,31,255,255,253,0,85,86,229,85,64,255,255,255,255,192,
  // 0x9488  针
  136,148,17,19,95,19,1,254,5,0,1,128,0,14,0,2,192,0,47,168,2,192,0,127,252,2,192,0,240,0,2,192,0,208,0,2,192,0,127,248,2,192,0,63,247,255,255,192,3,130,171,250,128,3,128,2,192,0,255,252,2,192,0,107,232,2,192,0,3,128,2,192,0,3,128,2,192,0,3,132,2,192,0,3,253,2,192,0,11,244,2,192,0,15,128,2,192,0,0,0,1,128,0,
  // 0x94ae  钮
  174,148,18,19,95,19,0,254,1,0,0,0,0,11,64,106,170,128,15,85,255,255,208,31,254,3,193,208,60,0,3,193,192,116,0,3,194,192,47,253,3,130,192,10,232,3,130,192,1,192,191,255,192,1,192,191,255,192,63,255,11,3,192,42,233,11,3,128,1,192,15,3,128,1,192,15,3,128,1,217,14,7,64,1,254,14,7,64,3,246,191,175,224,3,131,255,255,240,0,0,0,0,0,
  // 0x9519  错
  25,149,17,19,95,19,1,254,9,0,36,36,0,14,0,56,56,0,46,164,56,56,0,63,250,255,255,128,240,1,190,190,64,208,0,56,56,0,127,244,56,56,0,43,167,255,255,192,7,66,170,170,128,7,64,0,0,0,255,252,255,255,0,107,164,245,95,0,7,64,224,11,0,7,64,255,255,0,7,84,245,95,0,7,248,224,11,0,15,224,245,95,0,15,0,255,255,0,0,0,144,6,0,
  // 0x955c  镜
  92,149,17,19,95,19,1,254,4,0,2,64,0,14,0,87,213,64,46,162,255,255,128,127,244,36,24,0,240,0,44,60,0,208,3,255,255,192,127,241,85,85,64,47,160,0,0,0,7,0,255,255,64,7,0,208,7,64,255,248,255,255,64,175,164,208,7,64,7,0,255,255,64,7,0,44,180,0,7,104,60,112,0,11,248,56,112,192,15,209,240,112,192,14,15,192,127,192,0,5,0,5,0,
  // 0x957f  长
  127,149,17,19,95,19,1,254,1,128,0,0,0,1,208,0,120,0,1,208,1,244,0,1,208,11,208,0,1,208,191,0,0,1,211,244,0,0,1,210,128,0,0,1,208,0,0,0,255,255,255,255,192,171,250,254,170,128,1,208,180,0,0,1,208,60,0,0,1,208,46,0,0,1,208,15,64,0,1,208,3,224,0,1,230,240,253,0,3,255,224,63,192,3,244,0,7,64,1,0,0,0,0,
  // 0x95ed  闭
  237,149,17,19,95,19,1,254,4,0,0,0,0,61,10,170,170,64,15,31,255,255,64,7,64,0,7,64,0,0,29,7,64,116,0,29,7,64,116,0,29,7,64,117,255,255,231,64,117,170,255,167,64,116,0,253,7,64,116,3,237,7,64,116,15,93,7,64,116,125,29,7,64,118,244,29,7,64,118,192,29,7,64,116,2,188,7,64,116,3,248,7,64,116,0,0,127,64,100,0,0,41,0,
  // 0x95f2  闲
  242,149,17,18,90,19,1,254,29,10,170,170,64,15,15,255,255,64,3,192,0,7,64,1,128,64,7,64,112,1,208,7,64,112,1,208,7,64,113,255,255,231,64,112,91,249,87,64,112,11,248,7,64,112,15,254,7,64,112,61,223,71,64,112,181,211,199,64,114,225,209,215,64,113,129,208,71,64,112,1,208,7,64,112,1,208,7,64,112,0,1,255,0,112,0,0,169,0,
  // 0x95f4  间
  244,149,17,18,90,19,1,254,61,26,170,170,64,15,31,255,255,64,7,64,0,7,64,0,0,0,7,64,116,0,0,7,64,116,63,255,7,64,116,57,91,7,64,116,52,7,7,64,116,52,7,7,64,116,63,255,7,64,116,57,91,7,64,116,52,7,7,64,116,57,91,7,64,116,63,255,7,64,116,0,0,7,64,116,0,0,7,64,116,0,0,63,64,36,0,0,41,0,
  // 0x9608  阈
  8,150,17,19,95,19,1,254,4,0,0,0,0,31,15,255,255,64,11,138,170,175,64,3,208,16,7,64,116,64,55,71,64,116,0,49,135,64,118,255,255,231,64,117,85,121,87,64,116,0,52,135,64,116,255,57,199,64,116,195,43,135,64,116,255,47,71,64,116,0,31,7,64,116,107,157,55,64,119,254,127,119,64,117,0,247,231,64,116,1,193,135,64,116,0,1,255,0,100,0,0,164,0,
  // 0x964d  降
  77,150,17,19,95,19,1,254,0,0,9,0,0,127,240,45,0,0,122,240,127,254,0,112,225,245,125,0,113,199,252,124,0,114,202,30,240,0,115,64,15,208,0,115,192,127,253,0,112,219,244,111,192,112,230,64,225,64,112,179,255,255,64,112,241,246,245,0,118,224,224,224,0,119,192,224,224,0,112,15,255,255,192,112,10,170,250,128,112,0,0,224,0,112,0,0,224,0,96,0,0,144,0,
  // 0x9650  限
  80,150,17,18,90,19,1,254,127,242,255,255,0,122,246,234,175,0,112,178,192,11,0,112,226,192,11,0,113,210,255,255,0,114,194,229,95,0,115,194,192,11,0,112,226,234,175,0,112,178,255,255,0,112,114,195,129,0,112,118,194,203,128,118,242,193,238,0,119,210,192,244,0,112,2,192,180,0,112,2,214,125,0,112,27,255,95,128,112,31,228,7,192,96,0,0,0,0,
  // 0x9664  除
  100,150,17,19,95,19,1,254,0,0,10,0,0,127,240,31,192,0,122,240,60,240,0,112,224,240,120,0,113,195,208,47,0,114,223,64,11,192,115,158,255,253,192,115,128,95,148,0,113,192,11,0,0,112,224,11,0,0,112,247,255,255,64,112,182,175,170,0,118,241,75,4,0,119,195,139,29,0,112,11,75,15,0,112,15,11,7,128,112,44,11,3,192,112,0,127,0,0,96,0,40,0,0,
  // 0x9669  险
  105,150,18,19,95,19,1,254,0,0,6,0,0,127,240,15,64,0,122,240,31,192,0,112,224,56,240,0,113,192,240,60,0,114,195,192,31,64,115,143,213,91,208,115,157,255,248,192,113,208,0,0,0,112,224,1,1,0,112,179,135,7,64,112,178,195,79,0,118,225,195,77,0,119,192,211,172,0,112,0,128,52,0,112,0,0,112,0,112,15,255,255,192,112,10,170,170,128,32,0,0,0,0,
  // 0x96f6  零
  246,150,17,18,90,19,1,254,31,255,255,253,0,5,86,229,84,0,191,255,255,255,128,176,2,208,3,128,177,85,213,83,128,176,1,208,3,128,11,253,223,248,0,0,7,224,0,0,0,47,125,0,0,2,248,11,224,0,127,191,255,191,128,244,0,0,11,192,0,0,0,0,0,15,255,255,244,0,0,11,0,116,0,0,11,1,180,0,0,11,3,240,0,0,11,0,0,0,
  // 0x9700  需
  0,151,17,18,90,19,1,254,31,255,255,253,0,5,86,229,84,0,0,2,208,0,0,191,255,255,255,128,176,1,208,3,128,179,253,223,243,128,96,1,208,2,64,11,253,223,248,0,0,0,0,0,0,191,255,255,255,192,85,87,213,85,64,5,87,213,85,0,31,255,255,254,0,29,13,13,14,0,29,13,13,14,0,29,13,13,14,0,29,13,13,190,0,4,4,4,20,0,
  // 0x9752  青
  82,151,17,19,95,19,1,254,0,1,128,0,0,5,86,229,85,0,47,255,255,255,0,0,1,208,0,0,15,255,255,252,0,5,86,229,84,0,85,86,229,85,64,255,255,255,255,192,0,0,0,0,0,7,255,255,244,0,7,149,85,180,0,7,128,0,180,0,7,255,255,244,0,7,64,0,116,0,7,255,255,244,0,7,128,0,180,0,7,64,0,116,0,7,64,15,240,0,1,0,5,64,0,
  // 0x975e  非
  94,151,17,19,95,19,1,254,0,24,9,0,0,0,44,14,0,0,0,44,14,0,0,106,188,15,170,128,191,252,15,255,192,0,44,14,0,0,0,44,14,0,0,0,44,14,0,0,127,252,15,255,64,42,188,15,170,64,0,60,14,0,0,0,61,14,0,0,107,255,79,170,128,255,248,15,255,192,64,240,14,0,0,3,208,14,0,0,15,128,14,0,0,126,0,14,0,0,36,0,9,0,0,
  // 0x9760  靠
  96,151,17,19,95,19,1,254,1,0,128,0,0,3,129,208,0,0,15,255,255,253,0,46,2,208,0,0,191,255,255,255,128,0,1,128,0,0,15,255,255,252,0,15,0,0,44,0,15,0,0,44,0,15,255,255,252,0,0,44,14,0,0,191,252,15,255,128,0,44,14,0,0,63,252,15,255,0,0,44,14,0,0,255,252,15,255,192,65,244,14,0,0,31,208,14,0,0,9,0,9,0,0,
  // 0x9762  面
  98,151,17,18,90,19,1,254,170,170,170,170,128,255,255,255,255,192,0,3,192,0,0,0,3,192,0,0,42,171,234,170,0,63,255,255,255,0,56,56,14,15,0,56,56,14,15,0,56,63,254,15,0,56,61,94,15,0,56,56,14,15,0,56,61,94,15,0,56,63,254,15,0,56,56,14,15,0,56,56,14,15,0,63,255,255,255,0,62,170,170,175,0,36,0,0,10,0,
  // 0x9875  页
  117,152,17,18,90,19,1,254,106,170,170,170,64,191,255,255,255,128,0,3,192,0,0,0,3,128,0,0,10,175,234,168,0,15,255,255,252,0,15,0,0,60,0,15,1,208,60,0,15,1,208,60,0,15,1,208,60,0,15,1,208,60,0,15,2,208,60,0,15,3,192,60,0,5,11,158,20,0,0,47,11,224,0,7,248,0,190,0,191,144,0,31,128,36,0,0,2,0,
  // 0x9879  项
  121,152,18,18,90,19,0,254,0,2,255,255,240,0,2,255,234,160,63,252,3,192,0,3,192,171,234,128,3,192,255,255,192,3,192,224,3,192,3,192,225,211,192,3,192,225,211,192,3,192,225,211,192,3,192,225,211,192,3,220,225,211,192,11,253,226,195,192,127,144,227,194,192,52,0,7,152,0,0,0,31,47,0,0,1,252,7,208,0,15,224,0,240,0,1,0,0,0,
  // 0x9884  预
  132,152,18,18,90,19,0,254,26,169,127,255,240,63,255,106,254,160,0,45,0,176,0,13,180,26,250,144,11,224,47,255,208,1,244,44,1,208,42,190,108,113,208,127,255,172,113,208,1,211,108,113,208,1,215,44,113,208,1,218,44,113,208,1,208,44,177,208,1,208,44,241,208,1,208,1,228,0,1,208,3,207,0,1,208,31,71,208,47,192,252,0,240,10,64,80,0,16,
  // 0x9891  频
  145,152,17,19,95,19,1,254,0,144,0,0,0,0,224,42,170,128,52,229,127,255,192,52,255,0,224,0,52,224,0,208,0,52,224,63,255,128,190,250,125,87,128,255,255,184,147,128,1,192,56,227,128,37,194,56,227,128,53,199,56,227,128,113,203,56,211,128,225,222,56,211,128,129,252,57,195,128,0,180,18,209,0,2,224,3,188,0,31,128,31,15,0,253,0,252,3,192,80,0,144,0,64,
  // 0x989d  额
  157,152,17,19,95,19,1,254,0,64,0,0,0,3,192,42,170,128,86,229,127,255,192,255,255,64,208,0,226,3,65,192,0,95,86,63,255,64,47,254,57,87,64,184,45,52,83,64,235,184,52,227,64,11,240,52,211,64,31,253,52,211,64,253,31,116,211,64,181,86,53,195,64,47,253,54,195,64,44,13,23,129,0,44,13,11,110,0,45,93,126,11,192,47,254,244,1,192,24,0,0,0,0,
  // 0x98ce  风
  206,152,18,18,90,19,1,254,10,170,170,168,0,15,255,255,252,0,15,0,0,60,0,15,0,9,60,0,15,52,14,60,0,15,60,44,60,0,15,31,56,60,0,14,11,244,60,0,14,2,240,60,0,14,2,240,60,0,29,7,252,60,0,29,15,45,44,0,44,61,15,44,0,60,244,7,156,144,120,144,1,29,208,240,0,0,15,192,160,0,0,7,128,0,0,0,0,0,
  // 0x9971  饱
  113,153,18,19,95,19,0,254,1,0,8,0,0,7,64,29,0,0,11,0,62,170,128,15,84,127,255,192,15,253,240,1,192,29,46,208,1,192,60,59,255,241,192,122,146,185,177,192,35,192,112,113,192,3,192,112,114,192,3,192,121,178,192,3,192,127,242,192,3,192,112,59,192,3,200,112,47,64,3,252,112,0,80,3,244,116,0,112,7,208,126,170,240,7,0,47,255,208,0,0,0,0,0,
  // 0x9a6c  马
  108,154,17,18,90,19,1,254,26,170,170,160,0,31,255,255,240,0,0,0,0,240,0,2,128,0,224,0,3,192,0,224,0,3,192,1,208,0,3,128,1,208,0,3,128,1,208,0,7,255,255,255,64,2,170,170,175,64,0,0,0,11,64,0,0,0,11,0,255,255,255,75,0,170,170,170,79,0,0,0,0,14,0,0,0,0,45,0,0,0,15,252,0,0,0,10,160,0,
  // 0x9a71  驱
  113,154,18,18,90,19,0,254,47,252,42,170,160,26,188,127,255,240,0,44,116,0,0,13,44,116,2,128,13,44,119,131,192,28,56,118,211,64,28,56,116,251,0,28,56,116,62,0,45,121,116,45,0,47,255,116,63,0,0,14,116,187,64,0,14,116,243,192,6,222,119,193,224,127,141,119,128,208,16,13,117,0,0,0,44,122,170,160,3,252,127,255,240,1,80,0,0,0,
  // 0x9ad8  高
  216,154,17,19,95,19,1,254,0,1,128,0,0,0,2,208,0,0,191,255,255,255,128,106,170,170,170,64,0,0,0,0,0,2,255,255,224,0,2,192,0,224,0,2,208,1,224,0,2,255,255,224,0,0,0,0,0,0,63,255,255,255,0,61,85,85,95,0,60,0,0,11,0,60,63,255,11,0,60,52,7,11,0,60,56,11,11,0,60,63,255,15,0,60,52,1,255,0,40,0,0,168,0,
  // 0x9ec4  黄
  196,158,17,19,95,19,1,254,0,36,6,64,0,0,116,7,64,0,47,255,255,254,0,26,190,171,169,0,0,116,7,64,0,170,190,175,234,128,255,255,255,255,192,0,1,208,0,0,15,255,255,252,0,15,86,229,124,0,15,1,208,44,0,15,255,255,252,0,15,2,224,44,0,15,86,229,124,0,15,255,255,252,0,0,36,6,64,0,7,248,7,248,0,127,128,0,111,64,36,0,0,2,0,
  // 0x9ede  點
  222,158,17,19,95,19,1,254,0,0,0,128,0,191,255,1,208,0,182,215,1,208,0,189,223,1,208,0,186,235,1,250,128,186,247,1,255,192,177,199,1,208,0,191,255,1,208,0,2,208,1,208,0,22,213,1,208,0,191,255,63,255,64,2,192,62,171,64,255,255,120,3,64,170,169,56,3,64,21,90,56,3,64,119,115,120,3,64,163,50,191,255,64,211,16,62,171,64,64,0,36,1,0,
  // 0x9f50  齐
  80,159,17,19,95,19,1,254,0,1,144,0,0,0,2,208,0,0,255,255,255,255,192,107,234,171,250,64,0,240,3,192,0,0,61,15,64,0,0,15,189,0,0,0,11,253,0,0,5,255,191,229,0,255,228,2,255,192,121,208,1,230,64,0,224,1,208,0,0,224,1,208,0,1,224,1,208,0,2,208,1,208,0,3,192,1,208,0,15,128,1,208,0,63,0,1,208,0,8,0,0,144,0,
  // 0xff1a  ：
  26,255,3,13,13,19,8,1,116,252,184,0,0,0,0,0,0,0,184,252,180,
};

#endif // HAS_GRAPHICAL_TFT
