/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Katakana 19pt, capital 'A' height: 14px, width: 100%, range: 0x30a0-0x8868, glyphs: 103
extern const uint8_t NotoSans_Medium_Katakana_14[7913] = {
  162,14,160,48,104,136,18,251, // unifont_t
  // 0x30a0  ゠
  160,48,9,5,15,19,5,5,106,170,64,0,0,0,0,0,0,0,0,0,106,170,64,
  // 0x30a1  ァ
  161,48,14,13,52,19,3,254,186,170,171,128,191,255,255,208,0,0,11,128,0,44,31,0,0,60,125,0,0,60,244,0,0,60,0,0,0,56,0,0,0,184,0,0,1,240,0,0,7,208,0,0,47,128,0,0,9,0,0,0,
  // 0x30a2  ア
  162,48,16,16,64,19,2,255,191,255,255,252,191,255,255,254,0,0,0,124,0,0,0,244,0,15,3,224,0,15,15,192,0,15,47,0,0,15,4,0,0,15,0,0,0,30,0,0,0,46,0,0,0,60,0,0,0,248,0,0,7,240,0,0,31,192,0,0,10,0,0,0,
  // 0x30a3  ィ
  163,48,13,14,56,19,2,254,0,0,2,0,0,0,15,192,0,0,63,0,0,1,248,0,0,15,208,0,1,255,192,0,111,247,192,0,126,3,192,0,16,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,1,64,0,
  // 0x30a4  イ
  164,48,16,16,64,19,1,255,0,0,0,40,0,0,0,189,0,0,2,248,0,0,15,208,0,0,127,0,0,7,248,0,0,127,244,0,27,253,180,0,127,208,180,0,36,0,180,0,0,0,180,0,0,0,180,0,0,0,180,0,0,0,180,0,0,0,184,0,0,0,180,0,
  // 0x30a5  ゥ
  165,48,13,14,56,19,3,254,0,45,0,0,0,45,0,0,106,191,171,64,191,255,255,192,180,0,7,128,180,0,11,64,180,0,15,0,96,0,31,0,0,0,61,0,0,0,252,0,0,7,240,0,0,127,192,0,1,254,0,0,0,144,0,0,
  // 0x30a6  ウ
  166,48,15,18,72,19,2,254,0,11,64,0,0,11,64,0,0,11,64,0,191,255,255,244,191,255,255,252,180,0,0,184,180,0,0,244,180,0,0,240,180,0,1,240,100,0,3,208,0,0,7,192,0,0,15,128,0,0,63,0,0,1,252,0,0,31,240,0,0,255,128,0,0,56,0,0,0,0,0,0,
  // 0x30a7  ェ
  167,48,13,11,44,19,3,255,63,255,255,64,62,191,175,64,0,45,0,0,0,45,0,0,0,45,0,0,0,45,0,0,0,45,0,0,0,45,0,0,255,255,255,192,255,255,255,192,0,0,0,0,
  // 0x30a8  エ
  168,48,17,13,65,19,1,0,31,255,255,253,0,31,255,255,253,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,127,255,255,255,64,127,255,255,255,64,0,0,0,0,0,
  // 0x30a9  ォ
  169,48,14,14,56,19,3,254,0,1,224,0,0,1,208,0,0,1,208,0,127,255,255,208,58,175,250,144,0,11,224,0,0,47,224,0,0,189,224,0,2,240,224,0,31,192,224,0,190,0,224,0,52,0,224,0,0,63,224,0,0,26,128,0,
  // 0x30aa  オ
  170,48,16,17,68,19,1,255,0,0,25,0,0,0,30,0,0,0,30,0,0,0,14,0,47,255,255,255,47,255,255,255,0,0,190,0,0,1,254,0,0,7,222,0,0,31,78,0,0,125,15,0,2,244,15,0,31,208,15,0,127,0,15,0,36,0,15,0,0,7,254,0,0,3,248,0,
  // 0x30ab  カ
  171,48,15,18,72,19,2,254,0,26,0,0,0,31,0,0,0,30,0,0,0,30,0,0,191,255,255,240,191,255,255,244,0,45,0,176,0,60,0,176,0,60,0,240,0,120,0,240,0,180,0,240,0,240,0,240,2,224,0,224,11,192,1,224,31,64,2,208,189,1,255,192,116,0,255,64,0,0,0,0,
  // 0x30ac  ガ
  172,48,16,19,76,19,2,254,0,0,0,4,0,24,0,92,0,45,1,207,0,45,0,226,0,45,0,80,255,255,255,208,255,255,255,240,0,60,0,240,0,60,0,240,0,120,0,224,0,180,0,224,0,240,1,224,2,224,1,208,3,208,2,208,15,128,2,192,63,0,3,192,252,2,255,128,176,1,254,0,0,0,0,0,
  // 0x30ad  キ
  173,48,15,16,64,19,2,255,0,60,0,0,0,60,0,0,0,45,6,192,1,111,255,208,255,255,229,0,254,95,0,0,0,15,0,0,0,11,64,104,0,11,255,252,107,255,255,148,255,235,192,0,80,3,192,0,0,2,208,0,0,1,224,0,0,1,240,0,0,0,224,0,
  // 0x30ae  ギ
  174,48,17,18,90,19,1,255,0,0,0,1,0,0,0,0,87,0,0,30,0,114,192,0,15,0,56,0,0,15,5,176,0,0,95,255,240,0,127,255,249,64,0,62,151,128,0,0,0,3,192,0,0,0,3,192,25,0,0,3,239,254,0,26,255,255,164,0,127,250,224,0,0,36,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,180,0,0,0,0,116,0,0,
  // 0x30af  ク
  175,48,15,18,72,19,2,254,0,14,0,0,0,31,0,0,0,62,0,0,0,127,255,244,0,250,170,244,3,208,0,240,15,128,2,224,126,0,3,208,248,0,11,192,16,0,15,0,0,0,62,0,0,0,188,0,0,2,240,0,0,31,208,0,0,191,0,0,15,248,0,0,7,128,0,0,0,0,0,0,
  // 0x30b0  グ
  176,48,17,19,95,19,1,254,0,0,0,2,0,0,5,0,115,128,0,15,128,57,192,0,31,0,28,0,0,63,170,244,0,0,191,255,252,0,1,240,0,244,0,7,192,0,240,0,47,64,1,224,0,189,0,3,208,0,32,0,11,192,0,0,0,15,0,0,0,0,62,0,0,0,0,252,0,0,0,7,240,0,0,0,47,192,0,0,6,254,0,0,0,11,240,0,0,0,1,0,0,0,0,
  // 0x30b1  ケ
  177,48,17,18,90,19,1,254,0,40,0,0,0,0,124,0,0,0,0,180,0,0,0,0,240,0,0,0,1,255,255,255,64,3,255,255,255,64,11,128,46,0,0,47,0,45,0,0,189,0,60,0,0,52,0,60,0,0,0,0,184,0,0,0,0,244,0,0,0,2,240,0,0,0,7,208,0,0,0,31,128,0,0,0,190,0,0,0,0,56,0,0,0,0,0,0,0,0,
  // 0x30b2  ゲ
  178,48,17,19,95,19,1,254,0,0,0,2,0,0,16,0,99,64,0,184,0,54,192,0,244,0,44,64,1,240,0,0,0,2,255,255,255,0,7,255,255,255,0,15,128,61,0,0,47,0,60,0,0,189,0,60,0,0,180,0,124,0,0,0,0,184,0,0,0,0,240,0,0,0,2,240,0,0,0,7,208,0,0,0,31,128,0,0,0,191,0,0,0,0,184,0,0,0,0,0,0,0,0,
  // 0x30b3  コ
  179,48,14,15,60,19,3,255,255,255,255,208,255,255,255,208,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,255,255,255,192,255,255,255,208,0,0,3,208,0,0,0,0,
  // 0x30b4  ゴ
  180,48,16,19,76,19,2,254,0,0,0,28,0,0,3,141,0,0,1,203,0,0,0,128,127,255,255,240,127,255,255,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,127,255,255,240,127,255,255,240,0,0,0,240,0,0,0,0,
  // 0x30b5  サ
  181,48,17,18,90,19,1,254,0,160,2,128,0,0,240,3,192,0,0,240,3,192,0,0,240,3,192,0,255,255,255,255,128,255,255,255,255,128,0,240,3,192,0,0,240,3,192,0,0,240,3,192,0,0,240,3,128,0,0,240,7,128,0,0,0,15,64,0,0,0,31,0,0,0,0,61,0,0,0,1,248,0,0,0,15,240,0,0,0,7,64,0,0,0,0,0,0,0,
  // 0x30b6  ザ
  182,48,17,18,90,19,1,254,0,0,1,2,64,1,224,7,169,192,1,224,7,156,192,1,224,7,140,0,1,224,7,128,0,255,255,255,255,0,255,255,255,255,0,1,224,7,128,0,1,224,7,128,0,1,224,7,64,0,1,224,11,64,0,1,144,15,0,0,0,0,31,0,0,0,0,61,0,0,0,0,252,0,0,0,11,240,0,0,0,15,128,0,0,0,1,0,0,0,
  // 0x30b7  シ
  183,48,16,16,64,19,2,255,2,128,0,0,3,244,0,0,0,254,0,0,0,29,0,0,16,0,0,4,248,0,0,28,127,64,0,61,11,192,0,248,1,0,3,240,0,0,31,192,0,0,190,0,0,7,244,0,0,191,192,0,47,253,0,0,63,144,0,0,4,0,0,0,
  // 0x30b8  ジ
  184,48,16,17,68,19,2,255,0,0,0,40,3,192,7,28,3,248,3,143,0,190,1,192,0,8,0,64,160,0,0,20,253,0,0,60,47,128,0,252,7,0,2,240,0,0,11,192,0,0,63,0,0,1,252,0,0,31,224,0,6,255,64,0,127,244,0,0,62,0,0,0,0,0,0,0,
  // 0x30b9  ス
  185,48,15,15,60,19,2,255,47,255,255,192,47,255,255,192,0,0,11,128,0,0,15,0,0,0,46,0,0,0,124,0,0,0,244,0,0,3,240,0,0,11,252,0,0,63,63,0,0,252,15,192,7,240,3,224,127,128,1,248,253,0,0,124,32,0,0,32,
  // 0x30ba  ズ
  186,48,17,19,95,19,1,254,0,0,0,3,0,0,0,0,179,128,0,0,0,57,192,15,255,255,244,0,15,255,255,224,0,0,0,3,192,0,0,0,7,192,0,0,0,15,64,0,0,0,46,0,0,0,0,124,0,0,0,0,248,0,0,0,3,253,0,0,0,15,239,64,0,0,63,11,208,0,1,252,2,240,0,15,224,0,252,0,127,64,0,62,0,40,0,0,28,0,0,0,0,0,0,
  // 0x30bb  セ
  187,48,16,17,68,19,1,255,0,20,0,0,0,120,0,0,0,120,0,0,0,120,0,4,0,120,6,254,0,126,255,254,111,255,249,124,255,253,0,180,164,120,1,240,0,120,3,192,0,120,15,64,0,120,1,0,0,120,0,0,0,120,0,0,0,124,0,24,0,63,255,252,0,11,255,168,
  // 0x30bc  ゼ
  188,48,17,18,90,19,1,255,0,0,0,2,0,0,0,0,115,128,0,244,0,53,192,0,180,0,44,64,0,180,0,0,0,0,180,1,188,0,0,186,191,254,0,26,255,254,188,0,255,249,0,244,0,233,180,1,224,0,0,180,7,192,0,0,180,15,64,0,0,180,5,0,0,0,180,0,0,0,0,180,0,0,0,0,184,0,20,0,0,127,255,252,0,0,31,255,232,0,
  // 0x30bd  ソ
  189,48,14,15,60,19,2,255,32,0,0,240,188,0,0,240,61,0,1,240,31,0,2,224,15,128,3,192,7,192,7,192,2,0,11,64,0,0,31,0,0,0,61,0,0,0,252,0,0,3,240,0,0,31,192,0,0,191,0,0,2,248,0,0,0,128,0,0,
  // 0x30be  ゾ
  190,48,16,18,72,19,2,255,0,0,0,4,0,0,2,93,0,0,2,203,16,0,0,209,244,0,1,144,188,0,2,224,62,0,3,208,31,0,3,192,15,128,7,128,6,0,15,64,0,0,31,0,0,0,61,0,0,0,252,0,0,3,240,0,0,15,192,0,0,191,0,0,3,248,0,0,1,208,0,0,
  // 0x30bf  タ
  191,48,15,19,76,19,2,254,0,4,0,0,0,15,0,0,0,46,0,0,0,63,170,224,0,255,255,248,2,224,0,240,11,192,1,240,47,0,3,208,252,61,7,192,240,47,143,64,0,7,255,0,0,0,254,0,0,1,255,128,0,7,235,192,0,47,129,64,1,253,0,0,31,244,0,0,11,64,0,0,0,0,0,0,
  // 0x30c0  ダ
  192,48,17,19,95,19,1,254,0,0,0,3,0,0,6,64,115,128,0,15,128,57,192,0,31,0,44,0,0,63,255,248,0,0,190,170,252,0,1,240,0,180,0,7,192,0,240,0,47,72,1,224,0,189,47,67,192,0,48,11,235,128,0,0,1,255,0,0,0,0,127,64,0,0,0,255,224,0,0,7,226,208,0,0,47,128,64,0,2,253,0,0,0,11,224,0,0,0,1,0,0,0,0,
  // 0x30c1  チ
  193,48,17,17,85,19,1,254,0,0,6,240,0,10,175,255,240,0,11,255,245,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,127,255,255,255,64,127,255,255,255,64,0,1,224,0,0,0,2,208,0,0,0,3,208,0,0,0,7,192,0,0,0,15,64,0,0,0,62,0,0,0,2,252,0,0,0,0,224,0,0,0,0,0,0,0,0,
  // 0x30c2  ヂ
  194,48,17,17,85,19,1,254,0,0,22,208,0,10,191,255,224,0,15,255,228,19,0,0,2,208,54,192,0,2,208,44,64,0,2,208,0,0,255,255,255,255,0,255,255,255,255,0,0,3,192,0,0,0,3,192,0,0,0,7,192,0,0,0,15,64,0,0,0,31,0,0,0,0,125,0,0,0,2,248,0,0,0,2,208,0,0,0,0,0,0,0,0,
  // 0x30c3  ッ
  195,48,13,13,52,19,3,254,0,40,1,0,112,60,3,192,120,45,7,192,60,30,11,128,45,8,15,0,25,0,31,0,0,0,60,0,0,0,184,0,0,2,240,0,0,31,192,0,1,254,0,0,3,244,0,0,0,64,0,0,
  // 0x30c4  ツ
  196,48,15,16,64,19,2,255,0,44,0,0,96,45,0,60,240,31,0,60,184,15,0,120,60,11,128,244,61,1,0,240,29,0,2,224,0,0,3,192,0,0,15,64,0,0,47,0,0,0,188,0,0,3,240,0,0,47,192,0,2,254,0,0,1,224,0,0,0,0,0,0,
  // 0x30c5  ヅ
  197,48,17,18,90,19,1,255,0,0,0,1,0,0,0,0,163,64,0,0,0,114,192,0,15,0,52,64,116,15,0,4,0,124,11,128,46,0,61,3,192,61,0,30,3,192,60,0,15,0,0,184,0,9,0,0,240,0,0,0,2,224,0,0,0,7,192,0,0,0,31,64,0,0,0,126,0,0,0,2,248,0,0,0,47,208,0,0,1,255,0,0,0,0,180,0,0,0,
  // 0x30c6  テ
  198,48,17,17,85,19,1,254,3,255,255,244,0,3,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,64,127,255,255,255,64,0,0,240,0,0,0,0,240,0,0,0,1,224,0,0,0,2,208,0,0,0,3,192,0,0,0,15,128,0,0,0,47,0,0,0,1,253,0,0,0,0,240,0,0,0,0,0,0,0,0,
  // 0x30c7  デ
  199,48,18,19,95,19,1,254,0,0,0,3,64,0,0,0,53,192,3,255,255,236,208,7,255,255,200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,0,127,255,255,255,64,0,1,224,0,0,0,1,224,0,0,0,2,208,0,0,0,3,208,0,0,0,7,192,0,0,0,15,128,0,0,0,63,0,0,0,1,252,0,0,0,1,240,0,0,0,0,0,0,0,0,
  // 0x30c8  ト
  200,48,10,16,48,19,6,255,244,0,0,244,0,0,240,0,0,240,0,0,240,0,0,253,0,0,255,244,0,250,255,128,240,31,240,240,1,224,240,0,0,240,0,0,240,0,0,240,0,0,244,0,0,160,0,0,
  // 0x30c9  ド
  201,48,12,16,48,19,5,255,104,0,36,120,7,44,120,3,142,120,1,192,120,0,64,125,0,0,127,228,0,127,255,128,120,47,244,120,1,240,120,0,16,120,0,0,120,0,0,120,0,0,120,0,0,120,0,0,
  // 0x30ca  ナ
  202,48,16,18,72,19,2,254,0,2,128,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,255,255,255,254,255,255,255,254,0,3,192,0,0,3,192,0,0,7,192,0,0,11,128,0,0,15,0,0,0,47,0,0,0,124,0,0,2,248,0,0,15,224,0,0,3,64,0,0,0,0,0,0,
  // 0x30cb  ニ
  203,48,16,13,52,19,1,0,11,255,255,244,11,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,127,255,255,255,0,0,0,0,
  // 0x30cc  ヌ
  204,48,14,16,64,19,2,254,47,255,255,208,47,255,255,208,0,0,3,192,0,0,11,128,2,0,15,64,7,224,31,0,1,253,61,0,0,63,252,0,0,11,244,0,0,7,253,0,0,47,191,64,0,190,11,224,11,244,2,208,127,208,0,0,45,0,0,0,0,0,0,0,
  // 0x30cd  ネ
  205,48,17,18,90,19,1,254,0,1,224,0,0,0,1,224,0,0,0,1,224,0,0,15,255,255,244,0,15,255,255,248,0,0,0,3,224,0,0,0,15,128,0,0,0,126,0,0,0,2,248,0,0,0,31,224,208,0,1,255,226,248,0,127,245,224,127,64,62,65,224,15,64,0,1,224,1,0,0,1,224,0,0,0,1,224,0,0,0,1,224,0,0,0,0,0,0,0,
  // 0x30ce  ノ
  206,48,13,15,60,19,2,0,0,0,2,128,0,0,3,192,0,0,7,192,0,0,15,64,0,0,15,0,0,0,46,0,0,0,60,0,0,0,244,0,0,2,240,0,0,11,208,0,0,47,64,0,1,253,0,0,11,244,0,0,127,128,0,0,29,0,0,0,
  // 0x30cf  ハ
  207,48,17,14,70,19,1,0,0,36,11,0,0,0,60,15,64,0,0,120,7,192,0,0,180,3,208,0,0,240,1,240,0,0,240,0,240,0,2,224,0,184,0,3,208,0,60,0,7,192,0,61,0,15,64,0,47,0,31,0,0,15,0,61,0,0,15,64,124,0,0,11,128,0,0,0,0,0,
  // 0x30d0  バ
  208,48,17,16,80,19,1,0,0,0,0,3,0,0,0,0,115,192,0,0,0,56,192,0,120,15,24,0,0,184,15,64,0,0,244,7,192,0,0,240,3,208,0,1,240,1,240,0,2,224,0,240,0,3,192,0,184,0,7,192,0,124,0,15,64,0,61,0,31,0,0,46,0,62,0,0,31,0,188,0,0,15,64,116,0,0,10,0,
  // 0x30d1  パ
  209,48,18,17,85,19,1,255,0,0,0,15,128,0,0,0,52,208,0,16,5,52,208,0,120,15,15,128,0,184,11,128,0,0,244,3,192,0,0,240,3,208,0,1,240,1,240,0,2,208,0,244,0,3,192,0,184,0,7,192,0,124,0,15,64,0,61,0,31,0,0,46,0,62,0,0,31,0,124,0,0,15,0,184,0,0,15,64,0,0,0,0,0,
  // 0x30d2  ヒ
  210,48,13,16,64,19,4,0,80,0,0,0,240,0,0,0,240,0,0,0,240,0,8,0,240,0,190,0,240,47,249,0,251,255,128,0,255,224,0,0,244,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,248,0,5,0,127,255,255,64,31,255,254,0,
  // 0x30d3  ビ
  211,48,15,18,72,19,3,255,0,0,0,64,0,0,8,224,180,0,14,116,180,0,7,32,180,0,1,0,180,0,29,0,180,1,255,0,180,127,244,0,191,254,64,0,191,144,0,0,184,0,0,0,180,0,0,0,180,0,0,0,180,0,0,0,180,0,0,0,124,0,5,64,63,255,255,128,11,255,254,64,
  // 0x30d4  ピ
  212,48,15,17,68,19,3,255,0,0,2,240,180,0,7,28,180,0,7,28,180,0,7,240,180,0,126,0,180,11,254,0,186,255,224,0,191,249,0,0,190,64,0,0,180,0,0,0,180,0,0,0,180,0,0,0,180,0,0,0,180,0,0,0,124,0,5,64,63,255,255,128,11,255,254,64,
  // 0x30d5  フ
  213,48,15,15,60,19,2,255,127,255,255,240,127,255,255,244,0,0,0,240,0,0,1,240,0,0,2,224,0,0,3,192,0,0,11,192,0,0,15,64,0,0,47,0,0,0,188,0,0,2,244,0,0,31,208,0,2,255,64,0,7,248,0,0,1,64,0,0,
  // 0x30d6  ブ
  214,48,16,18,72,19,2,255,0,0,1,77,0,0,2,203,0,0,0,227,255,255,255,224,255,255,255,240,0,0,2,224,0,0,2,224,0,0,3,192,0,0,7,192,0,0,15,64,0,0,31,0,0,0,61,0,0,0,252,0,0,3,240,0,0,31,208,0,2,255,0,0,15,248,0,0,3,128,0,0,
  // 0x30d7  プ
  215,48,17,18,90,19,2,255,0,0,0,46,0,0,0,0,163,64,0,0,0,145,128,191,255,255,227,64,191,255,255,254,0,0,0,1,240,0,0,0,2,224,0,0,0,3,208,0,0,0,7,192,0,0,0,15,128,0,0,0,31,0,0,0,0,62,0,0,0,0,252,0,0,0,3,240,0,0,0,31,208,0,0,2,255,0,0,0,15,248,0,0,0,3,128,0,0,0,
  // 0x30d8  ヘ
  216,48,17,13,65,19,1,0,0,31,0,0,0,0,63,192,0,0,0,250,240,0,0,3,224,188,0,0,11,192,63,0,0,31,64,15,192,0,126,0,3,224,0,188,0,1,248,0,32,0,0,189,0,0,0,0,47,64,0,0,0,15,192,0,0,0,3,0,0,0,0,0,0,
  // 0x30d9  ベ
  217,48,17,15,75,19,1,0,0,0,0,4,0,0,0,0,29,0,0,4,3,203,0,0,47,65,211,64,0,191,208,176,0,1,241,244,0,0,7,208,125,0,0,15,128,47,0,0,63,0,11,192,0,252,0,3,240,0,116,0,0,252,0,16,0,0,126,0,0,0,0,31,128,0,0,0,11,64,0,0,0,1,0,
  // 0x30da  ペ
  218,48,17,14,70,19,1,0,0,0,0,189,0,0,0,1,199,0,0,47,65,199,0,0,191,208,189,0,1,241,244,0,0,7,208,125,0,0,15,128,47,0,0,62,0,11,192,0,252,0,3,240,0,48,0,0,252,0,0,0,0,126,0,0,0,0,31,128,0,0,0,11,64,0,0,0,1,0,
  // 0x30db  ホ
  219,48,16,17,68,19,2,255,0,2,128,0,0,3,192,0,0,3,128,0,0,3,128,0,255,255,255,252,255,255,255,252,0,3,128,0,0,3,128,0,7,3,129,192,15,3,130,224,46,3,128,244,124,3,128,124,244,3,128,46,224,3,128,13,0,7,128,0,0,255,128,0,0,174,0,0,
  // 0x30dc  ボ
  220,48,17,17,85,19,1,255,0,1,64,87,64,0,2,208,114,192,0,2,208,56,128,0,2,208,0,0,127,255,255,255,0,127,255,255,255,0,0,2,208,0,0,0,2,208,0,0,2,130,208,160,0,7,194,208,244,0,15,66,208,124,0,46,2,208,46,0,124,2,208,15,0,180,2,208,11,0,0,2,208,0,0,0,127,208,0,0,0,63,192,0,0,
  // 0x30dd  ポ
  221,48,17,18,90,19,1,255,0,0,0,47,0,0,1,144,114,128,0,2,208,114,128,0,2,208,47,0,0,2,208,0,0,127,255,255,255,0,127,255,255,255,0,0,2,208,0,0,0,2,208,0,0,2,130,208,160,0,7,194,208,244,0,15,66,208,124,0,46,2,208,46,0,124,2,208,15,0,180,2,208,11,0,0,2,208,0,0,0,127,208,0,0,0,63,192,0,0,
  // 0x30de  マ
  222,48,16,16,64,19,2,254,255,255,255,252,255,255,255,254,0,0,0,188,0,0,1,244,0,0,3,224,0,0,15,192,7,192,47,0,3,240,188,0,0,255,240,0,0,63,192,0,0,15,192,0,0,3,240,0,0,0,248,0,0,0,125,0,0,0,40,0,0,0,0,0,
  // 0x30df  ミ
  223,48,13,16,64,19,3,255,11,148,0,0,15,255,228,0,0,91,255,64,0,0,27,0,0,0,0,0,42,64,0,0,63,254,64,0,1,191,252,0,0,1,188,0,0,0,0,0,16,0,0,0,255,144,0,0,175,255,144,0,0,111,254,0,0,0,110,0,0,0,0,0,
  // 0x30e0  ム
  224,48,17,16,80,19,1,255,0,7,192,0,0,0,11,128,0,0,0,15,64,0,0,0,15,0,0,0,0,31,0,0,0,0,45,0,0,0,0,60,0,0,0,0,124,2,192,0,0,184,2,224,0,0,240,0,240,0,1,240,0,188,0,2,224,0,125,0,7,234,255,255,0,191,255,255,175,0,126,148,0,11,128,0,0,0,6,0,
  // 0x30e1  メ
  225,48,15,16,64,19,2,255,0,0,2,128,0,0,3,208,0,0,7,192,3,64,15,64,7,240,15,0,1,253,61,0,0,47,252,0,0,7,244,0,0,3,252,0,0,15,255,64,0,63,15,208,0,252,3,244,7,240,0,244,127,128,0,16,125,0,0,0,0,0,0,0,
  // 0x30e2  モ
  226,48,16,15,60,19,2,255,47,255,255,240,47,255,255,224,0,45,0,0,0,45,0,0,0,45,0,0,255,255,255,252,255,255,255,253,0,45,0,0,0,45,0,0,0,45,0,0,0,45,0,0,0,46,0,0,0,31,0,0,0,15,255,248,0,2,255,248,
  // 0x30e3  ャ
  227,48,13,14,56,19,3,254,7,128,0,0,3,192,0,0,3,192,27,192,2,255,255,192,255,254,75,128,249,240,15,0,0,240,60,0,0,180,244,0,0,120,16,0,0,60,0,0,0,45,0,0,0,30,0,0,0,15,0,0,0,9,0,0,
  // 0x30e4  ヤ
  228,48,17,16,80,19,1,255,1,224,0,0,0,0,240,0,0,0,0,240,0,111,0,0,185,191,255,64,22,255,254,110,0,255,254,64,60,0,105,61,0,244,0,0,30,3,224,0,0,15,15,192,0,0,15,2,0,0,0,11,64,0,0,0,7,128,0,0,0,3,192,0,0,0,3,208,0,0,0,2,224,0,0,0,1,224,0,0,
  // 0x30e5  ュ
  229,48,14,11,44,19,3,255,31,255,252,0,31,255,252,0,0,0,60,0,0,0,120,0,0,0,120,0,0,0,180,0,0,0,180,0,0,0,240,0,255,255,255,208,255,255,255,208,0,0,0,0,
  // 0x30e6  ユ
  230,48,17,13,65,19,1,0,7,255,255,224,0,7,255,255,240,0,0,0,1,224,0,0,0,2,224,0,0,0,2,208,0,0,0,3,208,0,0,0,3,192,0,0,0,3,192,0,0,0,7,192,0,0,0,7,128,0,191,255,255,255,128,191,255,255,255,128,0,0,0,0,0,
  // 0x30e7  ョ
  231,48,11,13,39,19,4,254,255,255,252,170,170,188,0,0,60,0,0,60,0,0,60,127,255,252,106,170,188,0,0,60,0,0,60,0,0,60,255,255,252,250,170,252,0,0,20,
  // 0x30e8  ヨ
  232,48,13,15,60,19,3,255,255,255,255,192,255,255,255,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,127,255,255,192,127,255,255,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,255,255,255,192,255,255,255,192,0,0,3,192,
  // 0x30e9  ラ
  233,48,15,17,68,19,2,254,11,255,255,208,11,255,255,208,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,248,127,255,255,248,0,0,0,240,0,0,1,240,0,0,3,208,0,0,11,128,0,0,47,0,0,0,252,0,0,31,240,0,0,255,128,0,0,120,0,0,0,0,0,0,
  // 0x30ea  リ
  234,48,11,16,48,19,4,255,240,0,124,240,0,60,240,0,60,240,0,60,240,0,60,240,0,60,240,0,60,240,0,124,240,0,120,80,0,180,0,0,240,0,3,224,0,31,192,1,254,0,2,244,0,0,64,0,
  // 0x30eb  ル
  235,48,17,16,80,19,1,255,0,240,60,0,0,0,240,60,0,0,0,240,60,0,0,0,240,60,0,0,0,224,60,0,0,0,224,60,0,0,1,224,60,0,0,1,224,60,0,0,2,208,60,2,128,3,192,60,11,192,7,192,60,47,0,15,64,61,252,0,47,0,63,240,0,188,0,63,128,0,52,0,40,0,0,0,0,0,0,0,
  // 0x30ec  レ
  236,48,13,15,60,19,4,0,180,0,0,0,244,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,64,240,0,3,192,240,0,15,128,240,0,190,0,240,7,248,0,240,127,192,0,251,253,0,0,255,208,0,0,120,0,0,0,
  // 0x30ed  ロ
  237,48,15,15,60,19,2,255,127,255,255,244,127,255,255,244,120,0,0,180,120,0,0,180,120,0,0,180,120,0,0,180,120,0,0,180,120,0,0,180,120,0,0,180,120,0,0,180,120,0,0,180,127,255,255,244,127,255,255,244,120,0,0,180,0,0,0,0,
  // 0x30ee  ヮ
  238,48,13,13,52,19,3,254,122,170,175,64,191,255,255,192,180,0,11,128,180,0,15,64,180,0,15,0,180,0,31,0,0,0,62,0,0,0,124,0,0,1,244,0,0,7,224,0,0,127,128,0,2,253,0,0,0,144,0,0,
  // 0x30ef  ワ
  239,48,15,15,60,19,2,255,191,255,255,244,191,255,255,248,180,0,0,244,180,0,0,244,180,0,0,240,180,0,1,240,180,0,2,224,0,0,3,192,0,0,11,192,0,0,31,0,0,0,126,0,0,2,248,0,0,47,224,0,0,255,64,0,0,116,0,0,
  // 0x30f0  ヰ
  240,48,17,17,85,19,1,255,0,0,1,0,0,0,0,7,64,0,0,0,7,64,0,0,0,7,64,0,47,255,255,255,0,47,255,255,255,0,0,116,7,64,0,0,116,7,64,0,0,116,7,64,0,0,116,7,64,0,0,116,7,64,0,127,255,255,255,64,127,255,255,255,64,0,0,7,64,0,0,0,7,64,0,0,0,7,64,0,0,0,7,64,0,
  // 0x30f1  ヱ
  241,48,17,14,70,19,1,0,31,255,255,255,0,31,255,255,255,0,0,0,0,61,0,0,1,128,184,0,0,3,194,240,0,0,3,199,192,0,0,3,193,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,127,255,255,255,128,127,255,255,255,128,0,0,0,0,0,
  // 0x30f2  ヲ
  242,48,14,16,64,19,3,254,255,255,255,208,255,255,255,224,0,0,2,208,0,0,3,192,0,0,3,192,191,255,255,128,127,255,255,64,0,0,15,0,0,0,62,0,0,0,188,0,0,2,240,0,0,15,192,0,0,191,0,0,15,248,0,0,3,128,0,0,0,0,0,0,
  // 0x30f3  ン
  243,48,15,15,60,19,3,0,16,0,0,0,188,0,0,0,63,64,0,0,15,208,0,16,2,240,0,48,0,128,0,244,0,0,2,240,0,0,11,192,0,0,47,64,0,0,189,0,0,7,244,0,0,127,192,0,27,253,0,0,255,208,0,0,180,0,0,0,
  // 0x30f4  ヴ
  244,48,16,19,76,19,2,254,0,0,0,28,0,15,2,206,0,15,0,215,0,15,0,80,255,255,255,240,255,255,255,244,240,0,0,240,240,0,1,240,240,0,1,224,240,0,3,208,160,0,3,192,0,0,11,128,0,0,31,0,0,0,126,0,0,1,252,0,0,31,224,0,1,255,64,0,0,248,0,0,0,0,0,0,
  // 0x30f5  ヵ
  245,48,12,14,42,19,3,254,0,56,0,0,56,0,0,56,0,191,255,255,170,254,175,0,180,11,0,176,11,0,240,11,2,208,15,7,192,15,15,64,30,126,7,189,116,7,248,0,0,0,
  // 0x30f6  ヶ
  246,48,15,14,56,19,2,254,0,240,0,0,0,240,0,0,2,224,0,0,3,255,255,244,11,234,254,160,31,0,240,0,125,0,240,0,116,1,224,0,0,2,208,0,0,3,192,0,0,15,128,0,0,63,0,0,0,252,0,0,0,96,0,0,
  // 0x30f7  ヷ
  247,48,16,19,76,19,2,254,0,0,2,28,0,0,3,206,0,0,1,128,255,255,255,224,255,255,255,244,240,0,0,240,240,0,1,240,240,0,1,224,240,0,2,224,240,0,3,208,80,0,7,192,0,0,15,128,0,0,47,0,0,0,125,0,0,2,248,0,0,31,224,0,1,255,64,0,0,248,0,0,0,0,0,0,
  // 0x30f8  ヸ
  248,48,17,19,95,19,1,254,0,0,0,1,0,0,0,0,38,128,0,0,11,93,192,0,0,11,76,128,0,0,11,64,0,63,255,255,255,0,47,255,255,254,0,0,176,11,64,0,0,176,11,64,0,0,176,11,64,0,0,176,11,64,0,0,176,11,64,0,191,255,255,255,64,191,255,255,255,64,0,0,11,64,0,0,0,11,64,0,0,0,11,64,0,0,0,11,64,0,0,0,0,0,0,
  // 0x30f9  ヹ
  249,48,17,18,90,19,1,255,0,0,0,6,0,0,0,0,227,64,0,0,0,178,128,0,0,0,32,0,47,255,255,254,0,47,255,255,254,0,0,0,0,60,0,0,2,128,244,0,0,3,195,224,0,0,3,203,128,0,0,3,193,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,191,255,255,255,64,191,255,255,255,64,0,0,0,0,0,
  // 0x30fa  ヺ
  250,48,16,19,76,19,2,254,0,0,1,28,0,0,3,142,0,0,1,197,191,255,255,208,255,255,255,240,0,0,1,240,0,0,2,224,0,0,3,208,63,255,255,192,127,255,255,128,0,0,15,64,0,0,31,0,0,0,61,0,0,0,248,0,0,3,240,0,0,47,192,0,6,254,0,0,7,244,0,0,1,64,0,0,
  // 0x30fb  ・
  251,48,5,5,10,19,7,5,46,0,191,128,191,128,127,0,4,0,
  // 0x30fc  ー
  252,48,15,3,12,19,2,6,255,255,255,252,255,255,255,252,0,0,0,0,
  // 0x30fd  ヽ
  253,48,9,9,27,19,5,2,124,0,0,63,0,0,15,192,0,3,240,0,0,252,0,0,62,0,0,31,128,0,11,192,0,2,64,
  // 0x30fe  ヾ
  254,48,10,12,36,19,5,2,0,1,192,0,56,224,0,29,112,184,14,0,190,0,0,31,128,0,7,224,0,1,244,0,0,189,0,0,47,0,0,15,128,0,6,0,
  // 0x30ff  ヿ
  255,48,12,17,51,19,3,254,127,255,255,127,255,255,0,0,15,0,0,15,0,0,15,0,0,15,0,0,15,0,0,15,0,0,15,0,0,15,0,0,15,0,0,15,0,0,15,0,0,15,0,0,15,0,0,15,0,0,0,
  // 0x4eee  仮
  238,78,18,19,95,19,0,254,0,16,0,0,0,0,117,170,170,160,0,241,255,255,240,1,225,208,0,0,3,193,208,0,0,11,193,208,0,0,31,193,250,170,128,127,193,255,255,208,55,193,252,2,192,19,193,237,3,192,3,194,207,7,128,3,194,203,79,0,3,195,195,222,0,3,195,193,252,0,3,195,128,252,0,3,203,67,254,0,3,207,31,143,208,3,221,125,2,240,1,132,16,0,16,
  // 0x540d  名
  13,84,16,19,76,19,1,254,0,9,0,0,0,46,0,0,0,126,170,64,1,255,255,192,7,208,7,128,47,192,15,0,254,240,46,0,160,188,184,0,0,31,240,0,0,15,192,0,0,127,255,255,2,254,170,175,111,252,0,15,254,60,0,15,160,60,0,15,0,60,0,15,0,62,170,175,0,63,255,255,0,40,0,10,
  // 0x5b9a  定
  154,91,17,19,95,19,1,254,0,1,144,0,0,0,1,208,0,0,106,171,250,170,64,127,255,255,255,64,116,0,0,7,64,116,0,0,7,64,118,170,170,167,64,3,255,255,240,0,0,1,208,0,0,1,65,208,0,0,3,193,208,0,0,3,129,255,252,0,11,129,250,168,0,15,193,208,0,0,31,241,208,0,0,60,127,208,0,0,184,31,255,170,128,240,1,191,255,128,0,0,0,0,0,
  // 0x7247  片
  71,114,16,19,76,19,1,254,0,0,40,0,11,0,60,0,11,0,60,0,11,0,60,0,11,0,60,0,11,255,255,255,11,255,255,255,11,0,0,0,11,0,0,0,11,0,0,0,15,255,255,208,15,255,255,208,15,0,1,208,30,0,1,208,45,0,1,208,60,0,1,208,248,0,1,208,240,0,1,208,16,0,1,144,
  // 0x793a  示
  58,121,17,17,85,19,1,254,15,255,255,252,0,10,170,170,168,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,128,255,255,255,255,192,0,1,208,0,0,0,1,208,0,0,3,129,208,176,0,11,129,208,180,0,15,1,208,60,0,30,1,208,46,0,60,1,208,15,0,248,1,208,11,64,176,1,208,7,64,0,191,208,0,0,0,62,64,0,0,
  // 0x7fa9  義
  169,127,17,19,95,19,1,254,0,64,1,64,0,0,240,3,192,0,21,185,91,213,0,63,255,255,255,0,5,86,229,84,0,15,255,255,252,0,0,1,208,0,0,255,255,255,255,192,85,90,85,85,64,5,191,60,244,0,21,244,44,46,0,85,245,125,90,64,255,255,255,255,192,0,224,15,24,0,191,255,203,188,0,165,229,7,240,64,0,224,127,225,192,31,211,244,191,192,5,1,64,6,0,
  // 0x8868  表
  104,136,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,63,255,255,255,0,42,170,234,170,0,0,1,208,0,0,15,255,255,253,0,5,86,229,84,0,0,1,208,0,0,255,255,255,255,128,106,175,250,170,64,0,126,56,10,0,2,244,44,47,0,127,240,31,248,0,249,240,11,192,0,0,240,3,208,0,0,241,181,244,0,1,255,244,127,64,31,249,0,15,192,9,0,0,1,64,
};

#endif // HAS_GRAPHICAL_TFT
