/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Cyrillic 19pt, capital 'A' height: 14px, width: 100%, range: 0x0401-0x0491, glyphs: 74
extern const uint8_t NotoSans_Medium_Cyrillic_14[3616] = {
  130,14,1,4,145,4,18,251, // unifont_t
  // 0x0401  Ё
  8,17,34,11,2,0,56,52,60,116,0,0,170,168,255,253,240,0,240,0,240,0,240,0,255,252,255,252,240,0,240,0,240,0,240,0,255,253,255,253,
  // 0x0402  Ђ
  255,
  // 0x0403  Ѓ
  255,
  // 0x0404  Є
  11,15,45,12,1,255,0,106,144,7,255,248,31,128,96,61,0,0,120,0,0,180,0,0,255,255,128,255,255,128,244,0,0,184,0,0,124,0,0,63,0,0,15,234,180,2,255,240,0,0,0,
  // 0x0405  Ѕ
  255,
  // 0x0406  І
  6,14,28,7,0,0,42,160,63,240,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,31,144,127,240,
  // 0x0407  Ї
  6,17,34,7,0,0,116,176,116,176,0,0,42,160,63,240,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,31,144,127,240,
  // 0x0408  Ј
  255,
  // 0x0409  Љ
  255,
  // 0x040a  Њ
  255,
  // 0x040b  Ћ
  255,
  // 0x040c  Ќ
  255,
  // 0x040d  Ѝ
  255,
  // 0x040e  Ў
  255,
  // 0x040f  Џ
  255,
  // 0x0410  А
  12,14,42,12,0,0,0,40,0,0,126,0,0,191,0,0,247,64,1,227,192,3,195,192,3,193,224,11,64,240,15,234,244,31,255,248,45,0,60,60,0,45,120,0,31,244,0,15,
  // 0x0411  Б
  9,14,42,12,2,0,170,170,0,255,255,0,240,0,0,240,0,0,240,0,0,240,0,0,255,248,0,255,255,0,240,15,128,240,7,192,240,7,192,240,15,128,250,255,0,255,248,0,
  // 0x0412  В
  10,14,42,12,2,0,170,144,0,255,255,0,240,31,192,240,3,192,240,3,192,240,11,128,255,253,0,255,255,64,240,7,192,240,3,208,240,3,208,240,7,192,250,191,128,255,253,0,
  // 0x0413  Г
  8,14,28,10,2,0,170,169,255,254,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,
  // 0x0414  Д
  13,18,72,14,0,252,0,42,168,0,0,127,253,0,0,180,45,0,0,240,45,0,0,240,45,0,1,240,45,0,2,208,45,0,3,192,45,0,3,192,45,0,11,128,45,0,15,0,45,0,30,0,45,0,191,255,255,192,255,255,255,192,240,0,3,192,240,0,3,192,240,0,3,192,160,0,2,128,
  // 0x0415  Е
  8,14,28,11,2,0,170,168,255,253,240,0,240,0,240,0,240,0,255,252,255,252,240,0,240,0,240,0,240,0,255,253,255,253,
  // 0x0416  Ж
  17,14,70,17,0,0,100,1,128,10,0,60,2,208,46,0,15,2,208,124,0,7,130,208,240,0,2,210,211,208,0,0,246,219,128,0,0,62,239,0,0,0,63,239,0,0,0,246,219,128,0,2,226,211,208,0,7,194,208,240,0,15,2,208,124,0,61,2,208,46,0,184,2,208,15,64,
  // 0x0417  З
  10,15,45,12,1,255,6,168,0,191,255,64,160,11,192,0,3,192,0,3,192,0,15,128,31,249,0,31,254,0,0,11,192,0,2,208,0,2,224,0,3,208,250,175,128,191,253,0,0,0,0,
  // 0x0418  И
  11,14,42,15,2,0,144,0,40,224,0,252,224,2,252,224,3,236,224,15,108,224,46,44,224,60,60,224,244,60,225,224,60,227,192,60,239,64,60,255,0,60,252,0,60,248,0,60,
  // 0x0419  Й
  11,18,54,15,2,0,14,1,208,15,71,192,3,255,64,0,0,0,144,0,40,224,0,252,224,2,252,224,3,236,224,15,108,224,46,44,224,60,60,224,244,60,225,224,60,227,192,60,239,64,60,255,0,60,252,0,60,248,0,60,
  // 0x041a  К
  10,14,42,12,2,0,144,1,144,240,7,192,240,31,0,240,60,0,240,244,0,243,208,0,251,128,0,255,128,0,243,208,0,240,244,0,240,124,0,240,31,0,240,11,192,240,3,224,
  // 0x041b  Л
  12,15,45,14,0,255,0,170,169,0,255,255,0,240,31,1,224,15,1,208,15,2,208,15,2,192,15,3,192,15,3,192,15,3,192,15,7,128,15,15,64,15,175,0,15,253,0,15,0,0,0,
  // 0x041c  М
  14,14,56,17,2,0,164,0,2,144,252,0,11,224,253,0,15,224,239,0,30,224,235,0,61,224,231,128,57,224,227,192,177,224,226,208,241,224,224,225,209,224,224,242,193,224,224,183,193,224,224,63,65,224,224,63,1,224,224,30,1,224,
  // 0x041d  Н
  11,14,42,14,2,0,144,0,96,240,0,180,240,0,180,240,0,180,240,0,180,240,0,180,255,255,244,255,255,244,240,0,180,240,0,180,240,0,180,240,0,180,240,0,180,240,0,180,
  // 0x041e  О
  13,15,60,15,1,255,0,174,64,0,11,255,244,0,47,64,125,0,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,
  // 0x041f  П
  10,14,42,14,2,0,170,170,160,255,255,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,
  // 0x0420  Р
  9,14,42,12,2,0,170,144,0,255,253,0,240,111,0,240,11,128,240,7,128,240,11,128,240,31,0,255,253,0,255,160,0,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,
  // 0x0421  С
  10,15,45,12,1,255,0,106,128,7,255,240,31,128,96,61,0,0,124,0,0,180,0,0,244,0,0,244,0,0,244,0,0,184,0,0,124,0,0,63,0,0,15,234,240,2,255,224,0,0,0,
  // 0x0422  Т
  11,14,42,11,0,0,106,170,160,255,255,244,0,244,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,
  // 0x0423  У
  12,15,45,12,0,255,100,0,10,124,0,46,61,0,60,15,0,120,11,64,244,3,192,240,2,210,208,0,243,192,0,191,128,0,63,0,0,62,0,0,124,0,59,244,0,63,208,0,0,0,0,
  // 0x0424  Ф
  14,15,60,16,1,255,0,14,0,0,0,15,0,0,7,255,248,0,47,239,191,64,124,15,7,192,240,15,2,208,240,15,1,224,240,15,1,224,244,15,2,208,124,15,7,192,47,175,191,64,7,255,248,0,0,15,0,0,0,15,0,0,0,0,0,0,
  // 0x0425  Х
  11,14,42,12,0,0,100,0,40,61,0,184,31,1,240,11,131,192,3,199,128,1,255,0,0,189,0,0,253,0,1,239,0,3,203,128,11,67,208,31,1,240,60,0,184,184,0,60,
  // 0x0426  Ц
  12,18,54,14,2,252,144,0,160,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,255,255,254,255,255,255,0,0,15,0,0,15,0,0,15,0,0,10,
  // 0x0427  Ч
  11,14,42,13,1,0,96,0,36,180,0,120,180,0,120,180,0,120,180,0,120,180,0,120,184,0,120,126,91,248,31,255,248,1,80,120,0,0,120,0,0,120,0,0,120,0,0,120,
  // 0x0428  Ш
  16,14,56,20,2,0,144,2,128,10,240,3,192,15,240,3,192,15,240,3,192,15,240,3,192,15,240,3,192,15,240,3,192,15,240,3,192,15,240,3,192,15,240,3,192,15,240,3,192,15,240,3,192,15,255,255,255,255,255,255,255,255,
  // 0x0429  Щ
  18,18,90,20,2,252,144,2,128,10,0,240,3,192,15,0,240,3,192,15,0,240,3,192,15,0,240,3,192,15,0,240,3,192,15,0,240,3,192,15,0,240,3,192,15,0,240,3,192,15,0,240,3,192,15,0,240,3,192,15,0,240,3,192,15,0,255,255,255,255,144,255,255,255,255,224,0,0,0,1,224,0,0,0,1,224,0,0,0,1,224,0,0,0,0,144,
  // 0x042a  Ъ
  13,14,56,13,0,0,170,128,0,0,255,208,0,0,2,208,0,0,2,208,0,0,2,208,0,0,2,208,0,0,2,255,228,0,2,255,254,0,2,208,31,0,2,208,15,64,2,208,15,64,2,208,31,0,2,251,254,0,2,255,228,0,
  // 0x042b  Ы
  13,14,56,17,2,0,144,0,2,64,240,0,7,192,240,0,7,192,240,0,7,192,240,0,7,192,240,0,7,192,255,244,7,192,255,255,7,192,240,15,71,192,240,7,135,192,240,7,135,192,240,15,71,192,250,255,7,192,255,248,7,192,
  // 0x042c  Ь
  9,14,42,12,2,0,144,0,0,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,255,248,0,255,255,64,240,11,192,240,3,192,240,3,192,240,11,192,250,255,64,255,248,0,
  // 0x042d  Э
  10,15,45,12,1,255,42,160,0,255,254,0,144,31,128,0,3,208,0,2,224,0,1,240,31,255,240,31,255,240,0,0,240,0,1,224,0,3,208,0,11,192,250,191,0,255,248,0,0,0,0,
  // 0x042e  Ю
  17,15,75,20,2,255,144,0,106,128,0,240,3,255,248,0,240,15,192,126,0,240,31,0,15,0,240,61,0,11,128,240,60,0,7,192,255,252,0,3,192,255,252,0,3,192,240,60,0,7,192,240,61,0,7,128,240,46,0,15,64,240,15,64,47,0,240,7,250,252,0,240,0,191,224,0,0,0,0,0,0,
  // 0x042f  Я
  11,14,42,12,0,0,0,106,164,7,255,244,15,144,180,46,0,180,46,0,180,31,0,180,15,144,180,3,255,244,0,245,244,3,208,180,7,192,180,15,0,180,62,0,180,124,0,180,
  // 0x0430  а
  9,12,36,11,1,255,1,80,0,47,253,0,41,31,0,0,11,64,0,11,64,47,255,64,189,11,64,240,11,64,240,15,64,249,191,64,63,227,64,0,0,0,
  // 0x0431  б
  10,16,48,12,1,255,0,1,64,1,191,208,15,250,64,62,0,0,120,0,0,180,84,0,247,255,64,254,11,192,244,3,208,240,2,208,240,2,208,180,2,208,124,3,192,47,175,64,11,253,0,0,0,0,
  // 0x0432  в
  10,10,30,11,1,0,127,255,0,121,91,192,120,3,192,120,11,128,127,254,0,125,95,128,120,3,208,120,3,208,126,175,192,127,254,0,
  // 0x0433  г
  7,10,20,8,1,0,127,252,121,84,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,
  // 0x0434  д
  11,14,42,12,0,252,1,255,224,1,230,224,2,209,224,3,193,224,3,193,224,7,129,224,15,1,224,30,1,224,126,170,248,191,255,252,176,0,44,176,0,44,176,0,44,96,0,24,
  // 0x0435  е
  9,12,36,11,1,255,1,80,0,15,253,0,61,31,64,180,7,128,244,7,192,255,255,192,245,85,64,244,0,0,120,0,0,63,155,64,11,255,64,0,0,0,
  // 0x0436  ж
  15,10,40,15,0,0,60,7,64,240,15,7,67,192,7,135,79,64,2,231,109,0,0,255,248,0,0,251,188,0,3,199,79,0,15,71,71,192,45,7,66,224,184,7,64,180,
  // 0x0437  з
  9,12,36,10,0,255,1,80,0,63,254,0,37,31,64,0,7,64,0,31,0,7,252,0,1,111,0,0,7,192,0,7,192,122,111,64,63,253,0,0,0,0,
  // 0x0438  и
  10,10,30,13,1,0,120,3,240,120,11,240,120,15,240,120,60,240,120,120,240,116,240,240,118,208,240,127,128,240,127,0,240,125,0,240,
  // 0x0439  й
  10,15,45,13,1,0,9,1,128,15,3,192,11,255,64,0,84,0,0,0,0,120,3,240,120,11,240,120,15,240,120,60,240,120,120,240,116,240,240,118,208,240,127,128,240,127,0,240,125,0,240,
  // 0x043a  к
  9,10,30,11,1,0,120,15,64,120,46,0,120,184,0,121,240,0,127,192,0,123,208,0,120,244,0,120,60,0,120,15,0,120,7,192,
  // 0x043b  л
  10,11,33,11,0,255,3,255,240,3,214,240,3,193,240,3,129,240,7,129,240,11,65,240,15,1,240,15,1,240,126,1,240,248,1,240,0,0,0,
  // 0x043c  м
  12,10,30,15,1,0,126,0,63,127,0,63,123,64,191,119,192,235,118,193,219,116,227,203,116,243,139,116,127,11,116,62,11,116,45,11,
  // 0x043d  н
  10,10,30,12,1,0,120,1,224,120,1,224,120,1,224,120,1,224,127,255,224,126,170,224,120,1,224,120,1,224,120,1,224,120,1,224,
  // 0x043e  о
  10,12,36,12,1,255,1,80,0,31,254,0,62,95,128,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,
  // 0x043f  п
  10,10,30,12,1,0,127,255,208,125,86,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,
  // 0x0440  р
  10,16,48,12,1,251,0,84,0,119,255,64,127,91,192,124,3,208,120,1,224,120,1,240,120,1,240,124,2,224,124,3,208,127,175,192,122,254,0,120,0,0,120,0,0,120,0,0,120,0,0,36,0,0,
  // 0x0441  с
  8,12,24,9,1,255,1,80,31,254,62,88,184,0,240,0,240,0,240,0,244,0,184,0,63,173,11,253,0,0,
  // 0x0442  т
  9,10,30,9,0,0,191,255,192,22,245,64,1,224,0,1,224,0,1,224,0,1,224,0,1,224,0,1,224,0,1,224,0,1,224,0,
  // 0x0443  у
  10,15,45,10,0,251,180,1,224,124,3,208,60,3,192,30,7,128,15,15,0,11,79,0,7,157,0,3,252,0,1,248,0,0,244,0,0,240,0,1,224,0,7,192,0,191,64,0,100,0,0,
  // 0x0444  ф
  12,20,60,14,1,251,0,20,0,0,60,0,0,60,0,0,60,0,0,125,0,11,255,224,63,125,188,188,60,47,244,60,15,240,60,15,240,60,15,244,60,15,124,60,46,47,190,252,7,255,224,0,60,0,0,60,0,0,60,0,0,60,0,0,24,0,
  // 0x0445  х
  10,10,30,10,0,0,60,3,208,31,11,128,11,143,0,3,253,0,1,248,0,2,252,0,7,238,0,15,15,64,46,3,192,124,2,224,
  // 0x0446  ц
  11,14,42,12,1,252,120,1,224,120,1,224,120,1,224,120,1,224,120,1,224,120,1,224,120,1,224,120,1,224,126,171,248,127,255,252,0,0,60,0,0,60,0,0,60,0,0,40,
  // 0x0447  ч
  10,10,30,12,1,0,180,2,208,180,2,208,180,2,208,180,2,208,184,7,208,63,255,208,6,146,208,0,2,208,0,2,208,0,2,208,
  // 0x0448  ш
  15,10,40,17,1,0,120,7,128,60,120,7,128,60,120,7,128,60,120,7,128,60,120,7,128,60,120,7,128,60,120,7,128,60,120,7,128,60,126,171,234,188,127,255,255,252,
  // 0x0449  щ
  17,14,70,18,1,252,120,7,128,60,0,120,7,128,60,0,120,7,128,60,0,120,7,128,60,0,120,7,128,60,0,120,7,128,60,0,120,7,128,60,0,120,7,128,60,0,126,171,234,190,0,127,255,255,255,64,0,0,0,11,64,0,0,0,11,64,0,0,0,11,64,0,0,0,6,0,
  // 0x044a  ъ
  13,10,40,13,0,0,255,224,0,0,86,224,0,0,1,224,0,0,1,224,0,0,1,255,252,0,1,229,111,0,1,224,11,64,1,224,15,64,1,250,191,0,1,255,248,0,
  // 0x044b  ы
  13,10,40,15,1,0,120,0,7,128,120,0,7,128,120,0,7,128,120,0,7,128,127,254,7,128,125,111,135,128,120,3,199,128,120,3,199,128,126,175,71,128,127,253,7,128,
  // 0x044c  ь
  10,10,30,11,1,0,120,0,0,120,0,0,120,0,0,120,0,0,127,255,64,125,91,192,120,2,208,120,2,208,126,175,192,127,254,0,
  // 0x044d  э
  9,12,36,9,0,255,5,64,0,63,248,0,36,126,0,0,15,0,0,11,64,31,255,64,10,175,64,0,15,64,0,31,0,121,189,0,127,244,0,0,0,0,
  // 0x044e  ю
  14,12,48,16,1,255,0,0,84,0,120,7,255,64,120,15,87,192,120,45,1,224,120,60,0,240,127,252,0,240,126,188,0,240,120,60,0,240,120,46,2,224,120,15,171,192,120,3,255,0,0,0,0,0,
  // 0x044f  я
  9,10,30,11,0,0,15,255,192,62,87,192,60,3,192,60,3,192,47,171,192,11,255,192,7,131,192,15,3,192,61,3,192,124,3,192,
  // 0x0450  ѐ
  255,
  // 0x0451  ё
  9,15,45,11,1,255,13,28,0,13,44,0,0,0,0,1,80,0,15,253,0,61,31,64,180,7,128,244,7,192,255,255,192,245,85,64,244,0,0,120,0,0,63,155,64,11,255,64,0,0,0,
  // 0x0452  ђ
  255,
  // 0x0453  ѓ
  255,
  // 0x0454  є
  8,12,24,10,1,255,0,80,31,255,62,85,184,0,240,0,255,252,250,164,240,0,184,0,63,106,11,254,0,0,
  // 0x0455  ѕ
  255,
  // 0x0456  і
  3,14,14,5,1,0,120,120,0,0,120,120,120,120,120,120,120,120,120,120,
  // 0x0457  ї
  6,14,28,5,0,0,225,192,225,208,0,0,0,0,30,0,30,0,30,0,30,0,30,0,30,0,30,0,30,0,30,0,30,0,
  // 0x0458  ј
  255,
  // 0x0459  љ
  255,
  // 0x045a  њ
  255,
  // 0x045b  ћ
  255,
  // 0x045c  ќ
  255,
  // 0x045d  ѝ
  255,
  // 0x045e  ў
  255,
  // 0x045f  џ
  255,
  // 0x0460  Ѡ
  255,
  // 0x0461  ѡ
  255,
  // 0x0462  Ѣ
  255,
  // 0x0463  ѣ
  255,
  // 0x0464  Ѥ
  255,
  // 0x0465  ѥ
  255,
  // 0x0466  Ѧ
  255,
  // 0x0467  ѧ
  255,
  // 0x0468  Ѩ
  255,
  // 0x0469  ѩ
  255,
  // 0x046a  Ѫ
  255,
  // 0x046b  ѫ
  255,
  // 0x046c  Ѭ
  255,
  // 0x046d  ѭ
  255,
  // 0x046e  Ѯ
  255,
  // 0x046f  ѯ
  255,
  // 0x0470  Ѱ
  255,
  // 0x0471  ѱ
  255,
  // 0x0472  Ѳ
  255,
  // 0x0473  ѳ
  255,
  // 0x0474  Ѵ
  255,
  // 0x0475  ѵ
  255,
  // 0x0476  Ѷ
  255,
  // 0x0477  ѷ
  255,
  // 0x0478  Ѹ
  255,
  // 0x0479  ѹ
  255,
  // 0x047a  Ѻ
  255,
  // 0x047b  ѻ
  255,
  // 0x047c  Ѽ
  255,
  // 0x047d  ѽ
  255,
  // 0x047e  Ѿ
  255,
  // 0x047f  ѿ
  255,
  // 0x0480  Ҁ
  255,
  // 0x0481  ҁ
  255,
  // 0x0482  ҂
  255,
  // 0x0483  ҃
  255,
  // 0x0484  ҄
  255,
  // 0x0485  ҅
  255,
  // 0x0486  ҆
  255,
  // 0x0487  ҇
  255,
  // 0x0488  ҈
  255,
  // 0x0489  ҉
  255,
  // 0x048a  Ҋ
  255,
  // 0x048b  ҋ
  255,
  // 0x048c  Ҍ
  255,
  // 0x048d  ҍ
  255,
  // 0x048e  Ҏ
  255,
  // 0x048f  ҏ
  255,
  // 0x0490  Ґ
  8,17,34,10,2,0,0,5,0,15,0,15,170,175,255,255,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,
  // 0x0491  ґ
  7,13,26,9,1,0,0,44,0,44,0,60,127,252,121,84,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,
};

#endif // HAS_GRAPHICAL_TFT
