/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../../../inc/MarlinConfigPre.h"

#if ENABLED(DGUS_LCD_UI_E3S1PRO)

#include "DGUS_ScreenSetup.h"
#include "../DGUSSetupHandler.h"

#include "../../ui_api.h"

#define SETUP_HELPER(SCREEN, SETUP) \
  { .screen = SCREEN, \
  .setup_fn = SETUP }

const struct DGUS_ScreenSetup screen_setup_list[] PROGMEM = {
  SETUP_HELPER(DGUS_ScreenID::FILE1, &DGUSSetupHandler::sdCardPrepare),
  SETUP_HELPER(DGUS_ScreenID::FILE2, &DGUSSetupHandler::sdCardPrepare),
  SETUP_HELPER(DGUS_ScreenID::FILE3, &DGUSSetupHandler::sdCardPrepare),
  SETUP_HELPER(DGUS_ScreenID::FILE4, &DGUSSetupHandler::sdCardPrepare),
  SETUP_HELPER((DGUS_ScreenID)0, nullptr)
};

#endif // DGUS_LCD_UI_E3S1PRO
