/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NetworkUtils {
    private static final PatchLogger logger = PatchLogger.getLogger(NetworkUtils.class.getName());
    public static final String ERROR_HOST_NAME = "UNKNOWN-HOST";
    private static final String LOOPBACK_ADDRESS_V4_1 = "127.0.0.1";
    private static final String LOOPBACK_ADDRESS_V4_2 = "127.0.1.1";
    private static final String LOOPBACK_ADDRESS_V6 = "0:0:0:0:0:0:0:1";
    private static final List<String> LOOP_BACK_ADDRESS_LIST = new ArrayList<String>();
    private static volatile String REPRESSENTATION_HOST_IP;
    private static final Pattern pattern;

    private NetworkUtils() {
    }

    public static String getHostName() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            return localHost.getHostName();
        }
        catch (UnknownHostException e) {
            return NetworkUtils.getMachineName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getRepresentationHostIp() {
        if (REPRESSENTATION_HOST_IP != null) return REPRESSENTATION_HOST_IP;
        Class<NetworkUtils> clazz = NetworkUtils.class;
        synchronized (NetworkUtils.class) {
            REPRESSENTATION_HOST_IP = NetworkUtils.getRepresentationHostIp0();
            // ** MonitorExit[var0] (shouldn't be in output)
            return REPRESSENTATION_HOST_IP;
        }
    }

    public static String getRepresentationHostIp0() {
        try {
            String ip = NetworkUtils.getHostIp();
            if (!NetworkUtils.isLoopbackAddress(ip)) {
                return ip;
            }
            List<String> ipList = NetworkUtils.getHostIpList();
            if (!ipList.isEmpty()) {
                return ipList.get(0);
            }
            return LOOPBACK_ADDRESS_V4_1;
        }
        catch (Throwable e) {
            return LOOPBACK_ADDRESS_V4_1;
        }
    }

    public static String getHostIp() {
        String hostIp;
        try {
            InetAddress thisIp = InetAddress.getLocalHost();
            hostIp = thisIp.getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.warning(e.getMessage());
            hostIp = LOOPBACK_ADDRESS_V4_1;
        }
        return hostIp;
    }

    public static List<String> getHostIpList() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (interfaces == null) {
            return Collections.EMPTY_LIST;
        }
        while (interfaces.hasMoreElements()) {
            NetworkInterface current = interfaces.nextElement();
            if (NetworkUtils.isSkipNetworkInterface(current)) continue;
            Enumeration<InetAddress> addresses = current.getInetAddresses();
            while (addresses.hasMoreElements()) {
                String hostAddress;
                InetAddress address = addresses.nextElement();
                if (address.isLoopbackAddress() || NetworkUtils.isLoopbackAddress(hostAddress = address.getHostAddress())) continue;
                result.add(address.getHostAddress());
            }
        }
        return result;
    }

    public static String getHostV4Ip() {
        String hostIp = NetworkUtils.getHostIp();
        if (NetworkUtils.validationIpV4FormatAddress(hostIp)) {
            return hostIp;
        }
        return LOOPBACK_ADDRESS_V4_1;
    }

    public static List<String> getHostV4IpList() {
        List<String> hostIpList = NetworkUtils.getHostIpList();
        ArrayList<String> hostV4IpList = new ArrayList<String>(hostIpList.size());
        for (String ip : hostIpList) {
            if (!NetworkUtils.validationIpV4FormatAddress(ip)) continue;
            hostV4IpList.add(ip);
        }
        return hostV4IpList;
    }

    private static boolean isSkipNetworkInterface(NetworkInterface networkInterface) {
        try {
            return !networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean isLoopbackAddress(String ip) {
        if (ip == null) {
            return true;
        }
        return LOOP_BACK_ADDRESS_LIST.contains(ip);
    }

    public static boolean validationIpV4FormatAddress(String address) {
        try {
            String[] eachDotAddress = address.split("\\.");
            if (eachDotAddress.length != 4) {
                return false;
            }
            for (String eachAddress : eachDotAddress) {
                if (Integer.parseInt(eachAddress) <= 255) continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Deprecated
    public static String getMachineName() {
        try {
            Enumeration<NetworkInterface> enet = NetworkInterface.getNetworkInterfaces();
            while (enet.hasMoreElements()) {
                NetworkInterface net = enet.nextElement();
                if (net.isLoopback()) continue;
                Enumeration<InetAddress> eaddr = net.getInetAddresses();
                while (eaddr.hasMoreElements()) {
                    InetAddress inet = eaddr.nextElement();
                    String canonicalHostName = inet.getCanonicalHostName();
                    if (canonicalHostName.equalsIgnoreCase(inet.getHostAddress())) continue;
                    return canonicalHostName;
                }
            }
            return ERROR_HOST_NAME;
        }
        catch (SocketException e) {
            logger.warning(e.getMessage());
            return ERROR_HOST_NAME;
        }
    }

    public static String getHostFromURL(String urlSpec) {
        if (urlSpec == null) {
            return null;
        }
        try {
            URL url = new URL(urlSpec);
            String host = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                return host;
            }
            return host + ":" + port;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static InetSocketAddress[] generatePublicInternalIntranetAddr(String host, int port) {
        int i;
        String[] parts;
        InetSocketAddress[] res = new InetSocketAddress[3];
        res[0] = new InetSocketAddress(host, port);
        String internalHost = host;
        Matcher matcher = pattern.matcher(host);
        if (!matcher.matches()) {
            res[1] = new InetSocketAddress(host, port);
            res[2] = new InetSocketAddress(host, port);
            return res;
        }
        String intranetHost = host;
        if (!host.contains("-intranet") && !host.contains("-internal")) {
            parts = host.split("\\.");
            intranetHost = parts[0] + "-intranet";
            for (i = 1; i < parts.length; ++i) {
                intranetHost = intranetHost + "." + parts[i];
            }
        }
        res[1] = new InetSocketAddress(intranetHost, port);
        if (!host.contains("-internal") && !host.contains("-intranet")) {
            parts = host.split("\\.");
            internalHost = parts[0] + "-internal";
            for (i = 1; i < parts.length; ++i) {
                internalHost = internalHost + "." + parts[i];
            }
        }
        res[2] = new InetSocketAddress(internalHost, port);
        return res;
    }

    static {
        LOOP_BACK_ADDRESS_LIST.add(LOOPBACK_ADDRESS_V4_1);
        LOOP_BACK_ADDRESS_LIST.add(LOOPBACK_ADDRESS_V4_2);
        LOOP_BACK_ADDRESS_LIST.add(LOOPBACK_ADDRESS_V6);
        pattern = Pattern.compile("[a-z\\-\\.]+\\.aliyuncs\\.com");
    }
}

