/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.sentinel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SentinelOpenSourceCompatibilityUtil {
    private static final Set<String> SENTINEL_PACKAGES_NEEDED_REMOVE = new HashSet<String>(Arrays.asList("sentinel-core", "sentinel-parameter-flow-control", "sentinel-annotation-aspectj", "sentinel-webflow-extension", "sentinel-datasource-extension", "sentinel-datasource-acm", "sentinel-api-gateway-adapter-common", "sentinel-spring-webmvc-adapter", "sentinel-spring-webmvc-v6x-adapter", "sentinel-web-servlet", "sentinel-apache-dubbo-adapter", "sentinel-dubbo-adapter", "sentinel-zuul-adapter", "sentinel-spring-cloud-gateway-adapter", "sentinel-reactor-adapter", "sentinel-spring-webflux-adapter"));
    private static final Set<String> AHAS_PACKAGES = new HashSet<String>(Arrays.asList("ahas-sentinel-client", "spring-boot-starter-ahas-sentinel-client", "spring-cloud-gateway-starter-ahas-sentinel", "spring-cloud-zuul-starter-ahas-sentinel"));
    private static final Set<String> MSE_PACKAGES = new HashSet<String>(Arrays.asList("mse-starter"));
    public static Set<String> sentinelRelatedDependencies = new HashSet<String>();
    private static List<String> removedDependencies = new ArrayList<String>();
    private static Map<String, List<String>> addedDependencies = new HashMap<String, List<String>>();
    private static Map<String, List<String>> datasourceRecord = new HashMap<String, List<String>>();

    static boolean isMseSentinelJar(String jarName) {
        if (jarName == null || jarName.isEmpty()) {
            return false;
        }
        if (!jarName.contains(".jar")) {
            return false;
        }
        for (String m : MSE_PACKAGES) {
            if (!jarName.contains(m)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAhasSentinelJar(String jarName) {
        if (jarName == null || jarName.isEmpty()) {
            return false;
        }
        if (!jarName.contains(".jar")) {
            return false;
        }
        for (String m : AHAS_PACKAGES) {
            if (!jarName.contains(m) || jarName.contains("MSE")) continue;
            return true;
        }
        return false;
    }

    public static boolean isOpenSentinelConflictJar(String jarName) {
        if (jarName == null || jarName.isEmpty()) {
            return false;
        }
        if (!jarName.contains(".jar")) {
            return false;
        }
        if (jarName.contains("ahas")) {
            return false;
        }
        for (String m : SENTINEL_PACKAGES_NEEDED_REMOVE) {
            if (!jarName.contains(m)) continue;
            return true;
        }
        return SentinelOpenSourceCompatibilityUtil.isScaSentinelJar(jarName);
    }

    public static boolean isScaSentinelJar(String jarName) {
        boolean contains = jarName.contains("spring-cloud-starter-alibaba-sentinel") || jarName.contains("spring-cloud-alibaba-sentinel");
        return contains;
    }

    public static void addSentienlRemovedDependencie(String dependencyName) {
        removedDependencies.add(dependencyName);
    }

    public static List<String> getRemovedDependencies() {
        return removedDependencies;
    }

    public static void addSentienlAddedDependencie(String classloaderName, List<String> dependencyName) {
        List dependencyList = addedDependencies.getOrDefault(classloaderName, new ArrayList());
        dependencyList.addAll(dependencyName);
        addedDependencies.put(classloaderName, dependencyList);
    }

    public static Map<String, List<String>> getAddedDependencies() {
        return addedDependencies;
    }

    public static void addDataSourceRecord(String ruleManagerName, String record) {
        List records = datasourceRecord.getOrDefault(ruleManagerName, new ArrayList());
        records.add(record);
        datasourceRecord.put(ruleManagerName, records);
    }

    public static Map<String, List<String>> getDatasourceRecord() {
        return datasourceRecord;
    }
}

