/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.sentinel;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MicroServiceConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Supplier;

public class MseSentinelPropertyManager {
    private static final AliyunJavaAgentLogger LOGGER = AliyunJavaAgentLoggerFactory.getLogger(MseSentinelPropertyManager.class.getName());
    private static volatile boolean sentinelPropertyRegistered = false;
    public static Object flowRuleProperty;
    public static Supplier<String> flowRuleSource;
    public static Object degradeRuleProperty;
    public static Supplier<String> degradeRuleSource;
    public static Object defaultCbRuleProperty;
    public static Supplier<String> defaultCbRuleSource;
    public static Object paramFlowRuleProperty;
    public static Supplier<String> paramFlowRuleSource;
    public static Object webFlowRuleProperty;
    public static Supplier<String> webFlowRuleSource;
    public static Object fallbackDefinitionProperty;
    public static Supplier<String> fallbackDefinitionSource;
    public static Object adaptiveControllerConfigProperty;
    public static Supplier<String> adaptiveControllerConfigSource;
    public static Object whiteListConfigProperty;
    public static Supplier<String> whiteListConfigSource;
    public static Object sentinelEventProperty;
    public static Object parseObjectFunction;

    public static void registerFlowRuleProperty(ClassLoader classloader) throws Exception {
        Class<?> clazz = classloader.loadClass("com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager");
        Class<?> methodClass = classloader.loadClass("com.alibaba.csp.sentinel.property.SentinelProperty");
        Method method = clazz.getDeclaredMethod("register2Property", methodClass);
        method.invoke(null, flowRuleProperty);
        Field currentPropertyField = clazz.getDeclaredField("currentProperty");
        currentPropertyField.setAccessible(true);
        flowRuleSource = () -> {
            try {
                return currentPropertyField.get(null).toString();
            }
            catch (Throwable th) {
                return th.getMessage();
            }
        };
        LOGGER.warn("[MSE] [SENTINEL] [DATASOURCE] [REG] [INFO] Register FlowRuleProperty success, currentPropertyField: {}", (Object)flowRuleSource.get());
    }

    public static void registerDegradeRuleProperty(ClassLoader classloader) throws Exception {
        Class<?> clazz = classloader.loadClass("com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager");
        Class<?> methodClass = classloader.loadClass("com.alibaba.csp.sentinel.property.SentinelProperty");
        Method method = clazz.getDeclaredMethod("register2Property", methodClass);
        method.invoke(null, degradeRuleProperty);
        Field currentPropertyField = clazz.getDeclaredField("currentProperty");
        currentPropertyField.setAccessible(true);
        degradeRuleSource = () -> {
            try {
                return currentPropertyField.get(null).toString();
            }
            catch (Throwable e) {
                return e.getMessage();
            }
        };
        LOGGER.warn("[MSE] [SENTINEL] [DATASOURCE] [REG] [INFO] Register DegradeRuleProperty success, currentPropertyField: {}", (Object)degradeRuleSource.get());
    }

    public static void registerDefaultCbRuleProperty(ClassLoader classloader) throws Exception {
        Class<?> clazz = classloader.loadClass("com.alibaba.csp.sentinel.slots.block.degrade.DefaultCircuitBreakerRuleManager");
        Class<?> methodClass = classloader.loadClass("com.alibaba.csp.sentinel.property.SentinelProperty");
        Method method = clazz.getDeclaredMethod("register2Property", methodClass);
        method.invoke(null, defaultCbRuleProperty);
        Field currentPropertyField = clazz.getDeclaredField("currentProperty");
        currentPropertyField.setAccessible(true);
        defaultCbRuleSource = () -> {
            try {
                return currentPropertyField.get(null).toString();
            }
            catch (Throwable e) {
                return e.getMessage();
            }
        };
        LOGGER.warn("[MSE] [SENTINEL] [DATASOURCE] [REG] [INFO] Register DefaultCbRuleProperty success, currentPropertyField: {}", (Object)defaultCbRuleSource.get());
    }

    public static void registerParamFlowRuleProperty(ClassLoader classloader) throws Exception {
        Class<?> clazz = classloader.loadClass("com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager");
        Class<?> methodClass = classloader.loadClass("com.alibaba.csp.sentinel.property.SentinelProperty");
        Method method = clazz.getDeclaredMethod("register2Property", methodClass);
        method.invoke(null, paramFlowRuleProperty);
        Field currentPropertyField = clazz.getDeclaredField("currentProperty");
        currentPropertyField.setAccessible(true);
        paramFlowRuleSource = () -> {
            try {
                return currentPropertyField.get(null).toString();
            }
            catch (Throwable th) {
                return th.getMessage();
            }
        };
        LOGGER.warn("[MSE] [SENTINEL] [DATASOURCE] [REG] [INFO] Register ParamFlowRuleProperty success, currentPropertyField: {}", (Object)paramFlowRuleSource.get());
    }

    public static void registerWebFlowRuleProperty(ClassLoader classloader) throws Exception {
        Class<?> clazz = classloader.loadClass("com.alibaba.csp.sentinel.webflow.rule.WebFlowRuleManager");
        Class<?> methodClass = classloader.loadClass("com.alibaba.csp.sentinel.property.SentinelProperty");
        Method method = clazz.getDeclaredMethod("register2Property", methodClass);
        method.invoke(null, webFlowRuleProperty);
        Field currentPropertyField = clazz.getDeclaredField("currentProperty");
        currentPropertyField.setAccessible(true);
        webFlowRuleSource = () -> {
            try {
                return currentPropertyField.get(null).toString();
            }
            catch (Throwable th) {
                return th.getMessage();
            }
        };
        LOGGER.warn("[MSE] [SENTINEL] [DATASOURCE] [REG] [INFO] Register WebFlowRuleProperty success, currentPropertyField: {}", (Object)webFlowRuleSource.get());
    }

    public static void registerFallBackDefinitionPropertyAndClassLoader(ClassLoader classLoader) throws Exception {
        Class<?> clazz = classLoader.loadClass("com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfigManager");
        Method instanceMethod = clazz.getDeclaredMethod("getInstance", new Class[0]);
        Object blockFallbackObject = instanceMethod.invoke(null, new Object[0]);
        Class<?> methodClass = classLoader.loadClass("com.alibaba.csp.sentinel.property.SentinelProperty");
        Method method = clazz.getDeclaredMethod("register2Property", methodClass);
        method.invoke(blockFallbackObject, fallbackDefinitionProperty);
        Class<?> utilClass = classLoader.loadClass("com.alibaba.csp.sentinel.setting.fallback.BlockFallbackUtils");
        Method utilMethod = utilClass.getDeclaredMethod("setAppContextClassLoader", ClassLoader.class);
        utilMethod.invoke(null, classLoader);
        if (parseObjectFunction != null) {
            Class<?> functionClass = classLoader.loadClass("com.alibaba.csp.sentinel.util.function.BiFunction");
            Method setParseObjectFunction = utilClass.getDeclaredMethod("setParseObjectFunction", functionClass);
            setParseObjectFunction.invoke(null, parseObjectFunction);
        }
        Field currentPropertyField = clazz.getDeclaredField("currentProperty");
        currentPropertyField.setAccessible(true);
        fallbackDefinitionSource = () -> {
            try {
                return currentPropertyField.get(blockFallbackObject).toString();
            }
            catch (Throwable e) {
                return e.getMessage();
            }
        };
        LOGGER.warn("[MSE] [SENTINEL] [DATASOURCE] [REG] [INFO] Register FallBackDefinitionProperty and ClassLoader success, currentPropertyField: {}", (Object)fallbackDefinitionSource.get());
    }

    public static void registerAdaptiveControllerConfigProperty(ClassLoader classLoader) throws Exception {
        Class<?> clazz = classLoader.loadClass("com.alibaba.csp.sentinel.slots.system.adaptive.AdaptiveControllerRuleManager");
        Class<?> methodClass = classLoader.loadClass("com.alibaba.csp.sentinel.property.SentinelProperty");
        Method method = clazz.getDeclaredMethod("register2Property", methodClass);
        method.invoke(null, adaptiveControllerConfigProperty);
        Field currentPropertyField = clazz.getDeclaredField("currentProperty");
        currentPropertyField.setAccessible(true);
        adaptiveControllerConfigSource = () -> {
            try {
                return currentPropertyField.get(null).toString();
            }
            catch (Throwable th) {
                return th.getMessage();
            }
        };
        LOGGER.warn("[MSE] [SENTINEL] [DATASOURCE] [REG] [INFO] Register AdaptiveControllerConfigProperty success, currentPropertyField: {}", (Object)adaptiveControllerConfigSource.get());
    }

    public static void registerWhiteListConfigProperty(ClassLoader classLoader) throws Exception {
        Class<?> clazz = classLoader.loadClass("com.alibaba.csp.sentinel.whitelist.WhiteListConfigManager");
        Class<?> methodClass = classLoader.loadClass("com.alibaba.csp.sentinel.property.SentinelProperty");
        Method method = clazz.getDeclaredMethod("register2Property", methodClass);
        method.invoke(null, whiteListConfigProperty);
        Field currentPropertyField = clazz.getDeclaredField("currentProperty");
        currentPropertyField.setAccessible(true);
        whiteListConfigSource = () -> {
            try {
                return currentPropertyField.get(null).toString();
            }
            catch (Throwable th) {
                return th.getMessage();
            }
        };
        LOGGER.warn("[MSE] [SENTINEL] [DATASOURCE] [REG] [INFO] Register WhiteListConfigProperty success, currentPropertyField: {}", (Object)whiteListConfigSource.get());
    }

    public static void registerSentinelEventListener(ClassLoader classLoader) throws Exception {
        Class<?> clazz = classLoader.loadClass("com.alibaba.csp.sentinel.event.SentinelEventContext");
        Class<?> methodClass = classLoader.loadClass("com.alibaba.csp.sentinel.event.SentinelEventListener");
        Method method = clazz.getDeclaredMethod("registerListener", methodClass);
        method.invoke(null, sentinelEventProperty);
        LOGGER.warn("[MSE] [SENTINEL] [DATASOURCE] [REG] [INFO] Register SentinelEventListener success");
    }

    public static void registerAllProperty(ClassLoader classLoader) {
        if (classLoader == null) {
            LOGGER.error("[MSE] [SENTINEL] [DATASOURCE] [REG] [ERROR] Fail to register sentinel property into classLoader: classLoader can not be null");
        }
        if (sentinelPropertyRegistered) {
            return;
        }
        LOGGER.warn("[MSE] [SENTINEL] [DATASOURCE] [REG] [INFO] Begin to register sentinel property into classLoader: {}", (Object)classLoader);
        try {
            MseSentinelPropertyManager.registerFlowRuleProperty(classLoader);
            MseSentinelPropertyManager.registerDegradeRuleProperty(classLoader);
            MseSentinelPropertyManager.registerDefaultCbRuleProperty(classLoader);
            MseSentinelPropertyManager.registerParamFlowRuleProperty(classLoader);
            MseSentinelPropertyManager.registerWebFlowRuleProperty(classLoader);
            MseSentinelPropertyManager.registerAdaptiveControllerConfigProperty(classLoader);
            MseSentinelPropertyManager.registerSentinelEventListener(classLoader);
            MseSentinelPropertyManager.registerFallBackDefinitionPropertyAndClassLoader(classLoader);
            MseSentinelPropertyManager.registerWhiteListConfigProperty(classLoader);
            sentinelPropertyRegistered = true;
        }
        catch (Throwable e) {
            MicroServiceConfig.MSE_ENT_SENTINEL_BLOCK = true;
            LOGGER.error("[MSE] [SENTINEL] [DATASOURCE] [REG] [ERROR] Fail to register sentinel property into classLoader: {}", (Object)classLoader, (Object)e);
            LOGGER.error("[MSE] [SENTINEL] [DATASOURCE] [REG] [ERROR] Set MSE_ENT_SENTINEL_BLOCK = true");
        }
        LOGGER.warn("[MSE] [SENTINEL] [DATASOURCE] [REG] [INFO] Finish registering sentinel property into classLoader: {}", (Object)classLoader);
    }

    public static void setSentinelPropertyRegistered(boolean registered) {
        sentinelPropertyRegistered = registered;
    }

    public static void initMseStarter(ClassLoader classLoader) {
        if (classLoader == null) {
            return;
        }
        try {
            Class<?> springInit = classLoader.loadClass("com.aliyun.mse.sentinel.MseSentinelInitConfiguration");
            if (springInit != null) {
                Method method = springInit.getDeclaredMethod("doInit", new Class[0]);
                Object o = springInit.getConstructor(new Class[0]).newInstance(new Object[0]);
                method.invoke(o, new Object[0]);
            }
            LOGGER.warn("[MSE] [SENTINEL] [AGENT] initMseStarter success");
        }
        catch (Throwable t) {
            LOGGER.warn("[MSE] [SENTINEL] [AGENT] initMseStarter failed", t);
        }
    }

    static {
        flowRuleSource = () -> "";
        degradeRuleSource = () -> "";
        defaultCbRuleSource = () -> "";
        paramFlowRuleSource = () -> "";
        webFlowRuleSource = () -> "";
        fallbackDefinitionSource = () -> "";
        adaptiveControllerConfigSource = () -> "";
        whiteListConfigSource = () -> "";
    }
}

