/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.sentinel;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.sentinel.MseSentinelJarLoader;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class MseSentinelJarLoaderHolder {
    private static final AliyunJavaAgentLogger LOGGER = AliyunJavaAgentLoggerFactory.getLogger(MseSentinelJarLoaderHolder.class.getName());
    private static MseSentinelJarLoader mseSentinelJarLoader;

    public static void loadSentinelSpringBootRelatedJar2ClassLoader(ClassLoader classLoader) {
        if (mseSentinelJarLoader != null) {
            mseSentinelJarLoader.loadSentinelSpringBootRelatedJar2ClassLoader(classLoader);
        } else {
            LOGGER.error("[MSE] [SENTINEL] [DEP] [BOOT] [ERROR] Try to loadSentinelSpringBootRelatedJar2ClassLoader, but MseSentinelJarLoader is not yet registered");
        }
    }

    public static void loadSentinelZuulRelatedJar2ClassLoader(ClassLoader classLoader) {
        if (mseSentinelJarLoader != null) {
            mseSentinelJarLoader.loadSentinelZuulRelatedJar2ClassLoader(classLoader);
        } else {
            LOGGER.error("[MSE] [SENTINEL] [DEP] [ZUUL] [ERROR] Try to loadSentinelZuulRelatedJar2ClassLoader, but MseSentinelJarLoader is not yet registered");
        }
    }

    public static void loadSentinelSpringCloudGatewayRelatedJar2ClassLoader(ClassLoader classLoader) {
        if (mseSentinelJarLoader != null) {
            mseSentinelJarLoader.loadSentinelSpringCloudGatewayRelatedJar2ClassLoader(classLoader);
        } else {
            LOGGER.error("[MSE] [SENTINEL] [DEP] [SCG] [ERROR] Try to loadSentinelSpringCloudGatewayRelatedJar2ClassLoader, but MseSentinelJarLoader is not yet registered");
        }
    }

    public static void loadSentinelApacheDubboRelatedJar2ClassLoader(ClassLoader classLoader) {
        if (mseSentinelJarLoader != null) {
            mseSentinelJarLoader.loadSentinelApacheDubboRelatedJar2ClassLoader(classLoader);
        } else {
            LOGGER.error("[MSE] [SENTINEL] [DEP] [APACHE_DUBBO] [ERROR] Try to loadSentinelApacheDubboRelatedJar2ClassLoader, but MseSentinelJarLoader is not yet registered");
        }
    }

    public static void loadSentinelAlibabaDubboRelatedJar2ClassLoader(ClassLoader classLoader) {
        if (mseSentinelJarLoader != null) {
            mseSentinelJarLoader.loadSentinelAlibabaDubboRelatedJar2ClassLoader(classLoader);
        } else {
            LOGGER.error("[MSE] [SENTINEL] [DEP] [ALI_DUBBO] [ERROR] Try to loadSentinelAlibabaDubboRelatedJar2ClassLoader, but MseSentinelJarLoader is not yet registered");
        }
    }

    public static void loadSentinelSpringMVCRelatedJar2ClassLoader(ClassLoader classLoader) {
        if (mseSentinelJarLoader != null) {
            mseSentinelJarLoader.loadSentinelSpringMVCRelatedJar2ClassLoader(classLoader);
        } else {
            LOGGER.error("[MSE] [SENTINEL] [DEP] [MVC] [ERROR] Try to loadSentinelSpringMVCRelatedJar2ClassLoader, but MseSentinelJarLoader is not yet registered");
        }
    }

    public static void loadSentinelTomcatServletRelatedJar2ClassLoader(ClassLoader classLoader) {
        if (mseSentinelJarLoader != null) {
            mseSentinelJarLoader.loadSentinelTomcatServletRelatedJar2ClassLoader(classLoader);
        } else {
            LOGGER.error("[MSE] [SENTINEL] [DEP] [SERVLET] [ERROR] Try to loadSentinelTomcatServletRelatedJar2ClassLoader, but MseSentinelJarLoader is not yet registered");
        }
    }

    public static void registerMseSentinelJarLoader(MseSentinelJarLoader mseSentinelJarLoader) {
        if (mseSentinelJarLoader != null) {
            MseSentinelJarLoaderHolder.mseSentinelJarLoader = mseSentinelJarLoader;
        }
        LOGGER.warn("[MSE] [SENTINEL] [AGENT] [INIT] [INFO] MseSentinelJarLoader is registered");
    }

    public static Enumeration<URL> getSentinelSpiURL(String resourceName) {
        if (mseSentinelJarLoader != null) {
            return mseSentinelJarLoader.getSentinelSpiURL(resourceName);
        }
        LOGGER.error("[MSE] [SENTINEL] [AGENT] [INIT] [ERROR] Try to getSentinelSpiURL, but MseSentinelJarLoader is not yet registered");
        return new EmptyEnumeration<URL>();
    }

    public static class EmptyEnumeration<E>
    implements Enumeration<E> {
        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public E nextElement() {
            throw new NoSuchElementException();
        }
    }
}

