/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.scg;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.JsonMarshaler;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.State;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Callback;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.DataId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Endpoint;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.GroupId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Namespace;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.scg.SCGConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.scg.SCGRouteDefinition;

@Endpoint(value=ConfigEnum.MSE_APP_CONFIG_ENDPOINT)
@Namespace(value=ConfigEnum.MSE_APP_CONFIG_NAMESPACE)
@GroupId(value=ConfigEnum.ARMS_APP_CONFIG_GROUP_ID)
public class SCGState
extends State {
    private static final AliyunJavaAgentLogger logger = AliyunJavaAgentLoggerFactory.getLogger(SCGState.class.getName());

    public SCGState() {
        super.registerConfigInstance(this);
    }

    @DataId(value=ConfigEnum.EDAS_SCG_ROUTE_DATA_ID)
    @Callback
    public void routesCallback(String configInfo) {
        logger.warn("SCGRouteListener changed, {}", (Object)configInfo);
        if (StringUtils.isEmpty(configInfo)) {
            return;
        }
        try {
            JsonMarshaler jsonMarshaler = GlobalInstanceHolder.getInstance(JsonMarshaler.class);
            SCGConstants.routes = jsonMarshaler.parseMap(configInfo, String.class, SCGRouteDefinition.class);
            SCGConstants.routesNeedUpdate.set(true);
        }
        catch (Throwable t) {
            logger.warn("SCGRouteListener parse error: " + t.getMessage(), t);
        }
    }

    @DataId(value=ConfigEnum.EDAS_SCG_DEFAULT_FILTERS_DATA_ID)
    @Callback
    public void defaultFiltersCallback(String configInfo) {
        logger.warn("SCGDefaultFiltersListener changed, {}", (Object)configInfo);
        if (StringUtils.isEmpty(configInfo)) {
            return;
        }
        try {
            JsonMarshaler jsonMarshaler = GlobalInstanceHolder.getInstance(JsonMarshaler.class);
            SCGConstants.defaultFilters = jsonMarshaler.parseArray(configInfo, String.class);
            SCGConstants.defaultFiltersNeedUpdate.set(true);
            SCGConstants.routesNeedUpdate.set(true);
        }
        catch (Throwable t) {
            logger.warn("SCGDefaultFiltersListener parse error: " + t.getMessage(), t);
        }
    }
}

