/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.outlier;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MicroServiceConfig;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.outlier.OutlierConfig;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.outlier.StatisticsData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ServiceQuality {
    private static final AliyunJavaAgentLogger LOGGER = AliyunJavaAgentLoggerFactory.getLogger(ServiceQuality.class.getName());
    private static ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, StatisticsData>>> STATISTICS_MAP = new ConcurrentHashMap();
    private static ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("service.quality.cleanWorker-" + thread.getId());
            return thread;
        }
    });
    private static OutlierConfig DUBBO_OUTLIER_CONFIG = OutlierConfig.newInstance("7");
    private static OutlierConfig SC_OUTLIER_CONFIG = OutlierConfig.newInstance("25");
    private static final int REMAIN_NUMBER = 10;
    private static final long CLEAN_UP_INTERVAL = 30000L;
    private static final long OUT_DATE_TIME = 60000L;
    private static final ConcurrentMap<String, Map<String, List<QualityData>>> DATA = new ConcurrentHashMap<String, Map<String, List<QualityData>>>();
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void record(long timestamp, String url, String rpcType, String dst, long bizErrCount, long count, long error, double avgRt) {
        int windowSize;
        if (!DUBBO_OUTLIER_CONFIG.isOutlierEnabled() && !SC_OUTLIER_CONFIG.isOutlierEnabled()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (rpcType.equalsIgnoreCase("7")) {
            windowSize = DUBBO_OUTLIER_CONFIG.getTimeWindowInSeconds();
        } else if (rpcType.equalsIgnoreCase("25")) {
            windowSize = SC_OUTLIER_CONFIG.getTimeWindowInSeconds();
        } else {
            return;
        }
        long since = now - (long)(windowSize * 1000);
        DATA.putIfAbsent(dst, new HashMap());
        if (STATISTICS_MAP.size() > MicroServiceConfig.getOutlierMapMaxSize()) {
            LOGGER.warn("STATISTICS_MAP size has reached the threshold, {}", (Object)STATISTICS_MAP.size());
            return;
        }
        STATISTICS_MAP.putIfAbsent(dst, new ConcurrentHashMap());
        Map q = (Map)DATA.get(dst);
        ConcurrentHashMap<String, ConcurrentHashMap<String, StatisticsData>> rpcTypeToDataMap = STATISTICS_MAP.get(dst);
        rpcTypeToDataMap.putIfAbsent(rpcType, new ConcurrentHashMap());
        ConcurrentHashMap<String, StatisticsData> urlToDataMap = rpcTypeToDataMap.get(rpcType);
        if (urlToDataMap.size() > MicroServiceConfig.getOutlierMapMaxSize()) {
            LOGGER.debug("{} 's url map size has reached the threshold, {}", (Object)dst, (Object)urlToDataMap.size());
            return;
        }
        urlToDataMap.putIfAbsent(url, new StatisticsData());
        if (!q.containsKey(url)) {
            ArrayList list = new ArrayList();
            q.put(url, list);
        }
        List d = (List)q.get(url);
        StatisticsData statisticsData = urlToDataMap.get(url);
        long countTmp = 0L;
        long rtCountTmp = 0L;
        long bizErrTmp = 0L;
        long errorTmp = 0L;
        try {
            Object object = LOCK;
            synchronized (object) {
                d.add(new QualityData(rpcType, bizErrCount, timestamp, count, avgRt, error));
                if (d.size() > 10) {
                    d.remove(d.get(0));
                }
                while (d.size() > 0 && ((QualityData)d.get(0)).seconds < since) {
                    d.remove(d.get(0));
                }
                for (QualityData qualityData : d) {
                    countTmp += qualityData.getCount();
                    rtCountTmp = (long)((double)rtCountTmp + qualityData.getRt());
                    bizErrTmp += qualityData.getBizErr();
                    errorTmp += qualityData.getError();
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("record error:" + e.getMessage());
        }
        statisticsData.setCount(countTmp);
        statisticsData.setRtCount(rtCountTmp);
        statisticsData.setBizErr(bizErrTmp);
        statisticsData.setError(errorTmp);
        statisticsData.setAvgRt((double)rtCountTmp / (double)d.size());
        statisticsData.setSuccessRate(1.0 - 1.0 * (double)(errorTmp + bizErrTmp) / (double)countTmp);
        statisticsData.setSuccessRateSys(1.0 - 1.0 * (double)errorTmp / (double)countTmp);
        statisticsData.setQps((double)countTmp / (double)windowSize);
        statisticsData.setLastInvokeTimeStamp(now);
        if (statisticsData.getError() > 0L) {
            LOGGER.warn("[metrics] dst" + dst + " statisticsData" + statisticsData);
        }
    }

    public static StatisticsData query(String ipPort, String rpcType, String url) {
        if (STATISTICS_MAP.size() <= 0) {
            return new StatisticsData();
        }
        return STATISTICS_MAP.get(ipPort).get(rpcType).get(url);
    }

    public static Map<String, StatisticsData> query(String ipPort, String rpcType) {
        if (STATISTICS_MAP.size() <= 0) {
            return null;
        }
        if (STATISTICS_MAP.get(ipPort) == null) {
            return null;
        }
        return STATISTICS_MAP.get(ipPort).get(rpcType);
    }

    static {
        SCHEDULED_EXECUTOR_SERVICE.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<String> removeEndpointList = new ArrayList<String>();
                    for (Map.Entry endpointEntry : STATISTICS_MAP.entrySet()) {
                        boolean endPointHasBeenRecordRecently = false;
                        String endpoint = (String)endpointEntry.getKey();
                        ArrayList<String> removeRpcTypeList = new ArrayList<String>();
                        for (Map.Entry rpcTypeEntry : ((ConcurrentHashMap)endpointEntry.getValue()).entrySet()) {
                            boolean rpcTypeHasBeenRecordRecently = false;
                            String rpcType = (String)rpcTypeEntry.getKey();
                            ArrayList<String> removeUrlList = new ArrayList<String>();
                            for (Map.Entry statisticsEntry : ((ConcurrentHashMap)rpcTypeEntry.getValue()).entrySet()) {
                                String url = (String)statisticsEntry.getKey();
                                StatisticsData statisticsData = (StatisticsData)statisticsEntry.getValue();
                                if (statisticsData.getLastInvokeTimeStamp() < System.currentTimeMillis() - 60000L) {
                                    removeUrlList.add(url);
                                    continue;
                                }
                                rpcTypeHasBeenRecordRecently = true;
                            }
                            for (String url : removeUrlList) {
                                ((ConcurrentHashMap)rpcTypeEntry.getValue()).remove(url);
                            }
                            if (!rpcTypeHasBeenRecordRecently) {
                                removeRpcTypeList.add(rpcType);
                                continue;
                            }
                            endPointHasBeenRecordRecently = true;
                        }
                        for (String rpcType : removeRpcTypeList) {
                            ((ConcurrentHashMap)endpointEntry.getValue()).remove(rpcType);
                        }
                        if (endPointHasBeenRecordRecently) continue;
                        removeEndpointList.add(endpoint);
                    }
                    for (String endpoint : removeEndpointList) {
                        STATISTICS_MAP.remove(endpoint);
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("scheduler clean up STATISTICS_MAP error,", t);
                }
            }
        }, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    public static class QualityData {
        private String rpcType;
        private long bizErr;
        private long seconds;
        private long count;
        private double rt;
        private long error;

        public QualityData() {
        }

        public QualityData(String rpcType, long bizErr, long seconds, long count, double rt, long error) {
            this.rpcType = rpcType;
            this.bizErr = bizErr;
            this.seconds = seconds;
            this.count = count;
            this.rt = rt;
            this.error = error;
        }

        public String getRpcType() {
            return this.rpcType;
        }

        public void setRpcType(String rpcType) {
            this.rpcType = rpcType;
        }

        public long getBizErr() {
            return this.bizErr;
        }

        public void setBizErr(long bizErr) {
            this.bizErr = bizErr;
        }

        public long getSeconds() {
            return this.seconds;
        }

        public void setSeconds(long seconds) {
            this.seconds = seconds;
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public double getRt() {
            return this.rt;
        }

        public void setRt(double rt) {
            this.rt = rt;
        }

        public long getError() {
            return this.error;
        }

        public void setError(long error) {
            this.error = error;
        }

        public String toString() {
            return "QualityData{rpcType='" + this.rpcType + '\'' + ", bizErr=" + this.bizErr + ", seconds=" + this.seconds + ", count=" + this.count + ", rt=" + this.rt + ", error=" + this.error + '}';
        }
    }
}

