/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.outlier;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MicroServiceCommonUtil;
import java.util.concurrent.ConcurrentHashMap;

public class OutlierConfig {
    public static ConcurrentHashMap<String, OutlierConfig> rpcTypeToQosConfigMap = new ConcurrentHashMap();
    private static final AliyunJavaAgentLogger LOGGER = AliyunJavaAgentLoggerFactory.getLogger(OutlierConfig.class.getName());
    public static final String DUBBO_RPCTYPE = "7";
    public static final String SC_RPCTYPE = "25";
    public static final String CONFIG_KEY = "profiler";
    private volatile String rpcType = "";
    private volatile boolean isOutlierEnabled = false;
    private volatile boolean shouldCountBizError = true;
    private volatile int timeWindowInSeconds = 10;
    private volatile int requestThreshold = 1;
    private volatile double errorRateThreshold = 0.5;
    private volatile double maxIsolationRate = 0.1;
    private volatile long isolationTime = 30000L;
    private volatile long maxIsolationTimeMultiple = 40L;

    public static OutlierConfig newInstance(String rpcType) {
        OutlierConfig outlierConfig = rpcTypeToQosConfigMap.get(rpcType);
        if (outlierConfig != null) {
            return outlierConfig;
        }
        OutlierConfig newOutlierConfig = new OutlierConfig(rpcType);
        outlierConfig = rpcTypeToQosConfigMap.putIfAbsent(rpcType, newOutlierConfig);
        if (outlierConfig == null) {
            outlierConfig = newOutlierConfig;
        }
        return outlierConfig;
    }

    public OutlierConfig(String rpcType) {
        this.rpcType = rpcType;
        if (rpcType.length() > 0) {
            try {
                String pre = CONFIG_KEY + (rpcType.equalsIgnoreCase(SC_RPCTYPE) ? ".sc." : ".dubbo.");
                this.isOutlierEnabled = Boolean.valueOf(MicroServiceCommonUtil.getSystemParameter(pre + "isOutlierEnabled", "false"));
                this.shouldCountBizError = Boolean.valueOf(MicroServiceCommonUtil.getSystemParameter(pre + "shouldCountBizError", "true"));
                this.timeWindowInSeconds = Integer.valueOf(MicroServiceCommonUtil.getSystemParameter(pre + "timeWindowInSeconds", "10"));
                this.requestThreshold = Integer.valueOf(MicroServiceCommonUtil.getSystemParameter(pre + "requestThreshold", "1"));
                this.errorRateThreshold = Double.valueOf(MicroServiceCommonUtil.getSystemParameter(pre + "errorRateThreshold", "0.5"));
                this.maxIsolationRate = Double.valueOf(MicroServiceCommonUtil.getSystemParameter(pre + "maxIsolationRate", "0.1"));
                this.isolationTime = Long.valueOf(MicroServiceCommonUtil.getSystemParameter(pre + "isolationTime", "30000"));
                this.maxIsolationTimeMultiple = Long.valueOf(MicroServiceCommonUtil.getSystemParameter(pre + "maxIsolationTimeMultiple", "40"));
            }
            catch (Exception e) {
                LOGGER.warn("OutlierConfig error from System getProperty ", e);
            }
            LOGGER.warn("OutlierConfig from System getProperty " + this);
        }
    }

    public boolean isShouldCountBizError() {
        return this.shouldCountBizError;
    }

    public void setShouldCountBizError(boolean shouldCountBizError) {
        this.shouldCountBizError = shouldCountBizError;
    }

    public boolean isOutlierEnabled() {
        return this.isOutlierEnabled;
    }

    public int getTimeWindowInSeconds() {
        return this.timeWindowInSeconds;
    }

    public int getRequestThreshold() {
        return this.requestThreshold;
    }

    public double getErrorRateThreshold() {
        return this.errorRateThreshold;
    }

    public double getMaxIsolationRate() {
        return this.maxIsolationRate;
    }

    public long getIsolationTime() {
        return this.isolationTime;
    }

    public long getMaxIsolationTimeMultiple() {
        return this.maxIsolationTimeMultiple;
    }

    public String getRpcType() {
        return this.rpcType;
    }

    public void setRpcType(String rpcType) {
        this.rpcType = rpcType;
    }

    public void setOutlierEnabled(boolean outlierEnabled) {
        this.isOutlierEnabled = outlierEnabled;
    }

    public void setTimeWindowInSeconds(int timeWindowInSeconds) {
        this.timeWindowInSeconds = timeWindowInSeconds;
    }

    public void setRequestThreshold(int requestThreshold) {
        this.requestThreshold = requestThreshold;
    }

    public void setErrorRateThreshold(double errorRateThreshold) {
        if (errorRateThreshold >= 0.0 && errorRateThreshold <= 1.0) {
            this.errorRateThreshold = errorRateThreshold;
        }
    }

    public void setMaxIsolationRate(double maxIsolationRate) {
        if (maxIsolationRate >= 0.0 && maxIsolationRate <= 1.0) {
            this.maxIsolationRate = maxIsolationRate;
        }
    }

    public void setIsolationTime(long isolationTime) {
        this.isolationTime = isolationTime;
    }

    public void setMaxIsolationTimeMultiple(long maxIsolationTimeMultiple) {
        this.maxIsolationTimeMultiple = maxIsolationTimeMultiple;
    }

    public String toString() {
        return "OutlierConfig{rpcType='" + this.rpcType + '\'' + ", isOutlierEnabled=" + this.isOutlierEnabled + ", shouldCountBizError=" + this.shouldCountBizError + ", timeWindowInSeconds=" + this.timeWindowInSeconds + ", requestThreshold=" + this.requestThreshold + ", errorRateThreshold=" + this.errorRateThreshold + ", maxIsolationRate=" + this.maxIsolationRate + ", isolationTime=" + this.isolationTime + ", maxIsolationTimeMultiple=" + this.maxIsolationTimeMultiple + '}';
    }
}

