/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.builder;

import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.TypeDefinition;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.TypeDefinitionBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.builder.TypeBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.ClassUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class MapTypeBuilder
implements TypeBuilder {
    @Override
    public boolean accept(Type type, Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Map.class.isAssignableFrom(clazz);
    }

    @Override
    public TypeDefinition build(Type type, Class<?> clazz, TypeDefinitionBuilder typeDefinitionBuilder, Map<String, TypeDefinition> typeCache) {
        if (!(type instanceof ParameterizedType)) {
            TypeDefinition td = new TypeDefinition(clazz.getCanonicalName());
            typeCache.put(td.getType(), td);
            return td;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Object[] actualTypeArgs = parameterizedType.getActualTypeArguments();
        if (actualTypeArgs == null || actualTypeArgs.length != 2) {
            throw new IllegalArgumentException(MessageFormat.format("[ServiceDefinitionBuilder] Map type [{0}] with unexpected amount of arguments [{1}]." + Arrays.toString(actualTypeArgs), type, actualTypeArgs));
        }
        String canonicalName = ClassUtils.getCanonicalNameForParameterizedType(parameterizedType);
        if (typeCache.containsKey(canonicalName)) {
            return typeCache.get(canonicalName);
        }
        TypeDefinition td = new TypeDefinition(canonicalName);
        typeCache.put(canonicalName, td);
        ArrayList<String> tdList = new ArrayList<String>();
        for (Object actualType : actualTypeArgs) {
            TypeDefinition itemTypeDefinition;
            if (actualType instanceof ParameterizedType) {
                Class rawType = (Class)((ParameterizedType)actualType).getRawType();
                itemTypeDefinition = TypeDefinitionBuilder.build((Type)actualType, rawType, typeDefinitionBuilder, typeCache);
                tdList.add(itemTypeDefinition.getType());
                continue;
            }
            if (!(actualType instanceof Class)) continue;
            Class actualClass = (Class)actualType;
            itemTypeDefinition = TypeDefinitionBuilder.build(null, actualClass, typeDefinitionBuilder, typeCache);
            tdList.add(itemTypeDefinition.getType());
        }
        td.setItems(tdList);
        return td;
    }
}

