/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.builder;

import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.TypeDefinition;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.TypeDefinitionBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.builder.TypeBuilder;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;

public class EnumTypeBuilder
implements TypeBuilder {
    @Override
    public boolean accept(Type type, Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz.isEnum();
    }

    @Override
    public TypeDefinition build(Type type, Class<?> clazz, TypeDefinitionBuilder typeDefinitionBuilder, Map<String, TypeDefinition> typeCache) {
        String canonicalName = clazz.getCanonicalName();
        if (typeCache.containsKey(canonicalName)) {
            return typeCache.get(canonicalName);
        }
        TypeDefinition td = new TypeDefinition(canonicalName);
        try {
            Method methodValues = clazz.getDeclaredMethod("values", new Class[0]);
            for (Object value : (Object[])methodValues.invoke(clazz, new Object[0])) {
                td.getEnums().add(value.toString());
            }
        }
        catch (Throwable t) {
            td.setId("-1");
        }
        typeCache.put(canonicalName, td);
        typeDefinitionBuilder.getTypeDiffList().add(td);
        return td;
    }
}

