/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MicroServiceConfig;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.event.EventTypeEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.event.MicroServiceEvent;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.event.MseEventUploader;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.MethodApi;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.MethodDefinition;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.MicroServiceMetaData;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.ParameterDefinition;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.TypeDefinition;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.TypeDefinitionBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.ApplicationInfoUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.ClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public final class ServiceDefinitionBuilder {
    private static final PatchLogger LOGGER = PatchLogger.getLogger(ServiceDefinitionBuilder.class.getName());
    private static Method getParameters;
    private static Method getName;
    private static Map<Method, MethodApi> methodApiMap;

    public static MicroServiceMetaData buildDubboFullDefinition(Class<?> interfaceClass, Map<String, String> params) {
        MicroServiceMetaData sd = new MicroServiceMetaData();
        ServiceDefinitionBuilder.build(sd, interfaceClass);
        sd.setParameters(params);
        return sd;
    }

    public static MicroServiceMetaData buildSpringCloudFullDefinition(Map<String, String> params, Map<Method, MethodApi> apiMap) {
        MicroServiceMetaData sd = new MicroServiceMetaData();
        methodApiMap = apiMap;
        ServiceDefinitionBuilder.build(sd, apiMap);
        sd.setParameters(params);
        return sd;
    }

    private static void build(MicroServiceMetaData sd, Class<?> interfaceClass) {
        MseEventUploader mseEventUploader = GlobalInstanceHolder.getInstance(MseEventUploader.class);
        sd.setCanonicalName(interfaceClass.getCanonicalName());
        sd.setCodeSource(ClassUtils.getCodeSource(interfaceClass));
        HashMap<String, TypeDefinition> types = new HashMap<String, TypeDefinition>();
        TypeDefinitionBuilder builder = new TypeDefinitionBuilder();
        List<Method> methods = ClassUtils.getPublicNonStaticMethods(interfaceClass);
        for (Method method : methods) {
            if (ApplicationInfoUtil.CURRENT_ANAL_DUBBO_METHOD_COUNT.get() >= MicroServiceConfig.MetadataConfig.getMetadataMethodMaxSize()) {
                LOGGER.log(Level.WARNING, "METADATA REPORT,method size beyond max size {}, method size {}", new Object[]{MicroServiceConfig.MetadataConfig.getMetadataMethodMaxSize(), ApplicationInfoUtil.CURRENT_ANAL_DUBBO_METHOD_COUNT.get()});
                sd.setCutOff("4");
                String result = "metadata beyond max size, current method size " + ApplicationInfoUtil.CURRENT_ANAL_DUBBO_METHOD_COUNT.get();
                MicroServiceEvent event = new MicroServiceEvent("DUBBO", EventTypeEnum.ACTIVE_TRACE_Method_Cutoff, result);
                mseEventUploader.uploadEventAsync(event);
                break;
            }
            MethodDefinition md = ServiceDefinitionBuilder.buildMethod(method, builder, types);
            sd.getMethods().add(md);
            ApplicationInfoUtil.CURRENT_ANAL_DUBBO_METHOD_COUNT.incrementAndGet();
        }
        sd.setTypes(types);
    }

    private static void build(MicroServiceMetaData sd, Map<Method, MethodApi> apiMap) {
        MseEventUploader mseEventUploader = GlobalInstanceHolder.getInstance(MseEventUploader.class);
        TypeDefinitionBuilder builder = new TypeDefinitionBuilder();
        int count = 0;
        HashMap<String, TypeDefinition> types = new HashMap<String, TypeDefinition>();
        for (Map.Entry<Method, MethodApi> entry : apiMap.entrySet()) {
            try {
                if (count >= MicroServiceConfig.MetadataConfig.getMetadataMethodMaxSize()) {
                    LOGGER.log(Level.WARNING, "METADATA REPORT,method size beyond max size {}, method size {}", new Object[]{MicroServiceConfig.MetadataConfig.getMetadataMethodMaxSize(), count});
                    String result = "metadata beyond max size, current method size " + count;
                    MicroServiceEvent event = new MicroServiceEvent("SPRING CLOUD", EventTypeEnum.ACTIVE_TRACE_Method_Cutoff, result);
                    mseEventUploader.uploadEventAsync(event);
                    break;
                }
                Method method = entry.getKey();
                MethodDefinition md = ServiceDefinitionBuilder.buildMethod(method, builder, types);
                MethodApi methodApi = entry.getValue();
                ServiceDefinitionBuilder.buildMethodApi(md, methodApi);
                sd.getMethods().add(md);
                ++count;
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "METADATA REPORT, build method error,", t);
            }
        }
        Collections.sort(sd.getMethods(), MethodDefinition.comparator);
        sd.setTypes(types);
    }

    private static MethodDefinition buildMethod(Method method, TypeDefinitionBuilder builder, Map<String, TypeDefinition> types) {
        MethodDefinition md = new MethodDefinition();
        md.setName(method.getName());
        Class<?>[] paramTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Type[] genericParamTypes = method.getGenericParameterTypes();
        ArrayList<ParameterDefinition> parameterDefinitions = new ArrayList<ParameterDefinition>();
        String[] parameterTypes = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            TypeDefinition td = builder.build(genericParamTypes[i], paramTypes[i], types);
            parameterTypes[i] = td.getType();
            MethodApi methodApi = methodApiMap.get(method);
            String paramName = null;
            for (int j = 0; j < parameterAnnotations[i].length && StringUtils.isEmpty(paramName); ++j) {
                try {
                    Annotation annotation = parameterAnnotations[i][j];
                    String annotationName = annotation.annotationType().getCanonicalName();
                    if (!"org.springframework.web.bind.annotation.PathVariable".equals(annotationName) && !"org.springframework.web.bind.annotation.RequestParam".equals(annotationName) || !StringUtils.isEmpty(paramName = (String)annotation.getClass().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]))) continue;
                    paramName = (String)annotation.getClass().getMethod("name", new Class[0]).invoke((Object)annotation, new Object[0]);
                    continue;
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, "Cannot get name from annotation", t);
                }
            }
            if (StringUtils.isEmpty(paramName)) {
                paramName = ServiceDefinitionBuilder.getParameterName(method, i);
            }
            ParameterDefinition parameterDefinition = new ParameterDefinition();
            parameterDefinition.setName(paramName);
            List<Object> descriptions = Collections.emptyList();
            if (methodApi != null) {
                descriptions = methodApi.getParameterDescriptions();
            }
            if (i < descriptions.size()) {
                parameterDefinition.setDescription(methodApi.getParameterDescriptions().get(i));
            } else {
                parameterDefinition.setDescription("");
            }
            parameterDefinition.setType(td.getType());
            parameterDefinitions.add(parameterDefinition);
        }
        md.setParameterDefinitions(parameterDefinitions);
        md.setParameterTypes(parameterTypes);
        TypeDefinition td = builder.build(method.getGenericReturnType(), method.getReturnType(), types);
        md.setReturnType(td.getType());
        return md;
    }

    private static String getParameterName(Method method, int paramIndex) {
        String name = null;
        if (getParameters == null || getName == null) {
            LOGGER.log(Level.WARNING, "jdk doesn't support getParameters method");
        } else {
            try {
                Object[] parameters = (Object[])getParameters.invoke((Object)method, new Object[0]);
                if (parameters != null) {
                    Object parameter = parameters[paramIndex];
                    name = (String)getName.invoke(parameter, new Object[0]);
                }
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "jdk doesn't support getParameters method", e);
            }
        }
        return name;
    }

    private static void buildMethodApi(MethodDefinition md, MethodApi methodApi) {
        md.setMethodController(methodApi.getMethodController());
        List<String> requestMethods = methodApi.getRequestMethods();
        if (requestMethods.size() == 0) {
            requestMethods.add("ALL");
        }
        md.setRequestMethods(requestMethods);
        md.setPaths(methodApi.getPaths());
        md.setNameDetail(methodApi.getMethodDescription());
        md.setParameterDetails(methodApi.getParameterDescriptions());
    }

    private ServiceDefinitionBuilder() {
    }

    static {
        methodApiMap = Collections.emptyMap();
        try {
            getParameters = Method.class.getMethod("getParameters", new Class[0]);
            getName = Class.forName("java.lang.reflect.Parameter").getMethod("getName", new Class[0]);
        }
        catch (Throwable t) {
            LOGGER.log(Level.WARNING, "jdk doesn't support getParameters method", t);
        }
    }
}

