/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.readiness.spring;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class SpringLaunchRecorder {
    private static final AliyunJavaAgentLogger logger = AliyunJavaAgentLoggerFactory.getLogger(SpringLaunchRecorder.class.getName());
    public static AtomicInteger CURRENT_REFRESHING_CONTEXT_COUNT = new AtomicInteger(0);
    private static final int MAX_RECORD_SIZE = 10000;
    private static final ConcurrentMap<String, Record> userSpringLaunchRecord = new ConcurrentHashMap<String, Record>();

    public static void recordEvent(boolean success, String name, Throwable t) {
        logger.warn("[STARTUP_ONLINE_RECORD] record event: {}, status:{}, throwable: {}", name, success, t);
        if (userSpringLaunchRecord.size() > 10000) {
            logger.error("[BUG-DETECTED] too many event recorded! record failure: {}", (Object)name);
            return;
        }
        Record exist = userSpringLaunchRecord.put(name, new Record(success, name, System.currentTimeMillis(), t));
        if (exist != null) {
            logger.warn("existing repeat progress: {}", (Object)name);
        }
    }

    public static boolean hasFailure() {
        for (String event : userSpringLaunchRecord.keySet()) {
            Record record = (Record)userSpringLaunchRecord.get(event);
            if (record.isSuccess()) continue;
            String cause = record.getThrowable() == null ? "unknown" : record.getThrowable().getMessage();
            logger.error("[STARTUP_ONLINE][SPRING] existing failure in spring context. msg: {}, cause: {}", (Object)record.getMsg(), (Object)cause);
            return true;
        }
        return false;
    }

    public static boolean hasRefreshed() {
        if (!SpringLaunchRecorder.existEventNamed("ContextRefreshed")) {
            boolean existFailure = SpringLaunchRecorder.existEventNamed("SpringContextRefreshFailed");
            if (existFailure) {
                logger.error("[STARTUP_ONLINE][SPRING] existing runtime exception while refreshing, spring context refresh failed");
                return false;
            }
            logger.warn("[STARTUP_ONLINE][SPRING] No Spring context refreshed yet");
            return false;
        }
        int curRefreshingCtxCount = CURRENT_REFRESHING_CONTEXT_COUNT.get();
        if (curRefreshingCtxCount > 0) {
            logger.warn("[STARTUP_ONLINE][SPRING] Still {} context(s) refreshing...", (Object)curRefreshingCtxCount);
            return false;
        }
        if (curRefreshingCtxCount < 0) {
            logger.error("[BUG-DETECTED] context fresh num cannot be minus: {}", (Object)curRefreshingCtxCount);
        }
        return true;
    }

    public static long getLastContextRefreshTimeOrNow() {
        Record record = (Record)userSpringLaunchRecord.get("ContextRefreshed");
        if (record == null) {
            return System.currentTimeMillis();
        }
        return record.getTimestamp();
    }

    public static boolean detectSpring() {
        boolean existSpringContextRefresh = SpringLaunchRecorder.existEventNamed("ExistContext");
        return existSpringContextRefresh;
    }

    public static boolean existEventNamed(String namePrefix) {
        for (String eventName : userSpringLaunchRecord.keySet()) {
            if (!eventName.startsWith(namePrefix)) continue;
            return true;
        }
        return false;
    }

    public static class Record {
        private String msg;
        private boolean success;
        private long timestamp;
        private Throwable throwable;

        public Record(boolean success, String msg) {
            this(success, msg, System.currentTimeMillis(), null);
        }

        public Record(boolean success, String msg, long timestamp, Throwable throwable) {
            this.msg = msg;
            this.success = success;
            this.timestamp = timestamp;
            this.throwable = throwable;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }
    }

    public static class EventName {
        public static final String EXIST_CONTEXT = "ExistContext";
        public static final String CONTEXT_REFRESHED = "ContextRefreshed";
        public static final String REFRESH_FAILED = "SpringContextRefreshFailed";
    }
}

