/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.readiness.msegov;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.AgentRegisterStatusEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.DegradeCenter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MicroServiceConfig;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MseConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.event.EventTypeEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.event.MicroServiceEvent;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.event.MseEventUploader;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.LossLessRule;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.LosslessOnlineEvent;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.LosslessRuleConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.ShutDownContext;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.StartupContext;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.readiness.ReadinessCondition;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.AppInfoUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.NetworkUtils;
import java.util.concurrent.atomic.AtomicBoolean;

public class MseReadiness
extends ReadinessCondition {
    private static final AliyunJavaAgentLogger logger = AliyunJavaAgentLoggerFactory.getLogger(MseReadiness.class.getName());
    public static volatile Long firstCheckTime = null;
    private static final Long registerMaxWaitTime = MicroServiceConfig.getRegisterMaxWaitTime();
    private static final boolean isRegisterMaxWaitEnable = MicroServiceConfig.isRegisterMaxWaitEnable();
    private static volatile boolean sendReadinessEvent = false;
    private static final Long warmupMaxWaitTime = MicroServiceConfig.getWarmupMaxWaitTime();
    private static final boolean isWarmupMaxWaitEnable = MicroServiceConfig.isWarmupMaxWaitEnable();
    private static volatile Long finalWaitStartBeforeAssignWt = null;
    public static volatile AtomicBoolean readinessLogicHasPass = new AtomicBoolean(false);

    public MseReadiness(int order) {
        super(order);
    }

    @Override
    public String name() {
        return "MSE_READINESS";
    }

    @Override
    public boolean ready() {
        if (readinessLogicHasPass.get() && !StartupContext.hasRegistered.equals((Object)AgentRegisterStatusEnum.OFFLINE)) {
            logger.warn("[STARTUP_ONLINE][MSE_READINESS] readinessLogicHasPass.");
            return true;
        }
        boolean readinessResult = this.readinessLogic();
        if (readinessResult && !StartupContext.hasRegistered.equals((Object)AgentRegisterStatusEnum.OFFLINE)) {
            logger.warn("[STARTUP_ONLINE][MSE_READINESS] readinessLogicHasPass set true.");
            readinessLogicHasPass.set(true);
        }
        logger.warn("[STARTUP_ONLINE] readiness return " + readinessResult);
        return readinessResult;
    }

    public boolean readinessLogic() {
        Boolean enable;
        if (ShutDownContext.isShutDown()) {
            logger.warn("[STARTUP_ONLINE][MSE_READINESS] ShutDownContext.isShutDown is true. readiness check failed.");
            return false;
        }
        if (DegradeCenter.degradeServiceWarmup()) {
            return this.originalReadiness();
        }
        LossLessRule lossLessRule = LosslessRuleConstants.LOSS_LESS_RULE;
        Boolean bl = enable = lossLessRule != null ? lossLessRule.getEnable() : LosslessRuleConstants.CLOSE;
        if (LosslessRuleConstants.CLOSE.equals(enable)) {
            return this.originalReadiness();
        }
        if (lossLessRule.getRelated().booleanValue()) {
            return this.dealWarmedReadiness(lossLessRule);
        }
        if (lossLessRule.getAligned().booleanValue()) {
            return this.dealRegisteredReadiness(lossLessRule);
        }
        logger.warn("[STARTUP_ONLINE][MSE_READINESS] registeredReadiness and warmedReadiness are closed. Fallback to originalReadiness.");
        return this.originalReadiness();
    }

    public boolean dealRegisteredReadiness(LossLessRule lossLessRule) {
        boolean isReady = AgentRegisterStatusEnum.ONLINE.equals((Object)StartupContext.hasRegistered);
        if (!isReady) {
            if (firstCheckTime == null) {
                firstCheckTime = System.currentTimeMillis();
            }
            long waitTime = System.currentTimeMillis() - firstCheckTime;
            long maxWait = registerMaxWaitTime + lossLessRule.getDelayTime() * 1000L;
            if (isRegisterMaxWaitEnable && waitTime > maxWait) {
                logger.warn("[STARTUP_ONLINE][MSE_READINESS] RegisteredReadiness only and exceed maxWait time. return true");
                return true;
            }
            logger.warn("[STARTUP_ONLINE][MSE_READINESS] register not ready. return false.");
            return false;
        }
        logger.warn("[STARTUP_ONLINE][MSE_READINESS] register ready. return true.");
        this.sendReadinessEvent();
        return true;
    }

    public boolean dealWarmedReadiness(LossLessRule lossLessRule) {
        long warmupTime;
        long l = warmupTime = lossLessRule.getWarmupTime() != null ? lossLessRule.getWarmupTime() : 0L;
        if ((LosslessRuleConstants.startWarmupTime == null || System.currentTimeMillis() - LosslessRuleConstants.startWarmupTime < warmupTime * 1000L) && lossLessRule.getRelated().booleanValue()) {
            boolean hasNotWarmup;
            logger.warn("[STARTUP_ONLINE][MSE_READINESS] waiting for warmup.");
            if (LosslessRuleConstants.startWarmupTime == null && finalWaitStartBeforeAssignWt != null && System.currentTimeMillis() - finalWaitStartBeforeAssignWt > warmupMaxWaitTime) {
                LosslessRuleConstants.startWarmupTime = System.currentTimeMillis();
                logger.warn("[STARTUP_ONLINE][MSE_READINESS] exceed expected warmup time,set expected warmup start time to currentTime.");
                return false;
            }
            boolean bl = hasNotWarmup = isWarmupMaxWaitEnable && LosslessRuleConstants.startWarmupTime == null && finalWaitStartBeforeAssignWt == null;
            if (hasNotWarmup) {
                finalWaitStartBeforeAssignWt = System.currentTimeMillis() + lossLessRule.getDelayTime() * 1000L;
                logger.warn("[STARTUP_ONLINE]][MSE_READINESS] final wait started before assigning warmup start time automatically. finalWaitStartBeforeAssignWt set: {}", (Object)finalWaitStartBeforeAssignWt);
            }
            return false;
        }
        this.sendReadinessEvent();
        return true;
    }

    public boolean originalReadiness() {
        boolean noServiceRegisterAgain;
        if (StartupContext.exportedTimestamp == null) {
            logger.warn("[STARTUP_ONLINE][MSE_READINESS] exported timestamp is not detected.");
            if (System.currentTimeMillis() - StartupContext.getStartTime() < (long)MicroServiceConfig.getReadinessNoRegisterMaxWaitTime()) {
                logger.warn("[STARTUP_ONLINE][MSE_READINESS] wait time is less than NoRegisterMaxWaitTime.");
                return false;
            }
            logger.warn("[STARTUP_ONLINE][MSE_READINESS] wait time is more than NoRegisterMaxWaitTime.");
            this.sendReadinessEvent();
            return true;
        }
        boolean bl = noServiceRegisterAgain = System.currentTimeMillis() - StartupContext.exportedTimestamp > (long)MicroServiceConfig.getReadinessWaitTime();
        if (noServiceRegisterAgain) {
            this.sendReadinessEvent();
            logger.warn("[STARTUP_ONLINE][MSE_READINESS] no more service register. readiness passed.");
        }
        return noServiceRegisterAgain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendReadinessEvent() {
        if (sendReadinessEvent) return;
        Class<StartupContext> clazz = StartupContext.class;
        synchronized (StartupContext.class) {
            if (sendReadinessEvent) return;
            MseEventUploader mseEventUploader = GlobalInstanceHolder.getInstance(MseEventUploader.class);
            if (mseEventUploader == null) {
                logger.error("[BUG-DETECTED][STARTUP_ONLINE][MSE_READINESS] mseEventUploader is null.");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            LosslessOnlineEvent losslessOnlineEvent = new LosslessOnlineEvent(NetworkUtils.getHostIp(), AppInfoUtils.getPid());
            losslessOnlineEvent.setNamespace(MseConstants.mseNamespace);
            MicroServiceEvent event = new MicroServiceEvent(LosslessRuleConstants.APP_Framework, EventTypeEnum.ACTIVE_TRACE_Readiness_Finish, losslessOnlineEvent.toString());
            mseEventUploader.uploadEventAsync(event);
            sendReadinessEvent = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

