/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.readiness;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MicroServiceCommonUtil;

public abstract class ReadinessCondition
implements Comparable<ReadinessCondition> {
    private static final AliyunJavaAgentLogger LOGGER = AliyunJavaAgentLoggerFactory.getLogger(ReadinessCondition.class.getName());
    private boolean stopCheck;
    private final int checkOrder;

    public ReadinessCondition(int order) {
        this.checkOrder = order;
        this.stopCheck = this.initStopCheckFlag();
    }

    public final int order() {
        return this.checkOrder;
    }

    public abstract boolean ready();

    public abstract String name();

    public final boolean shouldStopCheck() {
        return this.stopCheck;
    }

    public final void setStopCheck(boolean stopCheck) {
        this.stopCheck = stopCheck;
    }

    private boolean initStopCheckFlag() {
        String simpleName = this.getClass().getSimpleName();
        String configKey = "profile_micro_service_readiness_check_skip_" + simpleName;
        try {
            String skipThisReadiness = MicroServiceCommonUtil.getSystemParameterWithoutDefaultValue(configKey);
            boolean stopCheck = Boolean.parseBoolean(skipThisReadiness);
            if (stopCheck) {
                LOGGER.warn("[STARTUP_ONLINE] skip {} readiness check because of the specified configuration.", (Object)simpleName);
            }
            return stopCheck;
        }
        catch (Exception e) {
            LOGGER.error("[STARTUP_ONLINE] skip {} error, reason: {}", (Object)simpleName, (Object)e.getMessage());
            return true;
        }
    }

    @Override
    public int compareTo(ReadinessCondition o) {
        return Integer.compare(this.order(), o.order());
    }
}

