/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.AgentInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.DegradeCenter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MicroServiceConfig;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.ShutDownContext;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.HttpGet;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.MicroServiceUtil;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;

public class SpringCloudGracefulShutdown {
    public static final AliyunJavaAgentLogger LOGGER = AliyunJavaAgentLoggerFactory.getLogger(SpringCloudGracefulShutdown.class.getName());
    public static ConcurrentHashMap<String, Long> remoteIpList = new ConcurrentHashMap();

    public static void addRemoteIp(String remoteIp) {
        if (!MicroServiceConfig.isSpringCloudOfflineNoticeEnable()) {
            return;
        }
        if (remoteIpList.size() >= MicroServiceConfig.getRemoteAddressSize()) {
            SpringCloudGracefulShutdown.cleanExpiredRemoteIp();
        }
        if (remoteIpList.size() >= MicroServiceConfig.getRemoteAddressSize()) {
            if (ThreadLocalRandom.current().nextInt(0, 100) < 5) {
                LOGGER.warn("SpringCloudGracefulShutdown.addRemoteIp fail, size:{}", (Object)remoteIpList.size());
            }
            return;
        }
        if (!remoteIpList.containsKey(remoteIp)) {
            LOGGER.warn("[SC_OFFLINE_POSITIVE_PROVIDER] add address to remoteAddressMap, remoteIp={}", (Object)remoteIp);
        }
        remoteIpList.put(remoteIp, System.currentTimeMillis());
    }

    public static String gracefulShutdown() {
        if (!MicroServiceConfig.isSpringCloudOfflineNoticeEnable()) {
            LOGGER.warn("[SC_OFFLINE_POSITIVE_PROVIDER] is SpringCloudOffline enabled : false");
            return "enable false";
        }
        LOGGER.warn("[SC_OFFLINE_POSITIVE_PROVIDER] start sc offline...");
        StringBuilder res = new StringBuilder();
        try {
            Enumeration<String> enumeration = remoteIpList.keys();
            while (enumeration.hasMoreElements()) {
                String url = enumeration.nextElement();
                Long timestamp = remoteIpList.get(url);
                if (System.currentTimeMillis() - timestamp > 300000L) {
                    remoteIpList.remove(url);
                    continue;
                }
                String offlineCallUrl = SpringCloudGracefulShutdown.buildOfflineUrl(url);
                res.append(SpringCloudGracefulShutdown.goAway(offlineCallUrl));
                LOGGER.warn("[SC_OFFLINE_POSITIVE_PROVIDER] consumer url:{}", (Object)offlineCallUrl);
            }
        }
        catch (Exception e) {
            LOGGER.error("[SC_OFFLINE_POSITIVE_PROVIDER] offline with exception ", e);
        }
        return res.toString();
    }

    private static String buildOfflineUrl(String host) {
        String url = "http://" + host + ":55199/" + MicroServiceConfig.MICRO_SERVICE_QOS_COMMAND_HEALTH;
        url = url + "?action=offline";
        url = url + "&serverIp=" + MicroServiceUtil.getSpringCloudServerIp();
        url = url + "&serverPort=" + MicroServiceUtil.getSpringCloudServerPort();
        url = url + "&serverName=" + MicroServiceUtil.getSpringCloudServerName();
        try {
            url = url + "&providerAppId=" + URLEncoder.encode(AgentInfo.INSTANCE.getMseAppId(), "UTF-8");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return url;
    }

    private static String goAway(String url) {
        String result = HttpGet.httpGet(url, 500, 500, HttpGet.emptyHeader);
        return result;
    }

    private static boolean expired(long now, long value) {
        return now - value > (long)MicroServiceConfig.getRemoteAddressExpireTime();
    }

    public static void cleanExpiredRemoteIp() {
        long now = System.currentTimeMillis();
        Enumeration<String> enumeration = remoteIpList.keys();
        while (enumeration.hasMoreElements()) {
            Long value;
            String key = enumeration.nextElement();
            if (key == null || (value = remoteIpList.get(key)) == null || !SpringCloudGracefulShutdown.expired(now, value)) continue;
            remoteIpList.remove(key);
        }
    }

    public static boolean isOffline(String shutdownEndpoint) {
        if (DegradeCenter.degradeMSE()) {
            return false;
        }
        for (String endpoint : ShutDownContext.shutDownServerMap.keySet()) {
            Long timestamp = (Long)ShutDownContext.shutDownServerMap.get(endpoint);
            if (timestamp != null && System.currentTimeMillis() - timestamp > (long)MicroServiceConfig.getRemoteAddressExpireTime()) {
                ShutDownContext.shutDownServerMap.remove(endpoint);
                LOGGER.warn("[SC_OFFLINE] remove server [{}] from shutdownServerMap due to timeout. The timestamp of which is {}.", (Object)endpoint, (Object)timestamp);
            }
            if (!endpoint.equals(shutdownEndpoint)) continue;
            return true;
        }
        return false;
    }
}

