/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MicroServiceConfig;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;

public class ShutdownRemoteAddressCollector {
    private static final AliyunJavaAgentLogger LOGGER = AliyunJavaAgentLoggerFactory.getLogger(ShutdownRemoteAddressCollector.class.getName());
    private static final ConcurrentHashMap<String, Long> remoteAddressMap = new ConcurrentHashMap();

    public static void addRemoteAddress(String address) {
        if (remoteAddressMap.size() >= MicroServiceConfig.getRemoteAddressSize()) {
            ShutdownRemoteAddressCollector.cleanRemoteAddressMap();
        }
        if (remoteAddressMap.size() >= MicroServiceConfig.getRemoteAddressSize()) {
            if (ThreadLocalRandom.current().nextInt(0, 100) < 5) {
                LOGGER.warn("add address to remoteAddressMap fail, size:{}", (Object)remoteAddressMap.size());
            }
            return;
        }
        remoteAddressMap.put(address, System.currentTimeMillis());
    }

    private static void cleanRemoteAddressMap() {
        long now = System.currentTimeMillis();
        Enumeration<String> enumeration = remoteAddressMap.keys();
        while (enumeration.hasMoreElements()) {
            Long value;
            String key = enumeration.nextElement();
            if (key == null || (value = remoteAddressMap.get(key)) == null || !ShutdownRemoteAddressCollector.expired(now, value)) continue;
            remoteAddressMap.remove(key);
        }
    }

    private static boolean expired(long now, long value) {
        return now - value > (long)MicroServiceConfig.getRemoteAddressExpireTime();
    }
}

