/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.event;

import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.event.EventTypeEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.event.MicroServiceEventExtraInfo;

public class MicroServiceEvent {
    private long timestamp;
    private String framework;
    private EventTypeEnum type;
    private String extraInfo;

    public MicroServiceEvent(String framework, EventTypeEnum type, MicroServiceEventExtraInfo extraInfo) {
        this(System.currentTimeMillis(), framework, type, extraInfo);
    }

    public MicroServiceEvent(long timestamp, String framework, EventTypeEnum type, MicroServiceEventExtraInfo extraInfo) {
        this.timestamp = timestamp;
        this.framework = framework;
        this.type = type;
        this.extraInfo = extraInfo.toJson();
    }

    @Deprecated
    public MicroServiceEvent(String framework, EventTypeEnum type, String extraInfo) {
        this(System.currentTimeMillis(), framework, type, extraInfo);
    }

    @Deprecated
    public MicroServiceEvent(long timestamp, String framework, EventTypeEnum type, String extraInfo) {
        this.timestamp = timestamp;
        this.framework = framework;
        this.type = type;
        this.extraInfo = extraInfo;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getFramework() {
        return this.framework;
    }

    public EventTypeEnum getType() {
        return this.type;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setFramework(String framework) {
        this.framework = framework;
    }

    public void setType(EventTypeEnum type) {
        this.type = type;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MicroServiceEvent)) {
            return false;
        }
        MicroServiceEvent other = (MicroServiceEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$framework = this.getFramework();
        String other$framework = other.getFramework();
        if (this$framework == null ? other$framework != null : !this$framework.equals(other$framework)) {
            return false;
        }
        EventTypeEnum this$type = this.getType();
        EventTypeEnum other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$extraInfo = this.getExtraInfo();
        String other$extraInfo = other.getExtraInfo();
        return !(this$extraInfo == null ? other$extraInfo != null : !this$extraInfo.equals(other$extraInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MicroServiceEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $framework = this.getFramework();
        result = result * 59 + ($framework == null ? 43 : $framework.hashCode());
        EventTypeEnum $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $extraInfo = this.getExtraInfo();
        result = result * 59 + ($extraInfo == null ? 43 : $extraInfo.hashCode());
        return result;
    }

    public String toString() {
        return "MicroServiceEvent(timestamp=" + this.getTimestamp() + ", framework=" + this.getFramework() + ", type=" + (Object)((Object)this.getType()) + ", extraInfo=" + this.getExtraInfo() + ")";
    }
}

