/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.common;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CommonConstants {
    private static final ConcurrentMap<String, Long> SUBSCRIBE_APP_IDS = new ConcurrentHashMap<String, Long>();
    public static final String COMMON_DATA_ID = "micro.service.common.";

    public static String getCommonDataId(String appId) {
        return COMMON_DATA_ID + appId.replace("@", "-");
    }

    public static void addSubscribeAppId(String appId) {
        SUBSCRIBE_APP_IDS.putIfAbsent(appId, System.currentTimeMillis());
    }

    public static List<String> getAllSubscribeAppIds() {
        return new LinkedList<String>(SUBSCRIBE_APP_IDS.keySet());
    }

    public static Set<Map.Entry<String, Long>> getSubscribeAppEntrySet() {
        return SUBSCRIBE_APP_IDS.entrySet();
    }

    public static void removeSubscribeAppIds(String key) {
        SUBSCRIBE_APP_IDS.remove(key);
    }

    public static String getServiceId(String serviceName, String version, String group) {
        if (serviceName == null) {
            return null;
        }
        if (version == null) {
            version = "";
        }
        if (group == null) {
            group = "";
        }
        return serviceName + ":" + version + ":" + group;
    }
}

