/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.canary;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.canary.Tag;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.JSON;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CanaryUtil {
    private static final AliyunJavaAgentLogger logger = AliyunJavaAgentLoggerFactory.getLogger(CanaryUtil.class.getName());

    public static Set<Tag> parseTagsFromUserData(String userData) {
        try {
            if (!StringUtils.isEmpty(userData)) {
                String[] entries;
                for (String entry : entries = userData.split("&")) {
                    int index = entry.indexOf("=");
                    if (index <= -1 || !entry.substring(0, index).equals("__microservice_tag__")) continue;
                    return new HashSet<Tag>(CanaryUtil.parseTags(entry.substring(index + 1)));
                }
            }
            return new HashSet<Tag>();
        }
        catch (Throwable throwable) {
            return new HashSet<Tag>();
        }
    }

    public static List<Tag> parseTags(String jsonStr) {
        return JSON.parseArray(jsonStr, Tag.class);
    }
}

