/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.auth;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import java.lang.ref.SoftReference;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignatureUtil {
    private static final PatchLogger LOGGER = PatchLogger.getLogger(SignatureUtil.class.getName());
    private static final String METHOD = "HmacSHA256";
    private static Random random = new Random();
    private static volatile SoftReference<String> secretKeyCache = new SoftReference<Object>(null);
    private static ConcurrentMap<String, Mac> macInstanceMap = new ConcurrentHashMap<String, Mac>();

    public static String getRandomString(int length) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(62);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createSecretKey() {
        String s = secretKeyCache.get();
        if (s != null) {
            return s;
        }
        Class<SignatureUtil> clazz = SignatureUtil.class;
        synchronized (SignatureUtil.class) {
            s = secretKeyCache.get();
            if (s != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return s;
            }
            String randomString = SignatureUtil.getRandomString(32);
            secretKeyCache = new SoftReference<String>(randomString);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return randomString;
        }
    }

    public static String createSignature(String signatureBase, String secretKey) {
        if (StringUtils.isEmpty(secretKey)) {
            throw new IllegalArgumentException("Secret Key provided to HMAC SigningUtils was null or empty.");
        }
        try {
            return SignatureUtil.urlSafeEncode(SignatureUtil.hmac(signatureBase, secretKey));
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "[CreateSignature] error occurs", t);
            return "";
        }
    }

    static byte[] hmac(String signatureBase, String secretKey) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac hmac = null;
        try {
            hmac = SignatureUtil.getMacInstance(secretKey);
        }
        catch (CloneNotSupportedException e) {
            hmac = SignatureUtil.createMacInstance(secretKey);
        }
        return hmac.doFinal(signatureBase.getBytes());
    }

    private static Mac getMacInstance(String secretKey) throws CloneNotSupportedException {
        Mac macInstance = macInstanceMap.computeIfAbsent(secretKey, key -> {
            try {
                return SignatureUtil.createMacInstance(key);
            }
            catch (Throwable e) {
                throw new RuntimeException("fail create macInstance", e);
            }
        });
        return (Mac)macInstance.clone();
    }

    private static Mac createMacInstance(String secretKey) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac hmac = Mac.getInstance(METHOD);
        SecretKeySpec sk = new SecretKeySpec(secretKey.getBytes(), METHOD);
        hmac.init(sk);
        return hmac;
    }

    static String urlSafeEncode(byte[] bytes) {
        return Base64.getUrlEncoder().encodeToString(bytes).replaceAll("=", "");
    }

    static String urlUnSafeEncode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static boolean verifySignature(String signatureBase, String secretKey, String signature) {
        try {
            byte[] hmacBytes = SignatureUtil.hmac(signatureBase, secretKey);
            return StringUtils.equals(SignatureUtil.urlSafeEncode(hmacBytes), signature) || StringUtils.equals(SignatureUtil.urlUnSafeEncode(hmacBytes), signature);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "[VerifySignature] error occurs ", t);
            return false;
        }
    }
}

