/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.auth;

import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.auth.MseServiceAuth;
import java.util.ArrayList;
import java.util.List;

public class ServiceRule {
    private String serviceName = null;
    private boolean black = true;
    private boolean needAuth = true;
    private List<String> consumerAppIdList = new ArrayList<String>();
    private List<String> ipList = new ArrayList<String>();
    private List<MseServiceAuth.AuthConsumer> consumers = new ArrayList<MseServiceAuth.AuthConsumer>();

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setBlack(boolean black) {
        this.black = black;
    }

    public void setNeedAuth(boolean needAuth) {
        this.needAuth = needAuth;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isNeedAuth() {
        return this.needAuth;
    }

    public List<String> getIpList() {
        return this.ipList;
    }

    public List<String> getConsumerAppIdList() {
        return this.consumerAppIdList;
    }

    public void setConsumerAppIdList(List<String> consumerAppIdList) {
        this.consumerAppIdList = consumerAppIdList;
    }

    public boolean couldPass(String consumerAppId, String consumerMseGatewayId) {
        if (!this.black) {
            return this.containConsumerId(consumerAppId, consumerMseGatewayId);
        }
        return !this.containConsumerId(consumerAppId, consumerMseGatewayId);
    }

    private boolean containConsumerId(String consumerAppId, String consumerMseGatewayId) {
        MseServiceAuth.AuthConsumer appConsumer = this.getConsumerByType("app");
        if (appConsumer != null && appConsumer.getAppIds().contains(consumerAppId)) {
            return true;
        }
        MseServiceAuth.AuthConsumer mseGatewayConsumer = this.getConsumerByType("mseGateway");
        if (mseGatewayConsumer != null && mseGatewayConsumer.getMseGatewayIds().contains(consumerMseGatewayId)) {
            return true;
        }
        return this.containConsumerType("any");
    }

    public boolean couldPass(String consumerAppId) {
        if (!this.black) {
            return this.consumerAppIdList.contains(consumerAppId);
        }
        return !this.consumerAppIdList.contains(consumerAppId);
    }

    public List<MseServiceAuth.AuthConsumer> getConsumers() {
        return this.consumers;
    }

    public void setConsumers(List<MseServiceAuth.AuthConsumer> consumers) {
        this.consumers = consumers;
    }

    public boolean isPublicAccess() {
        return !this.black && this.containConsumerType("any");
    }

    private boolean containConsumerType(String consumerType) {
        for (MseServiceAuth.AuthConsumer consumer : this.consumers) {
            if (!consumerType.equals(consumer.getConsumerType())) continue;
            return true;
        }
        return false;
    }

    private MseServiceAuth.AuthConsumer getConsumerByType(String consumerType) {
        for (MseServiceAuth.AuthConsumer consumer : this.consumers) {
            if (!consumerType.equals(consumer.getConsumerType())) continue;
            return consumer;
        }
        return null;
    }

    public String toString() {
        return "ServiceRule{serviceName='" + this.serviceName + '\'' + ", black=" + this.black + ", needAuth=" + this.needAuth + ", consumerAppIdList=" + this.consumerAppIdList + ", ipList=" + this.ipList + ", consumers=" + this.consumers + '}';
    }
}

