/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils.ArmsCommonUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.AppTypeUtil;
import java.lang.instrument.Instrumentation;

public final class MseConstants {
    private static final AliyunJavaAgentLogger log = AliyunJavaAgentLoggerFactory.getLogger(MseConstants.class.getName());
    public static String agentDir = "/tmp/";
    public static boolean isServerIpSet = false;
    public static int callStackMaxLength = 128;
    public static int callSQLMaxLength = 1024;
    public static String agentEnv = "DEFAULT";
    public static String agentCustomArgs = "";
    public static String clusterId = "";
    public static String clusterName = "";
    public static String podAppVersion = "";
    public static String hostTags = "";
    public static String hostVersionTags = "";
    public static String hostEnvTags = "";
    public static String podNamespace = "";
    public static String podWorkloadName = "";
    public static String podWorkloadKind = "";
    public static int paramMaxLength = 512;
    public static int eachParamMaxLength = 256;
    public static boolean isFcScenario = false;
    public static boolean enableStackCompress = true;
    public static String userId = "";
    public static String regionId = "";
    public static String licenseKey;
    public static String mseNamespace;
    public static String mseAppName;
    public static String appId;
    public static String mscAppNameInNacos;
    public static final String mseDebugHost;
    public static String mode;
    public static long agentStartTimestamp;
    public static long agentStartCostMills;
    public static boolean appSecDisable;
    public static boolean appSecEnable;
    public static Instrumentation instrumentation;
    public static String collectorEndpoint;
    public static String armsCurrentDev;
    public static int trafficTagsKeyLimit;
    public static int trafficTagsValueLimit;
    public static String tenantId;
    public static String SENTINEL_GROUP_ID;

    private static void initialize() {
        MseConstants.setEDASSystemProperties();
        MseConstants.setOneAgentProperty();
        MseConstants.setMseConstants();
    }

    private static void setEDASSystemProperties() {
        String mseSysProperties = null;
        try {
            mseSysProperties = System.getenv("MSE_AGENT_PROPERTY");
            if (mseSysProperties != null && !mseSysProperties.trim().equals("")) {
                String result = MseConstants.parseAndSetSystemProperties(mseSysProperties);
                log.info("Set MSE system property success: {}", (Object)result);
            }
        }
        catch (Exception e) {
            log.warn("Failed to parse MSE MSE_AGENT_OPTS ENV {}: {}", (Object)mseSysProperties, (Object)e.getMessage());
            return;
        }
        String edasSysProperties = null;
        try {
            edasSysProperties = System.getenv("EDAS_CATALINA_OPTS");
            if (edasSysProperties != null && !edasSysProperties.trim().equals("")) {
                String result = MseConstants.parseAndSetSystemProperties(edasSysProperties);
                log.info("Set EDAS system property success: {}", (Object)result);
            }
        }
        catch (Exception e) {
            log.warn("Failed to parse EDAS EDAS_CATALINA_OPTS ENV {}:{}", (Object)edasSysProperties, (Object)e.getMessage());
        }
    }

    private static void setOneAgentProperty() {
        String oneAgentProperty = null;
        try {
            oneAgentProperty = System.getenv("ONE_AGENT_PROPERTY");
            if (oneAgentProperty != null) {
                String result = MseConstants.parseAndSetSystemProperties(oneAgentProperty);
                log.info("Set ONE_AGENT_PROPERTY success: {}", (Object)result);
            }
        }
        catch (Exception e) {
            log.warn("Failed to parse ONE_AGENT_PROPERTY ENV {}:{}", (Object)oneAgentProperty, (Object)e.getMessage());
        }
    }

    private static String parseAndSetSystemProperties(String propertyString) {
        if (propertyString == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String[] allSysPropertiesKV = propertyString.split(" ");
        for (int i = 0; i < allSysPropertiesKV.length; ++i) {
            String mseSysPropertiesKVStr;
            String[] mseSysPropertiesKV;
            String propertyKV = allSysPropertiesKV[i].trim();
            if (!propertyKV.startsWith("-D") || (mseSysPropertiesKV = (mseSysPropertiesKVStr = propertyKV.substring(2)).split("=", 2)).length <= 1) continue;
            sb.append(mseSysPropertiesKV[0] + "=" + mseSysPropertiesKV[1] + "~");
            System.setProperty(mseSysPropertiesKV[0], mseSysPropertiesKV[1]);
        }
        return sb.toString();
    }

    private static void setMseConstants() {
        regionId = ConfigPropertiesUtil.getString("mse.regionId");
        if (regionId == null || regionId.isEmpty()) {
            regionId = ConfigPropertiesUtil.getString("aliyun.javaagent.regionId");
        }
        if (StringUtils.isEmpty(licenseKey = ConfigPropertiesUtil.getString("mse.licenseKey"))) {
            licenseKey = ConfigPropertiesUtil.getString("msc.licenseKey");
        }
        userId = ArmsCommonUtils.getUserId(licenseKey);
        mseNamespace = ConfigPropertiesUtil.getString("mse.namespace");
        mseAppName = ConfigPropertiesUtil.getString("mse.appName");
        if (StringUtils.isEmpty(mseAppName)) {
            mseAppName = ConfigPropertiesUtil.getString("msc.appName");
        }
        if (StringUtils.isEmpty(appId = ConfigPropertiesUtil.getString("mse.appId"))) {
            appId = ArmsCommonUtils.generateAppId(userId, mseNamespace, mseAppName);
        }
        if (AppTypeUtil.isEdasApp()) {
            MseConstants.overrideMseConstantsByEdas();
        }
        SENTINEL_GROUP_ID = "ahas-sentinel-" + regionId;
        String env = System.getProperty("mse.env");
        SENTINEL_GROUP_ID = env != null ? SENTINEL_GROUP_ID + "-" + env : SENTINEL_GROUP_ID + "-online";
    }

    private static void overrideMseConstantsByEdas() {
        appId = ConfigPropertiesUtil.getString("project.name");
        regionId = ConfigPropertiesUtil.getString("aliyun.javaagent.regionId");
        tenantId = licenseKey = ConfigPropertiesUtil.getString("tenant.id");
        String licenseKey = ConfigPropertiesUtil.getString("arms.licenseKey");
        userId = ArmsCommonUtils.getUserId(licenseKey);
    }

    static {
        regionId = System.getProperty("mse.regionId");
        if (regionId == null || regionId.isEmpty()) {
            regionId = System.getenv("MSE_REGION_ID");
        }
        if (regionId == null || regionId.isEmpty()) {
            regionId = System.getenv("SAE_INSTANCE_REGION_ID");
        }
        if (regionId == null || regionId.isEmpty()) {
            regionId = System.getenv("SAE_REGION");
        }
        if (regionId == null || regionId.isEmpty()) {
            regionId = ConfigPropertiesUtil.getString("aliyun.javaagent.regionId");
        }
        licenseKey = "";
        mseNamespace = "";
        mseAppName = "";
        appId = "";
        mscAppNameInNacos = "";
        mseDebugHost = System.getenv("MSE_DEBUG_HOST");
        mode = "";
        appSecDisable = false;
        appSecEnable = false;
        collectorEndpoint = null;
        armsCurrentDev = null;
        trafficTagsKeyLimit = 5;
        trafficTagsValueLimit = 10;
        tenantId = "";
        MseConstants.initialize();
    }

    public static class Key {
        public static final String COMMON_REGION_ID = "aliyun.javaagent.regionId";
        public static final String MSE_LICENSE_KEY = "mse.licenseKey";
        public static final String MSC_LICENSE_KEY = "msc.licenseKey";
        public static final String MSE_REGION_ID = "mse.regionId";
        public static final String MSE_REGION_ENV_KEY = "MSE_REGION_ID";
        public static final String MSE_APP_ID = "mse.appId";
        public static final String MSE_APP_NAME = "mse.appName";
        public static final String MSC_APP_NAME = "msc.appName";
        public static final String MSE_NAMESPACE = "mse.namespace";
        public static final int APPLICATION_NAME_MAX_LEN = 24;
        public static final int AGENT_NAME_MAX_LEN = 24;
        public static final String EDAS_TENANT_ID = "tenant.id";
        public static final String EDAS_PROJECT_NAME = "project.name";
        public static final String EDAS_REGION_ID_KEY = "aliyun.javaagent.regionId";
        public static final String LICENSEKEY_NAME = "licenseKey";
        public static final String APPID_NAME = "appId";
        public static final String PACKET_TYPE_NAME = "packetType";
        public static final String SPAN_SERVICE = "/api/v1/arms/spans";
        public static final String METRIC_SERVICE = "/collector/report";
        public static final String META_SERVICE = "/api/v1/arms/metadata";
        public static final String AGENT_MODE_EDAS = "EDAS";
        public static final String AGENT_MODE_MSC = "MSC";
        public static final String AGENT_MODE_ARMS = "ARMS";
        public static final String AGENT_MODE_ARMS_MSC = "ARMS&MSC";
        public static final String AGENT_MODE_EDASMSC = "edasmsc";
        public static final String AGENT_MODE_FC = "FC";
        public static final String AGENT_MODE_SAE = "Serverless";
        public static final String EDAS_SCG_MODULE_NAME = "edas-scg";
        public static final String EDAS_SCG_ACCESS_LOGGER = "EdasScgAccessLogger";
    }
}

