/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.ArmsJvmVersion;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils.JvmUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.jsr166.ConcurrentReferenceHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class ClassLoadUtils {
    private static final PatchLogger LOGGER = PatchLogger.getLogger(ClassLoadUtils.class.getName());
    private static final int MAX_CACHE_SIZE = 100;
    private static ConcurrentHashMap<String, Class> clazzCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class, ConcurrentHashMap<String, Method>> methodCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class, ConcurrentHashMap<String, Field>> fieldCache = new ConcurrentHashMap();
    private static final Map<Class<?>, Field[]> declaredFieldsCache = new ConcurrentReferenceHashMap(256);
    private static final Field[] NO_FIELDS = new Field[0];
    private static Field modifiersField = null;

    public static Method findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Throwable throwable = null;
        while (clazz != null) {
            try {
                ConcurrentHashMap<String, Method> old;
                ConcurrentHashMap<String, Method> methodMap = methodCache.get(clazz);
                if (methodMap == null && (old = methodCache.putIfAbsent(clazz, methodMap = new ConcurrentHashMap())) != null) {
                    methodMap = old;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(methodName).append(";");
                for (Class<?> parameterType : parameterTypes) {
                    sb.append(parameterType.getName()).append(":");
                }
                Method method = methodMap.get(sb.toString());
                if (method == null) {
                    method = clazz.getDeclaredMethod(methodName, parameterTypes);
                    Method old2 = methodMap.putIfAbsent(sb.toString(), method);
                    if (old2 != null) {
                        return old2;
                    }
                }
                return method;
            }
            catch (Throwable th) {
                throwable = th;
                clazz = clazz.getSuperclass();
            }
        }
        if (throwable != null) {
            LOGGER.log(Level.SEVERE, "class " + clazz + " has no such method " + methodName + " with parameterTypes: " + parameterTypes + " error:" + throwable.getMessage());
        }
        return null;
    }

    public static Method getMethodIncludeAncestor(Class clz, String methodName, Class<?> ... parameterTypes) {
        Class<?>[] interfaceClasses;
        if (clz == null) {
            return null;
        }
        Method result = ClassLoadUtils.getMethod(clz, methodName, parameterTypes);
        if (result != null) {
            return result;
        }
        result = ClassLoadUtils.getMethodIncludeAncestor(clz.getSuperclass(), methodName, parameterTypes);
        if (result != null) {
            return result;
        }
        for (Class<?> item : interfaceClasses = clz.getInterfaces()) {
            result = ClassLoadUtils.getMethodIncludeAncestor(item, methodName, parameterTypes);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Method getMethod(Class clz, String methodName, Class<?> ... parameterTypes) {
        ConcurrentHashMap<String, Method> old;
        if (clz == null) {
            return null;
        }
        ConcurrentHashMap<String, Method> methodMap = methodCache.get(clz);
        if (methodMap == null && (old = methodCache.putIfAbsent(clz, methodMap = new ConcurrentHashMap())) != null) {
            methodMap = old;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(methodName).append(";");
        for (Class<?> parameterType : parameterTypes) {
            sb.append(parameterType.getName()).append(":");
        }
        Method method = methodMap.get(sb.toString());
        if (method == null) {
            method = ClassLoadUtils.getDeclaredMethod(clz, methodName, parameterTypes);
            if (method == null) {
                return null;
            }
            Method old2 = methodMap.putIfAbsent(sb.toString(), method);
            if (old2 != null) {
                return old2;
            }
        }
        return method;
    }

    public static Method getDeclaredMethod(Class clz, String methodName, Class<?> ... parameterTypes) {
        Method[] declaredMethods;
        for (Method item : declaredMethods = clz.getDeclaredMethods()) {
            if (!methodName.equals(item.getName()) || !ClassLoadUtils.arrayContentsEq(parameterTypes, item.getParameterTypes())) continue;
            return item;
        }
        return null;
    }

    private static boolean arrayContentsEq(Object[] a1, Object[] a2) {
        if (a1 == null) {
            return a2 == null || a2.length == 0;
        }
        if (a2 == null) {
            return a1.length == 0;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static Field getField(Class clz, String fieldName) {
        if (clz == null) {
            return null;
        }
        try {
            Field field;
            ConcurrentHashMap<String, Field> fieldMap = fieldCache.get(clz);
            if (fieldMap == null) {
                fieldMap = new ConcurrentHashMap();
                if (fieldCache.size() > 100) {
                    LOGGER.log(Level.WARNING, "filed cache map class size has reach max size,{},{}", new Object[]{clz, fieldName});
                    return clz.getDeclaredField(fieldName);
                }
                ConcurrentHashMap<String, Field> old = fieldCache.putIfAbsent(clz, fieldMap);
                if (old != null) {
                    fieldMap = old;
                }
            }
            if ((field = fieldMap.get(fieldName)) == null) {
                field = clz.getDeclaredField(fieldName);
                if (fieldMap.size() > 100) {
                    LOGGER.log(Level.WARNING, "filed cache map field size has reach max size,{},{}", new Object[]{clz, fieldName});
                    return field;
                }
                Field old = fieldMap.putIfAbsent(fieldName, field);
                if (old != null) {
                    return old;
                }
            }
            return field;
        }
        catch (NoSuchFieldException e) {
            LOGGER.log(Level.SEVERE, "class " + clz + "no such field " + fieldName + " error:" + e.getMessage());
            return null;
        }
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            Class<?> old;
            String key = classLoader.getClass().getSimpleName() + ":" + className;
            Class<?> clz = clazzCache.get(key);
            if (clz == null && (old = clazzCache.putIfAbsent(key, clz = classLoader.loadClass(className))) != null) {
                return old;
            }
            return clz;
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "classLoader:" + classLoader.getClass().getSimpleName() + " class " + className + " not found error:" + e.getMessage());
            return null;
        }
    }

    public static Class loadClass(ClassLoader classLoader, Class cls) {
        if (cls == null) {
            return null;
        }
        return ClassLoadUtils.loadClass(classLoader, cls.getName());
    }

    public static Method getMethod(ClassLoader classLoader, String className, String methodName, Class<?> ... parameterTypes) {
        Class<?> clz = ClassLoadUtils.loadClass(classLoader, className);
        return ClassLoadUtils.getMethod(clz, methodName, parameterTypes);
    }

    public static Object invokeMethod(Method method, Object obj, Object ... args) {
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.SEVERE, "invoke method" + method + " error: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, "invoke method" + method + " error: " + e.getMessage());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "invoke method" + method + " error: " + e.getMessage());
        }
        return null;
    }

    public static void updateFinalModifierField(Field field) throws Exception {
        field.setAccessible(true);
        ArmsJvmVersion version = JvmUtils.getVersion();
        if (modifiersField == null) {
            if (version.onOrAfter(ArmsJvmVersion.JAVA_17)) {
                Field[] fields;
                Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                getDeclaredFields0.setAccessible(true);
                for (Field each : fields = (Field[])getDeclaredFields0.invoke(Field.class, false)) {
                    if (!"modifiers".equals(each.getName())) continue;
                    modifiersField = each;
                    break;
                }
            } else {
                modifiersField = Field.class.getDeclaredField("modifiers");
            }
        }
        modifiersField.setAccessible(true);
        int newModifiers = field.getModifiers();
        newModifiers &= 0xFFFFFFEF;
        newModifiers = (newModifiers | 1) & 0xFFFFFFFD & 0xFFFFFFFB;
        modifiersField.setInt(field, newModifiers);
    }

    public static Field findField(Class<?> clz, String fieldName) {
        if (clz == null) {
            return null;
        }
        try {
            Field field;
            ConcurrentHashMap<String, Field> fieldMap = fieldCache.get(clz);
            if (fieldMap == null) {
                fieldMap = new ConcurrentHashMap();
                if (fieldCache.size() > 100) {
                    LOGGER.log(Level.WARNING, "filed cache map class size has reach max size,{},{}", new Object[]{clz, fieldName});
                    return clz.getDeclaredField(fieldName);
                }
                ConcurrentHashMap<String, Field> old = fieldCache.putIfAbsent(clz, fieldMap);
                if (old != null) {
                    fieldMap = old;
                }
            }
            if ((field = fieldMap.get(fieldName)) == null) {
                field = ClassLoadUtils.findField0(clz, fieldName);
                if (fieldMap.size() > 100) {
                    LOGGER.log(Level.WARNING, "filed cache map field size has reach max size,{},{}", new Object[]{clz, fieldName});
                    return field;
                }
                Field old = fieldMap.putIfAbsent(fieldName, field);
                if (old != null) {
                    return old;
                }
            }
            return field;
        }
        catch (NoSuchFieldException e) {
            LOGGER.log(Level.WARNING, "class " + clz + "no such field " + fieldName + " error:" + e.getMessage());
            return null;
        }
    }

    public static Field findField(ClassLoader classLoader, String className, String methodName) {
        Class<?> clz = ClassLoadUtils.loadClass(classLoader, className);
        return ClassLoadUtils.findField(clz, methodName);
    }

    public static Object findField(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static void setField(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static Field findField0(Class<?> clazz, String name) {
        return ClassLoadUtils.findField0(clazz, name, null);
    }

    private static Field findField0(Class<?> clazz, String name, Class<?> type) {
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = ClassLoadUtils.getDeclaredFields(searchType)) {
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    private static Field[] getDeclaredFields(Class<?> clazz) {
        Field[] result = declaredFieldsCache.get(clazz);
        if (result == null) {
            result = clazz.getDeclaredFields();
            declaredFieldsCache.put(clazz, result.length == 0 ? NO_FIELDS : result);
        }
        return result;
    }

    public static boolean checkClass(Class<?> clazz, String className) {
        if (clazz == null) {
            return false;
        }
        if (className.equals(clazz.getName())) {
            return true;
        }
        return ClassLoadUtils.checkClass(clazz.getSuperclass(), className);
    }
}

