/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.metrics.threadpool;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.state.ArmsState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Callback;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.ConfigKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.DataId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Endpoint;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.GroupId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Namespace;
import io.opentelemetry.javaagent.shaded.instrumentation.api.metrics.threadpool.ThreadNamePatternExtractStrategy;

@Endpoint(value=ConfigEnum.ARMS_APP_CONFIG_ENDPOINT)
@DataId(value=ConfigEnum.ARMS_APP_CONFIG_DATA_ID)
@GroupId(value=ConfigEnum.ARMS_APP_CONFIG_GROUP_ID)
@Namespace(value=ConfigEnum.ARMS_APP_CONFIG_NAMESPACE)
public class ThreadPoolMonitorState
extends ArmsState {
    private static final ThreadPoolMonitorState INSTANCE = new ThreadPoolMonitorState();
    @ConfigKey(value="profiler.threadpoolmonitor.threshold", type=Integer.class)
    private volatile int monitoredThreadPoolThreshold = 1000;
    private volatile ThreadNamePatternExtractStrategy threadNamePatternExtractStrategy = ThreadNamePatternExtractStrategy.REPLACE_ALL_DIGITAL;
    @ConfigKey(value="profiler.threadpoolmonitor.threadNamePatternExtractStrategy", type=String.class)
    private volatile String threadNamePatternExtractStrategyStr = "REPLACE_ALL_DIGITAL";
    @ConfigKey(value="profiler.threadpoolmonitor.enable")
    private volatile boolean threadPoolMonitorEnable = true;
    @ConfigKey(value="profiler.threadpoolmonitor.threadPoolUsage.blacklist", type=String.class)
    private volatile String threadPoolUsageBlackList = "";
    @ConfigKey(value="profiler.threadpoolmonitor.threadNamePattern.blacklist", type=String.class)
    private volatile String threadNamePatternBlackList = "";
    private int registeredThreadCount = 0;
    private long lastScheduleTimestamp = -1L;

    private ThreadPoolMonitorState() {
        super.registerConfigInstance(this);
    }

    public static ThreadPoolMonitorState getInstance() {
        return INSTANCE;
    }

    @Override
    @Callback
    public void onConfigChange(String configInfo) {
        this.threadNamePatternExtractStrategy = ThreadNamePatternExtractStrategy.fromString(this.threadNamePatternExtractStrategyStr);
    }

    public boolean isThreadPoolMonitorEnable() {
        return this.threadPoolMonitorEnable && this.isArmsEnable();
    }

    public int getMonitoredThreadPoolThreshold() {
        return this.monitoredThreadPoolThreshold;
    }

    public void setRegisteredThreadCount(int registeredThreadCount) {
        this.registeredThreadCount = registeredThreadCount;
    }

    public boolean isInBlacklist(String poolUsage, String threadNamePattern) {
        return StringUtils.isNotEmpty(this.threadPoolUsageBlackList) && this.threadPoolUsageBlackList.contains(poolUsage) || StringUtils.isNotEmpty(this.threadNamePatternBlackList) && this.threadNamePatternBlackList.contains(threadNamePattern);
    }

    public void setThreadPoolUsageBlackList(String threadPoolUsageBlackList) {
        this.threadPoolUsageBlackList = threadPoolUsageBlackList;
    }

    public void setThreadNamePatternBlackList(String threadNamePatternBlackList) {
        this.threadNamePatternBlackList = threadNamePatternBlackList;
    }

    public void setThreadNamePatternExtractStrategyStr(String threadNamePatternExtractStrategyStr) {
        this.threadNamePatternExtractStrategyStr = threadNamePatternExtractStrategyStr;
    }

    public ThreadNamePatternExtractStrategy getThreadNamePatternExtractStrategy() {
        return this.threadNamePatternExtractStrategy;
    }

    public void updateLastScheduleTime() {
        this.lastScheduleTimestamp = System.currentTimeMillis();
    }
}

