/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.metrics.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.state.ArmsState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.ConfigKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.DataId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Endpoint;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.GroupId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Namespace;
import java.util.concurrent.atomic.AtomicInteger;

@Endpoint(value=ConfigEnum.ARMS_APP_CONFIG_ENDPOINT)
@DataId(value=ConfigEnum.ARMS_APP_CONFIG_DATA_ID)
@GroupId(value=ConfigEnum.ARMS_APP_CONFIG_GROUP_ID)
@Namespace(value=ConfigEnum.ARMS_APP_CONFIG_NAMESPACE)
public class ConnectionPoolMonitorState
extends ArmsState {
    private static final ConnectionPoolMonitorState INSTANCE = new ConnectionPoolMonitorState();
    @ConfigKey(value="profiler.threadpoolmonitor.enable", type=Boolean.class)
    private volatile boolean threadPoolMonitorEnable = true;
    private final AtomicInteger registeredConnectionPoolCount = new AtomicInteger(0);

    public static ConnectionPoolMonitorState getInstance() {
        return INSTANCE;
    }

    private ConnectionPoolMonitorState() {
        super.registerConfigInstance(this);
    }

    public boolean isThreadPoolMonitorEnable() {
        return this.threadPoolMonitorEnable && this.isArmsEnable();
    }

    public void increaseRegisteredConnectionPoolCount() {
        this.registeredConnectionPoolCount.incrementAndGet();
    }
}

