/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.usermethod;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.AbstractArmsState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsCommonServiceMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsUserMethodState;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.logging.Level;

public class ArmsUserMethodMetrics
extends ArmsCommonServiceMetrics
implements OperationListener {
    private static final ContextKey<ArmsUserMethodMetricsState> ARMS_USER_METHOD_METRICS_STATE = ContextKey.named("arms-user-method-metrics-state");
    private static final PatchLogger logger = PatchLogger.getLogger(ArmsUserMethodMetrics.class.getName());

    public static OperationMetrics get() {
        return ArmsUserMethodMetrics::new;
    }

    public ArmsUserMethodMetrics(Meter meter) {
        super(meter);
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(ARMS_USER_METHOD_METRICS_STATE, new ArmsUserMethodMetricsState(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        ArmsUserMethodMetricsState state = context.get(ARMS_USER_METHOD_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        ArmsUserMethodState userMethodState = ArmsUserMethodState.fromContextOrNull(context);
        if (userMethodState == null || StringUtils.isNullOrEmpty(userMethodState.getUserMethodRpcName())) {
            return;
        }
        Attributes allAttributes = endAttributes.toBuilder().putAll(state.startAttributes).build();
        this.onEnd0(context, state.startTimeNanos, endNanos, allAttributes);
    }

    static class ArmsUserMethodMetricsState
    extends AbstractArmsState {
        private final Attributes startAttributes;
        private final long startTimeNanos;

        public ArmsUserMethodMetricsState(Attributes startAttributes, long startTimeNanos) {
            this.startAttributes = startAttributes;
            this.startTimeNanos = startTimeNanos;
        }

        @Override
        public Attributes startAttributes() {
            return this.startAttributes;
        }

        @Override
        public long startTimeNanos() {
            return this.startTimeNanos;
        }
    }
}

