/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.url.internal;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.SanitizerUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsOTelConfigState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsRpcConfigState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.url.UrlAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.url.internal.UrlAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class InternalUrlAttributesExtractor<REQUEST> {
    private final UrlAttributesGetter<REQUEST> getter;
    private final Function<REQUEST, String> alternateSchemeProvider;
    private final boolean emitStableUrlAttributes;
    private final boolean emitOldHttpAttributes;

    public InternalUrlAttributesExtractor(UrlAttributesGetter<REQUEST> getter, Function<REQUEST, String> alternateSchemeProvider, boolean emitStableUrlAttributes, boolean emitOldHttpAttributes) {
        this.getter = getter;
        this.alternateSchemeProvider = alternateSchemeProvider;
        this.emitStableUrlAttributes = emitStableUrlAttributes;
        this.emitOldHttpAttributes = emitOldHttpAttributes;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        String urlPath;
        String urlQuery = this.getter.getUrlQuery(request);
        if (!StringUtils.isEmpty(urlQuery)) {
            String httpParams = InternalUrlAttributesExtractor.getHttpParams(urlQuery);
            String value = "";
            value = SanitizerUtils.sanitizerPvs(httpParams, "=");
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.HTTP_PARAMS, value);
        }
        if (StringUtils.isNotEmpty(urlPath = this.getter.getUrlPath(request))) {
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.HTTP_PATH, urlPath);
        }
        if (ArmsOTelConfigState.oTelConfigState.isoTelAttributeEnable()) {
            String urlScheme = this.getUrlScheme(request);
            if (this.emitStableUrlAttributes) {
                AttributesExtractorUtil.internalSet(attributes, UrlAttributes.URL_SCHEME, urlScheme);
                AttributesExtractorUtil.internalSet(attributes, UrlAttributes.URL_PATH, urlPath);
                AttributesExtractorUtil.internalSet(attributes, UrlAttributes.URL_QUERY, urlQuery);
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_SCHEME, urlScheme);
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_TARGET, InternalUrlAttributesExtractor.getTarget(urlPath, urlQuery));
            }
        }
    }

    private String getUrlScheme(REQUEST request) {
        String urlScheme = this.alternateSchemeProvider.apply(request);
        if (urlScheme == null) {
            urlScheme = this.getter.getUrlScheme(request);
        }
        return urlScheme;
    }

    @Nullable
    private static String getTarget(@Nullable String path, @Nullable String query) {
        if (path == null && query == null) {
            return null;
        }
        return (path == null ? "" : path) + (query == null || query.isEmpty() ? "" : "?" + query);
    }

    private static String getHttpParams(String query) {
        try {
            if (query.length() <= ArmsRpcConfigState.rpcConfigState.getParamMaxLength()) {
                return query;
            }
            return query.substring(0, ArmsRpcConfigState.rpcConfigState.getParamMaxLength() - 1);
        }
        catch (Throwable t) {
            return query;
        }
    }
}

