/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.scheduled;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.scheduled.JobAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import javax.annotation.Nullable;

public class JobAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final JobAttributesGetter<REQUEST, RESPONSE> getter;

    public static <REQUEST, RESPONSE> JobAttributesExtractor<REQUEST, RESPONSE> create(JobAttributesGetter<REQUEST, RESPONSE> getter) {
        return new JobAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    private JobAttributesExtractor(JobAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        if (!"UnknownJobId".equals(this.getter.getJobId(request))) {
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.JOB_ID_KEY, this.getter.getJobId(request));
        }
        if (!"UnknownGroupId".equals(this.getter.getJobGroupId(request))) {
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.GROUP_ID_ID_KEY, this.getter.getJobGroupId(request));
        }
        if (!"UnknownJobName".equals(this.getter.getJobName(request))) {
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.JOB_NAME_KEY, this.getter.getJobName(request));
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        if (!"UnknownSchedulerStatus".equals(this.getter.getResultStatus(request))) {
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.JOB_RESULT_STATUS_KEY, this.getter.getResultStatus(request));
        }
        if (!"UnknownRpcName".equals(this.getter.getRpc(request))) {
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.RPC, this.getter.getRpc(request));
        }
    }
}

