/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.scheduled;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.convergence.ConvergeService;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.UniCallKind;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.LocalRootSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.common.LocalRootSpanUpdater;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.scheduled.JobAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsScheduledRpcNameState;
import java.util.logging.Level;

public final class ArmsScheduledRpcNameHolder {
    private static final PatchLogger logger = PatchLogger.getLogger(ArmsScheduledRpcNameHolder.class.getName());

    public static <REQUEST> ContextCustomizer<REQUEST> create(JobAttributesGetter<REQUEST, ?> getter) {
        return (context, request, startAttributes) -> {
            try {
                if (ArmsScheduledRpcNameState.fromContextOrNull(context) != null) {
                    return context;
                }
                ConvergeService convergeService = GlobalInstanceHolder.getInstance(ConvergeService.class);
                String rpcName = getter.getRpc(request);
                if (convergeService != null) {
                    rpcName = convergeService.convergeRpc(UniCallKind.RPC, rpcName);
                }
                LocalRootSpanUpdater.updateSpanName(LocalRootSpan.fromContextOrNull(context), rpcName);
                return context.with(ArmsScheduledRpcNameState.create(rpcName));
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "Failed to customize scheduled context", t);
                return context;
            }
        };
    }

    private ArmsScheduledRpcNameHolder() {
    }
}

