/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.scheduled;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.AbstractArmsState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsCommonServiceMetrics;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.logging.Level;

public class ArmsScheduledMetrics
extends ArmsCommonServiceMetrics
implements OperationListener {
    private static final ContextKey<ArmsScheduledMetricsState> ARMS_SCHEDULED_METRICS_STATE = ContextKey.named("arms-scheduled-metrics-state");
    private static final PatchLogger logger = PatchLogger.getLogger(ArmsScheduledMetrics.class.getName());

    public static OperationMetrics get() {
        return ArmsScheduledMetrics::new;
    }

    public ArmsScheduledMetrics(Meter meter) {
        super(meter);
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(ARMS_SCHEDULED_METRICS_STATE, new ArmsScheduledMetricsState(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        ArmsScheduledMetricsState state = context.get(ARMS_SCHEDULED_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        Attributes allAttributes = endAttributes.toBuilder().putAll(state.startAttributes).build();
        this.onEnd0(context, state.startTimeNanos, endNanos, allAttributes);
    }

    static class ArmsScheduledMetricsState
    extends AbstractArmsState {
        private final Attributes startAttributes;
        private final long startTimeNanos;

        public ArmsScheduledMetricsState(Attributes startAttributes, long startTimeNanos) {
            this.startAttributes = startAttributes;
            this.startTimeNanos = startTimeNanos;
        }

        @Override
        public Attributes startAttributes() {
            return this.startAttributes;
        }

        @Override
        public long startTimeNanos() {
            return this.startTimeNanos;
        }
    }
}

