/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.rpc;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.state.ArmsState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.rpc.ArmsRpcMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.rpc.AutoValue_RpcServerMetrics_State;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.rpc.MetricsView;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class RpcServerMetrics
implements OperationListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<State> RPC_SERVER_REQUEST_METRICS_STATE = ContextKey.named("rpc-server-request-metrics-state");
    private static final PatchLogger logger = PatchLogger.getLogger(RpcServerMetrics.class.getName());
    private final DoubleHistogram serverDurationHistogram;

    private RpcServerMetrics(Meter meter) {
        this.serverDurationHistogram = meter.histogramBuilder("rpc.server.duration").setDescription("The duration of an inbound RPC invocation").setUnit("ms").build();
    }

    public static OperationMetrics get() {
        if (ArmsState.INSTANCE.isArmsEnable()) {
            return ArmsRpcMetrics::new;
        }
        return RpcServerMetrics::new;
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(RPC_SERVER_REQUEST_METRICS_STATE, new AutoValue_RpcServerMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        State state = context.get(RPC_SERVER_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record RPC request metrics.", context);
            return;
        }
        this.serverDurationHistogram.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_MS, MetricsView.applyServerView(state.startAttributes(), endAttributes), context);
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

